# Copyright (C) 2010-2011 Richard Lincoln
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to
# deal in the Software without restriction, including without limitation the
# rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
# sell copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
# IN THE SOFTWARE.

from CIM14.IEC61970.Wires.Conductor import Conductor

class DCLineSegment(Conductor):
    """A wire or combination of wires not insulated from one another, with consistent electrical characteristics, used to carry direct current between points in the DC region of the power system.
    """

    def __init__(self, dcSegmentInductance=0.0, dcSegmentResistance=0.0, *args, **kw_args):
        """Initialises a new 'DCLineSegment' instance.

        @param dcSegmentInductance: Inductance of the DC line segment. 
        @param dcSegmentResistance: Resistance of the DC line segment. 
        """
        #: Inductance of the DC line segment.
        self.dcSegmentInductance = dcSegmentInductance

        #: Resistance of the DC line segment.
        self.dcSegmentResistance = dcSegmentResistance

        super(DCLineSegment, self).__init__(*args, **kw_args)

    _attrs = ["dcSegmentInductance", "dcSegmentResistance"]
    _attr_types = {"dcSegmentInductance": float, "dcSegmentResistance": float}
    _defaults = {"dcSegmentInductance": 0.0, "dcSegmentResistance": 0.0}
    _enums = {}
    _refs = []
    _many_refs = []

