# Copyright (C) 2010-2011 Richard Lincoln
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to
# deal in the Software without restriction, including without limitation the
# rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
# sell copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
# IN THE SOFTWARE.

from CIM15.IEC61970.Core.IdentifiedObject import IdentifiedObject

class ErpReqLineItem(IdentifiedObject):
    """Information that describes a requested item and its attributes.Information that describes a requested item and its attributes.
    """

    def __init__(self, cost=0.0, quantity=0, deliveryDate='', code='', ErpQuoteLineItem=None, status=None, ErpRequisition=None, TypeMaterial=None, ErpPOLineItem=None, TypeAsset=None, *args, **kw_args):
        """Initialises a new 'ErpReqLineItem' instance.

        @param cost: Cost of material 
        @param quantity: Quantity of item requisitioned. 
        @param deliveryDate: 
        @param code: 
        @param ErpQuoteLineItem:
        @param status:
        @param ErpRequisition:
        @param TypeMaterial:
        @param ErpPOLineItem:
        @param TypeAsset:
        """
        #: Cost of material
        self.cost = cost

        #: Quantity of item requisitioned.
        self.quantity = quantity


        self.deliveryDate = deliveryDate


        self.code = code

        self._ErpQuoteLineItem = None
        self.ErpQuoteLineItem = ErpQuoteLineItem

        self.status = status

        self._ErpRequisition = None
        self.ErpRequisition = ErpRequisition

        self._TypeMaterial = None
        self.TypeMaterial = TypeMaterial

        self._ErpPOLineItem = None
        self.ErpPOLineItem = ErpPOLineItem

        self._TypeAsset = None
        self.TypeAsset = TypeAsset

        super(ErpReqLineItem, self).__init__(*args, **kw_args)

    _attrs = ["cost", "quantity", "deliveryDate", "code"]
    _attr_types = {"cost": float, "quantity": int, "deliveryDate": str, "code": str}
    _defaults = {"cost": 0.0, "quantity": 0, "deliveryDate": '', "code": ''}
    _enums = {}
    _refs = ["ErpQuoteLineItem", "status", "ErpRequisition", "TypeMaterial", "ErpPOLineItem", "TypeAsset"]
    _many_refs = []

    def getErpQuoteLineItem(self):
        
        return self._ErpQuoteLineItem

    def setErpQuoteLineItem(self, value):
        if self._ErpQuoteLineItem is not None:
            self._ErpQuoteLineItem._ErpReqLineItem = None

        self._ErpQuoteLineItem = value
        if self._ErpQuoteLineItem is not None:
            self._ErpQuoteLineItem.ErpReqLineItem = None
            self._ErpQuoteLineItem._ErpReqLineItem = self

    ErpQuoteLineItem = property(getErpQuoteLineItem, setErpQuoteLineItem)

    status = None

    def getErpRequisition(self):
        
        return self._ErpRequisition

    def setErpRequisition(self, value):
        if self._ErpRequisition is not None:
            filtered = [x for x in self.ErpRequisition.ErpReqLineItems if x != self]
            self._ErpRequisition._ErpReqLineItems = filtered

        self._ErpRequisition = value
        if self._ErpRequisition is not None:
            if self not in self._ErpRequisition._ErpReqLineItems:
                self._ErpRequisition._ErpReqLineItems.append(self)

    ErpRequisition = property(getErpRequisition, setErpRequisition)

    def getTypeMaterial(self):
        
        return self._TypeMaterial

    def setTypeMaterial(self, value):
        if self._TypeMaterial is not None:
            filtered = [x for x in self.TypeMaterial.ErpReqLineItems if x != self]
            self._TypeMaterial._ErpReqLineItems = filtered

        self._TypeMaterial = value
        if self._TypeMaterial is not None:
            if self not in self._TypeMaterial._ErpReqLineItems:
                self._TypeMaterial._ErpReqLineItems.append(self)

    TypeMaterial = property(getTypeMaterial, setTypeMaterial)

    def getErpPOLineItem(self):
        
        return self._ErpPOLineItem

    def setErpPOLineItem(self, value):
        if self._ErpPOLineItem is not None:
            self._ErpPOLineItem._ErpReqLineItem = None

        self._ErpPOLineItem = value
        if self._ErpPOLineItem is not None:
            self._ErpPOLineItem.ErpReqLineItem = None
            self._ErpPOLineItem._ErpReqLineItem = self

    ErpPOLineItem = property(getErpPOLineItem, setErpPOLineItem)

    def getTypeAsset(self):
        
        return self._TypeAsset

    def setTypeAsset(self, value):
        if self._TypeAsset is not None:
            filtered = [x for x in self.TypeAsset.ErpReqLineItems if x != self]
            self._TypeAsset._ErpReqLineItems = filtered

        self._TypeAsset = value
        if self._TypeAsset is not None:
            if self not in self._TypeAsset._ErpReqLineItems:
                self._TypeAsset._ErpReqLineItems.append(self)

    TypeAsset = property(getTypeAsset, setTypeAsset)

