# flake8: noqa: E501
# no-cython-lint

import os
from unittest import mock

from ddtrace.ext.test_visibility import ITR_SKIPPING_LEVEL
from ddtrace.internal.ci_visibility._api_client import ITRData
from ddtrace.internal.utils.http import Response
from tests.ci_visibility.api_client._util import TestTestVisibilityAPIClientBase
from tests.ci_visibility.api_client._util import _make_fqdn_suite_ids
from tests.ci_visibility.api_client._util import _make_fqdn_test_ids


class TestTestVisibilityAPIClientSkippableRealWorldResponses(TestTestVisibilityAPIClientBase):
    """Tests that captured real-world skippable responses from the API client are parsed properly"""

    def test_civisibility_api_client_skippable_real_flask_scenario_suite_level(self):
        """Tests a once-captured real world response from a flask project in suite-skipping mode

        NOTE: this ignores coverage data for the sake of expediency.
        """
        with open(os.path.join(os.path.dirname(__file__), "real_world_skippable_response_flask_suite_level.json")) as f:
            skippable_response = f.read()

        expected_skippable_items = ITRData(
            correlation_id="fb9c5c7853a0d039dadb4c7ee0cb21bc",
            skippable_items=_make_fqdn_suite_ids(
                [
                    ("tests", "test_subclassing.py"),
                    ("tests", "test_blueprints.py"),
                    ("tests", "test_json_tag.py"),
                    ("tests", "test_json.py"),
                    ("tests", "test_reqctx.py"),
                    ("tests", "test_async.py"),
                    ("tests", "test_views.py"),
                    ("tests", "test_user_error_handler.py"),
                    ("tests", "test_helpers.py"),
                    ("tests", "test_cli.py"),
                    ("tests", "test_testing.py"),
                    ("tests", "test_templating.py"),
                    ("tests", "test_signals.py"),
                    ("tests", "test_session_interface.py"),
                    ("tests", "test_regression.py"),
                    ("tests", "test_logging.py"),
                    ("tests", "test_instance_config.py"),
                    ("tests", "test_converters.py"),
                    ("tests", "test_config.py"),
                    ("tests", "test_basic.py"),
                    ("tests", "test_appctx.py"),
                ]
            ),
        )
        client = self._get_test_client(itr_skipping_level=ITR_SKIPPING_LEVEL.SUITE)
        with mock.patch.object(client, "_do_request", return_value=Response(200, skippable_response)):
            actual_skippable_items = client.fetch_skippable_items()
            assert actual_skippable_items == expected_skippable_items

    def test_civisibility_api_client_skippable_real_flask_scenario_test_level_with_parameters(self):
        """Tests a once-captured real world response from a flask project in suite-skipping mode

        NOTE: this ignores coverage data for the sake of expediency.
        """
        with open(os.path.join(os.path.dirname(__file__), "real_world_skippable_response_flask_test_level.json")) as f:
            skippable_response = f.read()

        expected_skippable_items = ITRData(
            correlation_id="4e70ba1f19491bd7a08f17044b1cce28",
            covered_files={},
            skippable_items=_make_fqdn_test_ids(
                [
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_custom_tag",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 39, 37, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_json_bad_requests",
                        '{"arguments": {"debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_views.py",
                        "test_remove_method_from_parent",
                        '{"arguments": {"to_handle": "500"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_views.py",
                        "test_method_based_view",
                        '{"arguments": {"to_handle": "500"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_client_pop_all_preserved",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_full_url_request",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_session_transaction_needs_cookies",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_session_transactions",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_specify_url_scheme",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_client_open_environ",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_environ_defaults_from_config",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_custom_jinja_env",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_templates_auto_reload",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_test",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_filter_with_name_and_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_filter",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_request_less_rendering",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_simple_stream",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_context_processing",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_environ_for_valid_idna_completes",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_session_error_pops_context",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_context_binding",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_proper_test_request_context",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_teardown_with_handled_exception",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_logging.py",
                        "test_log_view_exception",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_json_customization",
                        '{"arguments": {"tz": "(\'KST\', 9)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_jsonify_aware_datetimes[tz1]",
                        '{"arguments": {"tz": "(\'PST\', -8)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_jsonify_datetime[value1]",
                        '{"arguments": {"value": "datetime.date(1975, 1, 5)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_jsonify_basic_types[s]",
                        '{"arguments": {"test_value": "\'s\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_jsonify_basic_types[3.14]",
                        '{"arguments": {"test_value": "3.14"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_jsonify_basic_types[0]",
                        '{"arguments": {"test_value": "0"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_json_custom_mimetypes",
                        '{"arguments": {"debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_bad_request_debug_message[False]",
                        '{"arguments": {"debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_instance_config.py",
                        "test_prefix_package_paths[False]",
                        '{"arguments": {"limit_loader": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_instance_config.py",
                        "test_installed_package_paths[False]",
                        '{"arguments": {"limit_loader": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_instance_config.py",
                        "test_installed_module_paths[False]",
                        '{"arguments": {"limit_loader": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_open_resource_with_encoding[utf-16-le]",
                        '{"arguments": {"encoding": "\'utf-16-le\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_open_resource_exceptions[r+]",
                        '{"arguments": {"mode": "\'r+\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_open_resource_exceptions[x]",
                        '{"arguments": {"mode": "\'x\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_make_response",
                        '{"arguments": {"debug": "\'True\'", "expect": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_abort_no_app",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_redirect_with_app",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_url_with_method",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_config.py",
                        "test_from_pyfile_weird_encoding[iso-8859-15]",
                        '{"arguments": {"encoding": "\'iso-8859-15\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_config.py",
                        "test_config_from_mapping",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_config.py",
                        "test_config_from_file_toml",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_config.py",
                        "test_config_from_object",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_disable_dotenv_from_env",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_all_methods",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_help_echo_exception",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_help_echo_loading_error",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_flaskgroup_nested",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_scriptinfo",
                        '{"arguments": {"iname": "\'cliapp.message.txt\'", "aname": "None"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        'test_locate_app[cliapp.factory-create_app2("foo", "bar", )-app2_foo_bar]',
                        '{"arguments": {"iname": "\'cliapp.factory\'", "aname": "\'create_app2(\\"foo\\", \\"bar\\", )\'", "result": "\'app2_foo_bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_locate_app[cliapp.factory-create_app()-app]",
                        '{"arguments": {"iname": "\'cliapp.factory\'", "aname": "\'create_app()\'", "result": "\'app\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_locate_app[cliapp.factory-None-app]",
                        '{"arguments": {"iname": "\'cliapp.factory\'", "aname": "None", "result": "\'app\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_locate_app[cliapp.app-None-testapp]",
                        '{"arguments": {"iname": "\'cliapp.app\'", "aname": "None", "result": "\'testapp\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_prepare_import[test.a.b-path7-test.a.b]",
                        '{"arguments": {"value": "\'test.a.b\'", "path": "PosixPath(\'/Users/romain.komorn/nondd/flask-shallow\')", "result": "\'test.a.b\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_prepare_import[value5-path5-cliapp.inner1]",
                        '{"arguments": {"value": "PosixPath(\'/Users/romain.komorn/nondd/flask-shallow/tests/test_apps/cliapp/inner1/__init__\')", "path": "PosixPath(\'/Users/romain.komorn/nondd/flask-shallow/tests/test_apps\')", "result": "\'cliapp.inner1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_prepare_import[test.py-path1-test]",
                        '{"arguments": {"value": "\'test.py\'", "path": "PosixPath(\'/Users/romain.komorn/nondd/flask-shallow\')", "result": "\'test\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_nesting_url_prefixes[/other-/something-/parent-/child]",
                        '{"arguments": {"parent_init": "\'/other\'", "child_init": "\'/something\'", "parent_registration": "\'/parent\'", "child_registration": "\'/child\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_add_template_test_with_name_and_template",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_template_test_after_route_with_template",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_template_test_with_template",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_add_template_test",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_template_filter_with_name",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_blueprint_prefix_slash[/foo/-//bar-/foo/bar]",
                        '{"arguments": {"prefix": "\'/foo/\'", "rule": "\'//bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_blueprint_prefix_slash[/foo/-bar-/foo/bar]",
                        '{"arguments": {"prefix": "\'/foo/\'", "rule": "\'bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_run_from_config[None-None-localhost:8080-localhost-8080]",
                        '{"arguments": {"host": "None", "port": "None", "server_name": "\'localhost:8080\'", "expect_host": "\'localhost\'", "expect_port": "8080"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_run_from_config[localhost-None-pocoo.org:8080-localhost-8080]",
                        '{"arguments": {"host": "\'localhost\'", "port": "None", "server_name": "\'pocoo.org:8080\'", "expect_host": "\'localhost\'", "expect_port": "8080"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_run_from_config[None-None-pocoo.org:8080-pocoo.org-8080]",
                        '{"arguments": {"host": "None", "port": "None", "server_name": "\'pocoo.org:8080\'", "expect_host": "\'pocoo.org\'", "expect_port": "8080"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_run_server_port",
                        '{"arguments": {"matching": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_subdomain_basic_support",
                        '{"arguments": {"propagate_exceptions": "False", "use_reloader": "False", "use_debugger": "False", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[False-False-False-True]",
                        '{"arguments": {"propagate_exceptions": "False", "use_reloader": "False", "use_debugger": "False", "debug": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[True-False-True-False]",
                        '{"arguments": {"propagate_exceptions": "True", "use_reloader": "False", "use_debugger": "True", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[True-False-True-True]",
                        '{"arguments": {"propagate_exceptions": "True", "use_reloader": "False", "use_debugger": "True", "debug": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[True-True-False-False]",
                        '{"arguments": {"propagate_exceptions": "True", "use_reloader": "True", "use_debugger": "False", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[None-True-False-False]",
                        '{"arguments": {"propagate_exceptions": "None", "use_reloader": "True", "use_debugger": "False", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_exception_propagation[None]",
                        '{"arguments": {"key": "None"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_server_name_subdomain",
                        '{"arguments": {"compact": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_static_folder_with_pathlib_path",
                        '{"arguments": {"compact": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_static_url_empty_path_default",
                        '{"arguments": {"compact": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_url_for_passes_special_values_to_build_error_handler",
                        '{"arguments": {"compact": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_build_error_handler_reraise",
                        '{"arguments": {"compact": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_url_generation",
                        '{"arguments": {"compact": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_jsonify_no_prettyprint[True]",
                        '{"arguments": {"compact": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_make_response_with_response_instance",
                        '{"arguments": {"debug": "False", "trap": "True", "expect_key": "False", "expect_abort": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_trap_bad_request_key_error[True-None-False-True]",
                        '{"arguments": {"debug": "True", "trap": "None", "expect_key": "False", "expect_abort": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_http_error_subclass_handling",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_error_handling_processing",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_teardown_request_handler_debug_mode",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_session_refresh_vary",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_missing_session",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_session_using_application_root",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_session_path",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_url_mapping",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_provide_automatic_options_kwarg",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_method_route[get]",
                        '{"arguments": {"method": "\'get\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_async.py",
                        "test_async_error_handler[/bp/error]",
                        '{"arguments": {"path": "\'/bp/error\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_async.py",
                        "test_async_route[/methodview]",
                        '{"arguments": {"path": "\'/methodview\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_user_error_handler.py",
                        "test_error_handler_no_match",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_nosubdomain",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_client_json_no_app_context",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_session_transaction_needs_cookies",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_session_transactions_keep_context",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_specify_url_scheme",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_environ_defaults",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_iterable_loader",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_test_with_name_and_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_test_with_name_and_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_filter",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_request_less_rendering",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_simple_stream",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_appcontext_tearing_down_signal",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_session_interface.py",
                        "test_open_session_with_endpoint",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_environ_for_valid_idna_completes",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_context_binding",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_teardown_with_previous_exception",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    ("tests", "test_helpers.py", "test_streaming_with_context_as_decorator"),
                    ("tests", "test_helpers.py", "test_redirect_with_app"),
                    ("tests", "test_helpers.py", "test_url_for_with_self"),
                    ("tests", "test_helpers.py", "test_url_for_with_scheme"),
                    ("tests", "test_helpers.py", "test_static_file"),
                    ("tests", "test_helpers.py", "test_send_file"),
                    ("tests", "test_converters.py", "test_context_available"),
                    (
                        "tests",
                        "test_user_error_handler.py",
                        "test_error_handler_subclass",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_client_pop_all_preserved",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_cli_invoke",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_nosubdomain",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_client_json_no_app_context",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_session_transactions_no_null_sessions",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_redirect_keep_session",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_blueprint_with_subdomain",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_environbuilder_json_dumps",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_specify_url_scheme",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_test_with_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_test",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_filter_with_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_escaping",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_appcontext_signals",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_before_render_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_normal_environ_completes",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_environ_for_valid_idna_completes",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_context_test",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_context_binding",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_logging.py",
                        "test_log_view_exception",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_logging.py",
                        "test_wsgi_errors_stream",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_tag_order",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_duplicate_tag",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    ("tests", "test_views.py", "test_view_provide_automatic_options_attr"),
                    ("tests", "test_user_error_handler.py", "test_handle_generic"),
                    ("tests", "test_testing.py", "test_reuse_client"),
                    ("tests", "test_testing.py", "test_session_transaction_needs_cookies"),
                    ("tests", "test_testing.py", "test_session_transactions_keep_context"),
                    ("tests", "test_testing.py", "test_client_open_environ"),
                    ("tests", "test_templating.py", "test_template_loader_debugging"),
                    ("tests", "test_templating.py", "test_templates_auto_reload"),
                    ("tests", "test_templating.py", "test_add_template_global"),
                    ("tests", "test_templating.py", "test_template_test_with_template"),
                    ("tests", "test_templating.py", "test_add_template_filter_with_name_and_template"),
                    ("tests", "test_templating.py", "test_template_filter_with_template"),
                    ("tests", "test_templating.py", "test_escaping_without_template_filename"),
                    ("tests", "test_templating.py", "test_context_processing"),
                    ("tests", "test_signals.py", "test_request_signals"),
                    ("tests", "test_reqctx.py", "test_teardown_with_handled_exception"),
                    ("tests", "test_logging.py", "test_wsgi_errors_stream"),
                    ("tests", "test_json_tag.py", "test_duplicate_tag"),
                    ("tests", "test_json.py", "test_json_decimal"),
                    ("tests", "test_json.py", "test_json_bad_requests"),
                    ("tests", "test_instance_config.py", "test_uninstalled_module_paths"),
                    ("tests", "test_instance_config.py", "test_explicit_instance_paths"),
                    ("tests", "test_config.py", "test_config_from_envvar_missing"),
                    ("tests", "test_config.py", "test_config_from_mapping"),
                    ("tests", "test_cli.py", "test_cli_empty"),
                    ("tests", "test_cli.py", "test_help_echo_exception"),
                    ("tests", "test_cli.py", "test_app_cli_has_app_context"),
                    ("tests", "test_cli.py", "test_get_version"),
                    ("tests", "test_blueprints.py", "test_nesting_subdomains"),
                    ("tests", "test_blueprints.py", "test_add_template_test"),
                    ("tests", "test_blueprints.py", "test_template_test"),
                    ("tests", "test_blueprints.py", "test_add_template_filter_with_template"),
                    ("tests", "test_blueprints.py", "test_template_filter"),
                    ("tests", "test_blueprints.py", "test_route_decorator_custom_endpoint_with_dots"),
                    ("tests", "test_blueprints.py", "test_blueprint_specific_user_error_handling"),
                    ("tests", "test_blueprints.py", "test_blueprint_specific_error_handling"),
                    ("tests", "test_basic.py", "test_multi_route_rules"),
                    ("tests", "test_basic.py", "test_get_method_on_g"),
                    ("tests", "test_basic.py", "test_nonascii_pathinfo"),
                    ("tests", "test_basic.py", "test_inject_blueprint_url_defaults"),
                    ("tests", "test_basic.py", "test_max_content_length"),
                    ("tests", "test_basic.py", "test_server_name_subdomain"),
                    ("tests", "test_basic.py", "test_static_route_with_host_matching"),
                    ("tests", "test_basic.py", "test_static_folder_with_ending_slash"),
                    ("tests", "test_basic.py", "test_static_url_path_with_ending_slash"),
                    ("tests", "test_basic.py", "test_url_for_passes_special_values_to_build_error_handler"),
                    ("tests", "test_basic.py", "test_url_generation"),
                    ("tests", "test_basic.py", "test_error_handling"),
                    ("tests", "test_basic.py", "test_teardown_request_handler_error"),
                    ("tests", "test_basic.py", "test_request_processing"),
                    ("tests", "test_basic.py", "test_flashes"),
                    ("tests", "test_basic.py", "test_session_cookie_setting"),
                    ("tests", "test_basic.py", "test_session_special_types"),
                    ("tests", "test_basic.py", "test_session_stored_last"),
                    ("tests", "test_basic.py", "test_session_expiration"),
                    ("tests", "test_basic.py", "test_session_using_session_settings"),
                    ("tests", "test_basic.py", "test_session"),
                    ("tests", "test_basic.py", "test_provide_automatic_options_kwarg"),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_dump_load_unchanged[data8]",
                        '{"arguments": {"data": "UUID(\'2a3a83a6-16ae-4a99-ae5c-48eb22c975d0\')"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_views.py",
                        "test_methods_var_inheritance",
                        '{"arguments": {"to_handle": "500"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_views.py",
                        "test_explicit_head",
                        '{"arguments": {"to_handle": "500"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_views.py",
                        "test_view_patching",
                        '{"arguments": {"to_handle": "500"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_views.py",
                        "test_basic_view",
                        '{"arguments": {"to_handle": "500"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_user_error_handler.py",
                        "test_handle_generic",
                        '{"arguments": {"to_handle": "500"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_user_error_handler.py",
                        "test_default_error_handler",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_cli_custom_obj",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_cli_runner_class",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_subdomain",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_client_json_no_app_context",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_test_client_context_binding",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_session_transactions_no_null_sessions",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_blueprint_with_subdomain",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_environbuilder_json_dumps",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_path_is_url",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_environ_base_modified",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_global",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_filter_with_name_and_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_filter_with_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_filter_with_name",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_escaping_without_template_filename",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_no_escaping",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_standard_context",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_subclassing.py",
                        "test_suppressed_exception_logging",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_normal_environ_completes",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_logging.py",
                        "test_wsgi_errors_stream",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_tag_order",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_custom_tag",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_dump_load_unchanged[<html>]",
                        '{"arguments": {"data": "Markup(\'<html>\')"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_dump_load_unchanged[data5]",
                        '{"arguments": {"data": "[(1, 2, 3)]"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_dump_load_unchanged[data4]",
                        '{"arguments": {"data": "(1, 2, 3)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_dump_load_unchanged[data3]",
                        '{"arguments": {"data": "{\'x\': (1, 2, 3), \'y\': 4}"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_dump_load_unchanged[data0]",
                        '{"arguments": {"data": "{\' t\': (1, 2, 3)}"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_jsonify_aware_datetimes[tz0]",
                        '{"arguments": {"tz": "(\'UTC\', 0)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_jsonify_datetime[value0]",
                        '{"arguments": {"value": "datetime.datetime(1973, 3, 11, 6, 30, 45)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_jsonify_dicts",
                        '{"arguments": {"test_value": "None"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_jsonify_basic_types[longer string]",
                        '{"arguments": {"test_value": "\'longer string\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_jsonify_basic_types[23]",
                        '{"arguments": {"test_value": "23"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_jsonify_basic_types[-1]",
                        '{"arguments": {"test_value": "-1"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        'test_json_as_unicode[False-"\\u2603"]',
                        '{"arguments": {"test_value": "False", "expected": "\'\\"\\u2603\\"\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_instance_config.py",
                        "test_prefix_package_paths[True]",
                        '{"arguments": {"limit_loader": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_instance_config.py",
                        "test_installed_module_paths[True]",
                        '{"arguments": {"limit_loader": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_instance_config.py",
                        "test_uninstalled_namespace_paths",
                        '{"arguments": {"encoding": "\'utf-16-le\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_open_resource_exceptions[w]",
                        '{"arguments": {"mode": "\'w\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_open_resource[rt]",
                        '{"arguments": {"mode": "\'rt\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_open_resource[rb]",
                        '{"arguments": {"mode": "\'rb\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_open_resource[r]",
                        '{"arguments": {"mode": "\'r\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_get_debug_flag[-False]",
                        '{"arguments": {"debug": "\'\'", "expect": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_streaming_with_context_as_decorator",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_streaming_with_context",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_name_with_import_error",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_app_aborter_class",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_url_for_with_scheme",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_url_for_with_anchor",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_static_file",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_config.py",
                        "test_get_namespace",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_config.py",
                        "test_session_lifetime",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_config.py",
                        "test_config_missing_file",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_config.py",
                        "test_config_from_envvar",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_config.py",
                        "test_from_prefixed_env_nested",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_config.py",
                        "test_config_from_file_json",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_run_cert_no_ssl",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_run_cert_import",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_load_dotenv",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    ("tests", "test_cli.py", "test_host", '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}'),
                    (
                        "tests",
                        "test_cli.py",
                        "test_subdomain",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_no_command_echo_loading_error",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_flaskgroup_debug[True]",
                        '{"arguments": {"set_debug_flag": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_flaskgroup_app_context",
                        '{"arguments": {"iname": "\'cliapp.message.txt\'", "aname": "None"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_appgroup_app_context",
                        '{"arguments": {"iname": "\'cliapp.message.txt\'", "aname": "None"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_app_cli_has_app_context",
                        '{"arguments": {"iname": "\'cliapp.message.txt\'", "aname": "None"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        'test_locate_app_raises[cliapp.factory-create_app2("foo")]',
                        '{"arguments": {"iname": "\'cliapp.factory\'", "aname": "\'create_app2(\\"foo\\")\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_locate_app[cliapp.factory-create_app-app]",
                        '{"arguments": {"iname": "\'cliapp.factory\'", "aname": "\'create_app\'", "result": "\'app\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_locate_app[cliapp.app-testapp-testapp]",
                        '{"arguments": {"iname": "\'cliapp.app\'", "aname": "\'testapp\'", "result": "\'testapp\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_prepare_import[value9-path9-cliapp.message.txt]",
                        '{"arguments": {"value": "PosixPath(\'/Users/romain.komorn/nondd/flask-shallow/tests/test_apps/cliapp/message.txt\')", "path": "PosixPath(\'/Users/romain.komorn/nondd/flask-shallow/tests/test_apps\')", "result": "\'cliapp.message.txt\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_prepare_import[value6-path6-cliapp.inner1.inner2]",
                        '{"arguments": {"value": "PosixPath(\'/Users/romain.komorn/nondd/flask-shallow/tests/test_apps/cliapp/inner1/inner2\')", "path": "PosixPath(\'/Users/romain.komorn/nondd/flask-shallow/tests/test_apps\')", "result": "\'cliapp.inner1.inner2\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_cli_name",
                        '{"arguments": {"parent_init": "\'/other\'", "child_init": "\'/something\'", "parent_registration": "\'/parent\'", "child_registration": "\'/child\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_blueprint_renaming",
                        '{"arguments": {"parent_init": "\'/other\'", "child_init": "\'/something\'", "parent_registration": "\'/parent\'", "child_registration": "\'/child\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_unique_blueprint_names",
                        '{"arguments": {"parent_init": "\'/other\'", "child_init": "\'/something\'", "parent_registration": "\'/parent\'", "child_registration": "\'/child\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_app_url_processors",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_request_processing",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_template_test_with_name_and_template",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_add_template_test_with_template",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_template_filter_with_template",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_add_template_filter",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_template_filter",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_endpoint_decorator",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_default_static_max_age",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_blueprint_app_error_handling",
                        '{"arguments": {"host": "None", "port": "None", "server_name": "\'localhost:0\'", "expect_host": "\'localhost\'", "expect_port": "0"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_blueprint_specific_user_error_handling",
                        '{"arguments": {"host": "None", "port": "None", "server_name": "\'localhost:0\'", "expect_host": "\'localhost\'", "expect_port": "0"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_max_cookie_size",
                        '{"arguments": {"host": "None", "port": "None", "server_name": "\'localhost:0\'", "expect_host": "\'localhost\'", "expect_port": "0"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_g_iteration_protocol",
                        '{"arguments": {"propagate_exceptions": "False", "use_reloader": "False", "use_debugger": "False", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_route_decorator_custom_endpoint",
                        '{"arguments": {"propagate_exceptions": "False", "use_reloader": "False", "use_debugger": "False", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[False-True-False-True]",
                        '{"arguments": {"propagate_exceptions": "False", "use_reloader": "True", "use_debugger": "False", "debug": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[False-True-True-False]",
                        '{"arguments": {"propagate_exceptions": "False", "use_reloader": "True", "use_debugger": "True", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[None-False-True-False]",
                        '{"arguments": {"propagate_exceptions": "None", "use_reloader": "False", "use_debugger": "True", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[None-False-True-True]",
                        '{"arguments": {"propagate_exceptions": "None", "use_reloader": "False", "use_debugger": "True", "debug": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[None-True-False-True]",
                        '{"arguments": {"propagate_exceptions": "None", "use_reloader": "True", "use_debugger": "False", "debug": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[None-True-True-False]",
                        '{"arguments": {"propagate_exceptions": "None", "use_reloader": "True", "use_debugger": "True", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[None-True-True-True]",
                        '{"arguments": {"propagate_exceptions": "None", "use_reloader": "True", "use_debugger": "True", "debug": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_exception_propagation[DEBUG]",
                        '{"arguments": {"key": "\'DEBUG\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_exception_propagation[PROPAGATE_EXCEPTIONS]",
                        '{"arguments": {"key": "\'PROPAGATE_EXCEPTIONS\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_static_url_path_with_ending_slash",
                        '{"arguments": {"compact": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_static_url_path",
                        '{"arguments": {"compact": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_static_files",
                        '{"arguments": {"compact": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_build_error_handler",
                        '{"arguments": {"compact": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_enctype_debug_helper",
                        '{"arguments": {"debug": "False", "trap": "True", "expect_key": "False", "expect_abort": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_trap_bad_request_key_error[False-True-False-False]",
                        '{"arguments": {"debug": "False", "trap": "True", "expect_key": "False", "expect_abort": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_errorhandler_precedence",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_request_processing",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_extended_flashing",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_session_cookie_setting",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_session_special_types",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_session_stored_last",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_session_expiration",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_session_using_session_settings",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_session",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_endpoint_decorator",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_routing",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_request_dispatching",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_provide_automatic_options_attr",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_async.py",
                        "test_async_route[/home]",
                        '{"arguments": {"path": "\'/home\'"}, "metadata": {}}',
                    ),
                    ("tests", "test_appctx.py", "test_app_tearing_down_with_handled_exception_by_app_handler"),
                    ("tests", "test_appctx.py", "test_app_tearing_down_with_handled_exception_by_except_block"),
                    ("tests", "test_appctx.py", "test_app_tearing_down_with_previous_exception"),
                    (
                        "tests",
                        "test_user_error_handler.py",
                        "test_default_error_handler",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_user_error_handler.py",
                        "test_error_handler_blueprint",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_cli_custom_obj",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_cli_invoke",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_redirect_keep_session",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_client_open_environ",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_loader_debugging",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_templates_auto_reload",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_test_with_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_test",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_filter_with_name_and_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_filter_with_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_filter_with_name",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_filter",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_macros",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_escaping_without_template_filename",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_no_escaping",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_standard_context",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_original_win",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_context_processing",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_template_rendered",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_normal_environ_completes",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_bad_environ_raises_bad_request",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_session_dynamic_cookie_name",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_logging.py",
                        "test_existing_handler",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_tag_interface",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_custom_tag",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    ("tests", "test_helpers.py", "test_streaming_with_context_and_custom_close"),
                    ("tests", "test_helpers.py", "test_streaming_with_context"),
                    ("tests", "test_helpers.py", "test_abort_with_app"),
                    ("tests", "test_helpers.py", "test_url_with_method"),
                    ("tests", "test_converters.py", "test_custom_converters"),
                    (
                        "tests",
                        "test_user_error_handler.py",
                        "test_default_error_handler",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_user_error_handler.py",
                        "test_error_handler_blueprint",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_user_error_handler.py",
                        "test_error_handler_http_subclass",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_cli_custom_obj",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_cli_runner_class",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_full_url_request",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_test_client_context_binding",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_path_is_url",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_client_open_environ",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_environ_defaults",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_templates_auto_reload_debug_run",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_test_with_name_and_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_test_with_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_test",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_filter_with_name_and_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_macros",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_no_escaping",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_request_less_rendering",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_template_rendered",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_bad_environ_raises_bad_request",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_session_error_pops_context",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_manual_context_binding",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_proper_test_request_context",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_teardown_on_pop",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_regression.py",
                        "test_aborting",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_logging.py",
                        "test_logger",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_tag_interface",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_dump_load_unchanged[data8]",
                        '{"arguments": {"data": "UUID(\'5beea569-ff01-423c-986f-600868d8d9a1\')"}, "metadata": {}}',
                    ),
                    ("tests", "test_blueprints.py", "test_template_test_with_name_and_template"),
                    ("tests", "test_views.py", "test_init_once"),
                    ("tests", "test_views.py", "test_remove_method_from_parent"),
                    ("tests", "test_views.py", "test_multiple_inheritance"),
                    ("tests", "test_views.py", "test_methods_var_inheritance"),
                    ("tests", "test_views.py", "test_view_patching"),
                    ("tests", "test_views.py", "test_method_based_view"),
                    ("tests", "test_views.py", "test_basic_view"),
                    ("tests", "test_user_error_handler.py", "test_error_handler_no_match"),
                    ("tests", "test_testing.py", "test_cli_runner_class"),
                    ("tests", "test_testing.py", "test_path_is_url"),
                    ("tests", "test_testing.py", "test_environ_defaults"),
                    ("tests", "test_testing.py", "test_environ_defaults_from_config"),
                    ("tests", "test_templating.py", "test_add_template_test_with_name"),
                    ("tests", "test_templating.py", "test_add_template_test"),
                    ("tests", "test_templating.py", "test_template_test"),
                    ("tests", "test_templating.py", "test_add_template_filter_with_template"),
                    ("tests", "test_templating.py", "test_template_filter"),
                    ("tests", "test_templating.py", "test_request_less_rendering"),
                    ("tests", "test_signals.py", "test_appcontext_tearing_down_signal"),
                    ("tests", "test_signals.py", "test_appcontext_signals"),
                    ("tests", "test_reqctx.py", "test_environ_for_valid_idna_completes"),
                    ("tests", "test_reqctx.py", "test_manual_context_binding"),
                    ("tests", "test_reqctx.py", "test_context_binding"),
                    ("tests", "test_reqctx.py", "test_teardown_with_previous_exception"),
                    ("tests", "test_logging.py", "test_has_level_handler"),
                    ("tests", "test_logging.py", "test_existing_handler"),
                    ("tests", "test_logging.py", "test_logger"),
                    ("tests", "test_json_tag.py", "test_tag_order"),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_dump_load_unchanged[data9]",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 3, 11, 48, 23, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_dump_load_unchanged[data8]",
                        '{"arguments": {"data": "UUID(\'ffa487bb-3420-4ad8-a5a1-4fa0036aa50b\')"}, "metadata": {}}',
                    ),
                    ("tests", "test_json.py", "test_json_key_sorting"),
                    ("tests", "test_json.py", "test_json_customization"),
                    ("tests", "test_json.py", "test_jsonify_arrays"),
                    ("tests", "test_json.py", "test_json_dump_to_file"),
                    ("tests", "test_config.py", "test_get_namespace"),
                    ("tests", "test_config.py", "test_from_prefixed_env_custom_prefix"),
                    ("tests", "test_config.py", "test_config_from_object"),
                    ("tests", "test_cli.py", "test_cli_blueprints"),
                    ("tests", "test_cli.py", "test_disable_dotenv_from_env"),
                    ("tests", "test_cli.py", "test_dotenv_optional"),
                    ("tests", "test_cli.py", "test_load_dotenv"),
                    ("tests", "test_cli.py", "test_all_methods"),
                    ("tests", "test_cli.py", "test_help_echo_loading_error"),
                    ("tests", "test_cli.py", "test_appgroup_app_context"),
                    ("tests", "test_blueprints.py", "test_blueprint_renaming"),
                    ("tests", "test_blueprints.py", "test_unique_blueprint_names"),
                    ("tests", "test_blueprints.py", "test_template_test_after_route_with_template"),
                    ("tests", "test_blueprints.py", "test_template_filter_with_name_and_template"),
                    ("tests", "test_blueprints.py", "test_template_filter_after_route_with_template"),
                    ("tests", "test_blueprints.py", "test_template_filter_with_template"),
                    ("tests", "test_blueprints.py", "test_template_filter_with_name"),
                    ("tests", "test_blueprints.py", "test_route_decorator_custom_endpoint"),
                    ("tests", "test_blueprints.py", "test_empty_name_not_allowed"),
                    ("tests", "test_blueprints.py", "test_dotted_name_not_allowed"),
                    ("tests", "test_blueprints.py", "test_default_static_max_age"),
                    ("tests", "test_blueprints.py", "test_templates_and_static"),
                    ("tests", "test_blueprints.py", "test_blueprint_app_error_handling"),
                    ("tests", "test_basic.py", "test_max_cookie_size"),
                    ("tests", "test_basic.py", "test_subdomain_matching_with_ports"),
                    ("tests", "test_basic.py", "test_subdomain_basic_support"),
                    ("tests", "test_basic.py", "test_g_iteration_protocol"),
                    ("tests", "test_basic.py", "test_routing_redirect_debugging"),
                    ("tests", "test_basic.py", "test_static_folder_with_pathlib_path"),
                    ("tests", "test_basic.py", "test_static_files"),
                    ("tests", "test_basic.py", "test_build_error_handler"),
                    ("tests", "test_basic.py", "test_jsonify_args_and_kwargs_check"),
                    ("tests", "test_basic.py", "test_enctype_debug_helper"),
                    ("tests", "test_basic.py", "test_before_request_and_routing_errors"),
                    ("tests", "test_basic.py", "test_before_after_request_order"),
                    ("tests", "test_basic.py", "test_teardown_request_handler_debug_mode"),
                    ("tests", "test_basic.py", "test_after_request_processing"),
                    ("tests", "test_basic.py", "test_extended_flashing"),
                    ("tests", "test_basic.py", "test_session_path"),
                    ("tests", "test_basic.py", "test_provide_automatic_options_attr"),
                    ("tests", "test_basic.py", "test_options_on_multiple_rules"),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_dump_load_unchanged[data9]",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 3, 8, 21, 10, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_views.py",
                        "test_view_provide_automatic_options_attr",
                        '{"arguments": {"to_handle": "500"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_views.py",
                        "test_view_inheritance",
                        '{"arguments": {"to_handle": "500"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_user_error_handler.py",
                        "test_handle_generic_http",
                        '{"arguments": {"to_handle": "500"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_user_error_handler.py",
                        "test_error_handler_blueprint",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_user_error_handler.py",
                        "test_error_handler_http_subclass",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_user_error_handler.py",
                        "test_error_handler_no_match",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_cli_invoke",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_nosubdomain",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_json_request_and_response",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_reuse_client",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_environ_base_default",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_environ_defaults",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_templates_auto_reload_debug_run",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_iterable_loader",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_custom_template_loader",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_test_with_name_and_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_test_with_name_and_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_test_with_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_test_with_name",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_filter",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_escaping",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_appcontext_tearing_down_signal",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_request_signals",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_before_render_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_session_interface.py",
                        "test_open_session_with_endpoint",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_bad_environ_raises_bad_request",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_session_dynamic_cookie_name",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_manual_context_binding",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_context_test",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_teardown_on_pop",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_regression.py",
                        "test_aborting",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_logging.py",
                        "test_has_level_handler",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_duplicate_tag",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_dump_load_unchanged[\\xff]",
                        '{"arguments": {"data": "b\'\\\\xff\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_html_method",
                        '{"arguments": {"tz": "(\'KST\', 9)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_tojson_filter",
                        '{"arguments": {"tz": "(\'KST\', 9)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_json_decimal",
                        '{"arguments": {"tz": "(\'KST\', 9)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_jsonify_uuid_types",
                        '{"arguments": {"tz": "(\'KST\', 9)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_jsonify_basic_types[None]",
                        '{"arguments": {"test_value": "None"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_jsonify_basic_types[1]",
                        '{"arguments": {"test_value": "1"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_json_dump_to_file",
                        '{"arguments": {"test_value": "False", "expected": "\'\\"\\u2603\\"\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        'test_json_as_unicode[True-"\\\\u2603"]',
                        '{"arguments": {"test_value": "True", "expected": "\'\\"\\\\\\\\u2603\\"\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_bad_request_debug_message[True]",
                        '{"arguments": {"debug": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_instance_config.py",
                        "test_installed_package_paths[True]",
                        '{"arguments": {"limit_loader": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_instance_config.py",
                        "test_uninstalled_package_paths",
                        '{"arguments": {"encoding": "\'utf-16-le\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_instance_config.py",
                        "test_uninstalled_module_paths",
                        '{"arguments": {"encoding": "\'utf-16-le\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_instance_config.py",
                        "test_explicit_instance_paths",
                        '{"arguments": {"encoding": "\'utf-16-le\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_open_resource_with_encoding[utf-8]",
                        '{"arguments": {"encoding": "\'utf-8\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_open_resource_exceptions[a]",
                        '{"arguments": {"mode": "\'a\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_get_debug_flag[False-False]",
                        '{"arguments": {"debug": "\'False\'", "expect": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_get_debug_flag[0-False]",
                        '{"arguments": {"debug": "\'0\'", "expect": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_streaming_with_context_and_custom_close",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_url_for_with_self",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_send_from_directory",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_converters.py",
                        "test_context_available",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_converters.py",
                        "test_custom_converters",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_config.py",
                        "test_from_pyfile_weird_encoding[latin-1]",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_config.py",
                        "test_from_pyfile_weird_encoding[utf-8]",
                        '{"arguments": {"encoding": "\'utf-8\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_config.py",
                        "test_config_missing",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_config.py",
                        "test_from_prefixed_env_custom_prefix",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_config.py",
                        "test_from_prefixed_env",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_config.py",
                        "test_config_from_pyfile",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_run_exclude_patterns",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_cli_blueprints",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_dotenv_optional",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_simple",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_locate_app_raises[cliapp.message.txt-None]",
                        '{"arguments": {"iname": "\'cliapp.message.txt\'", "aname": "None"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_locate_app_raises[cliapp.factory-no_app]",
                        '{"arguments": {"iname": "\'cliapp.factory\'", "aname": "\'no_app\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_locate_app_raises[cliapp/app-None]",
                        '{"arguments": {"iname": "\'cliapp/app\'", "aname": "None"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_prepare_import[a/test-path2-test]",
                        '{"arguments": {"value": "\'a/test\'", "path": "PosixPath(\'/Users/romain.komorn/nondd/flask-shallow/a\')", "result": "\'test\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_prepare_import[test-path0-test]",
                        '{"arguments": {"value": "\'test\'", "path": "PosixPath(\'/Users/romain.komorn/nondd/flask-shallow\')", "result": "\'test\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_find_best_app",
                        '{"arguments": {"parent_init": "\'/other\'", "child_init": "\'/something\'", "parent_registration": "\'/parent\'", "child_registration": "\'/child\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_nesting_url_prefixes[None-None-/parent-/child]",
                        '{"arguments": {"parent_init": "None", "child_init": "None", "parent_registration": "\'/parent\'", "child_registration": "\'/child\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_nesting_url_prefixes[/parent-/child-None-None]",
                        '{"arguments": {"parent_init": "\'/parent\'", "child_init": "\'/child\'", "parent_registration": "None", "child_registration": "None"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_nested_callback_order",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_add_template_test_with_name",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_template_test_with_name",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_template_filter_with_name_and_template",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_template_filter_after_route_with_template",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_add_template_filter_with_name",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_route_decorator_custom_endpoint_with_dots",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_route_decorator_custom_endpoint",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_dotted_name_not_allowed",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_templates_and_static",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_blueprint_url_processors",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_blueprint_prefix_slash[/foo//-/bar-/foo/bar]",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_blueprint_prefix_slash[/foo-/bar-/foo/bar]",
                        '{"arguments": {"prefix": "\'/foo\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_blueprint_prefix_slash[-/bar-/bar]",
                        '{"arguments": {"prefix": "\'\'", "rule": "\'/bar\'", "url": "\'/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_blueprint_prefix_slash[/foo/--/foo/]",
                        '{"arguments": {"prefix": "\'/foo/\'", "rule": "\'\'", "url": "\'/foo/\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_blueprint_prefix_slash[/foo--/foo]",
                        '{"arguments": {"prefix": "\'/foo\'", "rule": "\'\'", "url": "\'/foo\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_blueprint_prefix_slash[/--/]",
                        '{"arguments": {"prefix": "\'/\'", "rule": "\'\'", "url": "\'/\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_blueprint_specific_error_handling",
                        '{"arguments": {"host": "None", "port": "None", "server_name": "\'localhost:0\'", "expect_host": "\'localhost\'", "expect_port": "0"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_run_from_config[None-None-localhost:0-localhost-0]",
                        '{"arguments": {"host": "None", "port": "None", "server_name": "\'localhost:0\'", "expect_host": "\'localhost\'", "expect_port": "0"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_run_from_config[localhost-80-pocoo.org:8080-localhost-80]",
                        '{"arguments": {"host": "\'localhost\'", "port": "80", "server_name": "\'pocoo.org:8080\'", "expect_host": "\'localhost\'", "expect_port": "80"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_run_from_config[None-80-pocoo.org:8080-pocoo.org-80]",
                        '{"arguments": {"host": "None", "port": "80", "server_name": "\'pocoo.org:8080\'", "expect_host": "\'pocoo.org\'", "expect_port": "80"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_multi_route_class_views",
                        '{"arguments": {"matching": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_subdomain_matching_other_name[False]",
                        '{"arguments": {"matching": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_subdomain_matching_with_ports",
                        '{"arguments": {"propagate_exceptions": "False", "use_reloader": "False", "use_debugger": "False", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_get_method_on_g",
                        '{"arguments": {"propagate_exceptions": "False", "use_reloader": "False", "use_debugger": "False", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_routing_redirect_debugging",
                        '{"arguments": {"propagate_exceptions": "False", "use_reloader": "False", "use_debugger": "False", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_nonascii_pathinfo",
                        '{"arguments": {"propagate_exceptions": "False", "use_reloader": "False", "use_debugger": "False", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_inject_blueprint_url_defaults",
                        '{"arguments": {"propagate_exceptions": "False", "use_reloader": "False", "use_debugger": "False", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_max_content_length",
                        '{"arguments": {"propagate_exceptions": "False", "use_reloader": "False", "use_debugger": "False", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[False-True-True-True]",
                        '{"arguments": {"propagate_exceptions": "False", "use_reloader": "True", "use_debugger": "True", "debug": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[True-False-False-True]",
                        '{"arguments": {"propagate_exceptions": "True", "use_reloader": "False", "use_debugger": "False", "debug": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[True-True-True-False]",
                        '{"arguments": {"propagate_exceptions": "True", "use_reloader": "True", "use_debugger": "True", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[None-False-False-False]",
                        '{"arguments": {"propagate_exceptions": "None", "use_reloader": "False", "use_debugger": "False", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[None-False-False-True]",
                        '{"arguments": {"propagate_exceptions": "None", "use_reloader": "False", "use_debugger": "False", "debug": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_exception_propagation[TESTING]",
                        '{"arguments": {"key": "\'TESTING\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_static_route_with_host_matching",
                        '{"arguments": {"compact": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_static_folder_with_ending_slash",
                        '{"arguments": {"compact": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_json_dump_dataclass",
                        '{"arguments": {"compact": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_jsonify_no_prettyprint[False]",
                        '{"arguments": {"compact": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_trap_bad_request_key_error[False-None-True-True]",
                        '{"arguments": {"debug": "False", "trap": "None", "expect_key": "True", "expect_abort": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_user_error_handling",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_error_handling",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_before_after_request_order",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_teardown_request_handler_error",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_teardown_request_handler",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_request_preprocessing_early_return",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_session_vary_cookie",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_session_using_samesite_attribute",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_method_route[delete]",
                        '{"arguments": {"method": "\'delete\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_method_route[put]",
                        '{"arguments": {"method": "\'put\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_method_route[post]",
                        '{"arguments": {"method": "\'post\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_async.py",
                        "test_async_route[/view]",
                        '{"arguments": {"path": "\'/view\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_async.py",
                        "test_async_route[/bp/]",
                        '{"arguments": {"path": "\'/bp/\'"}, "metadata": {}}',
                    ),
                    ("tests", "test_appctx.py", "test_context_refcounts"),
                    ("tests", "test_appctx.py", "test_app_tearing_down_with_unhandled_exception"),
                    ("tests", "test_appctx.py", "test_request_context_means_app_context"),
                    ("tests", "test_appctx.py", "test_url_generation_requires_server_name"),
                    (
                        "tests",
                        "test_user_error_handler.py",
                        "test_error_handler_http_subclass",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_client_pop_all_preserved",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_subdomain",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_full_url_request",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_reuse_client",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_session_transactions",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_blueprint_with_subdomain",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_environbuilder_json_dumps",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_environ_base_default",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_environ_defaults_from_config",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_custom_jinja_env",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_templates_auto_reload_debug_run",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_global",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_test",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_filter_with_name_and_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_filter_with_name",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_escaping",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_appcontext_signals",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_request_exception_signal",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_request_signals",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_session_error_pops_context",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_manual_context_binding",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_regression.py",
                        "test_aborting",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_logging.py",
                        "test_log_view_exception",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_logging.py",
                        "test_has_level_handler",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_logging.py",
                        "test_wsgi_errors_stream",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_tag_order",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_duplicate_tag",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_dump_load_unchanged[data9]",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    ("tests", "test_helpers.py", "test_name_with_import_error"),
                    ("tests", "test_helpers.py", "test_app_aborter_class"),
                    ("tests", "test_helpers.py", "test_redirect_no_app"),
                    ("tests", "test_helpers.py", "test_url_for_with_alternating_schemes"),
                    ("tests", "test_helpers.py", "test_url_for_with_scheme_not_external"),
                    ("tests", "test_helpers.py", "test_url_for_with_anchor"),
                    (
                        "tests",
                        "test_user_error_handler.py",
                        "test_error_handler_no_match",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_subdomain",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_reuse_client",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_session_transaction_needs_cookies",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_session_transactions",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_loader_debugging",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_templates_auto_reload",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_iterable_loader",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_global",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_test_with_name",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_filter_with_name_and_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_filter_with_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_filter_with_name",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_filter_with_name",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_escaping_without_template_filename",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_simple_stream",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_original_win",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_context_processing",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_subclassing.py",
                        "test_suppressed_exception_logging",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_appcontext_tearing_down_signal",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_teardown_with_handled_exception",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_teardown_with_previous_exception",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_custom_tag",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_dump_load_unchanged[data9]",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    ("tests", "test_blueprints.py", "test_nested_callback_order"),
                    ("tests", "test_blueprints.py", "test_app_url_processors"),
                    ("tests", "test_blueprints.py", "test_app_request_processing"),
                    ("tests", "test_blueprints.py", "test_add_template_test_with_name_and_template"),
                    ("tests", "test_views.py", "test_endpoint_override"),
                    ("tests", "test_views.py", "test_explicit_head"),
                    ("tests", "test_views.py", "test_view_decorators"),
                    ("tests", "test_user_error_handler.py", "test_handle_generic_http"),
                    ("tests", "test_user_error_handler.py", "test_error_handler_blueprint"),
                    ("tests", "test_user_error_handler.py", "test_error_handler_http_subclass"),
                    ("tests", "test_user_error_handler.py", "test_error_handler_subclass"),
                    ("tests", "test_testing.py", "test_client_pop_all_preserved"),
                    ("tests", "test_testing.py", "test_cli_custom_obj"),
                    ("tests", "test_testing.py", "test_cli_invoke"),
                    ("tests", "test_testing.py", "test_nosubdomain"),
                    ("tests", "test_testing.py", "test_subdomain"),
                    ("tests", "test_testing.py", "test_client_json_no_app_context"),
                    ("tests", "test_testing.py", "test_json_request_and_response"),
                    ("tests", "test_testing.py", "test_session_transactions_no_null_sessions"),
                    ("tests", "test_testing.py", "test_redirect_keep_session"),
                    ("tests", "test_testing.py", "test_blueprint_with_subdomain"),
                    ("tests", "test_testing.py", "test_environbuilder_json_dumps"),
                    ("tests", "test_testing.py", "test_environ_base_modified"),
                    ("tests", "test_testing.py", "test_environ_base_default"),
                    ("tests", "test_templating.py", "test_custom_jinja_env"),
                    ("tests", "test_templating.py", "test_iterable_loader"),
                    ("tests", "test_templating.py", "test_template_filter_with_name_and_template"),
                    ("tests", "test_templating.py", "test_add_template_filter"),
                    ("tests", "test_templating.py", "test_macros"),
                    ("tests", "test_templating.py", "test_no_escaping"),
                    ("tests", "test_templating.py", "test_escaping"),
                    ("tests", "test_templating.py", "test_standard_context"),
                    ("tests", "test_templating.py", "test_original_win"),
                    ("tests", "test_signals.py", "test_flash_signal"),
                    ("tests", "test_session_interface.py", "test_open_session_with_endpoint"),
                    ("tests", "test_reqctx.py", "test_normal_environ_completes"),
                    ("tests", "test_reqctx.py", "test_context_test"),
                    ("tests", "test_reqctx.py", "test_proper_test_request_context"),
                    ("tests", "test_reqctx.py", "test_teardown_on_pop"),
                    ("tests", "test_regression.py", "test_aborting"),
                    ("tests", "test_logging.py", "test_log_view_exception"),
                    ("tests", "test_json_tag.py", "test_tag_interface"),
                    ("tests", "test_json.py", "test_html_method"),
                    ("tests", "test_instance_config.py", "test_uninstalled_package_paths"),
                    ("tests", "test_helpers.py", "test_make_response"),
                    ("tests", "test_config.py", "test_session_lifetime"),
                    ("tests", "test_config.py", "test_custom_config_class"),
                    ("tests", "test_config.py", "test_config_missing_file"),
                    ("tests", "test_config.py", "test_config_from_class"),
                    ("tests", "test_config.py", "test_from_prefixed_env"),
                    ("tests", "test_config.py", "test_config_from_file_toml"),
                    ("tests", "test_config.py", "test_config_from_file_json"),
                    ("tests", "test_config.py", "test_config_from_pyfile"),
                    ("tests", "test_cli.py", "test_run_cert_no_ssl"),
                    ("tests", "test_cli.py", "test_run_cert_path"),
                    ("tests", "test_cli.py", "test_no_command_echo_loading_error"),
                    ("tests", "test_cli.py", "test_flaskgroup_app_context"),
                    ("tests", "test_cli.py", "test_with_appcontext"),
                    ("tests", "test_cli.py", "test_locate_app_suppress_raise"),
                    ("tests", "test_cli.py", "test_cli_name"),
                    ("tests", "test_blueprints.py", "test_self_registration"),
                    ("tests", "test_blueprints.py", "test_child_and_parent_subdomain"),
                    ("tests", "test_blueprints.py", "test_add_template_test_with_template"),
                    ("tests", "test_blueprints.py", "test_add_template_test_with_name"),
                    ("tests", "test_blueprints.py", "test_template_test_with_name"),
                    ("tests", "test_blueprints.py", "test_add_template_filter_with_name_and_template"),
                    ("tests", "test_blueprints.py", "test_empty_url_defaults"),
                    ("tests", "test_blueprints.py", "test_blueprint_url_defaults"),
                    ("tests", "test_basic.py", "test_multi_route_class_views"),
                    ("tests", "test_basic.py", "test_subdomain_matching"),
                    ("tests", "test_basic.py", "test_route_decorator_custom_endpoint"),
                    ("tests", "test_basic.py", "test_url_processors"),
                    ("tests", "test_basic.py", "test_static_url_empty_path_default"),
                    ("tests", "test_basic.py", "test_static_url_path"),
                    ("tests", "test_basic.py", "test_json_dump_dataclass"),
                    ("tests", "test_basic.py", "test_response_type_errors"),
                    ("tests", "test_basic.py", "test_error_handler_after_processor_error"),
                    ("tests", "test_basic.py", "test_trapping_of_all_http_exceptions"),
                    ("tests", "test_basic.py", "test_user_error_handling"),
                    ("tests", "test_basic.py", "test_baseexception_error_handling"),
                    ("tests", "test_basic.py", "test_error_handling_processing"),
                    ("tests", "test_basic.py", "test_teardown_request_handler"),
                    ("tests", "test_basic.py", "test_request_preprocessing_early_return"),
                    ("tests", "test_basic.py", "test_session_vary_cookie"),
                    ("tests", "test_basic.py", "test_session_using_application_root"),
                    ("tests", "test_basic.py", "test_werkzeug_routing"),
                    ("tests", "test_basic.py", "test_url_mapping"),
                    ("tests", "test_basic.py", "test_method_route_no_methods"),
                    ("tests", "test_views.py", "test_init_once", '{"arguments": {"to_handle": "500"}, "metadata": {}}'),
                    (
                        "tests",
                        "test_views.py",
                        "test_multiple_inheritance",
                        '{"arguments": {"to_handle": "500"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_views.py",
                        "test_endpoint_override",
                        '{"arguments": {"to_handle": "500"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_views.py",
                        "test_implicit_head",
                        '{"arguments": {"to_handle": "500"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_views.py",
                        "test_view_decorators",
                        '{"arguments": {"to_handle": "500"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_user_error_handler.py",
                        "test_handle_class_or_code[500]",
                        '{"arguments": {"to_handle": "500"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_user_error_handler.py",
                        "test_handle_class_or_code[InternalServerError]",
                        '{"arguments": {"to_handle": "<class \'werkzeug.exceptions.InternalServerError\'>"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_user_error_handler.py",
                        "test_error_handler_subclass",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_session_transactions_keep_context",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_redirect_keep_session",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_loader_debugging",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_test_with_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_test_with_name",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_test",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_filter_with_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_filter_with_name",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_macros",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_original_win",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_flash_signal",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_appcontext_signals",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_request_exception_signal",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_template_rendered",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_teardown_with_previous_exception",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_logging.py",
                        "test_existing_handler",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_logging.py",
                        "test_logger_debug",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_logging.py",
                        "test_logger",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_tag_interface",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_dump_load_unchanged[data9]",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 21, 5, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_dump_load_unchanged[data8]",
                        '{"arguments": {"data": "UUID(\'72b725bf-e17a-44ca-aa2d-22ed6e2412b5\')"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_dump_load_unchanged[data2]",
                        '{"arguments": {"data": "{\' di\': \' di\'}"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_dump_load_unchanged[data1]",
                        '{"arguments": {"data": "{\' t__\': b\'a\'}"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_json_key_sorting",
                        '{"arguments": {"tz": "(\'KST\', 9)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_json_attr",
                        '{"arguments": {"tz": "(\'KST\', 9)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_jsonify_aware_datetimes[tz2]",
                        '{"arguments": {"tz": "(\'KST\', 9)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_jsonify_arrays",
                        '{"arguments": {"test_value": "None"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_jsonify_basic_types[False]",
                        '{"arguments": {"test_value": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json.py",
                        "test_jsonify_basic_types[True]",
                        '{"arguments": {"test_value": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_get_debug_flag[True-True]",
                        '{"arguments": {"debug": "\'True\'", "expect": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_get_debug_flag[No-False]",
                        '{"arguments": {"debug": "\'No\'", "expect": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_stream_keeps_session",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_abort_with_app",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_redirect_no_app",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_url_for_with_alternating_schemes",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_url_for_with_scheme_not_external",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_helpers.py",
                        "test_send_file",
                        '{"arguments": {"encoding": "\'latin-1\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_config.py",
                        "test_custom_config_class",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_config.py",
                        "test_config_from_envvar_missing",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_config.py",
                        "test_config_from_class",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_cli_empty",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_run_cert_adhoc",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_run_cert_path",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_dotenv_path",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_no_routes",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    ("tests", "test_cli.py", "test_sort", '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}'),
                    (
                        "tests",
                        "test_cli.py",
                        "test_flaskgroup_debug[False]",
                        '{"arguments": {"set_debug_flag": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_with_appcontext",
                        '{"arguments": {"iname": "\'cliapp.message.txt\'", "aname": "None"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_get_version",
                        '{"arguments": {"iname": "\'cliapp.message.txt\'", "aname": "None"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_locate_app_suppress_raise",
                        '{"arguments": {"iname": "\'cliapp.message.txt\'", "aname": "None"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_locate_app_raises[cliapp.importerrorapp-None]",
                        '{"arguments": {"iname": "\'cliapp.importerrorapp\'", "aname": "None"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_locate_app_raises[cliapp.factory-create_app(]",
                        '{"arguments": {"iname": "\'cliapp.factory\'", "aname": "\'create_app(\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_locate_app_raises[cliapp.app-notanapp]",
                        '{"arguments": {"iname": "\'cliapp.app\'", "aname": "\'notanapp\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_locate_app_raises[notanapp.py-None]",
                        '{"arguments": {"iname": "\'notanapp.py\'", "aname": "None"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_locate_app[cliapp.factory- create_app () -app]",
                        '{"arguments": {"iname": "\'cliapp.factory\'", "aname": "\' create_app () \'", "result": "\'app\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        'test_locate_app[cliapp.factory-create_app2("foo", "bar")-app2_foo_bar]',
                        '{"arguments": {"iname": "\'cliapp.factory\'", "aname": "\'create_app2(\\"foo\\", \\"bar\\")\'", "result": "\'app2_foo_bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_prepare_import[value8-path8-cliapp.app]",
                        '{"arguments": {"value": "PosixPath(\'/Users/romain.komorn/nondd/flask-shallow/tests/test_apps/cliapp.app\')", "path": "PosixPath(\'/Users/romain.komorn/nondd/flask-shallow/tests/test_apps\')", "result": "\'cliapp.app\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_prepare_import[test/__init__-path4-test]",
                        '{"arguments": {"value": "\'test/__init__\'", "path": "PosixPath(\'/Users/romain.komorn/nondd/flask-shallow\')", "result": "\'test\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_cli.py",
                        "test_prepare_import[test/__init__.py-path3-test]",
                        '{"arguments": {"value": "\'test/__init__.py\'", "path": "PosixPath(\'/Users/romain.komorn/nondd/flask-shallow\')", "result": "\'test\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_self_registration",
                        '{"arguments": {"parent_init": "\'/other\'", "child_init": "\'/something\'", "parent_registration": "\'/parent\'", "child_registration": "\'/child\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_child_and_parent_subdomain",
                        '{"arguments": {"parent_init": "\'/other\'", "child_init": "\'/something\'", "parent_registration": "\'/parent\'", "child_registration": "\'/child\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_nesting_subdomains",
                        '{"arguments": {"parent_init": "\'/other\'", "child_init": "\'/something\'", "parent_registration": "\'/parent\'", "child_registration": "\'/child\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_nesting_url_prefixes[/parent-None-None-/child]",
                        '{"arguments": {"parent_init": "\'/parent\'", "child_init": "None", "parent_registration": "None", "child_registration": "\'/child\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_nested_blueprint",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_app_request_processing",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_template_global",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_context_processing",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_template_test",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_add_template_filter_with_name_and_template",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_add_template_filter_with_template",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_empty_url_defaults",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_dotted_names_from_app",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_empty_name_not_allowed",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_templates_list",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_blueprint_url_defaults",
                        '{"arguments": {"prefix": "\'/foo//\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_blueprint_prefix_slash[/foo/-/bar-/foo/bar]",
                        '{"arguments": {"prefix": "\'/foo/\'", "rule": "\'/bar\'", "url": "\'/foo/bar\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_blueprint_prefix_slash[/-/-/]",
                        '{"arguments": {"prefix": "\'/\'", "rule": "\'/\'", "url": "\'/\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_blueprints.py",
                        "test_blueprint_prefix_slash[-/-/]",
                        '{"arguments": {"prefix": "\'\'", "rule": "\'/\'", "url": "\'/\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_app_freed_on_zero_refcount",
                        '{"arguments": {"host": "None", "port": "None", "server_name": "\'localhost:0\'", "expect_host": "\'localhost\'", "expect_port": "0"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_run_from_config[localhost-0-localhost:8080-localhost-0]",
                        '{"arguments": {"host": "\'localhost\'", "port": "0", "server_name": "\'localhost:8080\'", "expect_host": "\'localhost\'", "expect_port": "0"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_run_defaults",
                        '{"arguments": {"matching": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_multi_route_rules",
                        '{"arguments": {"matching": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_subdomain_matching_other_name[True]",
                        '{"arguments": {"matching": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_subdomain_matching",
                        '{"arguments": {"propagate_exceptions": "False", "use_reloader": "False", "use_debugger": "False", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_no_setup_after_first_request",
                        '{"arguments": {"propagate_exceptions": "False", "use_reloader": "False", "use_debugger": "False", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_url_processors",
                        '{"arguments": {"propagate_exceptions": "False", "use_reloader": "False", "use_debugger": "False", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[False-False-False-False]",
                        '{"arguments": {"propagate_exceptions": "False", "use_reloader": "False", "use_debugger": "False", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[False-False-True-False]",
                        '{"arguments": {"propagate_exceptions": "False", "use_reloader": "False", "use_debugger": "True", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[False-False-True-True]",
                        '{"arguments": {"propagate_exceptions": "False", "use_reloader": "False", "use_debugger": "True", "debug": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[False-True-False-False]",
                        '{"arguments": {"propagate_exceptions": "False", "use_reloader": "True", "use_debugger": "False", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[True-False-False-False]",
                        '{"arguments": {"propagate_exceptions": "True", "use_reloader": "False", "use_debugger": "False", "debug": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[True-True-False-True]",
                        '{"arguments": {"propagate_exceptions": "True", "use_reloader": "True", "use_debugger": "False", "debug": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_werkzeug_passthrough_errors[True-True-True-True]",
                        '{"arguments": {"propagate_exceptions": "True", "use_reloader": "True", "use_debugger": "True", "debug": "True"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_request_locals",
                        '{"arguments": {"compact": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_static_url_empty_path",
                        '{"arguments": {"compact": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_jsonify_args_and_kwargs_check",
                        '{"arguments": {"compact": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_jsonify_mimetype",
                        '{"arguments": {"compact": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_make_response",
                        '{"arguments": {"debug": "False", "trap": "True", "expect_key": "False", "expect_abort": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_response_type_errors",
                        '{"arguments": {"debug": "False", "trap": "True", "expect_key": "False", "expect_abort": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_response_types",
                        '{"arguments": {"debug": "False", "trap": "True", "expect_key": "False", "expect_abort": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_error_handler_after_processor_error",
                        '{"arguments": {"debug": "False", "trap": "True", "expect_key": "False", "expect_abort": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_trapping_of_all_http_exceptions",
                        '{"arguments": {"debug": "False", "trap": "True", "expect_key": "False", "expect_abort": "False"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_before_request_and_routing_errors",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_baseexception_error_handling",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_after_request_processing",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_flashes",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_disallow_string_for_allowed_methods",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_method_route_no_methods",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_method_route[patch]",
                        '{"arguments": {"method": "\'patch\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_options_on_multiple_rules",
                        '{"arguments": {"path": "\'/bp/error\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_basic.py",
                        "test_options_work",
                        '{"arguments": {"path": "\'/bp/error\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_async.py",
                        "test_async_before_after_request",
                        '{"arguments": {"path": "\'/bp/error\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_async.py",
                        "test_async_error_handler[/error]",
                        '{"arguments": {"path": "\'/error\'"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_async.py",
                        "test_async_route[/]",
                        '{"arguments": {"path": "\'/\'"}, "metadata": {}}',
                    ),
                    ("tests", "test_appctx.py", "test_clean_pop"),
                    ("tests", "test_appctx.py", "test_custom_app_ctx_globals_class"),
                    ("tests", "test_appctx.py", "test_app_ctx_globals_methods"),
                    ("tests", "test_appctx.py", "test_app_tearing_down"),
                    ("tests", "test_appctx.py", "test_app_context_provides_current_app"),
                    ("tests", "test_appctx.py", "test_url_generation_without_context_fails"),
                    ("tests", "test_appctx.py", "test_basic_url_generation"),
                    (
                        "tests",
                        "test_user_error_handler.py",
                        "test_error_handler_subclass",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_cli_runner_class",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_json_request_and_response",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_test_client_context_binding",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_session_transactions_no_null_sessions",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_path_is_url",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_environ_base_modified",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_custom_template_loader",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_test_with_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_test_with_name",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_test_with_name",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_filter_with_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_subclassing.py",
                        "test_suppressed_exception_logging",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_flash_signal",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_before_render_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_context_test",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_proper_test_request_context",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_teardown_with_handled_exception",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_teardown_on_pop",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_logging.py",
                        "test_logger_debug",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_logging.py",
                        "test_logger",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 17, 8, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_json_tag.py",
                        "test_dump_load_unchanged[data8]",
                        '{"arguments": {"data": "UUID(\'730a38a4-d61c-4f6a-95b1-2b4f687dc9fc\')"}, "metadata": {}}',
                    ),
                    ("tests", "test_helpers.py", "test_stream_keeps_session"),
                    ("tests", "test_helpers.py", "test_abort_no_app"),
                    ("tests", "test_helpers.py", "test_send_from_directory"),
                    (
                        "tests",
                        "test_testing.py",
                        "test_json_request_and_response",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_session_transactions_keep_context",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_environ_base_modified",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_environ_base_default",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_testing.py",
                        "test_environ_defaults_from_config",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_custom_jinja_env",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_custom_template_loader",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_test_with_name_and_template",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_test_with_name",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_add_template_filter",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_template_filter",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_templating.py",
                        "test_standard_context",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_flash_signal",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_request_exception_signal",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_signals.py",
                        "test_request_signals",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_session_interface.py",
                        "test_open_session_with_endpoint",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_reqctx.py",
                        "test_session_dynamic_cookie_name",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_logging.py",
                        "test_has_level_handler",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_logging.py",
                        "test_existing_handler",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    (
                        "tests",
                        "test_logging.py",
                        "test_logger_debug",
                        '{"arguments": {"data": "datetime.datetime(2024, 9, 4, 12, 15, 52, tzinfo=datetime.timezone.utc)"}, "metadata": {}}',
                    ),
                    ("tests", "test_blueprints.py", "test_nested_blueprint"),
                    ("tests", "test_blueprints.py", "test_request_processing"),
                    ("tests", "test_blueprints.py", "test_template_global"),
                    ("tests", "test_blueprints.py", "test_context_processing"),
                    ("tests", "test_views.py", "test_implicit_head"),
                    ("tests", "test_views.py", "test_view_inheritance"),
                    ("tests", "test_user_error_handler.py", "test_default_error_handler"),
                    ("tests", "test_testing.py", "test_full_url_request"),
                    ("tests", "test_testing.py", "test_test_client_context_binding"),
                    ("tests", "test_testing.py", "test_session_transactions"),
                    ("tests", "test_testing.py", "test_specify_url_scheme"),
                    ("tests", "test_templating.py", "test_templates_auto_reload_debug_run"),
                    ("tests", "test_templating.py", "test_custom_template_loader"),
                    ("tests", "test_templating.py", "test_add_template_test_with_name_and_template"),
                    ("tests", "test_templating.py", "test_template_test_with_name_and_template"),
                    ("tests", "test_templating.py", "test_add_template_test_with_template"),
                    ("tests", "test_templating.py", "test_template_test_with_name"),
                    ("tests", "test_templating.py", "test_add_template_filter_with_name"),
                    ("tests", "test_templating.py", "test_template_filter_with_name"),
                    ("tests", "test_templating.py", "test_simple_stream"),
                    ("tests", "test_subclassing.py", "test_suppressed_exception_logging"),
                    ("tests", "test_signals.py", "test_request_exception_signal"),
                    ("tests", "test_signals.py", "test_before_render_template"),
                    ("tests", "test_signals.py", "test_template_rendered"),
                    ("tests", "test_reqctx.py", "test_bad_environ_raises_bad_request"),
                    ("tests", "test_reqctx.py", "test_session_dynamic_cookie_name"),
                    ("tests", "test_reqctx.py", "test_session_error_pops_context"),
                    ("tests", "test_logging.py", "test_logger_debug"),
                    ("tests", "test_json_tag.py", "test_custom_tag"),
                    ("tests", "test_json.py", "test_tojson_filter"),
                    ("tests", "test_json.py", "test_json_attr"),
                    ("tests", "test_json.py", "test_jsonify_uuid_types"),
                    ("tests", "test_json.py", "test_jsonify_dicts"),
                    ("tests", "test_json.py", "test_json_custom_mimetypes"),
                    ("tests", "test_instance_config.py", "test_uninstalled_namespace_paths"),
                    ("tests", "test_config.py", "test_config_missing"),
                    ("tests", "test_config.py", "test_config_from_envvar"),
                    ("tests", "test_config.py", "test_from_prefixed_env_nested"),
                    ("tests", "test_cli.py", "test_run_exclude_patterns"),
                    ("tests", "test_cli.py", "test_run_cert_import"),
                    ("tests", "test_cli.py", "test_run_cert_adhoc"),
                    ("tests", "test_cli.py", "test_dotenv_path"),
                    ("tests", "test_cli.py", "test_host"),
                    ("tests", "test_cli.py", "test_subdomain"),
                    ("tests", "test_cli.py", "test_no_routes"),
                    ("tests", "test_cli.py", "test_sort"),
                    ("tests", "test_cli.py", "test_simple"),
                    ("tests", "test_cli.py", "test_flaskgroup_nested"),
                    ("tests", "test_cli.py", "test_scriptinfo"),
                    ("tests", "test_cli.py", "test_find_best_app"),
                    ("tests", "test_blueprints.py", "test_template_test_with_template"),
                    ("tests", "test_blueprints.py", "test_add_template_filter_with_name"),
                    ("tests", "test_blueprints.py", "test_add_template_filter"),
                    ("tests", "test_blueprints.py", "test_endpoint_decorator"),
                    ("tests", "test_blueprints.py", "test_dotted_names_from_app"),
                    ("tests", "test_blueprints.py", "test_templates_list"),
                    ("tests", "test_blueprints.py", "test_blueprint_url_processors"),
                    ("tests", "test_basic.py", "test_app_freed_on_zero_refcount"),
                    ("tests", "test_basic.py", "test_run_server_port"),
                    ("tests", "test_basic.py", "test_run_defaults"),
                    ("tests", "test_basic.py", "test_no_setup_after_first_request"),
                    ("tests", "test_basic.py", "test_request_locals"),
                    ("tests", "test_basic.py", "test_static_url_empty_path"),
                    ("tests", "test_basic.py", "test_build_error_handler_reraise"),
                    ("tests", "test_basic.py", "test_jsonify_mimetype"),
                    ("tests", "test_basic.py", "test_make_response_with_response_instance"),
                    ("tests", "test_basic.py", "test_make_response"),
                    ("tests", "test_basic.py", "test_response_types"),
                    ("tests", "test_basic.py", "test_errorhandler_precedence"),
                    ("tests", "test_basic.py", "test_http_error_subclass_handling"),
                    ("tests", "test_basic.py", "test_session_refresh_vary"),
                    ("tests", "test_basic.py", "test_missing_session"),
                    ("tests", "test_basic.py", "test_session_using_samesite_attribute"),
                    ("tests", "test_basic.py", "test_endpoint_decorator"),
                    ("tests", "test_basic.py", "test_disallow_string_for_allowed_methods"),
                    ("tests", "test_basic.py", "test_request_dispatching"),
                    ("tests", "test_basic.py", "test_options_work"),
                    ("tests", "test_async.py", "test_async_before_after_request"),
                ]
            ),
        )
        client = self._get_test_client()
        with mock.patch.object(client, "_do_request", return_value=Response(200, skippable_response)):
            actual_skippable_items = client.fetch_skippable_items()
            assert actual_skippable_items == expected_skippable_items

    def test_civisibility_api_client_skippable_real_flask_scenario_test_level_without_parameters(self):
        """Tests a once-captured real world response from a flask project in suite-skipping mode

        NOTE: this ignores coverage data for the sake of expediency.
        """
        with open(os.path.join(os.path.dirname(__file__), "real_world_skippable_response_flask_test_level.json")) as f:
            skippable_response = f.read()

        expected_skippable_items = ITRData(
            correlation_id="4e70ba1f19491bd7a08f17044b1cce28",
            covered_files={},
            skippable_items=_make_fqdn_test_ids(
                [
                    ("tests", "test_json_tag.py", "test_custom_tag"),
                    ("tests", "test_json.py", "test_json_bad_requests"),
                    ("tests", "test_views.py", "test_remove_method_from_parent"),
                    ("tests", "test_views.py", "test_method_based_view"),
                    ("tests", "test_testing.py", "test_client_pop_all_preserved"),
                    ("tests", "test_testing.py", "test_full_url_request"),
                    ("tests", "test_testing.py", "test_session_transaction_needs_cookies"),
                    ("tests", "test_testing.py", "test_session_transactions"),
                    ("tests", "test_testing.py", "test_specify_url_scheme"),
                    ("tests", "test_testing.py", "test_client_open_environ"),
                    ("tests", "test_testing.py", "test_environ_defaults_from_config"),
                    ("tests", "test_templating.py", "test_custom_jinja_env"),
                    ("tests", "test_templating.py", "test_templates_auto_reload"),
                    ("tests", "test_templating.py", "test_add_template_test"),
                    ("tests", "test_templating.py", "test_add_template_filter_with_name_and_template"),
                    ("tests", "test_templating.py", "test_add_template_filter"),
                    ("tests", "test_templating.py", "test_request_less_rendering"),
                    ("tests", "test_templating.py", "test_simple_stream"),
                    ("tests", "test_templating.py", "test_context_processing"),
                    ("tests", "test_reqctx.py", "test_environ_for_valid_idna_completes"),
                    ("tests", "test_reqctx.py", "test_session_error_pops_context"),
                    ("tests", "test_reqctx.py", "test_context_binding"),
                    ("tests", "test_reqctx.py", "test_proper_test_request_context"),
                    ("tests", "test_reqctx.py", "test_teardown_with_handled_exception"),
                    ("tests", "test_logging.py", "test_log_view_exception"),
                    ("tests", "test_json.py", "test_json_customization"),
                    ("tests", "test_json.py", "test_jsonify_aware_datetimes[tz1]"),
                    ("tests", "test_json.py", "test_jsonify_datetime[value1]"),
                    ("tests", "test_json.py", "test_jsonify_basic_types[s]"),
                    ("tests", "test_json.py", "test_jsonify_basic_types[3.14]"),
                    ("tests", "test_json.py", "test_jsonify_basic_types[0]"),
                    ("tests", "test_json.py", "test_json_custom_mimetypes"),
                    ("tests", "test_json.py", "test_bad_request_debug_message[False]"),
                    ("tests", "test_instance_config.py", "test_prefix_package_paths[False]"),
                    ("tests", "test_instance_config.py", "test_installed_package_paths[False]"),
                    ("tests", "test_instance_config.py", "test_installed_module_paths[False]"),
                    ("tests", "test_helpers.py", "test_open_resource_with_encoding[utf-16-le]"),
                    ("tests", "test_helpers.py", "test_open_resource_exceptions[r+]"),
                    ("tests", "test_helpers.py", "test_open_resource_exceptions[x]"),
                    ("tests", "test_helpers.py", "test_make_response"),
                    ("tests", "test_helpers.py", "test_abort_no_app"),
                    ("tests", "test_helpers.py", "test_redirect_with_app"),
                    ("tests", "test_helpers.py", "test_url_with_method"),
                    ("tests", "test_config.py", "test_from_pyfile_weird_encoding[iso-8859-15]"),
                    ("tests", "test_config.py", "test_config_from_mapping"),
                    ("tests", "test_config.py", "test_config_from_file_toml"),
                    ("tests", "test_config.py", "test_config_from_object"),
                    ("tests", "test_cli.py", "test_disable_dotenv_from_env"),
                    ("tests", "test_cli.py", "test_all_methods"),
                    ("tests", "test_cli.py", "test_help_echo_exception"),
                    ("tests", "test_cli.py", "test_help_echo_loading_error"),
                    ("tests", "test_cli.py", "test_flaskgroup_nested"),
                    ("tests", "test_cli.py", "test_scriptinfo"),
                    (
                        "tests",
                        "test_cli.py",
                        'test_locate_app[cliapp.factory-create_app2("foo", "bar", )-app2_foo_bar]',
                    ),
                    ("tests", "test_cli.py", "test_locate_app[cliapp.factory-create_app()-app]"),
                    ("tests", "test_cli.py", "test_locate_app[cliapp.factory-None-app]"),
                    ("tests", "test_cli.py", "test_locate_app[cliapp.app-None-testapp]"),
                    ("tests", "test_cli.py", "test_prepare_import[test.a.b-path7-test.a.b]"),
                    ("tests", "test_cli.py", "test_prepare_import[value5-path5-cliapp.inner1]"),
                    ("tests", "test_cli.py", "test_prepare_import[test.py-path1-test]"),
                    ("tests", "test_blueprints.py", "test_nesting_url_prefixes[/other-/something-/parent-/child]"),
                    ("tests", "test_blueprints.py", "test_add_template_test_with_name_and_template"),
                    ("tests", "test_blueprints.py", "test_template_test_after_route_with_template"),
                    ("tests", "test_blueprints.py", "test_template_test_with_template"),
                    ("tests", "test_blueprints.py", "test_add_template_test"),
                    ("tests", "test_blueprints.py", "test_template_filter_with_name"),
                    ("tests", "test_blueprints.py", "test_blueprint_prefix_slash[/foo/-//bar-/foo/bar]"),
                    ("tests", "test_blueprints.py", "test_blueprint_prefix_slash[/foo/-bar-/foo/bar]"),
                    ("tests", "test_basic.py", "test_run_from_config[None-None-localhost:8080-localhost-8080]"),
                    ("tests", "test_basic.py", "test_run_from_config[localhost-None-pocoo.org:8080-localhost-8080]"),
                    ("tests", "test_basic.py", "test_run_from_config[None-None-pocoo.org:8080-pocoo.org-8080]"),
                    ("tests", "test_basic.py", "test_run_server_port"),
                    ("tests", "test_basic.py", "test_subdomain_basic_support"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[False-False-False-True]"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[True-False-True-False]"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[True-False-True-True]"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[True-True-False-False]"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[None-True-False-False]"),
                    ("tests", "test_basic.py", "test_exception_propagation[None]"),
                    ("tests", "test_basic.py", "test_server_name_subdomain"),
                    ("tests", "test_basic.py", "test_static_folder_with_pathlib_path"),
                    ("tests", "test_basic.py", "test_static_url_empty_path_default"),
                    ("tests", "test_basic.py", "test_url_for_passes_special_values_to_build_error_handler"),
                    ("tests", "test_basic.py", "test_build_error_handler_reraise"),
                    ("tests", "test_basic.py", "test_url_generation"),
                    ("tests", "test_basic.py", "test_jsonify_no_prettyprint[True]"),
                    ("tests", "test_basic.py", "test_make_response_with_response_instance"),
                    ("tests", "test_basic.py", "test_trap_bad_request_key_error[True-None-False-True]"),
                    ("tests", "test_basic.py", "test_http_error_subclass_handling"),
                    ("tests", "test_basic.py", "test_error_handling_processing"),
                    ("tests", "test_basic.py", "test_teardown_request_handler_debug_mode"),
                    ("tests", "test_basic.py", "test_session_refresh_vary"),
                    ("tests", "test_basic.py", "test_missing_session"),
                    ("tests", "test_basic.py", "test_session_using_application_root"),
                    ("tests", "test_basic.py", "test_session_path"),
                    ("tests", "test_basic.py", "test_url_mapping"),
                    ("tests", "test_basic.py", "test_provide_automatic_options_kwarg"),
                    ("tests", "test_basic.py", "test_method_route[get]"),
                    ("tests", "test_async.py", "test_async_error_handler[/bp/error]"),
                    ("tests", "test_async.py", "test_async_route[/methodview]"),
                    ("tests", "test_user_error_handler.py", "test_error_handler_no_match"),
                    ("tests", "test_testing.py", "test_nosubdomain"),
                    ("tests", "test_testing.py", "test_client_json_no_app_context"),
                    ("tests", "test_testing.py", "test_session_transaction_needs_cookies"),
                    ("tests", "test_testing.py", "test_session_transactions_keep_context"),
                    ("tests", "test_testing.py", "test_specify_url_scheme"),
                    ("tests", "test_testing.py", "test_environ_defaults"),
                    ("tests", "test_templating.py", "test_iterable_loader"),
                    ("tests", "test_templating.py", "test_add_template_test_with_name_and_template"),
                    ("tests", "test_templating.py", "test_template_test_with_name_and_template"),
                    ("tests", "test_templating.py", "test_template_filter"),
                    ("tests", "test_templating.py", "test_request_less_rendering"),
                    ("tests", "test_templating.py", "test_simple_stream"),
                    ("tests", "test_signals.py", "test_appcontext_tearing_down_signal"),
                    ("tests", "test_session_interface.py", "test_open_session_with_endpoint"),
                    ("tests", "test_reqctx.py", "test_environ_for_valid_idna_completes"),
                    ("tests", "test_reqctx.py", "test_context_binding"),
                    ("tests", "test_reqctx.py", "test_teardown_with_previous_exception"),
                    ("tests", "test_helpers.py", "test_streaming_with_context_as_decorator"),
                    ("tests", "test_helpers.py", "test_redirect_with_app"),
                    ("tests", "test_helpers.py", "test_url_for_with_self"),
                    ("tests", "test_helpers.py", "test_url_for_with_scheme"),
                    ("tests", "test_helpers.py", "test_static_file"),
                    ("tests", "test_helpers.py", "test_send_file"),
                    ("tests", "test_converters.py", "test_context_available"),
                    ("tests", "test_user_error_handler.py", "test_error_handler_subclass"),
                    ("tests", "test_testing.py", "test_client_pop_all_preserved"),
                    ("tests", "test_testing.py", "test_cli_invoke"),
                    ("tests", "test_testing.py", "test_nosubdomain"),
                    ("tests", "test_testing.py", "test_client_json_no_app_context"),
                    ("tests", "test_testing.py", "test_session_transactions_no_null_sessions"),
                    ("tests", "test_testing.py", "test_redirect_keep_session"),
                    ("tests", "test_testing.py", "test_blueprint_with_subdomain"),
                    ("tests", "test_testing.py", "test_environbuilder_json_dumps"),
                    ("tests", "test_testing.py", "test_specify_url_scheme"),
                    ("tests", "test_templating.py", "test_add_template_test_with_template"),
                    ("tests", "test_templating.py", "test_template_test"),
                    ("tests", "test_templating.py", "test_template_filter_with_template"),
                    ("tests", "test_templating.py", "test_escaping"),
                    ("tests", "test_signals.py", "test_appcontext_signals"),
                    ("tests", "test_signals.py", "test_before_render_template"),
                    ("tests", "test_reqctx.py", "test_normal_environ_completes"),
                    ("tests", "test_reqctx.py", "test_environ_for_valid_idna_completes"),
                    ("tests", "test_reqctx.py", "test_context_test"),
                    ("tests", "test_reqctx.py", "test_context_binding"),
                    ("tests", "test_logging.py", "test_log_view_exception"),
                    ("tests", "test_logging.py", "test_wsgi_errors_stream"),
                    ("tests", "test_json_tag.py", "test_tag_order"),
                    ("tests", "test_json_tag.py", "test_duplicate_tag"),
                    ("tests", "test_views.py", "test_view_provide_automatic_options_attr"),
                    ("tests", "test_user_error_handler.py", "test_handle_generic"),
                    ("tests", "test_testing.py", "test_reuse_client"),
                    ("tests", "test_testing.py", "test_session_transaction_needs_cookies"),
                    ("tests", "test_testing.py", "test_session_transactions_keep_context"),
                    ("tests", "test_testing.py", "test_client_open_environ"),
                    ("tests", "test_templating.py", "test_template_loader_debugging"),
                    ("tests", "test_templating.py", "test_templates_auto_reload"),
                    ("tests", "test_templating.py", "test_add_template_global"),
                    ("tests", "test_templating.py", "test_template_test_with_template"),
                    ("tests", "test_templating.py", "test_add_template_filter_with_name_and_template"),
                    ("tests", "test_templating.py", "test_template_filter_with_template"),
                    ("tests", "test_templating.py", "test_escaping_without_template_filename"),
                    ("tests", "test_templating.py", "test_context_processing"),
                    ("tests", "test_signals.py", "test_request_signals"),
                    ("tests", "test_reqctx.py", "test_teardown_with_handled_exception"),
                    ("tests", "test_logging.py", "test_wsgi_errors_stream"),
                    ("tests", "test_json_tag.py", "test_duplicate_tag"),
                    ("tests", "test_json.py", "test_json_decimal"),
                    ("tests", "test_json.py", "test_json_bad_requests"),
                    ("tests", "test_instance_config.py", "test_uninstalled_module_paths"),
                    ("tests", "test_instance_config.py", "test_explicit_instance_paths"),
                    ("tests", "test_config.py", "test_config_from_envvar_missing"),
                    ("tests", "test_config.py", "test_config_from_mapping"),
                    ("tests", "test_cli.py", "test_cli_empty"),
                    ("tests", "test_cli.py", "test_help_echo_exception"),
                    ("tests", "test_cli.py", "test_app_cli_has_app_context"),
                    ("tests", "test_cli.py", "test_get_version"),
                    ("tests", "test_blueprints.py", "test_nesting_subdomains"),
                    ("tests", "test_blueprints.py", "test_add_template_test"),
                    ("tests", "test_blueprints.py", "test_template_test"),
                    ("tests", "test_blueprints.py", "test_add_template_filter_with_template"),
                    ("tests", "test_blueprints.py", "test_template_filter"),
                    ("tests", "test_blueprints.py", "test_route_decorator_custom_endpoint_with_dots"),
                    ("tests", "test_blueprints.py", "test_blueprint_specific_user_error_handling"),
                    ("tests", "test_blueprints.py", "test_blueprint_specific_error_handling"),
                    ("tests", "test_basic.py", "test_multi_route_rules"),
                    ("tests", "test_basic.py", "test_get_method_on_g"),
                    ("tests", "test_basic.py", "test_nonascii_pathinfo"),
                    ("tests", "test_basic.py", "test_inject_blueprint_url_defaults"),
                    ("tests", "test_basic.py", "test_max_content_length"),
                    ("tests", "test_basic.py", "test_server_name_subdomain"),
                    ("tests", "test_basic.py", "test_static_route_with_host_matching"),
                    ("tests", "test_basic.py", "test_static_folder_with_ending_slash"),
                    ("tests", "test_basic.py", "test_static_url_path_with_ending_slash"),
                    ("tests", "test_basic.py", "test_url_for_passes_special_values_to_build_error_handler"),
                    ("tests", "test_basic.py", "test_url_generation"),
                    ("tests", "test_basic.py", "test_error_handling"),
                    ("tests", "test_basic.py", "test_teardown_request_handler_error"),
                    ("tests", "test_basic.py", "test_request_processing"),
                    ("tests", "test_basic.py", "test_flashes"),
                    ("tests", "test_basic.py", "test_session_cookie_setting"),
                    ("tests", "test_basic.py", "test_session_special_types"),
                    ("tests", "test_basic.py", "test_session_stored_last"),
                    ("tests", "test_basic.py", "test_session_expiration"),
                    ("tests", "test_basic.py", "test_session_using_session_settings"),
                    ("tests", "test_basic.py", "test_session"),
                    ("tests", "test_basic.py", "test_provide_automatic_options_kwarg"),
                    ("tests", "test_json_tag.py", "test_dump_load_unchanged[data8]"),
                    ("tests", "test_views.py", "test_methods_var_inheritance"),
                    ("tests", "test_views.py", "test_explicit_head"),
                    ("tests", "test_views.py", "test_view_patching"),
                    ("tests", "test_views.py", "test_basic_view"),
                    ("tests", "test_user_error_handler.py", "test_handle_generic"),
                    ("tests", "test_user_error_handler.py", "test_default_error_handler"),
                    ("tests", "test_testing.py", "test_cli_custom_obj"),
                    ("tests", "test_testing.py", "test_cli_runner_class"),
                    ("tests", "test_testing.py", "test_subdomain"),
                    ("tests", "test_testing.py", "test_client_json_no_app_context"),
                    ("tests", "test_testing.py", "test_test_client_context_binding"),
                    ("tests", "test_testing.py", "test_session_transactions_no_null_sessions"),
                    ("tests", "test_testing.py", "test_blueprint_with_subdomain"),
                    ("tests", "test_testing.py", "test_environbuilder_json_dumps"),
                    ("tests", "test_testing.py", "test_path_is_url"),
                    ("tests", "test_testing.py", "test_environ_base_modified"),
                    ("tests", "test_templating.py", "test_add_template_global"),
                    ("tests", "test_templating.py", "test_template_filter_with_name_and_template"),
                    ("tests", "test_templating.py", "test_template_filter_with_template"),
                    ("tests", "test_templating.py", "test_template_filter_with_name"),
                    ("tests", "test_templating.py", "test_escaping_without_template_filename"),
                    ("tests", "test_templating.py", "test_no_escaping"),
                    ("tests", "test_templating.py", "test_standard_context"),
                    ("tests", "test_subclassing.py", "test_suppressed_exception_logging"),
                    ("tests", "test_reqctx.py", "test_normal_environ_completes"),
                    ("tests", "test_logging.py", "test_wsgi_errors_stream"),
                    ("tests", "test_json_tag.py", "test_tag_order"),
                    ("tests", "test_json_tag.py", "test_custom_tag"),
                    ("tests", "test_json_tag.py", "test_dump_load_unchanged[<html>]"),
                    ("tests", "test_json_tag.py", "test_dump_load_unchanged[data5]"),
                    ("tests", "test_json_tag.py", "test_dump_load_unchanged[data4]"),
                    ("tests", "test_json_tag.py", "test_dump_load_unchanged[data3]"),
                    ("tests", "test_json_tag.py", "test_dump_load_unchanged[data0]"),
                    ("tests", "test_json.py", "test_jsonify_aware_datetimes[tz0]"),
                    ("tests", "test_json.py", "test_jsonify_datetime[value0]"),
                    ("tests", "test_json.py", "test_jsonify_dicts"),
                    ("tests", "test_json.py", "test_jsonify_basic_types[longer string]"),
                    ("tests", "test_json.py", "test_jsonify_basic_types[23]"),
                    ("tests", "test_json.py", "test_jsonify_basic_types[-1]"),
                    ("tests", "test_json.py", 'test_json_as_unicode[False-"\\u2603"]'),
                    ("tests", "test_instance_config.py", "test_prefix_package_paths[True]"),
                    ("tests", "test_instance_config.py", "test_installed_module_paths[True]"),
                    ("tests", "test_instance_config.py", "test_uninstalled_namespace_paths"),
                    ("tests", "test_helpers.py", "test_open_resource_exceptions[w]"),
                    ("tests", "test_helpers.py", "test_open_resource[rt]"),
                    ("tests", "test_helpers.py", "test_open_resource[rb]"),
                    ("tests", "test_helpers.py", "test_open_resource[r]"),
                    ("tests", "test_helpers.py", "test_get_debug_flag[-False]"),
                    ("tests", "test_helpers.py", "test_streaming_with_context_as_decorator"),
                    ("tests", "test_helpers.py", "test_streaming_with_context"),
                    ("tests", "test_helpers.py", "test_name_with_import_error"),
                    ("tests", "test_helpers.py", "test_app_aborter_class"),
                    ("tests", "test_helpers.py", "test_url_for_with_scheme"),
                    ("tests", "test_helpers.py", "test_url_for_with_anchor"),
                    ("tests", "test_helpers.py", "test_static_file"),
                    ("tests", "test_config.py", "test_get_namespace"),
                    ("tests", "test_config.py", "test_session_lifetime"),
                    ("tests", "test_config.py", "test_config_missing_file"),
                    ("tests", "test_config.py", "test_config_from_envvar"),
                    ("tests", "test_config.py", "test_from_prefixed_env_nested"),
                    ("tests", "test_config.py", "test_config_from_file_json"),
                    ("tests", "test_cli.py", "test_run_cert_no_ssl"),
                    ("tests", "test_cli.py", "test_run_cert_import"),
                    ("tests", "test_cli.py", "test_load_dotenv"),
                    ("tests", "test_cli.py", "test_host"),
                    ("tests", "test_cli.py", "test_subdomain"),
                    ("tests", "test_cli.py", "test_no_command_echo_loading_error"),
                    ("tests", "test_cli.py", "test_flaskgroup_debug[True]"),
                    ("tests", "test_cli.py", "test_flaskgroup_app_context"),
                    ("tests", "test_cli.py", "test_appgroup_app_context"),
                    ("tests", "test_cli.py", "test_app_cli_has_app_context"),
                    ("tests", "test_cli.py", 'test_locate_app_raises[cliapp.factory-create_app2("foo")]'),
                    ("tests", "test_cli.py", "test_locate_app[cliapp.factory-create_app-app]"),
                    ("tests", "test_cli.py", "test_locate_app[cliapp.app-testapp-testapp]"),
                    ("tests", "test_cli.py", "test_prepare_import[value9-path9-cliapp.message.txt]"),
                    ("tests", "test_cli.py", "test_prepare_import[value6-path6-cliapp.inner1.inner2]"),
                    ("tests", "test_cli.py", "test_cli_name"),
                    ("tests", "test_blueprints.py", "test_blueprint_renaming"),
                    ("tests", "test_blueprints.py", "test_unique_blueprint_names"),
                    ("tests", "test_blueprints.py", "test_app_url_processors"),
                    ("tests", "test_blueprints.py", "test_request_processing"),
                    ("tests", "test_blueprints.py", "test_template_test_with_name_and_template"),
                    ("tests", "test_blueprints.py", "test_add_template_test_with_template"),
                    ("tests", "test_blueprints.py", "test_template_filter_with_template"),
                    ("tests", "test_blueprints.py", "test_add_template_filter"),
                    ("tests", "test_blueprints.py", "test_template_filter"),
                    ("tests", "test_blueprints.py", "test_endpoint_decorator"),
                    ("tests", "test_blueprints.py", "test_default_static_max_age"),
                    ("tests", "test_blueprints.py", "test_blueprint_app_error_handling"),
                    ("tests", "test_blueprints.py", "test_blueprint_specific_user_error_handling"),
                    ("tests", "test_basic.py", "test_max_cookie_size"),
                    ("tests", "test_basic.py", "test_g_iteration_protocol"),
                    ("tests", "test_basic.py", "test_route_decorator_custom_endpoint"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[False-True-False-True]"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[False-True-True-False]"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[None-False-True-False]"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[None-False-True-True]"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[None-True-False-True]"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[None-True-True-False]"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[None-True-True-True]"),
                    ("tests", "test_basic.py", "test_exception_propagation[DEBUG]"),
                    ("tests", "test_basic.py", "test_exception_propagation[PROPAGATE_EXCEPTIONS]"),
                    ("tests", "test_basic.py", "test_static_url_path_with_ending_slash"),
                    ("tests", "test_basic.py", "test_static_url_path"),
                    ("tests", "test_basic.py", "test_static_files"),
                    ("tests", "test_basic.py", "test_build_error_handler"),
                    ("tests", "test_basic.py", "test_enctype_debug_helper"),
                    ("tests", "test_basic.py", "test_trap_bad_request_key_error[False-True-False-False]"),
                    ("tests", "test_basic.py", "test_errorhandler_precedence"),
                    ("tests", "test_basic.py", "test_request_processing"),
                    ("tests", "test_basic.py", "test_extended_flashing"),
                    ("tests", "test_basic.py", "test_session_cookie_setting"),
                    ("tests", "test_basic.py", "test_session_special_types"),
                    ("tests", "test_basic.py", "test_session_stored_last"),
                    ("tests", "test_basic.py", "test_session_expiration"),
                    ("tests", "test_basic.py", "test_session_using_session_settings"),
                    ("tests", "test_basic.py", "test_session"),
                    ("tests", "test_basic.py", "test_endpoint_decorator"),
                    ("tests", "test_basic.py", "test_werkzeug_routing"),
                    ("tests", "test_basic.py", "test_request_dispatching"),
                    ("tests", "test_basic.py", "test_provide_automatic_options_attr"),
                    ("tests", "test_async.py", "test_async_route[/home]"),
                    ("tests", "test_appctx.py", "test_app_tearing_down_with_handled_exception_by_app_handler"),
                    ("tests", "test_appctx.py", "test_app_tearing_down_with_handled_exception_by_except_block"),
                    ("tests", "test_appctx.py", "test_app_tearing_down_with_previous_exception"),
                    ("tests", "test_user_error_handler.py", "test_default_error_handler"),
                    ("tests", "test_user_error_handler.py", "test_error_handler_blueprint"),
                    ("tests", "test_testing.py", "test_cli_custom_obj"),
                    ("tests", "test_testing.py", "test_cli_invoke"),
                    ("tests", "test_testing.py", "test_redirect_keep_session"),
                    ("tests", "test_testing.py", "test_client_open_environ"),
                    ("tests", "test_templating.py", "test_template_loader_debugging"),
                    ("tests", "test_templating.py", "test_templates_auto_reload"),
                    ("tests", "test_templating.py", "test_add_template_test_with_template"),
                    ("tests", "test_templating.py", "test_add_template_test"),
                    ("tests", "test_templating.py", "test_add_template_filter_with_name_and_template"),
                    ("tests", "test_templating.py", "test_template_filter_with_template"),
                    ("tests", "test_templating.py", "test_add_template_filter_with_name"),
                    ("tests", "test_templating.py", "test_add_template_filter"),
                    ("tests", "test_templating.py", "test_macros"),
                    ("tests", "test_templating.py", "test_escaping_without_template_filename"),
                    ("tests", "test_templating.py", "test_no_escaping"),
                    ("tests", "test_templating.py", "test_standard_context"),
                    ("tests", "test_templating.py", "test_original_win"),
                    ("tests", "test_templating.py", "test_context_processing"),
                    ("tests", "test_signals.py", "test_template_rendered"),
                    ("tests", "test_reqctx.py", "test_normal_environ_completes"),
                    ("tests", "test_reqctx.py", "test_bad_environ_raises_bad_request"),
                    ("tests", "test_reqctx.py", "test_session_dynamic_cookie_name"),
                    ("tests", "test_logging.py", "test_existing_handler"),
                    ("tests", "test_json_tag.py", "test_tag_interface"),
                    ("tests", "test_json_tag.py", "test_custom_tag"),
                    ("tests", "test_helpers.py", "test_streaming_with_context_and_custom_close"),
                    ("tests", "test_helpers.py", "test_streaming_with_context"),
                    ("tests", "test_helpers.py", "test_abort_with_app"),
                    ("tests", "test_helpers.py", "test_url_with_method"),
                    ("tests", "test_converters.py", "test_custom_converters"),
                    ("tests", "test_user_error_handler.py", "test_default_error_handler"),
                    ("tests", "test_user_error_handler.py", "test_error_handler_blueprint"),
                    ("tests", "test_user_error_handler.py", "test_error_handler_http_subclass"),
                    ("tests", "test_testing.py", "test_cli_custom_obj"),
                    ("tests", "test_testing.py", "test_cli_runner_class"),
                    ("tests", "test_testing.py", "test_full_url_request"),
                    ("tests", "test_testing.py", "test_test_client_context_binding"),
                    ("tests", "test_testing.py", "test_path_is_url"),
                    ("tests", "test_testing.py", "test_client_open_environ"),
                    ("tests", "test_testing.py", "test_environ_defaults"),
                    ("tests", "test_templating.py", "test_templates_auto_reload_debug_run"),
                    ("tests", "test_templating.py", "test_template_test_with_name_and_template"),
                    ("tests", "test_templating.py", "test_template_test_with_template"),
                    ("tests", "test_templating.py", "test_add_template_test"),
                    ("tests", "test_templating.py", "test_add_template_filter_with_name_and_template"),
                    ("tests", "test_templating.py", "test_macros"),
                    ("tests", "test_templating.py", "test_no_escaping"),
                    ("tests", "test_templating.py", "test_request_less_rendering"),
                    ("tests", "test_signals.py", "test_template_rendered"),
                    ("tests", "test_reqctx.py", "test_bad_environ_raises_bad_request"),
                    ("tests", "test_reqctx.py", "test_session_error_pops_context"),
                    ("tests", "test_reqctx.py", "test_manual_context_binding"),
                    ("tests", "test_reqctx.py", "test_proper_test_request_context"),
                    ("tests", "test_reqctx.py", "test_teardown_on_pop"),
                    ("tests", "test_regression.py", "test_aborting"),
                    ("tests", "test_logging.py", "test_logger"),
                    ("tests", "test_json_tag.py", "test_tag_interface"),
                    ("tests", "test_json_tag.py", "test_dump_load_unchanged[data8]"),
                    ("tests", "test_blueprints.py", "test_template_test_with_name_and_template"),
                    ("tests", "test_views.py", "test_init_once"),
                    ("tests", "test_views.py", "test_remove_method_from_parent"),
                    ("tests", "test_views.py", "test_multiple_inheritance"),
                    ("tests", "test_views.py", "test_methods_var_inheritance"),
                    ("tests", "test_views.py", "test_view_patching"),
                    ("tests", "test_views.py", "test_method_based_view"),
                    ("tests", "test_views.py", "test_basic_view"),
                    ("tests", "test_user_error_handler.py", "test_error_handler_no_match"),
                    ("tests", "test_testing.py", "test_cli_runner_class"),
                    ("tests", "test_testing.py", "test_path_is_url"),
                    ("tests", "test_testing.py", "test_environ_defaults"),
                    ("tests", "test_testing.py", "test_environ_defaults_from_config"),
                    ("tests", "test_templating.py", "test_add_template_test_with_name"),
                    ("tests", "test_templating.py", "test_add_template_test"),
                    ("tests", "test_templating.py", "test_template_test"),
                    ("tests", "test_templating.py", "test_add_template_filter_with_template"),
                    ("tests", "test_templating.py", "test_template_filter"),
                    ("tests", "test_templating.py", "test_request_less_rendering"),
                    ("tests", "test_signals.py", "test_appcontext_tearing_down_signal"),
                    ("tests", "test_signals.py", "test_appcontext_signals"),
                    ("tests", "test_reqctx.py", "test_environ_for_valid_idna_completes"),
                    ("tests", "test_reqctx.py", "test_manual_context_binding"),
                    ("tests", "test_reqctx.py", "test_context_binding"),
                    ("tests", "test_reqctx.py", "test_teardown_with_previous_exception"),
                    ("tests", "test_logging.py", "test_has_level_handler"),
                    ("tests", "test_logging.py", "test_existing_handler"),
                    ("tests", "test_logging.py", "test_logger"),
                    ("tests", "test_json_tag.py", "test_tag_order"),
                    ("tests", "test_json_tag.py", "test_dump_load_unchanged[data9]"),
                    ("tests", "test_json_tag.py", "test_dump_load_unchanged[data8]"),
                    ("tests", "test_json.py", "test_json_key_sorting"),
                    ("tests", "test_json.py", "test_json_customization"),
                    ("tests", "test_json.py", "test_jsonify_arrays"),
                    ("tests", "test_json.py", "test_json_dump_to_file"),
                    ("tests", "test_config.py", "test_get_namespace"),
                    ("tests", "test_config.py", "test_from_prefixed_env_custom_prefix"),
                    ("tests", "test_config.py", "test_config_from_object"),
                    ("tests", "test_cli.py", "test_cli_blueprints"),
                    ("tests", "test_cli.py", "test_disable_dotenv_from_env"),
                    ("tests", "test_cli.py", "test_dotenv_optional"),
                    ("tests", "test_cli.py", "test_load_dotenv"),
                    ("tests", "test_cli.py", "test_all_methods"),
                    ("tests", "test_cli.py", "test_help_echo_loading_error"),
                    ("tests", "test_cli.py", "test_appgroup_app_context"),
                    ("tests", "test_blueprints.py", "test_blueprint_renaming"),
                    ("tests", "test_blueprints.py", "test_unique_blueprint_names"),
                    ("tests", "test_blueprints.py", "test_template_test_after_route_with_template"),
                    ("tests", "test_blueprints.py", "test_template_filter_with_name_and_template"),
                    ("tests", "test_blueprints.py", "test_template_filter_after_route_with_template"),
                    ("tests", "test_blueprints.py", "test_template_filter_with_template"),
                    ("tests", "test_blueprints.py", "test_template_filter_with_name"),
                    ("tests", "test_blueprints.py", "test_route_decorator_custom_endpoint"),
                    ("tests", "test_blueprints.py", "test_empty_name_not_allowed"),
                    ("tests", "test_blueprints.py", "test_dotted_name_not_allowed"),
                    ("tests", "test_blueprints.py", "test_default_static_max_age"),
                    ("tests", "test_blueprints.py", "test_templates_and_static"),
                    ("tests", "test_blueprints.py", "test_blueprint_app_error_handling"),
                    ("tests", "test_basic.py", "test_max_cookie_size"),
                    ("tests", "test_basic.py", "test_subdomain_matching_with_ports"),
                    ("tests", "test_basic.py", "test_subdomain_basic_support"),
                    ("tests", "test_basic.py", "test_g_iteration_protocol"),
                    ("tests", "test_basic.py", "test_routing_redirect_debugging"),
                    ("tests", "test_basic.py", "test_static_folder_with_pathlib_path"),
                    ("tests", "test_basic.py", "test_static_files"),
                    ("tests", "test_basic.py", "test_build_error_handler"),
                    ("tests", "test_basic.py", "test_jsonify_args_and_kwargs_check"),
                    ("tests", "test_basic.py", "test_enctype_debug_helper"),
                    ("tests", "test_basic.py", "test_before_request_and_routing_errors"),
                    ("tests", "test_basic.py", "test_before_after_request_order"),
                    ("tests", "test_basic.py", "test_teardown_request_handler_debug_mode"),
                    ("tests", "test_basic.py", "test_after_request_processing"),
                    ("tests", "test_basic.py", "test_extended_flashing"),
                    ("tests", "test_basic.py", "test_session_path"),
                    ("tests", "test_basic.py", "test_provide_automatic_options_attr"),
                    ("tests", "test_basic.py", "test_options_on_multiple_rules"),
                    ("tests", "test_json_tag.py", "test_dump_load_unchanged[data9]"),
                    ("tests", "test_views.py", "test_view_provide_automatic_options_attr"),
                    ("tests", "test_views.py", "test_view_inheritance"),
                    ("tests", "test_user_error_handler.py", "test_handle_generic_http"),
                    ("tests", "test_user_error_handler.py", "test_error_handler_blueprint"),
                    ("tests", "test_user_error_handler.py", "test_error_handler_http_subclass"),
                    ("tests", "test_user_error_handler.py", "test_error_handler_no_match"),
                    ("tests", "test_testing.py", "test_cli_invoke"),
                    ("tests", "test_testing.py", "test_nosubdomain"),
                    ("tests", "test_testing.py", "test_json_request_and_response"),
                    ("tests", "test_testing.py", "test_reuse_client"),
                    ("tests", "test_testing.py", "test_environ_base_default"),
                    ("tests", "test_testing.py", "test_environ_defaults"),
                    ("tests", "test_templating.py", "test_templates_auto_reload_debug_run"),
                    ("tests", "test_templating.py", "test_iterable_loader"),
                    ("tests", "test_templating.py", "test_custom_template_loader"),
                    ("tests", "test_templating.py", "test_add_template_test_with_name_and_template"),
                    ("tests", "test_templating.py", "test_template_test_with_name_and_template"),
                    ("tests", "test_templating.py", "test_template_test_with_template"),
                    ("tests", "test_templating.py", "test_add_template_test_with_name"),
                    ("tests", "test_templating.py", "test_template_filter"),
                    ("tests", "test_templating.py", "test_escaping"),
                    ("tests", "test_signals.py", "test_appcontext_tearing_down_signal"),
                    ("tests", "test_signals.py", "test_request_signals"),
                    ("tests", "test_signals.py", "test_before_render_template"),
                    ("tests", "test_session_interface.py", "test_open_session_with_endpoint"),
                    ("tests", "test_reqctx.py", "test_bad_environ_raises_bad_request"),
                    ("tests", "test_reqctx.py", "test_session_dynamic_cookie_name"),
                    ("tests", "test_reqctx.py", "test_manual_context_binding"),
                    ("tests", "test_reqctx.py", "test_context_test"),
                    ("tests", "test_reqctx.py", "test_teardown_on_pop"),
                    ("tests", "test_regression.py", "test_aborting"),
                    ("tests", "test_logging.py", "test_has_level_handler"),
                    ("tests", "test_json_tag.py", "test_duplicate_tag"),
                    ("tests", "test_json_tag.py", "test_dump_load_unchanged[\\xff]"),
                    ("tests", "test_json.py", "test_html_method"),
                    ("tests", "test_json.py", "test_tojson_filter"),
                    ("tests", "test_json.py", "test_json_decimal"),
                    ("tests", "test_json.py", "test_jsonify_uuid_types"),
                    ("tests", "test_json.py", "test_jsonify_basic_types[None]"),
                    ("tests", "test_json.py", "test_jsonify_basic_types[1]"),
                    ("tests", "test_json.py", "test_json_dump_to_file"),
                    ("tests", "test_json.py", 'test_json_as_unicode[True-"\\\\u2603"]'),
                    ("tests", "test_json.py", "test_bad_request_debug_message[True]"),
                    ("tests", "test_instance_config.py", "test_installed_package_paths[True]"),
                    ("tests", "test_instance_config.py", "test_uninstalled_package_paths"),
                    ("tests", "test_instance_config.py", "test_uninstalled_module_paths"),
                    ("tests", "test_instance_config.py", "test_explicit_instance_paths"),
                    ("tests", "test_helpers.py", "test_open_resource_with_encoding[utf-8]"),
                    ("tests", "test_helpers.py", "test_open_resource_exceptions[a]"),
                    ("tests", "test_helpers.py", "test_get_debug_flag[False-False]"),
                    ("tests", "test_helpers.py", "test_get_debug_flag[0-False]"),
                    ("tests", "test_helpers.py", "test_streaming_with_context_and_custom_close"),
                    ("tests", "test_helpers.py", "test_url_for_with_self"),
                    ("tests", "test_helpers.py", "test_send_from_directory"),
                    ("tests", "test_converters.py", "test_context_available"),
                    ("tests", "test_converters.py", "test_custom_converters"),
                    ("tests", "test_config.py", "test_from_pyfile_weird_encoding[latin-1]"),
                    ("tests", "test_config.py", "test_from_pyfile_weird_encoding[utf-8]"),
                    ("tests", "test_config.py", "test_config_missing"),
                    ("tests", "test_config.py", "test_from_prefixed_env_custom_prefix"),
                    ("tests", "test_config.py", "test_from_prefixed_env"),
                    ("tests", "test_config.py", "test_config_from_pyfile"),
                    ("tests", "test_cli.py", "test_run_exclude_patterns"),
                    ("tests", "test_cli.py", "test_cli_blueprints"),
                    ("tests", "test_cli.py", "test_dotenv_optional"),
                    ("tests", "test_cli.py", "test_simple"),
                    ("tests", "test_cli.py", "test_locate_app_raises[cliapp.message.txt-None]"),
                    ("tests", "test_cli.py", "test_locate_app_raises[cliapp.factory-no_app]"),
                    ("tests", "test_cli.py", "test_locate_app_raises[cliapp/app-None]"),
                    ("tests", "test_cli.py", "test_prepare_import[a/test-path2-test]"),
                    ("tests", "test_cli.py", "test_prepare_import[test-path0-test]"),
                    ("tests", "test_cli.py", "test_find_best_app"),
                    ("tests", "test_blueprints.py", "test_nesting_url_prefixes[None-None-/parent-/child]"),
                    ("tests", "test_blueprints.py", "test_nesting_url_prefixes[/parent-/child-None-None]"),
                    ("tests", "test_blueprints.py", "test_nested_callback_order"),
                    ("tests", "test_blueprints.py", "test_add_template_test_with_name"),
                    ("tests", "test_blueprints.py", "test_template_test_with_name"),
                    ("tests", "test_blueprints.py", "test_template_filter_with_name_and_template"),
                    ("tests", "test_blueprints.py", "test_template_filter_after_route_with_template"),
                    ("tests", "test_blueprints.py", "test_add_template_filter_with_name"),
                    ("tests", "test_blueprints.py", "test_route_decorator_custom_endpoint_with_dots"),
                    ("tests", "test_blueprints.py", "test_route_decorator_custom_endpoint"),
                    ("tests", "test_blueprints.py", "test_dotted_name_not_allowed"),
                    ("tests", "test_blueprints.py", "test_templates_and_static"),
                    ("tests", "test_blueprints.py", "test_blueprint_url_processors"),
                    ("tests", "test_blueprints.py", "test_blueprint_prefix_slash[/foo//-/bar-/foo/bar]"),
                    ("tests", "test_blueprints.py", "test_blueprint_prefix_slash[/foo-/bar-/foo/bar]"),
                    ("tests", "test_blueprints.py", "test_blueprint_prefix_slash[-/bar-/bar]"),
                    ("tests", "test_blueprints.py", "test_blueprint_prefix_slash[/foo/--/foo/]"),
                    ("tests", "test_blueprints.py", "test_blueprint_prefix_slash[/foo--/foo]"),
                    ("tests", "test_blueprints.py", "test_blueprint_prefix_slash[/--/]"),
                    ("tests", "test_blueprints.py", "test_blueprint_specific_error_handling"),
                    ("tests", "test_basic.py", "test_run_from_config[None-None-localhost:0-localhost-0]"),
                    ("tests", "test_basic.py", "test_run_from_config[localhost-80-pocoo.org:8080-localhost-80]"),
                    ("tests", "test_basic.py", "test_run_from_config[None-80-pocoo.org:8080-pocoo.org-80]"),
                    ("tests", "test_basic.py", "test_multi_route_class_views"),
                    ("tests", "test_basic.py", "test_subdomain_matching_other_name[False]"),
                    ("tests", "test_basic.py", "test_subdomain_matching_with_ports"),
                    ("tests", "test_basic.py", "test_get_method_on_g"),
                    ("tests", "test_basic.py", "test_routing_redirect_debugging"),
                    ("tests", "test_basic.py", "test_nonascii_pathinfo"),
                    ("tests", "test_basic.py", "test_inject_blueprint_url_defaults"),
                    ("tests", "test_basic.py", "test_max_content_length"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[False-True-True-True]"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[True-False-False-True]"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[True-True-True-False]"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[None-False-False-False]"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[None-False-False-True]"),
                    ("tests", "test_basic.py", "test_exception_propagation[TESTING]"),
                    ("tests", "test_basic.py", "test_static_route_with_host_matching"),
                    ("tests", "test_basic.py", "test_static_folder_with_ending_slash"),
                    ("tests", "test_basic.py", "test_json_dump_dataclass"),
                    ("tests", "test_basic.py", "test_jsonify_no_prettyprint[False]"),
                    ("tests", "test_basic.py", "test_trap_bad_request_key_error[False-None-True-True]"),
                    ("tests", "test_basic.py", "test_user_error_handling"),
                    ("tests", "test_basic.py", "test_error_handling"),
                    ("tests", "test_basic.py", "test_before_after_request_order"),
                    ("tests", "test_basic.py", "test_teardown_request_handler_error"),
                    ("tests", "test_basic.py", "test_teardown_request_handler"),
                    ("tests", "test_basic.py", "test_request_preprocessing_early_return"),
                    ("tests", "test_basic.py", "test_session_vary_cookie"),
                    ("tests", "test_basic.py", "test_session_using_samesite_attribute"),
                    ("tests", "test_basic.py", "test_method_route[delete]"),
                    ("tests", "test_basic.py", "test_method_route[put]"),
                    ("tests", "test_basic.py", "test_method_route[post]"),
                    ("tests", "test_async.py", "test_async_route[/view]"),
                    ("tests", "test_async.py", "test_async_route[/bp/]"),
                    ("tests", "test_appctx.py", "test_context_refcounts"),
                    ("tests", "test_appctx.py", "test_app_tearing_down_with_unhandled_exception"),
                    ("tests", "test_appctx.py", "test_request_context_means_app_context"),
                    ("tests", "test_appctx.py", "test_url_generation_requires_server_name"),
                    ("tests", "test_user_error_handler.py", "test_error_handler_http_subclass"),
                    ("tests", "test_testing.py", "test_client_pop_all_preserved"),
                    ("tests", "test_testing.py", "test_subdomain"),
                    ("tests", "test_testing.py", "test_full_url_request"),
                    ("tests", "test_testing.py", "test_reuse_client"),
                    ("tests", "test_testing.py", "test_session_transactions"),
                    ("tests", "test_testing.py", "test_blueprint_with_subdomain"),
                    ("tests", "test_testing.py", "test_environbuilder_json_dumps"),
                    ("tests", "test_testing.py", "test_environ_base_default"),
                    ("tests", "test_testing.py", "test_environ_defaults_from_config"),
                    ("tests", "test_templating.py", "test_custom_jinja_env"),
                    ("tests", "test_templating.py", "test_templates_auto_reload_debug_run"),
                    ("tests", "test_templating.py", "test_add_template_global"),
                    ("tests", "test_templating.py", "test_template_test"),
                    ("tests", "test_templating.py", "test_template_filter_with_name_and_template"),
                    ("tests", "test_templating.py", "test_template_filter_with_name"),
                    ("tests", "test_templating.py", "test_escaping"),
                    ("tests", "test_signals.py", "test_appcontext_signals"),
                    ("tests", "test_signals.py", "test_request_exception_signal"),
                    ("tests", "test_signals.py", "test_request_signals"),
                    ("tests", "test_reqctx.py", "test_session_error_pops_context"),
                    ("tests", "test_reqctx.py", "test_manual_context_binding"),
                    ("tests", "test_regression.py", "test_aborting"),
                    ("tests", "test_logging.py", "test_log_view_exception"),
                    ("tests", "test_logging.py", "test_has_level_handler"),
                    ("tests", "test_logging.py", "test_wsgi_errors_stream"),
                    ("tests", "test_json_tag.py", "test_tag_order"),
                    ("tests", "test_json_tag.py", "test_duplicate_tag"),
                    ("tests", "test_json_tag.py", "test_dump_load_unchanged[data9]"),
                    ("tests", "test_helpers.py", "test_name_with_import_error"),
                    ("tests", "test_helpers.py", "test_app_aborter_class"),
                    ("tests", "test_helpers.py", "test_redirect_no_app"),
                    ("tests", "test_helpers.py", "test_url_for_with_alternating_schemes"),
                    ("tests", "test_helpers.py", "test_url_for_with_scheme_not_external"),
                    ("tests", "test_helpers.py", "test_url_for_with_anchor"),
                    ("tests", "test_user_error_handler.py", "test_error_handler_no_match"),
                    ("tests", "test_testing.py", "test_subdomain"),
                    ("tests", "test_testing.py", "test_reuse_client"),
                    ("tests", "test_testing.py", "test_session_transaction_needs_cookies"),
                    ("tests", "test_testing.py", "test_session_transactions"),
                    ("tests", "test_templating.py", "test_template_loader_debugging"),
                    ("tests", "test_templating.py", "test_templates_auto_reload"),
                    ("tests", "test_templating.py", "test_iterable_loader"),
                    ("tests", "test_templating.py", "test_add_template_global"),
                    ("tests", "test_templating.py", "test_add_template_test_with_name"),
                    ("tests", "test_templating.py", "test_template_filter_with_name_and_template"),
                    ("tests", "test_templating.py", "test_add_template_filter_with_template"),
                    ("tests", "test_templating.py", "test_add_template_filter_with_name"),
                    ("tests", "test_templating.py", "test_template_filter_with_name"),
                    ("tests", "test_templating.py", "test_escaping_without_template_filename"),
                    ("tests", "test_templating.py", "test_simple_stream"),
                    ("tests", "test_templating.py", "test_original_win"),
                    ("tests", "test_templating.py", "test_context_processing"),
                    ("tests", "test_subclassing.py", "test_suppressed_exception_logging"),
                    ("tests", "test_signals.py", "test_appcontext_tearing_down_signal"),
                    ("tests", "test_reqctx.py", "test_teardown_with_handled_exception"),
                    ("tests", "test_reqctx.py", "test_teardown_with_previous_exception"),
                    ("tests", "test_json_tag.py", "test_custom_tag"),
                    ("tests", "test_json_tag.py", "test_dump_load_unchanged[data9]"),
                    ("tests", "test_blueprints.py", "test_nested_callback_order"),
                    ("tests", "test_blueprints.py", "test_app_url_processors"),
                    ("tests", "test_blueprints.py", "test_app_request_processing"),
                    ("tests", "test_blueprints.py", "test_add_template_test_with_name_and_template"),
                    ("tests", "test_views.py", "test_endpoint_override"),
                    ("tests", "test_views.py", "test_explicit_head"),
                    ("tests", "test_views.py", "test_view_decorators"),
                    ("tests", "test_user_error_handler.py", "test_handle_generic_http"),
                    ("tests", "test_user_error_handler.py", "test_error_handler_blueprint"),
                    ("tests", "test_user_error_handler.py", "test_error_handler_http_subclass"),
                    ("tests", "test_user_error_handler.py", "test_error_handler_subclass"),
                    ("tests", "test_testing.py", "test_client_pop_all_preserved"),
                    ("tests", "test_testing.py", "test_cli_custom_obj"),
                    ("tests", "test_testing.py", "test_cli_invoke"),
                    ("tests", "test_testing.py", "test_nosubdomain"),
                    ("tests", "test_testing.py", "test_subdomain"),
                    ("tests", "test_testing.py", "test_client_json_no_app_context"),
                    ("tests", "test_testing.py", "test_json_request_and_response"),
                    ("tests", "test_testing.py", "test_session_transactions_no_null_sessions"),
                    ("tests", "test_testing.py", "test_redirect_keep_session"),
                    ("tests", "test_testing.py", "test_blueprint_with_subdomain"),
                    ("tests", "test_testing.py", "test_environbuilder_json_dumps"),
                    ("tests", "test_testing.py", "test_environ_base_modified"),
                    ("tests", "test_testing.py", "test_environ_base_default"),
                    ("tests", "test_templating.py", "test_custom_jinja_env"),
                    ("tests", "test_templating.py", "test_iterable_loader"),
                    ("tests", "test_templating.py", "test_template_filter_with_name_and_template"),
                    ("tests", "test_templating.py", "test_add_template_filter"),
                    ("tests", "test_templating.py", "test_macros"),
                    ("tests", "test_templating.py", "test_no_escaping"),
                    ("tests", "test_templating.py", "test_escaping"),
                    ("tests", "test_templating.py", "test_standard_context"),
                    ("tests", "test_templating.py", "test_original_win"),
                    ("tests", "test_signals.py", "test_flash_signal"),
                    ("tests", "test_session_interface.py", "test_open_session_with_endpoint"),
                    ("tests", "test_reqctx.py", "test_normal_environ_completes"),
                    ("tests", "test_reqctx.py", "test_context_test"),
                    ("tests", "test_reqctx.py", "test_proper_test_request_context"),
                    ("tests", "test_reqctx.py", "test_teardown_on_pop"),
                    ("tests", "test_regression.py", "test_aborting"),
                    ("tests", "test_logging.py", "test_log_view_exception"),
                    ("tests", "test_json_tag.py", "test_tag_interface"),
                    ("tests", "test_json.py", "test_html_method"),
                    ("tests", "test_instance_config.py", "test_uninstalled_package_paths"),
                    ("tests", "test_helpers.py", "test_make_response"),
                    ("tests", "test_config.py", "test_session_lifetime"),
                    ("tests", "test_config.py", "test_custom_config_class"),
                    ("tests", "test_config.py", "test_config_missing_file"),
                    ("tests", "test_config.py", "test_config_from_class"),
                    ("tests", "test_config.py", "test_from_prefixed_env"),
                    ("tests", "test_config.py", "test_config_from_file_toml"),
                    ("tests", "test_config.py", "test_config_from_file_json"),
                    ("tests", "test_config.py", "test_config_from_pyfile"),
                    ("tests", "test_cli.py", "test_run_cert_no_ssl"),
                    ("tests", "test_cli.py", "test_run_cert_path"),
                    ("tests", "test_cli.py", "test_no_command_echo_loading_error"),
                    ("tests", "test_cli.py", "test_flaskgroup_app_context"),
                    ("tests", "test_cli.py", "test_with_appcontext"),
                    ("tests", "test_cli.py", "test_locate_app_suppress_raise"),
                    ("tests", "test_cli.py", "test_cli_name"),
                    ("tests", "test_blueprints.py", "test_self_registration"),
                    ("tests", "test_blueprints.py", "test_child_and_parent_subdomain"),
                    ("tests", "test_blueprints.py", "test_add_template_test_with_template"),
                    ("tests", "test_blueprints.py", "test_add_template_test_with_name"),
                    ("tests", "test_blueprints.py", "test_template_test_with_name"),
                    ("tests", "test_blueprints.py", "test_add_template_filter_with_name_and_template"),
                    ("tests", "test_blueprints.py", "test_empty_url_defaults"),
                    ("tests", "test_blueprints.py", "test_blueprint_url_defaults"),
                    ("tests", "test_basic.py", "test_multi_route_class_views"),
                    ("tests", "test_basic.py", "test_subdomain_matching"),
                    ("tests", "test_basic.py", "test_route_decorator_custom_endpoint"),
                    ("tests", "test_basic.py", "test_url_processors"),
                    ("tests", "test_basic.py", "test_static_url_empty_path_default"),
                    ("tests", "test_basic.py", "test_static_url_path"),
                    ("tests", "test_basic.py", "test_json_dump_dataclass"),
                    ("tests", "test_basic.py", "test_response_type_errors"),
                    ("tests", "test_basic.py", "test_error_handler_after_processor_error"),
                    ("tests", "test_basic.py", "test_trapping_of_all_http_exceptions"),
                    ("tests", "test_basic.py", "test_user_error_handling"),
                    ("tests", "test_basic.py", "test_baseexception_error_handling"),
                    ("tests", "test_basic.py", "test_error_handling_processing"),
                    ("tests", "test_basic.py", "test_teardown_request_handler"),
                    ("tests", "test_basic.py", "test_request_preprocessing_early_return"),
                    ("tests", "test_basic.py", "test_session_vary_cookie"),
                    ("tests", "test_basic.py", "test_session_using_application_root"),
                    ("tests", "test_basic.py", "test_werkzeug_routing"),
                    ("tests", "test_basic.py", "test_url_mapping"),
                    ("tests", "test_basic.py", "test_method_route_no_methods"),
                    ("tests", "test_views.py", "test_init_once"),
                    ("tests", "test_views.py", "test_multiple_inheritance"),
                    ("tests", "test_views.py", "test_endpoint_override"),
                    ("tests", "test_views.py", "test_implicit_head"),
                    ("tests", "test_views.py", "test_view_decorators"),
                    ("tests", "test_user_error_handler.py", "test_handle_class_or_code[500]"),
                    ("tests", "test_user_error_handler.py", "test_handle_class_or_code[InternalServerError]"),
                    ("tests", "test_user_error_handler.py", "test_error_handler_subclass"),
                    ("tests", "test_testing.py", "test_session_transactions_keep_context"),
                    ("tests", "test_testing.py", "test_redirect_keep_session"),
                    ("tests", "test_templating.py", "test_template_loader_debugging"),
                    ("tests", "test_templating.py", "test_add_template_test_with_template"),
                    ("tests", "test_templating.py", "test_template_test_with_name"),
                    ("tests", "test_templating.py", "test_template_test"),
                    ("tests", "test_templating.py", "test_add_template_filter_with_template"),
                    ("tests", "test_templating.py", "test_add_template_filter_with_name"),
                    ("tests", "test_templating.py", "test_macros"),
                    ("tests", "test_templating.py", "test_original_win"),
                    ("tests", "test_signals.py", "test_flash_signal"),
                    ("tests", "test_signals.py", "test_appcontext_signals"),
                    ("tests", "test_signals.py", "test_request_exception_signal"),
                    ("tests", "test_signals.py", "test_template_rendered"),
                    ("tests", "test_reqctx.py", "test_teardown_with_previous_exception"),
                    ("tests", "test_logging.py", "test_existing_handler"),
                    ("tests", "test_logging.py", "test_logger_debug"),
                    ("tests", "test_logging.py", "test_logger"),
                    ("tests", "test_json_tag.py", "test_tag_interface"),
                    ("tests", "test_json_tag.py", "test_dump_load_unchanged[data9]"),
                    ("tests", "test_json_tag.py", "test_dump_load_unchanged[data8]"),
                    ("tests", "test_json_tag.py", "test_dump_load_unchanged[data2]"),
                    ("tests", "test_json_tag.py", "test_dump_load_unchanged[data1]"),
                    ("tests", "test_json.py", "test_json_key_sorting"),
                    ("tests", "test_json.py", "test_json_attr"),
                    ("tests", "test_json.py", "test_jsonify_aware_datetimes[tz2]"),
                    ("tests", "test_json.py", "test_jsonify_arrays"),
                    ("tests", "test_json.py", "test_jsonify_basic_types[False]"),
                    ("tests", "test_json.py", "test_jsonify_basic_types[True]"),
                    ("tests", "test_helpers.py", "test_get_debug_flag[True-True]"),
                    ("tests", "test_helpers.py", "test_get_debug_flag[No-False]"),
                    ("tests", "test_helpers.py", "test_stream_keeps_session"),
                    ("tests", "test_helpers.py", "test_abort_with_app"),
                    ("tests", "test_helpers.py", "test_redirect_no_app"),
                    ("tests", "test_helpers.py", "test_url_for_with_alternating_schemes"),
                    ("tests", "test_helpers.py", "test_url_for_with_scheme_not_external"),
                    ("tests", "test_helpers.py", "test_send_file"),
                    ("tests", "test_config.py", "test_custom_config_class"),
                    ("tests", "test_config.py", "test_config_from_envvar_missing"),
                    ("tests", "test_config.py", "test_config_from_class"),
                    ("tests", "test_cli.py", "test_cli_empty"),
                    ("tests", "test_cli.py", "test_run_cert_adhoc"),
                    ("tests", "test_cli.py", "test_run_cert_path"),
                    ("tests", "test_cli.py", "test_dotenv_path"),
                    ("tests", "test_cli.py", "test_no_routes"),
                    ("tests", "test_cli.py", "test_sort"),
                    ("tests", "test_cli.py", "test_flaskgroup_debug[False]"),
                    ("tests", "test_cli.py", "test_with_appcontext"),
                    ("tests", "test_cli.py", "test_get_version"),
                    ("tests", "test_cli.py", "test_locate_app_suppress_raise"),
                    ("tests", "test_cli.py", "test_locate_app_raises[cliapp.importerrorapp-None]"),
                    ("tests", "test_cli.py", "test_locate_app_raises[cliapp.factory-create_app(]"),
                    ("tests", "test_cli.py", "test_locate_app_raises[cliapp.app-notanapp]"),
                    ("tests", "test_cli.py", "test_locate_app_raises[notanapp.py-None]"),
                    ("tests", "test_cli.py", "test_locate_app[cliapp.factory- create_app () -app]"),
                    ("tests", "test_cli.py", 'test_locate_app[cliapp.factory-create_app2("foo", "bar")-app2_foo_bar]'),
                    ("tests", "test_cli.py", "test_prepare_import[value8-path8-cliapp.app]"),
                    ("tests", "test_cli.py", "test_prepare_import[test/__init__-path4-test]"),
                    ("tests", "test_cli.py", "test_prepare_import[test/__init__.py-path3-test]"),
                    ("tests", "test_blueprints.py", "test_self_registration"),
                    ("tests", "test_blueprints.py", "test_child_and_parent_subdomain"),
                    ("tests", "test_blueprints.py", "test_nesting_subdomains"),
                    ("tests", "test_blueprints.py", "test_nesting_url_prefixes[/parent-None-None-/child]"),
                    ("tests", "test_blueprints.py", "test_nested_blueprint"),
                    ("tests", "test_blueprints.py", "test_app_request_processing"),
                    ("tests", "test_blueprints.py", "test_template_global"),
                    ("tests", "test_blueprints.py", "test_context_processing"),
                    ("tests", "test_blueprints.py", "test_template_test"),
                    ("tests", "test_blueprints.py", "test_add_template_filter_with_name_and_template"),
                    ("tests", "test_blueprints.py", "test_add_template_filter_with_template"),
                    ("tests", "test_blueprints.py", "test_empty_url_defaults"),
                    ("tests", "test_blueprints.py", "test_dotted_names_from_app"),
                    ("tests", "test_blueprints.py", "test_empty_name_not_allowed"),
                    ("tests", "test_blueprints.py", "test_templates_list"),
                    ("tests", "test_blueprints.py", "test_blueprint_url_defaults"),
                    ("tests", "test_blueprints.py", "test_blueprint_prefix_slash[/foo/-/bar-/foo/bar]"),
                    ("tests", "test_blueprints.py", "test_blueprint_prefix_slash[/-/-/]"),
                    ("tests", "test_blueprints.py", "test_blueprint_prefix_slash[-/-/]"),
                    ("tests", "test_basic.py", "test_app_freed_on_zero_refcount"),
                    ("tests", "test_basic.py", "test_run_from_config[localhost-0-localhost:8080-localhost-0]"),
                    ("tests", "test_basic.py", "test_run_defaults"),
                    ("tests", "test_basic.py", "test_multi_route_rules"),
                    ("tests", "test_basic.py", "test_subdomain_matching_other_name[True]"),
                    ("tests", "test_basic.py", "test_subdomain_matching"),
                    ("tests", "test_basic.py", "test_no_setup_after_first_request"),
                    ("tests", "test_basic.py", "test_url_processors"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[False-False-False-False]"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[False-False-True-False]"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[False-False-True-True]"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[False-True-False-False]"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[True-False-False-False]"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[True-True-False-True]"),
                    ("tests", "test_basic.py", "test_werkzeug_passthrough_errors[True-True-True-True]"),
                    ("tests", "test_basic.py", "test_request_locals"),
                    ("tests", "test_basic.py", "test_static_url_empty_path"),
                    ("tests", "test_basic.py", "test_jsonify_args_and_kwargs_check"),
                    ("tests", "test_basic.py", "test_jsonify_mimetype"),
                    ("tests", "test_basic.py", "test_make_response"),
                    ("tests", "test_basic.py", "test_response_type_errors"),
                    ("tests", "test_basic.py", "test_response_types"),
                    ("tests", "test_basic.py", "test_error_handler_after_processor_error"),
                    ("tests", "test_basic.py", "test_trapping_of_all_http_exceptions"),
                    ("tests", "test_basic.py", "test_before_request_and_routing_errors"),
                    ("tests", "test_basic.py", "test_baseexception_error_handling"),
                    ("tests", "test_basic.py", "test_after_request_processing"),
                    ("tests", "test_basic.py", "test_flashes"),
                    ("tests", "test_basic.py", "test_disallow_string_for_allowed_methods"),
                    ("tests", "test_basic.py", "test_method_route_no_methods"),
                    ("tests", "test_basic.py", "test_method_route[patch]"),
                    ("tests", "test_basic.py", "test_options_on_multiple_rules"),
                    ("tests", "test_basic.py", "test_options_work"),
                    ("tests", "test_async.py", "test_async_before_after_request"),
                    ("tests", "test_async.py", "test_async_error_handler[/error]"),
                    ("tests", "test_async.py", "test_async_route[/]"),
                    ("tests", "test_appctx.py", "test_clean_pop"),
                    ("tests", "test_appctx.py", "test_custom_app_ctx_globals_class"),
                    ("tests", "test_appctx.py", "test_app_ctx_globals_methods"),
                    ("tests", "test_appctx.py", "test_app_tearing_down"),
                    ("tests", "test_appctx.py", "test_app_context_provides_current_app"),
                    ("tests", "test_appctx.py", "test_url_generation_without_context_fails"),
                    ("tests", "test_appctx.py", "test_basic_url_generation"),
                    ("tests", "test_user_error_handler.py", "test_error_handler_subclass"),
                    ("tests", "test_testing.py", "test_cli_runner_class"),
                    ("tests", "test_testing.py", "test_json_request_and_response"),
                    ("tests", "test_testing.py", "test_test_client_context_binding"),
                    ("tests", "test_testing.py", "test_session_transactions_no_null_sessions"),
                    ("tests", "test_testing.py", "test_path_is_url"),
                    ("tests", "test_testing.py", "test_environ_base_modified"),
                    ("tests", "test_templating.py", "test_custom_template_loader"),
                    ("tests", "test_templating.py", "test_template_test_with_template"),
                    ("tests", "test_templating.py", "test_add_template_test_with_name"),
                    ("tests", "test_templating.py", "test_template_test_with_name"),
                    ("tests", "test_templating.py", "test_add_template_filter_with_template"),
                    ("tests", "test_subclassing.py", "test_suppressed_exception_logging"),
                    ("tests", "test_signals.py", "test_flash_signal"),
                    ("tests", "test_signals.py", "test_before_render_template"),
                    ("tests", "test_reqctx.py", "test_context_test"),
                    ("tests", "test_reqctx.py", "test_proper_test_request_context"),
                    ("tests", "test_reqctx.py", "test_teardown_with_handled_exception"),
                    ("tests", "test_reqctx.py", "test_teardown_on_pop"),
                    ("tests", "test_logging.py", "test_logger_debug"),
                    ("tests", "test_logging.py", "test_logger"),
                    ("tests", "test_json_tag.py", "test_dump_load_unchanged[data8]"),
                    ("tests", "test_helpers.py", "test_stream_keeps_session"),
                    ("tests", "test_helpers.py", "test_abort_no_app"),
                    ("tests", "test_helpers.py", "test_send_from_directory"),
                    ("tests", "test_testing.py", "test_json_request_and_response"),
                    ("tests", "test_testing.py", "test_session_transactions_keep_context"),
                    ("tests", "test_testing.py", "test_environ_base_modified"),
                    ("tests", "test_testing.py", "test_environ_base_default"),
                    ("tests", "test_testing.py", "test_environ_defaults_from_config"),
                    ("tests", "test_templating.py", "test_custom_jinja_env"),
                    ("tests", "test_templating.py", "test_custom_template_loader"),
                    ("tests", "test_templating.py", "test_add_template_test_with_name_and_template"),
                    ("tests", "test_templating.py", "test_template_test_with_name"),
                    ("tests", "test_templating.py", "test_add_template_filter"),
                    ("tests", "test_templating.py", "test_template_filter"),
                    ("tests", "test_templating.py", "test_standard_context"),
                    ("tests", "test_signals.py", "test_flash_signal"),
                    ("tests", "test_signals.py", "test_request_exception_signal"),
                    ("tests", "test_signals.py", "test_request_signals"),
                    ("tests", "test_session_interface.py", "test_open_session_with_endpoint"),
                    ("tests", "test_reqctx.py", "test_session_dynamic_cookie_name"),
                    ("tests", "test_logging.py", "test_has_level_handler"),
                    ("tests", "test_logging.py", "test_existing_handler"),
                    ("tests", "test_logging.py", "test_logger_debug"),
                    ("tests", "test_blueprints.py", "test_nested_blueprint"),
                    ("tests", "test_blueprints.py", "test_request_processing"),
                    ("tests", "test_blueprints.py", "test_template_global"),
                    ("tests", "test_blueprints.py", "test_context_processing"),
                    ("tests", "test_views.py", "test_implicit_head"),
                    ("tests", "test_views.py", "test_view_inheritance"),
                    ("tests", "test_user_error_handler.py", "test_default_error_handler"),
                    ("tests", "test_testing.py", "test_full_url_request"),
                    ("tests", "test_testing.py", "test_test_client_context_binding"),
                    ("tests", "test_testing.py", "test_session_transactions"),
                    ("tests", "test_testing.py", "test_specify_url_scheme"),
                    ("tests", "test_templating.py", "test_templates_auto_reload_debug_run"),
                    ("tests", "test_templating.py", "test_custom_template_loader"),
                    ("tests", "test_templating.py", "test_add_template_test_with_name_and_template"),
                    ("tests", "test_templating.py", "test_template_test_with_name_and_template"),
                    ("tests", "test_templating.py", "test_add_template_test_with_template"),
                    ("tests", "test_templating.py", "test_template_test_with_name"),
                    ("tests", "test_templating.py", "test_add_template_filter_with_name"),
                    ("tests", "test_templating.py", "test_template_filter_with_name"),
                    ("tests", "test_templating.py", "test_simple_stream"),
                    ("tests", "test_subclassing.py", "test_suppressed_exception_logging"),
                    ("tests", "test_signals.py", "test_request_exception_signal"),
                    ("tests", "test_signals.py", "test_before_render_template"),
                    ("tests", "test_signals.py", "test_template_rendered"),
                    ("tests", "test_reqctx.py", "test_bad_environ_raises_bad_request"),
                    ("tests", "test_reqctx.py", "test_session_dynamic_cookie_name"),
                    ("tests", "test_reqctx.py", "test_session_error_pops_context"),
                    ("tests", "test_logging.py", "test_logger_debug"),
                    ("tests", "test_json_tag.py", "test_custom_tag"),
                    ("tests", "test_json.py", "test_tojson_filter"),
                    ("tests", "test_json.py", "test_json_attr"),
                    ("tests", "test_json.py", "test_jsonify_uuid_types"),
                    ("tests", "test_json.py", "test_jsonify_dicts"),
                    ("tests", "test_json.py", "test_json_custom_mimetypes"),
                    ("tests", "test_instance_config.py", "test_uninstalled_namespace_paths"),
                    ("tests", "test_config.py", "test_config_missing"),
                    ("tests", "test_config.py", "test_config_from_envvar"),
                    ("tests", "test_config.py", "test_from_prefixed_env_nested"),
                    ("tests", "test_cli.py", "test_run_exclude_patterns"),
                    ("tests", "test_cli.py", "test_run_cert_import"),
                    ("tests", "test_cli.py", "test_run_cert_adhoc"),
                    ("tests", "test_cli.py", "test_dotenv_path"),
                    ("tests", "test_cli.py", "test_host"),
                    ("tests", "test_cli.py", "test_subdomain"),
                    ("tests", "test_cli.py", "test_no_routes"),
                    ("tests", "test_cli.py", "test_sort"),
                    ("tests", "test_cli.py", "test_simple"),
                    ("tests", "test_cli.py", "test_flaskgroup_nested"),
                    ("tests", "test_cli.py", "test_scriptinfo"),
                    ("tests", "test_cli.py", "test_find_best_app"),
                    ("tests", "test_blueprints.py", "test_template_test_with_template"),
                    ("tests", "test_blueprints.py", "test_add_template_filter_with_name"),
                    ("tests", "test_blueprints.py", "test_add_template_filter"),
                    ("tests", "test_blueprints.py", "test_endpoint_decorator"),
                    ("tests", "test_blueprints.py", "test_dotted_names_from_app"),
                    ("tests", "test_blueprints.py", "test_templates_list"),
                    ("tests", "test_blueprints.py", "test_blueprint_url_processors"),
                    ("tests", "test_basic.py", "test_app_freed_on_zero_refcount"),
                    ("tests", "test_basic.py", "test_run_server_port"),
                    ("tests", "test_basic.py", "test_run_defaults"),
                    ("tests", "test_basic.py", "test_no_setup_after_first_request"),
                    ("tests", "test_basic.py", "test_request_locals"),
                    ("tests", "test_basic.py", "test_static_url_empty_path"),
                    ("tests", "test_basic.py", "test_build_error_handler_reraise"),
                    ("tests", "test_basic.py", "test_jsonify_mimetype"),
                    ("tests", "test_basic.py", "test_make_response_with_response_instance"),
                    ("tests", "test_basic.py", "test_make_response"),
                    ("tests", "test_basic.py", "test_response_types"),
                    ("tests", "test_basic.py", "test_errorhandler_precedence"),
                    ("tests", "test_basic.py", "test_http_error_subclass_handling"),
                    ("tests", "test_basic.py", "test_session_refresh_vary"),
                    ("tests", "test_basic.py", "test_missing_session"),
                    ("tests", "test_basic.py", "test_session_using_samesite_attribute"),
                    ("tests", "test_basic.py", "test_endpoint_decorator"),
                    ("tests", "test_basic.py", "test_disallow_string_for_allowed_methods"),
                    ("tests", "test_basic.py", "test_request_dispatching"),
                    ("tests", "test_basic.py", "test_options_work"),
                    ("tests", "test_async.py", "test_async_before_after_request"),
                ]
            ),
        )
        client = self._get_test_client()
        with mock.patch.object(client, "_do_request", return_value=Response(200, skippable_response)):
            actual_skippable_items = client.fetch_skippable_items(ignore_test_parameters=True)
            assert actual_skippable_items == expected_skippable_items
