from aws_cdk import (
    App,
    Stack,
    StackProps,
    CfnOutput
)
from constructs import Construct
from must_cdk import AmplifyApp

class BasicAmplifyStack(Stack):
    def __init__(self, scope: Construct, id: str, **kwargs) -> None:
        super().__init__(scope, id, **kwargs)

        # Basic Amplify app - will use gh auth token automatically
        amplify_app = AmplifyApp(
            self, "MustCdkApp",
            app_name="must-cdk",
            repository="https://github.com/globalmsq/must-cdk",
            
            # Optional: Override default build settings
            build_settings={
                "compute_type": "STANDARD_8GB",
                "enable_branch_auto_build": True
            },

            # Optional: Add environment variables
            environment_variables={
                "NODE_ENV": "production"
            }
        )

        # Output the app URL
        CfnOutput(
            self, "AmplifyAppUrl",
            value=f"https://main.{amplify_app.app.attr_app_id}.amplifyapp.com",
            description="Amplify App URL"
        )

# Example usage
app = App()
BasicAmplifyStack(app, "BasicAmplifyStack")
app.synth()
