import * as cdk from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { AmplifyApp } from 'must-cdk';

export class BasicAmplifyStack extends cdk.Stack {
  constructor(scope: Construct, id: string, props?: cdk.StackProps) {
    super(scope, id, props);

    // Basic Amplify app - will use gh auth token automatically
    const amplifyApp = new AmplifyApp(this, 'MustCdkApp', {
      appName: 'must-cdk',
      repository: 'https://github.com/globalmsq/must-cdk',
      
      // Optional: Override default build settings
      buildSettings: {
        computeType: 'STANDARD_8GB',
        enableBranchAutoBuild: true
      },

      // Optional: Add environment variables
      environmentVariables: {
        NODE_ENV: 'production'
      }
    });

    // Output the app URL
    new cdk.CfnOutput(this, 'AmplifyAppUrl', {
      value: `https://main.${amplifyApp.app.attrAppId}.amplifyapp.com`,
      description: 'Amplify App URL'
    });
  }
}

// Example usage
const app = new cdk.App();
new BasicAmplifyStack(app, 'BasicAmplifyStack');
