from aws_cdk import App, Stack, Environment
from must_cdk import RestApiToLambda
import os

class RestApiStack(Stack):
    def __init__(self, scope: App, id: str, **kwargs):
        super().__init__(scope, id, **kwargs)

        RestApiToLambda(self, "UserApi",
            api_name="user-service",
            description="User management API",
            lambda_function={
                "runtime": "nodejs18.x",
                "handler": "index.handler",
                "code": "lambda/user-service",
                "environment": {
                    "TABLE_NAME": "users-table",
                    "REGION": "ap-northeast-2"
                },
                "memorySize": 256,
                "timeout": 30
            },
            custom_domain={
                "domainName": "api.example.com",
                "certificateArn": "arn:aws:acm:ap-northeast-2:123456789012:certificate/xxx"
            },
            cors={
                "allowOrigins": ["https://example.com"],
                "allowMethods": ["GET", "POST", "PUT", "DELETE"],
                "allowHeaders": ["Content-Type", "Authorization"]
            },
            authorizer={
                "type": "JWT",
                "jwtConfiguration": {
                    "issuer": "https://cognito-idp.ap-northeast-2.amazonaws.com/xxx",
                    "audience": ["client-id"]
                }
            },
            api_key={
                "name": "client-api-key",
                "description": "API key for client application"
            },
            usage_plan={
                "name": "standard-plan",
                "throttle": {
                    "rateLimit": 100,
                    "burstLimit": 200
                },
                "quota": {
                    "limit": 10000,
                    "period": "MONTH"
                }
            }
        )

app = App()
RestApiStack(app, "RestApiStack",
    env=Environment(
        account=os.getenv("CDK_DEFAULT_ACCOUNT"),
        region="ap-northeast-2"
    )
)
app.synth()
