import * as api from "aws-cdk-lib/aws-apigateway";
import { ICertificate } from "aws-cdk-lib/aws-certificatemanager";
import * as lambda from "aws-cdk-lib/aws-lambda";
import * as logs from "aws-cdk-lib/aws-logs";
import * as route53 from "aws-cdk-lib/aws-route53";
import { TaggableProps } from "../common/tags";
export interface CustomRoute {
    readonly path: string;
    readonly method: string;
    readonly handler: lambda.IFunction;
    readonly methodOptions?: api.MethodOptions;
}
export interface ApiGatewayToLambdaProps extends TaggableProps {
    /**
     * Primary Lambda function for the API
     */
    readonly lambdaFunction: lambda.IFunction;
    /**
     * API configuration
     */
    readonly apiName: string;
    readonly proxy?: boolean;
    readonly restApiProps?: api.RestApiProps;
    readonly lambdaApiProps?: api.LambdaRestApiProps;
    /**
     * Binary media types for the API
     * This setting will be applied regardless of whether LambdaRestApi or RestApi is used
     */
    readonly binaryMediaTypes?: string[];
    /**
     * Optional custom domain name for API Gateway
     */
    readonly customDomainName?: string;
    /**
     * Optional Route53 hosted zone for custom domain
     */
    readonly hostedZone?: route53.IHostedZone;
    /**
     * Optional ACM certificate to use instead of creating a new one
     */
    readonly existingCertificate?: ICertificate;
    /**
     * Whether to create a Usage Plan
     */
    readonly createUsagePlan?: boolean;
    /**
     * CloudWatch Logs configuration
     */
    readonly logGroupProps?: logs.LogGroupProps;
    /**
     * Custom routes for manual API setup (when proxy is false)
     * If provided, will use RestApi instead of LambdaRestApi
     */
    readonly customRoutes?: CustomRoute[];
    /**
     * Enable CloudWatch logging for API Gateway
     */
    readonly enableLogging?: boolean;
}
