import { a, defineData } from '@aws-amplify/backend';

/*== STEP 1 ===============================================================
The section below creates a Note database table with "name", "description", 
and "image" fields. The authorization rule below specifies that any 
authenticated user can "create", "read", "update", and "delete" any "Note" records.
=========================================================================*/
const schema = a.schema({
  Note: a
    .model({
      name: a.string().required(),
      description: a.string(),
      image: a.string(),
    })
    .authorization((allow) => [allow.publicApiKey()]),
});

export const data = defineData({
  schema,
  authorizationModes: {
    defaultAuthorizationMode: 'apiKey',
    // API Key is used for a.allow.public() rules
    apiKeyAuthorizationMode: {
      expiresInDays: 30,
    },
  },
});

/*== STEP 2 ===============================================================
Go to your frontend source code. From your client-side code, generate a
Data client to make CRUDL requests to your table. (THIS SNIPPET WILL ONLY
WORK IN THE FRONTEND CODE FILE.)

Using JavaScript or Next.js React Server Components, Middleware, Server 
Actions or Pages Router? Review how to generate Data clients for those use
cases: https://docs.amplify.aws/gen2/build-a-backend/data/connect-to-API/
=========================================================================*/

/*
"use client"
import { generateClient } from "aws-amplify/data";

const client = generateClient() // use this Data client for CRUDL requests
*/

/*== STEP 3 ===============================================================
Fetch records from the database and use them in your frontend component.
(THIS SNIPPET WILL ONLY WORK IN THE FRONTEND CODE FILE.)
=========================================================================*/

/* For example, in a React component, you can use this snippet in your
  function's RETURN statement */
// const { data: notes } = await client.models.Note.list()

// return <ul>{notes.map(note => <li key={note.id}>{note.name}</li>)}</ul>
