# 🚀 TurboPDF — Generador de PDFs Profesionales para Django

[![PyPI version](https://img.shields.io/pypi/v/turbopdf.svg?style=for-the-badge&logo=pypi&logoColor=white)](https://pypi.org/project/turbopdf/)
[![Python versions](https://img.shields.io/pypi/pyversions/turbopdf.svg?style=for-the-badge&logo=python&logoColor=white)](https://pypi.org/project/turbopdf/)
[![License: MIT](https://img.shields.io/badge/License-MIT-blue.svg?style=for-the-badge)](https://github.com/EcosistemaUNP/python-ecosistema-turbopdf/blob/main/LICENSE)
[![GitHub stars](https://img.shields.io/github/stars/EcosistemaUNP/python-ecosistema-turbopdf?style=for-the-badge&logo=github)](https://github.com/EcosistemaUNP/python-ecosistema-turbopdf/stargazers)

> ✨ **PDFs modulares, elegantes y fáciles de generar en Django — con plantillas HTML reutilizables y estilo profesional.**

Construye contratos, informes, formularios y documentos institucionales usando componentes HTML modulares + `wkhtmltopdf`. Ideal para entornos educativos, gubernamentales o empresariales.

---

## 🎯 ¿Por qué TurboPDF?

✅ **Modular** — Usa componentes HTML reutilizables (header, footer, tabla, firma, etc.)  
✅ **Profesional** — Estilos listos para documentos oficiales  
✅ **Rápido** — Genera PDFs en segundos  
✅ **Django-Friendly** — Integración directa con tus vistas y modelos  
✅ **Personalizable** — Adapta colores, logos y estilos fácilmente

---

## 🧩 Componentes incluidos

- 🖋️ `HeaderComponent` — Encabezado institucional
- 📄 `FooterComponent` — Pie de página con paginación
- 📊 `TableComponent` — Tablas responsivas y estilizadas
- ✍️ `SignatureComponent` — Firmas alineadas
- 🧾 `SectionComponent` — Secciones con títulos y contenido

---

## ⚡ Instalación

```bash
pip install turbopdf