# coding: utf-8

import semantic_release
from semantic_release.history import parser_angular, parser_helpers


def parse_commit(message):
    if (
        "generated by python-semantic-release" in message
        or message.startswith("Merge pull request")
        or message.startswith("Merge branch")
    ):
        raise semantic_release.UnknownCommitMessageStyleError()

    return parser_helpers.ParsedCommit(
        bump=parser_angular.LEVEL_BUMPS["minor"],
        type="feature",
        scope=None,
        descriptions=[message],
        breaking_descriptions=[],
    )
