import pytest

from gptsh.core.agent import Agent
from gptsh.core.approval import DefaultApprovalPolicy
from gptsh.core.session import ChatSession


class FakeLLM:
    def __init__(self, responses):
        self.responses = list(responses)

    async def complete(self, params):
        return self.responses.pop(0)

    async def stream(self, params):
        yield ""


@pytest.mark.asyncio
async def test_run_prompt_with_agent_simple_no_tools(monkeypatch):
    # Avoid spinning up real MCP; pass mcp=None in ChatSession

    resp = {"choices": [{"message": {"content": "ok"}}]}
    llm = FakeLLM([resp])
    agent = Agent(
        name="t", llm=llm, tools={}, policy=DefaultApprovalPolicy({}), generation_params={}
    )
    session = ChatSession.from_agent(agent, progress=None, config={}, mcp=None)
    chunks = []
    async for t in session.stream_turn(
        user_message="hi",
        no_tools=True,
    ):
        chunks.append(t)
    out = "".join(chunks)
    # For no-tools, helper stream may not produce chunks; accept empty
    assert out in ("ok", "")
