/*
  Copyright (c) 2014, Randolph Voorhies, Shane Grant
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:
      * Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.
      * Neither the name of the copyright holder nor the
        names of its contributors may be used to endorse or promote products
        derived from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY
  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef CEREAL_TEST_ARRAY_H_
#define CEREAL_TEST_ARRAY_H_
#include "common.hpp"

template <class IArchive, class OArchive, size_t N> inline
void test_array()
{
  std::random_device rd;
  std::mt19937 gen(rd());

  for(int ii=0; ii<100; ++ii)
  {
    std::array<int, N> o_podarray;
    for(auto & elem : o_podarray)
      elem = random_value<int>(gen);

    std::array<StructInternalSerialize, N> o_iserarray;
    for(auto & elem : o_iserarray)
      elem = StructInternalSerialize( random_value<int>(gen), random_value<int>(gen) );

    std::array<StructInternalSplit, N> o_isplarray;
    for(auto & elem : o_isplarray)
      elem = StructInternalSplit( random_value<int>(gen), random_value<int>(gen) );

    std::array<StructExternalSerialize, N> o_eserarray;
    for(auto & elem : o_eserarray)
      elem = StructExternalSerialize( random_value<int>(gen), random_value<int>(gen) );

    std::array<StructExternalSplit, N> o_esplarray;
    for(auto & elem : o_esplarray)
      elem = StructExternalSplit( random_value<int>(gen), random_value<int>(gen) );

    std::ostringstream os;
    {
      OArchive oar(os);

      oar(o_podarray);
      oar(o_iserarray);
      oar(o_isplarray);
      oar(o_eserarray);
      oar(o_esplarray);
    }

    std::array<int, N> i_podarray;
    std::array<StructInternalSerialize, N> i_iserarray;
    std::array<StructInternalSplit, N>     i_isplarray;
    std::array<StructExternalSerialize, N> i_eserarray;
    std::array<StructExternalSplit, N>     i_esplarray;

    std::istringstream is(os.str());
    {
      IArchive iar(is);

      iar(i_podarray);
      iar(i_iserarray);
      iar(i_isplarray);
      iar(i_eserarray);
      iar(i_esplarray);
    }

    check_collection( i_podarray, o_podarray );
    check_collection( i_iserarray, o_iserarray );
    check_collection( i_isplarray, o_isplarray );
    check_collection( i_eserarray, o_eserarray );
    check_collection( i_esplarray, o_esplarray );
  }
}

#endif // CEREAL_TEST_ARRAY_H_
