# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ActionsOrganizationSecretRepositoryArgs', 'ActionsOrganizationSecretRepository']

@pulumi.input_type
class ActionsOrganizationSecretRepositoryArgs:
    def __init__(__self__, *,
                 repository_id: pulumi.Input[_builtins.int],
                 secret_name: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ActionsOrganizationSecretRepository resource.
        :param pulumi.Input[_builtins.int] repository_id: Repository id that can access the organization secret.
        :param pulumi.Input[_builtins.str] secret_name: Name of the existing secret
        """
        pulumi.set(__self__, "repository_id", repository_id)
        pulumi.set(__self__, "secret_name", secret_name)

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Input[_builtins.int]:
        """
        Repository id that can access the organization secret.
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "repository_id", value)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the existing secret
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_name", value)


@pulumi.input_type
class _ActionsOrganizationSecretRepositoryState:
    def __init__(__self__, *,
                 repository_id: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ActionsOrganizationSecretRepository resources.
        :param pulumi.Input[_builtins.int] repository_id: Repository id that can access the organization secret.
        :param pulumi.Input[_builtins.str] secret_name: Name of the existing secret
        """
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Repository id that can access the organization secret.
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "repository_id", value)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the existing secret
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_name", value)


@pulumi.type_token("github:index/actionsOrganizationSecretRepository:ActionsOrganizationSecretRepository")
class ActionsOrganizationSecretRepository(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 repository_id: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource help you to allow/unallow a repository to use an existing GitHub Actions secrets within your GitHub organization.
        You must have write access to an organization secret to use this resource.

        This resource is only applicable when `visibility` of the existing organization secret has been set to `selected`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        repo = github.get_repository(full_name="my-org/repo")
        org_secret_repos = github.ActionsOrganizationSecretRepository("org_secret_repos",
            secret_name="EXAMPLE_SECRET_NAME",
            repository_id=repo_github_repository["repoId"])
        ```

        ## Import

        This resource can be imported using an ID made up of the secret name:

        ```sh
        $ pulumi import github:index/actionsOrganizationSecretRepository:ActionsOrganizationSecretRepository test_secret_repos test_secret_name:repo_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] repository_id: Repository id that can access the organization secret.
        :param pulumi.Input[_builtins.str] secret_name: Name of the existing secret
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ActionsOrganizationSecretRepositoryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource help you to allow/unallow a repository to use an existing GitHub Actions secrets within your GitHub organization.
        You must have write access to an organization secret to use this resource.

        This resource is only applicable when `visibility` of the existing organization secret has been set to `selected`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        repo = github.get_repository(full_name="my-org/repo")
        org_secret_repos = github.ActionsOrganizationSecretRepository("org_secret_repos",
            secret_name="EXAMPLE_SECRET_NAME",
            repository_id=repo_github_repository["repoId"])
        ```

        ## Import

        This resource can be imported using an ID made up of the secret name:

        ```sh
        $ pulumi import github:index/actionsOrganizationSecretRepository:ActionsOrganizationSecretRepository test_secret_repos test_secret_name:repo_id
        ```

        :param str resource_name: The name of the resource.
        :param ActionsOrganizationSecretRepositoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ActionsOrganizationSecretRepositoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 repository_id: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ActionsOrganizationSecretRepositoryArgs.__new__(ActionsOrganizationSecretRepositoryArgs)

            if repository_id is None and not opts.urn:
                raise TypeError("Missing required property 'repository_id'")
            __props__.__dict__["repository_id"] = repository_id
            if secret_name is None and not opts.urn:
                raise TypeError("Missing required property 'secret_name'")
            __props__.__dict__["secret_name"] = secret_name
        super(ActionsOrganizationSecretRepository, __self__).__init__(
            'github:index/actionsOrganizationSecretRepository:ActionsOrganizationSecretRepository',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            repository_id: Optional[pulumi.Input[_builtins.int]] = None,
            secret_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ActionsOrganizationSecretRepository':
        """
        Get an existing ActionsOrganizationSecretRepository resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] repository_id: Repository id that can access the organization secret.
        :param pulumi.Input[_builtins.str] secret_name: Name of the existing secret
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ActionsOrganizationSecretRepositoryState.__new__(_ActionsOrganizationSecretRepositoryState)

        __props__.__dict__["repository_id"] = repository_id
        __props__.__dict__["secret_name"] = secret_name
        return ActionsOrganizationSecretRepository(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Output[_builtins.int]:
        """
        Repository id that can access the organization secret.
        """
        return pulumi.get(self, "repository_id")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the existing secret
        """
        return pulumi.get(self, "secret_name")

