# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetUserExternalIdentityResult',
    'AwaitableGetUserExternalIdentityResult',
    'get_user_external_identity',
    'get_user_external_identity_output',
]

@pulumi.output_type
class GetUserExternalIdentityResult:
    """
    A collection of values returned by getUserExternalIdentity.
    """
    def __init__(__self__, id=None, login=None, saml_identity=None, scim_identity=None, username=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if login and not isinstance(login, str):
            raise TypeError("Expected argument 'login' to be a str")
        pulumi.set(__self__, "login", login)
        if saml_identity and not isinstance(saml_identity, dict):
            raise TypeError("Expected argument 'saml_identity' to be a dict")
        pulumi.set(__self__, "saml_identity", saml_identity)
        if scim_identity and not isinstance(scim_identity, dict):
            raise TypeError("Expected argument 'scim_identity' to be a dict")
        pulumi.set(__self__, "scim_identity", scim_identity)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def login(self) -> _builtins.str:
        """
        The username of the GitHub user
        """
        return pulumi.get(self, "login")

    @_builtins.property
    @pulumi.getter(name="samlIdentity")
    def saml_identity(self) -> Mapping[str, _builtins.str]:
        """
        An Object containing the user's SAML data. This object will
        be empty if the user is not managed by SAML.
        """
        return pulumi.get(self, "saml_identity")

    @_builtins.property
    @pulumi.getter(name="scimIdentity")
    def scim_identity(self) -> Mapping[str, _builtins.str]:
        """
        An Object contining the user's SCIM data. This object will
        be empty if the user is not managed by SCIM.
        """
        return pulumi.get(self, "scim_identity")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The member's SAML Username
        """
        return pulumi.get(self, "username")


class AwaitableGetUserExternalIdentityResult(GetUserExternalIdentityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserExternalIdentityResult(
            id=self.id,
            login=self.login,
            saml_identity=self.saml_identity,
            scim_identity=self.scim_identity,
            username=self.username)


def get_user_external_identity(username: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserExternalIdentityResult:
    """
    Use this data source to retrieve a specific organization member's SAML or SCIM user
    attributes.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example_user = github.get_user_external_identity(username="example-user")
    ```


    :param _builtins.str username: The username of the member to fetch external identity for.
    """
    __args__ = dict()
    __args__['username'] = username
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('github:index/getUserExternalIdentity:getUserExternalIdentity', __args__, opts=opts, typ=GetUserExternalIdentityResult).value

    return AwaitableGetUserExternalIdentityResult(
        id=pulumi.get(__ret__, 'id'),
        login=pulumi.get(__ret__, 'login'),
        saml_identity=pulumi.get(__ret__, 'saml_identity'),
        scim_identity=pulumi.get(__ret__, 'scim_identity'),
        username=pulumi.get(__ret__, 'username'))
def get_user_external_identity_output(username: Optional[pulumi.Input[_builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserExternalIdentityResult]:
    """
    Use this data source to retrieve a specific organization member's SAML or SCIM user
    attributes.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example_user = github.get_user_external_identity(username="example-user")
    ```


    :param _builtins.str username: The username of the member to fetch external identity for.
    """
    __args__ = dict()
    __args__['username'] = username
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('github:index/getUserExternalIdentity:getUserExternalIdentity', __args__, opts=opts, typ=GetUserExternalIdentityResult)
    return __ret__.apply(lambda __response__: GetUserExternalIdentityResult(
        id=pulumi.get(__response__, 'id'),
        login=pulumi.get(__response__, 'login'),
        saml_identity=pulumi.get(__response__, 'saml_identity'),
        scim_identity=pulumi.get(__response__, 'scim_identity'),
        username=pulumi.get(__response__, 'username')))
