# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OrganizationRoleTeamArgs', 'OrganizationRoleTeam']

@pulumi.input_type
class OrganizationRoleTeamArgs:
    def __init__(__self__, *,
                 role_id: pulumi.Input[_builtins.int],
                 team_slug: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a OrganizationRoleTeam resource.
        :param pulumi.Input[_builtins.int] role_id: The ID of the organization role.
        :param pulumi.Input[_builtins.str] team_slug: The slug of the team name.
        """
        pulumi.set(__self__, "role_id", role_id)
        pulumi.set(__self__, "team_slug", team_slug)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Input[_builtins.int]:
        """
        The ID of the organization role.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "role_id", value)

    @_builtins.property
    @pulumi.getter(name="teamSlug")
    def team_slug(self) -> pulumi.Input[_builtins.str]:
        """
        The slug of the team name.
        """
        return pulumi.get(self, "team_slug")

    @team_slug.setter
    def team_slug(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "team_slug", value)


@pulumi.input_type
class _OrganizationRoleTeamState:
    def __init__(__self__, *,
                 role_id: Optional[pulumi.Input[_builtins.int]] = None,
                 team_slug: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationRoleTeam resources.
        :param pulumi.Input[_builtins.int] role_id: The ID of the organization role.
        :param pulumi.Input[_builtins.str] team_slug: The slug of the team name.
        """
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)
        if team_slug is not None:
            pulumi.set(__self__, "team_slug", team_slug)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the organization role.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "role_id", value)

    @_builtins.property
    @pulumi.getter(name="teamSlug")
    def team_slug(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The slug of the team name.
        """
        return pulumi.get(self, "team_slug")

    @team_slug.setter
    def team_slug(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_slug", value)


@pulumi.type_token("github:index/organizationRoleTeam:OrganizationRoleTeam")
class OrganizationRoleTeam(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 role_id: Optional[pulumi.Input[_builtins.int]] = None,
                 team_slug: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manage an association between an organization role and a team.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        example = github.OrganizationRoleTeam("example",
            role_id=1234,
            team_slug="example-team")
        ```

        ## Import

        An organization role team association can be imported using the role ID and the team slug separated by a `:`.

        ```sh
        $ pulumi import github:index/organizationRoleTeam:OrganizationRoleTeam example "1234:example-team"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] role_id: The ID of the organization role.
        :param pulumi.Input[_builtins.str] team_slug: The slug of the team name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationRoleTeamArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage an association between an organization role and a team.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        example = github.OrganizationRoleTeam("example",
            role_id=1234,
            team_slug="example-team")
        ```

        ## Import

        An organization role team association can be imported using the role ID and the team slug separated by a `:`.

        ```sh
        $ pulumi import github:index/organizationRoleTeam:OrganizationRoleTeam example "1234:example-team"
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationRoleTeamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationRoleTeamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 role_id: Optional[pulumi.Input[_builtins.int]] = None,
                 team_slug: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationRoleTeamArgs.__new__(OrganizationRoleTeamArgs)

            if role_id is None and not opts.urn:
                raise TypeError("Missing required property 'role_id'")
            __props__.__dict__["role_id"] = role_id
            if team_slug is None and not opts.urn:
                raise TypeError("Missing required property 'team_slug'")
            __props__.__dict__["team_slug"] = team_slug
        super(OrganizationRoleTeam, __self__).__init__(
            'github:index/organizationRoleTeam:OrganizationRoleTeam',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            role_id: Optional[pulumi.Input[_builtins.int]] = None,
            team_slug: Optional[pulumi.Input[_builtins.str]] = None) -> 'OrganizationRoleTeam':
        """
        Get an existing OrganizationRoleTeam resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] role_id: The ID of the organization role.
        :param pulumi.Input[_builtins.str] team_slug: The slug of the team name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationRoleTeamState.__new__(_OrganizationRoleTeamState)

        __props__.__dict__["role_id"] = role_id
        __props__.__dict__["team_slug"] = team_slug
        return OrganizationRoleTeam(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the organization role.
        """
        return pulumi.get(self, "role_id")

    @_builtins.property
    @pulumi.getter(name="teamSlug")
    def team_slug(self) -> pulumi.Output[_builtins.str]:
        """
        The slug of the team name.
        """
        return pulumi.get(self, "team_slug")

