# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/environments/21_feature_converters.ipynb.

# %% auto 0
__all__ = ['feature_oracle', 'get_time_series_features']

# %% ../../nbs/environments/21_feature_converters.ipynb 4
# General libraries:
import numpy as np

# %% ../../nbs/environments/21_feature_converters.ipynb 5
def feature_oracle(features, window = 10, flat = False):
    """

    Takes a matrix of features where n is the number of time steps and m is the number of features.
    For each feature it adds as many columns as the window size where each column is the feature n+1 time steps in the future.

    Args:
        features (np.array): Array of features.
        window (int): Window size how many future features to add
        flat (bool): If True, the output is a 2D array. If False, the output is a 3D array.
    """

    oracle_features = np.zeros((features.shape[0]-window, features.shape[1], window+1))

    for i in range(window+1):
        if i == window:
            oracle_features[:, :, i] = features[i:,:].copy()
        else:
            oracle_features[:, :, i] = features[i:-window+i,:].copy()

    if flat:
        oracle_features = oracle_features.reshape((oracle_features.shape[0], oracle_features.shape[1] * oracle_features.shape[2]))

    return oracle_features

# %% ../../nbs/environments/21_feature_converters.ipynb 6
def get_time_series_features(time_series, window = 10, flat = False, include_t = False):

    # TODO Check how to differentiate between labels and features (features may also have the feature information
    # TODO of the current period, not just the lagged information)

    """

    Takes a matrix of a time series with n time steps and m features. It returns a 3D array where the first dimension
    is the time step, the second dimension is the window size and the third dimension is the number of features.

    Args:
        features (np.array): Input time series.
        window (int): Window size how many past time steps to include
        flat (bool): If True, the output is a 2D array. If False, the output is a 3D array.
    """

    num_features = time_series.shape[1]

    series = np.zeros((len(time_series)-window, window, num_features))

    if include_t:
        for i in range(len(time_series) - window):
            series[i,:,:]=(time_series[i+1:i+window+1])
    else:
        for i in range(len(time_series) - window):
            series[i,:,:]=(time_series[i:i+window])

    if flat:
        series = series.reshape((series.shape[0], series.shape[1] * series.shape[2]))

    return series
