"""add models table

Revision ID: 2dbb2cf49e07
Revises: a1b2c3d4e5f6
Create Date: 2025-11-06 14:49:10.902099

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "2dbb2cf49e07"
down_revision: Union[str, None] = "a1b2c3d4e5f6"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "provider_models",
        sa.Column("handle", sa.String(), nullable=False),
        sa.Column("display_name", sa.String(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("provider_id", sa.String(), nullable=False),
        sa.Column("organization_id", sa.String(), nullable=True),
        sa.Column("model_type", sa.String(), nullable=False),
        sa.Column("enabled", sa.Boolean(), server_default="TRUE", nullable=False),
        sa.Column("model_endpoint_type", sa.String(), nullable=False),
        sa.Column("max_context_window", sa.Integer(), nullable=True),
        sa.Column("supports_token_streaming", sa.Boolean(), nullable=True),
        sa.Column("supports_tool_calling", sa.Boolean(), nullable=True),
        sa.Column("embedding_dim", sa.Integer(), nullable=True),
        sa.Column("id", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(timezone=True), server_default=sa.text("now()"), nullable=True),
        sa.Column("updated_at", sa.DateTime(timezone=True), server_default=sa.text("now()"), nullable=True),
        sa.Column("is_deleted", sa.Boolean(), server_default=sa.text("FALSE"), nullable=False),
        sa.Column("_created_by_id", sa.String(), nullable=True),
        sa.Column("_last_updated_by_id", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(["organization_id"], ["organizations.id"], ondelete="CASCADE"),
        sa.ForeignKeyConstraint(["provider_id"], ["providers.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("handle", "organization_id", "model_type", name="unique_handle_per_org_and_type"),
        sa.UniqueConstraint("name", "provider_id", "model_type", name="unique_model_per_provider_and_type"),
    )
    op.create_index(op.f("ix_provider_models_handle"), "provider_models", ["handle"], unique=False)
    op.create_index(op.f("ix_provider_models_model_type"), "provider_models", ["model_type"], unique=False)
    op.create_index(op.f("ix_provider_models_organization_id"), "provider_models", ["organization_id"], unique=False)
    op.create_index(op.f("ix_provider_models_provider_id"), "provider_models", ["provider_id"], unique=False)
    op.alter_column("providers", "organization_id", existing_type=sa.VARCHAR(), nullable=True)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column("providers", "organization_id", existing_type=sa.VARCHAR(), nullable=False)
    op.drop_index(op.f("ix_provider_models_provider_id"), table_name="provider_models")
    op.drop_index(op.f("ix_provider_models_organization_id"), table_name="provider_models")
    op.drop_index(op.f("ix_provider_models_model_type"), table_name="provider_models")
    op.drop_index(op.f("ix_provider_models_handle"), table_name="provider_models")
    op.drop_table("provider_models")
    # ### end Alembic commands ###
