"""Add tags to passages and create passage_tags junction table

Revision ID: 54c76f7cabca
Revises: c41c87205254
Create Date: 2025-08-28 15:13:01.549590

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op
from letta.settings import settings

# revision identifiers, used by Alembic.
revision: str = "54c76f7cabca"
down_revision: Union[str, None] = "c41c87205254"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###

    # Database-specific timestamp defaults
    if not settings.letta_pg_uri_no_default:
        # SQLite uses CURRENT_TIMESTAMP
        timestamp_default = sa.text("(CURRENT_TIMESTAMP)")
    else:
        # PostgreSQL uses now()
        timestamp_default = sa.text("now()")

    op.create_table(
        "passage_tags",
        sa.Column("id", sa.String(), nullable=False),
        sa.Column("tag", sa.String(), nullable=False),
        sa.Column("passage_id", sa.String(), nullable=False),
        sa.Column("archive_id", sa.String(), nullable=False),
        sa.Column("created_at", sa.DateTime(timezone=True), server_default=timestamp_default, nullable=True),
        sa.Column("updated_at", sa.DateTime(timezone=True), server_default=timestamp_default, nullable=True),
        sa.Column("is_deleted", sa.Boolean(), server_default=sa.text("FALSE"), nullable=False),
        sa.Column("_created_by_id", sa.String(), nullable=True),
        sa.Column("_last_updated_by_id", sa.String(), nullable=True),
        sa.Column("organization_id", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(["archive_id"], ["archives.id"], ondelete="CASCADE"),
        sa.ForeignKeyConstraint(
            ["organization_id"],
            ["organizations.id"],
        ),
        sa.ForeignKeyConstraint(["passage_id"], ["archival_passages.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("passage_id", "tag", name="uq_passage_tag"),
    )
    op.create_index("ix_passage_tags_archive_id", "passage_tags", ["archive_id"], unique=False)
    op.create_index("ix_passage_tags_archive_tag", "passage_tags", ["archive_id", "tag"], unique=False)
    op.create_index("ix_passage_tags_org_archive", "passage_tags", ["organization_id", "archive_id"], unique=False)
    op.create_index("ix_passage_tags_tag", "passage_tags", ["tag"], unique=False)
    op.add_column("archival_passages", sa.Column("tags", sa.JSON(), nullable=True))
    op.add_column("source_passages", sa.Column("tags", sa.JSON(), nullable=True))
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("source_passages", "tags")
    op.drop_column("archival_passages", "tags")
    op.drop_index("ix_passage_tags_tag", table_name="passage_tags")
    op.drop_index("ix_passage_tags_org_archive", table_name="passage_tags")
    op.drop_index("ix_passage_tags_archive_tag", table_name="passage_tags")
    op.drop_index("ix_passage_tags_archive_id", table_name="passage_tags")
    op.drop_table("passage_tags")
    # ### end Alembic commands ###
