"""Add vector db namespace fields to archive and agent state

Revision ID: ddb69be34a72
Revises: f3bf00ef6118
Create Date: 2025-09-02 12:59:54.837863

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "ddb69be34a72"
down_revision: Union[str, None] = "f3bf00ef6118"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("agents", sa.Column("_vector_db_namespace", sa.String(), nullable=True))
    op.add_column("archives", sa.Column("_vector_db_namespace", sa.String(), nullable=True))
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("archives", "_vector_db_namespace")
    op.drop_column("agents", "_vector_db_namespace")
    # ### end Alembic commands ###
