# region License
# Copyright (c) .NET Foundation and contributors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# The latest version of this file can be found at https://github.com/p-hzamora/FluentValidation
# endregion

from enum import Enum


class OpName(Enum):
    CACHE = "CACHE"
    POP_TOP = "POP_TOP"
    PUSH_NULL = "PUSH_NULL"
    INTERPRETER_EXIT = "INTERPRETER_EXIT"
    END_FOR = "END_FOR"
    END_SEND = "END_SEND"
    NOP = "NOP"
    UNARY_NEGATIVE = "UNARY_NEGATIVE"
    UNARY_NOT = "UNARY_NOT"
    UNARY_INVERT = "UNARY_INVERT"
    RESERVED = "RESERVED"
    BINARY_SUBSCR = "BINARY_SUBSCR"
    BINARY_SLICE = "BINARY_SLICE"
    STORE_SLICE = "STORE_SLICE"
    GET_LEN = "GET_LEN"
    MATCH_MAPPING = "MATCH_MAPPING"
    MATCH_SEQUENCE = "MATCH_SEQUENCE"
    MATCH_KEYS = "MATCH_KEYS"
    PUSH_EXC_INFO = "PUSH_EXC_INFO"
    CHECK_EXC_MATCH = "CHECK_EXC_MATCH"
    CHECK_EG_MATCH = "CHECK_EG_MATCH"
    WITH_EXCEPT_START = "WITH_EXCEPT_START"
    GET_AITER = "GET_AITER"
    GET_ANEXT = "GET_ANEXT"
    BEFORE_ASYNC_WITH = "BEFORE_ASYNC_WITH"
    BEFORE_WITH = "BEFORE_WITH"
    END_ASYNC_FOR = "END_ASYNC_FOR"
    CLEANUP_THROW = "CLEANUP_THROW"
    STORE_SUBSCR = "STORE_SUBSCR"
    DELETE_SUBSCR = "DELETE_SUBSCR"
    GET_ITER = "GET_ITER"
    GET_YIELD_FROM_ITER = "GET_YIELD_FROM_ITER"
    LOAD_BUILD_CLASS = "LOAD_BUILD_CLASS"
    LOAD_ASSERTION_ERROR = "LOAD_ASSERTION_ERROR"
    RETURN_GENERATOR = "RETURN_GENERATOR"
    RETURN_VALUE = "RETURN_VALUE"
    SETUP_ANNOTATIONS = "SETUP_ANNOTATIONS"
    LOAD_LOCALS = "LOAD_LOCALS"
    POP_EXCEPT = "POP_EXCEPT"
    UNPACK_SEQUENCE = "UNPACK_SEQUENCE"
    UNPACK_EX = "UNPACK_EX"
    SWAP = "SWAP"
    LOAD_CONST = "LOAD_CONST"
    BUILD_TUPLE = "BUILD_TUPLE"
    BUILD_LIST = "BUILD_LIST"
    BUILD_SET = "BUILD_SET"
    BUILD_MAP = "BUILD_MAP"
    COMPARE_OP = "COMPARE_OP"
    IS_OP = "IS_OP"
    CONTAINS_OP = "CONTAINS_OP"
    RERAISE = "RERAISE"
    COPY = "COPY"
    RETURN_CONST = "RETURN_CONST"
    BINARY_OP = "BINARY_OP"
    LOAD_FAST = "LOAD_FAST"
    STORE_FAST = "STORE_FAST"
    DELETE_FAST = "DELETE_FAST"
    LOAD_FAST_CHECK = "LOAD_FAST_CHECK"
    RAISE_VARARGS = "RAISE_VARARGS"
    GET_AWAITABLE = "GET_AWAITABLE"
    MAKE_FUNCTION = "MAKE_FUNCTION"
    BUILD_SLICE = "BUILD_SLICE"
    MAKE_CELL = "MAKE_CELL"
    LOAD_CLOSURE = "LOAD_CLOSURE"
    LOAD_DEREF = "LOAD_DEREF"
    STORE_DEREF = "STORE_DEREF"
    DELETE_DEREF = "DELETE_DEREF"
    CALL_FUNCTION_EX = "CALL_FUNCTION_EX"
    LOAD_FAST_AND_CLEAR = "LOAD_FAST_AND_CLEAR"
    EXTENDED_ARG = "EXTENDED_ARG"
    LIST_APPEND = "LIST_APPEND"
    SET_ADD = "SET_ADD"
    MAP_ADD = "MAP_ADD"
    COPY_FREE_VARS = "COPY_FREE_VARS"
    YIELD_VALUE = "YIELD_VALUE"
    RESUME = "RESUME"
    MATCH_CLASS = "MATCH_CLASS"
    FORMAT_VALUE = "FORMAT_VALUE"
    BUILD_CONST_KEY_MAP = "BUILD_CONST_KEY_MAP"
    BUILD_STRING = "BUILD_STRING"
    LIST_EXTEND = "LIST_EXTEND"
    SET_UPDATE = "SET_UPDATE"
    DICT_MERGE = "DICT_MERGE"
    DICT_UPDATE = "DICT_UPDATE"
    CALL = "CALL"
    KW_NAMES = "KW_NAMES"
    CALL_INTRINSIC_1 = "CALL_INTRINSIC_1"
    CALL_INTRINSIC_2 = "CALL_INTRINSIC_2"
    LOAD_FROM_DICT_OR_DEREF = "LOAD_FROM_DICT_OR_DEREF"
    INSTRUMENTED_LOAD_SUPER_ATTR = "INSTRUMENTED_LOAD_SUPER_ATTR"
    INSTRUMENTED_POP_JUMP_IF_NONE = "INSTRUMENTED_POP_JUMP_IF_NONE"
    INSTRUMENTED_POP_JUMP_IF_NOT_NONE = "INSTRUMENTED_POP_JUMP_IF_NOT_NONE"
    INSTRUMENTED_RESUME = "INSTRUMENTED_RESUME"
    INSTRUMENTED_CALL = "INSTRUMENTED_CALL"
    INSTRUMENTED_RETURN_VALUE = "INSTRUMENTED_RETURN_VALUE"
    INSTRUMENTED_YIELD_VALUE = "INSTRUMENTED_YIELD_VALUE"
    INSTRUMENTED_CALL_FUNCTION_EX = "INSTRUMENTED_CALL_FUNCTION_EX"
    INSTRUMENTED_JUMP_FORWARD = "INSTRUMENTED_JUMP_FORWARD"
    INSTRUMENTED_JUMP_BACKWARD = "INSTRUMENTED_JUMP_BACKWARD"
    INSTRUMENTED_RETURN_CONST = "INSTRUMENTED_RETURN_CONST"
    INSTRUMENTED_FOR_ITER = "INSTRUMENTED_FOR_ITER"
    INSTRUMENTED_POP_JUMP_IF_FALSE = "INSTRUMENTED_POP_JUMP_IF_FALSE"
    INSTRUMENTED_POP_JUMP_IF_TRUE = "INSTRUMENTED_POP_JUMP_IF_TRUE"
    INSTRUMENTED_END_FOR = "INSTRUMENTED_END_FOR"
    INSTRUMENTED_END_SEND = "INSTRUMENTED_END_SEND"
    INSTRUMENTED_INSTRUCTION = "INSTRUMENTED_INSTRUCTION"
    INSTRUMENTED_LINE = "INSTRUMENTED_LINE"
    FOR_ITER = "FOR_ITER"
    JUMP_FORWARD = "JUMP_FORWARD"
    POP_JUMP_IF_FALSE = "POP_JUMP_IF_FALSE"
    POP_JUMP_IF_TRUE = "POP_JUMP_IF_TRUE"
    SEND = "SEND"
    POP_JUMP_IF_NOT_NONE = "POP_JUMP_IF_NOT_NONE"
    POP_JUMP_IF_NONE = "POP_JUMP_IF_NONE"
    JUMP_BACKWARD_NO_INTERRUPT = "JUMP_BACKWARD_NO_INTERRUPT"
    JUMP_BACKWARD = "JUMP_BACKWARD"
    STORE_NAME = "STORE_NAME"
    DELETE_NAME = "DELETE_NAME"
    STORE_ATTR = "STORE_ATTR"
    DELETE_ATTR = "DELETE_ATTR"
    STORE_GLOBAL = "STORE_GLOBAL"
    DELETE_GLOBAL = "DELETE_GLOBAL"
    LOAD_NAME = "LOAD_NAME"
    LOAD_ATTR = "LOAD_ATTR"
    IMPORT_NAME = "IMPORT_NAME"
    IMPORT_FROM = "IMPORT_FROM"
    LOAD_GLOBAL = "LOAD_GLOBAL"
    LOAD_SUPER_ATTR = "LOAD_SUPER_ATTR"
    LOAD_FROM_DICT_OR_GLOBALS = "LOAD_FROM_DICT_OR_GLOBALS"
