# Observability guide

`svc_infra.obs` adds Prometheus metrics, OpenTelemetry instrumentation, and a CLI to spin up Grafana dashboards.

```python
from svc_infra.api.fastapi.ease import easy_service_app

app = easy_service_app(name="Billing", release="1.2.3")  # ENABLE_OBS toggles middleware
```

### Environment

- `ENABLE_OBS`, `METRICS_PATH`, `OBS_SKIP_PATHS` – FastAPI bootstrap toggles for metrics exposure. 【F:src/svc_infra/api/fastapi/ease.py†L67-L111】
- `SVC_INFRA_DISABLE_PROMETHEUS` – disable the ASGI middleware entirely (used by tests/sidecars). 【F:src/svc_infra/obs/metrics/asgi.py†L49-L206】
- `SVC_INFRA_RATE_WINDOW`, `SVC_INFRA_DASHBOARD_REFRESH`, `SVC_INFRA_DASHBOARD_RANGE` – tune the Grafana dashboards generated by the CLI. 【F:src/svc_infra/obs/cloud_dash.py†L85-L108】
- Grafana Cloud support looks for `GRAFANA_CLOUD_URL`, `GRAFANA_CLOUD_TOKEN`, `GRAFANA_CLOUD_PROM_URL`, `GRAFANA_CLOUD_PROM_USERNAME`, `GRAFANA_CLOUD_RW_TOKEN`. 【F:src/svc_infra/obs/README.md†L37-L119】
