# -*- coding: utf-8 -*-
# Generated by Django 1.10.1 on 2016-09-09 23:19
from __future__ import unicode_literals

from django.db import migrations

def create_permissions(apps, schema_editor):
    User = apps.get_model('auth', 'User')
    ContentType = apps.get_model('contenttypes', 'ContentType')
    Permission = apps.get_model('auth', 'Permission')
    ct = ContentType.objects.get_for_model(User)
    Permission.objects.get_or_create(codename="member", content_type=ct, name="member")
    Permission.objects.get_or_create(codename="group_management", content_type=ct, name="group_management")
    Permission.objects.get_or_create(codename="jabber_broadcast", content_type=ct, name="jabber_broadcast")
    Permission.objects.get_or_create(codename="jabber_broadcast_all", content_type=ct, name="jabber_broadcast_all")
    Permission.objects.get_or_create(codename="fleetactivitytracking", content_type=ct, name="fleetactivitytracking")
    Permission.objects.get_or_create(codename="fleetactivitytracking_statistics", content_type=ct, name="fleetactivitytracking_statistics")
    Permission.objects.get_or_create(codename="human_resources", content_type=ct, name="human_resources")
    Permission.objects.get_or_create(codename="blue_member", content_type=ct, name="blue_member")
    Permission.objects.get_or_create(codename="alliance_apis", content_type=ct, name="alliance_apis")
    Permission.objects.get_or_create(codename="corp_apis", content_type=ct, name="corp_apis")
    Permission.objects.get_or_create(codename="timer_management", content_type=ct, name="timer_management")
    Permission.objects.get_or_create(codename="timer_view", content_type=ct, name="timer_view")
    Permission.objects.get_or_create(codename="srp_management", content_type=ct, name="srp_management")
    Permission.objects.get_or_create(codename="signature_management", content_type=ct, name="signature_management")
    Permission.objects.get_or_create(codename="signature_view", content_type=ct, name="signature_view")
    Permission.objects.get_or_create(codename="optimer_management", content_type=ct, name="optimer_management")
    Permission.objects.get_or_create(codename="optimer_view", content_type=ct, name="optimer_view")
    Permission.objects.get_or_create(codename="logging_notifications", content_type=ct, name="logging_notifications")

def reverse(apps, schema_editor):
    #too lazy
    pass

class Migration(migrations.Migration):

    dependencies = [
        ('authentication', '0003_authservicesinfo_state'),
    ]

    operations = [
        migrations.RunPython(create_permissions, reverse)
    ]
