"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CertbotDnsRoute53Job = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const events = require("aws-cdk-lib/aws-events");
const target = require("aws-cdk-lib/aws-events-targets");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
const lambda_bash_1 = require("./lambda-bash");
class CertbotDnsRoute53Job extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const certOptions = {
            BUCKET_NAME: props.destinationBucket.bucketName,
            EMAIL: props.certbotOptions.email,
            DOMAIN_NAME: props.certbotOptions.domainName,
            CUSTOM_PREFIX_DIRECTORY: props.certbotOptions.customPrefixDirectory,
        };
        const lambdaFun = new lambda_bash_1.BashExecFunction(this, 'certbotDnsRoute53JobLambda', {
            script: path.join(__dirname, '../docker.d/entrypoint.sh'),
            timeout: cdk.Duration.minutes(5),
            architecture: props.architecture ?? lambda.Architecture.X86_64,
            environment: {
                ...certOptions,
            },
        });
        props.destinationBucket.grantReadWrite(lambdaFun.handler.role);
        const route53PolicyJsonList = [{
                Effect: 'Allow',
                Action: [
                    'route53:ListHostedZones',
                    'route53:GetChange',
                ],
                Resource: [
                    '*',
                ],
            },
            {
                Effect: 'Allow',
                Action: [
                    'route53:ChangeResourceRecordSets',
                ],
                Resource: [
                    `arn:aws:route53:::hostedzone/${props.zone.hostedZoneId}`,
                ],
            }];
        route53PolicyJsonList.forEach(e => {
            lambdaFun.handler.role.addToPrincipalPolicy(iam.PolicyStatement.fromJson(e));
        });
        if (props.schedule) {
            new events.Rule(this, 'ScheduleRule', {
                schedule: props.schedule,
                targets: [
                    new target.LambdaFunction(lambdaFun.handler),
                ],
            });
        }
    }
}
exports.CertbotDnsRoute53Job = CertbotDnsRoute53Job;
_a = JSII_RTTI_SYMBOL_1;
CertbotDnsRoute53Job[_a] = { fqn: "cdk-certbot-dns-route53.CertbotDnsRoute53Job", version: "2.1.438" };
//# sourceMappingURL=data:application/json;base64,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