"""pyrmute - versioned Pydantic models and schemas with migrations."""

from ._migration_manager import MigrationManager
from ._registry import Registry
from ._schema_manager import SchemaManager
from ._version import __version__
from .exceptions import (
    InvalidVersionError,
    MigrationError,
    ModelNotFoundError,
    VersionedModelError,
)
from .migration_hooks import MetricsHook, MigrationHook
from .migration_testing import (
    MigrationTestCase,
    MigrationTestCases,
    MigrationTestResult,
    MigrationTestResults,
)
from .model_diff import ModelDiff
from .model_manager import ModelManager
from .model_version import ModelVersion
from .schema_config import SchemaConfig
from .types import (
    JsonSchema,
    JsonSchemaMode,
    MigrationFunc,
    ModelData,
    NestedModelInfo,
)

__all__ = [
    "InvalidVersionError",
    "JsonSchema",
    "JsonSchemaMode",
    "MetricsHook",
    "MigrationError",
    "MigrationFunc",
    "MigrationHook",
    "MigrationManager",
    "MigrationTestCase",
    "MigrationTestCases",
    "MigrationTestResult",
    "MigrationTestResults",
    "ModelData",
    "ModelDiff",
    "ModelManager",
    "ModelNotFoundError",
    "ModelVersion",
    "NestedModelInfo",
    "Registry",
    "SchemaConfig",
    "SchemaManager",
    "VersionedModelError",
    "__version__",
]
