from datetime import timedelta

TIME_DELTA_TO_TZ_NAME_MAP = {
    timedelta(minutes=60 * 12.0): 'Etc/GMT+12',
    timedelta(minutes=60 * 11.0): 'Etc/GMT+11',
    timedelta(minutes=60 * 10): 'Etc/GMT+10',
    timedelta(minutes=60 * 9.5): 'Pacific/Marquesas',
    timedelta(minutes=60 * 9.0): 'Etc/GMT+9',
    timedelta(minutes=60 * 8.0): 'Etc/GMT+8',
    timedelta(minutes=60 * 7.0): 'Etc/GMT+7',
    timedelta(minutes=60 * 6.0): 'Etc/GMT+6',
    timedelta(minutes=60 * 5.0): 'Etc/GMT+5',
    timedelta(minutes=60 * 4.0): 'Etc/GMT+4',
    timedelta(minutes=60 * 3.0): 'Etc/GMT+3',
    timedelta(minutes=60 * 2.5): 'Canada/Newfoundland',
    timedelta(minutes=60 * 2.0): 'Etc/GMT+2',
    timedelta(minutes=60 * 1.0): 'Etc/GMT+1',
    timedelta(minutes=60 * -0.0): 'UTC',
    timedelta(minutes=60 * -1.0): 'Etc/GMT-1',
    timedelta(minutes=60 * -2.0): 'Etc/GMT-2',
    timedelta(minutes=60 * -3.0): 'Etc/GMT-3',
    timedelta(minutes=60 * -3.5): 'Asia/Tehran',
    timedelta(minutes=60 * -4.0): 'Etc/GMT-4',
    timedelta(minutes=60 * -4.5): 'Asia/Kabul',
    timedelta(minutes=60 * -5.0): 'Etc/GMT-5',
    timedelta(minutes=60 * -5.5): 'Asia/Colombo',
    timedelta(minutes=60 * -5.75): 'Asia/Katmandu',
    timedelta(minutes=60 * -6.0): 'Etc/GMT-6',
    timedelta(minutes=60 * -6.5): 'Asia/Yangon',
    timedelta(minutes=60 * -7.0): 'Etc/GMT-7',
    timedelta(minutes=60 * -8.0): 'Etc/GMT-8',
    timedelta(minutes=60 * -8.75): 'Australia/Eucla',
    timedelta(minutes=60 * -9.0): 'Etc/GMT-9',
    timedelta(minutes=60 * -9.5): 'Australia/North',
    timedelta(minutes=60 * -10.0): 'Etc/GMT-10',
    timedelta(minutes=60 * -10.5): 'Australia/South',
    timedelta(minutes=60 * -11.0): 'Etc/GMT-11',
    timedelta(minutes=60 * -12.0): 'Etc/GMT-12',
    timedelta(minutes=60 * -13.0): 'Etc/GMT-13',
    timedelta(minutes=60 * -13.75): 'Pacific/Chatham',
    timedelta(minutes=60 * -14.00): 'Etc/GMT-14',
}

TZ_NAME_TO_TIME_DELTA_MAP = {
    'Etc/GMT+12': timedelta(minutes=60 * 12.0),
    'Etc/GMT+11': timedelta(minutes=60 * 11.0),
    'Etc/GMT+10': timedelta(minutes=60 * 10),
    'Pacific/Marquesas': timedelta(minutes=60 * 9.5),
    'Etc/GMT+9': timedelta(minutes=60 * 9.0),
    'Etc/GMT+8': timedelta(minutes=60 * 8.0),
    'Etc/GMT+7': timedelta(minutes=60 * 7.0),
    'Etc/GMT+6': timedelta(minutes=60 * 6.0),
    'Etc/GMT+5': timedelta(minutes=60 * 5.0),
    'Etc/GMT+4': timedelta(minutes=60 * 4.0),
    'Etc/GMT+3': timedelta(minutes=60 * 3.0),
    'Canada/Newfoundland': timedelta(minutes=60 * 2.5),
    'Etc/GMT+2': timedelta(minutes=60 * 2.0),
    'Etc/GMT+1': timedelta(minutes=60 * 1.0),
    'UTC': timedelta(minutes=60 * -0.0),
    'Etc/GMT-1': timedelta(minutes=60 * -1.0),
    'Etc/GMT-2': timedelta(minutes=60 * -2.0),
    'Etc/GMT-3': timedelta(minutes=60 * -3.0),
    'Asia/Tehran': timedelta(minutes=60 * -3.5),
    'Etc/GMT-4': timedelta(minutes=60 * -4.0),
    'Asia/Kabul': timedelta(minutes=60 * -4.5),
    'Etc/GMT-5': timedelta(minutes=60 * -5.0),
    'Asia/Colombo': timedelta(minutes=60 * -5.5),
    'Asia/Katmandu': timedelta(minutes=60 * -5.75),
    'Etc/GMT-6': timedelta(minutes=60 * -6.0),
    'Asia/Yangon': timedelta(minutes=60 * -6.5),
    'Etc/GMT-7': timedelta(minutes=60 * -7.0),
    'Etc/GMT-8': timedelta(minutes=60 * -8.0),
    'Australia/Eucla': timedelta(minutes=60 * -8.75),
    'Etc/GMT-9': timedelta(minutes=60 * -9.0),
    'Australia/North': timedelta(minutes=60 * -9.5),
    'Etc/GMT-10': timedelta(minutes=60 * -10.0),
    'Australia/South': timedelta(minutes=60 * -10.5),
    'Etc/GMT-11': timedelta(minutes=60 * -11.0),
    'Etc/GMT-12': timedelta(minutes=60 * -12.0),
    'Etc/GMT-13': timedelta(minutes=60 * -13.0),
    'Pacific/Chatham': timedelta(minutes=60 * -13.75),
    'Etc/GMT-14': timedelta(minutes=60 * -14.00),
}
