# Generated by Django 2.2.13 on 2020-07-10 09:41

from django.db import migrations, models


def assign_relative_path(apps, schema_editor):
    repo_metadata = apps.get_model('rpm', 'RepoMetadataFile')
    for metadata in repo_metadata.objects.all():
        metadata.relative_path = metadata.contentartifact_set.first().relative_path
        metadata.save()


class Migration(migrations.Migration):

    dependencies = [
        ('rpm', '0014_rpmrepository_package_retention_policy'),
    ]

    operations = [
        migrations.AddField(
            model_name='repometadatafile',
            name='relative_path',
            field=models.TextField(default=''),
            preserve_default=False,
        ),
        migrations.AlterUniqueTogether(
            name='repometadatafile',
            unique_together={('data_type', 'checksum', 'relative_path')},
        ),
        migrations.RunPython(assign_relative_path)
    ]
