metadata = {
    "CKV_DOCKER_1": {
        "url": "https://docs.bridgecrew.io/docs/ensure-port-22-is-not-exposed",
        "severity": "LOW",
        "description": "<h4>Port 22 is exposed</h4><h4>Description</h4>By exposing port 22,  you may allow a bad actor to brute force their way into the system and potentially get access to the entire network. As a best practice, restrict SSH solely to known static IP addresses. Limit the access list to include known hosts, services, or specific employees only.<br><h4>Fix - Buildtime</h4>Docker<br>DockerfileFROM busybox<br><br>EXPOSE 8080<br>"
    },
    "CKV_DOCKER_2": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-healthcheck-instructions-have-been-added-to-container-images",
        "severity": "LOW",
        "description": "<h4>Healthcheck instructions have not been added to container images</h4><h4>Description</h4>We recommend that you add the HEALTHCHECK instruction to your Docker container images  to ensure that health checks are executed against running containers.<br>An important security control is that of availability. Adding the HEALTHCHECK instruction to your container image ensures that the Docker engine periodically checks the running container instances against that instruction to ensure that containers are still operational.<br>Based on the results of the health check, the Docker engine could terminate containers which are not responding correctly, and instantiate new ones.<br><h4>Fix - Buildtime</h4>Docker<br>DockerfileFROM base<br><br>LABEL foo=\"bar baz<br>USER  me<br>HEALTHCHECK CMD curl --fail http://localhost:3000 || exit 1<br>"
    },
    "CKV_DOCKER_3": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-a-user-for-the-container-has-been-created",
        "severity": "LOW",
        "description": "<h4>A user for the container has not been created</h4><h4>Description</h4>Containers should run as a non-root user. It is good practice to run the container as a non-root user, where possible. This can be done either via the USER directive in the Dockerfile or through gosu or similar where used as part of the CMD or ENTRYPOINT directives.<br><h4>Fix - Buildtime</h4>Docker<br>DockerfileFROM base<br><br>LABEL foo=\"bar baz<br>USER  me<br>"
    },
    "CKV_DOCKER_4": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-copy-is-used-instead-of-add-in-dockerfiles",
        "severity": "LOW",
        "description": "<h4>Copy is not used instead of Add in Dockerfiles</h4><h4>Description</h4>The Copy instruction simply copies files from the local host machine to the container file system. The Add instruction could potentially retrieve files from remote URLs and perform operations such as unpacking them. The Add instruction, therefore, introduces security risks. For example, malicious files may be directly accessed from URLs without scanning, or there may be vulnerabilities associated with decompressing them<br>We recommend you use the Copy instruction instead of the Add instruction in the Dockerfile.<br><h4>Fix - Buildtime</h4>Dockerfile<br>Dockerfile- ADD config.txt /app/<br>+ COPY config.txt /app/<br>"
    },
    "CKV_DOCKER_5": {
        "url": "https://docs.bridgecrew.io/docs/ensure-update-instructions-are-not-used-alone-in-the-dockerfile",
        "severity": "LOW",
        "description": "<h4>Update instructions are used alone in a Dockerfile</h4><h4>Description</h4>You should not use OS package manager update instructions such as apt-get update or yum update either alone or in a single line in the Dockerfile.<br>Adding update instructions in a single line on the Dockerfile will cause the update layer to be cached. When you then build any image later using the same instruction, this will cause the previously cached update layer to be used, potentially preventing any fresh updates from being applied to later builds.<br><h4>Fix - Buildtime</h4>Docker<br>DockerfileFROM base<br><br>RUN apt-get update \\<br>&& apt-get install -y --no-install-recommends foo \\<br>&& echo gooo<br><br>RUN apk update \\<br>&& apk add --no-cache suuu looo<br><br>RUN apk --update add moo<br>"
    },
    "CKV_DOCKER_7": {
        "url": "https://docs.bridgecrew.io/docs/ensure-the-base-image-uses-a-non-latest-version-tag",
        "severity": "LOW",
        "description": "<h4>Base image uses a latest version tag</h4><h4>Description</h4>When possible, it is recommended to pin the version for the base image in your Dockerfiles. There are a number of potential issues that may be caused when using the latest tag. Since latest is the default tag when a tag is not specified, it does not automatically refer to the latest version of the image. This can lead to the use of outdated images and in the case of production deployments, using a dynamic version can cause unexpected behavior and difficulty in determining which version is being currently used. It is best practice to be specific as possible about what is running to make operations predictable and reliable<br><h4>Fix - Buildtime</h4>Dockerfile<br>Dockerfile- FROM alpine:latest<br>+ FROM alpine:3.17.1<br>"
    },
    "CKV_DOCKER_8": {
        "url": "https://docs.bridgecrew.io/docs/ensure-the-last-user-is-not-root",
        "severity": "LOW",
        "description": "<h4>Last USER is root</h4><h4>Description</h4>The Docker containers by default run with the root privilege and so does the application that runs inside the container. This is a major concern from the security perspective because hackers can gain root access to the Docker host by hacking the application running inside the container.<br><h4>Fix - Buildtime</h4>Dockerfile<br>Remove USER root or add a non-root user after.<br>DockerfileFROM base<br><br>- USER root<br>+ USER userA<br>"
    },
    "CKV_DOCKER_6": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-label-maintainer-is-used-instead-of-maintainer-deprecated",
        "severity": "LOW",
        "description": "<h4>LABEL maintainer is not used instead of MAINTAINER (deprecated)</h4><h4>Description</h4>The LABEL instruction is much more flexible and recommended to replace the MAINTAINER (deprecated) instruction in a Dockerfile.<br><h4>Fix - Buildtime</h4>Docker<br>DockerfileFROM  base<br><br>- MAINTAINER bad<br>+ LABEL maintainer = good<br>"
    },
    "CKV_DOCKER_9": {
        "url": "https://docs.bridgecrew.io/docs/ensure-docker-apt-is-not-used",
        "severity": "LOW",
        "description": "<h4>Docker APT is used</h4><h4>Description</h4>It is generally a best practice to avoid using APT (Advanced Package Tool) when working with Docker containers. This is because APT is designed to work with traditional server-based environments, and may not be well-suited for use with containers.<br>Using APT with Docker containers can create potential security risks, as it may allow packages to be installed that are not designed to work with containers. This can lead to compatibility issues and potentially compromise the security of your containers.<br><h4>Fix - Buildtime</h4>Docker<br>DockerfileFROM busybox:1.0<br>RUN apt-get install curl<br>HEALTHCHECK CMD curl --fail http://localhost:3000 || exit 1<br>"
    },
    "CKV_DOCKER_10": {
        "url": "https://docs.bridgecrew.io/docs/ensure-docker-workdir-values-are-absolute-paths",
        "severity": "LOW",
        "description": "<h4>Docker WORKDIR values are not absolute paths</h4><h4>Description</h4>Using absolute paths for the WORKDIR values in your Dockerfiles can help improve the security and reliability of your builds. The WORKDIR value specifies the working directory for the build stage, and using an absolute path ensures that the correct directory is being used.<br>By using absolute paths for WORKDIR, you can help prevent potential issues such as using the wrong directory for a stage, which can lead to compatibility problems and potentially compromise the security of your containers. It can also help ensure that your builds are consistent and reliable, as you can easily identify which directory is being used for each stage.<br><h4>Fix - Buildtime</h4>Docker<br>DockerfileFROM alpine:3.5<br>RUN apk add --update py2-pip<br>RUN pip install --upgrade pip<br>WORKDIR /path/to/workdir<br>WORKDIR /<br>WORKDIR c:\\\\windows<br>WORKDIR \"/path/to/workdir\"<br>WORKDIR \"c:\\\\windows\"<br>ENV DIRPATH=/path<br>ENV GLASSFISH_ARCHIVE glassfish5<br>WORKDIR $DIRPATH/$DIRNAME<br>WORKDIR ${GLASSFISH_HOME}/bin<br>COPY requirements.txt /usr/src/app/<br>RUN pip install --no-cache-dir -r /usr/src/app/requirements.txt<br>COPY app.py /usr/src/app/<br>COPY templates/index.html /usr/src/app/templates/<br>EXPOSE 5000<br>CMD [\"python\", \"/usr/src/app/app.py\"]<br>"
    },
    "CKV_DOCKER_11": {
        "url": "https://docs.bridgecrew.io/docs/ensure-docker-from-alias-is-unique-for-multistage-builds",
        "severity": "LOW",
        "description": "<h4>Docker From alias is not unique for multistage builds</h4><h4>Description</h4>Using unique FROM aliases in your Docker multistage builds can help improve the security and reliability of your builds. The FROM alias is used to specify the base image for a build stage, and using a unique alias for each stage can help prevent confusion and ensure that the correct image is being used.<br><h4>Fix - Buildtime</h4>Docker<br>DockerfileFROM debian:jesse1 as build<br>RUN stuff<br><br>FROM debian:jesse1 as another-alias<br>RUN more_stuff<br>"
    },
    "CKV_K8S_6": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_5",
        "severity": "MEDIUM",
        "description": "<h4>Root containers admitted</h4><h4>Description</h4>In Kubernetes, a container's user ID table maps to the host's user table. Running a process as the root user inside a container runs it as root on the host. Many container images use the root user to run PID 1. If PID 1 is compromised, an attacker has root permissions in the container, and any misconfigurations can be exploited.<br>Containers that run as root frequently have more permissions than their workload requires which, in case of compromise, could help an attacker further their exploits.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: PodSecurityPolicy<br>Arguments:<br>runAsUser:rule:MustRunAsNonRoot - Unable containers to run with root privileges.<br>runAsUser:rule:MustRunAs - When the minimum range is set to 1 or higher, containers cannot run as root.<br><br>YAMLapiVersion: policy/v1beta1<br>kind: PodSecurityPolicy<br>metadata:<br>name: <policy name><br>spec:<br>runAsUser:<br>+   rule: 'MustRunAsNonRoot'<br>or<br>rule: 'MustRunAs'<br>ranges:<br>+   - min: <min user, 1 or higher><br>max: <max user><br><br>To use a PodSecurityPolicy resource, the requesting user or target pod\u2019s service account must be authorized to use the policy. The preferred method is to grant access to the service account. In the following example we use RBAC, a standard Kubernetes authorization mode.<br>A Role or ClusterRole needs to grant access to use the desired policies.<br>Kind: ClusterRole<br>YAMLapiVersion: rbac.authorization.k8s.io/v1<br>kind: ClusterRole<br>metadata:<br>name: <role name><br>rules:<br>- apiGroups: ['policy']<br>resources: ['podsecuritypolicies']<br>verbs:     ['use']<br>resourceNames:<br>- <policy name><br><br>The ClusterRole is bound to the authorized service(s):<br>Kind: ClusterRoleBinding<br>YAMLapiVersion: rbac.authorization.k8s.io/v1<br>kind: ClusterRoleBinding<br>metadata:<br>name: <binding name><br>roleRef:<br>kind: ClusterRole<br>name: <role name><br>apiGroup: rbac.authorization.k8s.io<br>subjects:<br>- kind: ServiceAccount<br>name: <authorized service account name><br>namespace: <authorized pod namespace><br>"
    },
    "CKV_K8S_1": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_1",
        "severity": "MEDIUM",
        "description": "<h4>Containers wishing to share host process ID namespace admitted</h4><h4>Description</h4>When process namespace sharing is enabled, processes in a container are visible to all other containers in that pod. This feature can enable configuring cooperating containers that do not include debugging tools, such as a logger sidecar container or troubleshooting container images.<br>Sharing the host process ID namespace breaks the isolation between container images and can make processes visible to other containers in the pod. This includes all information in the /proc directory, which can sometimes include passwords or keys, passed as environment variables.<br>We recommend you do not admit containers wishing to share the host process ID namespace.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: PodSecurityPolicy<br>Argument: hostPID (Optional)<br>When set to false, Pod are unable to use their host's PID namespace.<br><br>YAMLapiVersion: policy/v1beta1<br>kind: PodSecurityPolicy<br>metadata:<br>name: <policy name><br>spec:<br>+ hostPID: false<br><br>To use a PodSecurityPolicy resource the requesting user or target pod\u2019s service account must be authorized to use the policy. The preferred method is to grant access to the service account. In the following example we use RBAC, a standard Kubernetes authorization mode.<br>A Role or ClusterRole must grant access to use the desired policies.<br>Kind: ClusterRole<br>YAMLapiVersion: rbac.authorization.k8s.io/v1<br>kind: ClusterRole<br>metadata:<br>name: <role name><br>rules:<br>- apiGroups: ['policy']<br>resources: ['podsecuritypolicies']<br>verbs:     ['use']<br>resourceNames:<br>- <policy name><br><br>The ClusterRole is then bound to the authorized service(s):<br>Kind: ClusterRoleBinding<br>YAMLapiVersion: rbac.authorization.k8s.io/v1<br>kind: ClusterRoleBinding<br>metadata:<br>name: <binding name><br>roleRef:<br>kind: ClusterRole<br>name: <role name><br>apiGroup: rbac.authorization.k8s.io<br>subjects:<br>- kind: ServiceAccount<br>name: <authorized service account name><br>namespace: <authorized pod namespace><br>"
    },
    "CKV_K8S_2": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_2",
        "severity": "HIGH",
        "description": "<h4>Privileged containers are admitted</h4><h4>Description</h4>Privileged containers are containers that have all of the root capabilities of a host machine, allowing  access to resources that are not accessible in ordinary containers.<br>Running a container with a privileged flag allows users to have critical access to the host\u2019s resources. If a privileged container is compromised, it does not necessarily entail remote code execution, but it implies that an attacker will be able to run full host root with all of the available capabilities, including  CAP_SYS_ADMIN.<br>Common uses of privileged containers include: running a Docker daemon inside a Docker container, running a container with direct hardware access, and automating CI/CD tasks in the open-source automation server Jenkins.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: PodSecurityPolicy<br>Argument: privileged (Optional)<br>When set to false, containers are unable to run processes that are essentially equivalent to root on the host.<br><br>YAMLapiVersion: policy/v1beta1<br>kind: PodSecurityPolicy<br>metadata:<br>name: <policy name><br>spec:<br>+ privileged: false<br><br>To use a PodSecurityPolicy resource, the requesting user or target pod\u2019s service account must be authorized to use the policy. The preferred method is to grant access to the service account. In the following example we use RBAC, a standard Kubernetes authorization mode.<br>A Role or ClusterRole must grant access to use the desired policies.<br>Kind: ClusterRole<br>YAMLapiVersion: rbac.authorization.k8s.io/v1<br>kind: ClusterRole<br>metadata:<br>name: <role name><br>rules:<br>- apiGroups: ['policy']<br>resources: ['podsecuritypolicies']<br>verbs:     ['use']<br>resourceNames:<br>- <policy name><br><br>The ClusterRole is then bound to the authorized service(s):<br>Kind: ClusterRoleBinding<br>YAMLapiVersion: rbac.authorization.k8s.io/v1<br>kind: ClusterRoleBinding<br>metadata:<br>name: <binding name><br>roleRef:<br>kind: ClusterRole<br>name: <role name><br>apiGroup: rbac.authorization.k8s.io<br>subjects:<br>- kind: ServiceAccount<br>name: <authorized service account name><br>namespace: <authorized pod namespace><br>"
    },
    "CKV_K8S_3": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_3",
        "severity": "MEDIUM",
        "description": "<h4>Containers wishing to share host IPC namespace admitted</h4><h4>Description</h4>The host IPC namespace controls whether a pod's containers can be shared. You can administer cluster-level restrictions to ensure that containers remain isolated using PodSecurityPolicy and ensuring hostIPC is set to False.<br>Preventing sharing of host PID/IPC namespace, networking, and ports ensures proper isolation between Docker containers and the underlying host.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: PodSecurityPolicy<br>Argument: hostIPC<br>Determines if the policy allows the use of HostIPC in the pod spec.<br><br>YAMLapiVersion: policy/v1beta1<br>kind: PodSecurityPolicy<br>metadata:<br>name: <policy name><br>spec:<br>+ hostIPC: false<br><br>To use a PodSecurityPolicy resource, the requesting user or target pod\u2019s service account must be authorized to use the policy. The preferred method is to grant access to the service account. In the following example we use RBAC, a standard Kubernetes authorization mode.<br>A Role or ClusterRole must grant access to use the desired policies.<br>Kind: ClusterRole<br>YAMLapiVersion: rbac.authorization.k8s.io/v1<br>kind: ClusterRole<br>metadata:<br>name: <role name><br>rules:<br>- apiGroups: ['policy']<br>resources: ['podsecuritypolicies']<br>verbs:     ['use']<br>resourceNames:<br>- <policy name><br><br>The ClusterRole is then bound to the authorized service(s):<br>Kind: ClusterRoleBinding<br>YAMLapiVersion: rbac.authorization.k8s.io/v1<br>kind: ClusterRoleBinding<br>metadata:<br>name: <binding name><br>roleRef:<br>kind: ClusterRole<br>name: <role name><br>apiGroup: rbac.authorization.k8s.io<br>subjects:<br>- kind: ServiceAccount<br>name: <authorized service account name><br>namespace: <authorized pod namespace><br>"
    },
    "CKV_K8S_4": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_4",
        "severity": "MEDIUM",
        "description": "<h4>Containers wishing to share host network namespace admitted</h4><h4>Description</h4>In a Kubernetes cluster, every pod gets its own IP address. Pods can be treated much like VMs or physical hosts from the perspectives of port allocation, naming, service discovery, load balancing, application configuration, and migration.<br>Sharing the host network namespace breaks the isolation between container images and can make the host visible to other containers in the pod. In some cases, pods in the host network of a node can communicate with all pods on all nodes without using network address translation (NAT).<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: PodSecurityPolicy<br>Argument: hostNetwork (Optional)<br>When set to false, Pods are unable to use their host's network namespace.<br><br>YAMLapiVersion: policy/v1beta1<br>kind: PodSecurityPolicy<br>metadata:<br>name: <policy name><br>spec:<br>+ hostNetwork: false<br><br>To use a PodSecurityPolicy resource, the requesting user or target pod\u2019s service account must be authorized to use the policy. The preferred method is to grant access to the service account. In the following example we use RBAC, a standard Kubernetes authorization mode.<br>A Role or ClusterRole needs to grant access to use the desired policies.<br>Kind: ClusterRole<br>YAMLapiVersion: rbac.authorization.k8s.io/v1<br>kind: ClusterRole<br>metadata:<br>name: <role name><br>rules:<br>- apiGroups: ['policy']<br>resources: ['podsecuritypolicies']<br>verbs:     ['use']<br>resourceNames:<br>- <policy name><br><br>The ClusterRole is then bound to the authorized service(s):<br>Kind: ClusterRoleBinding<br>YAMLapiVersion: rbac.authorization.k8s.io/v1<br>kind: ClusterRoleBinding<br>metadata:<br>name: <binding name><br>roleRef:<br>kind: ClusterRole<br>name: <role name><br>apiGroup: rbac.authorization.k8s.io<br>subjects:<br>- kind: ServiceAccount<br>name: <authorized service account name><br>namespace: <authorized pod namespace><br>"
    },
    "CKV_K8S_7": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_6",
        "severity": "LOW",
        "description": "<h4>Containers with NET_RAW capability admitted</h4><h4>Description</h4>NET_RAW is a default permissive setting in Kubernetes allowing ICMP traffic between containers and  grants an application the ability to craft raw packets.<br>In the hands of an attacker NET_RAW can enable a wide variety of networking exploits from within the cluster.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: PodSecurityPolicy<br>Argument: requiredDropCapabilities (Optional)<br>Defines the capabilities which must be dropped from containers. These capabilities are removed from the default set, and must not be added. NET_RAW capability is removed when the field includes it specifically, or when it includes ALL.<br><br>YAMLapiVersion: policy/v1beta1<br>kind: PodSecurityPolicy<br>metadata:<br>name: <policy name><br>spec:<br>requiredDropCapabilities:<br>+   -ALL<br>or<br>+ -NET_RAW<br><br>To use a PodSecurityPolicy resource, the requesting user or target pod\u2019s service account must be authorized to use the policy. The preferred method is to grant access to the service account. In the following example we use RBAC, a standard Kubernetes authorization mode.<br>First, a Role or ClusterRole needs to grant access to use the desired policies.<br>Kind: ClusterRole<br>YAMLapiVersion: rbac.authorization.k8s.io/v1<br>kind: ClusterRole<br>metadata:<br>name: <role name><br>rules:<br>- apiGroups: ['policy']<br>resources: ['podsecuritypolicies']<br>verbs:     ['use']<br>resourceNames:<br>- <policy name><br><br>The ClusterRole is then bound to the authorized service(s):<br>Kind: ClusterRoleBinding<br>YAMLapiVersion: rbac.authorization.k8s.io/v1<br>kind: ClusterRoleBinding<br>metadata:<br>name: <binding name><br>roleRef:<br>kind: ClusterRole<br>name: <role name><br>apiGroup: rbac.authorization.k8s.io<br>subjects:<br>- kind: ServiceAccount<br>name: <authorized service account name><br>namespace: <authorized pod namespace><br>"
    },
    "CKV_K8S_8": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_7",
        "severity": "LOW",
        "description": "<h4>Liveness probe is not configured</h4><h4>Description</h4>The kubelet uses liveness probes to know when to schedule restarts for containers. Restarting a container in a deadlock state can help to make the application more available, despite bugs.<br>If a container is unresponsive, either to a deadlocked application or a multi-threading defect, restarting the container can make the application more available, despite the defect.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Container<br>Field: livenessProbe (Optional)<br>The probe describes a health check to be performed against a container to determine whether it is alive or not.<br>Its arguments may include: exec, failureThreshold, httpGet, initialDelaySeconds, periodSeconds, successThreshold, tcpSocket and timeoutSeconds.<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>+   livenessProbe:<br><Probe arguments><br>"
    },
    "CKV_K8S_9": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_8",
        "severity": "LOW",
        "description": "<h4>Readiness probe is not configured</h4><h4>Description</h4>Readiness Probe is a Kubernetes capability that enables teams to make their applications more reliable and robust. This probe regulates under what circumstances the pod should be taken out of the list of service endpoints so that it no longer responds to requests. In defined circumstances the probe can remove the pod from the list of available service endpoints.<br>Using the Readiness Probe ensures teams define what actions need to be taken to prevent failure and ensure recovery in case of unexpected errors.<br>Kubernetes.io Documentation<br><h4>Fix - Buildtime</h4>Kubernetes<br>Resource: Container<br>Field: readinessProbe (Optional)<br>The probe describes a health check to be performed against a container to determine whether it is ready for traffic or not.<br>Its configurations may include: exec, failureThreshold, httpGet, initialDelaySeconds, periodSeconds, successThreshold, tcpSocket and timeoutSeconds.<br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>+   readinessProbe:<br><Probe configurations><br>"
    },
    "CKV_K8S_10": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_9",
        "severity": "LOW",
        "description": "<h4>CPU request is not set</h4><h4>Description</h4>When specifying the resource request for containers in a pod, the scheduler uses this information to decide which node to place the pod on. When setting resource limit for a container, the kubelet enforces those limits so that the running container is not allowed to use more of that resource than the limit you set.<br>If a container is created in a namespace that has a default CPU limit, and the container does not specify its own CPU limit, then the container is assigned the default CPU limit. Kubernetes assigns a default CPU request under certain conditions.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Container<br>Argument: resources:requests:cpu (Optional)<br>Defines the CPU request size for the container.<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>resources:<br>requests:<br>+       cpu: <cpu request><br>"
    },
    "CKV_K8S_11": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_10",
        "severity": "LOW",
        "description": "<h4>CPU limits are not set</h4><h4>Description</h4>Kubernetes allows administrators to set CPU quotas in namespaces, as hard limits for resource usage. Containers cannot use more CPU than the configured limit. Provided the system has CPU time free, a container is guaranteed to be allocated as much CPU as it requests.<br>CPU quotas are used to ensure adequate utilization of shared resources. A system without managed quotas could eventually collapse due to  inadequate resources for the tasks it bares.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Container<br>Argument: resources:limits:cpu (Optional)<br>Defines the CPU limit for the container.<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>resources:<br>limits:<br>+       cpu: <cpu limit><br>"
    },
    "CKV_K8S_12": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_11",
        "severity": "LOW",
        "description": "<h4>Memory requests are not set</h4><h4>Description</h4>Memory resources can be defined using values from bytes to petabytes, it is common to use mebibytes. If you configure a memory request that is larger than the amount of memory on your nodes, the pod will never be scheduled. When specifying a memory request for a container, include the resources:requests field in the container\u2019s resource manifest. To specify a memory limit, include resources:limits.<br>Setting memory requests enforces a memory limit for a container. A container is guaranteed to have as much memory as it requests, but is not allowed to use more memory than the limit set. This configuration may save resources and prevent an attack on an exploited container.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Container<br>Argument: resources:requests:memory (Optional)<br>Defines the memory request size for the container.<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>resources:<br>requests:<br>+       memory: <memory request><br>"
    },
    "CKV_K8S_13": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_12",
        "severity": "LOW",
        "description": "<h4>Memory limits are not set</h4><h4>Description</h4>The scheduler uses resource request information for containers in a pod to decide which node to place the pod on. The kubelet enforces the resource limits set, so that the running container is not allowed to use more resource than the limit set.<br>If a process in the container tries to consume more than the allowed amount of memory, the system kernel terminates the process that attempted the allocation, with an out of memory (OOM) error. With no limit set, kubectl allocates more and more memory to the container until it runs out.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Container<br>Argument: resources:limits:memory (Optional)<br>Defines the memory limit for the container.<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>resources:<br>limits:<br>+       memory: <memory limit><br>"
    },
    "CKV_K8S_16": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_15",
        "severity": "HIGH",
        "description": "<h4>Container is privileged</h4><h4>Description</h4>Privileged containers are containers that have all of the root capabilities of a host machine, allowing access to resources that are not accessible in ordinary containers. Common uses of privileged containers include: running a Docker daemon inside a Docker container, running a container with direct hardware access, and automating CI/CD tasks in the open-source automation server Jenkins.<br>Running a container with a privileged flag allows users to have critical access to the host\u2019s resources. If a privileged container is compromised, it does not necessarily entail remote code execution, but it implies that an attacker will be able to run full host root with all of the available capabilities, including  CAP_SYS_ADMIN.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Container<br>Argument: privileged (Optional)<br>If true, processes in the privileged containers are essentially equivalent to root on the host. Default to false.<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <Pod name><br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>securityContext:<br>-      privileged: true<br>"
    },
    "CKV_K8S_17": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_16",
        "severity": "MEDIUM",
        "description": "<h4>Containers share host process ID namespace</h4><h4>Description</h4>Namespaces provide isolation for running processes and limit access to system resources, without the running process agnostic to its limitations.<br>To limit an attacker's options to escalate privileges from within a container, we recommend you configure containers to refrain from sharing the host process ID namespace.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Pod / Deployment / DaemonSet / StatefulSet / ReplicaSet / ReplicationController / Job / CronJob<br>Argument: hostPID (Optional)<br>If true, the Pod uses the host's PID namespace. Default to false.<br><br>PodCronJobOtherapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>spec:<br>- hostPID: true<br>apiVersion: batch/v1beta1<br>kind: CronJob<br>metadata:<br>name: <name><br>spec:<br>schedule: <><br>jobTemplate:<br>spec:<br>template:<br>spec:<br>-          hostPID: true<br>apiVersion: <><br>kind: <kind><br>metadata:<br>name: <name><br>spec:<br>template:<br>spec:<br>-       hostPID: true<br>"
    },
    "CKV_K8S_18": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_17",
        "severity": "MEDIUM",
        "description": "<h4>Containers share host IPC namespace</h4><h4>Description</h4>Pods share many resources, so it could make sense to share a process namespace. Some container images may expect to be isolated from other containers. Not sharing IPC namespaces  helps ensure isolation. Containers in different pods have distinct IP addresses and will need special configuration to communicate by IPC.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Pod / Deployment / DaemonSet / StatefulSet / ReplicaSet / ReplicationController / Job / CronJob<br>Argument: hostIPC (Optional)<br>If true, the Pod uses the host's IPC namespace. Default to false.<br><br>PodCronJobOtherapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>spec:<br>- hostIPC: true<br>apiVersion: batch/v1beta1<br>kind: CronJob<br>metadata:<br>name: <name><br>spec:<br>schedule: <><br>jobTemplate:<br>spec:<br>template:<br>spec:<br>-          hostIPC: true<br>apiVersion: <><br>kind: <kind><br>metadata:<br>name: <name><br>spec:<br>template:<br>spec:<br>-       hostIPC: true<br>"
    },
    "CKV_K8S_19": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_18",
        "severity": "MEDIUM",
        "description": "<h4>Containers share the host network namespace</h4><h4>Description</h4>When using the host network mode for a container, that container\u2019s network stack is not isolated from the Docker host, so the container shares the host\u2019s networking namespace and does not get its own IP-address allocation.<br>To limit an attacker's options to escalate privileges from within a container, we recommend you to configure containers to not share the host network namespace.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Pod / Deployment / DaemonSet / StatefulSet / ReplicaSet / ReplicationController / Job / CronJob<br>Argument: hostNetwork (Optional)<br>If true, the Pod uses the host's network namespace. Default to false.<br><br>PodCronJobOtherapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>spec:<br>- hostNetwork: true<br>apiVersion: batch/v1beta1<br>kind: CronJob<br>metadata:<br>name: <name><br>spec:<br>schedule: <><br>jobTemplate:<br>spec:<br>template:<br>spec:<br>-          hostNetwork: true<br>apiVersion: <><br>kind: <kind><br>metadata:<br>name: <name><br>spec:<br>template:<br>spec:<br>-       hostNetwork: true<br>"
    },
    "CKV_K8S_20": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_19",
        "severity": "MEDIUM",
        "description": "<h4>Containers run with AllowPrivilegeEscalation</h4><h4>Description</h4>The AllowPrivilegeEscalation Pod Security Policy controls whether or not a user is allowed to set the security context of a container to True. Setting it to False ensures that no child process of a container can gain more privileges than its parent.<br>We recommend you to set AllowPrivilegeEscalation to False, to ensure RunAsUser commands cannot bypass their existing sets of permissions.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Container<br>Argument: allowPrivilegeEscalation (Optional)<br>If false, the pod can not request to allow privilege escalation. Default to true.<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <Pod name><br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>securityContext:<br>+      allowPrivilegeEscalation: false<br>"
    },
    "CKV_K8S_21": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_20",
        "severity": "LOW",
        "description": "<h4>Default namespace is used</h4><h4>Description</h4>In Kubernetes, the cluster comes out of the box with a namespace called \u201cdefault.\u201d Other namespaces Kubernetes includes are: default, kube-system and kube-public. Some Kubernetes tooling is set up out of the box to use this namespace and you can\u2019t delete it.<br>We recommend that you do not use the default namespace in large production systems. Using this space can result in accidental disruption with other services. Instead, we recommend you create alternate namespaces and use them to run additional required services.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Pod / Deployment / DaemonSet / StatefulSet / ReplicaSet / ReplicationController / Job / CronJob<br>Argument: namespace (Optional)<br>Defines the used namespace. Default to default.<br><br>YAMLapiVersion: <apiVersion><br>kind: <kind><br>metadata:<br>name: <name><br>+ namespace: <your namespace><br>- namespace: default<br>"
    },
    "CKV_K8S_22": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_21",
        "severity": "LOW",
        "description": "<h4>Read-Only filesystem for containers is not used</h4><h4>Description</h4>A read-only root filesystem helps to enforce an immutable infrastructure strategy. The container should only write on mounted volumes that can persist, even if the container exits.<br>Using an immutable root filesystem and a verified boot mechanism prevents against attackers from \"owning\" the machine through permanent local changes. An immutable root filesystem can also prevent malicious binaries from writing to the host system.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Container<br>Argument: readOnlyRootFilesystem (Optional)<br>Defines whether a container is able to write into the root filesystem. Default to false.<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <Pod name><br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>securityContext:<br>+      readOnlyRootFilesystem: true<br>"
    },
    "CKV_K8S_23": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_22",
        "severity": "MEDIUM",
        "description": "<h4>Admission of root containers not minimized</h4><h4>Description</h4>Containers rely on the traditional Unix security model granting explicit and implicit permissions to resources, through permissions granted to users and groups. User namespaces are not enabled in Kubernetes. The container's user ID table maps to the host's user table, and running a process as the root user inside a container runs it as root on the host. Although possible, we do not recommend running as root inside the container.<br>Containers that run as root usually have far more permissions than their workload requires. In case of compromise, an attacker can use these permissions to further an attack on the network. Several container images use the root user to run PID 1. An attacker will have root permissions in the container and be able to exploit mis-configurations.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Pod / Deployment / DaemonSet / StatefulSet / ReplicaSet / ReplicationController / Job / CronJob<br>Arguments:<br>runAsNonRoot (Optional) If true, Requires the container to run without root privileges. Default to false.<br>runAsUser (Optional) If user number is anything other than 0, requires the container to run with that user id, which is not root.<br><br>PodCronJobOtherapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>spec:<br>securityContext:<br>+   runAsNonRoot: true<br>+   runAsUser: <specific user><br>apiVersion: batch/v1beta1<br>kind: CronJob<br>metadata:<br>name: <name><br>spec:<br>schedule: <><br>jobTemplate:<br>spec:<br>template:<br>spec:<br>securityContext:<br>+            runAsNonRoot: true<br>+                        runAsUser: <specific user><br>apiVersion: <><br>kind: <kind><br>metadata:<br>name: <name><br>spec:<br>template:<br>spec:<br>securityContext:<br>+           runAsNonRoot: true<br>+               runAsUser: <specific user><br>"
    },
    "CKV_K8S_24": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_23",
        "severity": "LOW",
        "description": "<h4>Containers with added capability are allowed</h4><h4>Description</h4>Using the Linux capabilities feature you can grant certain privileges to a process without granting all the privileges of the root user. Added capabilities entitle containers in a pod with additional privileges that can be used to change core processes and networking settings of a cluster. We recommend you only use privileges that are required for the proper function of the cluster.<br>To add or remove Linux capabilities for a container, you can include the capabilities field in the securityContext section of the container manifest.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: PodSecurityPolicy<br>Argument: allowedCapabilities (Optional)<br>Provides a list of capabilities that may be added to a container beyond the default set.<br><br>YAMLapiVersion: policy/v1beta1<br>kind: PodSecurityPolicy<br>metadata:<br>name: <policy name><br>spec:<br>- allowedCapabilities:<br><br>To use a PodSecurityPolicy resource, the requesting user or target pod\u2019s service account must be authorized to use the policy. The preferred method is to grant access to the service account. In the following example we use RBAC, a standard Kubernetes authorization mode.<br>A Role or ClusterRole needs to grant access to use the desired policies.<br>Kind: ClusterRole<br>YAMLapiVersion: rbac.authorization.k8s.io/v1<br>kind: ClusterRole<br>metadata:<br>name: <role name><br>rules:<br>- apiGroups: ['policy']<br>resources: ['podsecuritypolicies']<br>verbs:     ['use']<br>resourceNames:<br>- <policy name><br><br>The ClusterRole is then bound to the authorized service(s):<br>Kind: ClusterRoleBinding<br>YAMLapiVersion: rbac.authorization.k8s.io/v1<br>kind: ClusterRoleBinding<br>metadata:<br>name: <binding name><br>roleRef:<br>kind: ClusterRole<br>name: <role name><br>apiGroup: rbac.authorization.k8s.io<br>subjects:<br>- kind: ServiceAccount<br>name: <authorized service account name><br>namespace: <authorized pod namespace><br>"
    },
    "CKV_K8S_25": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_24",
        "severity": "LOW",
        "description": "<h4>Admission of containers with added capability is not minimized</h4><h4>Description</h4>Containers run with a default set of capabilities as assigned by the Container Runtime. By default this can include potentially dangerous capabilities. With Docker as the container runtime the NET_RAW capability is enabled which may be misused by malicious containers. Ideally, all containers should drop this capability.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"kubernetes_pod\" \"pass2\" {<br>metadata {<br>name = \"terraform-example\"<br>}<br><br>spec {<br>container {<br>image = \"nginx:1.7.9\"<br>name  = \"example22\"<br><br>security_context {<br>capabilities {<br>add = []<br>}<br>}<br><br>env {<br>name  = \"environment\"<br>value = \"test\"<br>}<br><br>port {<br>container_port = 8080<br>}<br><br>liveness_probe {<br>http_get  {<br>path = \"/nginx_status\"<br>port = 80<br><br>http_header {<br>name  = \"X-Custom-Header\"<br>value = \"Awesome\"<br>}<br>}<br><br>initial_delay_seconds = 3<br>period_seconds        = 3<br>}<br>}<br><br>dns_config {<br>nameservers = [\"1.1.1.1\", \"8.8.8.8\", \"9.9.9.9\"]<br>searches    = [\"example.com\"]<br><br>option {<br>name  = \"ndots\"<br>value = 1<br>}<br><br>option {<br>name = \"use-vc\"<br>}<br>}<br><br>dns_policy = \"None\"<br>}<br>}<br>"
    },
    "CKV_K8S_26": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_25",
        "severity": "LOW",
        "description": "<h4>hostPort is specified</h4><h4>Description</h4>The hostPort setting applies to the Kubernetes containers. The container port will be exposed to the external network at :, where the hostIP is the IP address of the Kubernetes node where the container is running, and the hostPort is the port requested by the user.<br>We recommend that you do not specify a hostPort for a pod unless it is absolutely necessary. When you bind a pod to a hostPort, it limits the number of places the pod can be scheduled, because each <hostIP, hostPort, protocol> combination must be unique.<br>\ud83d\udea7WarningIf you do not specify the hostIP and protocol explicitly, Kubernetes will use 0.0.0.0 as the default hostIP and TCP as the default protocol. This will expose your host to the internet.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Container<br>Argument: hostPort (Optional)<br>Defines the number of port to expose on the host.<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <Pod name><br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>ports:<br>-    hostPort: <port><br>"
    },
    "CKV_K8S_27": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_26",
        "severity": "MEDIUM",
        "description": "<h4>Mounting Docker socket daemon in a container is not limited</h4><h4>Description</h4>Docker runs through a non-networked UNIX socket. In daemon mode it only allows connections from clients authenticated by a certificate signed by that CA. This socket can be mounted by other containers unless correct permissions are in place. Once mounted, the socket can be used to spin up any container, create new images, or shut down existing containers.<br>To protect the docker socket daemon running in a container, set appropriate SELinux/AppArmor profiles to limit containers mounting this socket.<br><h4>Fix - Buildtime</h4>Kubernetes<br>Resource: Pod / Deployment / DaemonSet / StatefulSet / ReplicaSet / ReplicationController / Job / CronJob<br>Argument: volumes:hostPath (Optional)<br>Mounts a file or directory from the host node\u2019s filesystem into your Pod. If the path is set to /var/lib/docker, the container has access to Docker internals.<br>PodCronJobOtherapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>spec:<br>volumes:<br>-name: <volume name><br>hostPath:<br>-           path: /var/run/docker.sock<br>apiVersion: batch/v1beta1<br>kind: CronJob<br>metadata:<br>name: <name><br>spec:<br>schedule: <><br>jobTemplate:<br>spec:<br>template:<br>spec:<br>volumes:<br>-name: <volume name><br>hostPath:<br>-                      path: /var/run/docker.sock<br>apiVersion: <><br>kind: <kind><br>metadata:<br>name: <name><br>spec:<br>template:<br>spec:<br>volumes:<br>-name: <volume name><br>hostPath:<br>-                  path: /var/run/docker.sock<br>"
    },
    "CKV_K8S_28": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_27",
        "severity": "LOW",
        "description": "<h4>Admission of containers with NET_RAW capability is not minimized</h4><h4>Description</h4>NET_RAW capability allows the binary to use RAW and PACKET sockets as well as binding to any address for transparent proxying. The ep stands for \u201ceffective\u201d (active) and \u201cpermitted\u201d (allowed to be used).<br>With Docker as the container runtime NET_RAW capability is enabled by default and may be misused by malicious containers. We recommend you define at least one PodSecurityPolicy (PSP) to prevent containers with NET_RAW capability from launching.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Container<br>Argument: securityContext:capabilities:drop (Optional)<br>Capabilites field allows granting certain privileges to a process without granting all the privileges of the root user. when drop includes ALL or NET_RAW, the NET_RAW capability is disabled.<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <Pod name><br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>securityContext:<br>capabilities:<br>drop:<br>+        - NET_RAW<br>+        - ALL<br>"
    },
    "CKV_K8S_30": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_28",
        "severity": "LOW",
        "description": "<h4>securityContext is not applied to pods and containers in container context</h4><h4>Description</h4>securityContext defines privilege and access control settings for your pod or container, and holds security configurations that will be applied to a container. Some fields are present in both securityContext and PodSecurityContext,  when both are set, securityContext takes precedence.<br>Well-defined privilege and access control settings will enhance assurance that your pod is running with the properties it requires to function.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource:  Container / Pod / Deployment / DaemonSet / StatefulSet / ReplicaSet / ReplicationController / Job / CronJob<br>Argument: securityContext (Optional)<br>A field that defines privilege and access control settings for your Pod or Container.<br><br>ContainerPodCronJobOtherapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <Pod name><br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>+   securityContext:<br>apiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>spec:<br>+  securityContext:<br>apiVersion: batch/v1beta1<br>kind: CronJob<br>metadata:<br>name: <name><br>spec:<br>schedule: <><br>jobTemplate:<br>spec:<br>template:<br>spec:<br>+          securityContext:<br>apiVersion: <><br>kind: <kind><br>metadata:<br>name: <name><br>spec:<br>template:<br>spec:<br>+       securityContext:<br>"
    },
    "CKV_K8S_31": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_29",
        "severity": "LOW",
        "description": "<h4>seccomp is not set to Docker/Default or Runtime/Default</h4><h4>Description</h4>Secure computing mode (seccomp) is a Linux kernel feature used to restrict actions available within the container. The seccomp() system call operates on the seccomp state of the calling process. The default seccomp profile provides a reliable setting for running containers with seccomp and disables non-essential system calls.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Pod / Deployment / DaemonSet / StatefulSet / ReplicaSet / ReplicationController / Job / CronJob<br>Argument: securityContext: seccompProfile: type: (Optional: Kubernetes > v1.19)<br>Addition of seccompProfile type: RuntimeDefault or DockerDefault<br><br>PodCronJobOtherapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>securityContext:<br>+    seccompProfile:<br>+      type: RuntimeDefault<br>or<br>+      type: DockerDefault<br>apiVersion: batch/v1beta1<br>kind: CronJob<br>metadata:<br>name: <name><br>spec:<br>schedule: <><br>jobTemplate:<br>spec:<br>template:<br>spec:<br>securityContext:<br>+            seccompProfile:<br>+              type: RuntimeDefault<br>or<br>+              type: DockerDefault<br>apiVersion: <><br>kind: <kind><br>metadata:<br>name: <name><br>spec:<br>template:<br>spec:<br>securityContext:<br>+        seccompProfile:<br>+          type: RuntimeDefault<br>or<br>+          type: DockerDefault<br>"
    },
    "CKV_K8S_32": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_30",
        "severity": "LOW",
        "description": "<h4>seccomp profile is not set to Docker/Default or Runtime/Default</h4><h4>Description</h4>Secure computing mode (seccomp) is a Linux kernel feature used to restrict actions available within the container. The seccomp() system call operates on the seccomp state of the calling process. The default seccomp profile provides a reliable setting for running containers with seccomp and disables non-essential system calls.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Pod / Deployment / DaemonSet / StatefulSet / ReplicaSet / ReplicationController / Job / CronJob<br>Argument: metadata:annotations (Optional)<br>Annotations attach arbitrary non-identifying metadata to objects.<br><br>PodCronJobOtherapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>annotations:<br>+   seccomp.security.alpha.kubernetes.io/pod: \"docker/default\"<br>or<br>+   seccomp.security.alpha.kubernetes.io/pod: \"runtime/default\"<br>apiVersion: batch/v1beta1<br>kind: CronJob<br>metadata:<br>name: <name><br>spec:<br>schedule: <><br>jobTemplate:<br>spec:<br>template:<br>metadata:<br>annotations:<br>+                  seccomp.security.alpha.kubernetes.io/pod: \"docker/default\"<br>or<br>+                seccomp.security.alpha.kubernetes.io/pod: \"runtime/default\"<br>apiVersion: <><br>kind: <kind><br>metadata:<br>name: <name><br>spec:<br>template:<br>metadata:<br>annotations:<br>+               seccomp.security.alpha.kubernetes.io/pod: \"docker/default\"<br>or<br>+               seccomp.security.alpha.kubernetes.io/pod: \"runtime/default\"<br>"
    },
    "CKV_K8S_33": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_31",
        "severity": "LOW",
        "description": "<h4>Kubernetes dashboard is deployed</h4><h4>Description</h4>The Terraform provider for Azure enables the capability to disable the Kubernetes dashboard on an AKS cluster. This is achieved by providing the Kubernetes dashboard as an AKS add-on, similar to the Azure Monitor, for containers integration, AKS virtual nodes, and the HTTP application routing.<br>In mid-2019 Tesla was hacked where their kube-dashboard was exposed to the internet. Hackers browsed around, found credentials, and deployed pods running bitcoin mining software. We recommend you disable the kube-dashboard if it's not needed, to prevent the need to manage its individual access interface and limit it as an attack vector.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Container<br>Arguments:<br>labels:app / k8s-app - specifies the app label for the pod<br>image - defines the image used by the container<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>labels:<br>-   app: kubernetes-dashboard<br>-   k8s-app: kubernetes-dashboard<br>spec:<br>containers:<br>- name: <container name><br>-   image: kubernetes-dashboard<br>-   image: kubernetesui<br>"
    },
    "CKV_K8S_34": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_32",
        "severity": "LOW",
        "description": "<h4>Tiller (Helm V2) is deployed</h4><h4>Description</h4>Tiller (Helm v2) is the in-cluster component of Helm. It interacts directly with the Kubernetes API server to install, upgrade, query, and remove Kubernetes resources. It also stores the objects that represent releases. Its permissive configuration could grant the users a broad range of permissions.<br>New versions of Kubernetes and Helm v3 have made Tiller obsolete, with its over permissive function in existing workloads remaining a security liability.<br>Consider upgrading to use Helm v3, which only runs on client machines. Not all charts may support Helm 3, but the number that do is growing rapidly.<br><h4>Fix - Runtime</h4>CLI Command<br>helm reset<br>Or, use helm reset --force to force the removal if charts are installed. You still need to remove the releases manually.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Container<br>Arguments:<br>labels:app / name - specifies the app label for the pod<br>image - defines the image used by the container<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>labels:<br>-   app: helm<br>-   name: tiller<br>spec:<br>containers:<br>- name: <container name><br>-   image: tiller<br>"
    },
    "CKV_K8S_35": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_33",
        "severity": "LOW",
        "description": "<h4>Secrets used as environment variables</h4><h4>Description</h4>Secrets can be mounted as data volumes or exposed as environment variables and used by a container in a pod to interact with external systems on your behalf. Secrets can also be used by other parts of the system, without being directly exposed to the pod.<br>Benefits for storing secrets as files include: setting file permissions, projects of secret keys to specific paths, and consuming secret values from volumes.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Container<br>Arguments:<br>env:valueFrom:secretKeyRef - uses a secret in an environment variable in a Pod<br>envFrom:secretRef - defines all of the secret\u2019s data as the container environment variables<br><br>valueFromenvFromapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <pod name><br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>env:<br>- name: <env name><br>valueFrom:<br>-         secretKeyRef:<br>-           name: <secret key name><br>-           key: <secret key><br>apiVersion: v1<br>kind: Pod<br>metadata:<br>name: <pod name><br>spec:<br>containers:<br>- name: <contianer name><br>image: <image><br>envFrom:<br>-     - secretRef:<br>-         name: <secret name><br>"
    },
    "CKV_K8S_37": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_34",
        "severity": "LOW",
        "description": "<h4>Admission of containers with capabilities assigned is not limited</h4><h4>Description</h4>Docker has a default list of capabilities that are allowed for each container of a pod. The containers use the capabilities from this default list, but pod manifest authors can alter it by requesting additional capabilities, or dropping some of the default capabilities.<br>Limiting the admission of containers with capabilities ensures that only a small number of containers have extended capabilities outside the default range. This helps ensure that if a container becomes compromised it is unable to provide a productive path for an attacker to move laterally to other containers in the pod.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Container<br>Argument: securityContext:capabilities:drop (Optional)<br>Capabilites field allows granting certain privileges to a process without granting all the privileges of the root user. when drop includes ALL, all of the root privileges are disabled for that container.<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <Pod name><br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>securityContext:<br>capabilities:<br>drop:<br>+         - ALL<br>"
    },
    "CKV_K8S_38": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_35",
        "severity": "LOW",
        "description": "<h4>Service account tokens are not mounted where necessary</h4><h4>Description</h4>One way to authenticate the API is by using the Service Account token. ServiceAccount is an object managed by Kubernetes and used to provide an identity for processes that run in a pod. Every service account has a secret related to it, this secret contains a bearer token. This is a JSON Web Token (JWT), a method for representing claims securely between two parties.<br>This Service Account token is being used during the authentication stage and can become useful for  attackers if the service account is privileged and they have access to such a token. With this token an attacker can easily impersonate the service account and use REST APIs.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource:  Pod / Deployment / DaemonSet / StatefulSet / ReplicaSet / ReplicationController / Job / CronJob<br>Argument: automountServiceAccountToken (Optional)<br>When set to false, you can opt out of automounting API credentials for a service account.<br><br>PodCronJobOtherapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>spec:<br>+  automountServiceAccountToken: false<br>apiVersion: batch/v1beta1<br>kind: CronJob<br>metadata:<br>name: <name><br>spec:<br>schedule: <><br>jobTemplate:<br>spec:<br>template:<br>spec:<br>+           automountServiceAccountToken: false<br>apiVersion: <><br>kind: <kind><br>metadata:<br>name: <name><br>spec:<br>template:<br>spec:<br>+       automountServiceAccountToken: false<br>"
    },
    "CKV_K8S_39": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_36",
        "severity": "HIGH",
        "description": "<h4>CAP_SYS_ADMIN Linux capability is used</h4><h4>Description</h4>Capabilities permit certain named root actions without giving full root access and are considered a  fine-grained permissions model.<br>We recommend all capabilities should be dropped from a pod, with only those required added back. There are a large number of capabilities, with CAP_SYS_ADMIN bounding most. CAP_SYS_ADMIN is a highly privileged access level equivalent to root access and should generally be avoided.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource:  Container<br>Argument: securityContext:capabilities:add (Optional)<br>Add capabilities field allows granting certain privileges to a process.<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <Pod name><br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>securityContext:<br>capabilities:<br>add:<br>-               -SYS_ADMIN<br>"
    },
    "CKV_K8S_40": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_37",
        "severity": "LOW",
        "description": "<h4>Containers do not run with a high UID</h4><h4>Description</h4>Linux namespaces provide isolation for running processes and limits access to system resources. To prevent privilege-escalation attacks from within a container, we recommend that you configure your container\u2019s applications to run as unprivileged users. The mapped user is assigned a range of UIDs which function within the namespace as normal UIDs from 0 to 65536, but have no privileges on the host machine itself.<br>If a process attempts to escalate privilege outside of the namespace, the process is running as an unprivileged high-number UID on the host, not mapped to a real user. This means the process has no privileges on the host system and cannot be attacked by this method.<br>This check will trigger below UID 10,000 as common linux distributions will assign UID 1000 to the first non-root, non system user and 1000 users should provide a reasonable buffer.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Pod / Deployment / DaemonSet / StatefulSet / ReplicaSet / ReplicationController / Job / CronJob<br>Argument: runAsUser (Optional)<br>Specifies the User ID that processes within the container and/or pod run with.<br><br>PodCronJobOtherapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>securityContext:<br>+     runAsUser: <UID higher then 10000><br>apiVersion: batch/v1beta1<br>kind: CronJob<br>metadata:<br>name: <name><br>spec:<br>schedule: <><br>jobTemplate:<br>spec:<br>template:<br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>securityContext:<br>+             runAsUser: <UID higher then 10000><br>apiVersion: <><br>kind: <kind><br>metadata:<br>name: <name><br>spec:<br>template:<br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>securityContext:<br>runAsUser: <UID higher then 10000><br>"
    },
    "CKV_K8S_41": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_38",
        "severity": "LOW",
        "description": "<h4>Default service accounts are actively used</h4><h4>Description</h4>Every Kubernetes installation has a service account called default that is associated with every running pod. Similarly, to enable pods to make calls to the internal API Server endpoint, there is a ClusterIP service called Kubernetes. This combination makes it possible for internal processes to call the API endpoint.<br>We recommend that users create their own user-managed service accounts and grant the appropriate roles to each service account.<br><h4>Fix - Buildtime</h4>Kubernetes<br>Option 1<br><br>Resource: ServiceAccount<br>Argument: If service name is set to default, automountServiceAccountToken should be set to false in order to opt out of automounting API credentials for a service account.<br><br>default servicenon-default serviceapiVersion: v1<br>kind: ServiceAccount<br>metadata:<br>name: default<br>+ automountServiceAccountToken: false<br>apiVersion: v1<br>kind: ServiceAccount<br>metadata:<br>+ name: <service name><br><br>Option 2<br><br>Resource: RoleBinding / ClusterRoleBinding<br>Argument:<br>RoleBinding grants the permissions defined in a role to a user or set of users within a specific namespace.<br>ClusterRoleBinding grants that access cluster-wide. To avoid activating  the default service account, it should not be used as a subject in RoleBinding or ClusterRoleBinding resources.<br><br>RoleBindingClusterRoleBindingapiVersion: rbac.authorization.k8s.io/v1<br>kind: RoleBinding<br>metadata:<br>name: <name><br>subjects:<br>-- kind: ServiceAccount<br>-  name: default<br>apiVersion: rbac.authorization.k8s.io/v1<br>kind: ClusterRoleBinding<br>metadata:<br>name: <name><br>subjects:<br>-- kind: ServiceAccount<br>-  name: default<br>"
    },
    "CKV_K8S_43": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_39",
        "severity": "LOW",
        "description": "<h4>Images are not selected using a digest</h4><h4>Description</h4>In some cases you may prefer to use a fixed version of an image, rather than update to newer versions. Docker enables you to pull an image by its digest, specifying exactly which version of an image to pull.<br>Pulling using a digest allows you to \u201cpin\u201d an image to that version, and guarantee that the image you\u2019re using is always the same. Digests also prevent race-conditions; if a new image is pushed while a deploy is in progress, different nodes may be pulling the images at different times, so some nodes have the new image, and some have the old one. Services automatically resolve tags to digests, so you don't need to manually specify a digest.<br><h4>Fix - Runtime</h4>CLI Command<br>To make sure the container always uses the same version of the image, you can specify its digest; replace <image-name>:<tag> with <image-name>@<digest> (for example, [email\u00a0protected]:45b23dee08af5e43a7fea6c4cf9c25ccf269ee113168c19722f87876677c5cb2).<br>The digest uniquely identifies a specific version of the image, so it is never updated by Kubernetes unless you change the digest value.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: image<br>Argument: digest<br><br>ContainerimageapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <Pod name><br>spec:<br>containers:<br>- name: <container name><br>image: [email\u00a0protected]:45b23dee08af5e43a7fea6c4cf9c25ccf269ee113168c19722f87876677c5cb2<br>{<br>\"creator\": 7,<br>\"id\": 2110,<br>\"image_id\": null,<br>\"images\": [<br>{<br>\"architecture\": \"amd64\",<br>\"features\": \"\",<br>\"variant\": null,<br>+         \"digest\": \"sha256:1ae98b2c895d1ceeba8913ff79f422f005b7f967a311da520a88ac89180b4c39\",<br>\"os\": \"linux\",<br>\"os_features\": \"\",<br>\"os_version\": null,<br>\"size\": 87342331<br>}<br>],<br>\"last_updated\": \"2017-04-06T20:16:24.015937Z\",<br>\"last_updater\": 2215,<br>\"last_updater_username\": \"stackbrew\",<br>\"name\": \"centos5\",<br>\"repository\": 54,<br>\"full_size\": 87342331,<br>\"v2\": true<br>}<br>"
    },
    "CKV_K8S_45": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_40",
        "severity": "LOW",
        "description": "<h4>Tiller (Helm V2) deployment is accessible from within the cluster</h4><h4>Description</h4>Tiller (Helm v2) is the in-cluster component of Helm. It interacts directly with the Kubernetes API server to install, upgrade, query, and remove Kubernetes resources. It also stores the objects that represent releases. Its permissive configuration could grant the users a broad range of permissions.<br>Helm v3 removes Tiller, and it is recommended that you upgrade: see Ensure Tiller (Helm V2) Is Not Deployed. However, this is not always feasible.<br>Restricting access to Tiller from within the cluster limits the abilities of a compromised pod or anonymous user in the cluster.<br><h4>Fix - Runtime</h4>CLI Commands<br>Shellkubectl -n kube-system patch deployment tiller-deploy --patch '<br>spec:<br>template:<br>spec:<br>containers:<br>- name: tiller<br>ports: []<br>args: [\"--listen=localhost:44134\"]<br>'<br><br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Container<br><br>YAMLapiVersion: apps/v1<br>kind: Deployment<br>metadata:<br>name: tiller<br>labels:<br>app: tiller<br>spec:<br>progressDeadlineSeconds: 600<br>replicas: 1<br>revisionHistoryLimit: 10<br>selector:<br>matchLabels:<br>app: helm<br>name: tiller<br>template:<br>metadata:<br>creationTimestamp: null<br>labels:<br>app: helm<br>name: tiller<br>spec:<br>automountServiceAccountToken: true<br>containers:<br>+     - args:<br>+       - --listen=localhost:44134<br>env:<br>- name: TILLER_NAMESPACE<br>value: kube-system<br>- name: TILLER_HISTORY_MAX<br>value: \"0\"<br>image: gcr.io/kubernetes-helm/tiller:v2.16.9<br>name: tiller<br>-       ports:<br>-       - containerPort: 44134<br>-         name: tiller<br>-         protocol: TCP<br>-       - containerPort: 44135<br>-         name: http<br>-         protocol: TCP<br>"
    },
    "CKV_K8S_44": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_41",
        "severity": "LOW",
        "description": "<h4>Tiller (Helm v2) service is not deleted</h4><h4>Description</h4>Tiller (Helm v2) is the in-cluster component of Helm. It interacts directly with the Kubernetes API server to install, upgrade, query, and remove Kubernetes resources. It also stores the objects that represent releases. Its permissive configuration could grant the users a broad range of permissions.<br>Helm v3 removes Tiller, and it is recommended that you upgrade: see Ensure Tiller (Helm V2) Is Not Deployed. However, this is not always feasible.<br>Restricting access to Tiller from within the cluster limits the abilities of a compromised pod or anonymous user in the cluster.<br>After restricting connectivity to the Tiller deployment, the Tiller service can be deleted.<br><h4>Fix - Runtime</h4>CLI Commands<br>kubectl -n kube-system delete service tiller-deploy<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Service<br><br>YAML-- apiVersion: v1<br>-  kind: Service<br>-  metadata:<br>-    labels:<br>-      app: helm<br>-      name: tiller<br>-    name: tiller-deploy<br>-    namespace: kube-system<br>-  spec:<br>-    ports:<br>-    - name: tiller<br>-      port: 44134<br>-      protocol: TCP<br>-      targetPort: tiller<br>-    selector:<br>-      app: helm<br>-      name: tiller<br>-    type: ClusterIP<br>"
    },
    "CKV_K8S_5": {
        "url": "https://docs.bridgecrew.io/docs/ensure-containers-do-not-run-with-allowprivilegeescalation",
        "severity": "MEDIUM",
        "description": "<h4>Containers run with AllowPrivilegeEscalation</h4><h4>Description</h4>The AllowPrivilegeEscalation Pod Security Policy controls whether or not a user is allowed to set the security context of a container to True. Setting it to False ensures that no child process of a container can gain more privileges than its parent.<br>We recommend you to set AllowPrivilegeEscalation to False, to ensure RunAsUser commands cannot bypass their existing sets of permissions.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Container<br>Argument: allowPrivilegeEscalation (Optional)<br>If false, the pod can not request to allow privilege escalation. Default to true.<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <Pod name><br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>securityContext:<br>+      allowPrivilegeEscalation: false<br>"
    },
    "CKV_K8S_29": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_28",
        "severity": "LOW",
        "description": "<h4>securityContext is not applied to pods and containers in container context</h4><h4>Description</h4>securityContext defines privilege and access control settings for your pod or container, and holds security configurations that will be applied to a container. Some fields are present in both securityContext and PodSecurityContext,  when both are set, securityContext takes precedence.<br>Well-defined privilege and access control settings will enhance assurance that your pod is running with the properties it requires to function.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource:  Container / Pod / Deployment / DaemonSet / StatefulSet / ReplicaSet / ReplicationController / Job / CronJob<br>Argument: securityContext (Optional)<br>A field that defines privilege and access control settings for your Pod or Container.<br><br>ContainerPodCronJobOtherapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <Pod name><br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>+   securityContext:<br>apiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>spec:<br>+  securityContext:<br>apiVersion: batch/v1beta1<br>kind: CronJob<br>metadata:<br>name: <name><br>spec:<br>schedule: <><br>jobTemplate:<br>spec:<br>template:<br>spec:<br>+          securityContext:<br>apiVersion: <><br>kind: <kind><br>metadata:<br>name: <name><br>spec:<br>template:<br>spec:<br>+       securityContext:<br>"
    },
    "CKV_K8S_36": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_34",
        "severity": "LOW",
        "description": "<h4>Admission of containers with capabilities assigned is not limited</h4><h4>Description</h4>Docker has a default list of capabilities that are allowed for each container of a pod. The containers use the capabilities from this default list, but pod manifest authors can alter it by requesting additional capabilities, or dropping some of the default capabilities.<br>Limiting the admission of containers with capabilities ensures that only a small number of containers have extended capabilities outside the default range. This helps ensure that if a container becomes compromised it is unable to provide a productive path for an attacker to move laterally to other containers in the pod.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Container<br>Argument: securityContext:capabilities:drop (Optional)<br>Capabilites field allows granting certain privileges to a process without granting all the privileges of the root user. when drop includes ALL, all of the root privileges are disabled for that container.<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <Pod name><br>spec:<br>containers:<br>- name: <container name><br>image: <image><br>securityContext:<br>capabilities:<br>drop:<br>+         - ALL<br>"
    },
    "CKV_K8S_42": {
        "url": "https://docs.bridgecrew.io/docs/ensure-default-service-accounts-are-not-actively-used",
        "severity": "LOW",
        "description": "<h4>Default Kubernetes service accounts are actively used by bounding to a role or cluster role</h4><h4>Description</h4>Every Kubernetes installation has a service account called default that is associated with every running pod. Similarly, to enable pods to make calls to the internal API Server endpoint, there is a ClusterIP service called Kubernetes. This combination makes it possible for internal processes to call the API endpoint.<br>We recommend that users create their own user-managed service accounts and grant the appropriate roles to each service account.<br><h4>Fix - Buildtime</h4>Kubernetes<br>Option 1<br><br>Resource: ServiceAccount<br>Argument: If service name is set to default, automountServiceAccountToken should be set to false in order to opt out of automounting API credentials for a service account.<br><br>default servicenon-default serviceapiVersion: v1<br>kind: ServiceAccount<br>metadata:<br>name: default<br>+ automountServiceAccountToken: false<br>apiVersion: v1<br>kind: ServiceAccount<br>metadata:<br>+ name: <service name><br><br>Option 2<br><br>Resource: RoleBinding / ClusterRoleBinding<br>Argument:<br>RoleBinding grants the permissions defined in a role to a user or set of users within a specific namespace.<br>ClusterRoleBinding grants that access cluster-wide. To avoid activating  the default service account, it should not be used as a subject in RoleBinding or ClusterRoleBinding resources.<br><br>RoleBindingClusterRoleBindingapiVersion: rbac.authorization.k8s.io/v1<br>kind: RoleBinding<br>metadata:<br>name: <name><br>subjects:<br>-- kind: ServiceAccount<br>-  name: default<br>apiVersion: rbac.authorization.k8s.io/v1<br>kind: ClusterRoleBinding<br>metadata:<br>name: <name><br>subjects:<br>-- kind: ServiceAccount<br>-  name: default<br>"
    },
    "CKV_K8S_14": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_13",
        "severity": "LOW",
        "description": "<h4>Image tag is not set to Fixed</h4><h4>Description</h4>You can add a :fixed tag to a container image, making it easier to determine what it contains, for example to specify the version. Container image tags and digests are used to refer to a specific version or instance of a container image.<br>We recommend you avoid using the :latest and :blank tags when deploying containers in production as it is harder to track which version of the image is running, and more difficult to roll back properly.<br><h4>Fix - Buildtime</h4>Kubernetes<br>Resource: Container<br>Argument: image:tag (Optional)<br>Defines the image version by a specific number or by using latest.<br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>spec:<br>containers:<br>- name: <container name><br>+   image: <image>:<image version><br>-   image: <image><br>-   image: <image>:latest<br>"
    },
    "CKV_K8S_15": {
        "url": "https://docs.bridgecrew.io/docs/bc_k8s_14",
        "severity": "LOW",
        "description": "<h4>Image pull policy is not set to Always</h4><h4>Description</h4>The Image Pull Policy of a container is set using the imagePullPolicy. The imagePullPolicy and the tag of the image are triggered when the kubelet attempts to pull the specified image. When the imagePullPolicy is set to Always, you ensure the latest version of the image is deployed every time the pod is started. Avoid using the :latest tag when deploying containers in production, it is harder to track which version of the image is running and more difficult to roll back correctly.<br><h4>Fix - Buildtime</h4>Kubernetes<br>Resource: Container<br>Argument: imagePullPolicy (Optional)<br>Defines for the kubelet when he should attempt to pull the specified image.<br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>name: <name><br>spec:<br>containers:<br>- name: <container name><br>+   imagePullPolicy: Always<br>"
    },
    "CKV_K8S_70": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-token-auth-file-parameter-is-not-set",
        "severity": "LOW",
        "description": "<h4>The --token-auth-file argument is Set</h4><h4>Description</h4>Do not use token based authentication. The token-based authentication utilizes static tokens to authenticate requests to the apiserver. The tokens are stored in clear-text in a file on the apiserver, and cannot be revoked or rotated without restarting the apiserver. Hence, do not use static token-based authentication.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>- kube-apiserver<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>livenessProbe:<br>failureThreshold: 8<br>httpGet:<br>host: 127.0.0.1<br>path: /healthz<br>port: 6443<br>scheme: HTTPS<br>initialDelaySeconds: 15<br>timeoutSeconds: 15<br>name: kube-apiserver<br>resources:<br>requests:<br>cpu: 250m<br>volumeMounts:<br>- mountPath: /etc/kubernetes/<br>name: k8s<br>readOnly: true<br>- mountPath: /etc/ssl/certs<br>name: certs<br>- mountPath: /etc/pki<br>name: pki<br>hostNetwork: true<br>volumes:<br>- hostPath:<br>path: /etc/kubernetes<br>name: k8s<br>- hostPath:<br>path: /etc/ssl/certs<br>name: certs<br>- hostPath:<br>path: /etc/pki<br>name: pki<br>"
    },
    "CKV_K8S_71": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-kubelet-https-argument-is-set-to-true",
        "severity": "CRITICAL",
        "description": "<h4>The --kubelet-https argument is not set to True</h4><h4>Description</h4>Use https for kubelet connections. Connections from apiserver to kubelets could potentially carry sensitive data such as secrets and keys. It is thus important to use in-transit encryption for any communication between the apiserver and kubelets.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --kubelet-https=true<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_72": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-kubelet-client-certificate-and-kubelet-client-key-arguments-are-set-as-appropriate",
        "severity": "HIGH",
        "description": "<h4>The --kubelet-client-certificate and --kubelet-client-key arguments are not set appropriately</h4><h4>Description</h4>Enable certificate based kubelet authentication. The apiserver, by default, does not authenticate itself to the kubelet's HTTPS endpoints. The requests from the apiserver are treated anonymously. You should set up certificate- based kubelet authentication to ensure that the apiserver authenticates itself to kubelets when submitting requests.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --kubelet-client-certificate=/path/to/cert<br>+   - --kubelet-client-key=/path/to/key<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_80": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-admission-control-plugin-alwayspullimages-is-set",
        "severity": "MEDIUM",
        "description": "<h4>The admission control plugin AlwaysPullImages is not set</h4><h4>Description</h4>Always pull images.<br>Setting admission control policy to AlwaysPullImages forces every new pod to pull the required images every time. In a multi-tenant cluster users can be assured that their private images can only be used by those who have the credentials to pull them. Without this admission control policy, once an image has been pulled to a node, any pod from any user can use it simply by knowing the image\u2019s name, without any authorization check against the image ownership. When this plug-in is enabled, images are always pulled prior to starting containers, which means valid credentials are required.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --enable-admission-plugins=AlwaysPullImages<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_81": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-admission-control-plugin-securitycontextdeny-is-set-if-podsecuritypolicy-is-not-used",
        "severity": "LOW",
        "description": "<h4>The admission control plugin SecurityContextDeny is set if PodSecurityPolicy is used</h4><h4>Description</h4>The SecurityContextDeny admission controller can be used to deny pods which make use of some SecurityContext fields which could allow for privilege escalation in the cluster. This should be used where PodSecurityPolicy is not in place within the cluster.<br>SecurityContextDeny can be used to provide a layer of security for clusters which do not have PodSecurityPolicies enabled.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --enable-admission-plugins=SecurityContextDeny<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_82": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-admission-control-plugin-serviceaccount-is-set",
        "severity": "LOW",
        "description": "<h4>The admission control plugin ServiceAccount is not set</h4><h4>Description</h4>Automate service accounts management. When you create a pod, if you do not specify a service account, it is automatically assigned the default service account in the same namespace. You should create your own service account and let the API server manage its security tokens.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --enable-admission-plugins=ServiceAccount<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_85": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-admission-control-plugin-noderestriction-is-set",
        "severity": "MEDIUM",
        "description": "<h4>The admission control plugin NodeRestriction is not set</h4><h4>Description</h4>Limit the Node and Pod objects that a kubelet could modify.<br>Using the NodeRestriction plug-in ensures that the kubelet is restricted to the Node and Pod objects that it could modify as defined. Such kubelets will only be allowed to modify their own Node API object, and only modify Pod API objects that are bound to their node.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --enable-admission-plugins=NodeRestriction<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_86": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-insecure-bind-address-argument-is-not-set",
        "severity": "HIGH",
        "description": "<h4>The --insecure-bind-address argument is set</h4><h4>Description</h4>Do not bind the insecure API service.<br>If you bind the apiserver to an insecure address, basically anyone who could connect to it over the insecure port, would have unauthenticated and unencrypted access to your master node. The apiserver doesn't do any authentication checking for insecure binds and traffic to the Insecure API port is not encrpyted, allowing attackers to potentially read sensitive data in transit.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --bind-address=192.168.1.1<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_68": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-anonymous-auth-argument-is-set-to-false-1",
        "severity": "LOW",
        "description": "<h4>The --anonymous-auth argument is not set to False</h4><h4>Description</h4>Disable anonymous requests to the API server. When enabled, requests that are not rejected by other configured authentication methods are treated as anonymous requests. These requests are then served by the API server. You should rely on authentication to authorize access and disallow anonymous requests.<br>If you are using RBAC authorization, it is generally considered reasonable to allow anonymous access to the API Server for health checks and discovery purposes, and hence this recommendation is not scored. However, you should consider whether anonymous discovery is an acceptable risk for your purposes.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --anonymous-auth=false<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_88": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-insecure-port-argument-is-set-to-0",
        "severity": "HIGH",
        "description": "<h4>The --insecure-port argument is not set to 0</h4><h4>Description</h4>Do not bind to insecure port. Setting up the apiserver to serve on an insecure port would allow unauthenticated and unencrypted access to your master node. This would allow attackers who could access this port, to easily take control of the cluster.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --insecure-port=0<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_89": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-secure-port-argument-is-not-set-to-0",
        "severity": "LOW",
        "description": "<h4>The --secure-port argument is set to 0</h4><h4>Description</h4>Do not disable the secure port. The secure port is used to serve https with authentication and authorization. If you disable it, no https traffic is served and all traffic is served unencrypted.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --secure-port=80<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_90": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-profiling-argument-is-set-to-false-2",
        "severity": "LOW",
        "description": "<h4>The --profiling argument is not set to False</h4><h4>Description</h4>Disable profiling, if not needed.Profiling allows for the identification of specific performance bottlenecks. It generates a significant amount of program data that could potentially be exploited to uncover system and program details. If you are not experiencing any bottlenecks and do not need the profiler for troubleshooting purposes, it is recommended to turn it off to reduce the potential attack surface.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --profiling=false<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_69": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-basic-auth-file-argument-is-not-set",
        "severity": "LOW",
        "description": "<h4>The --basic-auth-file argument is Set</h4><h4>Description</h4>Do not use basic authentication. Basic authentication uses plaintext credentials for authentication. Currently, the basic authentication credentials last indefinitely, and the password cannot be changed without restarting the API server. The basic authentication is currently supported for convenience. Hence, basic authentication should not be used.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>- kube-apiserver<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>livenessProbe:<br>failureThreshold: 8<br>httpGet:<br>host: 127.0.0.1<br>path: /healthz<br>port: 6443<br>scheme: HTTPS<br>initialDelaySeconds: 15<br>timeoutSeconds: 15<br>name: kube-apiserver<br>resources:<br>requests:<br>cpu: 250m<br>volumeMounts:<br>- mountPath: /etc/kubernetes/<br>name: k8s<br>readOnly: true<br>- mountPath: /etc/ssl/certs<br>name: certs<br>- mountPath: /etc/pki<br>name: pki<br>hostNetwork: true<br>volumes:<br>- hostPath:<br>path: /etc/kubernetes<br>name: k8s<br>- hostPath:<br>path: /etc/ssl/certs<br>name: certs<br>- hostPath:<br>path: /etc/pki<br>name: pki<br>"
    },
    "CKV_K8S_73": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-kubelet-certificate-authority-argument-is-set-as-appropriate",
        "severity": "HIGH",
        "description": "<h4>The --kubelet-certificate-authority argument is not set appropriately</h4><h4>Description</h4>Verify kubelet's certificate before establishing connection.The connections from the apiserver to the kubelet are used for fetching logs for pods, attaching (through kubectl) to running pods, and using the kubelet\u2019s port-forwarding functionality. These connections terminate at the kubelet\u2019s HTTPS endpoint. By default, the apiserver does not verify the kubelet\u2019s serving certificate, which makes the connection subject to man-in-the-middle attacks, and unsafe to run over untrusted and/or public networks.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --kubelet-certificate-authority=ca.file<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_74": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-authorization-mode-argument-is-not-set-to-alwaysallow-1",
        "severity": "MEDIUM",
        "description": "<h4>The --authorization-mode argument is set to AlwaysAllow</h4><h4>Description</h4>Do not always authorize all requests. The API Server, can be configured to allow all requests. This mode should not be used on any production cluster.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --authorization-mode=RBAC,node<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_75": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-authorization-mode-argument-includes-node",
        "severity": "MEDIUM",
        "description": "<h4>The --authorization-mode argument does not include node</h4><h4>Description</h4>Restrict kubelet nodes to reading only objects associated with them. The Node authorization mode only allows kubelets to read Secret, ConfigMap, PersistentVolume, and PersistentVolumeClaim objects associated with their nodes.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+    - kube-apiserver<br>+    - --authorization-mode=RBAC,Node<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_96": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-service-account-lookup-argument-is-set-to-true",
        "severity": "HIGH",
        "description": "<h4>The --service-account-lookup argument is not set to True</h4><h4>Description</h4>Validate service account before validating token.<br>If --service-account-lookup is not enabled, the apiserver only verifies that the authentication token is valid, and does not validate that the service account token mentioned in the request is actually present in etcd. This allows using a service account token even after the corresponding service account is deleted. This is an example of time of check to time of use security issue.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --service-account-lookup=true<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_77": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-authorization-mode-argument-includes-rbac",
        "severity": "LOW",
        "description": "<h4>The --authorization-mode argument does not include RBAC</h4><h4>Description</h4>Turn on Role Based Access Control.<br>Role Based Access Control (RBAC) allows fine-grained control over the operations that different entities can perform on different objects in the cluster. It is recommended to use the RBAC authorization mode.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --authorization-mode=RBAC,Node<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_78": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-admission-control-plugin-eventratelimit-is-set",
        "severity": "MEDIUM",
        "description": "<h4>The admission control plugin EventRateLimit is not set</h4><h4>Description</h4>Limit the rate at which the API server accepts requests.<br>Using EventRateLimit admission control enforces a limit on the number of events that the API Server will accept in a given time slice. A misbehaving workload could overwhelm and DoS the API Server, making it unavailable. This particularly applies to a multi-tenant cluster, where there might be a small percentage of misbehaving tenants which could have a significant impact on the performance of the cluster overall. Hence, it is recommended to limit the rate of events that the API server will accept.<br>Note: This is an Alpha feature in the Kubernetes 1.15 release.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: apiserver.config.k8s.io/v1<br>kind: AdmissionConfiguration<br>metadata:<br>name: \"admission-configuration-passed\"<br>plugins:<br>- name: ValidatingAdmissionWebhook<br>configuration:<br>apiVersion: apiserver.config.k8s.io/v1<br>kind: WebhookAdmissionConfiguration<br>kubeConfigFile: \"<path-to-kubeconfig-file>\"<br>+ - name: EventRateLimit<br>+   path: eventconfig.yaml<br>- name: MutatingAdmissionWebhook<br>configuration:<br>apiVersion: apiserver.config.k8s.io/v1<br>kind: WebhookAdmissionConfiguration<br>kubeConfigFile: \"<path-to-kubeconfig-file>\"<br>"
    },
    "CKV_K8S_79": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-admission-control-plugin-alwaysadmit-is-not-set",
        "severity": "MEDIUM",
        "description": "<h4>The admission control plugin AlwaysAdmit is set</h4><h4>Description</h4>Do not allow all requests. Setting admission control plugin AlwaysAdmit allows all requests and do not filter any requests.<br>The AlwaysAdmit admission controller was deprecated in Kubernetes v1.13. Its behavior was equivalent to turning off all admission controllers.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver-passed<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>- kube-apiserver<br>- --enable-admission-plugins=other<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>livenessProbe:<br>failureThreshold: 8<br>httpGet:<br>host: 127.0.0.1<br>path: /healthz<br>port: 6443<br>scheme: HTTPS<br>initialDelaySeconds: 15<br>timeoutSeconds: 15<br>name: kube-apiserver<br>resources:<br>requests:<br>cpu: 250m<br>volumeMounts:<br>- mountPath: /etc/kubernetes/<br>name: k8s<br>readOnly: true<br>- mountPath: /etc/ssl/certs<br>name: certs<br>- mountPath: /etc/pki<br>name: pki<br>hostNetwork: true<br>volumes:<br>- hostPath:<br>path: /etc/kubernetes<br>name: k8s<br>- hostPath:<br>path: /etc/ssl/certs<br>name: certs<br>- hostPath:<br>path: /etc/pki<br>name: pki<br>"
    },
    "CKV_K8S_97": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-service-account-key-file-argument-is-set-as-appropriate",
        "severity": "MEDIUM",
        "description": "<h4>The --service-account-key-file argument is not set appropriately</h4><h4>Description</h4>Explicitly set a service account public key file for service accounts on the apiserver.<br>By default, if no --service-account-key-file is specified to the apiserver, it uses the private key from the TLS serving certificate to verify service account tokens. To ensure that the keys for service account tokens could be rotated as needed, a separate public/private key pair should be used for signing service account tokens. Hence, the public key should be specified to the apiserver with --service-account-key-file.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --service-account-key-file=/keys/key.pem<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_105": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-api-server-only-makes-use-of-strong-cryptographic-ciphers",
        "severity": "CRITICAL",
        "description": "<h4>The API server does not make use of strong cryptographic ciphers</h4><h4>Description</h4>Ensure that the API server is configured to only use strong cryptographic ciphers. TLS ciphers have had a number of known vulnerabilities and weaknesses, which can reduce the protection provided by them. By default Kubernetes supports a number of TLS ciphersuites including some that have security concerns, weakening the protection provided.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --tls-cipher-suites=TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>livenessProbe:<br>failureThreshold: 8<br>httpGet:<br>host: 127.0.0.1<br>path: /healthz<br>port: 6443<br>scheme: HTTPS<br>initialDelaySeconds: 15<br>timeoutSeconds: 15<br>name: kube-apiserver-should-pass<br>resources:<br>requests:<br>cpu: 250m<br>volumeMounts:<br>- mountPath: /etc/kubernetes/<br>name: k8s<br>readOnly: true<br>- mountPath: /etc/ssl/certs<br>name: certs<br>- mountPath: /etc/pki<br>name: pki<br>hostNetwork: true<br>volumes:<br>- hostPath:<br>path: /etc/kubernetes<br>name: k8s<br>- hostPath:<br>path: /etc/ssl/certs<br>name: certs<br>- hostPath:<br>path: /etc/pki<br>name: pki<br>"
    },
    "CKV_K8S_111": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-root-ca-file-argument-is-set-as-appropriate",
        "severity": "HIGH",
        "description": "<h4>The --root-ca-file argument for controller managers is not set appropriately</h4><h4>Description</h4>Allow pods to verify the API server's serving certificate before establishing connections.<br>Processes running within pods that need to contact the API server must verify the API server's serving certificate. Failing to do so could be a subject to man-in-the-middle attacks.<br>Providing the root certificate for the API server's serving certificate to the controller manager with the --root-ca-file argument allows the controller manager to inject the trusted bundle into pods so that they can verify TLS connections to the API server.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-controller-manager<br>tier: control-plane<br>name: kube-controller-manager<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>- kube-controller-manager<br>+     -  --root-ca-file=private.pem<br>image: gcr.io/google_containers/kube-controller-manager-amd64:v1.6.0<br>"
    },
    "CKV_K8S_112": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-rotatekubeletservercertificate-argument-is-set-to-true-for-controller-manager",
        "severity": "MEDIUM",
        "description": "<h4>The RotateKubeletServerCertificate argument for controller managers is not set to True</h4><h4>Description</h4>Enable kubelet server certificate rotation. RotateKubeletServerCertificate causes the kubelet to both request a serving certificate after bootstrapping its client credentials and rotate the certificate as its existing credentials expire. This automated periodic rotation ensures that the there are no downtimes due to expired certificates and thus addressing availability in the CIA security triad.<br>\ud83d\udcd8NoteThis recommendation only applies if you let kubelets get their certificates from the API server. In case your kubelet certificates come from an outside authority/tool (e.g. Vault) then you need to take care of rotation yourself.<br><h4>Fix - Buildtime</h4>Kubernetes<br>Kind: Pod<br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kubelet<br>tier: control-plane<br>name: kubelet<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kubelet<br>+   - --feature-gates=RotateKubeletServerCertificate=true<br>image: gcr.io/google_containers/kubelet-amd64:v1.6.0<br>"
    },
    "CKV_K8S_117": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-client-cert-auth-argument-is-set-to-true",
        "severity": "MEDIUM",
        "description": "<h4>The --client-cert-auth argument is not set to True</h4><h4>Description</h4>Enable client authentication on etcd service. etcd is a highly-available key value store used by Kubernetes deployments for persistent storage of all of its REST API objects. These objects are sensitive in nature and should not be available to unauthenticated clients. You should enable the client authentication via valid certificates to secure the access to the etcd service.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>annotations:<br>scheduler.alpha.kubernetes.io/critical-pod: \"\"<br>creationTimestamp: null<br>labels:<br>component: etcd<br>tier: control-plane<br>name: etcd<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - etcd<br>+   - --client-cert-auth=true<br>image: k8s.gcr.io/etcd-amd64:3.2.18<br>"
    },
    "CKV_K8S_108": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-use-service-account-credentials-argument-is-set-to-true",
        "severity": "HIGH",
        "description": "<h4>The --use-service-account-credentials argument for controller managers is not set to True</h4><h4>Description</h4>Use individual service account credentials for each controller. The controller manager creates a service account per controller in the kube-system namespace, generates a credential for it, and builds a dedicated API client with that service account credential for each controller loop to use. Setting the --use-service-account- credentials to true runs each control loop within the controller manager using a separate service account credential. When used in combination with RBAC, this ensures that the control loops run with the minimum permissions required to perform their intended tasks.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-controller-manager<br>tier: control-plane<br>name: kube-controller-manager<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>- kube-controller-manager<br>+     -  --use-service-account-credentials=true<br>image: gcr.io/google_containers/kube-controller-manager-amd64:v1.6.0<br>"
    },
    "CKV_K8S_138": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-anonymous-auth-argument-is-set-to-false",
        "severity": "MEDIUM",
        "description": "<h4>The --anonymous-auth argument is not set to False</h4><h4>Description</h4>Disable anonymous requests to the Kubelet server. When enabled, requests that are not rejected by other configured authentication methods are treated as anonymous requests. These requests are then served by the Kubelet server. You should rely on authentication to authorize access and disallow anonymous requests.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kubelet<br>tier: control-plane<br>name: kubelet<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+    - kubelet<br>+    - --anonymous-auth=false<br>image: gcr.io/google_containers/kubelet-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_139": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-authorization-mode-argument-is-not-set-to-alwaysallow",
        "severity": "LOW",
        "description": "<h4>The --authorization-mode argument is set to AlwaysAllow</h4><h4>Description</h4>Do not allow all requests. Enable explicit authorization. Kubelets, by default, allow all authenticated requests (even anonymous ones) without needing explicit authorization checks from the apiserver. You should restrict this behavior and only allow explicitly authorized requests.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kubelet<br>tier: control-plane<br>name: kubelet<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kubelet<br>+   - --authorization-mode=RBAC,node<br>image: gcr.io/google_containers/kubelet-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_140": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-client-ca-file-argument-is-set-as-appropriate-scored",
        "severity": "LOW",
        "description": "<h4>The --client-ca-file argument for API Servers is not set appropriately</h4><h4>Description</h4>Enable Kubelet authentication using certificates. The connections from the apiserver to the kubelet are used for fetching logs for pods, attaching (through kubectl) to running pods, and using the kubelet\u2019s port-forwarding functionality. These connections terminate at the kubelet\u2019s HTTPS endpoint. By default, the apiserver does not verify the kubelet\u2019s serving certificate, which makes the connection subject to man-in-the-middle attacks, and unsafe to run over untrusted and/or public networks. Enabling Kubelet certificate authentication ensures that the apiserver could authenticate the Kubelet before submitting any requests.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kubelet<br>tier: control-plane<br>name: kubelet<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kubelet<br>+   - --root-ca-file=test.pem<br>image: gcr.io/google_containers/kubelet-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_83": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-admission-control-plugin-namespacelifecycle-is-set",
        "severity": "LOW",
        "description": "<h4>The admission control plugin NamespaceLifecycle is not set</h4><h4>Description</h4>Reject creating objects in a namespace that is undergoing termination.<br>Setting admission control policy to NamespaceLifecycle ensures that objects cannot be created in non-existent namespaces, and that namespaces undergoing termination are not used for creating the new objects. This is recommended to enforce the integrity of the namespace termination process and also for the availability of the newer objects.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --enable-admission-plugins=NamespaceLifecycle<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_84": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-admission-control-plugin-podsecuritypolicy-is-set",
        "severity": "LOW",
        "description": "<h4>The admission control plugin PodSecurityPolicy is not set</h4><h4>Description</h4>Reject creating pods that do not match Pod Security Policies.<br>A Pod Security Policy is a cluster-level resource that controls the actions that a pod can perform and what it has the ability to access. The PodSecurityPolicy objects define a set of conditions that a pod must run with in order to be accepted into the system. Pod Security Policies are comprised of settings and strategies that control the security features a pod has access to and hence this must be used to control pod access permissions.<br>\ud83d\udcd8NoteWhen the PodSecurityPolicy admission plugin is in use, there needs to be at least one PodSecurityPolicy in place for ANY pods to be admitted. See section 5.2 for recommendations on PodSecurityPolicy settings.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --enable-admission-plugins=PodSecurityPolicy<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_91": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-audit-log-path-argument-is-set",
        "severity": "MEDIUM",
        "description": "<h4>The --audit-log-path argument is not set</h4><h4>Description</h4>Enable auditing on the Kubernetes API Server and set the desired audit log path.<br>Auditing the Kubernetes API Server provides a security-relevant chronological set of records documenting the sequence of activities that have affected system by individual users, administrators or other components of the system. Even though currently, Kubernetes provides only basic audit capabilities, it should be enabled. You can enable it by setting an appropriate audit log path.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+  - kube-apiserver<br>+  - --audit-log-path=/path/to/log<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_118": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-auto-tls-argument-is-not-set-to-true",
        "severity": "HIGH",
        "description": "<h4>The --auto-tls argument is set to True</h4><h4>Description</h4>Do not use self-signed certificates for TLS. etcd is a highly-available key value store used by Kubernetes deployments for persistent storage of all of its REST API objects. These objects are sensitive in nature and should not be available to unauthenticated clients. You should enable the client authentication via valid certificates to secure the access to the etcd service.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>annotations:<br>scheduler.alpha.kubernetes.io/critical-pod: \"\"<br>creationTimestamp: null<br>labels:<br>component: etcd<br>tier: control-plane<br>name: etcd<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - etcd<br>+   - --auto-tls=true<br>image: k8s.gcr.io/etcd-amd64:3.2.18<br>"
    },
    "CKV_K8S_92": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-audit-log-maxage-argument-is-set-to-30-or-as-appropriate",
        "severity": "LOW",
        "description": "<h4>The --audit-log-maxage argument is not set appropriately</h4><h4>Description</h4>Retain the logs for at least 30 days or as appropriate. Retaining logs for at least 30 days ensures that you can go back in time and investigate or correlate any events. Set your audit log retention period to 30 days or as per your business requirements.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+    - kube-apiserver<br>+    - --audit-log-maxage=40<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_93": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-audit-log-maxbackup-argument-is-set-to-10-or-as-appropriate",
        "severity": "LOW",
        "description": "<h4>The --audit-log-maxbackup argument is not set appropriately</h4><h4>Description</h4>Retain 10 or an appropriate number of old log files. Kubernetes automatically rotates the log files. Retaining old log files ensures that you would have sufficient log data available for carrying out any investigation or correlation. For example, if you have set file size of 100 MB and the number of old log files to keep as 10, you would approximate have 1 GB of log data that you could potentially use for your analysis.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --audit-log-maxbackup=15<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_94": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-audit-log-maxsize-argument-is-set-to-100-or-as-appropriate",
        "severity": "LOW",
        "description": "<h4>The --audit-log-maxsize argument is not set appropriately</h4><h4>Description</h4>Rotate log files on reaching 100 MB or as appropriate. Kubernetes automatically rotates the log files. Retaining old log files ensures that you would have sufficient log data available for carrying out any investigation or correlation. If you have set file size of 100 MB and the number of old log files to keep as 10, you would approximate have 1 GB of log data that you could potentially use for your analysis.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --audit-log-maxsize=150<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_95": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-request-timeout-argument-is-set-as-appropriate",
        "severity": "MEDIUM",
        "description": "<h4>The --request-timeout argument is not set appropriately</h4><h4>Description</h4>Set global request timeout for API server requests as appropriate. Setting global request timeout allows extending the API server request timeout limit to a duration appropriate to the user's connection speed. By default, it is set to 60 seconds which might be problematic on slower connections making cluster resources inaccessible once the data volume for requests exceeds what can be transmitted in 60 seconds. But, setting this timeout limit to be too large can exhaust the API server resources making it prone to Denial-of-Service attack. Hence, it is recommended to set this limit as appropriate and change the default limit of 60 seconds only if needed.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --request-timeout=2m3s<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_99": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-etcd-certfile-and-etcd-keyfile-arguments-are-set-as-appropriate",
        "severity": "HIGH",
        "description": "<h4>The --etcd-certfile and --etcd-keyfile arguments are not set appropriately</h4><h4>Description</h4>etcd should be configured to make use of TLS encryption for client connections.<br>etcd is a highly-available key value store used by Kubernetes deployments for persistent storage of all of its REST API objects. These objects are sensitive in nature and should be protected by client authentication. This requires the API server to identify itself to the etcd server using a client certificate and key.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>- kube-apiserver<br>- --etcd-certfile=/path/to/cert<br>- --etcd-keyfile=/path/to/key<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>livenessProbe:<br>failureThreshold: 8<br>httpGet:<br>host: 127.0.0.1<br>path: /healthz<br>port: 6443<br>scheme: HTTPS<br>initialDelaySeconds: 15<br>timeoutSeconds: 15<br>name: kube-apiserver-should-pass<br>resources:<br>requests:<br>cpu: 250m<br>volumeMounts:<br>- mountPath: /etc/kubernetes/<br>name: k8s<br>readOnly: true<br>- mountPath: /etc/ssl/certs<br>name: certs<br>- mountPath: /etc/pki<br>name: pki<br>hostNetwork: true<br>volumes:<br>- hostPath:<br>path: /etc/kubernetes<br>name: k8s<br>- hostPath:<br>path: /etc/ssl/certs<br>name: certs<br>- hostPath:<br>path: /etc/pki<br>name: pki<br>"
    },
    "CKV_K8S_100": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-tls-cert-file-and-tls-private-key-file-arguments-are-set-as-appropriate",
        "severity": "HIGH",
        "description": "<h4>The --tls-cert-file and --tls-private-key-file arguments are not set appropriately for API servers</h4><h4>Description</h4>API server communication contains sensitive parameters that should remain encrypted in transit. Configure the API server to serve only HTTPS traffic by setup TLS connection on the API server. By default, --tls-cert-file and --tls-private-key-file arguments are not set.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>- kube-apiserver<br>+      - --tls-cert-file=/path/to/cert<br>+      - --tls-private-key-file=/path/to/key<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>livenessProbe:<br>failureThreshold: 8<br>httpGet:<br>host: 127.0.0.1<br>path: /healthz<br>port: 6443<br>scheme: HTTPS<br>initialDelaySeconds: 15<br>timeoutSeconds: 15<br>name: kube-apiserver<br>resources:<br>requests:<br>cpu: 250m<br>volumeMounts:<br>- mountPath: /etc/kubernetes/<br>name: k8s<br>readOnly: true<br>- mountPath: /etc/ssl/certs<br>name: certs<br>- mountPath: /etc/pki<br>name: pki<br>hostNetwork: true<br>volumes:<br>- hostPath:<br>path: /etc/kubernetes<br>name: k8s<br>- hostPath:<br>path: /etc/ssl/certs<br>name: certs<br>- hostPath:<br>path: /etc/pki<br>name: pki<br>"
    },
    "CKV_K8S_102": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-etcd-cafile-argument-is-set-as-appropriate-1",
        "severity": "HIGH",
        "description": "<h4>The --etcd-cafile argument is not set appropriately</h4><h4>Description</h4>etcd should be configured to make use of TLS encryption for client connections. etcd is a highly-available key value store used by Kubernetes deployments for persistent storage of all of its REST API objects. These objects are sensitive in nature and should be protected by client authentication. This requires the API server to identify itself to the etcd server using a SSL Certificate Authority file.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --etcd-ca-file=ca.file<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>livenessProbe:<br>failureThreshold: 8<br>httpGet:<br>host: 127.0.0.1<br>path: /healthz<br>port: 6443<br>scheme: HTTPS<br>initialDelaySeconds: 15<br>timeoutSeconds: 15<br>name: kube-apiserver<br>resources:<br>requests:<br>cpu: 250m<br>volumeMounts:<br>- mountPath: /etc/kubernetes/<br>name: k8s<br>readOnly: true<br>- mountPath: /etc/ssl/certs<br>name: certs<br>- mountPath: /etc/pki<br>name: pki<br>hostNetwork: true<br>volumes:<br>- hostPath:<br>path: /etc/kubernetes<br>name: k8s<br>- hostPath:<br>path: /etc/ssl/certs<br>name: certs<br>- hostPath:<br>path: /etc/pki<br>name: pki<br>"
    },
    "CKV_K8S_104": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-etcd-cafile-argument-is-set-as-appropriate",
        "severity": "CRITICAL",
        "description": "<h4>Encryption providers are not appropriately configured</h4><h4>Description</h4>Where etcd encryption is used, appropriate providers should be configured. Where etcd encryption is used, it is important to ensure that the appropriate set of encryption providers is used. Currently, the aescbc, kms and secretbox are likely to be appropriate options.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>GoapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --encryption-provider-config=config.file<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>livenessProbe:<br>failureThreshold: 8<br>httpGet:<br>host: 127.0.0.1<br>path: /healthz<br>port: 6443<br>scheme: HTTPS<br>initialDelaySeconds: 15<br>timeoutSeconds: 15<br>name: kube-apiserver-should-pass<br>resources:<br>requests:<br>cpu: 250m<br>volumeMounts:<br>- mountPath: /etc/kubernetes/<br>name: k8s<br>readOnly: true<br>- mountPath: /etc/ssl/certs<br>name: certs<br>- mountPath: /etc/pki<br>name: pki<br>hostNetwork: true<br>volumes:<br>- hostPath:<br>path: /etc/kubernetes<br>name: k8s<br>- hostPath:<br>path: /etc/ssl/certs<br>name: certs<br>- hostPath:<br>path: /etc/pki<br>name: pki<br>"
    },
    "CKV_K8S_106": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-terminated-pod-gc-threshold-argument-is-set-as-appropriate",
        "severity": "MEDIUM",
        "description": "<h4>The --terminated-pod-gc-threshold argument for controller managers is not set appropriately</h4><h4>Description</h4>Activate garbage collector on pod termination, as appropriate.. Garbage collection is important to ensure sufficient resource availability and avoiding degraded performance and availability. In the worst case, the system might crash or just be unusable for a long period of time. The current setting for garbage collection is 12,500 terminated pods which might be too high for your system to sustain. Based on your system resources and tests, choose an appropriate threshold value to activate garbage collection.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-controller-manager<br>tier: control-plane<br>name: kube-controller-manager<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>- kube-controller-manager<br>+     -  --terminated-pod-gc-threshold=555<br>image: gcr.io/google_containers/kube-controller-manager-amd64:v1.6.0<br>livenessProbe:<br>failureThreshold: 8<br>httpGet:<br>host: 127.0.0.1<br>path: /healthz<br>port: 6443<br>scheme: HTTPS<br>initialDelaySeconds: 15<br>timeoutSeconds: 15<br>name: kube-controller-manager-should-pass<br>resources:<br>requests:<br>cpu: 250m<br>volumeMounts:<br>- mountPath: /etc/kubernetes/<br>name: k8s<br>readOnly: true<br>- mountPath: /etc/ssl/certs<br>name: certs<br>- mountPath: /etc/pki<br>name: pki<br>hostNetwork: true<br>volumes:<br>- hostPath:<br>path: /etc/kubernetes<br>name: k8s<br>- hostPath:<br>path: /etc/ssl/certs<br>name: certs<br>- hostPath:<br>path: /etc/pki<br>name: pki<br>"
    },
    "CKV_K8S_107": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-profiling-argument-is-set-to-false",
        "severity": "MEDIUM",
        "description": "<h4>The --profiling argument for controller managers is not set to False</h4><h4>Description</h4>Disable profiling, if not needed. Profiling allows for the identification of specific performance bottlenecks. It generates a significant amount of program data that could potentially be exploited to uncover system and program details. If you are not experiencing any bottlenecks and do not need the profiler for troubleshooting purposes, it is recommended to turn it off to reduce the potential attack surface.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-controller-manager<br>tier: control-plane<br>name: kube-controller-manager<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>- kube-controller-manager<br>+     -  --profiling=false<br>image: gcr.io/google_containers/kube-controller-manager-amd64:v1.6.0<br>"
    },
    "CKV_K8S_110": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-service-account-private-key-file-argument-is-set-as-appropriate",
        "severity": "HIGH",
        "description": "<h4>The --service-account-private-key-file argument for controller managers is not set appropriately</h4><h4>Description</h4>Explicitly set a service account private key file for service accounts on the controller manager. To ensure that keys for service account tokens can be rotated as needed, a separate public/private key pair should be used for signing service account tokens. The private key should be specified to the controller manager with --service-account-private-key-file as appropriate.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-controller-manager<br>tier: control-plane<br>name: kube-controller-manager<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>- kube-controller-manager<br>+     -  --service-account-private-key-file=public.pem<br>image: gcr.io/google_containers/kube-controller-manager-amd64:v1.6.0<br>"
    },
    "CKV_K8S_113": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-bind-address-argument-is-set-to-127001",
        "severity": "HIGH",
        "description": "<h4>The --bind-address argument for controller managers is not set to 127.0.0.1</h4><h4>Description</h4>Do not bind the Controller Manager service to non-loopback insecure addresses. The Controller Manager API service which runs on port 10252/TCP by default is used for health and metrics information and is available without authentication or encryption. As such it should only be bound to a localhost interface, to minimize the cluster's attack surface<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>- kube-controller-manager<br>+     - --bind-address=127.0.0.1<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>"
    },
    "CKV_K8S_114": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-profiling-argument-is-set-to-false-1",
        "severity": "LOW",
        "description": "<h4>The --profiling argument is not set to False</h4><h4>Description</h4>Disable profiling, if not needed.<br>Profiling allows for the identification of specific performance bottlenecks. It generates a significant amount of program data that could potentially be exploited to uncover system and program details. If you are not experiencing any bottlenecks and do not need the profiler for troubleshooting purposes, it is recommended to turn it off to reduce the potential attack surface.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-scheduler<br>tier: control-plane<br>name: kube-scheduler<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-scheduler<br>+   - --profiling=false<br>image: gcr.io/google_containers/kube-scheduler-amd64:v1.6.0<br>"
    },
    "CKV_K8S_115": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-bind-address-argument-is-set-to-127001-1",
        "severity": "HIGH",
        "description": "<h4>The --bind-address argument is not set to 127.0.0.1</h4><h4>Description</h4>Do not bind the scheduler service to non-loopback insecure addresses. The Scheduler API service which runs on port 10251/TCP by default is used for health and metrics information and is available without authentication or encryption. As such it should only be bound to a localhost interface, to minimize the cluster's attack surface.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLpiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+    - kube-scheduler<br>+    - --bind-address=127.0.0.1<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>"
    },
    "CKV_K8S_116": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-cert-file-and-key-file-arguments-are-set-as-appropriate",
        "severity": "HIGH",
        "description": "<h4>The --cert-file and --key-file arguments are not set appropriately</h4><h4>Description</h4>Configure TLS encryption for the etcd service. etcd is a highly-available key value store used by Kubernetes deployments for persistent storage of all of its REST API objects. These objects are sensitive in nature and should be encrypted in transit.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kube-apiserver<br>+   - --etcd-certfile=/path/to/cert<br>+   - --etcd-keyfile=/path/to/key<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>"
    },
    "CKV_K8S_119": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-peer-cert-file-and-peer-key-file-arguments-are-set-as-appropriate",
        "severity": "HIGH",
        "description": "<h4>The --peer-cert-file and --peer-key-file arguments are not set appropriately</h4><h4>Description</h4>etcd should be configured to make use of TLS encryption for peer connections. etcd is a highly-available key value store used by Kubernetes deployments for persistent storage of all of its REST API objects. These objects are sensitive in nature and should be encrypted in transit and also amongst peers in the etcd clusters.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - etcd<br>+   - --peer-cert-file=file.pem<br>+   - --peer-key-file=file.key<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>"
    },
    "CKV_K8S_121": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-peer-client-cert-auth-argument-is-set-to-true",
        "severity": "HIGH",
        "description": "<h4>The --peer-client-cert-auth argument is not set to True</h4><h4>Description</h4>etcd should be configured for peer authentication. etcd is a highly-available key value store used by Kubernetes deployments for persistent storage of all of its REST API objects. These objects are sensitive in nature and should be accessible only by authenticated etcd peers in the etcd cluster.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>GoapiVersion: v1<br>kind: Pod<br>metadata:<br>name: etcd<br>namespace: should-pass<br>spec:<br>hostNetwork: true<br>containers:<br>- name: \"kuku2\"<br>image: \"b.gcr.io/kuar/etcd:2.2.0\"<br>args:<br>...<br>+         - \"--peer-client-cert-auth=true\"<br>...<br>"
    },
    "CKV_K8S_141": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-read-only-port-argument-is-set-to-0",
        "severity": "LOW",
        "description": "<h4>The --read-only-port argument is not set to 0</h4><h4>Description</h4>Disable the read-only port. The Kubelet process provides a read-only API in addition to the main Kubelet API. Unauthenticated access is provided to this read-only API which could possibly retrieve potentially sensitive information about the cluster.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kubelet<br>tier: control-plane<br>name: kubelet<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kubelet<br>+   - --read-only-port=0<br>image: gcr.io/google_containers/kubelet-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_143": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-streaming-connection-idle-timeout-argument-is-not-set-to-0",
        "severity": "LOW",
        "description": "<h4>The --streaming-connection-idle-timeout argument is set to 0</h4><h4>Description</h4>Do not disable timeouts on streaming connections.<br>Setting idle timeouts ensures that you are protected against Denial-of-Service attacks, inactive connections and running out of ephemeral ports.<br>By default, --streaming-connection-idle-timeout is set to 4 hours which might be too high for your environment. Setting this as appropriate would addition<br>ally ensure that such streaming connections are timed out after serving legitimate use cases.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kubelet<br>tier: control-plane<br>name: kubelet<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kubelet<br>+   - --streaming-connection-idle-timeout=1<br>image: gcr.io/google_containers/kubelet-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_144": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-protect-kernel-defaults-argument-is-set-to-true",
        "severity": "LOW",
        "description": "<h4>The --protect-kernel-defaults argument is not set to True</h4><h4>Description</h4>Protect tuned kernel parameters from overriding kubelet default kernel parameter values.<br>Kernel parameters are usually tuned and hardened by the system administrators before putting the systems into production. These parameters protect the kernel and the system. Your kubelet kernel defaults that rely on such parameters should be appropriately set to match the desired secured system state. Ignoring this could potentially lead to running pods with undesired kernel behavior.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kubelet<br>tier: control-plane<br>name: kubelet<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kubelet<br>+   - --protect-kernel-defaults=true<br>image: gcr.io/google_containers/kubelet-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_145": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-make-iptables-util-chains-argument-is-set-to-true",
        "severity": "LOW",
        "description": "<h4>The --make-iptables-util-chains argument is not set to True</h4><h4>Description</h4>Allow Kubelet to manage iptables. Kubelets can automatically manage the required changes to iptables based on how you choose your networking options for the pods. It is recommended to let kubelets manage the changes to iptables. This ensures that the iptables configuration remains in sync with pods networking configuration. Manually configuring iptables with dynamic pod network configuration changes might hamper the communication between pods/containers and to the outside world. You might have iptables rules too restrictive or too open.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Resource: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kubelet<br>tier: control-plane<br>name: kubelet<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kubelet<br>+   - --make-iptables-util-chains=true<br>image: gcr.io/google_containers/kubelet-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_146": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-hostname-override-argument-is-not-set",
        "severity": "LOW",
        "description": "<h4>The --hostname-override argument is set</h4><h4>Description</h4>Do not override node hostnames. Overriding hostnames could potentially break TLS setup between the kubelet and the apiserver. Additionally, with overridden hostnames, it becomes increasingly difficult to associate logs with a particular node and process them for security analytics. Hence, you should setup your kubelet nodes with resolvable FQDNs and avoid overriding the hostnames with IPs.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kubelet<br>tier: control-plane<br>name: kubelet<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>- kubelet<br>- --read-only-port=80<br>image: gcr.io/google_containers/kubelet-amd64:v1.6.0<br>livenessProbe:<br>failureThreshold: 8<br>httpGet:<br>host: 127.0.0.1<br>path: /healthz<br>port: 6443<br>scheme: HTTPS<br>initialDelaySeconds: 15<br>timeoutSeconds: 15<br>name: kubelet<br>resources:<br>requests:<br>cpu: 250m<br>volumeMounts:<br>- mountPath: /etc/kubernetes/<br>name: k8s<br>readOnly: true<br>- mountPath: /etc/ssl/certs<br>name: certs<br>- mountPath: /etc/pki<br>name: pki<br>hostNetwork: true<br>volumes:<br>- hostPath:<br>path: /etc/kubernetes<br>name: k8s<br>- hostPath:<br>path: /etc/ssl/certs<br>name: certs<br>- hostPath:<br>path: /etc/pki<br>name: pki<br>"
    },
    "CKV_K8S_147": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-event-qps-argument-is-set-to-0-or-a-level-which-ensures-appropriate-event-capture",
        "severity": "LOW",
        "description": "<h4>The --event-qps argument is not set to a level that ensures appropriate event capture</h4><h4>Description</h4>Security relevant information should be captured. The --event-qps flag on the Kubelet can be used to limit the rate at which events are gathered. Setting this too low could result in relevant events not being logged, however the unlimited setting of 0 could result in a denial of service on the kubelet.<br>It is important to capture all events and not restrict event creation. Events are an important source of security information and analytics that ensure that your environment is consistently monitored using the event data.<br><h4>Fix - Buildtime</h4>Kubernetes<br>Kind  Pod<br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kubelet<br>tier: control-plane<br>name: kubelet<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kubelet<br>+   - --event-qps=2<br>image: gcr.io/google_containers/kubelet-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_148": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-tls-cert-file-and-tls-private-key-file-arguments-are-set-as-appropriate-for-kubelet",
        "severity": "HIGH",
        "description": "<h4>The --tls-cert-file and --tls-private-key-file arguments are not set appropriately for Kubelety</h4><h4>Description</h4>API server communication contains sensitive parameters that should remain encrypted in transit. Configure the API server to serve only HTTPS traffic by setup TLS connection on the API server. By default, --tls-cert-file and --tls-private-key-file arguments are not set.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: Pod<br><br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-apiserver<br>tier: control-plane<br>name: kube-apiserver<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>- kube-apiserver<br>+      - --tls-cert-file=/path/to/cert<br>+      - --tls-private-key-file=/path/to/key<br>image: gcr.io/google_containers/kube-apiserver-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_149": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-rotate-certificates-argument-is-not-set-to-false",
        "severity": "HIGH",
        "description": "<h4>The --rotate-certificates argument is set to False</h4><h4>Description</h4>Enable kubelet client certificate rotation.<br>The --rotate-certificates setting causes the kubelet to rotate its client certificates by creating new CSRs as its existing credentials expire. This automated periodic rotation ensures that the there is no downtime due to expired certificates and thus addressing availability in the CIA security triad.<br>\ud83d\udcd8NoteThis recommendation only applies if you let kubelets get their certificates from the API server. In case your kubelet certificates come from an outside authority/tool (e.g. Vault) then you need to take care of rotation yourself.<br><h4>Fix - Buildtime</h4>Kubernetes<br>Kind Pod<br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-scheduler<br>tier: control-plane<br>name: kube-scheduler<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+  - kubelet<br>+  - --rotate-certificates=true<br>image: gcr.io/google_containers/kube-scheduler-amd64:v1.6.0<br>...<br>"
    },
    "CKV_K8S_151": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-the-kubelet-only-makes-use-of-strong-cryptographic-ciphers",
        "severity": "LOW",
        "description": "<h4>Kubelet does not use strong cryptographic ciphers</h4><h4>Description</h4>Ensure that the Kubelet is configured to only use strong cryptographic ciphers. TLS ciphers have had a number of known vulnerabilities and weaknesses, which can reduce the protection provided by them. By default Kubernetes supports a number of TLS ciphersuites including some that have security concerns, weakening the protection provided.<br><h4>Fix - Buildtime</h4>Kubernetes<br>Kind Pod<br>YAMLapiVersion: v1<br>kind: Pod<br>metadata:<br>creationTimestamp: null<br>labels:<br>component: kube-scheduler<br>tier: control-plane<br>name: kube-scheduler<br>namespace: kube-system<br>spec:<br>containers:<br>- command:<br>+   - kubelet<br>+   - --tls-cipher-suites=TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256<br>image: gcr.io/google_containers/kube-scheduler-amd64:v1.6.0<br>livenessProbe:<br>failureThreshold: 8<br>httpGet:<br>host: 127.0.0.1<br>path: /healthz<br>port: 6443<br>scheme: HTTPS<br>initialDelaySeconds: 15<br>timeoutSeconds: 15<br>name: kube-scheduler<br>resources:<br>requests:<br>cpu: 250m<br>volumeMounts:<br>- mountPath: /etc/kubernetes/<br>name: k8s<br>readOnly: true<br>- mountPath: /etc/ssl/certs<br>name: certs<br>- mountPath: /etc/pki<br>name: pki<br>hostNetwork: true<br>volumes:<br>- hostPath:<br>path: /etc/kubernetes<br>name: k8s<br>- hostPath:<br>path: /etc/ssl/certs<br>name: certs<br>- hostPath:<br>path: /etc/pki<br>name: pki<br>"
    },
    "CKV_K8S_154": {
        "url": "https://docs.bridgecrew.io/docs/prevent-nginx-ingress-annotation-snippets-which-contain-alias-statements",
        "severity": "LOW",
        "description": "<h4>NGINX Ingress has annotation snippets which contain alias statements</h4><h4>Description</h4>Allowing custom snippet annotations in ingress-nginx enables a user, who can create or update ingress objects, to obtain all secrets in the cluster. To still allow users leveraging the snippet feature it is recommend to remove any usage of alias.<br>Learn more around CVE-2021-25742<br><h4>Fix - Buildtime</h4>Kubernetes<br>YAMLapiVersion: networking.k8s.io/v1<br>kind: Ingress<br>metadata:<br>name: example-ingress<br>namespace: developer<br>annotations:<br>kubernetes.io/ingress.class: nginx<br>nginx.ingress.kubernetes.io/rewrite-target: /$2<br>nginx.ingress.kubernetes.io/server-snippet: |<br>location ^~ \"/test\" {<br>default_type 'text/plain';<br>-       alias /var/run;<br>}<br>spec:<br>rules:<br>- http:<br>paths:<br>- path: /test<br>pathType: Prefix<br>backend:<br>service:<br>name: web<br>port:<br>number: 8080<br>"
    },
    "CKV_K8S_49": {
        "url": "https://docs.bridgecrew.io/docs/ensure-minimized-wildcard-use-in-roles-and-clusterroles",
        "severity": "MEDIUM",
        "description": "<h4>Wildcard use is not minimized in Roles and ClusterRoles</h4><h4>Description</h4>In Kubernetes, roles and ClusterRoles are used to define the permissions that are granted to users, service accounts, and other entities in the cluster. Roles are namespaced and apply to a specific namespace, while ClusterRoles are cluster-wide and apply to the entire cluster.<br>When you define a role or ClusterRole, you can use wildcards to specify the resources and verbs that the role applies to. For example, you might specify a role that allows users to perform all actions on all resources in a namespace by using the wildcard \"*\" for the resources and verbs.<br>However, using wildcards can be a security risk because it grants broad permissions that may not be necessary for a specific role. If a role has too many permissions, it could potentially be abused by an attacker or compromised user to gain unauthorized access to resources in the cluster.<br><h4>Fix - Buildtime</h4>Kubernetes<br>Goresource \"kubernetes_cluster_role\" \"pass\" {<br>metadata {<br>name = \"terraform-example\"<br>}<br><br>rule {<br>api_groups = [\"\"]<br>resources  = [\"namespaces\", \"pods\"]<br>verbs      = [\"get\", \"list\", \"watch\"]<br>}<br>"
    },
    "CKV_K8S_155": {
        "url": "https://docs.bridgecrew.io/docs/ensure-clusterroles-that-grant-control-over-validating-or-mutating-admission-webhook-configurations-are-minimized",
        "severity": "HIGH",
        "description": "<h4>ClusterRoles that grant control over validating or mutating admission webhook configurations are not minimized</h4><h4>Description</h4>ClusterRoles that grant write permissions over admission webhook should be minimized to reduce powerful identities in the cluster. Validating admission webhooks can read every object admitted to the cluster, while mutating admission webhooks can read and mutate every object admitted to the cluster. As such, ClusterRoles that grant control over admission webhooks are granting near cluster admin privileges. Minimize such ClusterRoles to limit the number of powerful credentials that if compromised could take over the entire cluster.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: ClusterRole<br>Argument: rules<br>ClusterRoles that grant the \"create\", \"update\" or \"patch\" verbs over the \"mutatingwebhookconfigurations\" or \"validatingwebhookconfigurations\" resources in the \"admissionregistration.k8s.io\" API group are granting control over admission webhooks.<br><br>YAMLkind: ClusterRole<br>apiVersion: rbac.authorization.k8s.io/v1<br>metadata:<br>name: <ClusterRole-name><br>rules:<br>- apiGroups: [\"\"]<br>resources: [\"pods\"]<br>verbs: [\"get\"]<br>- apiGroups: [\"admissionregistration.k8s.io\"]<br>resources: [\"mutatingwebhookconfigurations\"]<br>verbs:<br>- list<br>"
    },
    "CKV_K8S_156": {
        "url": "https://docs.bridgecrew.io/docs/ensure-clusterroles-that-grant-permissions-to-approve-certificatesigningrequests-are-minimized",
        "severity": "HIGH",
        "description": "<h4>ClusterRoles that grant permissions to approve CertificateSigningRequests are not minimized</h4><h4>Description</h4>ClusterRoles that grant permissions to approve CertificateSigningRequests should be minimized to reduce powerful identities in the cluster. Approving CertificateSigningRequests allows one to issue new credentials for any user or group. As such, ClusterRoles that grant permissions to approve CertificateSigningRequests are granting cluster admin privileges. Minimize such ClusterRoles to limit the number of powerful credentials that if compromised could take over the entire cluster.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: ClusterRole<br>Argument: rules<br>ClusterRoles that grant the \"update\" verbs over the \"certificatesigningrequests/approval\" and the \"approve\" verb over \"signers\" in the \"certificates.k8s.io\" API group are granting permissions to approve CertificateSigningRequests<br><br>YAMLkind: ClusterRole<br>apiVersion: rbac.authorization.k8s.io/v1<br>metadata:<br>name: <ClusterRole-name><br>rules:<br>- apiGroups: [\"certificates.k8s.io\"]<br>resources: [\"certificatesigningrequests\"]<br>verbs: [\"get\", \"list\", \"create]<br>x- apiGroups: [\"certificates.k8s.io\"]<br>x  resources: [\"certificatesigningrequests/approval\"]<br>x  verbs: [\"update\"]<br>x- apiGroups: [\"certificates.k8s.io\"]<br>x  resources: [\"signers\"]<br>x  verbs: [\"approve\"]<br>"
    },
    "CKV_K8S_157": {
        "url": "https://docs.bridgecrew.io/docs/ensure-roles-and-clusterroles-that-grant-permissions-to-bind-rolebindings-or-clusterrolebindings-are-minimized",
        "severity": "MEDIUM",
        "description": "<h4>Roles and ClusterRoles that grant permissions to bind RoleBindings or ClusterRoleBindings are not minimized</h4><h4>Description</h4>Role or ClusterRoles that grant permissions to bind RoleBindings or ClusterRoleBindings should be minimized to reduce powerful identities in the cluster. Such Roles and ClusterRoles can attach existing permissions (Roles and ClusterRoles) to arbitrary identities. RoleBindings grant permissions over a namespace, while ClusterRoleBindings grant permissions over the entire cluster. Minimize such Roles and ClusterRoles to limit the number of powerful credentials that if compromised could escalate privileges and possibly take over the entire cluster.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: ClusterRole, Role<br>Argument: rules<br>ClusterRoles and Roles that grant the \"bind\" verbs over \"clusterrolebindings\" or \"rolebindings\" in the \"rbac.authorization.k8s.io\" API group should be minimized.<br><br>YAMLkind: ClusterRole<br>apiVersion: rbac.authorization.k8s.io/v1<br>metadata:<br>name: <ClusterRole-name><br>rules:<br>- apiGroups: [\"rbac.authorization.k8s.io\"]<br>resources: [\"roles\", \"clusterroles\"]<br>verbs: [\"get\", \"list\", \"create\", \"update\"]<br>x- apiGroups: [\"rbac.authorization.k8s.io\"]<br>x  resources: [\"clusterrolebindings\"]<br>x  verbs: [\"bind\"]<br>"
    },
    "CKV_K8S_158": {
        "url": "https://docs.bridgecrew.io/docs/ensure-roles-and-clusterroles-that-grant-permissions-to-escalate-roles-or-clusterrole-are-minimized",
        "severity": "MEDIUM",
        "description": "<h4>Roles and ClusterRoles that grant permissions to escalate Roles or ClusterRole are not minimized</h4><h4>Description</h4>Role or ClusterRoles that grant permissions to escalate Roles or ClusterRoles should be minimized to reduce powerful identities in the cluster. Such Roles and ClusterRoles can add arbitrary permissions to arbitrary identities. Escalating Roles can add permissions over a namespace, while escalating ClusterRoles can add permissions over the entire cluster. Minimize such Roles and ClusterRoles to limit the number of powerful credentials that if compromised could escalate privileges and possibly take over the entire cluster.<br><h4>Fix - Buildtime</h4>Kubernetes<br><br>Kind: ClusterRole, Role<br>Argument: rules<br>ClusterRoles and Roles that grant the \"escalate\" verbs over \"clusterroles\" or \"roles\" in the \"rbac.authorization.k8s.io\" API group should be minimized.<br><br>YAMLkind: ClusterRole<br>apiVersion: rbac.authorization.k8s.io/v1<br>metadata:<br>name: <ClusterRole-name><br>rules:<br>- apiGroups: [\"rbac.authorization.k8s.io\"]<br>resources: [\"roles\", \"clusterrolebindings\"]<br>verbs: [\"get\", \"list\", \"create\", \"update\"]<br>x- apiGroups: [\"rbac.authorization.k8s.io\"]<br>x  resources: [\"clusterroles\"]<br>x  verbs: [\"escalate\"]<br>"
    },
    "CKV_K8S_152": {
        "url": "https://docs.bridgecrew.io/docs/prevent-nginx-ingress-annotation-snippets-which-contain-lua-code-execution",
        "severity": "LOW",
        "description": "<h4>NGINX Ingress annotation snippets contain LUA code execution</h4><h4>Description</h4>Allowing custom snippet annotations in ingress-nginx enables a user, who can create or update ingress objects, to obtain all secrets in the cluster. To still allow users leveraging the snippet feature it is recommend to remove any usage of LUA code.<br>Learn more around CVE-2021-25742<br><h4>Fix - Buildtime</h4>Kubernetes<br>YAMLapiVersion: networking.k8s.io/v1<br>kind: Ingress<br>metadata:<br>name: app-ingress<br>annotations:<br>nginx.ingress.kubernetes.io/server-snippet: |<br>-     lua_package_path  \"/etc/nginx/lua/?.lua;;\";<br>location / {<br>return 200 'OK';<br>}<br>kubernetes.io/ingress.class: \"nginx\"<br>spec:<br>rules:<br>- http:<br>paths:<br>- path: /exp<br>pathType: Prefix<br>backend:<br>service:<br>name: some-service<br>port:<br>number: 1234<br>"
    },
    "CKV_K8S_153": {
        "url": "https://docs.bridgecrew.io/docs/prevent-all-nginx-ingress-annotation-snippets",
        "severity": "LOW",
        "description": "<h4>NGINX Ingress has annotation snippets</h4><h4>Description</h4>Allowing custom snippet annotations in ingress-nginx enables a user, who can create or update ingress objects, to obtain all secrets in the cluster. The safest way is to disallow any usage of annotation snippets.<br>Learn more around CVE-2021-25742<br><h4>Fix - Buildtime</h4>Kubernetes<br>YAMLapiVersion: networking.k8s.io/v1<br>kind: Ingress<br>metadata:<br>name: app-ingress<br>annotations:<br>-   nginx.ingress.kubernetes.io/server-snippet: |<br>-     location / {<br>-       return 200 'OK';<br>-     }<br>kubernetes.io/ingress.class: \"nginx\"<br>spec:<br>rules:<br>- http:<br>paths:<br>- path: /exp<br>pathType: Prefix<br>backend:<br>service:<br>name: some-service<br>port:<br>number: 1234<br>"
    },
    "CKV2_K8S_1": {
        "url": "https://docs.bridgecrew.io/docs/rolebinding-should-not-allow-privilege-escalation-to-a-serviceaccount-or-node-on-other-rolebinding",
        "severity": "CRITICAL",
        "description": "<h4>RoleBinding should not allow privilege escalation to a ServiceAccount or Node on other RoleBinding</h4><h4>Description</h4>In Kubernetes, a RoleBinding is used to grant specific permissions to a user or group of users. These permissions, also known as \"roles,\" determine what actions a user is allowed to perform within a Kubernetes cluster.<br>It is important to ensure that RoleBindings are configured in a way that does not allow privilege escalation. This means that a user with a RoleBinding should not be able to gain access to privileges that they are not explicitly granted through their RoleBinding.<br>Allowing privilege escalation would mean that a user could potentially gain unauthorized access to sensitive information or perform actions that they are not supposed to be able to perform. This could pose a security risk to the cluster, so it is important to prevent privilege escalation in RoleBindings.<br>One way to prevent privilege escalation in RoleBindings is to make sure that they are not granted to ServiceAccounts or Nodes. This is because ServiceAccounts and Nodes are not typically associated with individual users, so granting a RoleBinding to them could potentially allow any user who is able to access the ServiceAccount or Node to gain the privileges granted by the RoleBinding. This could lead to privilege escalation, so it is generally best to avoid granting RoleBindings to ServiceAccounts and Nodes.<br><h4>Fix - Buildtime</h4>YAMLapiVersion: v1<br>kind: RoleBinding<br>metadata:<br>name: restricted-access<br>subjects:<br>- kind: ServiceAccount<br>name: my-service-account<br>- kind: Node<br>name: my-node<br>roleRef:<br>kind: ClusterRole<br>name: restricted-access<br>apiGroup: rbac.authorization.k8s.io<br>"
    },
    "CKV2_K8S_2": {
        "url": "https://docs.bridgecrew.io/docs/granting-create-permissions-to-nodesproxy-or-podsexec-sub-resources-allows-potential-privilege-escalation",
        "severity": "HIGH",
        "description": "<h4>Granting create permissions to nodes/proxy or pods/exec sub resources allows potential privilege escalation</h4><h4>Description</h4>In Kubernetes, granting the create permission to the nodes/proxy or pods/exec sub resources can potentially allow privilege escalation. This is because these sub resources enable users to access and control the Kubernetes nodes and pods in the cluster.<br>If a user has the create permission for the nodes/proxy sub resource, they would be able to create a proxy to any node in the cluster. This would allow them to access the node as if they were directly logged in to it, potentially giving them access to sensitive information or allowing them to perform actions that they are not supposed to be able to perform.<br>Similarly, if a user has the create permission for the pods/exec sub resource, they would be able to execute commands on any pod in the cluster. This could allow them to gain access to the containers running on the pod, potentially giving them access to sensitive information or allowing them to perform unauthorized actions.<br>Therefore, it is important to carefully consider whether to grant the create permission for the nodes/proxy and pods/exec sub resources, as doing so could potentially allow privilege escalation. It may be safer to only grant these permissions to trusted users who have a legitimate need for them, and to monitor their usage to ensure that they are not being used for unauthorized purposes.<br><h4>Fix - Buildtime</h4>YAMLapiVersion: v1<br>kind: ClusterRole<br>metadata:<br>name: restricted-access<br>rules:<br>- apiGroups: [\"\"]<br>resources: [\"nodes/proxy\", \"pods/exec\"]<br>verbs: [\"create\"]<br>"
    },
    "CKV2_K8S_3": {
        "url": "https://docs.bridgecrew.io/docs/no-serviceaccountnode-should-have-impersonate-permissions-for-groupsusersservice-accounts",
        "severity": "CRITICAL",
        "description": "<h4>No ServiceAccount/Node should have impersonate permissions for groups/users/service-accounts</h4><h4>Description</h4>In Kubernetes, the impersonate permission allows a user or service account to perform actions as if they were another user or service account. This can be useful in certain situations, such as when one service needs to access another service on behalf of a user.<br>However, allowing a ServiceAccount or Node to have impersonate permissions for other users or service accounts can potentially allow privilege escalation. This is because ServiceAccounts and Nodes are not typically associated with individual users, so granting them the ability to impersonate other users could potentially allow any user who is able to access the ServiceAccount or Node to gain the privileges of the impersonated user.<br>For example, if a ServiceAccount has the impersonate permission for a user who has admin privileges, any user who is able to access the ServiceAccount would be able to perform actions as if they were an admin user. This could lead to unauthorized access to sensitive information or the ability to perform unauthorized actions, so it is generally best to avoid granting impersonate permissions to ServiceAccounts and Nodes.<br><h4>Fix - Buildtime</h4>YAMLapiVersion: v1<br>kind: ServiceAccount<br>metadata:<br>name: my-service-account<br>annotations:<br>authorization.k8s.io/impersonate: \"false\"<br>"
    },
    "CKV2_K8S_4": {
        "url": "https://docs.bridgecrew.io/docs/serviceaccounts-and-nodes-that-can-modify-servicesstatus-may-set-the-statusloadbalanceringressip-field-to-exploit-the-unfixed-cve-2020-8554-and-launch-mitm-attacks-against-the-cluster",
        "severity": "MEDIUM",
        "description": "<h4>ServiceAccounts and nodes that can modify services/status may set the status.loadBalancer.ingress.ip field to exploit the unfixed CVE-2020-8554 and launch MiTM attacks against the cluster</h4><h4>Description</h4>In Kubernetes, a ServiceAccount is an account that is associated with a specific service. A ServiceAccount can be granted specific permissions, known as \"roles,\" that determine what actions it is allowed to perform within a Kubernetes cluster.<br>One potential issue with ServiceAccounts is that they can be used to exploit a vulnerability known as CVE-2020-8554. This vulnerability allows a ServiceAccount that has the ability to modify services and their status to set the status.loadBalancer.ingress.ip field to an arbitrary IP address.<br>If a ServiceAccount with these permissions sets the status.loadBalancer.ingress.ip field to an IP address that they control, they would be able to launch a man-in-the-middle (MiTM) attack against the cluster. This would allow them to intercept and modify traffic between the cluster and the specified IP address, potentially allowing them to gain access to sensitive information or perform unauthorized actions.<br>To prevent this type of attack, it is important to ensure that ServiceAccounts with the ability to modify services and their status do not have the ability to set the status.loadBalancer.ingress.ip field. This can be done by carefully configuring the roles and permissions associated with the ServiceAccounts in the cluster.<br>It is also important to note that nodes, which are the physical or virtual machines that run the Kubernetes cluster, can also potentially exploit the CVE-2020-8554 vulnerability if they have the ability to modify services and their status. Therefore, it is also important to ensure that nodes do not have these permissions to prevent potential MiTM attacks against the cluster.<br><h4>Fix - Buildtime</h4>YAMLapiVersion: v1<br>kind: ServiceAccount<br>metadata:<br>name: my-service-account<br>annotations:<br>services/status/patch: \"[]\"<br>"
    },
    "CKV2_K8S_5": {
        "url": "https://docs.bridgecrew.io/docs/no-serviceaccountnode-should-be-able-to-read-all-secrets",
        "severity": "HIGH",
        "description": "<h4>No ServiceAccount/Node should be able to read all secrets</h4><h4>Description</h4>In Kubernetes, a ServiceAccount is an account that is associated with a specific service. A ServiceAccount can be granted specific permissions, known as \"roles,\" that determine what actions it is allowed to perform within a Kubernetes cluster.<br>One potential issue with ServiceAccounts is that they could potentially be granted the ability to read all secrets in a Kubernetes cluster. This would allow the ServiceAccount to access sensitive information such as passwords, API keys, and other sensitive data that is stored as secrets in the cluster.<br>Allowing a ServiceAccount to read all secrets could pose a security risk to the cluster, as it could potentially allow unauthorized access to sensitive information. Therefore, it is generally best to avoid granting ServiceAccounts the ability to read all secrets in a cluster.<br>It is also important to note that nodes, which are the physical or virtual machines that run the Kubernetes cluster, can also potentially be granted the ability to read all secrets. Therefore, it is also important to ensure that nodes do not have this ability to prevent potential unauthorized access to sensitive information.<br><h4>Fix - Buildtime</h4>YAMLapiVersion: v1<br>kind: ServiceAccount<br>metadata:<br>name: my-service-account<br>annotations:<br>authorization.k8s.io/get: \"[]\"<br>"
    },
    "CKV_AWS_10": {
        "url": "https://docs.bridgecrew.io/docs/iam_9-1",
        "severity": "MEDIUM",
        "description": "<h4>AWS IAM password policy does not have a minimum of 14 characters</h4><h4>Description</h4>Password policies are used to enforce the creation and use of password complexity. Your IAM password policy should be set for passwords to require the inclusion of different character types. The password policy should enforce passwords contain a minimum of 14 characters, this increases security, especially from a brute force attack.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the password policy in the AWS Console you will need appropriate permissions to View Identity Access Management Account Settings.<br>To manually set the password policy with a minimum length, follow these steps:<br><br>Log in to the AWS Management Console as an IAM user at https://console.aws.amazon.com/iam/.<br>Navigate to IAM Services.<br>On the Left Pane click Account Settings.<br>Set Minimum password length to 14 or greater.<br>Click Apply password policy.<br><br>CLI Command<br>To change the password policy, use the following command:<br>Bashaws iam update-account-password-policy --minimum-password-length 14<br><br>\ud83d\udcd8NoteAll commands starting with aws iam update-account-password-policy can be combined into a single command.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_iam_account_password_policy\" \"strict\" {<br>minimum_password_length        = 14<br>require_lowercase_characters   = true<br>require_numbers                = true<br>require_uppercase_characters   = true<br>require_symbols                = true<br>allow_users_to_change_password = true<br>}<br>"
    },
    "CKV_AWS_9": {
        "url": "https://docs.bridgecrew.io/docs/iam_11",
        "severity": "MEDIUM",
        "description": "<h4>AWS IAM password policy does not expire in 90 days</h4><h4>Description</h4>Password policies are used to enforce the creation and use of password complexity. Your IAM password policy should require passwords to be rotated or expired within a specified timeframe, we recommend passwords expire after 90 days or less.<br>Reducing the lifetime of a password by enforcing regular password changes increases account resilience towards:<br><br>Brute force attack;<br>Passwords being stolen or compromised, sometimes without your knowledge;<br>Web filters and proxy servers intercepting and recording traffic, including encrypted data;<br>Use of the same user password across work, email, and personal systems; and<br>End user workstations compromised by a keystroke logger.<br><br><h4>Fix - Runtime</h4>AWS Console<br>To change the password policy in the AWS Console you will need appropriate permissions to View Identity Access Management Account Settings.<br>To manually set the password policy with a minimum length, use the following command:<br><br>Log in to the AWS Management Console as an IAM user at https://console.aws.amazon.com/iam/.<br>Navigate to IAM Services.<br>On the Left Pane click Account Settings.<br>Select Enable password expiration .<br>For Password expiration period (in days)\" enter 90** or less.<br>Click Apply password policy.<br><br>CLI Command<br>Change the password policy using CLI command:<br>Bashaws iam update-account-password-policy --max-password-age 90<br><br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_iam_account_password_policy\" \"strict\" {<br>minimum_password_length        = 8<br>require_lowercase_characters   = true<br>require_numbers                = true<br>require_uppercase_characters   = true<br>require_symbols                = true<br>apassword_reuse_prevention     = 24<br>max_password_age               = 89<br>}<br>"
    },
    "CKV_AWS_13": {
        "url": "https://docs.bridgecrew.io/docs/iam_10",
        "severity": "HIGH",
        "description": "<h4>AWS IAM password policy allows password reuse</h4><h4>Description</h4>Password policies are used to enforce the creation and use of password complexity. Your IAM password policy must prevent reuse of passwords. Each password should be brand new to increase security, especially from a brute force attack.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the password policy in the AWS Console you will need appropriate permissions to View Identity Access Management Account Settings.<br>To manually set the password policy with a minimum length, follow these steps:<br><br>Log in to the AWS Management Console as an IAM user at https://console.aws.amazon.com/iam/.<br>Navigate to IAM Services.<br>On the Left Pane click Account Settings.<br>Select Prevent password reuse.<br>For Number of passwords to remember\" enter 24**.<br>Click Apply password policy.<br><br>CLI Command<br>To change the password policy, use the following command:<br>Bashaws iam update-account-password-policy --password-reuse-prevention 24<br><br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_iam_account_password_policy\" \"strict\" {<br>minimum_password_length        = 8<br>require_lowercase_characters   = true<br>require_numbers                = true<br>require_uppercase_characters   = true<br>require_symbols                = true<br>apassword_reuse_prevention  = 24<br>}<br>"
    },
    "CKV_AWS_40": {
        "url": "https://docs.bridgecrew.io/docs/iam_16-iam-policy-privileges-1",
        "severity": "LOW",
        "description": "<h4>IAM policies are not only attached to Groups and Roles</h4><h4>Description</h4>By default, IAM users, groups, and roles have no access to AWS resources. IAM policies are the means by which privileges are granted to users, groups, or roles.<br>Assigning privileges at the group or role level reduces the complexity of access management as the number of users increase. Reducing access management complexity may in-turn reduce opportunity for a principal to inadvertently receive or retain excessive privileges.<br>We recommend that IAM policies are applied directly to groups and roles, but not to users.<br><h4>Fix - Buildtime</h4>CloudFormation<br><br>Resource: AWS::IAM::Policy<br>Arguments: Properties.Users<br><br>YAMLResources:<br>ExamplePolicy:<br>Type: 'AWS::IAM::Policy'<br>Properties:<br>...<br>-     Users:<br>-       - example_user<br>"
    },
    "CKV_AWS_1": {
        "url": "https://docs.bridgecrew.io/docs/iam_23",
        "severity": "CRITICAL",
        "description": "<h4>IAM policies that allow full administrative privileges are created</h4><h4>Description</h4>IAM policies are the means by which privileges are granted to users, groups, and roles. Standard security practice is to grant least privilege\u201a this is granting only the permissions required to perform a task. Providing full administrative may expose resources to potentially unwanted actions.<br>We recommend:<br><br>You determine what users need to do, then craft policies allowing them to perform only those tasks.<br>You do not allow all users full administrative privileges.<br>You start with a minimum set of permissions and grant additional permissions as necessary.<br>IAM policies that have a statement with Effect: Allow with Action:  over Resource:  are removed.<br><br><h4>Fix - Runtime</h4>AWS Console<br>To detach the policy that has full administrative privileges, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon IAM console.<br>In the navigation pane, click Policies and then search for the policy name found in the audit step.<br>Select the policy to be deleted.<br>In the Policy Action menu, select first Detach.<br>Select all Users, Groups, and Roles that have this policy attached.<br>Click Detach Policy.<br>In the Policy Action menu, select Detach.<br><br>CLI Command<br>To detach the policy that has full administrative privileges as found in the audit step, use the following commands:<br><br>Lists all IAM users, groups, and roles that the specified managed policy is attached to.<br><br>Bashaws iam list-entities-for-policy --policy-arn <policy_arn><br><br><br>Detach the policy from all IAM Users.<br><br>Bash   aws iam detach-user-policy --user-name <iam_user> --policy-arn <policy_arn><br><br><br>Detach the policy from all IAM Groups.<br><br>Bash   aws iam detach-group-policy --group-name <iam_group> --policy-arn <policy_arn><br><br><br>Detach the policy from all IAM Roles.<br><br>Bash   aws iam detach-role-policy --role-name <iam_role> --policy-arn <policy_arn><br><br><h4>Fix - Buildtime</h4>Terraform<br>Resource: aws_iam_policy<br>Goresource \"aws_iam_policy\" \"pass1\" {<br>name   = \"pass1\"<br>path   = \"/\"<br>policy = <<POLICY<br>{<br>\"Statement\": [<br>{<br>\"Action\": [<br>\"s3:ListBucket*\",<br>\"s3:HeadBucket\",<br>\"s3:Get*\"<br>],<br>\"Effect\": \"Allow\",<br>\"Resource\": [<br>\"arn:aws:s3:::b1\",<br>\"arn:aws:s3:::b1/*\",<br>\"arn:aws:s3:::b2\",<br>\"arn:aws:s3:::b2/*\"<br>],<br>\"Sid\": \"\"<br>},<br>{<br>\"Action\": \"s3:PutObject*\",<br>\"Effect\": \"Allow\",<br>\"Resource\": \"arn:aws:s3:::b1/*\",<br>\"Sid\": \"\"<br>}<br>],<br>\"Version\": \"2012-10-17\"<br>}<br>POLICY<br>}<br>"
    },
    "CKV_AWS_121": {
        "url": "https://docs.bridgecrew.io/docs/logging_5-enable-aws-config-regions",
        "severity": "MEDIUM",
        "description": "<h4>AWS config is not enabled in all regions</h4><h4>Description</h4>AWS Config is a web service that performs the configuration management of supported AWS resources within your account and delivers log files to you. The recorded information includes: the configuration item (AWS resource), relationships between configuration items (AWS resources), and any configuration changes between resources. The AWS configuration item history captured by AWS Config enables security analysis, resource change tracking, and compliance auditing.<br>We recommend you enable AWS Config in all regions.<br><h4>Fix - Runtime</h4>AWS Console<br>To implement AWS Config configuration using the AWS Management Console, follow these steps:<br><br>Log in to the AWS Management Console at [https://console.aws.amazon.com/].<br>At the top right of the console select the region you want to focus on.<br>Click Services.<br>Click Config.<br>Define which resources you want to record in the selected region. Include global resources (IAM resources).<br>Select an S3 bucket in the same account, or in another managed AWS account.<br>Create an SNS Topic from the same AWS account, or from another managed AWS account.<br><br>CLI Command<br>To change the policy using the following steps and commands:<br><br>Ensure there is an appropriate S3 bucket, SNS topic, and IAM role per the AWS Config Service prerequisites.<br>Set up the configuration recorder:<br><br>Bashaws configservice subscribe<br>--s3-bucket my-config-bucket<br>--sns-topic arn:aws:sns:us-east-1:012345678912:my-config-notice<br>--iam-role arn:aws:iam::012345678912:role/myConfigRole<br><br><br>Start the configuration recorder:<br><br>Bashstart-configuration-recorder<br>--configuration-recorder-name <value><br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_config_configuration_aggregator<br>Argument: all_regions<br><br>Goresource \"aws_config_configuration_aggregator\" \"organization\" {<br>name = \"example\"<br>account_aggregation_source {<br>account_ids  = [\"123456789012\"]<br>+   all_regions  = true<br>}<br>"
    },
    "CKV_AWS_49": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_iam_43",
        "severity": "HIGH",
        "description": "<h4>IAM policy documents allow * (asterisk) as a statement's action</h4><h4>Description</h4>The Action element describes the specific action or actions that will be allowed or denied. Statements must include either an Action or NotAction element. Each AWS service has its own set of actions that describe tasks that can be performed with that service. Specify a value using a namespace that identifies a service, for example, iam, ec2 sqs, sns, s3, followed by the name of the action to be allowed or denied. The name must match an action that is supported by the service.<br>We recommend you do not allow \"*\" (all resource) statements as part of action elements. This level of access could potentially grant unwanted and unregulated access to anyone given this policy document setting. We recommend you to write a refined policy describing the specific action allowed or required by the specific policy holder.<br><h4>Fix - Runtime</h4>AWS Console<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon IAM console.<br>In the navigation pane, choose Policies.<br>In the list of policies, choose the policy name of the policy to edit. You can use the Filter menu and the search box to filter the list of policies.<br>Choose the Permissions tab, then choose Edit Policy.<br>Identify any Action statements permitting actions access to all resources (\"*\").<br>On the Review page, review the policy Summary, then click Save Changes.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Argument: statement<br>Attribute: action<br>Example fix:<br><br>aws_iam_policyresource \"aws_iam_policy\" \"example\" {<br># ... other configuration ...<br>policy = <<POLICY<br>{<br>\"Version\": \"2012-10-17\",<br>\"Statement\": {<br>\"Effect\": \"Allow\",<br>-    \"Action\": \"*\",<br>\"Resource\": \"*\"<br>}<br>"
    },
    "CKV_AWS_12": {
        "url": "https://docs.bridgecrew.io/docs/iam_8",
        "severity": "MEDIUM",
        "description": "<h4>AWS IAM password policy does not have a number</h4><h4>Description</h4>Password policies are used to enforce the creation and use of password complexity. Your IAM password policy should be set for passwords to require the inclusion of different character types. The password policy should enforce passwords contain at least one number, this increases security, especially from a brute force attack.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the password policy in the AWS Console you will need appropriate permissions to View Identity Access Management Account Settings.<br>To manually set the password policy with a minimum length, follow these steps:<br><br>Log in to the AWS Management Console as an IAM user at https://console.aws.amazon.com/iam/.<br>Navigate to IAM Services.<br>On the Left Pane click Account Settings.<br>Select Require at least one number.<br>Click Apply password policy.<br><br>CLI Command<br>To change the password policy, use the following command:<br>Bashaws iam update-account-password-policy --require-numbers<br><br>\ud83d\udcd8NoteAll commands starting with aws iam update-account-password-policy can be combined into a single command.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_iam_account_password_policy\" \"strict\" {<br>minimum_password_length        = 8<br>require_lowercase_characters   = true<br>require_numbers                = true<br>require_uppercase_characters   = true<br>require_symbols                = true<br>allow_users_to_change_password = true<br>}<br>"
    },
    "CKV_AWS_60": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_iam_44",
        "severity": "HIGH",
        "description": "<h4>IAM role does not allow only specific services or principals to be assumed</h4><h4>Description</h4>The IAM role is an identity with specific permissions. An IAM role is similar to an IAM user: it has an AWS identity with permission policies that determine what the identity can and cannot do in AWS. When a user assumes a role, it is provided with temporary security credentials for a bounded session.<br>The list of principals able to assume a role should be limited as much as possible, and should not include \"*\", meaning that any authenticated identity across all of AWS can assume the role.<br>We recommend that you define fine-grained roles for specific services or principles. For example, when setting up an AWS service role it is recommended to include only the permissions required for the service to access the AWS resources required. Alternatively, you can use a principal as an entity that can perform actions and access resources. The main benefit of the principal entity is to limit the use of wildcards in the policy document.<br><h4>Fix - Runtime</h4>AWS IAM Console<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon IAM console.<br>Click Roles, and find the role to update.<br>Click the Trust relationships tab.<br>Click Show policy document or Edit trust relationship to view the policy document.<br>After clicking Edit trust relationship, remove any \"Allow\" statements that have an AWS Principal including \"*\".<br>Click Update Trust Policy.<br><br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_iam_role\" \"test_role\" {<br>name = \"test_role\"<br>...<br>assume_role_policy = <<EOF<br>{<br>\"Version\": \"2012-10-17\",<br>\"Statement\": [<br>{<br>\"Action\": \"sts:AssumeRole\",<br>\"Principal\": {<br>\"AWS\": [<br>-         \"*\"<br>]<br>},<br>\"Effect\": \"Allow\",<br>\"Sid\": \"\"<br>}<br><br>CloudFormation<br><br>Resource: AWS::IAM::Role<br>Argument: Properties.AssumeRolePolicyDocument.Statement<br><br>YAMLType: 'AWS::IAM::Role'<br>Properties:<br>AssumeRolePolicyDocument:<br>Version: \"2012-10-17\"<br>Statement:<br>- Effect: Allow<br>Principal:<br>\"AWS\":<br>-               - \"*\"<br>"
    },
    "CKV_AWS_61": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_iam_45",
        "severity": "HIGH",
        "description": "<h4>AWS IAM policy does allow assume role permission across all services</h4><h4>Description</h4>The IAM role is an identity with specific permissions. An IAM role is similar to an IAM user, it is an AWS identity with permission policies that determine what the identity can and cannot do in AWS. When a user assumes a role, it provides temporary security credentials for a bounded session.<br>We recommend that you define fine-grained roles for specific services or principles. For example, when settings up an AWS service role it is recommended to include only the permissions required for the service to access the AWS resources required. Alternatively, you can use a Principal as an entity in AWS that can perform actions and access resources. The main benefit of the Principal entity is to limit the use of wildcards in the policy document.<br><h4>Fix - Buildtime</h4>CloudFormation<br><br>Resource: AWS::IAM::Role<br>Argument: Properties.AssumeRolePolicyDocument.Statement<br><br>YAMLResources:<br>ExecutionRole:<br>Type: AWS::IAM::Role<br>Properties:<br>...<br>AssumeRolePolicyDocument:<br>...<br>Statement:<br>- Effect: \"Allow\"<br>Principal:<br>AWS:<br>-                 - arn:aws:iam::123456789101:root<br>-                                   - 123456789101<br>"
    },
    "CKV_AWS_CUSTOM_1": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_26",
        "severity": "LOW",
        "description": "<h4>AWS resources that support tags do not have Tags</h4><h4>Description</h4>Many different types of AWS resources support tags. Tags allow you to add metadata to a resource to help identify ownership, perform cost / billing analysis, and to enrich a resource with other valuable information, such as descriptions and environment names. While there are many ways that tags can be used, we recommend you follow a tagging practice.<br>View AWS's recommended tagging best practices here.<br><h4>Fix - Runtime</h4>AWS Console<br>The procedure varies by resource type. Tags can be added in the AWS console by navigating to the specific resource. There is usually a \"tags\" tab in the resource view that can be used to view and modify tags.<br>Example to edit tags for a Security Group:<br><br>Navigate to the Amazon EC2 console.<br>Select Security groups<br>Select a security group to edit, then click the Tags tab.<br>Click Manage tags, then Add new tag to add a tag.<br>Click Save changes.<br><br>CLI Command<br>The following command shows how to add tags for any resource associated with the EC2 service (in this case, a security group). The specific command varies by resource type for non-EC2 services (e.g., RDS).<br>aws ec2 create-tags --resources sg-000b51bf43c710838 --tags Key=Environment,Value=Dev<br><h4>Fix - Buildtime</h4>Terraform<br>The example below shows how to tag a security group in Terraform. The syntax is generally the same for any taggable resource type.<br>Goresource \"aws_security_group\" \"sg\" {<br>name = \"my-sg\"<br>...<br>+ tags = {<br>+   Environment = \"dev\"<br>+   Owner = \"apps-team\"<br>+ }<br>}<br>"
    },
    "CKV_AWS_72": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_iam_46",
        "severity": "HIGH",
        "description": "<h4>SQS policy documents allow * (asterisk) as a statement's action</h4><h4>Description</h4>The Action element describes the specific action or actions that will be allowed or denied. Statements must include either an Action or NotAction element. Each AWS service has its own set of actions that describe tasks that can be performed with that service. Specify a value using a namespace that identifies a service, for example, iam, ec2 sqs, sns, s3, followed by the name of the action to be allowed or denied. The name must match an action that is supported by the service.<br>We recommend you do not allow \"*\" (all resource) statements as part of action elements. This level of access could potentially grant unwanted and unregulated access to anyone given this policy document setting. We recommend you to write a refined policy describing the specific action allowed or required by the specific policy holder.<br><h4>Fix - Runtime</h4>AWS Console<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon SQS console.<br>Click on the queue you want to modify.<br>Click on the \"Access Policy\" tab within the queue's details page.<br>Click \"edit\" next to the displayed \"Access Policy\".<br>Identify any Action statements permitting actions access to all resources (\"*\").<br>Narrow the scope to necessary actions, for example sqs:SendMessage<br>Click Save.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Argument: statement<br>Attribute: action<br><br>aws_iam_policyresource \"aws_sqs_queue_policy\" \"example\" {<br>queue_url = aws_sqs_queue.q.id<br><br>policy = <<POLICY<br>{<br>\"Version\": \"2012-10-17\",<br>\"Id\": \"sqspolicy\",<br>\"Statement\": [<br>{<br>\"Sid\": \"First\",<br>\"Effect\": \"Allow\",<br>\"Principal\": \"*\",<br>\"Action\": \"sqs:SendMessage\",<br>\"Resource\": \"${aws_sqs_queue.q.arn}\",<br>\"Condition\": {<br>\"ArnEquals\": {<br>\"aws:SourceArn\": \"${aws_sns_topic.example.arn}\"<br>}<br>}<br>}<br>]<br>}<br>POLICY<br>}<br>"
    },
    "CKV_AWS_67": {
        "url": "https://docs.bridgecrew.io/docs/logging_1",
        "severity": "LOW",
        "description": "<h4>AWS CloudTrail is not enabled in all regions</h4><h4>Description</h4>AWS CloudTrail is a web service that records AWS API calls for your account and delivers log files to you. The recorded information includes: the identity of the API caller, the time of the API call, the source IP address of the API caller, the request parameters, and the response elements returned by the AWS service. CloudTrail provides a history of AWS API calls for an account, including API calls made via the Management Console, SDKs, command line tools, and higher-level AWS services such as CloudFormation.<br>The AWS API call history produced by CloudTrail enables security analysis, resource change tracking, and compliance auditing. AWS CloudTrail provides additional multi-region security:<br><br>Ensuring that a multi-regions trail exists will detect unexpected activity occurring in otherwise unused regions.<br>Ensuring that a multi-regions trail exists will enable Global Service Logging for a trail by default, capturing records of events generated on AWS global services.<br>For a multi-regions trail, ensuring that management events are configured for all types of Read/Write operations, results in the recording of management actions performed on all resources in an AWS account.<br><br><h4>Fix - Runtime</h4>AWS Console<br>To enable global (multi-region) CloudTrail logging, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Cloudtrail dashboard.<br>On the left navigation pane, click Trails.<br>Click Get Started Now.<br>Click Add new trail .<br>Enter a trail name in the Trail name box.<br>Set Apply trail to all regions option to Yes.<br>Enter an S3 bucket name in the S3 bucket box.<br>Click Create.<br><br>If one or more trail already exist, select the target trail to enable global logging, using the following steps:<br><br>Next to Apply trail to all regions, click the edit icon (pencil) and select Yes.<br>Click Save.<br>Next to Management Events, click the edit icon (pencil) and select All Read/Write Events.<br>Click Save.<br><br>CLI Command<br>To create a multi-region trail, use the following command:<br>Bashaws cloudtrail create-trail<br>--name <trail_name><br>--bucket-name <s3_bucket_for_cloudtrail><br>--is-multi-region-trail aws cloudtrail update-trail<br>--name <trail_name><br>--is-multi-region-trail<br><br>\ud83d\udcd8NoteCreating a CloudTrail with a CLI command, without providing any overriding options, configures Read/Write Management Events to All.<br><h4>Fix - Buildtime</h4>CloudFormation<br><br>Resource:  AWS::CloudTrail::Trail<br>Argument: Properties.IsMultiRegionTrail<br><br>YAMLResources:<br>MyTrail:<br>Type: AWS::CloudTrail::Trail<br>Properties:<br>...<br>+     IsMultiRegionTrail: True<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_cloudtrail<br>Argument: is_multi_region_trail - (Optional) Specifies whether the trail is created in the current region or in all regions. Defaults to false.<br><br><br>Goresource \"aws_cloudtrail\" \"foobar\" {<br>name                          = \"tf-trail-foobar\"<br>s3_bucket_name                = aws_s3_bucket.foo.id<br>s3_key_prefix                 = \"prefix\"<br>include_global_service_events = false<br>+ is_multi_region_trail = true<br>}<br>"
    },
    "CKV_AWS_35": {
        "url": "https://docs.bridgecrew.io/docs/logging_7",
        "severity": "MEDIUM",
        "description": "<h4>AWS CloudTrail logs are not encrypted using CMKs</h4><h4>Description</h4>AWS CloudTrail is a web service that records AWS API calls for an account, and makes those logs available to users and resources in accordance with IAM policies. AWS Key Management Service (KMS) is a managed service that helps create and control the encryption keys used to encrypt account data. It uses Hardware Security Modules (HSMs) to protect the security of encryption keys. CloudTrail logs can be configured to leverage server-side encryption (SSE) and KMS customer created master keys (CMK) to further protect CloudTrail logs.<br>We recommend that CloudTrail logs are configured to use SSE-KMS, providing additional confidentiality controls on log data. A given user must have S3 read permission on the corresponding log bucket and must be granted decrypt permission by the CMK policy.<br><h4>Fix - Runtime</h4>AWS Console<br>To configure CloudTrail to use SSE-KMS using the Management Console, follow these steps:<br><br>Log in to the AWS Management Console at [https://console.aws.amazon.com/].<br>Open the Amazon CloudTrail console.<br>In the left navigation pane, click Trails.<br>Select a Trail.<br>Navigate to the S3 section, click the edit button (pencil icon).<br>Click Advanced.<br>From the KMS key Id drop-down menu, select an existing CMK.<br><br>\ud83d\udcd8NoteEnsure the CMK is located in the same region as the S3 bucket.<br><br>For CloudTrail as a service to encrypt and decrypt log files using the CMK provided, apply a KMS Key policy on the selected CMK.<br>Click Save.<br>You will see a notification message stating that you need to have decrypt permissions on the specified KMS key to decrypt log files. Click Yes.<br><br>CLI Command<br>To update the CloudTrail, use the following command:<br>Bashaws cloudtrail update-trail<br>--name <trail_name><br>--kms-id <cloudtrail_kms_key> aws kms put-key-policy<br>--key-id <cloudtrail_kms_key><br>--policy <cloudtrail_kms_key_policy><br><br><h4>Fix - Buildtime</h4>CloudFormation<br><br>Resource:  AWS::CloudTrail::Trail<br>Argument: Properties.KMSKeyId<br><br>YAMLResources:<br>myTrail:<br>Type: AWS::CloudTrail::Trail<br>Properties:<br>...<br>+           KMSKeyId: alias/MyAliasName<br>"
    },
    "CKV_AWS_7": {
        "url": "https://docs.bridgecrew.io/docs/logging_8",
        "severity": "MEDIUM",
        "description": "<h4>AWS CMK rotation is not enabled</h4><h4>Description</h4>AWS Key Management Service (KMS) allows customers to rotate the backing key. This is where key material is stored within the KMS, and tied to the key ID of the Customer Created customer master key (CMK). The backing key is used to perform cryptographic operations such as encryption and decryption. Automated key rotation currently retains all prior backing keys, allowing decryption of encrypted data to take place transparently.<br>We recommend you enable CMK key rotation to help reduce the potential impact of a compromised key. Data encrypted with a new key cannot be accessed with a previous key, that may have been exposed.<br><h4>Fix - Runtime</h4>AWS Console<br>Procedure:<br><br>Log in to the AWS Management Console at [https://console.aws.amazon.com/].<br>Open the Amazon KMS console.<br>In the left navigation pane, select customer managed keys.<br>Select the customer master key (CMK) in scope.<br>Navigate to the Key Rotation tab.<br>Select Rotate this key every year.<br>Click Save.<br><br>CLI Command<br>Change the policy to enable key rotation using CLI command:<br>Bashaws kms enable-key-rotation --key-id <kms_key_id><br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_kms_key<br>Argument: enable_key_rotation - (Optional) Specifies whether key rotation is enabled. Defaults to false.<br><br>aws_kms_keyresource \"aws_kms_key\" \"kms_key_1\" {<br>...<br>is_enabled              = true<br>+ enable_key_rotation    = true<br>}<br><br>CloudFormation<br><br>Resource: AWS::KMS::Key<br>Attribute: EnableKeyRotation - (Optional) Specifies whether key rotation is enabled. Defaults to false.<br><br>YAMLType: AWS::KMS::Key<br>Properties:<br>...<br>+ EnableKeyRotation: true0<br>"
    },
    "CKV_AWS_48": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_logging_10",
        "severity": "MEDIUM",
        "description": "<h4>Amazon MQ Broker logging is not enabled</h4><h4>Description</h4>Amazon MQ is a broker service built on Apache ActiveMQ. As a message broker, MQ allows applications to communicate using various programming languages, operating systems and formal messaging protocols.<br>Amazon MQ is integrated with CloudTrail and provides a record of the Amazon MQ calls made by a user, role, or AWS service. It supports logging both the request parameters and the responses for APIs as events in CloudTrail. Logging MQ ensures developers can trace all requests and responses, and ensure they are only used for their predefined message brokering settings.<br>We recommend you enable Amazon MQ Broker Logging.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_mq_broker\" \"enabled\" {<br>broker_name        = \"example\"<br>engine_type        = \"ActiveMQ\"<br>engine_version     = \"5.16.3\"<br>host_instance_type = \"mq.t3.micro\"<br><br>user {<br>password = \"admin123\"<br>username = \"admin\"<br>}<br><br>logs {<br>general = true<br>}<br>}<br>"
    },
    "CKV_AWS_65": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_logging_11",
        "severity": "LOW",
        "description": "<h4>Container insights are not enabled on ECS cluster</h4><h4>Description</h4>Container Insights can be used to collect, aggregate, and summarize metrics and logs from containerized applications and microservices. They can also be extended to collect metrics at the cluster, task, and service levels. Using Container Insights allows you to monitor, troubleshoot, and set alarms for all your Amazon ECS resources. It provides a simple to use native and fully managed service for managing ECS issues.<br>We recommend that for existing clusters you use the AWS CLI; and for new clusters, you use either the Amazon ECS console, or the AWS CLI.<br><h4>Fix - Runtime</h4>AWS Console<br><br>Log in to the AWS Management Console at [https://console.aws.amazon.com/].<br>Open the Amazon ECS console.<br>In the navigation pane, choose Account Settings.<br>To enable the Container Insights default opt-in, check the box at the bottom of the page.<br><br>CLI Command<br>You can use the AWS CLI to set account-level permission to enable Container Insights for any new Amazon ECS clusters created in your account. To do so, enter the following command.<br>aws ecs put-account-setting<br>--name \"containerInsights\"<br>--value \"enabled\"<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_ecs_cluster<br>Argument: setting<br><br>aws_ecs_clusterresource \"aws_ecs_cluster\" \"foo\" {<br>...<br>name = \"white-hart\"<br>+ setting {<br>+   name  = \"containerInsights\"<br>+   value = \"enabled\"<br>+ }<br>}<br><br>CloudFormation<br><br>Resource: AWS::ECS::Cluster<br>Argument: Properties.ClusterSettings<br><br>YAMLResources:<br>ECSCluster:<br>Type: 'AWS::ECS::Cluster'<br>Properties:<br>...<br>+     ClusterSettings:<br>+       - Name: 'containerInsights'<br>+         Value: 'enabled'<br>"
    },
    "CKV_AWS_14": {
        "url": "https://docs.bridgecrew.io/docs/iam_7",
        "severity": "MEDIUM",
        "description": "<h4>AWS IAM password policy does not have a symbol</h4><h4>Description</h4>Password policies are used to enforce the creation and use of password complexity. Your IAM password policy should be set for passwords to require the inclusion of different character types. The password policy should enforce passwords contain at least one symbol, this increases security, especially from a brute force attack.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the password policy in the AWS Console you will need appropriate permissions to View Identity Access Management Account Settings.<br>go<br>To manually set the password policy with a minimum length, follow these steps:<br><br>Log in to the AWS Management Console as an IAM user at https://console.aws.amazon.com/iam/.<br>Navigate to IAM Services.<br>On the Left Pane click Account Settings.<br>Select Require at least one non-alphanumeric character.<br>Click Apply password policy.<br><br>CLI Command<br>To change the password policy, use the following command:<br>Bashaws iam update-account-password-policy --require-symbols<br><br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_iam_account_password_policy\" \"strict\" {<br>minimum_password_length        = 8<br>require_lowercase_characters   = true<br>require_numbers                = true<br>require_uppercase_characters   = true<br>require_symbols                = true<br>allow_users_to_change_password = true<br>}<br><br>\ud83d\udcd8NoteAll commands starting with aws iam update-account-password-policy can be combined into a single command.<br>"
    },
    "CKV_AWS_34": {
        "url": "https://docs.bridgecrew.io/docs/networking_32",
        "severity": "HIGH",
        "description": "<h4>CloudFront distribution ViewerProtocolPolicy is not set to HTTPS</h4><h4>Description</h4>AWS::CloudFront::Distribution ViewerCertificate determines the distribution\u2019s SSL/TLS configuration for communicating with viewers.<br>We recommend you use the ViewerProtocolPolicy parameter to enable secure HTTPS communication between clients and your CloudForamtion templates. Most browsers and clients released after 2010 support server name indication.<br>AWS recommends to accept HTTPS connections only from viewers that support SNI and advises against receiving HTTPS connections from all viewers, including those that do not support SNI, set SslSupportMethod. This also results in additional monthly charges from CloudFront.<br><h4>Fix - Runtime</h4>Procedure<br>Use ViewerProtocolPolicy in the CacheBehavior or DefaultCacheBehavior, and select Redirect HTTP to HTTPS or HTTPS Only.<br>To specify how CloudFront should use SSL/TLS to communicate with your custom origin, use CustomOriginConfig.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource:  aws_cloudfront_distribution<br>Argument:  viewer_protocol_policy under default_cache_behavior or ordered_cache_behavior must not be allow-all. Acceptable values are redirect-to-https or https-only.<br><br>Goresource \"aws_cloudfront_distribution\" \"cloudfront\" {<br>...<br>default_cache_behavior {<br>...<br>target_origin_id       = \"my-origin\"<br>-  viewer_protocol_policy = \"allow-all\"<br>+  viewer_protocol_policy = \"redirect-to-https\"<br>}<br>}<br><br>CloudFormation<br><br>Resource:  AWS::CloudFront::Distribution<br>Argument:  ViewerProtocolPolicy under Properties.DefaultCacheBehavior or Properties.CacheBehaviors must not be allow-all. Acceptable values are redirect-to-https or https-only.<br><br>YAMLResources:<br>CloudFrontDistribution:<br>Type: 'AWS::CloudFront::Distribution'<br>Properties:<br>DistributionConfig:<br>...<br>DefaultCacheBehavior:<br>...<br>-         ViewerProtocolPolicy: 'allow-all'<br>+         ViewerProtocolPolicy: 'https-only' # or 'redirect-to-https'<br><br>CacheBehaviors:<br>- TargetOriginId: customorigin<br>...<br>-           ViewerProtocolPolicy: allow-all<br>+           ViewerProtocolPolicy: https-only # or redirect-to-https<br>"
    },
    "CKV_AWS_24": {
        "url": "https://docs.bridgecrew.io/docs/networking_1-port-security",
        "severity": "LOW",
        "description": "<h4>AWS Security Group allows all traffic on SSH port 22</h4><h4>Description</h4>Security groups are stateful and provide filtering of ingress/egress network traffic to AWS resources. We recommend that security groups do not allow unrestricted ingress access to port 22. Removing unfettered connectivity to remote console services, such as SSH, reduces a server's exposure to risk.<br><h4>Fix - Runtime</h4>AWS Console<br>To implement the prescribed state, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon VPC console.<br>In the left pane, click Security Groups.<br>For each security group, perform the following:<br>a) Select the security group.<br>b) Click Inbound Rules.<br>c) Identify the rules to be removed.<br>d) Click X in the Remove column.<br>Click Save.<br><br>CLI Command<br><br>Review the rules for an existing security group (Replacing the security group ID and region).<br><br>Shellaws ec2 describe-security-groups<br>--group-ids sg-xxxxxxxxxxxxxxxxx<br>--region us-east-1<br><br><br>Review and EC2 instances using the security group.<br><br>Shellaws ec2 describe-instances<br>--filters Name=instance.group-id,Values=sg-xxxxxxxxxxxxxxxxx<br>--region us-east-1<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_security_group<br>Argument:<br><br>aws_security_group.tfresource \"aws_security_group\" \"example\" {<br>...<br>ingress {<br>cidr_blocks = [<br>-     \"0.0.0.0/0\"<br>+     \"10.0.0.1/32\"<br>]<br>from_port = 22<br>to_port = 22<br>protocol = \"tcp\"<br>}<br>}<br><br>CloudFormation<br><br>Resource: AWS::EC2::SecurityGroup<br>Argument: Properties.SecurityGroupIngress<br><br>YAMLType: AWS::EC2::SecurityGroup<br>Properties:<br>...<br>SecurityGroupIngress:<br>- Description: SSH Ingress<br>IpProtocol: tcp<br>FromPort: 22<br>ToPort: 22<br>-       CidrIp: \"0.0.0.0/0\"<br>+       CidrIp: \"10.10.10.0/24\"<br>"
    },
    "CKV_AWS_25": {
        "url": "https://docs.bridgecrew.io/docs/networking_2",
        "severity": "LOW",
        "description": "<h4>Security Groups allow ingress from 0.0.0.0/0 to port 3389</h4><h4>Description</h4>Security groups are stateful and provide filtering of ingress/egress network traffic to AWS resources. We recommend that security groups do not allow unrestricted ingress access to port 3389. Removing unfettered connectivity to remote console services, such as SSH, reduces a server's exposure to risk.<br>Rationale<br>Removing unfettered connectivity to remote console services, such as RDP, reduces a server's exposure to risk.<br><h4>Fix - Runtime</h4>AWS Console<br>To implement the prescribed state, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon VPC console.<br>In the left pane, click Security Groups.<br>For each security group, perform the following:<br>a) Select the security group.<br>b) Click Inbound Rules.<br>c) Identify the rules to be removed.<br>d) Click X in the Remove column.<br>Click Save.<br><br><h4>Fix - Buildtime</h4>Terraform<br>The issue is the CIDR specified in the ingress control rule - \"0.0.0.0/0\". Change it from this:<br>aws_security_group.tfresource \"aws_security_group\" \"example\" {<br>...<br>ingress {<br>from_port   = 3389<br>to_port     = 3389<br>protocol    = \"tcp\"<br>-   cidr_blocks = [\"0.0.0.0/0\"]<br>+   cidr_blocks = [\"10.0.0.1/32\"]<br>}<br>}<br><br>CloudFormation<br><br>Resource: AWS::EC2::SecurityGroup<br>Argument: Properties.SecurityGroupIngress<br><br>YAMLType: AWS::EC2::SecurityGroup<br>Properties:<br>...<br>SecurityGroupIngress:<br>- Description: SSH Ingress<br>IpProtocol: tcp<br>FromPort: 3389<br>ToPort: 3389<br>-       CidrIp: \"0.0.0.0/0\"<br>+       CidrIp: \"10.10.10.0/24\"<br>"
    },
    "CKV_AWS_235": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-copied-amis-are-encrypted",
        "severity": "LOW",
        "description": "<h4>AWS copied AMIs are not encrypted</h4><h4>Description</h4>As a best practice enable encryption for your AWS copied AMIs to improve data security without making changes to your business or applications.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_ami_copy\" \"pass\" {<br>name              = \"terraform-example\"<br>description       = \"A copy of ami-xxxxxxxx\"<br>source_ami_id     = \"ami-xxxxxxxx\"<br>source_ami_region = \"us-west-1\"<br>encrypted         = true<br>tags = {<br>Name = \"HelloWorld\"<br>test = \"failed\"<br>}<br>}<br>"
    },
    "CKV_AWS_2": {
        "url": "https://docs.bridgecrew.io/docs/networking_29",
        "severity": "MEDIUM",
        "description": "<h4>ALB protocol is not HTTPS</h4><h4>Description</h4>An internet-facing AWS ELB/ALB is a public resource on your network that is completely exposed to the internet. It has a publicly resolvable DNS name, that can accept HTTP(S) requests from clients over the Internet. External actors gaining knowledge to this information can potentially attempt to access the EC2 instances that are registered with the load balancer.<br>When an AWS ALB has no HTTPS listeners, front-end connections between the web clients and the load balancer could become targeted by man-in-the-middle attacks and traffic interception techniques.<br><h4>Fix - Runtime</h4>AWS Console<br><br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br><br><br>Open the Amazon EC2 console.<br><br><br>Navigate to LOAD BALANCING, select Load Balancers.<br><br><br>Select a load balancer, then select Listeners.<br><br><br>To add a listener, select Add Listener.<br><br>For Protocol : port, select HTTPS and keep the default port or type a different port.<br>For Default actions, do one of the following:<br>\u2022\tChoose Add action, Forward to and choose a target group.<br>\u2022\tChoose Add action, Redirect to and provide the URL for the redirect.<br>\u2022\tChoose Add action, Return fixed response and provide a response code and optional response body.<br>To save the action, select the checkmark icon.<br>For Security policy, it is recommended that you keep the default security policy.<br>For Default SSL certificate, do one of the following:<br>\u2022\tIf you created or imported a certificate using AWS Certificate Manager, select From ACM and select the certificate.<br>\u2022\tIf you uploaded a certificate using IAM, select From IAM and select the certificate.<br><br><br><br>Click Save.<br><br><br><h4>Fix - Buildtime</h4>CloudFormation<br><br>Resource:  AWS::ElasticLoadBalancingV2::Listener<br>Arguments: Properties.Protocol / Properties.DefaultActions<br><br>YAMLResources:<br>ListenerHTTPS:<br>Type: AWS::ElasticLoadBalancingV2::Listener<br>Properties:<br>...<br># Option 1:<br>+     Protocol: HTTPS # Or TCP / TLS / UDP / TCP_UDP<br># Option 2:<br>+     DefaultActions:<br>+       - Type: redirect<br>+         RedirectConfig:<br>+           Protocol: HTTPS<br>...<br>"
    },
    "CKV_AWS_23": {
        "url": "https://docs.bridgecrew.io/docs/networking_31",
        "severity": "LOW",
        "description": "<h4>Not every Security Group rule has a description</h4><h4>Description</h4><h4>Descriptions can be up to 255 characters long and can be set and viewed from the AWS Management Console, AWS Command Line Interface (CLI), and the AWS APIs.</h4>We recommend you add descriptive text to each of your Security Group Rules clarifying each rule's goals, this helps prevent developer errors.<br><h4>Fix - Runtime</h4>AWS Console<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon VPC console.<br>Select Security Groups.<br>Select Create Security Group.<br>Select a Security Group and review all of the descriptions.<br>To modify the rules and descriptions, click Edit.<br><br><h4>Fix - Buildtime</h4>Terraform<br>Add a description to your ingress or egress rule.<br>aws_security_group.examplea.tfresource \"aws_security_group\" \"examplea\" {<br>name        = var.es_domain<br>description = \"Allow inbound traffic to ElasticSearch from VPC CIDR\"<br>vpc_id      = var.vpc<br><br><br>ingress {<br>cidr_blocks = [\"10.0.0.0/16\"]<br>+ description = \"What does this rule enable\"<br>from_port   = 80<br>protocol    = \"tcp\"<br>to_port     = 80<br>}<br>}<br>"
    },
    "CKV_AWS_38": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_kubernetes_1",
        "severity": "HIGH",
        "description": "<h4>AWS EKS cluster security group overly permissive to all traffic</h4><h4>Description</h4>Amazon EKS creates an endpoint for any managed Kubernetes API server to communicate with the cluster. By default, this API server endpoint is public to the internet. Access to it should be regulated using AWS IAM and native Kubernetes RBAC.<br>We recommend that your Kubernetes API server remains private so that all communication between worker nodes and APIs stays within your VPC. If public access is needed, at a minimum, restrict the IP addresses that can access your API server from the internet to reduce the potential attack surface. Ensure your Amazon EKS public endpoint is not accessible to 0.0.0.0/0.<br><h4>Fix - Runtime</h4>Amazon Console<br><br>Login to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon EKS console.<br>To display your cluster information, select the cluster's name.<br>Navigate to Networking, select Update.<br>Select Private Access or Public Access.<br>Private access. Select whether to enable or disable private access for your cluster's Kubernetes API server endpoint. If you enable private access, Kubernetes API requests that originate from within your cluster's VPC use the private VPC endpoint. You must enable private access to disable public access.<br>Public access. Select whether to enable or disable public access for your cluster's Kubernetes API server endpoint. If you disable public access, your cluster's Kubernetes API server can only receive requests from within the cluster VPC.<br>Click Advanced Settings.<br>To enter a CIDR block or add additional blocks, select Add Source. If you specify no blocks, the public API server endpoint receives requests from all (0.0.0.0/0) IP addresses.<br>To finish, click Update.<br><br><h4>Fix - Buildtime</h4>Terraform<br>Resource: aws_eks_cluster<br>Argument: endpoint_public_access, public_access_cidrs<br>Go##Option 1<br>resource \"aws_eks_cluster\" \"disabled\" {<br>name     = \"example\"<br>role_arn = \"aws_iam_role.arn\"<br><br>vpc_config {<br>subnet_ids = [\"subnet-12345\"]<br><br>endpoint_public_access = False<br>}<br><br>##Option 2:<br>resource \"aws_eks_cluster\" \"restricted\" {<br>name     = \"example\"<br>role_arn = \"aws_iam_role.arn\"<br><br>vpc_config {<br>subnet_ids = [\"subnet-12345\"]<br><br>public_access_cidrs = [\"10.0.0.0/16\"]<br>}<br>}<br>}<br>"
    },
    "CKV_AWS_39": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_kubernetes_2",
        "severity": "MEDIUM",
        "description": "<h4>AWS EKS cluster endpoint access is publicly enabled</h4><h4>Description</h4>Amazon EKS creates an endpoint for any managed Kubernetes API server to communicate with the cluster. This API server endpoint is public to the internet by default. Access to it should be regulated using AWS IAM and native Kubernetes RBAC.<br>We recommended that your Kubernetes API server remains private so that all communication between worker nodes and APIs stays within your VPC. If public access is needed, restrict the IP addresses that can access your API server from the internet to reduce the potential attack surface.<br><h4>Fix - Runtime</h4>Amazon Console<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon EKS console.<br>Choose the name of the cluster to display your cluster information.<br>Under Networking, click Update.<br>For Private access, disable private access for your cluster's Kubernetes API server endpoint. You must enable private access to disable public access.<br><br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_eks_cluster\" \"disabled\" {<br>name     = \"example\"<br>role_arn = \"aws_iam_role.arn\"<br><br>vpc_config {<br>subnet_ids = [\"subnet-12345\"]<br><br>endpoint_public_access = False<br>}<br>}<br>"
    },
    "CKV_AWS_58": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_kubernetes_3",
        "severity": "LOW",
        "description": "<h4>AWS EKS cluster does not have secrets encryption enabled</h4><h4>Description</h4>Secrets in Kubernetes enables managing sensitive information such as passwords and API keys using Kubernetes-native APIs. When creating a secret resource the Kubernetes API server stores it in etcd in a base64 encoded form. For example, using kubectl create secret, EKS can encrypt etcd volumes at disk-level using AWS-managed encryption keys.<br>AWS encourages using envelope encryption to encrypt a key with another key. The motivation is security best practice. Applications store sensitive data as part of a defense in depth security strategy. A master key is stored in AWS KMS that is then utilized for data key generation in the Kubernetes API server. It is also used to encrypt/decrypt sensitive data stored in Kubernetes secrets.<br><h4>Fix - Buildtime</h4>CloudFormation<br>Resource: AWS::EKS::Cluster<br>Argument: Properties.EncryptionConfig.Resources.secrets<br>YAMLResources:<br>myCluster:<br>Type: 'AWS::EKS::Cluster'<br>Properties:<br>...<br>EncryptionConfig:<br>- Resources:<br>+         - secrets<br>"
    },
    "CKV_AWS_37": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_kubernetes_4",
        "severity": "LOW",
        "description": "<h4>AWS EKS control plane logging is disabled</h4><h4>Description</h4>Amazon EKS control plane logging provides valuable diagnostic logs for all control plane related actions. Logging streams include cover for the following modules:<br><br>Kubernetes API server component logs (api)\u201a see kube-apiserver in the Kubernetes documentation.<br>Audit (audit). Kubernetes audit logs provide a record of the individual users, administrators, or system components that have affected your cluster. For more information, see Auditing in the Kubernetes documentation.<br>Authenticator (authenticator). For more information, see authorization in the Kubernetes documentation.<br>Controller manager (controllerManager). For more information, see kube-controller-manager in the Kubernetes documentation.<br>Scheduler (scheduler). For more information, see kube-scheduler in the Kubernetes documentation.<br><br>Amazon EKS control plane logging is used to detect anomalous configuration activity by your customer. It is used to track configuration changes conducted manually and programmatically, and trace back unapproved changes.<br><h4>Fix - Runtime</h4>AWS Console<br>To enable Amazon EKS logging, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon EKS console.<br>To display your cluster information, select the cluster's name.<br>Navigate to Logging and click Update.<br>For each individual log stream, select if the log type should be Enabled.<br>Click Update.<br><br><h4>Fix - Buildtime</h4>Terraform<br>The code below enables control plane logging.<br>Resource: aws_eks_cluster<br>Attributes: enabled_cluster_log_types<br>aws_eks_cluster.pike.tfresource \"aws_eks_cluster\" \"pike\" {<br>name_prefix= var.name<br>role_arn = aws_iam_role.pike<br>vpc_config {<br>endpoint_public_access = false<br>subnet_ids = var.subnet_ids<br>}<br><br>tags = {<br>pike=\"permissions\"<br>}<br>encryption_config {<br>resources = [\"secrets\"]<br>}<br>+  enabled_cluster_log_types = [\"api\", \"audit\", \"authenticator\",\"controllerManager\",\"scheduler\"]<br>}<br>"
    },
    "CKV_AWS_50": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_serverless_4",
        "severity": "LOW",
        "description": "<h4>AWS Lambda functions with tracing not enabled</h4><h4>Description</h4>X-Ray tracing in lambda functions allows you to visualize and troubleshoot errors and performance bottlenecks, and investigate requests that resulted in an error.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon Lambda console.<br>Open the function to modify.<br>Click the Configuration tab.<br>Open the Monitoring and operations tools on the left side.<br>Click Edit.<br>Enable Active tracing for AWS X-ray.<br>Click Save.<br><br>CLI Command<br>To enable X-Ray tracing for a function, use the following command:<br>aws lambda update-function-configuration --function-name MY_FUNCTION \\<br>--tracing-config Mode=Active<br><br><h4>Fix - Buildtime</h4>Terraform<br>Add the following block to a Terraform Lambda resource to add X-Ray tracing:<br>Gotracing_config {<br>mode = \"Active\"<br>}<br><br>CloudFormation<br>For CloudFormation, use the following block under Properties:<br>YAML\"TracingConfig\": {<br>\"Mode\": \"Active\"<br>}<br>"
    },
    "CKV_AWS_3": {
        "url": "https://docs.bridgecrew.io/docs/general_3-encrypt-ebs-volume",
        "severity": "HIGH",
        "description": "<h4>AWS EBS volumes are not encrypted</h4><h4>Description</h4>Encrypting EBS volumes ensures that replicated copies of your images are secure even if they are accidentally exposed. AWS EBS encryption uses AWS KMS customer master keys (CMK) when creating encrypted volumes and snapshots. Storing EBS volumes in their encrypted state reduces the risk of data exposure or data loss.<br>We recommend you encrypt all data stored in the EBS.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon EC2 console.<br>From the navigation bar, select Region.<br>From the navigation pane, select EC2 Dashboard.<br>In the upper-right corner of the page, select Account Attributes, then Settings.<br>Under EBS Storage, select Always encrypt new EBS volumes.<br>Click Update.<br><br>CLI Command<br>To always encrypt new EBS volumes, use the following command:<br>Bashaws ec2 --region <REGION> enable-ebs-encryption-by-default<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_ebs_volume<br>Argument: encrypted - (Optional) If true, the disk will be encrypted.<br><br>Goresource \"aws_ebs_volume\" \"example\" {<br>...<br>availability_zone = \"${var.availability_zone}\"<br>+ encrypted         = true<br>...<br>}<br><br>CloudFormation<br><br>Resource: AWS::EC2::Volume<br>Argument: Properties.Encrypted - (Optional) If true, the disk will be encrypted.<br><br>YAMLResources:<br>NewVolume:<br>Type: AWS::EC2::Volume<br>Properties:<br>...<br>+     Encrypted: true<br>"
    },
    "CKV_AWS_16": {
        "url": "https://docs.bridgecrew.io/docs/general_4",
        "severity": "HIGH",
        "description": "<h4>AWS RDS DB cluster encryption is disabled</h4><h4>Description</h4>AWS RDS is a managed DB service enabling quick deployment and management of MySQL, MariaDB, PostgreSQL, Oracle, and Microsoft SQL Server DB engines. Native RDS encryption helps protect your cloud applications and fulfils compliance requirements for data-at-rest encryption.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon RDS console.<br>Click Snapshots.<br>Select the snapshot that you want to encrypt.<br>Navigate to Snapshot Actions, select Copy Snapshot.<br>Select the Destination Region, then enter your New DB Snapshot Identifier.<br>Set Enable Encryption to Yes.<br>Select the Master Key from the list, then select Copy Snapshot.<br><br>CLI Command<br>If you use the create-db-instance AWS CLI command to create an encrypted DB instance, set the --storage-encrypted parameter to true. If you use the CreateDBInstance API operation, set the StorageEncrypted parameter to true.<br>Shellaws rds create-db-instance \\<br>--db-instance-identifier test-mysql-instance \\<br>--db-instance-class db.t3.micro \\<br>--engine mysql \\<br>--master-username admin \\<br>--master-user-password secret99 \\<br>--allocated-storage 20<br>--storage-encrypted true<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_db_instance<br>Argument: storage_encrypted - Specifies whether the DB instance is encrypted.<br><br>aws_db_instanceresource \"aws_db_instance\" \"example\" {<br>...<br>name                 = \"mydb\"<br>+ storage_encrypted    = true<br>}<br><br>CloudFormation<br><br>Resource: AWS::RDS::DBInstance<br>Argument: Properties.StorageEncrypted<br><br>YAMLResources:<br>DB:<br>Type: 'AWS::RDS::DBInstance'<br>Properties:<br>...<br>+     StorageEncrypted: true<br>"
    },
    "CKV_AWS_28": {
        "url": "https://docs.bridgecrew.io/docs/general_6",
        "severity": "HIGH",
        "description": "<h4>DynamoDB PITR is disabled</h4><h4>Description</h4>DynamoDB Point-In-Time Recovery (PITR) is an automatic backup service for DynamoDB table data that helps protect your DynamoDB tables from accidental write or delete operations. Once enabled, PITR provides continuous backups that can be controlled using various programmatic parameters. PITR can also be used to restore table data from any point in time during the last 35 days, as well as any incremental backups of DynamoDB tables.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon DynamoDB console.<br>Navigate to the desired DynamoDB table, then select the Backups tab.<br>To turn the feature on, click Enable.<br>The Earliest restore date and Latest restore date are visible within a few seconds.<br><br>CLI Command<br>To update continuous backup settings for a DynamoDB table:<br>Shellaws dynamodb update-continuous-backups \\<br>--table-name MusicCollection \\<br>--point-in-time-recovery-specification PointInTimeRecoveryEnabled=true<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_dynamodb_table<br>Argument: point_in_time_recovery - (Optional) Point-in-time recovery options.<br><br>Goresource \"aws_dynamodb_table\" \"example\" {<br>...<br>name           = \"GameScores\"<br>+ point_in_time_recovery {<br>+   enabled = true<br>+  }<br>...<br>}<br><br>CloudFormation / Serverless<br><br>Resource: AWS::DynamoDB::Table<br>Property: PointInTimeRecoverySpecification<br><br>YAMLResources:<br>iotCatalog:<br>Type: AWS::DynamoDB::Table<br>Properties:<br>...<br>PointInTimeRecoverySpecification:<br>+         PointInTimeRecoveryEnabled: true<br>"
    },
    "CKV_AWS_CUSTOM_3": {
        "url": "https://docs.bridgecrew.io/docs/general_7",
        "severity": "MEDIUM",
        "description": "<h4>Not all data stored in the EBS snapshot is securely encrypted</h4><h4>Description</h4>EBS snapshots must be encrypted, as they often include sensitive information, customer PII or CPNI.  Amazon EBS encryption uses AWS Key Management Service (AWS KMS) customer master keys (CMK) when creating encrypted volumes and snapshots. With EBS encryption enabled, you no longer have to build, maintain, and secure your own key management infrastructure.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon EC2 console.<br>From the navigation bar, select Region.<br>From the navigation pane, select EC2 Dashboard.<br>In the upper-right corner of the page, click Account Attributes, then EBS encryption.<br>click Manage.<br>For Default encryption key, select a symmetric customer managed CMK.<br>Click Update EBS encryption.<br><br>CLI Command<br>To enable EBS encryption by default:<br>Shellaws ec2 enable-ebs-encryption-by-default<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_ebs_snapshot<br>Argument: encrypted - Whether the snapshot is encrypted.<br>Example fix:<br><br>aws_ebs_snapshotresource \"aws_ebs_snapshot\" \"example\" {<br>volume_id = \"${aws_ebs_volume.example.id}\"<br>+ encrypted = true<br>...<br>}<br>"
    },
    "CKV_AWS_163": {
        "url": "https://docs.bridgecrew.io/docs/general_8",
        "severity": "HIGH",
        "description": "<h4>ECR image scan on push is not enabled</h4><h4>Description</h4>Amazon ECR is a fully managed container registry used to store, manage and deploy container images. ECR Image Scanning assesses and identifies operating system vulnerabilities. Using automated image scans you can ensure container image vulnerabilities are found before getting pushed to production. ECR APIs notify if vulnerabilities were found when a scan completes.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon ECR console.<br>Select a repository using the radio button.<br>Click Edit.<br>Enable the Scan on push toggle.<br><br>CLI Command<br>To create a repository configured for scan on push:<br>Shellaws ecr create-repository<br>--repository-name name<br>--image-scanning-configuration scanOnPush=true<br>--region us-east-2<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_ecr_repository<br>Argument: scan_on_push - (Required) Indicates whether images are scanned after being pushed to the repository (true) or not scanned (false).<br><br>aws_ecr_repository.foo.tfresource \"aws_ecr_repository\" \"example\" {<br>...<br>image_tag_mutability = \"MUTABLE\"<br>+  image_scanning_configuration {<br>+    scan_on_push = true<br>+  }<br>...<br>}<br><br>CloudFormation<br><br>Resource: AWS::ECR::Repository<br>Argument: Properties.ImageScanningConfiguration.ScanOnPush - (Required) Indicates whether images are scanned after being pushed to the repository (true) or not scanned (false).<br><br>YAMLResources:<br>ImageScanTrue:<br>Type: AWS::ECR::Repository<br>Properties:<br>...<br>+     ImageScanningConfiguration:<br>+       ScanOnPush: true<br>"
    },
    "CKV_AWS_29": {
        "url": "https://docs.bridgecrew.io/docs/general_9",
        "severity": "MEDIUM",
        "description": "<h4>AWS ElastiCache Redis cluster with encryption for data at rest is disabled</h4><h4>Description</h4>ElastiCache for Redis offers default encryption at rest as a service, as well as the ability to use your own symmetric customer-managed customer master keys in AWS Key Management Service (KMS).<br>ElastiCache for Redis at-rest encryption encrypts the following aspects:<br><br>Disk during sync, backup and swap operations<br>Backups stored in Amazon S3<br><br><h4>Fix - Runtime</h4>ElastiCache Console<br>To create a replication group using the ElastiCache console, make the following selections:<br><br>Engine: redis.<br>Engine version: 3.2.6, 4.0.10 or later.<br>Encryption at-rest list: Yes.<br><br>CLI Command<br>The following operation creates the Redis (cluster mode disabled) replication group my-classic-rg with three nodes (--num-cache-clusters), a primary and two read replicas. At-rest encryption is enabled for this replication group (--at-rest-encryption-enabled).<br>Shellaws elasticache create-replication-group \\<br>--replication-group-id my-classic-rg \\<br>--replication-group-description \"3 node replication group\" \\<br>--cache-node-type cache.m4.large \\<br>--engine redis \\<br>--engine-version 4.0.10 \\<br>--at-rest-encryption-enabled \\<br>--num-cache-clusters 3 \\<br>--cache-parameter-group default.redis4.0<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_elasticache_replication_group<br>Argument: at_rest_encryption_enabled - (Optional) Whether to enable encryption at rest.<br><br>Goresource \"aws_elasticache_replication_group\" \"default\"{<br>...<br>replication_group_id          = \"default-1\"<br>+ at_rest_encryption_enabled    = true<br>...<br>}<br><br>CloudFormation<br><br>Resource: AWS::ElastiCache::ReplicationGroup<br>Argument: AtRestEncryptionEnabled<br><br>YAMLResources:<br>ReplicationGroup:<br>Type: 'AWS::ElastiCache::ReplicationGroup'<br>Properties:<br>...<br>+     AtRestEncryptionEnabled: True<br>"
    },
    "CKV_AWS_30": {
        "url": "https://docs.bridgecrew.io/docs/general_10",
        "severity": "MEDIUM",
        "description": "<h4>AWS ElastiCache Redis cluster with in-transit encryption is disabled</h4><h4>Description</h4>ElastiCache for Redis offers optional encryption in transit. In-transit encryption provides an additional layer of data protection when transferring data over standard HTTPS protocol. In-transit encryption can only be enabled on Redis replication groups at time of their creation.<br>ElastiCache for Redis in-transit encryption enables the following features:<br><br>Encrypted connections: server and client connections are Secure Socket Layer (SSL) encrypted.<br>Encrypted replication: data transfer between primary replicas is encrypted.<br>Server authentication.<br>Client authentication.<br><br><h4>Fix - Runtime</h4>ElastiCache Console<br>To create a replication group using the ElastiCache console, make the following selections:<br><br>Engine: redis.<br>Engine version: 3.2.6, 4.0.10 or later.<br>Encryption in-transit list: Yes.<br><br>CLI command<br>The parameters TransitEncryptionEnabled (CLI: --transit-encryption-enabled) are only available when using the CreateReplicationGroup (CLI: create-replication-group) operation.<br>Shellaws elasticache create-replication-group ^<br>--replication-group-id sample-repl-group ^<br>--replication-group-description \"Demo cluster with replicas\" ^<br>--num-cache-clusters 3 ^<br>--cache-node-type cache.m4.large ^<br>--cache-parameter-group default.redis3.2 ^<br>--engine redis ^<br>--engine-version 3.2.4<br>--transit-encryption-enabled<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_elasticache_replication_group<br>Argument: transit_encryption_enabled - (Optional) Whether to enable encryption in transit.<br><br>Goresource \"aws_elasticache_replication_group\" \"example\"{<br>...<br>replication_group_id          = \"default-1\"<br>+ transit_encryption_enabled    = true<br>...<br>}<br><br>CloudFormation<br><br>Resource: AWS::ElastiCache::ReplicationGroup<br>Argument: Properties.TransitEncryptionEnabled - (Optional) Whether to enable encryption in transit.<br><br>YAMLResources:<br>ReplicationGroup:<br>Type: 'AWS::ElastiCache::ReplicationGroup'<br>Properties:<br>...<br>+     TransitEncryptionEnabled: True<br>"
    },
    "CKV_AWS_31": {
        "url": "https://docs.bridgecrew.io/docs/general_11",
        "severity": "MEDIUM",
        "description": "<h4>Data stored in the ElastiCache Replication Group is not securely encrypted in-transit</h4><h4>Description</h4>In Amazon ElastiCache, the Redis authentication command asks users to enter a password prior to being granted permission to execute Redis commands on a password-protected server. Authentication can only be enabled when you are creating clusters with the in-transit encryption option enabled. When Redis authentication is enabled, users are required to pass through an additional layer of authentication before gaining access to the server and gaining permission to perform actions.<br>We recommend that all data stored in the ElastiCache Replication Group is securely encrypted in-transit with an authentication token.<br><h4>Fix - Runtime</h4>Procedure<br>To authenticate a user using Redis AUTH create a new Redis Cluster with the following parameters enabled:<br><br>transit-encryption-enabled<br>auth-token.<br><br>CLI Command<br>The following AWS CLI operation modifies a replication group to rotate the AUTH token This-is-the-rotated-token.<br>Shellaws elasticache modify-replication-group \\<br>--replication-group-id authtestgroup \\<br>--auth-token This-is-the-rotated-token \\<br>--auth-token-update-strategy ROTATE \\<br>--apply-immediately<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_elasticache_replication_group<br>Argument: auth_token - (Optional) The password used to access a password protected server. Can be specified only if transit_encryption_enabled = true<br><br>Goresource \"aws_elasticache_replication_group\" \"example\" {<br>...<br>at_rest_encryption_enabled    = true<br>+ auth_token                    = var.auth_token<br>+ transit_encryption_enabled    = true<br>...<br>}<br><br>CloudFormation<br><br>Resource: AWS::ElastiCache::ReplicationGroup<br>Argument: AuthToken - (Optional) The password used to access a password protected server. Can be specified only if TransitEncryptionEnabled = true<br><br>YAMLResources:<br>ReplicationGroup:<br>Type: 'AWS::ElastiCache::ReplicationGroup'<br>Properties:<br>...<br>+     AuthToken: 'MySecret!AuthToken$'<br>+     TransitEncryptionEnabled: True<br>"
    },
    "CKV_AWS_8": {
        "url": "https://docs.bridgecrew.io/docs/general_13",
        "severity": "HIGH",
        "description": "<h4>Launch configurations do not have encrypted EBS volumes</h4><h4>Description</h4>Amazon Elastic Block Store (EBS) volumes allow you to create encrypted launch configurations when creating EC2 instances and auto scaling. When the entire EBS volume is encrypted, data stored at rest on the volume, disk I/O, snapshots created from the volume, and data in-transit between EBS and EC2 are all encrypted.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon EC2 console.<br>Navigate to Auto Scaling.<br>Create a new launch configuration.<br>Add an encrypted EBS volume (Add Storage).<br><br>CLI Command<br>Shellaws autoscaling create-launch-configuration<br>--launch-configuration-name my-launch-config<br>--image-id ami-c6169af6<br>--instance-type m1.medium<br>--encrypted true<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_launch_configuration<br>Attribute: encrypted - (Optional) Whether the volume should be encrypted or not. Do not use this option if you are using snapshot_id as the encrypted flag will be determined by the snapshot. (Default: false).<br><br>Goresource \"aws_launch_configuration\" \"example\" {<br>...<br>instance_type = \"t2.micro\"<br>+ root_block_device {<br>+ encrypted     = true<br>+ }<br>...<br>}<br><br>CloudFormation<br><br>Resource: AWS::AutoScaling::LaunchConfiguration<br>Attribute: Properties.BlockDeviceMappings<br><br>YAMLAutoScalingConfig:<br>Type: AWS::AutoScaling::LaunchConfiguration<br>Properties:<br>...<br>BlockDeviceMappings:<br>- DeviceName: \"/dev/sdk\"<br>+       Ebs:<br>...<br>+         Encrypted: true<br>- DeviceName: \"/dev/sdf\"<br>Ebs:<br>...<br>-         Encrypted: false<br>- DeviceName: \"/dev/sdc\"<br>-       VirtualName: ephermal<br>"
    },
    "CKV_AWS_22": {
        "url": "https://docs.bridgecrew.io/docs/general_14",
        "severity": "HIGH",
        "description": "<h4>Data stored in SageMaker is not securely encrypted at rest</h4><h4>Description</h4>Amazon SageMaker enables you to pass a KMS key to SageMaker notebooks, securing the following resources:<br><br>Storage volume<br>Processing jobs<br>Training jobs<br>Hyperparameter tuning jobs<br>Batch transform jobs<br>Endpoints<br><br>By applying encryption at-rest you ensure that the data stored on your AWS SageMaker notebook instances meet regulatory requirements and protect your SageMaker data at rest.<br><h4>Fix - Runtime</h4>AWS Console<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon SageMaker console.<br>Select Notebook instances, then click Create Notebook Instance.<br>On the Create Notebook Instance page, provide the required information.<br>The Encryption key lets you encrypt data on the ML storage volume attached to the notebook instance using an AWS Key Management Service (AWS KMS) key. If you plan to store sensitive information on the ML storage volume, consider encrypting the information.<br><br>CLI Command<br>To create a SageMaker notebook instance:<br>Shellcreate-notebook-instance<br>--notebook-instance-name <value><br>--instance-type <value><br>--kms-key-id <value><br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_sagemaker_notebook_instance<br>Attribute: kms_key_id - (Optional) The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.<br><br>Goresource \"aws_sagemaker_notebook_instance\" \"example\" {<br>...<br>name          = \"my-notebook-instance\"<br>+ kms_key_id    = <value><br>...<br>}<br>"
    },
    "CKV_AWS_26": {
        "url": "https://docs.bridgecrew.io/docs/general_15",
        "severity": "MEDIUM",
        "description": "<h4>AWS SNS topic has SSE disabled</h4><h4>Description</h4>Amazon SNS is a publishers and subscribers messaging service. When you publish messages to encrypted topics, customer master keys (CMK), powered by AWS KMS, can be used to encrypt your messages.<br>If you operate in a regulated market, such as HIPAA for healthcare, PCI DSS for finance, or FedRAMP for government, you need to ensure sensitive data messages passed in this service are encrypted at rest.<br><h4>Fix - Runtime</h4>SNS Console<br><br>Navigate to the SNS console in AWS and select Topics on the left.<br>Open a topic.<br>In the top-right corner, click Edit.<br>Under Encryption, select Enable encryption.<br>Select a customer master key - you can use the default AWS key or a custom key in KMS.<br><br>CLI Command<br>aws sns set-topic-attributes<br>--topic-arn <TOPIC_ARN><br>--attribute-name \"KmsMasterKeyId\"<br>--attribute-value <KEY><br><br>The ARN format is arn:aws:sns:REGION:ACCOUNTID:TOPIC_NAME<br>The key is a reference to a KMS key or alias. Use alias/aws/sns for the default AWS key.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_sns_topic<br>Argument: kms_master_key_id - (Optional) The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a custom CMK.<br><br>Goresource \"aws_sns_topic\" \"example\" {<br>...<br>name              = \"user-updates-topic\"<br>+ kms_master_key_id = \"alias/aws/sns\"<br>}<br><br>CloudFormation<br><br>Resource: AWS::SNS::Topic<br>Argument: Properties.KmsMasterKeyId<br><br>YAMLType: AWS::SNS::Topic<br>Properties:<br>...<br>+     KmsMasterKeyId: \"kms_id\"<br>"
    },
    "CKV_AWS_27": {
        "url": "https://docs.bridgecrew.io/docs/general_16-encrypt-sqs-queue",
        "severity": "MEDIUM",
        "description": "<h4>AWS SQS server side encryption is not enabled</h4><h4>Description</h4>Amazon Simple Queue Service (SQS) provides the ability to encrypt queues so sensitive data is passed securely. It uses server-side-encrypyion (SSE) and supports AWS-managed Customer Master Key (CMK), as well as self-created/self-managed keys. SSE encrypts only the body of the message, with queue metadata and message metadata out of scope, and backlogged messages not encrypted.<br>If you operate in a regulated market, such as HIPAA for healthcare, PCI DSS for finance, or FedRAMP for government, you need to ensure sensitive data messages passed in this service are encrypted at rest.<br>We recommend you encrypt Data Queued using SQS.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon SQS console.<br>Open a Queue and click Edit at the top right.<br>Expand Encryption and select Enabled.<br>Select or enter a CMK key, or use the default provided by AWS.<br><br>CLI Command<br>aws sqs set-queue-attributes --queue-url <QUEUE_URL> --attributes KmsMasterKeyId=<KEY><br><br>The format of the queue URL is https://sqs.REGION.amazonaws.com/ACCOUNT_ID/QUEUE_NAME<br>The key should be a KMS key or alias. The default AWS key is alias/aws/sqs.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_sqs_queue<br>Arguments:<br>kms_master_key_id - (Optional) The ID of an AWS-managed customer master key (CMK) for Amazon SQS or a custom CMK.<br>kms_data_key_reuse_period_seconds - (Optional) The length of time, in seconds, for which Amazon SQS can reuse a data key to encrypt or decrypt messages before calling AWS KMS again. An integer representing seconds, between 60 seconds (1 minute) and 86,400 seconds (24 hours). The default is 300 (5 minutes).<br><br>aws_sqs_queue.terraform_queue.tfresource \"aws_sqs_queue\" \"example\" {<br>name                              = \"terraform-example-queue\"<br>+ kms_master_key_id                 = \"alias/aws/sqs\"<br>+ kms_data_key_reuse_period_seconds = 300<br>...<br>}<br><br>CloudFormation<br><br>Resource: AWS::SQS::Queue<br>Arguments: Properties.KmsMasterKeyId<br><br>YAMLType: AWS::SQS::Queue<br>Properties:<br>...<br>+     KmsMasterKeyId: \"kms_id\"<br>"
    },
    "CKV_AWS_44": {
        "url": "https://docs.bridgecrew.io/docs/general_18",
        "severity": "MEDIUM",
        "description": "<h4>Neptune storage is not securely encrypted</h4><h4>Description</h4>Amazon Neptune is a fully managed graph database service for building and running applications that work with connected datasets. Neptune supports graph query languages such as Apache TinkerPop Gremlin and W3C\u2019s SPARQL.  Neptune also supports recommendation engines, fraud detection, knowledge graphs, drug discovery, and network security.<br>Encryption of Neptune storage protects data and metadata against unauthorized access. It also fulfils compliance requirements for data-at-rest encryption of production file systems. Encryption for an existing database cannot be added or changed after it is created.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon Neptune console.<br>To start the Launch DB instance wizard, click Launch DB Instance.<br>To customize the settings for your Neptune DB cluster, navigate to the Specify DB details page.<br>To enable encryption for a new Neptune DB instance, navigate to the Enable encryption section on the Neptune console and click Yes.<br><br>CLI Command<br>To creates a new Amazon Neptune DB cluster:<br>Shellcreate-db-cluster<br>--db-cluster-identifier <value><br>--engine <value><br>--storage-encrypted true<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_neptune_cluster<br>Arguments: storage_encrypted - (Optional) Specifies whether the Neptune cluster is encrypted. The default is false if not specified.<br><br>aws_neptune_clusterresource \"aws_neptune_cluster\" \"example\" {<br>...<br>cluster_identifier                  = \"neptune-cluster-demo\"<br>+ storage_encrypted                   = true<br>...<br>}<br><br>CloudFormation<br><br>Resource: AWS::Neptune::DBCluster<br>Arguments: Proprties.StorageEncrypted<br><br>YAMLType: \"AWS::Neptune::DBCluster\"<br>Properties:<br>...<br>+     StorageEncrypted: true<br>"
    },
    "CKV_AWS_43": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_22",
        "severity": "MEDIUM",
        "description": "<h4>AWS Kinesis streams are not encrypted using SSE</h4><h4>Description</h4>Amazon Kinesis Data Firehose is a streaming data pipeline service that can route messages to destinations such as S3, Redshift Elasticsearch and others. It can also be used to transform data properties before streaming to a defined destination.<br>Kinesis enables server-side data encryption if the data stream contains sensitive information. When sending data from a producer to a data stream Kinesis encrypts the data using an AWS KMS key before storing the data at rest.<br>We recommend you ensure Kinesis streams are encrypted using server-side encryption (SSE).<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Select Services  and search for Kinesis.<br>Under the Amazon Kinesis dashboard select Data Firehose from the left navigation panel.<br>Select the Firehose Delivery System that needs to be verified and click on the Name to access the delivery stream.<br>Select the Details tab and scroll down to Amazon S3 destination. Check the Encryption value and if it's set to Disabled then the selected Firehose Delivery System data is not encrypted.<br>Repeat steps 4 and 5 to verify another Firehose Delivery System.<br>To enable the Encryption on selected Firehose Delivery System click on the Name to access the delivery stream. Under the Details tab, click Edit to make the changes in Amazon S3 destination.<br>Click Enable next to the S3 encryption to enable the encryption.<br>Select the KMS master key from the dropdown list. Select the (Default( aws/s3 )) KMS key or an AWS KMS Customer Master Key (CMK).<br>Click Save .<br>A Successfully Updated message appears.<br><br>CLI Command<br>Enables or updates server-side encryption using an AWS KMS key for a specified stream.<br>Shellaws kinesis start-stream-encryption \\<br>--encryption-type KMS \\<br>--key-id arn:aws:kms:us-west-2:012345678912:key/a3c4a7cd-728b-45dd-b334-4d3eb496e452 \\<br>--stream-name samplestream<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_kinesis_stream<br>Arguments:<br>encryption_type - (Optional) The encryption type to use. The only acceptable values are NONE or KMS. The default value is NONE.<br>kms_key_id - (Optional) The GUID for the customer-managed KMS key to use for encryption. You can also use a Kinesis-owned master key by specifying the alias alias/aws/kinesis.<br><br>Goresource \"aws_kinesis_stream\" \"test_stream\" {<br>...<br>name             = \"terraform-kinesis-test\"<br>+ encryption_type = KMS<br>+ kms_key_id = <value><br>...<br>}<br><br>CloudFormation<br><br>Resource: AWS::Kinesis::Stream<br>Arguments: Properties.StreamEncryption.EncryptionType<br><br>YAMLResources:<br>KMSEncryption:<br>Type: AWS::Kinesis::Stream<br>Properties:<br>...<br>StreamEncryption:<br>...<br>EncryptionType: KMS<br>"
    },
    "CKV_AWS_47": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_23",
        "severity": "HIGH",
        "description": "<h4>DAX is not securely encrypted at rest</h4><h4>Description</h4>Amazon DynamoDB Accelerator (DAX) encryption at rest provides an additional layer of data protection, helping secure your data from unauthorized access to underlying storage.<br>With encryption at rest the data persisted by DAX on disk is encrypted using 256-bit Advanced Encryption Standard (AES-256). DAX writes data to disk as part of propagating changes from the primary node to read replicas. DAX encryption at rest automatically integrates with AWS KMS for managing the single service default key used to encrypt clusters.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon DynamoDB console.<br>In the navigation pane on the left side of the console, under DAX, select Clusters.<br>Click Create Cluster.<br>For Cluster name, enter a short name for your cluster. Select the node type for all of the nodes in the cluster, and for the cluster size, use 3 nodes.<br>In Encryption, make sure that Enable encryption is selected.<br>7 After selecting the IAM role, subnet group, security groups, and cluster settings, select Launch cluster.<br><br>CLI Command<br>To creates a DAX cluster:<br>Shellaws dax create-cluster \\<br>--cluster-name daxcluster \\<br>--node-type dax.r4.large \\<br>--replication-factor 3 \\<br>--iam-role-arn roleARN  \\<br>--sse-specification Enabled=true<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_dax_cluster<br>Arguments: server_side_encryption - (Optional) Encrypt at rest options, enabled/disabled.<br><br>Goresource \"aws_dax_cluster\" \"example\" {<br>...<br>cluster_name       = \"cluster-example\"<br>+ server_side_encryption = enabled<br>...<br>}<br><br>CloudFormation<br><br>Resource: AWS::DAX::Cluster<br>Arguments: Properties.SSESpecification.SSEEnabled - (Optional) Encrypt at rest options, enabled/disabled.<br><br>YAMLResources:<br>daxCluster:<br>Type: AWS::DAX::Cluster<br>Properties:<br>...<br>+     SSESpecification:<br>+       SSEEnabled: true<br>"
    },
    "CKV_AWS_51": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_24",
        "severity": "LOW",
        "description": "<h4>ECR image tags are not immutable</h4><h4>Description</h4>Amazon ECR supports immutable tags, preventing image tags from being overwritten. In the past, ECR tags could have been overwritten, this could be overcome by requiring users to uniquely identify an image using a naming convention.<br>Tag Immutability enables users can rely on the descriptive tags of an image as a mechanism to track and uniquely identify images. By setting an image tag as immutable, developers can use the tag to correlate the deployed image version with the build that produced the image.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon ECR console.<br>Select a repository using the radio button.<br>Click Edit.<br>Enable the Tag immutability toggle.<br><br>CLI Command<br>To create a repository with immutable tags configured:<br>Shellaws ecr create-repository<br>--repository-name name<br>--image-tag-mutability IMMUTABLE<br>--region us-east-2<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_ecr_repository<br>Arguments: image_tag_mutability - (Optional) The tag mutability setting for the repository. Must be one of: MUTABLE or IMMUTABLE. Defaults to MUTABLE.<br><br>Goresource \"aws_ecr_repository\" \"example\" {<br>...<br>name                 = \"bar\"<br>+ image_tag_mutability = \"IMMUTABLE\"<br>}<br><br>CloudFormation<br><br>Resource: AWS::ECR::Repository<br>Arguments: Properties.ImageTagMutability - (Optional) The tag mutability setting for the repository. Must be one of: MUTABLE or IMMUTABLE. Defaults to MUTABLE.<br><br>YAMLResources:<br>MyRepository:<br>Type: AWS::ECR::Repository<br>Properties:<br>...<br>+     ImageTagMutability: \"IMMUTABLE\"<br>"
    },
    "CKV_AWS_64": {
        "url": "https://docs.bridgecrew.io/docs/general_25",
        "severity": "HIGH",
        "description": "<h4>AWS Redshift cluster not encrypted</h4><h4>Description</h4>We recommend all data stored in the Redshift cluster is securely encrypted at rest, you can create new encrypted clusters or enable CMK encryption on existing clusters, as AWS says \"You can enable encryption when you launch your cluster, or you can modify an unencrypted cluster to use AWS Key Management Service (AWS KMS) encryption\"<br>https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource:  aws_redshift_cluster<br>Argument: encrypted, ensure that this argument is set to true to protect this database.<br><br>This change may recreate your cluster.<br>aws_redshift_cluster.redshift.tfresource \"aws_redshift_cluster\" \"redshift\" {<br>...<br>cluster_identifier        = \"shifty\"<br>+ encrypted                 = true<br>kms_key_id                = var.kms_key_id<br>...<br>}<br><br>CloudFormation<br><br>Resource:  AWS::Redshift::Cluster<br>Argument: Properties.Encrypted<br><br>YAMLType: \"AWS::Redshift::Cluster\"<br>Properties:<br>...<br>+     Encrypted: true<br>"
    },
    "CKV_AWS_71": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_logging_12",
        "severity": "MEDIUM",
        "description": "<h4>AWS Redshift database does not have audit logging enabled</h4><h4>Description</h4>Amazon Redshift logs information about connections and user activities in your database. These logs help you to monitor the database for security and troubleshooting purposes, a process often referred to as database auditing. The logs are stored in Amazon S3 buckets. These provide convenient access with data security features for users who are responsible for monitoring activities in the database.<br>Enabling S3 bucket logging on Redshift databases allows you to capture all events which may affect the database, this is useful in security and incident response workflows.<br><h4>Fix - Runtime</h4>AWS Console<br>To enable Redshift to S3 bucket logging using the AWS Management Console, follow these steps:<br><br>Log in to the AWS Management Console at [https://console.aws.amazon.com/].<br>Open the Amazon Redshift console.<br>On the navigation menu, choose Clusters, then choose the cluster that you want to update.<br>Choose the Maintenance and Monitoring tab. Then view the Audit logging section.<br>Choose Edit tab.<br>On the Configure audit logging page, choose to Enable audit logging and enter your choices regarding where the logs are stored.<br>Click Confirm.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_redshift_cluster<br>Argument: logging/enable is set to true.<br>An example terraform definition of an Amazon Redshift database with logging enabled, resolving the violation:<br><br>Goresource \"aws_redshift_cluster\" \"default\" {<br>...<br>cluster_type       = \"single-node\"<br>+   logging {<br>+     enable = \"true\"<br>+   }<br>}<br><br>CloudFormation<br><br>Resource: AWS::Redshift::Cluster<br>Argument: Properties.BucketName<br><br>YAMLType: \"AWS::Redshift::Cluster\"<br>Properties:<br>...<br>+     LoggingProperties:<br>+       BucketName: \"your_bucket\"<br>"
    },
    "CKV_AWS_5": {
        "url": "https://docs.bridgecrew.io/docs/elasticsearch_3-enable-encryptionatrest",
        "severity": "LOW",
        "description": "<h4>AWS Elasticsearch domain encryption for data at rest is disabled</h4><h4>Description</h4>Encryption of data at rest is a security feature that helps prevent unauthorized access to your data. The feature uses AWS Key Management Service (AWS KMS) to store and manage your encryption keys and the Advanced Encryption Standard algorithm with 256-bit keys (AES-256) to perform the encryption. If enabled, the feature encrypts the domain's: indices, logs, swap files, all data in the application directory, and automated snapshots.<br>We recommend you implement encryption at rest in order to protect a data store containing sensitive information from unauthorized access, and fulfill compliance requirements.<br><h4>Fix - Runtime</h4>Procedure<br>By default, domains do not encrypt data at rest, and you cannot configure existing domains to use EncryptionAtRest.<br>To enable EncryptionAtRest, you must create a new domain and migrate Elasticsearch to that domain. You will also need, at minimum, read-only permissions to AWS KMS.<br>To create a new domain sign in to your AWS Console and select the Elasticsearch service (under Analytics), follow these steps:<br><br>Select Create a new domain.<br>Change the default Encryption setting to enabled.<br>Continue configuring your cluster.<br><br><h4>Fix - Buildtime</h4>CloudFormation<br>Resource: AWS::Elasticsearch::Domain<br>Argument: Properties.EncryptionAtRestOptions.Enabled<br>YAMLResources:<br>ElasticsearchDomain:<br>Type: AWS::Elasticsearch::Domain<br>Properties:<br>...<br>EncryptionAtRestOptions:<br>+       Enabled: True<br>"
    },
    "CKV_AWS_6": {
        "url": "https://docs.bridgecrew.io/docs/elasticsearch_5",
        "severity": "MEDIUM",
        "description": "<h4>AWS Elasticsearch does not have node-to-node encryption enabled</h4><h4>Description</h4>The AWS Elasticsearch Service makes it possible to host sensitive workloads with node-to-node encryption by using Transport Layer Security (TLS) for all communications between instances in a cluster.<br>Using node-to-node encryption ensures that any data you send to your Amazon Elasticsearch Service domain over HTTPS, remains encrypted in-flight while it is being distributed and replicated between the nodes.<br><h4>Fix - Runtime</h4>AWS Console<br>To enable the feature, you must create another domain and migrate your data.<br>Using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Navigate to the Analytics section, select Elasticsearch Service.<br>To enable node-to-node encryption when you configure a new cluster, select Node-to-node encryption.<br><br><h4>Fix - Buildtime</h4>CloudFormation<br>Resources: AWS::Elasticsearch::Domain<br>Argument: Properties.NodeToNodeEncryptionOptions.Enabled<br>YAMLResources:<br>ElasticsearchDomain:<br>Type: AWS::Elasticsearch::Domain<br>Properties:<br>...<br>NodeToNodeEncryptionOptions:<br>+       Enabled: True<br>"
    },
    "CKV_AWS_83": {
        "url": "https://docs.bridgecrew.io/docs/elasticsearch_6",
        "severity": "MEDIUM",
        "description": "<h4>AWS Elasticsearch domains do not have EnforceHTTPS enabled</h4><h4>Description</h4>Amazon Elasticsearch Service (Amazon ES) allows you to build applications without setting up and maintaining your own search celuster on Amazon EC2. Amazon ES allows you to configure your domains to require that all traffic be submitted over HTTPS. This ensures communications between your clients and your domain are encrypted.<br>We recommend you configure the minimum required TLS version to accept. This option is a useful additional security control to ensure your clients are not misconfigured.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon Elasticsearch console.<br>Open a domain.<br>Select Actions > Modify encryptions<br>Select Require HTTPS for all traffic to the domain.<br>Click Submit.<br><br><h4>Fix - Buildtime</h4>CloudFormation<br>Resource: AWS::Elasticsearch::Domain<br>Argument: Properties.DomainEndpointOptions.EnforceHTTPS<br>YAMLResources:<br>Resource0:<br>Type: 'AWS::Elasticsearch::Domain'<br>Properties:<br>...<br>DomainEndpointOptions:<br>+       EnforceHTTPS: True<br>"
    },
    "CKV_AWS_53": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_s3_19",
        "severity": "MEDIUM",
        "description": "<h4>S3 bucket has block public ACLS disabled</h4><h4>Description</h4>Amazon S3 buckets and objects are configured to be private. They are protected by default, with the option to use Access Control Lists (ACLs) and bucket policies to grant access to other AWS accounts and to anonymous public requests. The Block public access to buckets and objects granted through new access control lists (ACLs) option does not allow the use of new public bucket or object ACLs, ensuring  future PUT requests that include them will fail.<br>This setting helps protect against future attempts to use ACLs to make buckets or objects public. When an application tries to upload an object with a public ACL this setting will be blocked for public access.<br>We recommend you set S3 Bucket BlockPublicAcls to True.<br><h4>Fix - Buildtime</h4>Terraform<br>Resource: aws_s3_bucket_public_access_block<br>Argument: block_public_acls<br>aws_s3_bucket_public_access_block.artifacts.tfresource \"aws_s3_bucket_public_access_block\" \"artifacts\" {<br>count  = var.bucketname == \"\" ? 1 : 0<br>bucket = aws_s3_bucket.artifacts[0].id<br><br>+ block_public_acls   = true<br>block_public_policy = true<br>restrict_public_buckets = true<br>ignore_public_acls=true<br>}<br>"
    },
    "CKV_AWS_54": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_s3_20",
        "severity": "MEDIUM",
        "description": "<h4>S3 bucket BlockPublicPolicy is not set to True</h4><h4>Description</h4>Amazon S3 Block Public Access policy works at the account level and on individual buckets, including those created in the future. It provides the ability to block existing public access, whether specified by an ACL or a policy, and ensures public access is not granted to newly created items.<br>If an AWS account is used to host a data lake or another business application, blocking public access will serve as an account-level guard against accidental public exposure.<br><h4>Fix - Buildtime</h4>Terraform<br>Resource: aws_s3_bucket_public_access_block<br>Argument: block_public_policy<br>aws_s3_bucket_public_access_block.artifacts.tfresource \"aws_s3_bucket_public_access_block\" \"artifacts\" {<br>count  = var.bucketname == \"\" ? 1 : 0<br>bucket = aws_s3_bucket.artifacts[0].id<br><br>block_public_acls   = true<br>+ block_public_policy = true<br>restrict_public_buckets = true<br>ignore_public_acls=true<br>}<br>"
    },
    "CKV_AWS_55": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_s3_21",
        "severity": "MEDIUM",
        "description": "<h4>S3 bucket IgnorePublicAcls is not set to True</h4><h4>Description</h4>The IgnorePublicAcls setting causes S3 to ignore all public ACLs on a bucket and any objects that it contains.  Enabling this setting does not affect the persistence of any existing ACLs and does not prevent new public ACLs from being set.<br>This setting will block public access granted by ACLs while still allowing PUT Object calls that include a public ACL.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_s3_bucket_public_access_block<br>Argument: ignore_public_acls<br><br>aws_s3_bucket_public_access_block.artifacts.tfresource \"aws_s3_bucket_public_access_block\" \"artifacts\" {<br>...<br>restrict_public_buckets = true<br>+ ignore_public_acls=true<br>}<br><br>CloudFormation<br><br>Resource: AWS::S3::Bucket<br>Argument: Properties.PublicAccessBlockConfiguration.IgnorePublicAcls<br><br>YAMLType: 'AWS::S3::Bucket'<br>Properties:<br>...<br>PublicAccessBlockConfiguration:<br>...<br>+       IgnorePublicAcls: true<br>"
    },
    "CKV_AWS_56": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_s3_22",
        "severity": "MEDIUM",
        "description": "<h4>S3 bucket RestrictPublicBucket is not set to True</h4><h4>Description</h4>The S3 Block Public Access configuration enables specifying whether S3 should restrict public bucket policies for buckets in this account. Setting  RestrictPublicBucket to TRUE restricts access to buckets with public policies to only AWS services and authorized users within this account.<br>Enabling this setting does not affect previously stored bucket policies.  Public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_s3_bucket_public_access_block<br>Argument: restrict_public_buckets<br><br>aws_s3_bucket_public_access_block.artifacts.tfresource \"aws_s3_bucket_public_access_block\" \"artifacts\" {<br>...<br>+ restrict_public_buckets = true<br>}<br><br>CloudFormation<br><br>Resource: AWS::S3::Bucket<br>Argument: Properties.PublicAccessBlockConfiguration.RestrictPublicBuckets<br><br>YAMLType: 'AWS::S3::Bucket'<br>Properties:<br>...<br>PublicAccessBlockConfiguration:<br>...<br>+       RestrictPublicBuckets: true<br>"
    },
    "CKV_AWS_70": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_s3_23",
        "severity": "CRITICAL",
        "description": "<h4>S3 bucket allows an action with any Principal</h4><h4>Description</h4>The Principal element specifies the user, account, service, or other entity that is allowed or denied access to a resource. In Amazon S3, a Principal is the account or user who is allowed access to the actions and resources in the statement. When added to a bucket policy, the principal is the user, account, service, or other entity that is the recipient of this permission.<br>When you set the wildcard (\"*\") as the Principal value you essentially grant permission to everyone. This is referred to as anonymous access. The following statements are all considered Anonymous Permissions.<br>Shell## Example 1<br>\"Principal\":\"*\"<br><br>## Example 2<br>\"Principal\":{\"AWS\":\"*\"}<br><br>## Example 2<br>\"Principal\":{\"AWS\":[\"*\", ...]}<br><br>When you grant anonymous access, anyone in the world can access your bucket. It is highly recommend to never grant any kind of anonymous write access to your S3 bucket.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon S3 console.<br>Select the Permissions tab, then select Bucket Policy.<br>Remove policies for s3:List actions for principals ''. If necessary, modify the policy instead, to limit the access to specific principals.<br><br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_s3_bucket\" \"bucket\" {<br>bucket = \"bucket\"<br><br>policy = <<POLICY<br>{<br>\"Id\": \"Policy1597273448050\",<br>\"Version\": \"2012-10-17\",<br>\"Statement\": [<br>{<br>\"Action\": [<br>\"s3:GetObject\"<br>],<br>\"Effect\": \"Allow\",<br>\"Resource\": \"arn:aws:s3:::bucket/*\",<br>-           \"Principal\": \"*\"<br>},<br>...<br>"
    },
    "CKV_AWS_46": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_secrets_1",
        "severity": "HIGH",
        "description": "<h4>EC2 user data exposes secrets</h4><h4>Description</h4>User Data is a metadata field of an EC2 instance that allows custom code to run after the instance is launched. It contains code exposed to any entity which has the most basic access to EC2, even read-only configurations. This code is not encrypted.<br>Removing secrets from easily-accessed unencrypted places reduces the risk of passwords, private keys and more from being exposed to third parties.<br><h4>Fix - Runtime</h4>CLI Command<br>To see the secret, run the following CLI command:<br>Bashaws ec2 describe-instance-attribute<br>--attribute userData<br>--region <REGION><br>--instance-id <INSTANCE_ID><br>--query UserData.Value<br>--output text > encodeddata; base64<br>--decode encodeddata<br><br><h4>Fix - Buildtime</h4>Terraform<br>Resource: aws_instance<br>Argument: user_data<br>In this case, the analysis has found a likely AWS secret being used in your user_data. Remove these secrets, substitute with dynamic (i.e. Obtain from Vault) or use instance profiles.<br>aws_instance.web.tfresource \"aws_instance\" \"web\" {<br>...<br>instance_type = \"t3.micro\"<br>-    user_data = \"access_key=123456ABCDEFGHIJZTLA and secret_key=AAAaa+Aa4AAaAA6aAkA0Ad+Aa8aA1aaaAAAaAaA\"<br>}<br><br>CloudFormation<br>Resource: AWS::EC2::Instance<br>Argument: Properties.UserData<br>YAMLResources:<br>Instance:<br>Type: AWS::EC2::Instance<br>Properties:<br>...<br>-     UserData: \"...\"<br>"
    },
    "CKV_AWS_45": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_secrets_3",
        "severity": "HIGH",
        "description": "<h4>Lambda function's environment variables expose secrets</h4><h4>Description</h4>A function's metadata includes environment variable fields that contain small configurations that help the function execute. These variables can be accessed by any entity with the most basic read-metadata-only permissions, and cannot be encrypted. Lambda runtime makes environment variables available without passing secrets in code or environment variables.<br>We recommend you remove secrets from unencrypted places, especially if they can be easily accessed, to reduce the risk of exposing data to third parties.<br><h4>Fix - Runtime</h4>CLI Command<br>To see the secrets, run the following CLI command:<br>Shellaws lambda get-function-configuration<br>--region <REGION><br>--function-name <FUNCTION_NAME><br>--query Environment.Variables<br><br><h4>Fix - Buildtime</h4>CloudFormation<br><br>Resource: AWS::Lambda::Function<br>Argument: Properties.Environment.Variables<br><br>YAMLType: AWS::Lambda::Function<br>Properties:<br>...<br>Environment:<br>Variables:<br>key1: not_a_secret<br>-           key2: secret<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_lambda_function<br>Argument Block Environment Attribute variables<br><br>aws_lambda_function.fail.tfresource \"aws_lambda_function\" \"fail\" {<br>function_name = \"test-env\"<br>role = \"\"<br>runtime = \"python3.8\"<br><br>environment {<br>variables = {<br>-      AWS_ACCESS_KEY_ID     = \"AKIAIOSFODNN7EXAMPLE\",<br>-      AWS_SECRET_ACCESS_KEY = \"wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY\",<br>-      AWS_DEFAULT_REGION    = \"us-west-2\"<br>}<br>}<br>}<br><br>In this case the permissions would be better being added to an IAM Role.<br>"
    },
    "CKV_AWS_41": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_secrets_5",
        "severity": "CRITICAL",
        "description": "<h4>AWS access keys and secrets are hard coded in infrastructure</h4><h4>Description</h4>When accessing AWS programmatically users can select to use an access key to verify their identity, and the identity of their applications. An access key consists of an access key ID and a secret access key. Anyone with an access key has the same level of access to AWS resources.<br>We recommend you protect access keys and keep them private. Specifically, do not store hard coded keys and secrets in infrastructure such as code, or other version-controlled configuration settings.<br><h4>Fix - Buildtime</h4>Terraform<br>You really should not add your secrets to your Infrastructure code, obtain AWS through the keychain e.g. via Environmental variables.<br>Remove any reference to access_key and secret_key.<br>provider.aws.tfprovider \"aws\" {<br>region = var.region<br>- access_key = \"NOTEXACTLYAKEY\"<br>- secret_key = \"NOTACTUALLYASECRET\"<br>}<br>"
    },
    "CKV_AWS_32": {
        "url": "https://docs.bridgecrew.io/docs/public_1-ecr-repositories-not-public",
        "severity": "INFO",
        "description": "<h4>AWS Private ECR repository policy is overly permissive</h4><h4>Description</h4>AWS ECR is a managed Docker registry service that simplifies Docker container image management. The ECR repository is a collection of Docker images available on AWS. Access control to ECR repositories is governed using resource-based policies. A public ECR repository can expose internal Docker images that contain confidential business logic.<br>We recommend you do not allow unrestricted public access to ECR repositories to help avoid data leakage.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon ECS console.<br>Select Amazon ECR , then select Repositories.<br>Click the image repository that you want to configure. To modify the permission policy, select Permissions.<br>In the Permission statements, select the policy statement that has Effect set to Allow and Principal set to *.<br>To select a restricted access policy, click Edit and make changes.<br><br><h4>Fix - Buildtime</h4>CloudFormation<br>Resource: AWS::ECR::Repository<br>Argument: Properties.RepositoryPolicyText.Statement.Principal<br>YAMLResources:<br>MyRepository:<br>Type: AWS::ECR::Repository<br>Properties:<br>...<br>RepositoryPolicyText:<br>...<br>Statement:<br>- ...<br>-           Principal: \"*\"<br>+                       Principal:<br>+             AWS:<br>+                - \"arn:aws:iam::123456789012:user/Bob\"<br>+                - ...<br>"
    },
    "CKV_AWS_17": {
        "url": "https://docs.bridgecrew.io/docs/public_2",
        "severity": "MEDIUM",
        "description": "<h4>AWS RDS database instance is publicly accessible</h4><h4>Description</h4>Ensure that all your public AWS Application Load Balancer are integrated with the Web Application Firewall (AWS WAF) service to protect against application-layer attacks. An Application Load Balancer functions at the application layer, the seventh layer of the Open Systems Interconnection (OSI) model. After the load balancer receives a request, it evaluates the listener rules in priority order to determine which rule to apply, and then selects a target from the target group for the rule action. You can configure listener rules to route requests to different target groups based on the content of the application traffic. Routing is performed independently for each target group, even when a target is registered with multiple target groups.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon RDS console.<br>On the navigation pane, click Snapshots.<br>Select the snapshot to encrypt.<br>Navigate to Snapshot Actions, select Copy Snapshot.<br>Select your Destination Region, then enter your New DB Snapshot Identifier.<br>Set Enable Encryption to Yes.<br>Select your Master Key from the list, then select Copy Snapshot.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_db_instance<br>Argument: publicly_accessible<br><br>aws_rds_cluster.default.tfresource \"aws_db_instance\" \"default\" {<br>...<br>+ publicly_accessible   = false<br>}<br><br>CloudFormation<br><br>Resource: AWS::RDS::DBInstance<br>Argument: Properties.PubliclyAccessible<br><br>YAMLType: 'AWS::RDS::DBInstance'<br>Properties:<br>...<br>+     PubliclyAccessible: false<br>"
    },
    "CKV_AWS_59": {
        "url": "https://docs.bridgecrew.io/docs/public_6-api-gateway-authorizer-set",
        "severity": "LOW",
        "description": "<h4>API gateway methods are publicly accessible</h4><h4>Description</h4>AWS API gateway methods are by default publicly accessible. All of the methods configured as part of the API should be protected by an Authorizer or an API key. Unprotected API's can lead to data leaks and security breaches.<br>We recommend you configure a custom authorizer OR an API key for every method in the API Gateway.<br><h4>Fix - Buildtime</h4>CloudFormation<br><br>Resource:  AWS::ApiGateway::Method<br>Argument: Properties.HttpMethod / Properties.AuthorizationType / Properties.ApiKeyRequired<br><br>YAMLResources:<br>ProtectedExample1:<br>Type: 'AWS::ApiGateway::Method'<br>Properties:<br>...<br>+     HttpMethod: OPTIONS<br>AuthorizationType: NONE<br>...<br><br>ProtectedExample2:<br>Type: 'AWS::ApiGateway::Method'<br>Properties:<br>...<br>HttpMethod: GET<br>AuthorizationType: NONE<br>+     ApiKeyRequired: true<br>...<br><br>ProtectedExample3:<br>Type: 'AWS::ApiGateway::Method'<br>Properties:<br>...<br>HttpMethod: GET<br>+     AuthorizationType: AWS_IAM # or other valid authorization types<br>...<br><br>Terraform<br><br>Resource:  aws_api_gateway_method<br>Argument: http_method, authorisation, api_key_required<br><br>aws_api_gateway_method.pass.tfresource \"aws_api_gateway_method\" \"pass\" {<br>rest_api_id = aws_api_gateway_rest_api.MyDemoAPI.id<br>resource_id = aws_api_gateway_resource.MyDemoResource.id<br>+ http_method = \"OPTIONS\"<br>+ authorization    = \"NONE\"<br>+ api_key_required = true<br>tags             = { test = \"Fail\" }<br>}<br>"
    },
    "CKV_AWS_87": {
        "url": "https://docs.bridgecrew.io/docs/public_9",
        "severity": "HIGH",
        "description": "<h4>AWS Redshift clusters should not be publicly accessible</h4><h4>Description</h4>Redshift clusters deployed within a VPC can be accessed from: the Internet, EC2 Instances outside the VPC via VPN, bastion hosts that you can launch in your public subnet, and using Amazon Redshift\u2019s Publicly Accessible option. To use public connectivity, create your Redshift clusters with the Publicly Accessible option set to Yes, your Redshift clusters within a VPC will be fully accessible outside your VPC. If you do not want your Redshift clusters accessible from the Internet or outside your VPC, disable the Redshift Publicly Accessible option. If your AWS account allows you to create EC2-Classic clusters, the default option for Publicly Accessible is No.<br>Public access to a Redshift cluster can increase the opportunity for malicious activity such as SQL injections or Distributed Denial of Service (DDoS) attacks.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Navigate to the Redshift service.<br>Click on the identified Redshift cluster name.<br>In the menu options, click Cluster, then select Modify.<br>Ensure the value for Publicly Accessible is set to No.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_redshift_cluster<br>Argument: publicly_accessible<br><br>Goresource \"aws_redshift_cluster\" \"default\" {<br>cluster_identifier = \"tf-redshift-cluster\"<br>...<br>- publicly_accessible= \"true\"<br>+ publicly_accessible= \"false\"<br>}<br><br>CloudFormation<br><br>Resource: AWS::Redshift::Cluster<br>Argument: Properties.PubliclyAccessible<br><br>YAMLType: \"AWS::Redshift::Cluster\"<br>Properties:<br>...<br>-     PubliclyAccessible: true<br>+           PubliclyAccessible: false<br>"
    },
    "CKV_AWS_77": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_29",
        "severity": "MEDIUM",
        "description": "<h4>Athena Database is not encrypted at rest</h4><h4>Description</h4>Athena is a query service managed by AWS that uses standard SQL to analyze data directly in Amazon S3. Encryption of data while in transit between Amazon Athena and S3 is provided by default using SSL/TLS, but encryption of query results at rest is not enabled by default.<br>The encryption at rest feature available for AWS Athena query results provides an additional layer of data protection by helping secure your data against unauthorized access to the underlying Amazon S3 storage.<br><h4>Fix - Runtime</h4>AWS Console<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon Athena console.<br>In the Athena console, choose Settings.<br>Choose Encrypt query results.<br>For Encryption select either CSE-KMS, SSE-KMS, or SSE-S3.<br>If your account has access to an existing AWS KMS customer managed key (CMK), choose its alias or choose Enter a KMS key ARN, then enter an ARN.<br>Click Save.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_athena_database<br>Arguments:encryption_configuration - (Optional) The encryption key block AWS Athena uses to decrypt the data in S3, such as an AWS Key Management Service (AWS KMS) key. An encryption_configuration block is documented below.<br><br>Goresource \"aws_athena_database\" \"examplea\" {<br>...<br>name   = \"database_name\"<br>+ encryption_configuration {<br>+   encryption_option = var.encryption_option<br>+   kms_key           = var.kms_key_arn<br>+ }<br>...<br>}<br>"
    },
    "CKV_AWS_62": {
        "url": "https://docs.bridgecrew.io/docs/iam_47",
        "severity": "CRITICAL",
        "description": "<h4>AWS IAM policy allows full administrative privileges</h4><h4>Description</h4>IAM policies should grant a minimum set of permissions, adding more as required, rather than grant full administrative privileges. Providing full administrative privileges when not required exposes resources to potentially unwanted actions.<br><h4>Fix - Runtime</h4>AWS Console<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon IAM console.<br>In the navigation pane, click Policies and then search for the policy name found in the audit step.<br>Select the policy that needs to be deleted.<br>In the policy action menu, select first Detach.<br>Select all Users, Groups, Roles that have this policy attached.<br>Click Detach Policy.<br>In the policy action menu, select Detach.<br><br>CLI Command<br><br>List all IAM users, groups, and roles that the specified managed policy is attached to:<br><br>aws iam list-entities-for-policy --policy-arn <policy_arn><br><br>Detach the policy from all IAM Users:<br><br>aws iam detach-user-policy --user-name <iam_user> --policy-arn <policy_arn><br><br>Detach the policy from all IAM Groups:<br><br>aws iam detach-group-policy --group-name <iam_group> --policy-arn <policy_arn><br><br>Detach the policy from all IAM Roles:<br><br>aws iam detach-role-policy --role-name <iam_role> --policy-arn <policy_arn><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resources: aws_iam_policy<br>Argument: policy - (Required) The policy document. This is a JSON formatted string. For more information about building AWS IAM policy documents with Terraform, see the AWS IAM Policy Document Guide<br><br>Goresource \"aws_iam_policy\" \"policy\" {<br>name        = \"test_policy\"<br>path        = \"/\"<br>description = \"My test policy\"<br><br>policy = <<EOF<br>{<br>\"Version\": \"2012-10-17\",<br>\"Statement\": [<br>{<br>\"Action\": [<br>-        \"*\"<br>],<br>\"Effect\": \"Allow\",<br>\"Resource\": \"*\"<br>}<br>]<br>}<br>EOF<br>}<br>"
    },
    "CKV_AWS_63": {
        "url": "https://docs.bridgecrew.io/docs/iam_48",
        "severity": "CRITICAL",
        "description": "<h4>IAM policy documents allow * (asterisk) as a statement's action</h4><h4>Description</h4>IAM policies should grant a minimum set of permissions, adding more as required, rather than grant full administrative privileges. Providing full administrative privileges when not required exposes resources to potentially unwanted actions.<br><h4>Fix - Runtime</h4>AWS Console<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon IAM console.<br>In the navigation pane, click Policies and then search for the policy name found in the audit step.<br>Select the policy that needs to be deleted.<br>In the policy action menu, select first Detach.<br>Select all Users, Groups, Roles that have this policy attached.<br>Click Detach Policy.<br>In the policy action menu, select Detach.<br><br>CLI Command<br><br>List all IAM users, groups, and roles that the specified managed policy is attached to:<br><br>aws iam list-entities-for-policy --policy-arn <policy_arn><br><br>Detach the policy from all IAM Users:<br><br>aws iam detach-user-policy --user-name <iam_user> --policy-arn <policy_arn><br><br>Detach the policy from all IAM Groups:<br><br>aws iam detach-group-policy --group-name <iam_group> --policy-arn <policy_arn><br><br>Detach the policy from all IAM Roles:<br><br>aws iam detach-role-policy --role-name <iam_role> --policy-arn <policy_arn><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resources: aws_iam_policy<br>Argument: policy - (Required) The policy document. This is a JSON formatted string. For more information about building AWS IAM policy documents with Terraform, see the AWS IAM Policy Document Guide.<br><br>Goresource \"aws_iam_policy\" \"policy\" {<br>name        = \"test_policy\"<br>path        = \"/\"<br>description = \"My test policy\"<br><br>policy = <<EOF<br>{<br>\"Version\": \"2012-10-17\",<br>\"Statement\": [<br>{<br>\"Action\": [<br>-        \"*\"<br>],<br>\"Effect\": \"Allow\",<br>\"Resource\": \"*\"<br>}<br>]<br>}<br>EOF<br>}<br>"
    },
    "CKV_AWS_66": {
        "url": "https://docs.bridgecrew.io/docs/logging_13",
        "severity": "LOW",
        "description": "<h4>CloudWatch log groups do not specify retention days</h4><h4>Description</h4>Enabling CloudWatch retention establishes how long log events are kept in AWS CloudWatch Logs. Retention settings are assigned to CloudWatch log groups and the retention period assigned to a log group is applied to their log streams. Any data older than the current retention setting is deleted automatically. You can change the log retention for each log group at any time.<br>Log data is stored in CloudWatch Logs indefinitely by default, l. This may incur high unexpected costs, especially when combined with other forms of logging. We recommend you configure how long to store log data for in a log group to balance cost with compliance retention requirements.<br><h4>Fix - Runtime</h4>AWS Console<br>Procedure:<br><br>Log in to the AWS Management Console at [https://console.aws.amazon.com/].<br>Open the Amazon CloudWatch console.<br>In the navigation pane, choose Log Groups.<br>Find the log group to update.<br>In the Expire Events After column for that log group, choose the current retention setting, such as Never Expire.<br>In Edit Retention, for Retention, choose a log retention value, then click Ok.<br><br>CLI Command<br>Sets the retention of the specified log group. A retention policy allows you to configure the number of days for which to retain log events in the specified log group.<br>Shellput-retention-policy<br>--log-group-name <value><br>--retention-in-days <value><br>[--cli-input-json <value>]<br>[--generate-cli-skeleton <value>]<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_cloudwatch_log_group<br>Argument: retention_in_days - (Optional) Specifies the number of days you want to retain log events in the specified log group. Possible values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731, 1827, 3653, and 0. If you select 0, the events in the log group are always retained and never expire.<br><br>Goresource \"aws_cloudwatch_log_group\" \"example\" {<br>...<br>name = \"example\"<br>+ retention_in_days = 90<br>}<br><br>CloudFormation<br><br>Resource: aws_cloudwatch_log_group<br>Argument: Properties.RetentionInDays - (Optional) Specifies the number of days you want to retain log events in the specified log group. Possible values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731, 1827, 3653, and 0. If you select 0, the events in the log group are always retained and never expire.<br><br>YAMLResources:<br>logGroup:<br>Type: AWS::Logs::LogGroup<br>Properties:<br>...<br>+     RetentionInDays: 90<br>"
    },
    "CKV_AWS_68": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_27",
        "severity": "MEDIUM",
        "description": "<h4>CloudFront distribution does not have WAF enabled</h4><h4>Description</h4>AWS WAF gives you control over how traffic reaches your applications by enabling you to create security rules. We recommend you create rules that block common attack patterns, such as SQL injection, cross-site scripting, and rules that filter out specific traffic patterns that you have defined.<br>With AWS Cloudfront \u2013 WAF integration enabled you will be able to block any malicious requests made to your Cloudfront Content Delivery Network based on the criteria defined in the WAF Web Access Control List (ACL) associated with the CDN distribution.<br><h4>Fix - Runtime</h4>CloudFront Console<br><br>Log in to the CloudFront console at https://console.aws.amazon.com/cloudfront/.<br>Choose the ID for the distribution that you want to update.<br>On the General tab, click Edit.<br>On the Distribution Settings page, in the AWS WAF Web ACL list, choose the web ACL that you want to associate with this distribution.<br>If you want to disassociate the distribution from all web ACLs, choose None. If you want to associate the distribution with a different web ACL, choose the new web ACL.<br>Click Yes, Edit.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_cloudfront_distribution<br>Arguments: web_acl_id (Optional) - If you're using AWS WAF to filter CloudFront requests, the Id of the AWS WAF web ACL that is associated with the distribution. The WAF Web ACL must exist in the WAF Global (CloudFront) region and the credentials configuring this argument must have waf:GetWebACL permissions assigned. If using WAFv2, provide the ARN of the web ACL.<br><br>Goresource \"aws_cloudfront_distribution\" \"exapmle\" {<br>...<br>enabled             = true<br>is_ipv6_enabled     = false<br>+ web_acl_id = aws_wafv2_web_acl.example.id<br>...<br>}<br><br>CloudFormation<br><br>Resource: AWS::CloudFront::Distribution<br>Arguments:  Properties.DistributionConfig.WebACLId<br><br>YAMLType: 'AWS::CloudFront::Distribution'<br>Properties:<br>...<br>DistributionConfig:<br>...<br>WebACLId: arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/12345<br>"
    },
    "CKV_AWS_69": {
        "url": "https://docs.bridgecrew.io/docs/public_11",
        "severity": "MEDIUM",
        "description": "<h4>AWS MQ is publicly accessible</h4><h4>Description</h4>Brokers created without public accessibility cannot be accessed from outside of your VPC. This greatly reduces your broker's susceptibility to DDoS attacks from the internet. Public Amazon MQ brokers can be accessed directly, outside of a VPC, allowing every EC2 on the Internet to reach your brokers through their public endpoints. This can increase the opportunity for malicious activity such as cross-site scripting and clickjacking attacks.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon MQ console.<br>In the Select deployment and storage page, in the Deployment mode and storage type section configure your MQ based on your specs.<br>In the Network and security section, configure your broker's connectivity and select the Public accessibility of your broker. Disabling public accessibility makes the broker accessible only within your VPC.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_mq_broker<br>Argument: publicly_accessible - (Optional) Whether to enable connections from applications outside of the VPC that hosts the broker's subnets.<br><br>Goresource \"aws_mq_broker\" \"example\" {<br>broker_name = \"example\"<br>+ publicly_accessible = true<br>configuration {<br>id       = aws_mq_configuration.test.id<br>revision = aws_mq_configuration.test.latest_revision<br>}<br><br>engine_type        = \"ActiveMQ\"<br>engine_version     = \"5.15.0\"<br>host_instance_type = \"mq.t2.micro\"<br>security_groups    = [aws_security_group.test.id]<br><br>user {<br>username = \"ExampleUser\"<br>password = \"MindTheGap\"<br>}<br>}<br>"
    },
    "CKV_AWS_73": {
        "url": "https://docs.bridgecrew.io/docs/logging_15",
        "severity": "LOW",
        "description": "<h4>API Gateway does not have X-Ray tracing enabled</h4><h4>Description</h4>When an API Gateway stage has the active tracing feature enabled, Amazon API Gateway service automatically samples API invocation requests based on the sampling algorithm specified by AWS X-Ray.<br>With tracing enabled X-Ray can provide an end-to-end view of an entire HTTP request. You can use this to analyze latencies in APIs and their backend services.<br><h4>Fix - Runtime</h4>AWS Console<br><br>Log in to the AWS Management Console at [https://console.aws.amazon.com/].<br>Open the Amazon API Gateway console.<br>In the APIs pane, choose the API, and then click Stages.<br>In the Stages pane, choose the name of the stage.<br>In the Stage Editor pane, choose the Logs/Tracing tab.<br>To enable active X-Ray tracing, choose Enable X-Ray Tracing under X-Ray Tracing.<br><br>CLI Command<br>Shellaws apigateway create-stage \\<br>--rest-api-id {rest-api-id} \\<br>--stage-name {stage-name} \\<br>--deployment-id {deployment-id} \\<br>--region {region} \\<br>--tracing-enabled=true<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_api_gateway_stage<br>Argument: xray_tracing_enabled - (Optional) Whether active tracing with X-ray is enabled. Defaults to false.<br><br>Goresource \"aws_api_gateway_stage\" \"test\" {<br>...<br>stage_name    = \"prod\"<br>+ xray_tracing_enabled = true<br>...<br>}<br><br>CloudFormation<br><br>Resource: AWS::ApiGateway::Stage<br>Argument: Properties.TracingEnabled<br><br>YAMLResources:<br>MyStage:<br>Type: AWS::ApiGateway::Stage<br>Properties:<br>...<br>+     TracingEnabled: true<br>...<br>"
    },
    "CKV_AWS_74": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_28",
        "severity": "MEDIUM",
        "description": "<h4>DocumentDB is not encrypted at rest</h4><h4>Description</h4>The encryption feature available for Amazon DocumentDB clusters provides an additional layer of data protection by helping secure your data against unauthorized access to the underlying storage.<br>Amazon DocumentDB allows you to encrypt your clusters using keys managed through the AWS Key Management Service (KMS). On a cluster running with Amazon DocumentDB encryption, data stored at rest in the underlying storage is encrypted, as are its automated backups, snapshots, and replicas in the same cluster.<br><h4>Fix - Runtime</h4>Procedure<br><br>Create an Amazon DocumentDB cluster.<br>Under the Authentication section, choose Show advanced settings.<br>Scroll down to the Encryption-at-rest section.<br>Choose the option that you want for encryption at rest. Whichever option you choose, you can't change it after the cluster is created.<br><br>To encrypt data at rest in this cluster, choose Enable encryption.<br>CLI Command<br>Goaws docdb create-db-cluster \\<br>--db-cluster-identifier sample-cluster \\<br>--port 27017 \\<br>--engine docdb \\<br>--master-username yourMasterUsername \\<br>--master-user-password yourMasterPassword \\<br>--storage-encrypted<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_docdb_cluster<br>Arguments: storage_encrypted - Specifies whether the DB cluster is encrypted.<br><br>Goresource \"aws_docdb_cluster\" \"example\" {<br>...<br>cluster_identifier = \"docdb-cluster-demo\"<br>+ storage_encrypted  = true<br>...<br>}<br>"
    },
    "CKV_AWS_75": {
        "url": "https://docs.bridgecrew.io/docs/logging_16",
        "severity": "LOW",
        "description": "<h4>Global Accelerator does not have Flow logs enabled</h4><h4>Description</h4>Global Accelerator is a networking service that sends traffic through AWS's global network enabling global access to your web apps. Flow logs allow capturing information about the IP address traffic going to and from network interfaces in the AWS Global Accelerator. Flow log data is published to Amazon S3, where it can be retrieved and viewed.<br>Flow logs enable troubleshooting if specific traffic is not reaching an endpoint, helping you to diagnose overly restrictive security group rules. It can also be used to monitor the traffic that is reaching endpoints in a VPC and establish if they should be receiving that traffic.<br><h4>Fix - Runtime</h4>CLI Command<br><br>Create an S3 bucket for your flow logs.<br>Add an IAM policy for the AWS user who is enabling the flow logs.<br>Run the following commands, with the S3 bucket name and prefix that you want to use for your log files:<br><br>Shellaws globalaccelerator update-accelerator-attributes<br>--accelerator-arn arn:aws:globalaccelerator::012345678901:accelerator/1234abcd-abcd-1234-abcd-1234abcdefgh<br>--region us-west-2<br>--flow-logs-enabled<br>--flow-logs-s3-bucket s3-bucket-name<br>--flow-logs-s3-prefix s3-bucket-prefix<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_globalaccelerator_accelerator<br>Argument: flow_logs_enabled - (Optional) Indicates whether flow logs are enabled.<br><br>Goresource \"aws_globalaccelerator_accelerator\" \"example\" {<br>name            = \"Example\"<br>ip_address_type = \"IPV4\"<br>enabled         = true<br><br>attributes {<br>+    flow_logs_enabled   = true<br>+    flow_logs_s3_bucket = \"example-bucket\"<br>+    flow_logs_s3_prefix = \"flow-logs/\"<br>}<br>}<br>"
    },
    "CKV_AWS_76": {
        "url": "https://docs.bridgecrew.io/docs/logging_17",
        "severity": "LOW",
        "description": "<h4>API Gateway does not have access logging enabled</h4><h4>Description</h4>Enabling the custom access logging option in API Gateway allows delivery of custom logs to CloudWatch Logs, which can be analyzed using CloudWatch Logs Insights. Using custom domain names in Amazon API Gateway allows insights into requests sent to each custom domain name. If there is more than one custom domain name mapped to a single API, understanding the quantity and type of requests by domain name may help understand request patterns.<br><h4>Fix - Runtime</h4>AWS Console<br>Procedure:<br><br>Log in to the AWS Management Console at [https://console.aws.amazon.com/].<br>Open the Amazon API Gateway console.<br>Find the Stage Editor for your API.<br>On the Stage Editor pane, choose the Logs/Tracing tab.<br>On the Logs/Tracing tab, under CloudWatch Settings, do the following to enable execution logging.<br>Select the Enable CloudWatch Logs check box.<br>For Log level, choose INFO to generate execution logs for all requests. Or, choose ERROR to generate execution logs only for requests to your API that result in an error.<br>Select the Log full requests/responses data check box for a REST API. Or, select the Log full message data check box for a WebSocket API.<br>Under Custom Access Logging, select the Enable Access Logging check box.<br>For Access Log Destination ARN, enter the ARN of a CloudWatch log group or an Amazon Kinesis Data Firehose stream.<br>Enter a Log Format. For guidance, you can choose CLF, JSON, XML, or CSV to see an example in that format.<br>Click Save Changes.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_api_gateway_stage<br>Argument: access_log_settings - (Optional) Enables access logs for the API stage. Detailed below.<br><br>Goresource \"aws_api_gateway_stage\" \"test\" {<br>...<br>stage_name    = \"prod\"<br>+ access_log_settings {<br>+   destination_arn = \"${aws_cloudwatch_log_group.example.arn}\"<br>+   format          = \"...\"<br>+  }<br>...<br>}<br><br>CloudFormation<br><br>Resource: AWS::ApiGateway::Stage<br>Argument: Properties.AccessLogSettings.DestinationArn<br><br>YAMLResources:<br>MyStage:<br>Type: AWS::ApiGateway::Stage<br>Properties:<br>...<br>AccessLogSetting:<br>DestinationArn: 'arn:aws:logs:us-east-1:123456789:log-group:example-log-group'<br>Format: \"...\"<br>...<br>"
    },
    "CKV_AWS_78": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_30",
        "severity": "MEDIUM",
        "description": "<h4>CodeBuild project encryption is disabled</h4><h4>Description</h4>AWS CodeBuild is a fully managed build service in the cloud. CodeBuild compiles your source code, runs unit tests, and produces artifacts that are ready to deploy. Build artifacts, such as a cache, logs, exported raw test report data files, and build results, are encrypted by default using CMKs for Amazon S3 that are managed by the AWS Key Management Service. If you do not want to use these CMKs, you must create and configure a customer-managed CMK.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_codebuild_project<br>Arguments: encryption_disabled - (Optional) If set to true, output artifacts will not be encrypted. If type is set to NO_ARTIFACTS then this value will be ignored. Defaults to false.<br>To fix, either set to false or remove attribute.<br><br>Goresource \"aws_codebuild_project\" \"project-with-cache\" {<br>...<br>name           = \"test-project-cache\"<br>artifacts {<br>+    encryption_disabled = false<br>}<br>...<br>}<br><br>CloudFormation<br><br>Resource: AWS::CodeBuild::Project<br>Arguments: Properties.Artifacts - (Optional) If set to true, output artifacts will not be encrypted. If type is set to NO_ARTIFACTS then this value will be ignored. Defaults to false.<br><br>YAMLResources:<br>CodeBuildProject:<br>Type: AWS::CodeBuild::Project<br>Properties:<br>...<br>Artifacts:<br>...<br>Type: S3<br>-               EncryptionDisabled: True<br>+               EncryptionDisabled: False<br>"
    },
    "CKV_AWS_79": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_31",
        "severity": "MEDIUM",
        "description": "<h4>Instance Metadata Service version 1 is enabled</h4><h4>Description</h4>The Instance Metadata Service (IMDS) is an on-instance component used by code on the instance to securely access instance metadata. You can access instance metadata from a running instance using one of the following methods:<br><br>Instance Metadata Service Version 1 (IMDSv1) \u2013 a request/response method<br>Instance Metadata Service Version 2 (IMDSv2) \u2013 a session-oriented method<br><br>As a request/response method IMDSv1 is prone to local misconfigurations:<br><br>Open proxies, open NATs and routers, server-side reflection vulnerabilities.<br>One way or another, local software might access local-only data.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_instance<br>Arguments: http_tokens - (Optional) Whether or not the metadata service requires session tokens, the mechanism used for Instance Metadata Service Version 2. Can be \"optional\" or \"required\". (Default: \"optional\"). Set to \"required\" to enable Instance Metadata Service V2.<br><br>Alternatively, disable the metadata service altogether by setting http_endpoint = \"disabled\".<br>Goresource \"aws_instance\" \"example\" {<br>...<br>instance_type     = \"t2.micro\"<br>+   metadata_options {<br>...<br>+       http_endpoint = \"enabled\"<br>+       http_tokens   = \"required\"<br>+  }<br>...<br>}<br><br>If setting http_tokens = \"required\" in a launch template that is being used for a EKS worker/node group, you should consider setting the http_put_response_hop_limit = 2 per the default behavior in EKS.<br>Without this setting the default service account in EKS will not be able to access the instance metadata service.<br>CloudFormation<br><br>Resource: AWS::EC2::LaunchTemplate<br>Arguments: Properties.MetadataOptions.HttpEndpoint /  Properties.MetadataOptions.HttpTokens<br><br>YAMLResources:<br>IMDSv1Disabled:<br>Type: AWS::EC2::LaunchTemplate<br>Properties:<br>...<br>LaunchTemplateData:<br>...<br>+       MetadataOptions:<br>+         HttpEndpoint: disabled<br><br>IMDSv2Enabled:<br>Type: AWS::EC2::LaunchTemplate<br>Properties:<br>...<br>LaunchTemplateData:<br>...<br>+       MetadataOptions:<br>+         HttpTokens: required<br>"
    },
    "CKV_AWS_80": {
        "url": "https://docs.bridgecrew.io/docs/logging_18",
        "severity": "MEDIUM",
        "description": "<h4>Amazon MSK cluster logging is not enabled</h4><h4>Description</h4>Amazon MSK enables you to build and run applications that use Apache Kafka to process streaming data. It also provides a control-plane for advanced operations, for example, creating, updating, and deleting clusters.<br>Consistent cluster logging helps you determine if a  request was made with root or AWS Identity and Access Management (IAM) user credentials and whether the request was made with temporary security credentials for a role or federated user.<br><h4>Fix - Runtime</h4>AWS Console<br>New Cluster:<br><br>Log in to the AWS Management Console at [https://console.aws.amazon.com/].<br>Open the Amazon MSK console.<br>Go to Broker Log Delivery in the Monitoring section.<br>Specify the destinations to which you want Amazon MSK to deliver your broker logs.<br><br>Existing Cluster:<br><br>In the Amazon MSK console  choose the cluster from your list of clusters.<br>Go to the Details tab. Scroll down to the Monitoring section and click Edit.<br>Specify the destinations to which you want Amazon MSK to deliver your broker logs.<br><br>CLI Command<br>When you use the create-cluster or the update-monitoring commands, you can optionally specify the logging-info parameter and pass to it a JSON structure. In this JSON, all three destination types are optional.<br>JSON{<br>\"BrokerLogs\": {<br>\"S3\": {<br>\"Bucket\": \"ExampleBucketName\",<br>\"Prefix\": \"ExamplePrefix\",<br>\"Enabled\": true<br>},<br>\"Firehose\": {<br>\"DeliveryStream\": \"ExampleDeliveryStreamName\",<br>\"Enabled\": true<br>},<br>\"CloudWatchLogs\": {<br>\"Enabled\": true,<br>\"LogGroup\": \"ExampleLogGroupName\"<br>}<br>}<br>}<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_msk_cluster<br>Argument: logging_info - (Optional) Configuration block for streaming broker logs to Cloudwatch/S3/Kinesis Firehose. See below.<br><br>Goresource \"aws_msk_cluster\" \"example\" {<br>cluster_name           = \"example\"<br>...<br>+  logging_info {<br>+    broker_logs {<br>+      cloudwatch_logs {<br>+        enabled   = true<br>+        log_group = aws_cloudwatch_log_group.test.name<br>}<br><br>CloudFormation<br><br>Resource:AWS::MSK::Cluster<br>ArgumentLoggingInfo. Configure your MSK cluster to send broker logs to different destination types. This is a container for the configuration details related to broker logs.<br><br>Go{<br>\"Type\" : \"AWS::MSK::Cluster\",<br>\"Properties\" : {<br>...<br>+    \"LoggingInfo\" : {<br>+      \"BrokerLogs\" : {<br>+        \"CloudWatchLogs\" : CloudWatchLogs,<br>+        \"Firehose\" : Firehose,<br>+        \"S3\" : S3<br>}<br>}<br>}<br>}<br>"
    },
    "CKV_AWS_81": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_32",
        "severity": "MEDIUM",
        "description": "<h4>MSK cluster encryption at rest and in transit is not enabled</h4><h4>Description</h4>Amazon MSK integrates with AWS Key Management Service (KMS) for server-side encryption. When you create an MSK cluster, you can specify the AWS KMS CMK for Amazon MSK to use to encrypt your data at rest. If you don't specify a CMK, Amazon MSK creates an AWS managed CMK for you and uses it on your behalf.<br>We recommend using encryption in transit and at rest to secure your managed Kafka queue.<br><h4>Fix - Runtime</h4>CLI Command<br>Run the create-cluster command and use the encryption-info option to point to the file where you saved your configuration JSON.<br>Shellaws kafka create-cluster<br>--cluster-name \"ExampleClusterName\"<br>--broker-node-group-info file://brokernodegroupinfo.json<br>--encryption-info file://encryptioninfo.json<br>--kafka-version \"2.2.1\"<br>--number-of-broker-nodes 3<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_msk_cluster<br>Arguments: encryption_info - (Optional) Configuration block for specifying encryption.<br>encryption_in_transit - (Optional) Configuration block to specify encryption in transit. See below.<br><br>Goresource \"aws_msk_cluster\" \"example\" {<br>cluster_name           = \"example\"<br>...<br>+ encryption_info {<br>+    encryption_at_rest_kms_key_arn = aws_kms_key.kms.arn<br>+<br>+    encryption_in_transit {<br>+        client_broker = \"TLS\"<br>+        in_cluster    = true<br>+     }<br>+ }<br>...<br>}<br>"
    },
    "CKV_AWS_82": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_33",
        "severity": "MEDIUM",
        "description": "<h4>Athena workgroup does not prevent disabling encryption</h4><h4>Description</h4>You can configure settings at the workgroup level, enforce control over the workgroup. This only affects you if you run queries in the workgroup; if you do, workgroup settings are used.<br>If a query runs in a workgroups and the workgroup overrides client-side settings, Athena uses the workgroup's settings for encryption. It also overrides any other settings specified for the query in the console, by using API operations, or with drivers.<br><h4>Fix - Runtime</h4>CLI Command<br>Run the create-cluster command and use the encryption-info option to point to the file where you saved your configuration JSON.<br>Shellaws kafka create-cluster<br>--cluster-name \"ExampleClusterName\"<br>--broker-node-group-info file://brokernodegroupinfo.json<br>--encryption-info file://encryptioninfo.json<br>--kafka-version \"2.2.1\"<br>--number-of-broker-nodes 3<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_athena_workgroup<br>Argument: enforce_workgroup_configuration - (Optional) Boolean whether the settings for the workgroup override client-side settings. For more information, see Workgroup Settings Override Client-Side Settings. Defaults to true.<br><br>aws_athena_workgroup.example.tfresource \"aws_athena_workgroup\" \"example\" {<br>name = \"example\"<br>...<br>configuration {<br>enforce_workgroup_configuration    = true<br>publish_cloudwatch_metrics_enabled = true<br><br>result_configuration {<br>output_location = \"s3://{aws_s3_bucket.example.bucket}/output/\"<br><br>encryption_configuration {<br>encryption_option = \"SSE_KMS\"<br>kms_key_arn       = aws_kms_key.example.arn<br>}<br>}<br>}<br>}<br><br>CloudFormation<br><br>Resource:  AWS::Athena::WorkGroup<br>Argument: Properties.WorkGroupConfiguration.EnforceWorkGroupConfiguration<br><br>YAMLResources:<br>MyAthenaWorkGroup:<br>Type: AWS::Athena::WorkGroup<br>Properties:<br>...<br>+     WorkGroupConfiguration:<br>+       EnforceWorkGroupConfiguration: true<br>...<br>"
    },
    "CKV_AWS_84": {
        "url": "https://docs.bridgecrew.io/docs/elasticsearch_7",
        "severity": "MEDIUM",
        "description": "<h4>AWS Elasticsearch domain logging is not enabled</h4><h4>Description</h4>Amazon ES exposes logs through CloudWatch. ES logs supported include error logs, search slow logs, index slow logs, and audit logs. All the logs are disabled by default. ES logs enable troubleshooting performance and stability issues. Audit logs track user activity for compliance purposes. If enabled, standard CloudWatch pricing applies.<br>We recommend you enable elasticsearch domain logging.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon Elasticsearch console.<br>In the navigation pane, under My domains, select the domain that you want to update.<br>4.Navigate to the Logs tab. For the log that you are working with, select Enable.<br>Create a CloudWatch log group, or select an existing one.<br>Select an access policy that contains the appropriate permissions, or create a new policy. Select Enable.<br>The status of your domain changes from Active to Processing. Prior to log publishing being enabled, the status of your domain must return to Active.<br><br>CLI Command<br>Before you can enable log publishing, you need a CloudWatch log group. If you don't already have one, you will need to can create one.<br>Shellaws logs put-resource-policy --policy-name my-policy --policy-document <policy_doc_json><br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_elasticsearch_domain<br>Argument: log_publishing_options - (Optional) Options for publishing slow and application logs to CloudWatch Logs. This block can be declared multiple times, for each log_type, within the same resource.<br><br>Goresource \"aws_elasticsearch_domain\" \"example\" {<br>...<br>domain_name           = \"example\"<br>log_publishing_options {<br>cloudwatch_log_group_arn = aws_cloudwatch_log_group.example.arn<br>log_type                 = \"INDEX_SLOW_LOGS\"<br>}<br>}<br><br>CloudFormation<br><br>Resource: AWS::Elasticsearch::Domain<br>Argument: Properties.LogPublishingOptions.AUDIT_LOGS.Enabled<br><br>YAMLResources:<br>Resource0:<br>Type: 'AWS::Elasticsearch::Domain'<br>Properties:<br>...<br>LogPublishingOptions:<br>AUDIT_LOGS:<br>+         Enabled: True<br>...<br>"
    },
    "CKV_AWS_85": {
        "url": "https://docs.bridgecrew.io/docs/logging_19",
        "severity": "MEDIUM",
        "description": "<h4>AWS DocumentDB logging is not enabled</h4><h4>Description</h4>The events recorded by the AWS DocumentDB audit logs include: successful and failed authentication attempts, creating indexes or dropping a collection in a database within the DocumentDB cluster.<br>AWS CloudWatch logs are a service that monitors, stores and accesses your log files from a variety of sources within your AWS account. When logging is enabled information such as Data Definition Language, authentication, authorization, and user management events are sent to AWS CloudWatch logs. This information can be used to analyze, monitor and archive your Amazon DocumentDB auditing events for security and compliance requirements.<br><h4>Fix - Runtime</h4>AWS Console<br><br>Log in to the AWS Management Console at [https://console.aws.amazon.com/].<br>Open the Amazon DocumentDB.<br>In the navigation pane, choose Clusters.<br>Specify the cluster that you want to modify by choosing the button to the left of the cluster's name.<br>Choose Actions, then click Modify.<br>In the Modify Cluster:  pane.<br>Go to Log Exports and enable exporting audit or profiler logs.<br><br>CLI Command<br>Use the modify-db-cluster operation to modify the specified cluster using the AWS CLI.<br>Shellaws docdb modify-db-cluster \\<br>--db-cluster-identifier sample-cluster \\<br>--cloudwatch-logs-export-configuration '{\"EnableLogTypes\":[\"audit\"]}'<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_docdb_cluster<br>Argument: enabled_cloudwatch_logs_exports - (Optional) List of log types to export to cloudwatch. If omitted, no logs will be exported. The following log types are supported: audit, profiler.<br><br>Goresource \"aws_docdb_cluster\" \"docdb\" {<br>cluster_identifier      = \"my-docdb-cluster\"<br>...<br>+ enabled_cloudwatch_logs_exports  = [\"audit\", \"profiler\"]<br>}<br>"
    },
    "CKV_AWS_86": {
        "url": "https://docs.bridgecrew.io/docs/logging_20",
        "severity": "MEDIUM",
        "description": "<h4>AWS CloudFront distribution has access logging disabled</h4><h4>Description</h4>Cloudfront access logs contain detailed information (requested object name, date and time of the access, client IP, access point, error code, etc) about each request made for your web content. This information can be extremely useful during security audits, or as input data for various analytics/reporting tools.<br>Pairing with Lambda and WAF logs could help expedite a response process and possibly enable blocking requests coming from IP addresses that generate multiple errors. These spikes in errors could possibly indicate they were made by attackers trying to find vulnerabilities within your web application.<br><h4>Fix - Runtime</h4>AWS Cloud Front Console<br>Procedure:<br><br>Log in to the AWS Management Console at [https://console.aws.amazon.com/].<br>Open the AMazon CloudFront console.<br>Select a CloudFront Distribution that is missing access logging.<br>From the menu, click Distribution Settings  to get into the configuration page.<br>From the General tab on the top menu, click Edit.<br>In Distribution Settings tab scroll down and verify the Logging feature configuration status. If Logging is Off then it cannot create log files that contain detailed information about every user request that CloudFront receives.<br>Click ON to initiate the Logging feature of CloudFront to log all viewer requests for files in your distribution.<br><br>CLI Command<br><br>Create an S3 bucket to store your access logs.<br>Create a JSON file to enable logging and set an S3 bucket location to configure a destination for logs files.<br><br>logging{<br>\"ETag\": \"ETAGID001\",<br>\"DistributionConfig\": {<br>...<br>\"Logging\": {<br>\"Bucket\": \"cloudfront-logging.s3.amazonaws.com\",<br>\"Enabled\": true,<br>},<br>}<br>}<br>}<br><br><br>Run update-distribution to update your distribution with your distribution id, the path of the configuration file, and your etag.<br><br>Shellaws cloudfront update-distribution<br>--id ID000000000000<br>--distribution-config logging.json<br>--if-match ETAGID001<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_cloudfront_distribution<br>Argument: logging_config (Optional) - The logging configuration that controls how logs are written to your distribution (maximum one).<br><br>Goresource \"aws_cloudfront_distribution\" \"s3_distribution\" {<br>...<br>default_root_object = \"index.html\"<br>+ logging_config {<br>+   bucket          = \"mylogs.s3.amazonaws.com\"<br>...<br>}<br>}<br><br>CloudFormation<br><br>Resource: AWS::CloudFront::Distribution<br>Argument: Properties.DistributionConfig.Logging/Bucket<br><br>YAMLResources:<br>MyCloudFrontDistribution:<br>Type: 'AWS::CloudFront::Distribution'<br>Properties:<br>...<br>DistributionConfig:<br>...<br>+       Logging:<br>+         Bucket: myawslogbucket.s3.amazonaws.com<br>"
    },
    "CKV_AWS_88": {
        "url": "https://docs.bridgecrew.io/docs/public_12",
        "severity": "HIGH",
        "description": "<h4>AWS EC2 instances aren't automatically made public and given public IP addresses</h4><h4>Description</h4>A public IP address is an IPv4 address that is reachable from the Internet. You can use public addresses for communication between your instances and the Internet. Each instance that receives a public IP address is also given an external DNS hostname.<br>We recommend you control whether your instance receives a public IP address as required.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon VPC console.<br>In the navigation pane, select Subnets.<br>Select a subnet, then select Subnet Actions > Modify auto-assign IP settings.<br>Select auto-assign public IPv4 address. When selected, requests a public IPv4 address for all instances launched into the selected subnet. Select or clear the setting as required.<br>Click Save.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_instance<br>Argument: associate_public_ip_address - (Optional) Associate a public ip address with an instance in a VPC. Boolean value.<br><br>Goresource \"aws_instance\" \"bar\" {<br>...<br>- associate_public_ip_address = true<br>}<br><br>CloudFormation<br><br>Resource: AWS::EC2::Instance / AWS::EC2::LaunchTemplate<br>Argument: NetworkInterfaces.AssociatePublicIpAddress - (Optional) Associate a public ip address with an instance in a VPC. Boolean value.<br><br>YAMLResources:<br>EC2Instance:<br>Type: AWS::EC2::Instance<br>Properties:<br>...<br>NetworkInterfaces:<br>- ...<br>-                   AssociatePublicIpAddress: true<br><br>EC2LaunchTemplate:<br>Type: AWS::EC2::LaunchTemplate<br>Properties:<br>LaunchTemplateData:<br>...<br>NetworkInterfaces:<br>- ...<br>-           AssociatePublicIpAddress: true<br>"
    },
    "CKV_AWS_89": {
        "url": "https://docs.bridgecrew.io/docs/public_13",
        "severity": "HIGH",
        "description": "<h4>DMS replication instance should be publicly accessible</h4><h4>Description</h4>AWS Database Migration Service (AWS DMS) is a service for migrating relational databases, data warehouses, NoSQL databases and other data stores. DMS can be used to migrate data into the AWS Cloud, between on-premises instances, or between combinations of cloud and on-premises environments.<br>An AWS DMS replication instance can have one public IP address and one private IP address, just like an Amazon Elastic Compute Cloud (Amazon EC2) instance that has a public IP address. If you uncheck (disable) the box for Publicly accessible, then the replication instance has only a private IP address.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_dms_replication_instance<br>Argument: publicly_accessible - (Optional, Default: false) Specifies the accessibility options for the replication instance. A value of true represents an instance with a public IP address. A value of false represents an instance with a private IP address.<br><br>Goresource \"aws_dms_replication_instance\" \"test\" {<br>...<br>allocated_storage            = 20<br>+ publicly_accessible          = false<br>}<br><br>CloudFormation<br><br>Resource: AWS::DMS::ReplicationInstance<br>Argument: Properties.PubliclyAccessible - (Optional, Default: false) Specifies the accessibility options for the replication instance. A value of true represents an instance with a public IP address. A value of false represents an instance with a private IP address.<br><br>YAMLResources:<br>ReplicationInstance:<br>Type: AWS::DMS::ReplicationInstance<br>Properties:<br>...<br>+     PubliclyAccessible: False<br>"
    },
    "CKV_AWS_90": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_networking_37",
        "severity": "MEDIUM",
        "description": "<h4>DocDB TLS is disabled</h4><h4>Description</h4>TLS can be used to encrypt the connection between an application and a DocDB cluster. By default, encryption in transit is enabled for newly created clusters. It can optionally be disabled when the cluster is created, or at a later time. When enabled, secure connections using TLS are required to connect to the cluster.<br><h4>Fix - Runtime</h4>AWS Console<br><br>Sign in to the AWS Management Console, and open the Amazon DocumentDB console at https://console.aws.amazon.com/docdb.<br>In the left navigation pane, choose Clusters.<br>In the list of clusters, select the name of your cluster.<br>The resulting page shows the details of the cluster that you selected. Scroll down to Cluster details. At the bottom of that section, locate the parameter group's name below Cluster parameter group.<br><br>CLI Command<br>Shellaws docdb describe-db-clusters \\<br>--db-cluster-identifier sample-cluster \\<br>--query 'DBClusters[*].[DBClusterIdentifier,DBClusterParameterGroup]'<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_docdb_cluster_parameter_group<br>Argument: parameter - (Optional) A list of documentDB parameters to apply.<br><br>Goresource \"aws_docdb_cluster_parameter_group\" \"example\" {<br>...<br>name        = \"example\"<br>+ parameter {<br>+   name  = \"tls\"<br>+   value = \"enabled\"<br>+  }<br>}<br><br>CloudFormation<br><br>Resource: AWS::DocDB::DBClusterParameterGroup<br>Argument: Parameters.tls<br><br>YAMLResources:<br>DocDBParameterGroupEnabled:<br>Type: AWS::DocDB::DBClusterParameterGroup<br>Properties:<br>...<br>Parameters:<br>...<br>-       tls: \"disabled\"<br>+               tls: \"enabled\"<br>"
    },
    "CKV_AWS_91": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_logging_22",
        "severity": "MEDIUM",
        "description": "<h4>AWS ELB (Classic) with access log is disabled</h4><h4>Description</h4>ELBv2 provide access logs that capture information about the TLS requests sent to NLBs. These access logs can be used to analyze traffic patterns and troubleshoot security and operational issues.<br>Access logging is an optional feature of ELB that is disabled by default. There is no additional charge for access logs. You are charged storage costs for Amazon S3, but not charged for the bandwidth.<br>After you enable access logging for your load balancer, ELBv2 captures the logs as compressed files and stores them in the Amazon S3 bucket that you specify.<br><h4>Fix - Runtime</h4>AWS Console<br><br>Go to the Amazon EC2 console at https://console.aws.amazon.com/ec2/.<br>In the navigation pane, choose Load Balancers.<br>Select your load balancer.<br>On the Description tab, choose Edit attributes.<br>On the Edit load balancer attributes page, do the following:<br>For Access logs, choose Enable and specify the name of an existing bucket or a name for a new bucket.<br>Choose Save.<br><br>CLI Command<br>Shellaws elbv2 modify-load-balancer-attributes --load-balancer-arn arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188 --attributes Key=access_logs.s3.enabled,Value=true Key=access_logs.s3.bucket,Value=my-loadbalancer-logs Key=access_logs.s3.prefix,Value=myapp<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_lb<br>Argument: access_logs - (Optional) An Access Logs block. Access Logs documented below.<br><br>Goresource \"aws_lb\" \"test\" {<br>...<br>name               = \"test-lb-tf\"<br>+ access_logs {<br>+   bucket  = aws_s3_bucket.lb_logs.bucket<br>+   prefix  = \"test-lb\"<br>+   enabled = true<br>+ }<br>}<br><br>CloudFormation<br>Resource: AWS::ElasticLoadBalancingV2::LoadBalancer<br>Argument: Properties.LoadBalancerAttributes<br>YAMLResources:<br>Resource0:<br>Type: 'AWS::ElasticLoadBalancingV2::LoadBalancer'<br>Properties:<br>...<br>LoadBalancerAttributes:<br>+     - Key: access_logs.s3.enabled<br>+       Value: \"true\"<br>"
    },
    "CKV_AWS_93": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_s3_24",
        "severity": "MEDIUM",
        "description": "<h4>AWS S3 bucket is not configured with MFA Delete</h4><h4>Description</h4>If a bucket's versioning configuration is MFA Delete: enabled, the bucket owner must include the x-amz-mfa request header to delete an object. Requests that include x-amz-mfa must use HTTPS.<br>Configuring a bucket to enable MFA (multi-factor authentication) Delete requires additional authentication for either of the following operations:<br>(1) Change the versioning state of your bucket<br>(2) Permanently delete an object version.<br>We recommend you configure S3 bucket with MFA Delete: enabled.<br><h4>Fix - Runtime</h4>CLI Command<br>Shellaws s3api put-bucket-versioning --profile my-root-profile --bucket my-bucket-name --versioning-configuration Status=Enabled,MFADelete=Enabled --mfa \u201carn:aws:iam::00000000:mfa/root-account-mfa-device 123456\u201d<br><br><h4>Fix - Buildtime</h4>Terraform<br>Resource:aws_s3_bucket<br>Argument:mfa_delete - (Optional) Enable MFA delete for either Change the versioning state of your bucket or Permanently delete an object version. Default is false. This cannot be used to toggle this setting but is available to allow managed buckets to reflect the state in AWS<br>aws_s3_bucket.b.tfresource \"aws_s3_bucket\" \"b\" {<br>bucket = \"my-tf-test-bucket\"<br>acl    = \"private\"<br><br>versioning {<br>enabled = true<br>+  mfa_delete = true<br>}<br>}<br>"
    },
    "CKV_AWS_96": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_38",
        "severity": "HIGH",
        "description": "<h4>Not all data stored in Aurora is securely encrypted at rest</h4><h4>Description</h4>This policy examines the resource aws_rds_cluster to check that encryption is set up. The property  storage_encrypted is examined.<br><h4>Fix - Runtime</h4>AWS Console<br>TBA<br>CLI Command<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_rds_cluster<br>Argument: storage_encrypted<br><br>aws_rds_cluster.test.tfresource \"aws_rds_cluster\" \"example\" {<br>...<br>cluster_identifier      = \"aurora-cluster-demo\"<br>+ storage_encrypted       = true<br>...<br>}<br><br>CloudFormation<br><br>Resource: AWS::RDS::DBCluster<br>Argument: Properties.StorageEncrypted<br><br>YAMLResources:<br>Aurora:<br>Type: 'AWS::RDS::DBCluster'<br>Properties:<br>...<br>Engine: 'aurora'<br>+     StorageEncrypted: true<br>...<br>"
    },
    "CKV_AWS_97": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_39",
        "severity": "HIGH",
        "description": "<h4>EFS volumes in ECS task definitions do not have encryption in transit enabled</h4><h4>Description</h4>This check examines ECS tasks, and checks the definitions for EFS and if attached that the transit is encrypted.<br><h4>Fix - Runtime</h4>AWS Console<br>TBA<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource:  aws_ecs_task_definition<br>Argument: efs_volume_configuration/transit_encryption needs to ENABLED if there is an attached EFS.<br><br>Goresource \"aws_ecs_task_definition\" \"example\" {<br>...<br>family                = \"service\"<br>volume {<br>...<br>+     transit_encryption      = \"ENABLED\"<br>}<br>}<br>}<br>...<br>}<br><br>CloudFormation<br><br>Resource:  AWS::ECS::TaskDefinition<br>Argument: Properties.Volumes.EFSVolumeConfiguration.TransitEncryption.EFSVolumeConfiguration needs to ENABLED if there is an attached EFS.<br><br>YAMLResources:<br>TaskDefinition:<br>Type: AWS::ECS::TaskDefinition<br>Properties:<br>...<br>Volumes:<br>- ...<br>EFSVolumeConfiguration:<br>...<br>+           TransitEncryption: \"ENABLED\"<br>"
    },
    "CKV_AWS_98": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_40",
        "severity": "HIGH",
        "description": "<h4>AWS SageMaker notebook instance is not configured with data encryption at rest using KMS key</h4><h4>Description</h4>This is a straight-forward check to ensure data encryption for Sagemaker notebooks, this check verifies that the cluster is encrypted with a Customer managed Key (CMK).<br><h4>Fix - Runtime</h4>AWS Console<br>There is no current way of enabling encryption on an existing notebook, it will need to be recreated.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource:  aws_sagemaker_endpoint_configuration<br>Argument: kms_key_arn, specifying a KMS key will ensure data encryption.<br><br>This modification will result in the resource being recreated.<br>aws_sagemaker_endpoint_configuration.examplea.tfresource \"aws_sagemaker_endpoint_configuration\" \"example\" {<br>...<br>name        = \"my-endpoint-config\"<br>+ kms_key_arn = aws_kms_key.examplea.arn<br>production_variants {<br>variant_name           = \"variant-1\"<br>model_name             = aws_sagemaker_model.examplea.name<br>initial_instance_count = 1<br>instance_type          = \"ml.t2.medium\"<br>}<br>...<br>}<br>"
    },
    "CKV2_AWS_12": {
        "url": "https://docs.bridgecrew.io/docs/networking_4",
        "severity": "LOW",
        "description": "<h4>AWS Default Security Group does not restrict all traffic</h4><h4>Description</h4>A VPC comes with a default security group that has an initial setting denying all inbound traffic, allowing all outbound traffic, and allowing all traffic between instances assigned to the security group. If you do not specify a security group when you launch an instance, the instance is automatically assigned to this default security group. Security groups are stateful and provide filtering of ingress/egress network traffic to AWS resources.<br>We recommend that your default security group restricts all inbound and outbound traffic. The default VPC in every region should have its default security group updated to comply with this recommendation. Any newly created VPCs will automatically contain a default security group that will need remediation to comply with this recommendation.<br>Configuring all VPC default security groups to restrict all traffic will encourage least privilege security group development and mindful placement of AWS resources into security groups. This in-turn reduces the exposure of those resources.<br>\ud83d\udcd8NoteWhen implementing this recommendation, VPC flow logging is invaluable in determining the least privilege port access required by systems to work properly.  VPC flow logging can log all packet acceptances and rejections occurring under the current security groups. This dramatically reduces the primary barrier to least privilege engineering, discovering the minimum ports required by systems in the environment. Even if the VPC flow logging recommendation described is not adopted as a permanent security measure, it should be used during any period of discovery and engineering for least privileged security groups.<br><h4>Fix - Runtime</h4>Procedure<br>Security Group Members:<br>To implement the prescribed state, follow these steps:<br><br>Identify AWS resources that exist within the default security group.<br>Create a set of least privilege security groups for those resources.<br>Place the resources in those security groups.<br>Remove the resources noted in Step 1 from the default security group.<br><br>AWS Console<br>Security Group State<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon VPC console.<br>Repeat the next steps for all VPCs, including the default VPC in each AWS region:<br>a) In the left pane, click Security Groups.<br>b) For each default security group, perform the following:<br>i) Select the default security group.<br>ii) Click Inbound Rules.<br>iii) Remove any inbound rules.<br>iv) Click Outbound Rules.<br>v) Remove any outbound rules.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resources: aws_default_security_group + aws_vpc<br>Argument: vpc_id (of aws_default_security_group)<br><br>Goresource \"aws_default_security_group\" \"default\" {<br>vpc_id = aws_vpc.ok_vpc.id<br>}<br>"
    },
    "CKV_AWS_99": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_41",
        "severity": "HIGH",
        "description": "<h4>AWS Glue security configuration encryption is not enabled</h4><h4>Description</h4>Ensure that AWS Glue has encryption enabled. AWS glue has three possible components that could be encrypted: Cloudwatch, job bookmarks and S3 buckets. This check ensures that each is set correctly.<br><h4>Fix - Runtime</h4>AWS Console<br>TBA<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource:  aws_glue_security_configuration<br>Arguments: encryption_configuration, job_bookmarks_encryption, s3_encryption<br><br>aws_glue_security_configuration.test.tfresource \"aws_glue_security_configuration\" \"test\" {<br>name = \"example\"<br>...<br>+ encryption_configuration {<br>+   cloudwatch_encryption {<br>+     cloudwatch_encryption_mode = \"SSE-KMS\"<br>+     kms_key_arn        = aws_kms_key.example.arn<br>+   }<br><br>+   job_bookmarks_encryption {<br>+     job_bookmarks_encryption_mode = \"CSE-KMS\"<br>+     kms_key_arn        = aws_kms_key.example.arn<br>+   }<br><br>+   s3_encryption {<br>+     kms_key_arn        = aws_kms_key.example.arn<br>+     s3_encryption_mode = \"SSE-KMS\"<br>+   }<br>+ }<br>}<br><br>CloudFormation<br><br>Resource:  AWS::Glue::SecurityConfiguration<br>Arguments: Properties.EncryptionConfiguration<br><br>YAMLResources:<br>Resource0:<br>Type: AWS::Glue::SecurityConfiguration<br>Properties:<br>...<br>EncryptionConfiguration:<br>CloudWatchEncryption:<br>+         CloudWatchEncryptionMode: SSE-KMS #any value but 'DISABLED'<br>...<br>JobBookmarksEncryption:<br>+         JobBookmarksEncryptionMode: CSE-KMS #any value but 'DISABLED'<br>...<br>S3Encryptions:<br>+         S3EncryptionMode: SSE-KMS #any value but 'DISABLED'<br>...<br>"
    },
    "CKV_AWS_100": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_kubernetes_5",
        "severity": "HIGH",
        "description": "<h4>Ensure AWS EKS node group does not have implicit SSH access from 0.0.0.0/0</h4><h4>Description</h4>It is generally a good security practice to ensure that your AWS EKS node group does not have implicit SSH access from 0.0.0.0/0, as this means that it is not accessible over the internet via SSH. This can help to protect your EKS node group from unauthorized access, as external parties will not be able to connect to it over the internet.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_eks_node_group<br>Argument: remote_access/source_security_group_ids<br>Makes sure there is no remote access block or the addition of source_security_group_ids<br><br>aws_eks_node_group.test.tfresource \"aws_eks_node_group\" \"test\" {<br>...<br>cluster_name    = aws_eks_cluster.example.name<br>remote_access {<br>ec2_ssh_key = \"some-key\"<br>+    source_security_group_ids = \"some-group\"<br>}<br>}<br><br>CloudFormation<br><br>Resource: AWS::EKS::Nodegroup<br>Argument: Properties.RemoteAccess<br><br>YAMLResources:<br>Nodegroup1:<br>Type: 'AWS::EKS::Nodegroup'<br>Properties:<br>...<br>RemoteAccess:<br>Ec2SshKey: <ssh key><br>+       SourceSecurityGroups:<br>+         - ...<br><br>Nodegroup2:<br>Type: 'AWS::EKS::Nodegroup'<br>Properties:<br>...<br>-     RemoteAccess:<br>-               ...<br>"
    },
    "CKV_AWS_101": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_logging_24",
        "severity": "HIGH",
        "description": "<h4>Neptune logging is not enabled</h4><h4>Description</h4>These logs can be used to analyse traffic patterns and troubleshoot security and operational issues.<br>It is recommended that you set your cluster to optionally export its' logs to AWS Cloudwatch.<br><h4>Fix - Runtime</h4>AWS Console<br>TBA<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_neptune_cluster<br>Argument: enable_cloudwatch_logs_exports<br><br>Goresource \"aws_neptune_cluster\" \"Pike\" {<br>cluster_identifier   = var.DBClusterIdentifier<br><br>...<br>+ enable_cloudwatch_logs_exports      = [\"audit\"]<br>}<br><br>CloudFormation<br><br>Resource: AWS::Neptune::DBCluster<br>Argument: Properties.EnableCloudWatchLogExports<br><br>YAMLType: \"AWS::Neptune::DBCluster\"<br>Properties:<br>...<br>+       EnableCloudwatchLogsExports: [\"audit\"]<br>"
    },
    "CKV_AWS_102": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_42",
        "severity": "HIGH",
        "description": "<h4>Neptune cluster instance is publicly available</h4><h4>Description</h4>Amazon Neptune is a graph database service that for high-performance graph database engine. Neptune supports the popular graph query languages Apache TinkerPop Gremlin and W3C\u2019s SPARQL.<br>Neptune also gives you the ability to create snapshots of your databases, which you can use later to restore a database. You can share a snapshot with a different Amazon Web Services account, and the owner of the recipient account can use your snapshot to restore a DB that contains your data. You can even choose to make your snapshots public \u2013 that is, anybody can restore a DB containing your data.<br>This is a check to make sure that your database resource is not Publicly available. This is the resources' default behaviour. https://docs.aws.amazon.com/neptune/latest/userguide/security-vpc.html. .<br><h4>Fix - Runtime</h4>AWS Console<br>First find your neptune instance id with the AWS commandline:<br>aws neptune describe-db-instances<br><br>Once you have your instance id you can unset its public status with:<br>aws neptune modify-db-instance aws neptune --db-instance-identifier <your db identifier> --no-publicly-accessible<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource:  aws_neptune_cluster_instance<br>Argument:  publicly_accessible this default to false, so the check is to ensure it's missing or false.<br><br>aws_neptune_cluster_instance.example.tfresource \"aws_neptune_cluster_instance\" \"example\" {<br>count              = 2<br>cluster_identifier = aws_neptune_cluster.default.id<br>engine             = \"neptune\"<br>instance_class     = \"db.r4.large\"<br>apply_immediately  = true<br>}<br>"
    },
    "CKV2_AWS_44": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-route-table-with-vpc-peering-does-not-contain-routes-overly-permissive-to-all-traffic",
        "severity": "HIGH",
        "description": "<h4>AWS route table with VPC peering overly permissive to all traffic</h4><h4>Description</h4>This policy identifies VPC route tables with VPC peering connection  which are overly permissive to all traffic. Being highly selective in peering routing tables is a very effective way of minimizing the impact of breach as resources outside of these routes are inaccessible to the peered VPC.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_route\" \"aws_route_pass_1\" {<br>route_table_id            = \"rtb-4fbb3ac4\"<br>destination_cidr_block    = \"10.0.1.0/22\"<br>vpc_peering_connection_id = \"pcx-45ff3dc1\"<br>}<br>"
    },
    "CKV_AWS_107": {
        "url": "https://docs.bridgecrew.io/docs/ensure-iam-policies-do-not-allow-credentials-exposure",
        "severity": "LOW",
        "description": "<h4>Credentials exposure actions return credentials in an API response</h4><h4>Description</h4>AWS IAM users access AWS resources using different types of credentials, such as passwords or access keys. Credentials Exposure actions return credentials as part of the API response, such as ecr:GetAuthorizationToken, iam:UpdateAccessKey, and others.<br>For more info, visit cloudsplaning documentation<br>https://cloudsplaining.readthedocs.io/en/latest/glossary/credentials-exposure/<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_iam_policy_document<br>Argument: effect + actions<br><br>Godata \"aws_iam_policy_document\" \"example\" {<br>statement {<br>sid = \"1\"<br>effect = \"Allow\"<br>actions = [<br>\"lambda:CreateFunction\",<br>\"lambda:CreateEventSourceMapping\",<br>\"dynamodb:CreateTable\",<br>]<br>resources = [<br>\"*\",<br>]<br>}<br>}<br><br>CloudFormation<br><br>Resource: AWS::IAM::Policy / AWS::IAM::ManagedPolicy / AWS::IAM::Group /<br>AWS::IAM::Role / AWS::IAM::User<br>Argument: Effect + Actions<br><br>YAMLResources:<br>AdminDeny:<br>Type: 'AWS::IAM::ManagedPolicy'<br>Properties:<br>...<br>PolicyDocument:<br>...<br>Statement:<br>- Effect: Allow<br>Action:<br>-   'lambda:CreateFunction'<br>-   'lambda:CreateEventSourceMapping'<br>-   'dynamodb:CreateTable'<br>Resource: '*'<br>"
    },
    "CKV_AWS_108": {
        "url": "https://docs.bridgecrew.io/docs/ensure-iam-policies-do-not-allow-data-exfiltration",
        "severity": "INFO",
        "description": "<h4>Data exfiltration allowed without resource constraints</h4><h4>Description</h4>Data Exfiltration actions allow certain read-only IAM actions without resource constraints, such as s3:GetObject, ssm:GetParameter*, or secretsmanager:GetSecretValue.<br>1 - Unrestricted s3:GetObject permissions has a long history of customer data leaks<br>2 - ssm:GetParameter* and secretsmanager:GetSecretValue are both used to access secrets.<br>3 - rds:CopyDBSnapshot and rds:CreateDBSnapshot can be used to exfiltrate RDS database contents.<br>For more information, visit the cloudsplaining documentation<br>https://cloudsplaining.readthedocs.io/en/latest/glossary/data-exfiltration/<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_iam_policy_document<br>Argument: effect + actions<br><br>Godata \"aws_iam_policy_document\" \"example\" {<br>statement {<br>sid = \"1\"<br>effect = \"Allow\"<br>actions = [<br>\"lambda:CreateFunction\",<br>\"lambda:CreateEventSourceMapping\",<br>\"dynamodb:CreateTable\",<br>]<br>resources = [<br>\"*\",<br>]<br>}<br>}<br><br>CloudFormation<br><br>Resource: AWS::IAM::ManagedPolicy<br>Argument: Effect + Actions<br><br>YAMLType: 'AWS::IAM::ManagedPolicy'<br>Properties:<br>...<br>PolicyDocument:<br>...<br>Statement:<br>- Effect: Allow<br>Action:<br>-   'lambda:CreateFunction'<br>-   'lambda:CreateEventSourceMapping'<br>-   'dynamodb:CreateTable'<br>Resource: '*'<br>"
    },
    "CKV_AWS_109": {
        "url": "https://docs.bridgecrew.io/docs/ensure-iam-policies-do-not-allow-permissions-management-resource-exposure-without-constraint",
        "severity": "LOW",
        "description": "<h4>Resource exposure allows modification of policies and exposes resources</h4><h4>Description</h4>This policy allows actions that permit modification of resource-based policies or can otherwise can expose AWS resources to the public via similar actions that can lead to resource exposure.<br>For example:<br>1 - s3:PutBucketPolicy, s3:PutBucketAcl, and s3:PutObjectAcl grant permissions to modify the properties of S3 buckets or objects for new or existing objects in an S3 bucket, which could expose objects to rogue actors or to the internet.<br>2 - ecr:SetRepositoryPolicy could allow an attacker to exfiltrate container images (which sometimes unintentionally contain secrets and non-public information), tamper with container images, or otherwise modify.<br>3 - iam:UpdateAssumeRolePolicy could allow an attacker to create a backdoor by assuming a privileged role in the victim account from an external account.<br>The ability to modify AWS Resource Access Manager, which could allow a malicious actor to share a VPC hosting sensitive or internal services to rogue AWS accounts<br>Attackers can easily exploit Resource Exposure permissions to expose resources to rogue users or the internet, as shown by endgame, an AWS pentesting tool that was also released by Salesforce.<br>For more info, visit cloudsplaning documentation<br>https://cloudsplaining.readthedocs.io/en/latest/glossary/resource-exposure/<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_iam_policy_document<br>Argument: effect + actions<br><br>Godata \"aws_iam_policy_document\" \"example\" {<br>statement {<br>sid = \"1\"<br>effect = \"Allow\"<br>actions = [<br>\"s3:*\"<br>]<br>resources = [<br>\"foo\",<br>]<br>}<br>}<br><br>CloudFormation<br><br>Resource: aws_iam_policy_document<br>Argument: effect + actions<br><br>YAMLType: 'AWS::IAM::ManagedPolicy'<br>Properties:<br>...<br>PolicyDocument:<br>...<br>Statement:<br>- Effect: Allow<br>Action:<br>- 's3:*'<br>Resource: 'foo'<br>"
    },
    "CKV_AWS_111": {
        "url": "https://docs.bridgecrew.io/docs/ensure-iam-policies-do-not-allow-write-access-without-constraint",
        "severity": "LOW",
        "description": "<h4>Write access allowed without constraint</h4><h4>Description</h4>This policy allows actions that permit modification of resource-based policies or can otherwise can expose AWS resources to the public via similar actions that can lead to resource exposure.<br>For example:<br>1 - s3:PutBucketPolicy, s3:PutBucketAcl, and s3:PutObjectAcl grant permissions to modify the properties of S3 buckets or objects for new or existing objects in an S3 bucket, which could expose objects to rogue actors or to the internet.<br>2 - ecr:SetRepositoryPolicy could allow an attacker to exfiltrate container images (which sometimes unintentionally contain secrets and non-public information), tamper with container images, or otherwise modify.<br>3 - iam:UpdateAssumeRolePolicy could allow an attacker to create a backdoor by assuming a privileged role in the victim account from an external account.<br>The ability to modify AWS Resource Access Manager, which could allow a malicious actor to share a VPC hosting sensitive or internal services to rogue AWS accounts<br>Attackers can easily exploit Resource Exposure permissions to expose resources to rogue users or the internet, as shown by endgame, an AWS pentesting tool that was also released by Salesforce.<br>For more info, visit cloudsplaning documentation<br>https://cloudsplaining.readthedocs.io/en/latest/glossary/resource-exposure/<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_iam_policy_document<br>*Argument: effect + actions<br><br>Godata \"aws_iam_policy_document\" \"example\" {<br>statement {<br>sid = \"1\"<br>effect = \"Allow\"<br>actions = [<br>\"s3:*\"<br>]<br><br>resources = [<br>\"foo\",<br>]<br>}<br>}<br>"
    },
    "CKV_AWS_113": {
        "url": "https://docs.bridgecrew.io/docs/ensure-session-manager-logs-are-enabled-and-encrypted",
        "severity": "MEDIUM",
        "description": "<h4>Session Manager logs are not enabled or encrypted</h4><h4>Description</h4>Encrypting your ession Manager logs helps protect your data from unauthorized access or tampering. That way, you can ensure that only authorized users can access and modify the contents of your logs. Such action can help protect against external threats such as hackers or malware, as well as internal threats such as accidental or unauthorized access.<br><h4>Fix - Buildtime</h4>Terraform<br>Resource: aws_ssm_document<br>Argument: cloudWatchStreamingEnabled<br>aws_rds_cluster_parameter_group.examplea.tfresource \"aws_ssm_document\" \"s3_enabled_encrypted\" {<br>name          = \"SSM-SessionManagerRunShell\"<br>document_type = \"Session\"<br><br>content = <<DOC<br>{<br>\"schemaVersion\": \"1.0\",<br>\"description\": \"Document to hold regional settings for Session Manager\",<br>\"sessionType\": \"Standard_Stream\",<br>\"inputs\": {<br>\"s3BucketName\": \"example\",<br>\"s3KeyPrefix\": \"\",<br>\"s3EncryptionEnabled\": true,<br>\"cloudWatchLogGroupName\": \"\",<br>\"cloudWatchEncryptionEnabled\": true,<br>\"idleSessionTimeout\": \"20\",<br>\"cloudWatchStreamingEnabled\": true,<br>\"kmsKeyId\": \"\",<br>\"runAsEnabled\": false,<br>\"runAsDefaultUser\": \"\",<br>\"shellProfile\": {<br>\"windows\": \"\",<br>\"linux\": \"\"<br>}<br>}<br>}<br>DOC<br>}<br>"
    },
    "CKV_AWS_114": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-emr-clusters-have-kerberos-enabled",
        "severity": "LOW",
        "description": "<h4>AWS EMR cluster is not configured with Kerberos authentication</h4><h4>Description</h4>Ensuring that the Kerberos Realm is set can help to improve the security of your EMR clusters by allowing you to more effectively manage and control access to your clusters. For example, you can use the Kerberos Realm to specify which users and groups are allowed to access your clusters, and which actions they are allowed to perform.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_emr_cluster<br>Argument: kerberos_attributes.realm<br><br>Goresource \"aws_emr_cluster\" \"test\" {<br>...<br>kerberos_attributes {<br>kdc_admin_password                = \"somePassword\"<br>+   realm                             = \"EC2.INTERNAL\"<br>}<br>}<br>"
    },
    "CKV_AWS_115": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-aws-lambda-function-is-configured-for-function-level-concurrent-execution-limit",
        "severity": "LOW",
        "description": "<h4>AWS Lambda function is not configured for function-level concurrent execution Limit</h4><h4>Description</h4>Adding concurrency to Lambda initializes that number of execution environments for multiple parallel requests at low latency. However, this could spike costs and open the door for abuse. Adding concurrency limits can prevent a rapid spike in usage and costs, while also increasing or lowering the default concurrency limit.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_lambda_function<br>Argument: reserved_concurrent_executions<br><br>Goresource \"aws_lambda_function\" \"example\" {<br>...<br>+  reserved_concurrent_executions = 100<br>}<br><br>CloudFormation<br><br>Resources: AWS::Lambda::Function, AWS::Serverless::Function<br>Argument: Properties/ReservedConcurrentExecutions<br><br>Type: AWS::Lambda::Function<br>Properties:<br>...<br>ReservedConcurrentExecutions: 100<br>...<br>"
    },
    "CKV_AWS_116": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-aws-lambda-function-is-configured-for-a-dead-letter-queue-dlq",
        "severity": "LOW",
        "description": "<h4>AWS Lambda function is not configured for a DLQ</h4><h4>Description</h4>Setting up a DLQ offers the possibility to investigate errors or failed requests to the connected Lambda function.<br>As an alternative it is possible to configure an on-failure destination target, which forwards a failed event to a DLQ, SNS Topic, Lambda function or EventBridge.<br>It is always important to understand why your application/function failed and to ensure that no data was dropped or compromised. Lambda functions are often used to process security related data like CloudTrail events and a failed delivery to a dependent system can result in an unnoticed security breach.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_lambda_function<br>Argument: dead_letter_config<br><br>Goresource \"aws_lambda_function\" \"test_lambda\" {<br>...<br>+ dead_letter_config {<br>+   target_arn = \"test\"<br>+ }<br>}<br><br>CloudFormation<br><br>Resource: AWS::Lambda::Function<br>Argument: Properties.DeadLetterConfig<br><br>YAMLType: AWS::Lambda::Function<br>Properties:<br>...<br>+ DeadLetterConfig:<br>+   TargetArn: \"test\"<br>"
    },
    "CKV_AWS_117": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-aws-lambda-function-is-configured-inside-a-vpc-1",
        "severity": "LOW",
        "description": "<h4>AWS Lambda Function is not assigned to access within VPC</h4><h4>Description</h4>By default, Lambda runs functions in a secure VPC with access to AWS services and the internet. Lambda owns this VPC, which isn't connected to the account's default VPC. Internet access from a private subnet requires Network Address Translation (NAT).<br>To give your function access to the internet, route outbound traffic to a NAT gateway in a public subnet.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_lambda_function<br>Argument: vpc_config.subnet_ids<br>For network connectivity to AWS resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet through that VPC.<br>subnet_ids - List of subnet IDs associated with the Lambda function.<br>Note: If both subnet_ids and security_group_ids are empty then vpc_config is considered to be empty or unset.<br><br>Goresource \"aws_lambda_function\" \"test_lambda\" {<br>...<br>vpc_config {<br>// Every subnet should be able to reach an EFS mount target in the same Availability Zone.<br>// Cross-AZ mounts are not permitted.<br>+   subnet_ids         = [aws_subnet.subnet_for_lambda.id]<br>security_group_ids = [aws_security_group.sg_for_lambda.id]<br>}<br>}<br>"
    },
    "CKV_AWS_118": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-enhanced-monitoring-is-enabled-for-amazon-rds-instances",
        "severity": "LOW",
        "description": "<h4>Enhanced monitoring for Amazon RDS instances is disabled</h4><h4>Description</h4>Enabling enhanced monitoring for Amazon RDS instances can provide you with additional visibility into the performance and health of your database instances. With enhanced monitoring, you can retrieve real-time performance metrics for your RDS instances at intervals of 1 second, rather than the standard interval of 60 seconds. This can be particularly useful for troubleshooting performance issues, identifying trends in resource utilization, and detecting potential issues before they become problems.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_db_instance<br>Argument: monitoring_interval<br><br>Goresource \"aws_db_instance\" \"default\" {<br>allocated_storage    = 10<br>...<br>+ monitoring_interval  = 5<br>}<br>"
    },
    "CKV_AWS_119": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-dynamodb-tables-are-encrypted",
        "severity": "LOW",
        "description": "<h4>Unencrypted DynamoDB tables</h4><h4>Description</h4>Encrypting your Amazon DynamoDB helps protect your data from unauthorized access or tampering. That way, you can ensure that only authorized users can access and modify the contents of your DBs. Such action can help protect against external threats such as hackers or malware, as well as internal threats such as accidental or unauthorized access.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_dynamodb_table<br>Argument: server_side_encryption<br><br>Goresource \"aws_dynamodb_table\" \"basic-dynamodb-table\" {<br>...<br>server_side_encryption {<br>+    enabled = true<br>+    kms_key_arn= aws_kms_key.dynamo.arn<br>}<br>}<br>"
    },
    "CKV_AWS_122": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-direct-internet-access-is-disabled-for-an-amazon-sagemaker-notebook-instance",
        "severity": "MEDIUM",
        "description": "<h4>AWS SageMaker notebook instance is not configured with direct internet access feature</h4><h4>Description</h4>We recommend that Direct Internet Access is enabled for an Amazon SageMaker Notebook Instances.<br>TBA.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_sagemaker_notebook_instance<br>Argument: direct_internet_access<br><br>Goresource \"aws_sagemaker_notebook_instance\" \"test\" {<br>name          = \"my-notebook-instance\"<br>role_arn      = aws_iam_role.role.arn<br>instance_type = \"ml.t2.medium\"<br>+                 direct_internet_access = \"Disabled\"<br><br>tags = {<br>Name = \"foo\"<br>}<br>}<br>"
    },
    "CKV_AWS_123": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-vpc-endpoint-service-is-configured-for-manual-acceptance",
        "severity": "LOW",
        "description": "<h4>VPC endpoint service is not configured for manual acceptance</h4><h4>Description</h4>Configuring your VPC endpoint service for manual acceptance is recommended because it allows you to review and manually approve or reject incoming connection requests to your VPC. This can be useful for security purposes, as it gives you the ability to review and control which resources are able to connect to your VPC.<br>By default, VPC endpoint services are configured for automatic acceptance, which means that all incoming connection requests are automatically accepted and allowed to connect to your VPC. Configuring your VPC endpoint service for manual acceptance allows you to review and selectively approve or reject incoming connection requests, giving you more control over who can access your VPC.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_vpc_endpoint_service<br>Argument: acceptance_required<br><br>Goresource \"aws_vpc_endpoint_service\" \"example\" {<br>...<br>+   acceptance_required        = true<br>network_load_balancer_arns = [aws_lb.example.arn]<br>}<br><br>CloudFormation<br><br>Resource: AWS::EC2::VPCEndpointService<br>Argument: Properties.AcceptanceRequired<br><br>YAMLType: AWS::EC2::VPCEndpointService<br>Properties:<br>...<br>+     AcceptanceRequired: true<br>"
    },
    "CKV_AWS_124": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-cloudformation-stacks-are-sending-event-notifications-to-an-sns-topic",
        "severity": "LOW",
        "description": "<h4>AWS CloudFormation stack configured without SNS topic</h4><h4>Description</h4>Enabling event notifications for your AWS CloudFormation stacks can help you to monitor and track changes to your stacks. When event notifications are enabled, CloudFormation will send a message to an Amazon Simple Notification Service (SNS) topic each time a stack event occurs. By doing so, you will improve your visibility and automation processes (if desired).<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_cloudformation_stack<br>Argument: notification_arns<br><br>Goresource \"aws_cloudformation_stack\" \"default\" {<br>name = \"networking-stack\"<br>...<br>+  notification_arns = [\"arn1\", \"arn2\"]<br>}<br>"
    },
    "CKV_AWS_126": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-detailed-monitoring-is-enabled-for-ec2-instances",
        "severity": "MEDIUM",
        "description": "<h4>Detailed monitoring for EC2 instances is disabled</h4><h4>Description</h4>Enabling detailed monitoring for Amazon Elastic Compute Cloud (EC2) instances can provide you with additional data and insights about the performance and utilization of your instances. : Detailed monitoring can provide you with more data about the utilization of your instances, which can be helpful for capacity planning and optimization.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_instance<br>Argument: monitoring<br><br>Goresource \"aws_instance\" \"test\" {<br>+  monitoring = true<br>}<br>"
    },
    "CKV_AWS_127": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-elastic-load-balancers-uses-ssl-certificates-provided-by-aws-certificate-manager",
        "severity": "HIGH",
        "description": "<h4>Elastic load balancers do not use SSL Certificates provided by AWS Certificate Manager</h4><h4>Description</h4>SSL helps protect your data from unauthorized access or tampering by encrypting the data that is streamed via your ELB By enabling SSL, you can help ensure that only authorized users with the correct keys can access and decrypt the data, and that the data is protected while in transit.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_elb<br>Argument: ssl_certificate_id<br><br>Goresource \"aws_elb\" \"test\" {<br>...<br>listener {<br>instance_port      = 8000<br>instance_protocol  = \"http\"<br>lb_port            = 443<br>lb_protocol        = \"https\"<br>+   ssl_certificate_id = \"arn:aws:iam::123456789012:server-certificate/certName\"<br>}<br>}<br>"
    },
    "CKV_AWS_129": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-respective-logs-of-amazon-relational-database-service-amazon-rds-are-enabled",
        "severity": "LOW",
        "description": "<h4>Respective logs of Amazon RDS are disabled</h4><h4>Description</h4>It is generally a good security practice to ensure that the respective logs of your Amazon RDS instances are enabled, as this can help you to monitor and track activity on your RDS instances. Logging can provide valuable information about the activity on your RDS instances, including details about connections, queries, and other types of events.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_db_instance<br>Argument: enabled_cloudwatch_logs_exports<br><br>Goresource \"aws_db_instance\" \"mysql\" {<br>allocated_storage = 5<br>...<br>+ enabled_cloudwatch_logs_exports = [\"general\", \"error\", \"slowquery\"]<br>}<br>"
    },
    "CKV_AWS_133": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-rds-instances-have-backup-policy",
        "severity": "MEDIUM",
        "description": "<h4>AWS RDS instance without automatic backup setting</h4><h4>Description</h4>This check examines the attribute backup_retention_period this should have a value 1-35, and checks if its set to 0 which would disable the backup.<br>This check is currently under review and maybe suppressed in future releases.<br><h4>Fix - Runtime</h4>n/a<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_rds_cluster<br>Argument: backup_retention_period<br><br>Goresource \"aws_rds_cluster\" \"test\" {<br>...<br>+ backup_retention_period = 35<br>}<br>"
    },
    "CKV_AWS_138": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-elb-is-cross-zone-load-balancing-enabled",
        "severity": "MEDIUM",
        "description": "<h4>AWS ELB has cross-zone load balancing disabled</h4><h4>Description</h4>Cross-zone load balancing reduces the need to maintain equivalent numbers of instances in each enabled Availability Zone, and improves your application's ability to handle the loss of one or more instances.<br>This would also guarantee better fault tolerance and more consistent traffic flow. If one of the availability zones registered with the ELB fails (as result of network outage or power loss), the load balancer with the Cross-Zone Load Balancing activated would act as a traffic guard, stopping any request being sent to the unhealthy zone and routing it to the other zones.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: xyz<br>Argument: xyz [this will be for composite checks and will indicate a specific resource]<br><br>Goresource \"aws_elb\" \"test_success\" {<br>name               = \"foobar-terraform-elb\"<br>availability_zones = [\"us-west-2a\", \"us-west-2b\", \"us-west-2c\"]<br>access_logs {<br>bucket        = \"foo\"<br>bucket_prefix = \"bar\"<br>interval      = 60<br>}<br>listener {<br>instance_port     = 8000<br>instance_protocol = \"http\"<br>lb_port           = 80<br>lb_protocol       = \"http\"<br>}<br>listener {<br>instance_port      = 8000<br>instance_protocol  = \"http\"<br>lb_port            = 443<br>lb_protocol        = \"https\"<br>ssl_certificate_id = \"arn:aws:iam::123456789012:server-certificate/certName\"<br>}<br>health_check {<br>healthy_threshold   = 2<br>unhealthy_threshold = 2<br>timeout             = 3<br>target              = \"HTTP:8000/\"<br>interval            = 30<br>}<br>instances                   = [aws_instance.foo.id]<br>idle_timeout                = 400<br>connection_draining         = true<br>connection_draining_timeout = 400<br>}<br>\"\"\")<br>resource_conf = hcl_res['resource'][0]['aws_elb']['test_success']<br>scan_result = check.scan_resource_conf(conf=resource_conf)<br>self.assertEqual(CheckResult.PASSED, scan_result)<br><br>def test_success(self):<br>hcl_res = hcl2.loads(\"\"\"<br>resource \"aws_elb\" \"test_success\" {<br>name               = \"foobar-terraform-elb\"<br>availability_zones = [\"us-west-2a\", \"us-west-2b\", \"us-west-2c\"]<br>access_logs {<br>bucket        = \"foo\"<br>bucket_prefix = \"bar\"<br>interval      = 60<br>}<br>listener {<br>instance_port     = 8000<br>instance_protocol = \"http\"<br>lb_port           = 80<br>lb_protocol       = \"http\"<br>}<br>listener {<br>instance_port      = 8000<br>instance_protocol  = \"http\"<br>lb_port            = 443<br>lb_protocol        = \"https\"<br>ssl_certificate_id = \"arn:aws:iam::123456789012:server-certificate/certName\"<br>}<br>health_check {<br>healthy_threshold   = 2<br>unhealthy_threshold = 2<br>timeout             = 3<br>target              = \"HTTP:8000/\"<br>interval            = 30<br>}<br>instances                   = [aws_instance.foo.id]<br>+             cross_zone_load_balancing   = true<br>idle_timeout                = 400<br>connection_draining         = true<br>connection_draining_timeout = 400<br>}<br>"
    },
    "CKV_AWS_139": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-rds-clusters-and-instances-have-deletion-protection-enabled",
        "severity": "LOW",
        "description": "<h4>RDS clusters and instances have deletion protection disabled</h4><h4>Description</h4>Enabling deletion protection on Amazon Relational Database Service (RDS) clusters and instances can help to prevent accidental deletion. When deletion protection is enabled, you cannot delete the RDS cluster or instance using the AWS Management Console, the AWS CLI, or the RDS API. This can be helpful if you want to ensure that your RDS resources are not deleted accidentally, either by yourself or by someone else with access to your AWS account.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_rds_cluster<br>Argument: deletion_protection<br><br>Goresource \"aws_rds_cluster\" \"default\" {<br>...<br>+ deletion_protection = true<br>}<br>"
    },
    "CKV_AWS_140": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-rds-global-clusters-are-encrypted",
        "severity": "LOW",
        "description": "<h4>Unencrypted RDS global clusters</h4><h4>Description</h4>Encrypting your RDS global clusters helps protect your data from unauthorized access or tampering. That way, you can ensure that only authorized users can access and modify the contents of your repositories. Such action can help protect against external threats such as hackers or malware, as well as internal threats such as accidental or unauthorized access.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_rds_global_cluster<br>Argument: storage_encrypted<br><br>Goresource \"aws_rds_global_cluster\" \"example\" {<br>...<br>+ storage_encrypted         = true<br>}<br>"
    },
    "CKV_AWS_143": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-s3-bucket-has-lock-configuration-enabled-by-default",
        "severity": "LOW",
        "description": "<h4>S3 bucket lock configuration disabled</h4><h4>Description</h4>Object Lock is an Amazon S3 feature that blocks object version deletion during a user-defined retention period, to enforce retention policies as an additional layer of data protection and/or for strict regulatory compliance. The feature provides two ways to manage object retention: retention periods and legal holds. A retention period specifies a fixed time frame during which an S3 object remains locked, meaning that it can't be overwritten or deleted. A legal hold implements the same protection as a retention period, but without an expiration date. Instead, a legal hold remains active until you explicitly remove it.<br>Ensure that your Amazon S3 buckets have Object Lock feature enabled in order to prevent the objects they store from being deleted. Used in combination with versioning, which protects objects from being overwritten, AWS S3 Object Lock enables you to store your S3 objects in an immutable form, providing an additional layer of protection against object changes and deletion. S3 Object Lock feature can also help you meet regulatory requirements within your organization when it comes to data protection.<br><h4>Fix - Runtime</h4>AWS Console<br><br>Sign in to AWS Management Console.<br>Navigate to S3 dashboard at https://console.aws.amazon.com/s3/.<br>Click + Create bucket button to start the setup process.<br>Within Create bucket dialog box, perform the following:<br><br><br>For step 1: Name and region:<br>Provide a unique name for the new bucket in the Bucket name box.<br>From Region dropdown box, select the AWS region where the new S3 bucket will be created.<br>From Copy settings from an existing bucket dropdown list, select the name of the S3 bucket that you want to re-create.<br>Click Next to continue the process.<br><br>For step 2: Configure options:<br>Under Versioning, select Keep all versions of an object in the same bucket checkbox to enable S3 versioning for the bucket. S3 Object Lock requires S3 object versioning.<br>Click the Advanced settings tab to shown the advanced configuration settings.<br>Under Object lock, select Permanently allow objects in this bucket to be locked checkbox to enable S3 Object Lock feature for the new bucket.<br>Click Next.<br><br>For step 3: Set permissions, set any required permissions or leave the settings unchanged to reflect the source bucket permissions configuration. Click Next to continue.<br>For step 4: Review, verify the resource configuration details, then click Create bucket to create the new S3 bucket.<br><br><br><br>Click on the name of the S3 bucket created at the previous step.<br>Select the Properties tab from the S3 dashboard top menu to view bucket properties.<br>In the Advanced settings section, click on the Object Lock box to access the feature configuration panel, where you can define the automatic settings for the objects that are uploaded without object lock configuration.<br>Inside Object Lock box, select one of the following retention modes. These retention modes apply different levels of protection to the objects within the selected bucket:<br><br><br>Select Enable governance mode so that users cannot overwrite or delete an S3 object version or alter its lock settings unless they have special permissions (e.g. root account). Governance mode enables you to protect objects against deletion by most users while still allowing you to grant some users permission to alter the retention settings or delete the object if required. In the Retention period box, enter the number of days required to protect an object version. Click Save to apply the changes.<br>Select Enable compliance mode so that a protected object version cannot be overwritten or deleted by any user, including the root account user. Once an S3 object is locked in Compliance mode, its retention mode cannot be reconfigured and its retention period cannot be shortened. This retention mode ensures that an object version can't be overwritten or deleted for the duration of the retention period, specified in the Retention period box. Click Save to apply the changes.<br><br><br>Now you can transfer the necessary S3 objects from the source bucket, the one with Object Lock feature disabled, to the destination bucket, the one that has Object Lock enabled.<br>Repeat steps no. 3 \u2013 9 to enable and configure Amazon S3 Object Lock for other S3 buckets available within your AWS account.<br><br>CLI Command<br><br>Run create-bucket command (OSX/Linux/UNIX) to (re)create the required Amazon S3 bucket and enable S3 Object Lock feature for all the objects uploaded to this bucket, by using the --object-lock-enabled-for-bucket command parameter:<br><br>Shellaws s3api create-bucket<br>--bucket cc-project5-protected-logs<br>--region us-east-1<br>--acl private<br>--object-lock-enabled-for-bucket<br><br><br>The command output should return the name of the new Amazon S3 bucket:<br><br>Shell{<br>\"Location\": \"/cc-project5-protected-logs\"<br>}<br><br><br>Define the Object Lock feature configuration parameters by specifying the retention mode and retention period for the new S3 bucket. The following example enables Governance retention mode for 90 days. Governance mode ensures that users cannot overwrite or delete an S3 object version or alter its lock settings unless they have special permissions (e.g. root account access). Governance mode enables you to protect objects against deletion by most users while still allowing you to grant some users permission to alter the retention settings or delete the object if required. Save these configuration parameters to a JSON file named object-lock-config.json:<br><br>Shell{<br>\"ObjectLockEnabled\": \"Enabled\",<br>\"Rule\": {<br>\"DefaultRetention\": {<br>\"Mode\": \"GOVERNANCE\",<br>\"Days\": 90<br>}<br>}<br>}<br><br><br>Run put-object-lock-configuration command (OSX/Linux/UNIX) using the configuration parameters defined at the previous step (i.e. object-lock-config.json) to apply your S3 Object Lock configuration to the newly created bucket (the command does not produce an output):<br><br>Shellaws s3api put-object-lock-configuration<br>--bucket cc-project5-protected-logs<br>--object-lock-configuration file://object-lock-config.json<br><br><br><br>Transfer the necessary S3 objects from the source bucket, the one with Object Lock feature disabled, to the destination bucket, the one with S3 Object Lock enabled, created at the previous steps.<br><br><br>Repeat steps no. 1 \u2013 5 to enable and configure Amazon S3 Object Lock for other S3 buckets available in your AWS account.<br><br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_s3_bucket<br>Argument: object_lock_enabled<br><br>Goresource \"aws_s3_bucket\" \"test\" {<br>...<br>+  object_lock_configuration = {<br>+     object_lock_enabled = \"Enabled\"<br>+  }<br>}<br>"
    },
    "CKV_AWS_57": {
        "url": "https://docs.bridgecrew.io/docs/s3_2-acl-write-permissions-everyone",
        "severity": "CRITICAL",
        "description": "<h4>AWS S3 bucket is publicly writable</h4><h4>Description</h4>Unprotected S3 buckets are one of the major causes of data theft and intrusions. An S3 bucket that allows WRITE access to everyone allows attackers to create, overwrite and delete objects within the bucket, which can lead to: S3 data loss, unintended changes to applications using that bucket, and unexpected charges. The only S3 buckets that should be globally accessible for unauthenticated users or for Any AWS Authenticate Users are those used for hosting static websites. Bucket ACL helps manage access to S3 bucket data.<br>We recommend AWS S3 buckets are not publicly accessible for WRITE actions to protect S3 data from unauthorized users and exposing sensitive data to public access.<br><h4>Fix - Runtime</h4>Procedure<br>S3 buckets should be protected by using the bucket ACL and bucket policies. If you want to share data with other users via S3 buckets, you could create pre-signed URLs with a short expiration duration.<br>To generate a pre-signed URL for the file samplefile.zip, use the following command:<br>Bashaws s3 presign --expires-in 36000 s3://sharedfolder/samplefile.zip<br><br>To generate pre-signed URLS for every object in an S3 bucket, use the following command:<br>Bashaws s3 ls --recursive s3://sharedfolder | awk '{print $4}' |<br>while read line; do aws s3 presign --expires-in 36000 s3://sharedfolder/$line; done<br><br>\ud83d\udcd8NoteFor all automation-related work use the bucket policy and grant access to the required roles.<br><h4>Fix - Buildtime</h4>CloudFormation<br><br>Resource: AWS::S3::Bucket<br>Argument: Properties.AccessControl<br><br>YAMLType: AWS::S3::Bucket<br>Properties:<br>...<br>-     AccessControl: PublicReadWrite<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_s3_bucket<br>Argument: acl<br><br>aws_s3_bucket.fail.tfresource \"aws_s3_bucket\" \"fail\" {<br>- acl    = \"public-read-write\"<br>bucket = \"superfail\"<br><br>versioning {<br>enabled    = false<br>mfa_delete = false<br>}<br><br>policy = <<POLICY<br>{<br>\"Version\":\"2012-10-17\",<br>\"Statement\":[<br>{<br>\"Sid\":\"AddCannedAcl\",<br>\"Effect\":\"Allow\",<br>\"Principal\": {\"AWS\": [\"*\"]},<br>\"Action\":[\"s3:PutObject\",\"s3:PutObjectAcl\"],<br>\"Resource\":\"arn:aws:s3:::DOC-EXAMPLE-BUCKET/*\",<br>\"Condition\":{\"StringEquals\":{\"s3:x-amz-acl\":[\"public-read\"]}}<br>}<br>]<br>}<br>POLICY<br>}<br><br>Replace the acl with \"private\" instead of \"public-read-write\", or remove entirely as the default is private.<br>"
    },
    "CKV_AWS_131": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-alb-drops-http-headers",
        "severity": "MEDIUM",
        "description": "<h4>ALB does not drop HTTP headers</h4><h4>Description</h4>Ensure that Drop Invalid Header Fields feature is enabled for your Amazon Application Load Balancers (ALBs) in order to follow security best practices and meet compliance requirements. If Drop Invalid Header Fields security feature is enabled, HTTP headers with header fields that are not valid are removed by the Application Load Balancer instead of being routed to the associated targets.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_alb<br>Argument: drop_invalid_header_fields<br><br>Goresource \"aws_alb\" \"test_success\" {<br>name               = \"test-lb-tf\"<br>internal           = false<br>load_balancer_type = \"network\"<br>subnets            = aws_subnet.public.*.id<br>+                  drop_invalid_header_fields = true<br>}<br>"
    },
    "CKV_AWS_134": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-amazon-elasticache-redis-clusters-have-automatic-backup-turned-on",
        "severity": "LOW",
        "description": "<h4>Amazon ElastiCache Redis clusters do not have automatic backup turned on</h4><h4>Description</h4>Amazon ElastiCache clusters running Redis can back up their data. Using automated backup, you can restore a cluster or seed a new cluster. The backup consists of the cluster's metadata, along with all of the data in the cluster.<br>You can enable or disable automatic backups on an existing Redis cluster or replication group by modifying it using the ElastiCache console, the AWS CLI, or the ElastiCache API. For any Redis cluster, you can enable automatic backups. When automatic backups are enabled, ElastiCache creates a backup of the cluster on a daily basis. There is no impact on the cluster and the change is immediate.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_elasticache_cluster<br>Argument: snapshot_retention_limit<br><br>Goresource \"aws_elasticache_cluster\" \"example\" {<br>...<br>+ snapshot_retention_limit = 5<br>}<br>"
    },
    "CKV_AWS_135": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-ec2-is-ebs-optimized",
        "severity": "LOW",
        "description": "<h4>EC2 EBS is not optimized</h4><h4>Description</h4>Ensuring that EC2 instances are EBS-optimized will help to deliver enhanced performance for EBS workloads. They provide dedicated throughput to Amazon Elastic Block Store (EBS) volumes, which can result in improved EBS performance. Additionally, EBS-optimized instances use a separate network connection for EBS traffic, which can reduce network latency and improve the performance of EBS-intensive workloads.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_instance<br>Argument: ebs_optimized<br><br>Goresource \"aws_instance\" \"foo\" {<br>...<br>+ ebs_optimized = true<br>}<br>"
    },
    "CKV_AWS_136": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-ecr-repositories-are-encrypted",
        "severity": "LOW",
        "description": "<h4>Unencrypted ECR repositories</h4><h4>Description</h4>Encrypting your ECR repositories helps protect your data from unauthorized access or tampering. That way, you can ensure that only authorized users can access and modify the contents of your repositories. Such action can help protect against external threats such as hackers or malware, as well as internal threats such as accidental or unauthorized access.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_ecr_repository<br>Argument: encryption_configuration.encryption_type<br><br>Goresource \"aws_ecr_repository\" \"example\" {<br>...<br>name                 = \"bar\"<br>+ encryption_configuration {<br>+   encryption_type = \"KMS\"<br>+ }<br>}<br><br>CloudFormation<br><br>Resource: AWS::ECR::Repository<br>Argument: Properties.EncryptionConfiguration.EncryptionType<br><br>YAMLResources:<br>KMSEncryption:<br>Type: AWS::ECR::Repository<br>Properties:<br>...<br>+     EncryptionConfiguration:<br>+       EncryptionType: \"KMS\"<br>...<br>"
    },
    "CKV_AWS_137": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-elasticsearch-is-configured-inside-a-vpc",
        "severity": "LOW",
        "description": "<h4>AWS ElasticSearch cluster is not in a VPC</h4><h4>Description</h4>AWS Elasticsearch domains that reside within a VPC have an extra layer of security when compared to ES domains that use public endpoints. Launching an Amazon ES cluster within an AWS VPC enables secure communication between the ES cluster (domain) and other AWS services without the need for an Internet Gateway, a NAT device or a VPN connection and all traffic remains secure within the AWS Cloud.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_elasticsearch_domain<br>Argument: vpc_options<br><br>Goresource \"aws_elasticsearch_domain\" \"es\" {<br>domain_name           = var.domain<br>elasticsearch_version = \"6.3\"<br><br>cluster_config {<br>instance_type = \"m4.large.elasticsearch\"<br>}<br><br>+         vpc_options {<br>+           subnet_ids = [<br>+             data.aws_subnet_ids.selected.ids[0],<br>+             data.aws_subnet_ids.selected.ids[1],<br>+           ]<br><br>security_group_ids = [aws_security_group.es.id]<br>}<br><br>}<br>"
    },
    "CKV2_AWS_47": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-cloudfront-attached-wafv2-webacl-is-configured-with-amr-for-log4j-vulnerability",
        "severity": "MEDIUM",
        "description": "<h4>AWS CloudFront attached WAFv2 WebACL is not configured with AMR for Log4j Vulnerability</h4><h4>Description</h4>This policy identifies AWS CloudFront attached with WAFv2 WebACL which is not configured with AWS Managed Rules (AMR) for Log4j Vulnerability. As per the guidelines given by AWS, CloudFront attached with WAFv2 WebACL should be configured with AWS Managed Rules (AMR) AWSManagedRulesKnownBadInputsRuleSet and AWSManagedRulesAnonymousIpList to protect from Log4j Vulnerability (CVE-2021-44228).\\n\\nFor more information please refer below URL,\\nhttps://aws.amazon.com/security/security-bulletins/AWS-2021-006/<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_cloudfront_distribution\" \"pass\" {<br>origin {<br>domain_name              = aws_s3_bucket.b.bucket_regional_domain_name<br>origin_access_control_id = aws_cloudfront_origin_access_control.default.id<br>origin_id                = local.s3_origin_id<br>}<br><br>enabled             = true<br>is_ipv6_enabled     = true<br>comment             = \"Some comment\"<br>default_root_object = \"index.html\"<br><br>aliases = [\"mysite.example.com\", \"yoursite.example.com\"]<br><br>default_cache_behavior {<br>allowed_methods  = [\"DELETE\", \"GET\", \"HEAD\", \"OPTIONS\", \"PATCH\", \"POST\", \"PUT\"]<br>cached_methods   = [\"GET\", \"HEAD\"]<br>target_origin_id = local.s3_origin_id<br><br>forwarded_values {<br>query_string = false<br><br>cookies {<br>forward = \"none\"<br>}<br>}<br><br>viewer_protocol_policy = \"allow-all\"<br>min_ttl                = 0<br>default_ttl            = 3600<br>max_ttl                = 86400<br>}<br><br># Cache behavior with precedence 0<br>ordered_cache_behavior {<br>path_pattern     = \"/content/immutable/*\"<br>allowed_methods  = [\"GET\", \"HEAD\", \"OPTIONS\"]<br>cached_methods   = [\"GET\", \"HEAD\", \"OPTIONS\"]<br>target_origin_id = local.s3_origin_id<br><br>forwarded_values {<br>query_string = false<br>headers      = [\"Origin\"]<br><br>cookies {<br>forward = \"none\"<br>}<br>}<br><br>min_ttl                = 0<br>default_ttl            = 86400<br>max_ttl                = 31536000<br>compress               = true<br>viewer_protocol_policy = \"redirect-to-https\"<br>}<br><br>price_class = \"PriceClass_200\"<br><br>restrictions {<br>geo_restriction {<br>restriction_type = \"whitelist\"<br>locations        = [\"US\", \"CA\", \"GB\", \"DE\"]<br>}<br>}<br><br>tags = {<br>Environment = \"production\"<br>}<br><br>viewer_certificate {<br>cloudfront_default_certificate = true<br>}<br>web_acl_id = aws_wafv2_web_acl.pass_acl.arn<br>}<br><br>resource \"aws_wafv2_web_acl\" \"pass_acl\" {<br>name        = \"managed-rule-example\"<br>description = \"Example of a managed rule.\"<br>scope       = \"REGIONAL\"<br><br>default_action {<br>allow {}<br>}<br><br>rule {<br>name     = \"rule-1\"<br>priority = 1<br><br>override_action {<br>count {}<br>}<br><br>statement {<br>managed_rule_group_statement {<br>name        = \"AWSManagedRulesAnonymousIpList\"<br>vendor_name = \"AWS\"<br><br>excluded_rule {<br>name = \"SizeRestrictions_QUERYSTRING\"<br>}<br><br>scope_down_statement {<br>geo_match_statement {<br>country_codes = [\"US\", \"NL\"]<br>}<br>}<br>}<br>}<br><br>visibility_config {<br>cloudwatch_metrics_enabled = false<br>metric_name                = \"friendly-rule-metric-name\"<br>sampled_requests_enabled   = false<br>}<br>}<br><br>rule {<br>name     = \"rule-2\"<br>priority = 2<br><br>override_action {<br>count {}<br>}<br><br>statement {<br>managed_rule_group_statement {<br>name        = \"AWSManagedRulesKnownBadInputsRuleSet\"<br>vendor_name = \"AWS\"<br><br>excluded_rule {<br>name = \"SizeRestrictions_QUERYSTRING\"<br>}<br><br>scope_down_statement {<br>geo_match_statement {<br>country_codes = [\"US\", \"NL\"]<br>}<br>}<br>}<br>}<br><br>visibility_config {<br>cloudwatch_metrics_enabled = false<br>metric_name                = \"friendly-rule-metric-name\"<br>sampled_requests_enabled   = false<br>}<br>}<br><br><br>tags = {<br>Tag1 = \"Value1\"<br>Tag2 = \"Value2\"<br>}<br><br>visibility_config {<br>cloudwatch_metrics_enabled = false<br>metric_name                = \"friendly-metric-name\"<br>sampled_requests_enabled   = false<br>}<br>}<br>"
    },
    "CKV_AWS_42": {
        "url": "https://docs.bridgecrew.io/docs/general_17",
        "severity": "MEDIUM",
        "description": "<h4>AWS EFS with encryption for data at rest is disabled</h4><h4>Description</h4>Amazon Elastic File System (Amazon EFS) is a simple, scalable file storage solution for AWS services and on-premises resources. Amazon EFS is built to elastically scale on-demand. It grows and shrinks automatically as files are added and removed.<br>It is essential to encrypt your Amazon EFS to protect data and metadata against unauthorized access. Encrypting your Amazon EFS also fulfils compliance requirements for data-at-rest encryption when file systems are used in production systems.<br><h4>Fix - Runtime</h4>Amazon Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon Elastic File System console.<br>To open the file system creation wizard, click Create file system.<br>Select Enable encryption.<br>To enable encryption using your own KMS CMK key, from the KMS master key list select the name of your AWS Key.<br><br>CLI Command<br>In the CreateFileSystem operation, the --encrypted parameter is a Boolean and is required for creating encrypted file systems. The --kms-key-id is required only when you use a customer-managed CMK and you include the key\u2019s alias or ARN.<br>Shellaws efs create-file-system \\<br>--creation-token $(uuidgen) \\<br>--performance-mode generalPurpose \\<br>--encrypted \\<br>--kms-key-id user/customer-managedCMKalias<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_efs_file_system<br>Arguments: encrypted - (Optional) If true, the disk will be encrypted. If you are using AWS KMS you can optionally provides a KMS customer master key.<br><br>aws_efs_file_systemresource \"aws_efs_file_system\" \"example\"{<br>...<br>creation_token                = \"default-efs\"<br>+ encrypted                   = true<br>+ kms_key_id = aws_kms_key.default-kms.arn<br>}<br><br>CloudFormation<br><br>Resource: AWS::EFS::FileSystem<br>Arguments: Encrypted - (Optional) If true, the disk will be encrypted. If you are using AWS KMS you can optionally provides a KMS customer master key.<br><br>YAMLResources:<br>FileSystemResource:<br>Type: 'AWS::EFS::FileSystem'<br>Properties:<br>...<br>+     Encrypted: true<br>"
    },
    "CKV_AWS_141": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-redshift-clusters-allow-version-upgrade-by-default",
        "severity": "LOW",
        "description": "<h4>Redshift clusters version upgrade is not default</h4><h4>Description</h4>With Allow Version Upgrade feature enabled, the Amazon Redshift engine upgrades (also known as major version upgrades) will occur automatically so the data warehouse service engine can get the newest features, bug fixes or the latest security patches released.<br><h4>Fix - Runtime</h4>CLI Command<br><br>Run modify-cluster command (OSX/Linux/UNIX) using the name of the cluster that you want to update as identifier (see Audit section part II, step no. 2) to enable AWS Redshift engine version upgrades for the selected cluster:<br><br>Shellaws redshift modify-cluster<br>--region us-east-1<br>--cluster-identifier cc-cluster<br>--allow-version-upgrade<br><br><br>If successful, the command output should return the Redshift cluster new configuration metadata:<br><br>Shell{<br>\"Cluster\": {<br>\"PubliclyAccessible\": true,<br>\"NumberOfNodes\": 1,<br>\"PendingModifiedValues\": {},<br>\"VpcId\": \"vpc-2eb53422\",<br>\"ClusterVersion\": \"1.0\",<br>\"AutomatedSnapshotRetentionPeriod\": 1,<br>\"ClusterParameterGroups\": [<br>...<br>\"AllowVersionUpgrade\": true,<br>...<br>\"ClusterSubnetGroupName\": \"default\",<br>\"ClusterSecurityGroups\": [],<br>\"ClusterIdentifier\": \"cc-cluster\",<br>\"AvailabilityZone\": \"us-east-1a\",<br>\"NodeType\": \"ds1.xlarge\",<br>\"ClusterStatus\": \"available\"<br>}<br>}<br><br><br><br>Repeat step no. 1 and 2 for other Redshift clusters with engine version upgrades disabled, available in the current region.<br><br><br>Change the AWS region by updating the --region command parameter value and repeat steps no. 1 - 3 for other regions.<br><br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_redshift_cluster<br>Argument: allow_version_upgrade<br><br>Goresource \"aws_redshift_cluster\" \"default\" {<br>...<br>+ allow_version_upgrade = true<br>}<br>"
    },
    "CKV_AWS_142": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-redshift-cluster-is-encrypted-by-kms",
        "severity": "MEDIUM",
        "description": "<h4>Redshift cluster is not encrypted by KMS</h4><h4>Description</h4>Encrypting your data and resources with KMS helps protect your data from unauthorized access or tampering. By encrypting your data, you can ensure that only authorized users can access and decrypt the data, and that the data is protected while in storage or in transit. Such action can help protect against external threats such as hackers or malware, as well as internal threats such as accidental or unauthorized access.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_redshift_cluster<br>Argument: kms_key_id<br><br>Goresource \"aws_redshift_cluster\" \"test\" {<br>...<br>+ kms_key_id         = \"someKey\"<br>}<br>"
    },
    "CKV_AWS_92": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_logging_23",
        "severity": "MEDIUM",
        "description": "<h4>The ELB does not have access logging enabled</h4><h4>Description</h4>These access logs can be used to analyze traffic patterns and troubleshoot security and operational issues.<br>Access logging is an optional feature of ELB that is disabled by default.<br><h4>Fix - Runtime</h4>AWS Console<br>TBA<br>CLI Command<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_elb<br>Argument: access_logs<br><br>aws_elb.test.tfresource \"aws_elb\" \"example\" {<br>...<br>name = \"test-lb-tf\"<br>+  access_logs {<br>+     bucket  = aws_s3_bucket.lb_logs.bucket<br>+     enabled = true<br>+  }<br>}<br><br>CloudFormation<br><br>Resource: AWS::ElasticLoadBalancing::LoadBalancer<br>Argument: Properties.AccessLoggingPolicy.Enabled<br><br>YAMLResources:<br>Resource0:<br>Type: 'AWS::ElasticLoadBalancing::LoadBalancer'<br>Properties:<br>...<br>AccessLoggingPolicy:<br>...<br>+       Enabled: true<br>"
    },
    "CKV_AWS_94": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_37",
        "severity": "HIGH",
        "description": "<h4>Glue Data Catalog encryption is not enabled</h4><h4>Description</h4>This examines the resource aws_glue_data_catalog_encryption_settings and checks that encryption is set up. The properties encrypted_at_rest and connection_encrypted in the blocks connection_password_encryption and encryption_at_rest are examined.<br><h4>Fix - Runtime</h4>AWS Console<br>TBA<br>CLI Command<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource aws_glue_data_catalog_encryption_settings<br>Arguments data_catalog_encryption_settings\\connection_password_encryption and data_catalog_encryption_settings\\encryption_at_rest blocks<br><br>aws_glue_data_catalog_encryption_settings.examplea.tfresource \"aws_glue_data_catalog_encryption_settings\" \"example\" {<br>...<br>+  data_catalog_encryption_settings {<br>+    connection_password_encryption {<br>+      aws_kms_key_id                       = aws_kms_key.glue.arn<br>+      return_connection_password_encrypted = true<br>+    }<br>+    encryption_at_rest {<br>+      catalog_encryption_mode = \"SSE-KMS\"<br>+      sse_aws_kms_key_id      = aws_kms_key.glue.arn<br>+    }<br>+  }<br>...<br>}<br><br>CloudFormation<br><br>Resource AWS::Glue::DataCatalogEncryptionSettings<br>Arguments Properties.DataCatalogEncryptionSettings<br><br>YAMLResources:<br>Example:<br>Type: 'AWS::Glue::DataCatalogEncryptionSettings'<br>Properties:<br>...<br>DataCatalogEncryptionSettings:<br>ConnectionPasswordEncryption:<br>...<br>+         ReturnConnectionPasswordEncrypted: True<br>EncryptionAtRest:<br>...<br>+         CatalogEncryptionMode: \"SSE-KMS\"<br>"
    },
    "CKV_AWS_157": {
        "url": "https://docs.bridgecrew.io/docs/general_73",
        "severity": "LOW",
        "description": "<h4>RDS instances do not have Multi-AZ enabled</h4><h4>Description</h4>Amazon RDS Multi-AZ deployments provide enhanced availability for databases within a single region. In the event of a planned or unplanned outage of your DB instance, Amazon RDS automatically switches to a standby replica in another Availability Zone if you have enabled Multi-AZ.<br>RDS Multi-AZ deployments offer the following benefits:<br><br>Enhanced durability.<br>Increased availability.<br>Protection of your database performance.<br>Automatic failover.<br><br><h4>Fix - Runtime</h4>AWS Console<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon RDS console.<br>To create a new Multi-AZ deployment using the AWS Management Console, simply click the \"Yes\" option for \"Multi-AZ Deployment\" when launching a DB Instance.<br>To convert an existing Single-AZ DB Instance to a Multi-AZ deployment, use the \"Modify\" option corresponding to your DB Instance in the AWS Management Console.<br><br>CLI Command<br>If you use the create-db-instance AWS CLI command to create a Multi-AZ DB instance, set the --multi-az parameter to true. If you use the CreateDBInstance API operation, set the MultiAZ parameter to true. You can't set the AvailabilityZone parameter if the DB instance is a Multi-AZ deployment.<br>Shellaws rds create-db-instance \\<br>--db-instance-identifier test-mysql-instance \\<br>--db-instance-class db.t3.micro \\<br>--engine mysql \\<br>--master-username admin \\<br>--master-user-password secret99 \\<br>--allocated-storage 20 \\<br>--multi-az true<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_db_instance<br>Argument: multi_az - Specifies if the RDS instance is Multi-AZ.<br><br>Goresource \"aws_db_instance\" \"default\" {<br>...<br>name                 = \"mydb\"<br>+ multi_az             = true<br>}<br><br>CloudFormation<br><br>Resource: AWS::RDS::DBInstance<br>Argument: Properties.MultiAZ<br><br>YAMLResources:<br>MyDBEnabled:<br>Type: 'AWS::RDS::DBInstance'<br>Properties:<br>...<br>+     MultiAZ: true<br>"
    },
    "CKV2_AWS_14": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-iam-groups-include-at-least-one-iam-user",
        "severity": "LOW",
        "description": "<h4>IAM groups do not include at least one IAM user</h4><h4>Description</h4>It is generally a best practice to include at least one IAM user in each IAM group. This can help to ensure that there is at least one user who has the permissions associated with the group, which can be useful if you need to delegate certain tasks or responsibilities.<br>Additionally, including at least one IAM user in each group can also make it easier to manage the permissions for those users. For example, if you need to change the permissions associated with a group, you can simply update the group's policy rather than updating the policies for each individual user.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_iam_group_membership, aws_iam_group, aws_iam_user<br>Argument: name and users of aws_iam_group_membership<br><br>Goresource \"aws_iam_group_membership\" \"ok_group\" {<br>name = \"tf-testing-group-membership\"<br><br>users = [<br>aws_iam_user.user_one.name,<br>aws_iam_user.user_two.name,<br>]<br><br>group = aws_iam_group.group.name<br>}<br><br>resource \"aws_iam_group\" \"group\" {<br>name = \"test-group\"<br>}<br><br>resource \"aws_iam_user\" \"user_one\" {<br>name = \"test-user\"<br>}<br><br>resource \"aws_iam_user\" \"user_two\" {<br>name = \"test-user-two\"<br>}<br>"
    },
    "CKV2_AWS_37": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-codecommit-is-associated-with-an-approval-rule",
        "severity": "LOW",
        "description": "<h4>AWS Codecommit is not associated with an approval rule</h4><h4>Description</h4>Associating AWS Codecommit with an approval rule ensures that code changes are reviewed by other team members before being merged into the main branch of a repository. This can help identify problems or issues with the code before it is deployed, and can also serve as a means of knowledge sharing among team members.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_codecommit_repository\" \"pass\" {<br>repository_name = \"MyTestRepository\"<br>description     = \"This is the Sample App Repository\"<br>}<br><br>resource \"aws_codecommit_approval_rule_template_association\" \"example\" {<br>approval_rule_template_name = aws_codecommit_approval_rule_template.example.name<br>repository_name             = aws_codecommit_repository.pass.repository_name<br>}<br>"
    },
    "CKV_AWS_145": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-s3-buckets-are-encrypted-with-kms-by-default",
        "severity": "LOW",
        "description": "<h4>S3 buckets are not encrypted with KMS</h4><h4>Description</h4>Encrypting your data and resources with KMS helps protect your data from unauthorized access or tampering. By encrypting your data, you can ensure that only authorized users can access and decrypt the data, and that the data is protected while in storage or in transit. Such action can help protect against external threats such as hackers or malware, as well as internal threats such as accidental or unauthorized access.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_s3_bucket<br><br>Goresource \"aws_s3_bucket\" \"bucket_name\" {<br>bucket = \"bucket_good\"<br>}<br><br>+ resource \"aws_s3_bucket_server_side_encryption_configuration\" \"good_sse_1\" {<br>+   bucket = aws_s3_bucket.bucket_name.bucket<br>+<br>+   rule {<br>+     apply_server_side_encryption_by_default {<br>+       kms_master_key_id = aws_kms_key.mykey.arn<br>+       sse_algorithm     = \"aws:kms\"<br>+     }<br>+   }<br>+ }<br>"
    },
    "CKV2_AWS_32": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_networking_65",
        "severity": "LOW",
        "description": "<h4>AWS CloudFront distribution does not have a strict security headers policy attached</h4><h4>Description</h4>Amazon CloudFront is a content delivery network (CDN) that delivers static and dynamic web content using a global network of edge locations. CloudFront introduced response headers policies to address this need and give the customers more control in defining header modifications performed by CloudFront. While it has been possible to manipulate response headers with CloudFront\u2019s edge serverless options, typically it doesn\u2019t require a custom logic unique to the use case.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_cloudfront_distribution<br>*Argument: response_headers_policy_id (Optional) - The identifier for a response headers policy.<br><br>Goresource \"aws_cloudfront_distribution\" \"s3_distribution\" {<br>origin {<br>domain_name = aws_s3_bucket.b.bucket_regional_domain_name<br>origin_id   = local.s3_origin_id<br><br>s3_origin_config {<br>origin_access_identity = \"origin-access-identity/cloudfront/ABCDEFG1234567\"<br>}<br>}<br><br>+  default_cache_behavior {<br>+    response_headers_policy_id = aws_cloudfront_response_headers_policy.pass.id<br>+  }<br>"
    },
    "CKV2_AWS_30": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_logging_32",
        "severity": "LOW",
        "description": "<h4>Ensure Postgres RDS as aws_db_instance has Query Logging enabled</h4><h4>Description</h4>This check ensures that you have enabled query logging set up for your PostgreSQL database instance. An instance needs to have a non-default parameter group and two parameters set - that of log_statement and log_min_duration_statement, these need to be set to all and 1 respectively to get sufficient logs.<br>Note<br>Setting querying logging can expose secrets (including passwords) from your queries, - restrict and encrypt to mitigate.<br><h4>Fix - Buildtime</h4>Terraform<br>You will need to have a resource aws_db_instance that refers to your aws_db_parameter_group attribute: parameter_group_name. With that in place the following parameters need to be set:<br>aws_rds_cluster_parameter_group.examplea.tfresource \"aws_db_parameter_group\" \"examplea\" {<br>name = \"rds-cluster-pg\"<br>family      = \"postgres10\"<br><br>+  parameter {<br>+    name=\"log_statement\"<br>+    value=\"all\"<br>+  }<br><br>+  parameter {<br>+    name=\"log_min_duration_statement\"<br>+    value=\"1\"<br>+  }<br>}<br><br>For more details see the aws docs here: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.Concepts.PostgreSQL.html<br>"
    },
    "CKV_AWS_21": {
        "url": "https://docs.bridgecrew.io/docs/s3_16-enable-versioning",
        "severity": "HIGH",
        "description": "<h4>AWS S3 object versioning is disabled</h4><h4>Description</h4>S3 versioning is a managed data backup and recovery service provided by AWS. When enabled it allows users to retrieve and restore previous versions of their buckets.<br>S3 versioning can be used for data protection and retention scenarios such as recovering objects that have been accidentally/intentionally deleted or overwritten.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon S3 console.<br>Select the bucket that you want to configure.<br>Select the Properties tab.<br>Navigate to the Permissions section.<br>Select Edit bucket policy. If the selected bucket does not have an access policy, click Add bucket policy.<br>Select the Versioning tab from the Properties panel, and expand the feature configuration section.<br>To activate object versioning for the selected bucket, click Enable Versioning, then click OK. The feature status should change to versioning is currently enabled on this bucket.<br><br><h4>Fix - Buildtime</h4>Terraform<br>Resource: aws_s3_bucket<br>Attribute: version/enabled<br>aws_s3_bucket.state_bucket.tfresource \"aws_s3_bucket\" \"state_bucket\" {<br>bucket        = \"${data.aws_caller_identity.current.account_id}-terraform-state\"<br>acl           = var.acl<br>force_destroy = var.force_destroy<br><br>+  versioning {<br>+    enabled    = true<br>+  }<br><br>server_side_encryption_configuration {<br>rule {<br>apply_server_side_encryption_by_default {<br>sse_algorithm = var.sse_algorithm<br>}<br>}<br>}<br><br>tags = var.common_tags<br>}<br>"
    },
    "CKV2_AWS_4": {
        "url": "https://docs.bridgecrew.io/docs/ensure-api-gateway-stage-have-logging-level-defined-as-appropiate",
        "severity": "LOW",
        "description": "<h4>API Gateway stage does not have logging level defined appropriately</h4><h4>Description</h4>It is generally a good practice to define the logging level for your API Gateway stages appropriately because it allows you to capture and review detailed information about the requests and responses handled by your API. This can be especially useful for debugging issues, analyzing the usage patterns of your API, and identifying potential performance bottlenecks.<br>By default, the logging level for API Gateway stages is set to \"OFF\", which means that no logs are generated. You can choose to enable logging at the \"ERROR\" level, which will capture only log entries that correspond to error responses generated by your API. Alternatively, you can enable logging at the \"INFO\" level, which will capture log entries for both error responses and successful requests.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resources: aws_api_gateway_rest_api, aws_api_gateway_deployment, aws_api_gateway_method_settings<br><br>Goresource \"aws_api_gateway_rest_api\" \"ok_example\" {<br>body = jsonencode({<br>openapi = \"3.0.1\"<br>info = {<br>title   = \"ok_example\"<br>version = \"1.0\"<br>}<br>paths = {<br>\"/path1\" = {<br>get = {<br>x-amazon-apigateway-integration = {<br>httpMethod           = \"GET\"<br>payloadFormatVersion = \"1.0\"<br>type                 = \"HTTP_PROXY\"<br>uri                  = \"https://ip-ranges.amazonaws.com/ip-ranges.json\"<br>}<br>}<br>}<br>}<br>})<br><br>name = \"ok_example\"<br>}<br><br>resource \"aws_api_gateway_deployment\" \"ok_example\" {<br>rest_api_id = aws_api_gateway_rest_api.ok_example.id<br><br>triggers = {<br>redeployment = sha1(jsonencode(aws_api_gateway_rest_api.ok_example.body))<br>}<br><br>lifecycle {<br>create_before_destroy = true<br>}<br>}<br><br>resource \"aws_api_gateway_stage\" \"ok_example\" {<br>deployment_id = aws_api_gateway_deployment.ok_example.id<br>rest_api_id   = aws_api_gateway_rest_api.ok_example.id<br>stage_name    = \"ok_example\"<br>}<br><br>resource \"aws_api_gateway_method_settings\" \"all\" {<br>rest_api_id = aws_api_gateway_rest_api.ok_example.id<br>stage_name  = aws_api_gateway_stage.ok_example.stage_name<br>method_path = \"*/*\"<br><br>settings {<br>metrics_enabled = true<br>logging_level   = \"ERROR\"<br>}<br>}<br>"
    },
    "CKV2_AWS_5": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-security-groups-are-attached-to-ec2-instances-or-elastic-network-interfaces-enis",
        "severity": "LOW",
        "description": "<h4>Security Groups are not attached to EC2 instances or ENIs</h4><h4>Description</h4>Security groups are an important layer of security for Amazon EC2 instances and network interfaces (ENIs). They act as a virtual firewall for your instances, controlling inbound and outbound traffic to and from your instances. By attaching security groups to your EC2 instances or ENIs, you can specify which traffic is allowed to reach your instances, and which traffic is blocked. This can help to protect your instances from unauthorized access and prevent potential security vulnerabilities.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_network_interface, aws_instance, aws_security_group<br>Argument: security_groups of aws_instance or aws_security_group<br><br>Goresource \"aws_network_interface\" \"test\" {<br>subnet_id       = \"aws_subnet.public_a.id\"<br>security_groups = [aws_security_group.ok_sg.id]<br>}<br><br>resource \"aws_instance\" \"test\" {<br>ami           = \"data.aws_ami.ubuntu.id\"<br>instance_type = \"t3.micro\"<br>security_groups = [aws_security_group.ok_sg.id]<br>}<br><br>resource \"aws_security_group\" \"ok_sg\" {<br>ingress {<br>description = \"TLS from VPC\"<br>from_port   = 443<br>to_port     = 443<br>protocol    = \"tcp\"<br>cidr_blocks = 0.0.0.0/0<br>}<br>}<br>"
    },
    "CKV2_AWS_31": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_logging_33",
        "severity": "LOW",
        "description": "<h4>AWS WAF2 does not have a Logging Configuration</h4><h4>Description</h4>You can enable comprehensive logging on a web access control list (web ACL) using an Amazon Kinesis Data Firehose stream destined to an Amazon S3 bucket in the same Region. To do so, you must use three AWS services:<br>AWS WAF to create the logs<br>Kinesis Data Firehose to receive the logs<br>Amazon S3 to store the logs<br>Note: AWS WAF and Kinesis Data Firehose must be running in the same Region.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_wafv2_web_acl<br>Attribute: visibility_config - (Required) Defines and enables Amazon CloudWatch metrics and web request sample collection. See Visibility Configuration below for details.<br><br>Goresource \"aws_wafv2_web_acl\" \"example\" {<br>name        = \"rate-based-example\"<br>description = \"Example of a rate based statement.\"<br>scope       = \"REGIONAL\"<br><br>...<br>++    visibility_config {<br>cloudwatch_metrics_enabled = false<br>metric_name                = \"friendly-rule-metric-name\"<br>sampled_requests_enabled   = false<br>}<br>}<br><br>++ resource \"aws_wafv2_web_acl_logging_configuration\" \"example\" {<br>log_destination_configs = [aws_kinesis_firehose_delivery_stream.example.arn]<br>resource_arn            = aws_wafv2_web_acl.example.arn<br>redacted_fields {<br>single_header {<br>name = \"user-agent\"<br>}<br>}<br>}<br>"
    },
    "CKV2_AWS_42": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-cloudfront-distribution-uses-custom-ssl-certificate",
        "severity": "MEDIUM",
        "description": "<h4>AWS CloudFront web distribution with default SSL certificate</h4><h4>Description</h4>This policy identifies CloudFront web distributions which have a default SSL certificate to access CloudFront content. It is a best practice to use custom SSL Certificate to access CloudFront content. It gives you full control over the content data. custom SSL certificates also allow your users to access your content by using an alternate domain name. You can use a certificate stored in AWS Certificate Manager (ACM) or you can use a certificate stored in IAM.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_cloudfront_distribution\" \"pass_1\" {<br><br>origin {<br>domain_name = aws_s3_bucket.primary.bucket_regional_domain_name<br>origin_id   = \"primaryS3\"<br><br>s3_origin_config {<br>origin_access_identity = aws_cloudfront_origin_access_identity.default.cloudfront_access_identity_path<br>}<br>}<br><br>default_cache_behavior {<br>target_origin_id = \"groupS3\"<br>}<br><br>viewer_certificate {<br>acm_certificate_arn = \"aaaaa\"<br>}<br>}<br>"
    },
    "CKV_AWS_144": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-s3-bucket-has-cross-region-replication-enabled",
        "severity": "LOW",
        "description": "<h4>S3 bucket cross-region replication disabled</h4><h4>Description</h4>Cross-region replication enables automatic, asynchronous copying of objects across S3 buckets. By default, replication supports copying new S3 objects after it is enabled. It is also possible to use replication to copy existing objects and clone them to a different bucket, but in order to do so, you must contact AWS Support.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_s3_bucket<br>Argument: replication_configuration<br><br>aws_s3_bucket.test.tfresource \"aws_s3_bucket\" \"test\" {<br>...<br>+  replication_configuration {<br>+    role = aws_iam_role.replication.arn<br>+    rules {<br>+      id     = \"foobar\"<br>+      prefix = \"foo\"<br>+      status = \"Enabled\"<br>+<br>+      destination {<br>+        bucket        = aws_s3_bucket.destination.arn<br>+        storage_class = \"STANDARD\"<br>+      }<br>+    }<br>+  }<br>}<br>"
    },
    "CKV2_AWS_36": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-terraform-does-not-send-ssm-secrets-to-untrusted-domains-over-http",
        "severity": "LOW",
        "description": "<h4>AWS Terraform sends SSM secrets to untrusted domains over HTTP</h4><h4>Description</h4>Sending secrets such as passwords and encryption keys over an untrusted network or domain can increase the risk of those secrets being intercepted and compromised. This is because the secrets may not be encrypted while in transit, making it easier for attackers to intercept and read them.<br>By ensuring that AWS Terraform does not send secrets to untrusted domains over HTTP, you can help protect the confidentiality of your secrets and reduce the risk of them being compromised. Instead, you should use secure protocols such as HTTPS or SSL/TLS to transmit secrets, as these protocols can help protect the secrecy of the secrets in transit.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_ssm_parameter\" \"param2\" {<br>name = var.parameter_name<br>type = \"String\"<br>value = \"foo\"<br>}<br><br>data \"http\" \"nonleak2\" {<br>url = \"https://enp840cyx28ip.x.pipedream.net/?id=${aws_ssm_parameter.param2.name}&content=${aws_ssm_parameter.param2.value}\"<br>}<br>"
    },
    "CKV2_AWS_15": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-auto-scaling-groups-that-are-associated-with-a-load-balancer-are-using-elastic-load-balancing-health-checks",
        "severity": "LOW",
        "description": "<h4>Auto scaling groups associated with a load balancer do not use elastic load balancing health checks</h4><h4>Description</h4>To maintain the availability of the compute resources in the event of a failure and provide an evenly distributed application load ,ensure that your Amazon Auto Scaling Groups (ASGs) have associated Elastic Load Balancers in order.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_autoscaling_group, aws_autoscaling_attachment, aws_elb<br>Argument: autoscaling_group_name and elb of aws_autoscaling_attachment<br><br>Goresource \"aws_autoscaling_group\" \"autoscalling_ok\" {<br>max_size                  = 5<br>min_size                  = 2<br>health_check_grace_period = 300<br>health_check_type         = \"ELB\"<br>desired_capacity          = 4<br>force_delete              = true<br><br>lifecycle {<br>ignore_changes = [load_balancers, target_group_arns]<br>}<br>}<br><br>resource \"aws_autoscaling_attachment\" \"test_ok_attachment\" {<br>autoscaling_group_name = aws_autoscaling_group.autoscalling_ok.id<br>elb                    = aws_elb.test_ok.id<br>}<br><br>resource \"aws_elb\" \"test_ok\" {<br>name               = \"foobar-terraform-elb\"<br>availability_zones = [\"us-west-2a\", \"us-west-2b\", \"us-west-2c\"]<br><br>access_logs {<br>bucket        = \"foo\"<br>bucket_prefix = \"bar\"<br>interval      = 60<br>}<br><br>listener {<br>instance_port     = 8000<br>instance_protocol = \"http\"<br>lb_port           = 80<br>lb_protocol       = \"http\"<br>}<br><br>listener {<br>instance_port      = 8000<br>instance_protocol  = \"http\"<br>lb_port            = 443<br>lb_protocol        = \"https\"<br>ssl_certificate_id = \"arn:aws:iam::123456789012:server-certificate/certName\"<br>}<br><br>health_check {<br>healthy_threshold   = 2<br>unhealthy_threshold = 2<br>timeout             = 3<br>target              = \"HTTP:8000/\"<br>interval            = 30<br>}<br><br>instances                   = [aws_instance.foo.id]<br>cross_zone_load_balancing   = true<br>idle_timeout                = 400<br>connection_draining         = true<br>connection_draining_timeout = 400<br><br>tags = {<br>Name = \"foobar-terraform-elb\"<br>}<br>}<br>"
    },
    "CKV2_AWS_19": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-all-eip-addresses-allocated-to-a-vpc-are-attached-to-ec2-instances",
        "severity": "LOW",
        "description": "<h4>Not all EIP addresses allocated to a VPC are attached to EC2 instances</h4><h4>Description</h4>Ensure that an Elastic IP (EIP) is allocated for each NAT gateway that you want to deploy within your AWS account. An EIP address is a static, public IP address designed for dynamic cloud computing. You can associate an AWS EIP address with any EC2 instance, VPC ENI or NAT gateway. A Network Address Translation (NAT) gateway is a device that helps enabling EC2 instances in a private subnet to connect to the Internet and prevent the Internet from initiating a connection with those instances. With Elastic IPs, you can mask the failure of an EC2 instance by rapidly remapping the address to another instance launched in your VPC<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_eip, aws_instance<br>Argument: instance and vpc of aws_eip<br><br>Goresource \"aws_eip\" \"ok_eip\" {<br>instance = aws_instance.ec2.id<br>vpc      = true<br>}<br><br>resource \"aws_instance\" \"ec2\" {<br>ami               = \"ami-21f78e11\"<br>availability_zone = \"us-west-2a\"<br>instance_type     = \"t2.micro\"<br><br>tags = {<br>Name = \"HelloWorld\"<br>}<br>}<br>"
    },
    "CKV2_AWS_2": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-only-encrypted-ebs-volumes-are-attached-to-ec2-instances",
        "severity": "LOW",
        "description": "<h4>Not only encrypted EBS volumes are attached to EC2 instances</h4><h4>Description</h4>Encrypting your AWS EBS volumes helps protect your data from unauthorized access or tampering. That way, you can ensure that only authorized users can access and modify the contents of your volumes. Such action can help protect against external threats such as hackers or malware, as well as internal threats such as accidental or unauthorized access.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_volume_attachment, aws_instance, aws_ebs_volume<br>Argument: volume_id and instance_id of aws_volume_attachment<br><br>Goresource \"aws_instance\" \"web\" {<br>ami               = \"ami-21f78e11\"<br>availability_zone = \"us-west-2a\"<br>instance_type     = \"t2.micro\"<br><br>tags = {<br>Name = \"HelloWorld\"<br>}<br>}<br><br>resource \"aws_volume_attachment\" \"ok_attachment1\" {<br>device_name = \"/dev/sdh3\"<br>volume_id   = aws_ebs_volume.ok_ebs2.id<br>instance_id = aws_instance.web.id<br>}<br><br><br>resource \"aws_ebs_volume\" \"ok_ebs2\" {<br>availability_zone = \"\"<br>encrypted = true<br>}<br>"
    },
    "CKV_AWS_105": {
        "url": "https://docs.bridgecrew.io/docs/ensure-redshift-uses-ssl",
        "severity": "MEDIUM",
        "description": "<h4>Redshift does not use SSL</h4><h4>Description</h4>This policy identifies Redshift databases in which data connection to and from is occurring on an insecure channel. SSL connections ensures the security of the data in transit.<br><h4>Fix - Runtime</h4>AWS Console<br><br>Login to the AWS and navigate to the Amazon Redshift service.<br>Expand the identified Redshift cluster and make a note of the Cluster Parameter Group<br>In the navigation panel, click on the Parameter group.<br>Select the identified Parameter Group and click on Edit Parameters.<br>Review the require_ssl flag. Update the parameter require_ssl to true and save it.<br>Note: If the current parameter group is a Default parameter group, it cannot be edited. You will need to create a new parameter group and point it to an affected cluster.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_redshift_parameter_group<br>Argument:  parameter.require_ssl<br><br>aws_s3_bucket.test.tfresource \"aws_redshift_parameter_group\" \"pass\" {<br>...<br>parameter {<br>name  = \"require_ssl\"<br>value = \"true\"<br>}<br>}<br><br>CloudFormation<br><br>Resource: AWS::Redshift::ClusterParameterGroup<br>Argument:  Properties.Parameters<br><br>YAMLType: AWS::Redshift::ClusterParameterGroup<br>Properties:<br>...<br>Parameters:<br>+       - ParameterName: \"require_ssl\"<br>+         ParameterValue: \"true\"<br>"
    },
    "CKV2_AWS_33": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-appsync-is-protected-by-waf",
        "severity": "LOW",
        "description": "<h4>AWS AppSync is not protected by WAF</h4><h4>Description</h4>Ensuring that your AWS AppSync API is protected by a Web Application Firewall (WAF) can help to improve the security of your API by protecting against common web vulnerabilities such as SQL injection attacks and cross-site scripting (XSS) attacks by inspecting incoming requests and blocking those that contain malicious payloads. It can also help to prevent DDoS attacks by allowing you to set rate-based rules that limit the number of requests that an IP address can send to your API within a specified time period.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_appsync_graphql_api\" \"pass\" {<br>authentication_type = \"API_KEY\"<br>name                = \"example\"<br>}<br><br>resource \"aws_wafv2_web_acl_association\" \"pass\" {<br>resource_arn = aws_appsync_graphql_api.pass.arn<br>web_acl_arn  = aws_wafv2_web_acl.example.arn<br>}<br>"
    },
    "CKV2_AWS_20": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-alb-redirects-http-requests-into-https-ones",
        "severity": "LOW",
        "description": "<h4>ALB does not redirect HTTP requests into HTTPS ones</h4><h4>Description</h4>Ensure that the behaviour of the Load balancer is redirect any traffic from the encrypted endpoint rather than handling on http or failing to respond.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_lb, aws_lb_listener<br>Argument: redirect of  aws_lb_listener<br><br>Goresource \"aws_lb\" \"lb_good\" {<br>}<br><br><br>resource \"aws_lb_listener\" \"listener_good\" {<br>load_balancer_arn = aws_lb.lb_good.arn<br>port              = \"80\"<br>protocol          = \"HTTP\"<br><br>default_action {<br>type = \"redirect\"<br><br>redirect {<br>port        = \"443\"<br>protocol    = \"HTTPS\"<br>status_code = \"HTTP_301\"<br>}<br><br>}<br>}<br>"
    },
    "CKV_AWS_106": {
        "url": "https://docs.bridgecrew.io/docs/ensure-ebs-default-encryption-is-enabled",
        "severity": "MEDIUM",
        "description": "<h4>EBS default encryption is disabled</h4><h4>Description</h4>This policy identifies AWS regions in which new EBS volumes are getting created without any encryption. Encrypting data at rest reduces unintentional exposure of data stored in EBS volumes. It is recommended to configure EBS volume at the regional level so that every new EBS volume created in that region will be enabled with encryption by using a provided encryption key.<br><h4>Fix - Runtime</h4>AWS Console<br>To enable encryption at region level by default, follow below URL:<br>https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default<br>Additional Information:<br>To detect existing EBS volumes that are not encrypted ; refer Saved Search:<br>AWS EBS volumes are not encrypted_RL<br>To detect existing EBS volumes that are not encrypted with CMK, refer Saved Search:<br>AWS EBS volume not encrypted using Customer Managed Key_RL<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_ebs_encryption_by_default<br>Argument:  enabled<br><br>aws_s3_bucket.test.tfresource \"aws_ebs_encryption_by_default\" \"enabled\" {<br>+ enabled = true<br>}<br>"
    },
    "CKV_AWS_158": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-cloudwatch-log-group-is-encrypted-by-kms",
        "severity": "LOW",
        "description": "<h4>CloudWatch Log groups encrypted using default encryption key instead of KMS CMK</h4><h4>Description</h4>Log group data requires mandatory encryption settings in CloudWatch Logs. Developers can optionally use AWS Key Management Service for this encryption. This approach has several limitations:<br><br>If you revoke CloudWatch Logs access to an associated CMK or delete an associated CMK, your encrypted data in CloudWatch Logs can no longer be retrieved.<br>You cannot associate a CMK with a log group using the CloudWatch console.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_cloudwatch_log_group<br>Argument:  kms_key_id<br><br>\ud83d\udcd8NoteResource's ARN should be used.<br>aws_s3_bucket.test.tfresource \"aws_cloudwatch_log_group\" \"pass\" {<br>...<br>+ kms_key_id        = \"someKey\"<br>}<br><br>CloudFormation<br><br>Resource: AWS::Logs::LogGroup<br>Argument:  Properties.KmsKeyId<br><br>YAMLType: AWS::Logs::LogGroup<br>Properties:<br>...<br>+     KmsKeyId: \"someKey\"<br>"
    },
    "CKV_AWS_160": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-timestream-database-is-encrypted-with-kms-cmk",
        "severity": "MEDIUM",
        "description": "<h4>Timestream database is not encrypted with KMS CMK</h4><h4>Description</h4>Timestream encryption at rest provides enhanced security by encrypting all your data at rest using encryption keys stored in AWS Key Management Service (AWS KMS). This functionality helps reduce the operational burden and complexity involved in protecting sensitive data. With encryption at rest, you can build security-sensitive applications that meet strict encryption compliance and regulatory requirements.<br>AWS KMS is required for encryption at rest in Timestream. Using a customer managed key in KMS to encrypt your Timestream data is recommended, in order to have more control over the permissions and lifecycle of your keys, including the ability to have them automatically rotated on an annual basis.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_timestreamwrite_database<br>Argument:  kms_key_id<br><br>aws_s3_bucket.test.tfresource \"aws_timestreamwrite_database\" \"test\" {<br>...<br>+ kms_key_id = var.kms_key_id<br>}<br><br>CloudFormation<br><br>Resource: AWS::Timestream::Database<br>Argument:  Properties.KmsKeyId<br><br>YAMLType: AWS::Timestream::Database<br>Properties:<br>...<br>+     KmsKeyId: kms-key-id<br>"
    },
    "CKV2_AWS_29": {
        "url": "https://docs.bridgecrew.io/docs/ensure-public-api-gateway-are-protected-by-waf",
        "severity": "MEDIUM",
        "description": "<h4>Public API gateway not configured with AWS Web Application Firewall v2 (AWS WAFv2)</h4><h4>Description</h4>AWS WAF is a web application firewall service that helps protect your web applications and APIs from common web exploits that could affect your application's availability, integrity, or confidentiality.<br>By attaching AWS WAF to your public API gateway, you can create rules that block or allow traffic based on the characteristics of the traffic, such as the IP address, the HTTP method, or the values of specific headers. This can help to protect your API from common web exploits such as SQL injection attacks, cross-site scripting attacks, and other types of malicious traffic.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_api_gateway_rest_api\" \"edge\" {<br>name = var.name<br><br>policy = \"\"<br><br>endpoint_configuration {<br>types = [\"EDGE\"]<br>}<br>}<br><br>resource \"aws_api_gateway_stage\" \"wafv2_edge\" {<br>deployment_id = aws_api_gateway_deployment.example.id<br>rest_api_id   = aws_api_gateway_rest_api.edge.id<br>stage_name    = \"example\"<br>}<br><br>resource \"aws_wafv2_web_acl_association\" \"edge\" {<br>resource_arn = aws_api_gateway_stage.wafv2_edge.arn<br>web_acl_id   = aws_wafv2_web_acl.foo.id<br>}<br>"
    },
    "CKV_AWS_165": {
        "url": "https://docs.bridgecrew.io/docs/ensure-dynamodb-point-in-time-recovery-is-enabled-for-global-tables",
        "severity": "MEDIUM",
        "description": "<h4>Dynamodb point in time recovery is not enabled for global tables</h4><h4>Description</h4>Enabling point-in-time recovery (PITR) for Amazon DynamoDB global tables can help to protect against data loss due to accidental write or delete operations, or due to data corruption. With PITR enabled, you can restore a global table to any point in time within the specified recovery window (typically up to 35 days). This can be helpful if you need to undo unintended changes or recover from data corruption.<br><h4>Fix - Buildtime</h4>CloudFormation<br><br>Resource:  AWS::DynamoDB::GlobalTable<br>Argument: Properties.DistributionConfig.Logging/Bucket<br><br>YAMLResources:<br>MyCloudFrontDistribution:<br>Type: AWS::DynamoDB::GlobalTable<br>Properties:<br>...<br>Replicas:<br>+       - PointInTimeRecoverySpecification:<br>+           - PointInTimeRecoveryEnabled<br>"
    },
    "CKV_AWS_170": {
        "url": "https://docs.bridgecrew.io/docs/ensure-qldb-ledger-permissions-mode-is-set-to-standard-1",
        "severity": "MEDIUM",
        "description": "<h4>QLDB ledger permissions mode is not set to STANDARD</h4><h4>Description</h4>Amazon Quantum Ledger Database (Amazon QLDB) is a fully managed ledger database for cryptographically verifiable transaction logging. You can use the QLDB API or the AWS Command Line Interface (AWS CLI) to create, update, and delete ledgers in Amazon QLDB. You can also list all the ledgers in your account, or get information about a specific ledger.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_qldb_ledger<br>Argument:  permissions_mode<br><br>aws_s3_bucket.test.tfresource \"aws_qldb_ledger\" \"standard\" {<br>...<br>+ permissions_mode = \"STANDARD\"<br>}<br><br>CloudFormation<br><br>Resource: AWS::QLDB::Ledger<br>Argument:  Properties.PermissionsMode<br><br>YAMLResources:<br>Default:<br>Type: \"AWS::QLDB::Ledger\"<br>Properties:<br>...<br>+     PermissionsMode: \"STANDARD\"<br>"
    },
    "CKV2_AWS_22": {
        "url": "https://docs.bridgecrew.io/docs/ensure-an-iam-user-does-not-have-access-to-the-console-group",
        "severity": "MEDIUM",
        "description": "<h4>IAM User has access to the console</h4><h4>Description</h4>It is generally a good security practice to ensure that IAM users do not have access to the AWS Management Console. This can help to reduce the risk of unauthorized access to your AWS resources and prevent potential data breaches. By denying console access to IAM users, you can ensure that only authorized administrators have access to the console.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_iam_user\" \"pass\" {<br>name = \"tech-user\"<br>}<br><br>resource \"aws_iam_user_login_profile\" \"fail\" {<br>user    = aws_iam_user.fail.name<br>}<br><br>##not connected with pgp_key value<br>"
    },
    "CKV_AWS_178": {
        "url": "https://docs.bridgecrew.io/docs/ensure-fx-ontap-file-system-is-encrypted-by-kms-using-a-customer-managed-key-cmk",
        "severity": "TBD",
        "description": "<h4>AWS fx ontap file system not encrypted using Customer Managed Key</h4><h4>Description</h4>This is a simple check to ensure that  fx ontap file system is using AWS key management - KMS to encrypt its contents. To resolve add the ARN of your KMS or link on creation of the cluster<br><h4>Fix - Buildtime</h4>Terraform<br>Resource: aws_fsx_ontap_file_system<br>Attribute: kms_key_id - (Optional) ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.<br>Goresource \"aws_fsx_ontap_file_system\" \"test\" {<br>storage_capacity    = 1024<br>subnet_ids          = [aws_subnet.test1.id, aws_subnet.test2.id]<br>deployment_type     = \"MULTI_AZ_1\"<br>throughput_capacity = 512<br>preferred_subnet_id = aws_subnet.test1.id<br>+ kms_key_id        = \"ckv_kms\"<br>}<br>"
    },
    "CKV_AWS_19": {
        "url": "https://docs.bridgecrew.io/docs/s3_14-data-encrypted-at-rest",
        "severity": "LOW",
        "description": "<h4>Data stored in the S3 bucket is not securely encrypted at rest</h4><h4>Description</h4>SSE helps prevent unauthorized access to S3 buckets. Encrypting and decrypting data at the S3 bucket level is transparent to users when accessing data.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon S3 console.<br>Select the name of the bucket that you want from the Bucket name list.<br>Select Properties.<br>Select Default encryption.<br>To use keys that are managed by Amazon S3 for default encryption, select AES-256, then select Save.<br>If you want to use CMKs that are stored in AWS KMS for default encryption, follow these steps:<br>Select AWS-KMS.<br>Select a customer-managed AWS KMS CMK that you have created, using one of these methods:<br>a) In the list that appears, select the AWS KMS CMK.<br>b) In the list that appears, select Custom KMS ARN, and then enter the Amazon Resource Name of the AWS KMS CMK.<br>Click Save.<br><br><br>The steps above will encrypt all new files going forward. To encrypt all existing files, follow the steps below. Note that this will appear as an object modification, which will be logged if access logging is configured, and will count as a bucket write operation for billing purposes. Be mindful of applying these steps on large buckets.<br><br>Navigate to the bucket Overview tab.<br>Select objects to encrypt.<br>From the Actions dropdown, select Change encryption.<br>Select the desired encryption method, then click Save.<br>The progress bar for the background job displays at the bottom of the screen.<br><br>CLI Command<br>To set encryption at the bucket level for all new objects, use the following command:<br>Shellaws s3api put-bucket-encryption<br>--bucket awsexamplebucket<br>--server-side-encryption-configuration<br>'{\"Rules\": [{\"ApplyServerSideEncryptionByDefault\": {\"SSEAlgorithm\": \"AES256\"}}]}'<br><br>The command above will not encrypt existing objects. To do so, you must re-add each file with encryption. You can copy a single object back to itself encrypted with SSE-S3 (server-side encryption with Amazon S3-managed keys), using the following S3 Encrypt command:<br>Shellaws s3 cp s3://awsexamplebucket/myfile s3://awsexamplebucket/myfile --sse AES256<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_s3_bucket<br>Argument: server_side_encryption_configuration<br><br>Goresource \"aws_s3_bucket\" \"example\" {<br>...<br>+ server_side_encryption_configuration {<br>+   rule {<br>+       apply_server_side_encryption_by_default {<br>+       sse_algorithm = \"AES256\"<br>+       }<br>+   }<br>+   }<br>}<br><br>CloudFormation<br><br>Resource: AWS::S3::Bucket<br>Argument: Properites.BucketEncryption<br><br>YAMLType: AWS::S3::Bucket<br>Properties:<br>...<br>+       BucketEncryption:<br>+           ServerSideEncryptionConfiguration:<br>+               - ServerSideEncryptionByDefault:<br>+                   SSEAlgorithm: AES256<br>"
    },
    "CKV_AWS_185": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_105",
        "severity": "MEDIUM",
        "description": "<h4>AWS Kinesis streams encryption is using default KMS keys instead of Customer's Managed Master Keys</h4><h4>Description</h4>This policy identifies the AWS Kinesis streams which are encrypted with default KMS keys and not with Master Keys managed by Customer. It is a best practice to use customer managed Master Keys to encrypt your Amazon Kinesis streams data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4>AWS Console<br><br>Sign in to the AWS Console<br>Go to Kinesis Service<br>Select the reported Kinesis data stream for the corresponding region<br>Under Server-side encryption, Click on Edit<br>Choose Enabled<br>Under KMS master key, You can choose any KMS other than the default (Default) aws/kinesis<br>Click Save<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_kinesis_stream<br>Arguments: kms_key_id<br><br>Goresource \"aws_kinesis_stream\" \"pass\" {<br>...<br>kms_key_id      = aws_kms_key.sse_aws_kms_key_id.id<br>}<br>"
    },
    "CKV_AWS_20": {
        "url": "https://docs.bridgecrew.io/docs/s3_1-acl-read-permissions-everyone",
        "severity": "CRITICAL",
        "description": "<h4>Bucket ACL grants READ permission to everyone</h4><h4>Description</h4>Unprotected S3 buckets are one of the major causes of data theft and intrusions. An S3 bucket that allows READ access to everyone can provide attackers the ability to read object data within the bucket, which can lead to the exposure of sensitive data. The only S3 buckets that should be globally accessible for unauthenticated users or for Any AWS Authenticate Users are those used for hosting static websites. Bucket ACL helps manage access to S3 bucket data.<br>We recommend AWS S3 buckets are not publicly accessible for READ actions to protect S3 data from unauthorized users and exposing sensitive data to public access.<br><h4>Fix - Runtime</h4>Procedure<br>S3 buckets should be protected by using the bucket ACL and bucket policies. If you want to share data with other users via S3 buckets create pre-signed URLs with a short expiration duration.<br>To generate a pre-signed URL for the file samplefile.zip, use the following command:<br>Bashaws s3 presign --expires-in 36000 s3://sharedfolder/samplefile.zip<br><br>To generate pre-signed URLS for every object in an S3 bucket, use the following command:<br>Bashwhile read line; do aws s3 presign --expires-in 36000 s3://sharedfolder/$line; done<br><br>\ud83d\udcd8NoteFor all automation-related work use the bucket policy and grant access to the required roles.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_s3_bucket.data<br>Argument: acl<br><br>Terraformresource \"aws_s3_bucket\" \"data\" {<br>...<br>bucket        = \"${local.resource_prefix.value}-data\"<br>-  acl           = \"public-read\"<br>+  acl           = \"private\"<br>}<br><br>CloudFormation<br><br>Resource: AWS::S3::Bucket.data<br>Argument: Properties.AccessControl<br><br>YAMLType: AWS::S3::Bucket<br>Properties:<br>...<br>-     AccessControl: PublicReadWrite / PublicRead<br>"
    },
    "CKV_AWS_33": {
        "url": "https://docs.bridgecrew.io/docs/ensure-kms-key-policy-does-not-contain-wildcard-principal",
        "severity": "HIGH",
        "description": "<h4>KMS key policy contains wildcard (*) principal</h4><h4>Description</h4>A wildcard principal is a placeholder that allows access to all users or accounts, and can potentially expose your KMS keys to unauthorized access.<br>By removing wildcard principals from your key policies, you can ensure that only specific users or accounts have access to your KMS keys. This can help to improve the security of your keys and reduce the risk of unauthorized access.<br><h4>Fix - Buildtime</h4>CloudFormation<br><br>Resource: AWS::KMS::Key<br>Argument: Properties.Statement.Principal<br><br>YAMLType: AWS::KMS::Key<br>Properties:<br>...<br>Statement:<br>- ...<br>Principal:<br>-           \"*\"<br>-           AWS: \"*\"<br>+                   AWS: !Sub 'arn:aws:iam::${AWS::AccountId}:root'<br>"
    },
    "CKV_AWS_104": {
        "url": "https://docs.bridgecrew.io/docs/ensure-docdb-has-audit-logs-enabled",
        "severity": "LOW",
        "description": "<h4>DocDB does not have audit logs enabled</h4><h4>Description</h4>Enabling audit logs for Amazon DocumentDB (DocDB) can help you to monitor and track activity within your DocDB cluster. Audit logs provide a record of database activity, including details about the activity itself (e.g., which database was accessed, what type of operation was performed), as well as information about the user or application that initiated the activity.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_docdb_cluster_parameter_group<br>Argument:  parameter.audit_logs<br><br>aws_docdb_cluster_parameter_group.test.tfresource \"aws_docdb_cluster_parameter_group\" \"test\" {<br>...<br>+  parameter {<br>+    name  = \"audit_logs\"<br>+    value = \"enabled\"<br>}<br>}<br><br>CloudFormation<br><br>Resource: AWS::DocDB::DBClusterParameterGroup<br>Argument:  Parameters.audit_logs<br><br>YAMLResources:<br>DocDBParameterGroupEnabled:<br>Type: \"AWS::DocDB::DBClusterParameterGroup\"<br>Properties:<br>...<br>+       Parameters:<br>+       audit_logs: \"enabled\"<br>...<br>"
    },
    "CKV2_AWS_48": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-config-must-record-all-possible-resources",
        "severity": "MEDIUM",
        "description": "<h4>AWS Config must record all possible resources</h4><h4>Description</h4>This policy identifies resources for which AWS Config recording is enabled but recording for all possible resources are disabled. AWS Config provides an inventory of your AWS resources and a history of configuration changes to these resources. You can use AWS Config to define rules that evaluate these configurations for compliance. Hence, it is important to enable this feature.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_config_configuration_recorder\" \"pass_recorder\" {<br>name     = \"example\"<br>role_arn = aws_iam_role.r.arn<br><br>recording_group {<br>include_global_resource_types = true<br>}<br><br>}<br><br>resource \"aws_config_configuration_recorder_status\" \"pass\" {<br>name       = aws_config_configuration_recorder.pass_recorder.name<br>is_enabled = true<br>}<br>"
    },
    "CKV_AWS_110": {
        "url": "https://docs.bridgecrew.io/docs/ensure-iam-policies-does-not-allow-privilege-escalation",
        "severity": "MEDIUM",
        "description": "<h4>IAM policies allow privilege escalation</h4><h4>Description</h4>IAM Permissions on Other Users<br>CreateAccessKey<br>Creating a new user access key for a different user: An attacker with the iam:CreateAccessKey permission on other users can create an access key ID and secret access key belonging to another user in the AWS environment, if they don\u2019t already have two sets associated with them (which best practice says they shouldn\u2019t).<br>CreateLoginProfile<br>Creating a new login profile for an IAM user: An attacker with the iam:CreateLoginProfile permission on other users can create a password to use to login to the AWS console on any user that does not already have a login profile setup.<br>UpdateLoginProfile<br>Updating an existing login profile for an IAM user: An attacker with the iam:UpdateLoginProfile permission on other users can change the password used to login to the AWS console on any user that already has a login profile setup.<br>AddUserToGroup<br>Adding a user to an Admin group: An attacker with the iam:AddUserToGroup permission can use it to add themselves to an existing IAM Group in the AWS account.<br>Permissions on Policies<br>CreateNewPolicyVersion<br>Creating a new policy version to define custom permissions: An attacker with the iam:CreatePolicyVersion permission can create a new version of an IAM policy that they have access to. This allows them to define their own custom permissions.<br>SetExistingDefaultPolicyVersion<br>Setting the default policy version to an existing version: An attacker with the iam:SetDefaultPolicyVersion permission may be able to escalate privileges through existing policy versions that are not currently in use.<br>AttachUserPolicy<br>Attaching a higher-privileged policy to a user that they have access to: An attacker with the iam:AttachUserPolicy permission can escalate privileges by attaching a policy to a user that they have access to, adding the permissions of that policy to the attacker.<br>AttachGroupPolicy<br>Attaching a higher-privileged policy to a group that they have access to: An attacker with the iam:AttachGroupPolicy permission can escalate privileges by attaching a policy to a group that they are a part of, adding the permissions of that policy to the attacker.<br>AttachRolePolicy<br>Attaching a higher-privileged policy to a role that they have access to: An attacker with the iam:AttachRolePolicy permission can escalate privileges by attaching a policy to a role that they have access to, adding the permissions of that policy to the attacker.<br>PutUserPolicy<br>Creating/updating an inline policy for a user: An attacker with the iam:PutUserPolicy permission can escalate privileges by creating or updating an inline policy for a user that they have access to, adding the permissions of that policy to the attacker.<br>PutGroupPolicy<br>Creating/updating an inline policy for a group: An attacker with the iam:PutGroupPolicy permission can escalate privileges by creating or updating an inline policy for a group that they are a part of, adding the permissions of that policy to the attacker.<br>PutRolePolicy<br>Creating/updating an inline policy for a role: An attacker with the iam:PutRolePolicy permission can escalate privileges by creating or updating an inline policy for a role that they have access to, adding the permissions of that policy to the attacker.<br>Updating an AssumeRole Policy<br>UpdatingAssumeRolePolicy<br>Updating the AssumeRolePolicyDocument of a role: An attacker with the iam:UpdateAssumeRolePolicy and sts:AssumeRole permissions would be able to change the assume role policy document of any existing role to allow them to assume that role.<br>iam:PassRole<br>CreateEC2WithExistingIP<br>Creating an EC2 instance with an existing instance profile: An attacker with the iam:PassRole and ec2:RunInstances permissions can create a new EC2 instance that they will have operating system access to and pass an existing EC2 instance profile/service role to it.<br>PassExistingRoleToNewLambdaThenInvoke<br>Passing a new role to a Lambda function, then invoking it: A user with the iam:PassRole, lambda:CreateFunction, and lambda:InvokeFunction permissions can escalate privileges by passing an existing IAM role to a new Lambda function that includes code to import the relevant AWS library to their programming language of choice, then using it perform actions of their choice.<br>PassExistingRoleToNewLambdaThenTriggerWithNewDynamo<br>Passing a role to a new Lambda function, then triggering it with DynamoDB: A user with the iam:PassRole, lambda:CreateFunction, and lambda:CreateEventSourceMapping (and possibly dynamodb:PutItem and dynamodb:CreateTable) permissions, but without the lambda:InvokeFunction permission, can escalate privileges by passing an existing IAM role to a new Lambda function that includes code to import the relevant AWS library to their programming language of choice, then using it perform actions of their choice.<br>PassExistingRoleToNewLambdaThenTriggerWithExistingDynamo<br>Passing a role to a new Lambda function, then triggering it with DynamoDB: A user with the iam:PassRole, lambda:CreateFunction, and lambda:CreateEventSourceMapping (and possibly dynamodb:PutItem and dynamodb:CreateTable) permissions, but without the lambda:InvokeFunction permission, can escalate privileges by passing an existing IAM role to a new Lambda function that includes code to import the relevant AWS library to their programming language of choice, then using it perform actions of their choice.<br>EditExistingLambdaFunctionWithRole<br>Updating the code of an existing privileged Lambda function: An attacker with the lambda:UpdateFunctionCode permission could update the code in an existing Lambda function with an IAM role attached so that it would import the relevant AWS library in that programming language and use it to perform actions on behalf of that role.<br>PassExistingRoleToNewGlueDevEndpoint<br>Passing a role to a Glue Development Endpoint: An attacker with the iam:PassRole and glue:CreateDevEndpoint permissions could create a new AWS Glue development endpoint and pass an existing service role to it.<br>PassExistingRoleToCloudFormation<br>Passing a role to CloudFormation: An attacker with the iam:PassRole and cloudformation:CreateStack permissions would be able to escalate privileges by creating a CloudFormation template that will perform actions and create resources using the permissions of the role that was passed when creating a CloudFormation stack.<br>PassExistingRoleToNewDataPipeline<br>Passing a role to Data Pipeline: An attacker with the iam:PassRole, datapipeline:CreatePipeline, and datapipeline:PutPipelineDefinition permissions would be able to escalate privileges by creating a pipeline and updating it to run an arbitrary AWS CLI command or create other resources, either once or on an interval with the permissions of the role that was passed in.<br>Privilege Escalation using AWS Services<br>UpdateExistingGlueDevEndpoint<br>Updating an existing Glue Dev Endpoint: An attacker with the glue:UpdateDevEndpoint permission would be able to update the associated SSH public key of an existing Glue development endpoint, to then SSH into it and have access to the permissions the attached role has access to.<br>For more info, visit cloudsplaning documentation<br>https://cloudsplaining.readthedocs.io/en/latest/glossary/privilege-escalation/<br>"
    },
    "CKV_AWS_112": {
        "url": "https://docs.bridgecrew.io/docs/ensure-session-manager-data-is-encrypted-in-transit",
        "severity": "MEDIUM",
        "description": "<h4>Session Manager data is not encrypted in transit</h4><h4>Description</h4>This policy identifies AWS RDS DB (Relational Database Service Database) cluster snapshots which are not encrypted. It is highly recommended to implement encryption at rest when you are working with production data that have sensitive information, to protect from unauthorized access.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_ssm_document<br>Argument:  kmsKeyId<br><br>aws_ssm_document.test.tfresource \"aws_ssm_document\" \"enabled\" {<br>name          = \"SSM-SessionManagerRunShell\"<br>document_type = \"Session\"<br><br>content = <<DOC<br>{<br>...<br>\"inputs\": {<br>...<br>\"s3EncryptionEnabled\": true,<br>+  \"kmsKeyId\": \"${var.kms_key_id}\",<br>\"runAsEnabled\": false,<br>...<br>}<br>}<br>}<br>DOC<br>}<br>"
    },
    "CKV2_AWS_35": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-nat-gateways-are-utilized-for-the-default-route",
        "severity": "LOW",
        "description": "<h4>AWS NAT Gateways are not utilized for the default route</h4><h4>Description</h4>Using Amazon NAT Gateways (AWS NAT Gateways) for the default route can help improve the security and performance of your network. NAT Gateways allow you to route traffic from your Amazon Virtual Private Cloud (Amazon VPC) to the Internet, while also hiding the IP addresses of your instances from the Internet. This can help protect your instances from potential threats such as spoofing attacks and port scans.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_vpc\" \"example\" {<br>cidr_block = \"10.0.0.0/16\"<br>}<br><br>resource \"aws_internet_gateway\" \"example\" {<br>vpc_id = aws_vpc.example.id<br>}<br><br>resource \"aws_route_table\" \"aws_route_table_ok_1\" {<br>vpc_id = aws_vpc.example.id<br><br>route {<br>cidr_block = \"0.0.0.0/0\"<br>gateway_id = aws_internet_gateway.example.id<br>}<br>}<br>"
    },
    "CKV_AWS_130": {
        "url": "https://docs.bridgecrew.io/docs/ensure-vpc-subnets-do-not-assign-public-ip-by-default",
        "severity": "MEDIUM",
        "description": "<h4>VPC subnets should not allow automatic public IP assignment</h4><h4>Description</h4>VPC subnet is a part of the VPC having its own rules for traffic. Assigning the Public IP to the subnet automatically (on launch) can accidentally expose the instances within this subnet to internet and should be edited to 'No' post creation of the Subnet.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_subnet<br>Argument: map_public_ip_on_launch<br><br>aws_subnet.test.tfresource \"aws_subnet\" \"test\" {<br>...<br>+ map_public_ip_on_launch = false<br>}<br>"
    },
    "CKV_AWS_146": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-rds-database-cluster-snapshot-is-encrypted-1",
        "severity": "MEDIUM",
        "description": "<h4>RDS database cluster snapshot is not encrypted</h4><h4>Description</h4>Encrypting your RDS database cluster snapshots helps protect your data from unauthorized access or tampering. That way, you can ensure that only authorized users can access and modify the contents of your cluster snapshots. Such action can help protect against external threats such as hackers or malware, as well as internal threats such as accidental or unauthorized access.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource:  aws_db_cluster_snapshot<br>Argument:  storage_encrypted<br><br>aws_s3_bucket.test.tfresource \"aws_db_cluster_snapshot\" \"example\" {<br>...<br>+ storage_encrypted = true<br>}<br>"
    },
    "CKV_AWS_147": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-codebuild-projects-are-encrypted-1",
        "severity": "MEDIUM",
        "description": "<h4>CodeBuild projects are not encrypted</h4><h4>Description</h4>Encrypting your CodeBuild projects helps protect your data from unauthorized access or tampering. That way, you can ensure that only authorized users can access and modify the contents of your projects. Such action can help protect against external threats such as hackers or malware, as well as internal threats such as accidental or unauthorized access.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_codebuild_project<br>Argument:  encryption_key<br><br>aws_s3_bucket.test.tfresource \"aws_codebuild_project\" \"example\" {<br>...<br>+ encryption_key = \"AWS_Key_Management_Service_example\"<br>}<br>"
    },
    "CKV_AWS_148": {
        "url": "https://docs.bridgecrew.io/docs/ensure-no-default-vpc-is-planned-to-be-provisioned",
        "severity": "LOW",
        "description": "<h4>Default VPC is planned to be provisioned</h4><h4>Description</h4>A default VPC is a VPC that is created for your AWS account when you create an AWS account. It includes a default security group and a default network access control list (NACL). Default VPCs have some limitations that might not be suitable for all use cases. Therefore, if you have specific requirements for your VPC, such as custom IP address ranges, support for PrivateLink or Transit Gateway, or the ability to delete the VPC, it might be more appropriate to create a custom VPC instead of using the default VPC.<br><h4>Fix - Buildtime</h4>Terraform<br>It is recommended for this resource to not be configured<br>Goresource \"aws_default_vpc\" \"default\" {<br>tags = {<br>Name = \"Default VPC\"<br>}<br>}<br>"
    },
    "CKV_AWS_149": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-secrets-manager-secret-is-encrypted-using-kms",
        "severity": "MEDIUM",
        "description": "<h4>Secrets Manager secret is not encrypted using KMS Customer Managed Key (CMK)</h4><h4>Description</h4>By default, secrets manager secrets are encrypted using the AWS-managed key aws/secretsmanager. It is best practice to explicitly provide a customer managed key to use instead.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_secretsmanager_secret<br>Argument:  kms_key_id<br><br>aws_s3_bucket.test.tfresource \"aws_secretsmanager_secret\" \"enabled\" {<br>...<br>+ kms_key_id = var.kms_key_id<br>}<br>"
    },
    "CKV_AWS_192": {
        "url": "https://docs.bridgecrew.io/docs/ensure-waf-prevents-message-lookup-in-log4j2",
        "severity": "CRITICAL",
        "description": "<h4>WAF allows message lookup in Log4j2</h4><h4>Description</h4>Using a vulnerable version of Apache Log4j library might enable attackers to exploit a Lookup mechanism that supports making requests using special syntax in a format string which can potentially lead to a risky code execution, data leakage and more.<br>Set your Web Application Firewall (WAF) to prevent executing such mechanism using the rule definition below.<br>Learn more around CVE-2021-44228<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_wafv2_web_acl<br><br>Goresource \"aws_wafv2_web_acl\" \"pass\" {<br>...<br><br>rule {<br>name     = \"AWS-AWSManagedRulesKnownBadInputsRuleSet\"<br>priority = 1<br><br>override_action {<br>none {}<br>}<br><br>statement {<br>managed_rule_group_statement {<br>name        = \"AWSManagedRulesKnownBadInputsRuleSet\"<br>vendor_name = \"AWS\"<br>}<br>}<br><br>...<br>}<br><br>...<br>}<br><br>CloudFormation<br><br>Resource: AWS::WAFv2::WebACL<br><br>TextPass:<br>Type: AWS::WAFv2::WebACL<br>Properties:<br>...<br><br>Rules:<br>- Name: AWS-AWSManagedRulesKnownBadInputsRuleSet<br>Priority: 1<br>Statement:<br>ManagedRuleGroupStatement:<br>VendorName: AWS<br>Name: AWSManagedRulesKnownBadInputsRuleSet<br>OverrideAction:<br>None: {}<br>...<br>"
    },
    "CKV_AWS_172": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_storage_1",
        "severity": "LOW",
        "description": "<h4>Ensure QLDB ledger has deletion protection enabled</h4><h4>Description</h4>Amazon Quantum Ledger Database (Amazon QLDB) is a fully managed ledger database for cryptographically verifiable transaction logging. You can use the QLDB API or the AWS Command Line Interface (AWS CLI) to create, update, and delete ledgers in Amazon QLDB. You can also list all the ledgers in your account, or get information about a specific ledger.<br>Deletion protection is enabled by default. To successfully delete this resource via Terraform, deletion_protection = false must be applied before attempting deletion. In CloudFormation the flag that prevents a ledger from being deleted by any user. If not provided on ledger creation, this feature is enabled (true) by default.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_qldb_ledger<br>Argument:  deletion_protection<br><br>Goresource \"aws_qldb_ledger\" \"sample-ledger\" {<br>name             = \"sample-ledger\"<br>permissions_mode = \"STANDARD\"<br>+ deletion_protection = true<br>}<br><br>CloudFormation<br><br>Resource: AWS::QLDB::Ledger<br>Argument:  DeletionProtection<br><br>YAMLType: AWS::QLDB::Ledger<br>Properties:<br>+  DeletionProtection: true<br>KmsKey: String<br>Name: String<br>PermissionsMode: String<br>Tags:<br>- Tag<br>"
    },
    "CKV_AWS_230": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-nacl-does-not-allow-ingress-from-00000-to-port-20",
        "severity": "LOW",
        "description": "<h4>AWS NACL allows ingress from 0.0.0.0/0 to port 20</h4><h4>Description</h4>Network Access Control List (NACL) is stateless and provides filtering of ingress/egress network traffic to AWS resources. We recommend that NACLs do not allow unrestricted ingress access to port 20. Removing unfettered connectivity to remote console services, such as FTP, reduces a server's exposure to risk.<br><h4>Fix - Buildtime</h4>CloudFormation<br>YAMLResources:<br>InboundRule:<br>Type: AWS::EC2::NetworkAclEntry<br>Properties:<br>NetworkAclId:<br>Ref: MyNACL<br>RuleNumber: 200<br>Protocol: 6<br>RuleAction: allow<br>-      CidrBlock: 0.0.0.0/0<br>+      CidrBlock: 10.0.0.0/32<br>PortRange:<br>From: 20<br>To: 20<br><br>Terraform<br>Goresource \"aws_network_acl_rule\" \"example\" {<br>network_acl_id = aws_network_acl.example.id<br>rule_number    = 200<br>egress         = false<br>protocol       = \"tcp\"<br>rule_action    = \"allow\"<br>- cidr_block     = \"0.0.0.0/0\"<br>+ cidr_block     = \"10.0.0.0/32\"<br>from_port      = 20<br>to_port        = 20<br>}<br>"
    },
    "CKV_AWS_152": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-load-balancer-networkgateway-has-cross-zone-load-balancing-enabled",
        "severity": "LOW",
        "description": "<h4>Load Balancer (Network/Gateway) does not have cross-zone load balancing enabled</h4><h4>Description</h4>Cross-zone load balancing is a feature that distributes incoming traffic evenly across the healthy targets in all enabled availability zones. This can help to ensure that your application is able to handle more traffic and reduce the risk of any single availability zone becoming overloaded and might be impact Load balancer's performance<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_lb<br>Argument: enable_cross_zone_load_balancing<br><br>aws_s3_bucket.test.tfresource \"aws_lb\" \"enabled\" {<br>...<br>+ enable_cross_zone_load_balancing = true<br>}<br>"
    },
    "CKV_AWS_153": {
        "url": "https://docs.bridgecrew.io/docs/autoscaling-groups-should-supply-tags-to-launch-configurations",
        "severity": "LOW",
        "description": "<h4>No tags supplied by Autoscaling groups to launch configurations</h4><h4>Description</h4>Tags help you do the following:<br><br>Control access to Auto Scaling groups based on tags. You can use conditions in your IAM policies to control access to Auto Scaling groups based on the tags on that group.<br>Identify and organize your AWS resources. Many AWS services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related.<br>You can apply tag-based, resource-level permissions in the identity-based policies that you create for Amazon EC2 Auto Scaling. This gives you better control over which resources a user can create, modify, use, or delete.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_autoscaling_group<br>Argument:  launch_configuration, tags<br><br>aws_s3_bucket.test.tfresource \"aws_autoscaling_group\" \"passtag\" {<br>...<br>+ launch_configuration      = aws_launch_configuration.foobar.name<br>+  tags = concat(<br>[<br>{<br>\"key\"                 = \"interpolation1\"<br>\"value\"               = \"value3\"<br>\"propagate_at_launch\" = true<br>},<br>...<br>}<br>"
    },
    "CKV_AWS_173": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_serverless_5",
        "severity": "LOW",
        "description": "<h4>Encryption settings for Lambda environmental variable is not set properly</h4><h4>Description</h4>You can use environment variables to adjust your function's behavior without updating code. An environment variable is a pair of strings that is stored in a function's version-specific configuration. The Lambda runtime makes environment variables available to your code and sets additional environment variables that contain information about the function and invocation request. Environment variables are not evaluated prior to the function invocation. Any value you define is considered a literal string and not expanded. Perform the variable evaluation in your function code.<br><h4>Fix - Buildtime</h4>Terraform<br>aws_lambda_function<br><br>Resource: aws_lambda_function<br>Argument: kms_key_arn<br><br>Goresource \"aws_lambda_function\" \"test_lambda\" {<br>filename      = \"lambda_function_payload.zip\"<br>function_name = \"lambda_function_name\"<br>role          = aws_iam_role.iam_for_lambda.arn<br>handler       = \"index.test\"<br><br># The filebase64sha256() function is available in Terraform 0.11.12 and later<br># For Terraform 0.11.11 and earlier, use the base64sha256() function and the file() function:<br># source_code_hash = \"${base64sha256(file(\"lambda_function_payload.zip\"))}\"<br>source_code_hash = filebase64sha256(\"lambda_function_payload.zip\")<br><br>runtime = \"nodejs12.x\"<br><br>+ kms_key_arn = \"ckv_km\"<br><br>environment {<br>variables = {<br>foo = \"bar\"<br>}<br>}<br>}<br>"
    },
    "CKV_AWS_154": {
        "url": "https://docs.bridgecrew.io/docs/ensure-redshift-is-not-deployed-outside-of-a-vpc",
        "severity": "LOW",
        "description": "<h4>Redshift is deployed outside of a VPC</h4><h4>Description</h4>A VPC is a virtual network in the AWS cloud that is isolated from other virtual networks. When you deploy Redshift in a VPC, you can control the inbound and outbound network traffic to and from your Redshift cluster using security groups and network access control lists (NACLs). This can help to improve the security of your Redshift cluster and protect it from unauthorized access or attacks.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_redshift_cluster<br>Argument: cluster_subnet_group_name<br><br>aws_s3_bucket.test.tfresource \"aws_redshift_cluster\" \"pass\" {<br>...<br>+ cluster_subnet_group_name=\"subnet-ebd9cead\"<br>}<br><br>CloudFormation<br><br>Resource: AWS::Redshift::Cluster<br>Argument: Properties.ClusterSubnetGroupName<br><br>YAMLType: \"AWS::Redshift::Cluster\"<br>Properties:<br>...<br>+   ClusterSubnetGroupName: \"subnet-ebd9cead\"<br>"
    },
    "CKV_AWS_155": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-workspace-user-volumes-are-encrypted",
        "severity": "MEDIUM",
        "description": "<h4>Workspace user volumes are not encrypted</h4><h4>Description</h4>Encrypting your Workspace user volumes helps protect your data from unauthorized access or tampering. That way, you can ensure that only authorized users can access and modify the contents of your volumes. Such action can help protect against external threats such as hackers or malware, as well as internal threats such as accidental or unauthorized access.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_workspaces_workspace<br>Argument:  user_volume_encryption_enabled, volume_encryption_key<br><br>aws_s3_bucket.test.tfresource \"aws_workspaces_workspace\" \"pass\" {<br>...<br>+ user_volume_encryption_enabled = true<br>+ volume_encryption_key          = var.volume_encryption_key<br>...<br>}<br><br>CloudFormation<br><br>Resource: AWS::WorkSpaces::Workspace<br>Argument:  Properties.UserVolumeEncryptionEnabled<br><br>YAMLType: AWS::WorkSpaces::Workspace<br>Properties:<br>...<br>+     UserVolumeEncryptionEnabled: true<br>"
    },
    "CKV_AWS_156": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-workspace-root-volumes-are-encrypted",
        "severity": "MEDIUM",
        "description": "<h4>Workspace root volumes are not encrypted</h4><h4>Description</h4>Encrypting your Workspace root volumes helps protect your data from unauthorized access or tampering. That way, you can ensure that only authorized users can access and modify the contents of your volumes. Such action can help protect against external threats such as hackers or malware, as well as internal threats such as accidental or unauthorized access.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_workspaces_workspace<br>Argument:  root_volume_encryption_enabled<br><br>aws_s3_bucket.test.tfresource \"aws_workspaces_workspace\" \"pass\" {<br>...<br>+ root_volume_encryption_enabled = true<br>...<br>}<br><br>CloudFormation<br><br>Resource: AWS::WorkSpaces::Workspace<br>Argument:  Properties.RootVolumeEncryptionEnabled<br><br>YAMLType: AWS::WorkSpaces::Workspace<br>...<br>Properties:<br>...<br>+   RootVolumeEncryptionEnabled: true<br>"
    },
    "CKV_AWS_159": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-athena-workgroup-is-encrypted",
        "severity": "MEDIUM",
        "description": "<h4>Athena Workgroup is not encrypted</h4><h4>Description</h4>Athena workgroups support full server-side encryption for all data at rest which should be enabled.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_athena_workgroup<br>Argument:  result_configuration.encryption_configuration<br><br>aws_s3_bucket.test.tfresource \"aws_athena_workgroup\" \"test\" {<br>...<br>+ configuration {<br>...<br>+   result_configuration {<br>+     output_location = \"s3://mys3bucket\"<br>+     encryption_configuration {<br>+       encryption_option = \"SSE_KMS\"<br>+       kms_key_arn       = \"mykmsarn\"<br>}<br>}<br>}<br>}<br>"
    },
    "CKV2_AWS_43": {
        "url": "https://docs.bridgecrew.io/docs/ensure-s3-bucket-does-not-allow-access-to-all-authenticated-users",
        "severity": "MEDIUM",
        "description": "<h4>AWS S3 buckets are accessible to any authenticated user</h4><h4>Description</h4>This policy identifies S3 buckets accessible to any authenticated AWS users. Amazon S3 allows customer to store and retrieve any type of content from anywhere in the web. Often, customers have legitimate reasons to expose the S3 bucket to public, for example to host website content. However, these buckets often contain highly sensitive enterprise data which if left accessible to anyone with valid AWS credentials, may result in sensitive data leaks.<br><h4>Fix - Buidtime</h4>Terraform<br>YAMLresource \"aws_s3_bucket_acl\" \"pass\" {<br>bucket = \"name\"<br>access_control_policy {<br>grant {<br>grantee {<br>id   = \"52b113e7a2f25102679df27bb0ae12b3f85be6\"<br>type = \"CanonicalUser\"<br>}<br>permission = \"READ\"<br>}<br>owner {<br>id = data.aws_canonical_user_id.current.id<br>}<br>}<br>}<br>"
    },
    "CKV_AWS_174": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_networking_63",
        "severity": "MEDIUM",
        "description": "<h4>CloudFront web distribution that allow TLS versions 1.0 or lower</h4><h4>Description</h4>This policy identifies AWS CloudFront web distributions which are configured with TLS versions for HTTPS communication between viewers and CloudFront. As a best practice, use TLSv1.1_2016 or later as the minimum protocol version in your CloudFront distribution security policies<br><h4>Fix - Runtime</h4>AWS Console<br><br>Sign in to the AWS console<br>Navigate to CloudFront Distributions Dashboard<br>Click on the reported distribution<br>On 'General' tab, Click on 'Edit' button<br>On 'Edit Distribution' page, Set 'Security Policy' to TLSv1.1_2016 or later as per your requirement.<br>Click on 'Yes, Edit'<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_cloudfront_distribution<br>Argument: minimum_protocol_version<br><br>Goresource \"aws_cloudfront_distribution\" \"pass\" {<br>...<br><br>viewer_certificate {<br>cloudfront_default_certificate = false<br>minimum_protocol_version = \"TLSv1.2_2018\"<br>}<br>}<br>"
    },
    "CKV_AWS_175": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_networking_64",
        "severity": "LOW",
        "description": "<h4>AWS WAF does not have associated rules</h4><h4>Description</h4>AWS WAF is a web application firewall that helps protect web applications from attacks by allowing you to configure rules that allow, block, or monitor (count) web requests based on conditions that you define. These conditions include IP addresses, HTTP headers, HTTP body, URI strings, SQL injection and cross-site scripting.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_wafv2_web_acl<br>Attribute rule - (Optional) The rule blocks used to identify the web requests that you want to allow, block, or count. See Rules below for details.<br><br>Goresource \"aws_wafv2_web_acl\" \"example\" {<br>name        = \"managed-rule-example\"<br>description = \"Example of a managed rule.\"<br>scope       = \"REGIONAL\"<br><br>default_action {<br>allow {}<br>}<br><br>+  rule {<br>name     = \"rule-1\"<br>priority = 1<br><br>override_action {<br>count {}<br>}<br><br>statement {<br>managed_rule_group_statement {<br>name        = \"AWSManagedRulesCommonRuleSet\"<br>vendor_name = \"AWS\"<br><br>excluded_rule {<br>name = \"SizeRestrictions_QUERYSTRING\"<br>}<br><br>excluded_rule {<br>name = \"NoUserAgent_HEADER\"<br>}<br><br>scope_down_statement {<br>geo_match_statement {<br>country_codes = [\"US\", \"NL\"]<br>}<br>}<br>}<br>}<br><br>visibility_config {<br>cloudwatch_metrics_enabled = false<br>metric_name                = \"friendly-rule-metric-name\"<br>sampled_requests_enabled   = false<br>}<br>}<br><br>tags = {<br>Tag1 = \"Value1\"<br>Tag2 = \"Value2\"<br>}<br><br>visibility_config {<br>cloudwatch_metrics_enabled = false<br>metric_name                = \"friendly-metric-name\"<br>sampled_requests_enabled   = false<br>}<br>}<br>"
    },
    "CKV_AWS_161": {
        "url": "https://docs.bridgecrew.io/docs/ensure-rds-database-has-iam-authentication-enabled",
        "severity": "MEDIUM",
        "description": "<h4>RDS database does not have IAM authentication enabled</h4><h4>Description</h4>IAM authentication uses AWS Identity and Access Management (IAM) to authenticate users and applications that connect to your RDS database. This can be more secure than traditional password-based authentication, as it allows you to use IAM policies and multi-factor authentication to control access to your database.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: \"aws_db_instance<br>Argument: iam_database_authentication_enabled<br><br>aws_s3_bucket.test.tfresource \"aws_db_instance\" \"test\" {<br>...<br>+ iam_database_authentication_enabled = true<br>}<br><br>CloudFormation<br><br>Resource: \"AWS::RDS::DBInstance<br>Argument: Properties.EnableIAMDatabaseAuthentication<br><br>YAMLResources:<br>DB:<br>Type: 'AWS::RDS::DBInstance'<br>Properties:<br>Engine: 'mysql' # or 'postgres'<br>...<br>+     EnableIAMDatabaseAuthentication: true<br>"
    },
    "CKV2_AWS_9": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-ebs-are-added-in-the-backup-plans-of-aws-backup",
        "severity": "LOW",
        "description": "<h4>EBS does not have an AWS Backup backup plan</h4><h4>Description</h4>Ensure that EBS are included in your backup plans for the AWS Backup. AWS Backup is a fully managed backup service that helps you protect your data in the cloud by automatically backing up your data to a secure, durable storage location. By creating a backup plan, you can ensure that your data is regularly backed up and can be recovered in the event of data loss or corruption.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_backup_selection, aws_ebs_volume<br>Argument: resources and plan_id of aws_backup_selection<br><br>Goresource \"aws_ebs_volume\" \"ebs_good\" {<br>availability_zone = \"us-west-2a\"<br>size              = 40<br><br>tags = {<br>Name = \"HelloWorld\"<br>}<br>}<br><br><br>resource \"aws_backup_selection\" \"backup_good\" {<br>iam_role_arn = \"arn\"<br>name         = \"tf_example_backup_selection\"<br>plan_id      = \"123456\"<br><br>resources = [<br>aws_ebs_volume.ebs_good.arn<br>]<br>}<br>"
    },
    "CKV_AWS_162": {
        "url": "https://docs.bridgecrew.io/docs/ensure-rds-cluster-has-iam-authentication-enabled",
        "severity": "MEDIUM",
        "description": "<h4>RDS cluster does not have IAM authentication enabled</h4><h4>Description</h4>IAM authentication uses AWS Identity and Access Management (IAM) to authenticate users and applications that connect to your RDS database. This can be more secure than traditional password-based authentication, as it allows you to use IAM policies and multi-factor authentication to control access to your database.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_rds_cluster<br>Argument: iam_database_authentication_enabled<br><br>aws_s3_bucket.test.tfresource \"aws_rds_cluster\" \"enabled\" {<br>...<br>+ iam_database_authentication_enabled = true<br>}<br><br>CloudFormation<br><br>Resource: AWS::RDS::DBCluster<br>Argument: Properties.EnableIAMDatabaseAuthentication<br><br>YAMLResources:<br>Enabled:<br>Type: 'AWS::RDS::DBCluster'<br>Properties:<br>...<br>+     EnableIAMDatabaseAuthentication: true<br>"
    },
    "CKV_AWS_164": {
        "url": "https://docs.bridgecrew.io/docs/ensure-transfer-server-is-not-exposed-publicly",
        "severity": "MEDIUM",
        "description": "<h4>Transfer Server is publicly  exposed</h4><h4>Description</h4>By ensuring that your Azure Transfer Server is not public, you can help protect your data from unauthorized access or tampering. Public Azure Transfer Servers are accessible over the internet, which can make them vulnerable to external threats such as hackers or malware. By making it private, you can help ensure that only authorized users can access the data.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_transfer_server<br>Argument: endpoint_type<br><br>aws_s3_bucket.test.tfresource \"aws_transfer_server\" \"test\" {<br>+ endpoint_type = \"VPC\"<br>protocols   = [\"SFTP\"]<br>}<br><br>CloudFormation<br><br>Resource: AWS::Transfer::Server<br>Argument: Properties.EndpointType<br><br>YAMLResources:<br>VPC:<br>Type: AWS::Transfer::Server<br>Properties:<br>...<br>+     EndpointType: \"VPC\" # or \"VPC_ENDPOINT\"<br>"
    },
    "CKV_AWS_176": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_logging_31",
        "severity": "TBD",
        "description": "<h4>AWS WAF Web Access Control Lists logging is disabled</h4><h4>Description</h4>Amazon WAF is a web application firewall service that lets you monitor web requests that are forwarded to Amazon API Gateway APIs, Amazon CloudFront distributions, or Application Load Balancers in order to help protect them from attacks. To get detailed information about the web traffic analyzed by your Web Access Control Lists (Web ACLs) you must enable logging. The log entries include the time that Amazon WAF received the request from your AWS resource, detailed information about the request, and the action for the rule that each request matched. You can also send these logs to an Amazon Kinesis Firehose delivery stream with a configured storage destination.<br><h4>Fix - Buildtime</h4>Terraform<br>Resource: aws_waf_web_acl<br>Attribute: logging_configuration<br>Goresource \"aws_waf_web_acl\" \"example\" {<br># ... other configuration ...<br>logging_configuration {<br>log_destination = \"${aws_kinesis_firehose_delivery_stream.example.arn}\"<br><br>redacted_fields {<br>field_to_match {<br>type = \"URI\"<br>}<br><br>field_to_match {<br>data = \"referer\"<br>type = \"HEADER\"<br>}<br>}<br>}<br>}<br>"
    },
    "CKV2_AWS_3": {
        "url": "https://docs.bridgecrew.io/docs/ensure-guardduty-is-enabled-to-specific-orgregion",
        "severity": "LOW",
        "description": "<h4>GuardDuty is not enbaled to specific org/region</h4><h4>Description</h4>GuardDuty is a security service provided by Amazon Web Services (AWS) that uses machine learning and threat intelligence to detect potential threats to your AWS accounts and workloads. Enabling GuardDuty in specific regions or within your organization can help you to identify and respond to potential threats more quickly and effectively. This can help to reduce the risk of security breaches and protect your data and systems from malicious activity.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_guardduty_detector, aws_guardduty_organization_configuration<br>Argument: auto_enable of aws_guardduty_organization_configuration<br><br>Goresource \"aws_guardduty_detector\" \"ok\" {<br>enable = true<br>}<br><br>resource \"aws_guardduty_organization_configuration\" \"example\" {<br>auto_enable = true<br>detector_id = aws_guardduty_detector.ok.id<br>}<br>"
    },
    "CKV_AWS_166": {
        "url": "https://docs.bridgecrew.io/docs/ensure-backup-vault-is-encrypted-at-rest-using-kms-cmk",
        "severity": "MEDIUM",
        "description": "<h4>Backup Vault is not encrypted at rest using KMS CMK</h4><h4>Description</h4>Encrypting your data and resources with KMS helps protect your data from unauthorized access or tampering. By encrypting your data, you can ensure that only authorized users can access and decrypt the data, and that the data is protected while in storage or in transit. Such action can help protect against external threats such as hackers or malware, as well as internal threats such as accidental or unauthorized access.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_backup_vault<br>Argument:  kms_key_arn<br><br>aws_s3_bucket.test.tfresource \"aws_backup_vault\" \"backup_with_kms_key\" {<br>...<br>+ kms_key_arn = aws_kms_key.example.arn<br>}<br><br>CloudFormation<br><br>Resource: AWS::Backup::BackupVault<br>Argument:  Properties.EncryptionKeyArn<br><br>YAMLType: AWS::Backup::BackupVault<br>Properties:<br>...<br>+     EncryptionKeyArn: example.arn/aws_kms_key<br>"
    },
    "CKV_AWS_167": {
        "url": "https://docs.bridgecrew.io/docs/ensure-glacier-vault-access-policy-is-not-public-by-only-allowing-specific-services-or-principals-to-access-it",
        "severity": "MEDIUM",
        "description": "<h4>Glacier Vault access policy is public and not restricted to specific services or principals</h4><h4>Description</h4>It is generally a best practice to restrict access to Amazon S3 Glacier vaults to only the specific services or principals that require access. This can help to reduce the risk of unauthorized access to the data stored in your vaults and protect against potential data breaches.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_glacier_vault<br>Argument:  Statement<br><br>aws_s3_bucket.test.tfresource \"aws_glacier_vault\" \"my_archive1\" {<br>...<br>access_policy = <<EOF<br>{<br>\"Version\":\"2012-10-17\",<br>\"Statement\":[<br>{<br>\"Sid\": \"add-read-only-perm\",<br>\"Principal\": \"*\",<br>+  \"Effect\": \"Deny\",<br>\"Action\": [<br>\"glacier:InitiateJob\",<br>\"glacier:GetJobOutput\"<br>],<br>\"Resource\": \"arn:aws:glacier:eu-west-1:432981146916:vaults/MyArchive\"<br>}<br>]<br>}<br>}<br>"
    },
    "CKV2_AWS_10": {
        "url": "https://docs.bridgecrew.io/docs/ensure-cloudtrail-trails-are-integrated-with-cloudwatch-logs",
        "severity": "MEDIUM",
        "description": "<h4>CloudTrail trail is not integrated with CloudWatch Log</h4><h4>Description</h4>AWS CloudTrail is a web service that records AWS API calls made in a given AWS account. The recorded information includes the identity of the API caller, the time of the API call, the source IP address of the API caller, the request parameters, and the response elements returned by the AWS service. CloudTrail uses Amazon S3 for log file storage and delivery, so log files are stored durably. In addition to capturing CloudTrail logs within a specified S3 bucket for long term analysis, realtime analysis can be performed by configuring CloudTrail to send logs to CloudWatch logs. For a trail that is enabled in all regions in an account, CloudTrail sends log files from all those regions to a CloudWatch logs log group. It is recommended that CloudTrail logs be sent to CloudWatch logs.<br>\ud83d\udcd8NoteThe intent of this recommendation is to ensure AWS account activity is being captured, monitored, and appropriately alarmed on. CloudWatch logs is a native way to accomplish this using AWS services but does not preclude the use of an alternate solution.<br>Sending CloudTrail logs to CloudWatch logs will facilitate real-time and historic activity logging based on user, API, resource, and IP address, and provides opportunity to establish alarms and notifications for anomalous or sensitivity account activity.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_cloudtrail<br>Argument: cloud_watch_logs_group_arn<br><br>Goresource \"aws_cloudtrail\" \"aws_cloudtrail_ok\" {<br>name                          = \"tf-trail-foobar\"<br>cloud_watch_logs_group_arn = \"${aws_cloudwatch_log_group.example.arn}:*\"<br>}<br>"
    },
    "CKV_AWS_168": {
        "url": "https://docs.bridgecrew.io/docs/ensure-sqs-queue-policy-is-not-public-by-only-allowing-specific-services-or-principals-to-access-it",
        "severity": "MEDIUM",
        "description": "<h4>SQS queue policy is public and access is not restricted to specific services or principals</h4><h4>Description</h4>It is generally a best practice to restrict access to Amazon Simple Queue Service (SQS) queues to only the specific services or principals that require access. This can help to reduce the risk of unauthorized access to the data stored in your queues and protect against potential data breaches.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_sqs_queue_policy<br>Argument:  Statement<br><br>aws_s3_bucket.test.tfresource \"aws_sqs_queue_policy\" \"test\" {<br>...<br>policy = <<POLICY<br>{<br>\"Version\":\"2012-10-17\",<br>\"Statement\":[<br>{<br>\"Principal\": \"*\",<br>+         \"Effect\": \"Deny\",<br>\"Action\": \"sqs:SendMessage\",<br>\"Resource\": \"${aws_sqs_queue_policy.q.arn}\"<br>}<br>]<br>}<br>POLICY<br>}<br>"
    },
    "CKV_AWS_169": {
        "url": "https://docs.bridgecrew.io/docs/ensure-sns-topic-policy-is-not-public-by-only-allowing-specific-services-or-principals-to-access-it",
        "severity": "MEDIUM",
        "description": "<h4>SNS topic policy is public and access is not restricted to specific services or principals</h4><h4>Description</h4>It is generally a best practice to restrict access to Amazon SNS topics to only the specific services or principals that require access. This can help to reduce the risk of unauthorized access to the data stored in your topics and protect against potential data breaches.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_sns_topic_policy<br>Argument:  Statement<br><br>aws_s3_bucket.test.tfresource \"aws_sns_topic_policy\" \"sns_tp1\" {<br>...<br>policy = <<POLICY<br>{<br>\"Version\":\"2012-10-17\",<br>\"Statement\":[<br>{<br>\"Principal\": \"*\",<br>+     \"Effect\": \"Deny\",<br>\"Action\": [<br>\"SNS:Subscribe\",<br>\"SNS:SetTopicAttributes\",<br>\"SNS:RemovePermission\",<br>\"SNS:Receive\",<br>\"SNS:Publish\",<br>\"SNS:ListSubscriptionsByTopic\",<br>\"SNS:GetTopicAttributes\",<br>\"SNS:DeleteTopic\",<br>\"SNS:AddPermission\",<br>],<br>\"Resource\": \"${aws_sns_topic.test.arn}\"<br>}<br>]<br>}<br>POLICY<br>}<br>"
    },
    "CKV_AWS_177": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_97",
        "severity": "TBD",
        "description": "<h4>[Policy Title]</h4><h4>Description</h4>This is a simple check to ensure that Kinesis Video Stream is using AWS key management - KMS to encrypt its contents. To resolve add the ARN of your KMS or link on creation of the cluster.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_kinesis_video_stream<br>Attribute: kms_key_id - (Optional) The ID of the AWS Key Management Service (AWS KMS) key that you want Kinesis Video Streams to use to encrypt stream data. If no key ID is specified, the default, Kinesis Video-managed key (aws/kinesisvideo) is used.<br><br>Goresource \"aws_kinesis_video_stream\" \"default\" {<br>name                    = \"terraform-kinesis-video-stream\"<br>data_retention_in_hours = 1<br>device_name             = \"kinesis-video-device-name\"<br>media_type              = \"video/h264\"<br>+ kms_ke_id                             = \"ckv_kms\"<br>tags = {<br>Name = \"terraform-kinesis-video-stream\"<br>}<br>}<br>"
    },
    "CKV_AWS_179": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_99",
        "severity": "TBD",
        "description": "<h4>AWS FSX Windows filesystem not encrypted using Customer Managed Key</h4><h4>Description</h4>This is a simple check to ensure that FSX Windows file system is using AWS key management - KMS to encrypt its contents. To resolve add the ARN of your KMS or link on creation of the cluster<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_fsx_windows_file_system<br>Attribute:  kms_key_id<br><br>Goresource \"aws_fsx_windows_file_system\" \"example\" {<br>active_directory_id = aws_directory_service_directory.example.id<br>kms_key_id          = aws_kms_key.example.arn<br>storage_capacity    = 300<br>subnet_ids          = [aws_subnet.example.id]<br>throughput_capacity = 1024<br>}<br>"
    },
    "CKV_AWS_181": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_101",
        "severity": "LOW",
        "description": "<h4>AWS S3 Object Copy not encrypted using Customer Managed Key</h4><h4>Description</h4>This is a simple check to ensure that the S3 Object Copy is using AWS key management - KMS to encrypt its contents. To resolve add the ARN of your KMS or link on creation of the cluster.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_s3_object_copy<br>Attribute: kms_key_id - (Optional) Specifies the AWS KMS Key ARN to use for object encryption. This value is a fully qualified ARN of the KMS Key.<br><br>Goresource \"aws_s3_object_copy\" \"test\" {<br>bucket = \"destination_bucket\"<br>key    = \"destination_key\"<br>source = \"source_bucket/source_key\"<br>+ kms_key_id = \"aws_kms_key.foo.arn\"<br><br><br>grant {<br>uri         = \"http://acs.amazonaws.com/groups/global/AllUsers\"<br>type        = \"Group\"<br>permissions = [\"READ\"]<br>}<br>}<br>"
    },
    "CKV_AWS_171": {
        "url": "https://docs.bridgecrew.io/docs/ensure-emr-cluster-security-configuration-encryption-uses-sse-kms",
        "severity": "MEDIUM",
        "description": "<h4>EMR cluster is not configured with SSE KMS for data at rest encryption (Amazon S3 with EMRFS)</h4><h4>Description</h4>Enabling Amazon S3 Server-Side Encryption with AWS Key Management Service (SSE-KMS) for your Amazon Elastic MapReduce (EMR) cluster's security configuration can help to protect the data stored in your cluster.<br>SSE-KMS uses a customer master key (CMK) in the AWS KMS to encrypt and decrypt data stored in Amazon S3.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_emr_security_configuration<br>Argument:  EnableAtRestEncryption<br><br>aws_emr_security_configuration.test.tfresource \"aws_emr_security_configuration\" \"test\" {<br>...<br>configuration = <<EOF<br>{<br>\"EncryptionConfiguration\": {<br>\"EnableAtRestEncryption\": true,<br>\"AtRestEncryptionConfiguration\": {<br>\"S3EncryptionConfiguration\": {<br>+       \"EncryptionMode\": \"SSE-KMS\",<br>+       \"AwsKmsKey\": \"${module.encryption_module.kms_key_alias}\"<br>},<br>\"LocalDiskEncryptionConfiguration\": {<br>\"EncryptionKeyProviderType\": \"AwsKms\",<br>\"AwsKmsKey\": \"${module.encryption_module.kms_key_alias}\"<br>}<br>},<br>\"EnableInTransitEncryption\": true<br>}<br>}<br>EOF<br>}<br>"
    },
    "CKV_AWS_182": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_102",
        "severity": "LOW",
        "description": "<h4>AWS  Doc DB not encrypted using Customer Managed Key</h4><h4>Description</h4>This is a simple check to ensure that the DocDB is using AWS key management - KMS to encrypt its contents. To resolve add the ARN of your KMS or link on creation of the cluster.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_docdb_cluster<br>Argument: kms_key_id - (Optional) The ARN for the KMS encryption key. When specifying kms_key_id, storage_encrypted needs to be set to true.<br><br>Goresource \"aws_docdb_cluster\" \"docdb\" {<br>cluster_identifier      = \"my-docdb-cluster\"<br>engine                  = \"docdb\"<br>master_username         = \"foo\"<br>master_password         = \"mustbeeightchars\"<br>backup_retention_period = 5<br>preferred_backup_window = \"07:00-09:00\"<br>skip_final_snapshot     = true<br>+ kms_key_id                        = \"ckv_kms\"<br>}<br>"
    },
    "CKV_AWS_187": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_107",
        "severity": "LOW",
        "description": "<h4>AWS Sagemaker domain not encrypted using Customer Managed Key</h4><h4>Description</h4>Amazon SageMaker Feature Store enables you to create two types of stores: an online store or offline store. The online store is used for low latency real-time inference use cases whereas the offline store is used for training and batch inference use cases. When you create a feature group for online or offline use you can provide a AWS Key Management Service customer managed key to encrypt all your data at rest. In case you do not provide a AWS KMS key then we ensure that your data is encrypted on the server side using an AWS owned AWS KMS key or AWS managed AWS KMS key.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_sagemaker_domain<br>Argument: kms_key_id - (Optional) The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.<br><br>Goresource \"aws_sagemaker_domain\" \"example\" {<br>domain_name = \"example\"<br>auth_mode   = \"IAM\"<br>vpc_id      = aws_vpc.test.id<br>subnet_ids  = [aws_subnet.test.id]<br>+ kms_key_id = \"ckv_kms\"<br>default_user_settings {<br>execution_role = aws_iam_role.test.arn<br>}<br>}<br>"
    },
    "CKV_AWS_95": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_logging_30",
        "severity": "LOW",
        "description": "<h4>AWS API Gateway V2 has Access Logging is disabled</h4><h4>Description</h4>Enabling the custom access logging option in API Gateway allows delivery of custom logs to CloudWatch Logs, which can be analyzed using CloudWatch Logs Insights. Using custom domain names in Amazon API Gateway allows insights into requests sent to each custom domain name. If there is more than one custom domain name mapped to a single API, understanding the quantity and type of requests by domain name may help understand request patterns.<br><h4>Fix - Runtime</h4>AWS Console<br>Procedure:<br><br>Log in to the AWS Management Console at [https://console.aws.amazon.com/].<br>Open the Amazon API Gateway console.<br>Find the Stage Editor for your API.<br>On the Stage Editor pane, choose the Logs/Tracing tab.<br>On the Logs/Tracing tab, under CloudWatch Settings, do the following to enable execution logging.<br>Select the Enable CloudWatch Logs check box.<br>For Log level, choose INFO to generate execution logs for all requests. Or, choose ERROR to generate execution logs only for requests to your API that result in an error.<br>Select the Log full requests/responses data check box for a REST API. Or, select the Log full message data check box for a WebSocket API.<br>Under Custom Access Logging, select the Enable Access Logging check box.<br>For Access Log Destination ARN, enter the ARN of a CloudWatch log group or an Amazon Kinesis Data Firehose stream.<br>Enter a Log Format. For guidance, you can choose CLF, JSON, XML, or CSV to see an example in that format.<br>Click Save Changes.<br><br><h4>Fix - Buildtime</h4>CloudFormation<br><br>Resource: AWS:: AWS::ApiGatewayV2::Stage<br>Argument: AccessLogSettings<br><br>YAMLMyStage:<br>Type: 'AWS::ApiGatewayV2::Stage'<br>Properties:<br>StageName: Prod<br><h4>Description: Prod Stage</h4>DeploymentId: !Ref MyDeployment<br>ApiId: !Ref CFNWebSocket<br>DefaultRouteSettings:<br>DetailedMetricsEnabled: true<br>LoggingLevel: INFO<br>DataTraceEnabled: false<br>ThrottlingBurstLimit: 10<br>ThrottlingRateLimit: 10<br>+  AccessLogSettings:<br>DestinationArn: 'arn:aws:logs:us-east-1:123456789:log-group:my-log-group'<br>Format: >-<br>{\"requestId\":\"$context.requestId\", \"ip\": \"$context.identity.sourceIp\",<br>\"caller\":\"$context.identity.caller\",<br>\"user\":\"$context.identity.user\",\"requestTime\":\"$context.requestTime\",<br>\"eventType\":\"$context.eventType\",\"routeKey\":\"$context.routeKey\",<br>\"status\":\"$context.status\",\"connectionId\":\"$context.connectionId\"}<br>"
    },
    "CKV_AWS_150": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_networking_62",
        "severity": "MEDIUM",
        "description": "<h4>Deletion protection disabled for load balancer</h4><h4>Description</h4>This policy identifies Elastic Load Balancers v2 (ELBv2) which are configured with deletion protection feature disabled. Enabling delete protection for these ELBs prevents irreversible data loss resulting from accidental or malicious operations.<br>For more details refer: https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#deletion-protection<br><h4>Fix - Runtime</h4>AWS Console<br><br>Log in to the AWS console<br>In the console, select the specific region from the region drop-down on the top right corner, for which the alert is generated<br>Go to the EC2 Dashboard, and select 'Load Balancers'<br>Click on the reported Load Balancer<br>On the Description tab, choose 'Edit attributes'<br>On the Edit load balancer attributes page, select 'Enable' for 'Delete Protection'<br>Click on 'Save' to save your changes<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_lb<br>Argument: enable_deletion_protection<br><br>Goresource \"aws_lb\" \"test_success\" {<br>...<br>+ enable_deletion_protection = true<br>}<br>"
    },
    "CKV_AWS_180": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_100",
        "severity": "LOW",
        "description": "<h4>AWS Image Builder component not encrypted using Customer Managed Key</h4><h4>Description</h4>This is a simple check to ensure that Image builder component is using AWS key management - KMS to encrypt its contents. To resolve add the ARN of your KMS or link on creation of the component.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_imagebuilder_component<br>Attribute: kms_key_id - (Optional) Amazon Resource Name (ARN) of the Key Management Service (KMS) Key used to encrypt the component.<br><br>Goresource \"aws_imagebuilder_component\" \"example\" {<br>data = yamlencode({<br>phases = [{<br>name = \"build\"<br>steps = [{<br>action = \"ExecuteBash\"<br>inputs = {<br>commands = [\"echo 'hello world'\"]<br>}<br>name      = \"example\"<br>onFailure = \"Continue\"<br>}]<br>}]<br>schemaVersion = 1.0<br>})<br>name     = \"example\"<br>platform = \"Linux\"<br>version  = \"1.0.0\"<br>kms_key_id = \"ckv_kms\"<br>}<br>"
    },
    "CKV_AWS_183": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_103",
        "severity": "LOW",
        "description": "<h4>AWS EBS Snapshot Copy not encrypted using Customer Managed Key</h4><h4>Description</h4>This is a simple check to ensure that the EBS Snapshot copy is using AWS key management - KMS to encrypt its contents. To resolve add the ARN of your KMS or link on creation of the snapshot.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_ebs_snapshot_copy<br>Attribute: kms_key_id - The ARN for the KMS encryption key.<br><br>Goresource \"aws_ebs_snapshot_copy\" \"example_copy\" {<br>source_snapshot_id = aws_ebs_snapshot.example_snapshot.id<br>source_region      = \"us-west-2\"<br>+ kms_key_id           = \"ckv_kms\"<br>tags = {<br>Name = \"HelloWorld_copy_snap\"<br>}<br>}<br>"
    },
    "CKV_AWS_184": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_104",
        "severity": "MEDIUM",
        "description": "<h4>AWS Elastic File System (EFS) not encrypted using Customer Managed Key</h4><h4>Description</h4>This policy identifies Elastic File Systems (EFSs) which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your EFS data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4>AWS Console<br>AWS EFS Encryption of data at rest can only be enabled during file system creation. So to resolve this alert, create a new EFS with encryption enabled with the customer-managed key, then migrate all required data from the reported EFS to this newly created EFS and delete reported EFS.<br>To create new EFS with encryption enabled, perform the following:<br><br>Sign into the AWS console<br>In the console, select the specific region from region drop down on the top right corner, for which the alert is generated<br>Navigate to EFS dashboard<br>Click on 'File systems' (Left Panel)<br>Click on 'Create file system' button<br>On the 'Configure file system access' step, specify EFS details as per your requirements and Click on 'Next Step'<br>On the 'Configure optional settings' step, Under 'Enable encryption' Choose 'Enable encryption of data at rest' and Select customer managed key [i.e. Other than (default)aws/elasticfilesystem] from 'Select KMS master key' dropdown list along with other parameters and Click on 'Next Step'<br>On the 'Review and create' step, Review all your setting and Click on 'Create File System' button<br><br>To delete reported EFS which does not has encryption, perform the following:<br><br>Sign into the AWS console<br>In the console, select the specific region from region drop down on the top right corner, for which the alert is generated<br>Navigate to EFS dashboard<br>Click on 'File systems' (Left Panel)<br>Select the reported file system<br>Click on 'Actions' drop-down<br>Click on 'Delete file system'<br>In the 'Permanently delete file system' popup box, To confirm the deletion enter the file system's ID and Click on 'Delete File System<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_efs_file_system<br>Arguments: encrypted<br><br>Goresource \"aws_efs_file_system\" \"enabled\" {<br>creation_token = \"example\"<br>kms_key_id = <kms key><br>}<br>"
    },
    "CKV_AWS_186": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_106",
        "severity": "LOW",
        "description": "<h4>AWS S3 Object Copy not encrypted using Customer Managed Key</h4><h4>Description</h4>This is a simple check to ensure that the S3 bucket Object is using AWS key management - KMS to encrypt its contents. To resolve add the ARN of your KMS or link on creation of the object.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_s3_bucket_object<br>Attribute: kms_key_id - (Optional) Specifies the AWS KMS Key ARN to use for object encryption. This value is a fully qualified ARN of the KMS Key.<br><br>Goresource \"aws_s3_bucket_object\" \"object\" {<br>bucket = \"your_bucket_name\"<br>key    = \"new_object_key\"<br>source = \"path/to/file\"<br>+ kms_key_id = \"ckv_kms\"<br><br># The filemd5() function is available in Terraform 0.11.12 and later<br># For Terraform 0.11.11 and earlier, use the md5() function and the file() function:<br># etag = \"${md5(file(\"path/to/file\"))}\"<br>etag = filemd5(\"path/to/file\")<br>}<br>"
    },
    "CKV_AWS_189": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_109",
        "severity": "LOW",
        "description": "<h4>AWS EBS Volume not encrypted using Customer Managed Key</h4><h4>Description</h4>Amazon EBS automatically creates a unique AWS managed key in each Region where you store AWS resources. This KMS key has the alias alias/aws/ebs. By default, Amazon EBS uses this KMS key for encryption. Alternatively, you can specify a symmetric customer managed key that you created as the default KMS key for EBS encryption. Using your own KMS key gives you more flexibility, including the ability to create, rotate, and disable KMS keys.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_ebs_volume<br>Attribute: kms_key_id - (Optional) The ARN for the KMS encryption key. When specifying kms_key_id, encrypted needs to be set to true. Note: Terraform must be running with credentials which have the GenerateDataKeyWithoutPlaintext permission on the specified KMS key as required by the EBS KMS CMK volume provisioning process to prevent a volume from being created and almost immediately deleted.<br><br>Goresource \"aws_ebs_volume\" \"example\" {<br>availability_zone = \"us-west-2a\"<br>size              = 40<br>+ kms_key_id = \"ckv_kms\"<br>tags = {<br>Name = \"HelloWorld\"<br>}<br>}<br>"
    },
    "CKV_AWS_190": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_110",
        "severity": "TBD",
        "description": "<h4>Ensure lustre file systems is encrypted by KMS using a customer managed Key (CMK)</h4><h4>Description</h4>Amazon FSx for Lustre uses a KMS key, either the AWS managed key for Amazon FSx or a custom KMS key, to encrypt and decrypt file system data. All scratch FSx for Lustre file systems are encrypted at rest with keys managed by the service. Data is encrypted using an XTS-AES-256 block cipher. Data is automatically encrypted before being written to the file system, and is automatically decrypted as it is read. The keys used to encrypt scratch file systems at-rest are unique per file system and destroyed after the file system is deleted. For persistent file systems, you choose the KMS key used to encrypt and decrypt data, either the AWS managed key for Amazon FSx or a custom KMS key. You specify which key to use when you create a persistent file system. You can enable, disable, or revoke grants on this KMS key.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_fsx_windows_file_system<br>Argument: kms_key_id<br><br>Goresource \"aws_fsx_windows_file_system\" \"example\" {<br>active_directory_id = aws_directory_service_directory.example.id<br>kms_key_id          = aws_kms_key.example.arn<br>storage_capacity    = 300<br>subnet_ids          = [aws_subnet.example.id]<br>throughput_capacity = 1024<br>}<br>"
    },
    "CKV_AWS_191": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_111",
        "severity": "LOW",
        "description": "<h4>AWS Elasticache replication group not configured with CMK key</h4><h4>Description</h4>ElastiCache for Redis offers default (service managed) encryption at rest, as well as ability to use your own symmetric customer managed AWS KMS keys in AWS Key Management Service (KMS).<br>Data stored on SSDs (solid-state drives) in data tiering enabled clusters is always encrypted by default. However, when the cluster is backed up, the snapshot data is not automatically encrypted. Encryption needs to be enabled on the snapshot.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_elasticache_replication_group<br>Attribute: kms_key_id - (Optional) The ARN of the key that you wish to use if encrypting at rest. If not supplied, uses service managed encryption. Can be specified only if at_rest_encryption_enabled = true.<br><br>Goresource \"aws_elasticache_replication_group\" \"example\" {<br>automatic_failover_enabled    = true<br>availability_zones            = [\"us-west-2a\", \"us-west-2b\"]<br>replication_group_id          = \"tf-rep-group-1\"<br>replication_group_description = \"test description\"<br>node_type                     = \"cache.m4.large\"<br>number_cache_clusters         = 2<br>parameter_group_name          = \"default.redis3.2\"<br>port                          = 6379<br><br><br>+ kms_key_id = \"arm:ckv\"<br>}<br>}<br>"
    },
    "CKV2_AWS_23": {
        "url": "https://docs.bridgecrew.io/docs/ensure-route53-a-record-has-an-attached-resource",
        "severity": "MEDIUM",
        "description": "<h4>Route53 A Record does not have Attached Resource</h4><h4>Description</h4>This check ensures that Route53 A records point to resources part of your Account rather than just random IP addresses. On the platform this check additionally compares IP's against provisioned EIP. In Checkov the graph correlates the A record against know AWS resources from EIP to Global Accelerator.<br><h4>Fix - Buildtime</h4>Terraform<br>** Resource: aws_route53_record<br>Goresource \"aws_route53_record\" \"pass\" {<br>zone_id = data.aws_route53_zone.primary.zone_id<br>name    = \"dns.freebeer.site\"<br>type    = \"A\"<br>ttl     = \"300\"<br>records = [aws_eip.fixed.public_ip]<br>}<br>"
    },
    "CKV_AWS_228": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-elasticsearch-domain-uses-an-updated-tls-policy",
        "severity": "LOW",
        "description": "<h4>AWS Elasticsearch domain does not use an updated TLS policy</h4><h4>Description</h4>The Transport Layer Security (TLS) protocol secures transmission of data between servers and web browsers, over the Internet, using standard encryption technology. To follow security best practices and the latest PCI compliance standards, enable the latest version of TLS protocol (i.e. TLS 1.2) for all your AWS Elasticsearch domains.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Goresource \"aws_elasticsearch_domain\" \"pass\" {<br>domain_name = \"pass\"<br><br>domain_endpoint_options {<br>enforce_https       = false<br>tls_security_policy = \"Policy-Min-TLS-1-2-2019-07\"<br>}<br><br>cluster_config {<br>instance_count = 2<br>}<br><br>encrypt_at_rest {<br>enabled = false<br>}<br><br>node_to_node_encryption {<br>enabled = false<br>}<br>}<br>"
    },
    "CKV_AWS_232": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-nacl-does-not-allow-ingress-from-00000-to-port-22",
        "severity": "LOW",
        "description": "<h4>AWS NACL allows ingress from 0.0.0.0/0 to port 22</h4><h4>Description</h4>Network Access Control List (NACL) is stateless and provides filtering of ingress/egress network traffic to AWS resources. We recommend that NACLs do not allow unrestricted ingress access to port 22. Removing unfettered connectivity to remote console services, such as SSH, reduces a server's exposure to risk.<br><h4>Fix - Buildtime</h4>CloudFormation<br>YAMLResources:<br>InboundRule:<br>Type: AWS::EC2::NetworkAclEntry<br>Properties:<br>NetworkAclId:<br>Ref: MyNACL<br>RuleNumber: 200<br>Protocol: 6<br>RuleAction: allow<br>-      CidrBlock: 0.0.0.0/0<br>+      CidrBlock: 10.0.0.0/32<br>PortRange:<br>From: 22<br>To: 22<br><br>Terraform<br>Goresource \"aws_network_acl_rule\" \"example\" {<br>network_acl_id = aws_network_acl.example.id<br>rule_number    = 200<br>egress         = false<br>protocol       = \"tcp\"<br>rule_action    = \"allow\"<br>- cidr_block     = \"0.0.0.0/0\"<br>+ cidr_block     = \"10.0.0.0/32\"<br>from_port      = 22<br>to_port        = 22<br>}<br>"
    },
    "CKV_AWS_120": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-api-gateway-caching-is-enabled",
        "severity": "LOW",
        "description": "<h4>AWS API Gateway caching is disabled</h4><h4>Description</h4>A cache cluster caches responses. With caching, you can reduce the number of calls made to your endpoint and also improve the latency of requests to your API.<br><h4>Fix - Runtime</h4><br>Go to the API Gateway console.<br>Select an API.<br>Select Stages.<br>In the Stages list for the API, select the required stage.<br>Go to the Settings tab.<br>Select Enable API cache.<br>Wait until cache creation is complete.<br><br><h4>Fix - Buildtime</h4>Terraform<br>resource \"aws_api_gateway_rest_api\" \"example\" {<br>...<br>+ cache_cluster_enabled = true<br>...<br>}<br><br>CloudFormation<br>Resources:<br>Prod:<br>Type: AWS::ApiGateway::Stage<br>Properties:<br>...<br>+ CacheClusterEnabled: True<br>"
    },
    "CKV_AWS_198": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-rds-security-groups-are-defined",
        "severity": "LOW",
        "description": "<h4>AWS RDS security groups are not defined</h4><h4>Description</h4>By ensuring that AWS RDS security groups are defined, you can help protect your instances from unauthorized access and ensure that only authorized traffic is allowed to reach your instances. This can help prevent data breaches and other security incidents, and can also help ensure that your instances are not overwhelmed by unwanted traffic.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_db_security_group\" \"exists\" {<br>name = \"rds_sg\"<br><br>ingress {<br>cidr = \"10.0.0.0/24\"<br>}<br>}<br>"
    },
    "CKV2_AWS_8": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-rds-clusters-has-backup-plan-of-aws-backup",
        "severity": "LOW",
        "description": "<h4>RDS clusters do not have an AWS Backup backup plan</h4><h4>Description</h4>Ensure that RDS clusters are included in your backup plans for the AWS Backup. AWS Backup is a fully managed backup service that helps you protect your data in the cloud by automatically backing up your data to a secure, durable storage location. By creating a backup plan, you can ensure that your data is regularly backed up and can be recovered in the event of data loss or corruption.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_rds_cluster, aws_backup_plan, aws_backup_selection<br>Argument: plan_id and resources<br><br>Goresource \"aws_rds_cluster\" \"rds_cluster_good\" {<br>cluster_identifier      = \"aurora-cluster-demo\"<br>engine                  = \"aurora-mysql\"<br>engine_version          = \"5.7.mysql_aurora.2.03.2\"<br>availability_zones      = [\"us-west-2a\", \"us-west-2b\", \"us-west-2c\"]<br>database_name           = \"mydb\"<br>master_username         = \"foo\"<br>master_password         = \"bar\"<br>}<br><br><br>resource \"aws_backup_plan\" \"example\" {<br>name = \"tf_example_backup_plan\"<br><br>rule {<br>rule_name         = \"tf_example_backup_rule\"<br>target_vault_name = \"vault-name\"<br>schedule          = \"cron(0 12 * * ? *)\"<br>}<br>}<br><br>resource \"aws_backup_selection\" \"backup_good\" {<br>iam_role_arn = \"arn:partition:service:region:account-id:resource-id\"<br>name         = \"tf_example_backup_selection\"<br>plan_id      = aws_backup_plan.example.id<br><br>resources = [<br>aws_rds_cluster.rds_cluster_good.arn<br>]<br>}<br>"
    },
    "CKV_AWS_263": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-app-flow-flow-uses-customer-managed-keys-cmks",
        "severity": "LOW",
        "description": "<h4>AWS App Flow flow does not use Customer Managed Keys (CMKs)</h4><h4>Description</h4>This policy identifies App Flow flow which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your App Flow flow data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_appflow_flow\" \"pass\" {<br>name = \"example\"<br><br>source_flow_config {<br>connector_type = \"S3\"<br>source_connector_properties {<br>s3 {<br>bucket_name   = aws_s3_bucket_policy.example_source.bucket<br>bucket_prefix = \"example\"<br>}<br>}<br>}<br><br>destination_flow_config {<br>connector_type = \"S3\"<br>destination_connector_properties {<br>s3 {<br>bucket_name = aws_s3_bucket_policy.example_destination.bucket<br><br>s3_output_format_config {<br>prefix_config {<br>prefix_type = \"PATH\"<br>}<br>}<br>}<br>}<br>}<br><br>task {<br>source_fields     = [\"exampleField\"]<br>destination_field = \"exampleField\"<br>task_type         = \"Map\"<br><br>connector_operator {<br>s3 = \"NO_OP\"<br>}<br>}<br><br>kms_arn = aws_kms_key.example.arn<br><br>trigger_config {<br>trigger_type = \"OnDemand\"<br>}<br>}<br>"
    },
    "CKV_AWS_195": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-glue-component-is-associated-with-a-security-configuration",
        "severity": "LOW",
        "description": "<h4>AWS Glue component is not associated with a security configuration</h4><h4>Description</h4>A security configuration specifies the encryption settings for data stored on data stores and for data in transit. By associating your Glue components with a security configuration, you can ensure that your data is encrypted in accordance with your security requirements.<br>Encrypting your data can help protect it from unauthorized access and ensure the confidentiality of your data. This is especially important for sensitive data, such as financial or personal information.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Textresource \"aws_glue_crawler\" \"enabled\" {<br>database_name = \"aws_glue_catalog_database.example.name\"<br>name          = \"example\"<br>role          = \"aws_iam_role.example.arn\"<br><br>security_configuration = \"aws_glue_security_configuration.example.name\"<br>}<br><br>resource \"aws_glue_dev_endpoint\" \"enabled\" {<br>name     = \"example\"<br>role_arn = \"aws_iam_role.example.arn\"<br><br>security_configuration = \"aws_glue_security_configuration.example.name\"<br>}<br><br>resource \"aws_glue_job\" \"enabled\" {<br>name     = \"example\"<br>role_arn = \"aws_iam_role.example.arn\"<br><br>security_configuration = \"aws_glue_security_configuration.example.name\"<br><br>command {<br>script_location = \"s3://aws_s3_bucket.example.bucket/example.py\"<br>}<br>}<br>"
    },
    "CKV_AWS_218": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-cloudsearch-uses-the-latest-transport-layer-security-tls-1",
        "severity": "LOW",
        "description": "<h4>AWS Cloudsearch does not use the latest (Transport Layer Security) TLS</h4><h4>Description</h4>The Transport Layer Security (TLS) protocol secures transmission of data between servers and web browsers, over the Internet, using standard encryption technology. To follow security best practices and the latest PCI compliance standards, enable the latest version of TLS protocol (i.e. TLS 1.2) for all your AWS Cloudsearch domains.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_cloudsearch_domain\" \"pass\" {<br>name = \"example-domain\"<br><br>scaling_parameters {<br>desired_instance_type = \"search.medium\"<br>}<br><br>index_field {<br>name            = \"headline\"<br>type            = \"text\"<br>search          = true<br>return          = true<br>sort            = true<br>highlight       = false<br>analysis_scheme = \"_en_default_\"<br>}<br><br>index_field {<br>name   = \"price\"<br>type   = \"double\"<br>search = true<br>facet  = true<br>return = true<br>sort   = true<br>}<br>endpoint_options {<br>enforce_https       = false<br>tls_security_policy = \"Policy-Min-TLS-1-2-2019-07\"<br>}<br>}<br>"
    },
    "CKV2_AWS_11": {
        "url": "https://docs.bridgecrew.io/docs/logging_9-enable-vpc-flow-logging",
        "severity": "MEDIUM",
        "description": "<h4>AWS VPC Flow logs not enabled</h4><h4>Description</h4>VPC Flow Logs is a feature that enables you to capture information about the IP traffic going to and from network interfaces in your VPC. After you have created a flow log, you can view and retrieve its data in Amazon CloudWatch Logs. VPC Flow Logs provide visibility into network traffic that traverses the VPC.<br>We recommend that VPC Flow Logs are enabled for packet Rejects for VPCs to help detect anomalous traffic and insight during security workflows.<br><h4>Fix - Runtime</h4>AWS Console<br>To determine if the VPC Flow logs is enabled, follow these steps:<br><br>Log in to the AWS Management Console at [https://console.aws.amazon.com/]<br>Select Services.<br>Select VPC.<br>In the left navigation pane, select Your VPCs.<br>Select a VPC.<br>In the right pane, select the Flow Logs tab.<br>If no Flow Log exists, click Create Flow Log.<br>Set Filter to Reject.<br>Enter a Role and Destination Log Group.<br>Click Create Log Flow.<br>Click CloudWatch Logs Group.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resources: aws_flow_log + aws_vpc<br>Argument: vpc_id (of aws_flow_log)<br><br>Goresource \"aws_flow_log\" \"example\" {<br>iam_role_arn    = \"arn\"<br>log_destination = \"log\"<br>traffic_type    = \"ALL\"<br>+ vpc_id          = aws_vpc.ok_vpc.id<br>}<br><br>resource \"aws_vpc\" \"ok_vpc\" {<br>cidr_block = \"10.0.0.0/16\"<br>}<br>"
    },
    "CKV_AWS_15": {
        "url": "https://docs.bridgecrew.io/docs/iam_5",
        "severity": "MEDIUM",
        "description": "<h4>AWS IAM password policy does not have an uppercase character</h4><h4>Description</h4>Password policies are used to enforce the creation and use of password complexity. Your IAM password policy should be set for passwords to require the inclusion of different character types. The password policy should enforce passwords contain at least one uppercase letter, this increases security, especially from a brute force attack.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the password policy in the AWS Console you will need appropriate permissions to View Identity Access Management Account Settings.<br>To manually set the password policy with a minimum length, follow these steps:<br><br>Log in to the AWS Management Console as an IAM user at https://console.aws.amazon.com/iam/.<br>Navigate to IAM Services.<br>On the Left Pane click Account Settings.<br>Select Requires at least one uppercase letter.<br>Click Apply password policy.<br><br>CLI Command<br>To change the password policy, use the following command:<br>Bashaws iam update-account-password-policy --require-uppercase-characters<br><br><h4>Fix - Buildtime</h4>Terraform<br>Resource:<br>Argument: require_uppercase_characters<br>\ud83d\udcd8NoteAll commands starting with aws iam update-account-password-policy can be combined into a single command.<br>"
    },
    "CKV_AWS_11": {
        "url": "https://docs.bridgecrew.io/docs/iam_6",
        "severity": "MEDIUM",
        "description": "<h4>AWS IAM password policy does not have a lowercase character</h4><h4>Description</h4>Password policies are used to enforce the creation and use of password complexity. Your IAM password policy should be set for passwords to require the inclusion of different character types. The password policy should enforce passwords contain at least one lowercase letter, this increases security, especially from a brute force attack.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the password policy in the AWS Console you will need appropriate permissions to View Identity Access Management Account Settings.<br>To manually set the password policy with a minimum length, follow these steps:<br><br>Log in to the AWS Management Console as an IAM user at https://console.aws.amazon.com/iam/.<br>Navigate to IAM Services.<br>On the Left Pane click Account Settings.<br>Select Requires at least one lowercase letter.<br>Click Apply password policy.<br><br>CLI Command<br>To change the password policy, use the following command:<br>Bashaws iam update-account-password-policy --require-lowercase-characters<br><br><h4>Fix - Buildtime</h4>Terraform<br>Textresource \"aws_iam_account_password_policy\" \"strict\" {<br>minimum_password_length        = 8<br>require_lowercase_characters   = true<br>require_numbers                = true<br>require_uppercase_characters   = true<br>require_symbols                = true<br>allow_users_to_change_password = true<br>}<br><br>\ud83d\udcd8NoteAll commands starting with aws iam update-account-password-policy can be combined into a single command.<br>"
    },
    "CKV_AWS_260": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-security-groups-do-not-allow-ingress-from-00000-to-port-80",
        "severity": "LOW",
        "description": "<h4>AWS security groups allow ingress from 0.0.0.0/0 to port 80</h4><h4>Description</h4>Allowing ingress from 0.0.0.0/0 to port 80 (i.e. the HTTP port) can expose your Amazon Web Services (AWS) resources to potential security threats. This is because 0.0.0.0/0 represents all IP addresses, and allowing traffic from all IP addresses to port 80 can make it easier for attackers to access your resources.<br>By ensuring that your AWS security groups do not allow ingress from 0.0.0.0/0 to port 80, you can help protect your resources from potential attacks and unauthorized access. Instead, you should specify the IP addresses or ranges of IP addresses that are allowed to access your resources, and only allow traffic from those sources.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_security_group\" \"bar-sg\" {<br>name   = \"sg-bar\"<br>vpc_id = aws_vpc.main.id<br>ingress {<br>from_port = 80<br>to_port   = 80<br>protocol  = \"tcp\"<br>security_groups = [aws_security_group.foo-sg.id]<br>description = \"foo\"<br>}<br>egress {<br>from_port = 0<br>to_port   = 0<br>protocol  = \"-1\"<br>cidr_blocks = [\"0.0.0.0/0\"]<br>}<br>}<br>"
    },
    "CKV_AWS_248": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-elasticsearch-does-not-use-the-default-security-group",
        "severity": "LOW",
        "description": "<h4>AWS Elasticsearch uses the default security group</h4><h4>Description</h4>Using the default security group for your Elasticsearch clusters can leave your clusters vulnerable to unauthorized access and other security threats. This is because the default security group has a number of inbound and outbound rules that allow traffic from any source, which can make it easier for attackers to gain access to your clusters.<br>By ensuring that AWS Elasticsearch does not use the default security group, you can help protect your clusters from unauthorized access and other security threats. Instead, you should create custom security groups that are tailored to your specific security needs, and use those for your Elasticsearch clusters. This can help you more effectively control access to your clusters and protect them from potential threats.<br>Buildtime - Fix<br>Terraform<br>Goresource \"aws_elasticsearch_domain\" \"pass\" {<br>domain_name           = \"example\"<br>elasticsearch_version = \"7.10\"<br><br>cluster_config {<br>instance_type = \"r4.large.elasticsearch\"<br>}<br><br>vpc_options {<br>security_group_ids = [\"sg_1234545\"]<br>}<br><br>tags = {<br>Domain = \"TestDomain\"<br>}<br>}<br>"
    },
    "CKV_AWS_242": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-mwaa-environment-has-scheduler-logs-enabled",
        "severity": "LOW",
        "description": "<h4>AWS MWAA environment has scheduler logs disabled</h4><h4>Description</h4>It is recommended to have a proper logging process for AWS MWAA environment scheduler in order to track configuration changes conducted manually and programmatically and trace back unapproved changes.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_mwaa_environment\" \"pass\" {<br>dag_s3_path        = \"dags/\"<br>execution_role_arn = \"aws_iam_role.example.arn\"<br><br>logging_configuration {<br>dag_processing_logs {<br>enabled   = true<br>log_level = \"DEBUG\"<br>}<br><br>scheduler_logs {<br>enabled   = true<br>log_level = \"INFO\"<br>}<br>}<br><br>name = \"example\"<br><br>network_configuration {<br>security_group_ids = [\"aws_security_group.example.id\"]<br>subnet_ids         = \"aws_subnet.private[*].id\"<br>}<br><br>source_bucket_arn = \"aws_s3_bucket.example.arn\"<br>}<br>"
    },
    "CKV_AWS_36": {
        "url": "https://docs.bridgecrew.io/docs/logging_2",
        "severity": "LOW",
        "description": "<h4>AWS CloudTrail log validation is not enabled in all regions</h4><h4>Description</h4>CloudTrail log file validation creates a digitally signed digest file containing a hash of each log that CloudTrail writes to S3. These digest files can be used to determine whether a log file was changed, deleted, or unchanged after CloudTrail delivered the log. It is recommended that file validation be enabled on all CloudTrails.<br>We recommend enabling log file validation to provide additional integrity checking of CloudTrail logs.<br><h4>Fix - Runtime</h4>AWS Console<br>To enable log file validation on a given trail, follow these steps:<br><br>Log in to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the IAM console.<br>On the left navigation pane, click Trails.<br>Select the target trail.<br>Navigate to the S3 section, click the edit icon (pencil).<br>Click Advanced.<br>In the Enable log file validation section, select Yes.<br>Click Save.<br><br>CLI Command<br>To enable log file validation on an AWS CloudTrail, use the following command:<br>Bashaws cloudtrail update-trail<br>--name <trail_name><br>--enable-log-file-validation<br><br>To start periodic validation of logs using these digests, use the following command:<br>Bashaws cloudtrail validate-logs<br>--trail-arn <trail_arn><br>--start-time <start_time><br>--end-time <end_time><br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_cloudtrail<br>Argument: enable_log_file_validation - (Optional) Specifies whether log file integrity validation is enabled. Defaults to false.<br><br>Goresource \"aws_cloudtrail\" \"trail_1\" {<br>...<br>name                          = \"terraform.env-trail-01\"<br>+ enable_log_file_validation    = true<br>}<br><br>CloudFormation<br><br>Resource: AWS::CloudTrail::Trail<br>Argument: Properties.EnableLogFileValidation<br><br>YAMLResources:<br>myTrail:<br>Type: AWS::CloudTrail::Trail<br>Properties:<br>...<br>+       EnableLogFileValidation: True<br>"
    },
    "CKV_AWS_209": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-cluster-logging-is-encrypted-using-a-customer-managed-key-cmk",
        "severity": "LOW",
        "description": "<h4>AWS cluster logging is not encrypted using a Customer Managed Key (CMK)</h4><h4>Description</h4>This policy identifies cluster logging which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your cluster logging data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br>Textresource \"aws_ecs_cluster\" \"pass2\" {<br>name = \"white-hart\"<br>configuration {<br>execute_command_configuration {<br>kms_key_id = aws_kms_key.example.arn<br><br>log_configuration {<br>#        cloud_watch_encryption_enabled = true<br># cloud_watch_log_group_name     = aws_cloudwatch_log_group.example.name<br><br># or<br># s3_bucket_name=   and<br>s3_bucket_encryption_enabled = true<br>}<br>}<br>}<br>tags = { test = \"fail\" }<br>}<br>"
    },
    "CKV_AWS_243": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-mwaa-environment-has-worker-logs-enabled",
        "severity": "LOW",
        "description": "<h4>AWS MWAA environment has worker logs disabled</h4><h4>Description</h4>It is recommended to have a proper logging process for AWS MWAA environment worker in order to track configuration changes conducted manually and programmatically and trace back unapproved changes.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_mwaa_environment\" \"pass\" {<br>dag_s3_path        = \"dags/\"<br>execution_role_arn = \"aws_iam_role.example.arn\"<br><br>logging_configuration {<br>worker_logs {<br>enabled   = true<br>log_level = \"CRITICAL\"<br>}<br>}<br><br>name = \"example\"<br><br>network_configuration {<br>security_group_ids = [\"aws_security_group.example.id\"]<br>subnet_ids         = \"aws_subnet.private[*].id\"<br>}<br><br>source_bucket_arn = \"aws_s3_bucket.example.arn\"<br>}<br>"
    },
    "CKV_AWS_226": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-db-instance-gets-all-minor-upgrades-automatically",
        "severity": "LOW",
        "description": "<h4>AWS DB instance does not get all minor upgrades automatically</h4><h4>Description</h4>When Amazon Relational Database Service (Amazon RDS) supports a new version of a database engine, you can upgrade your DB instances to the new version. There are two kinds of upgrades: major version upgrades and minor version upgrades. Minor upgrades helps maintain a secure and stable RDS with minimal impact on the application. For this reason, we recommend that your automatic minor upgrade is enabled. Minor version upgrades only occur automatically if a minor upgrade replaces an unsafe version, such as a minor upgrade that contains bug fixes for a previous version.<br><h4>Fix - Runtime</h4>AWS Console<br>Enable RDS auto minor version upgrades.<br><br>Go to the AWS console RDS dashboard.<br>In the navigation pane, choose Instances.<br>Select the database instance you wish to configure.<br>From the Instance actions menu, select Modify.<br>Under the Maintenance section, choose Yes for Auto minor version upgrade.<br>Select Continue and then Modify DB Instance.<br><br>CLI Command<br>Shellaws rds modify-db-instance \\<br>--region ${region} \\<br>--db-instance-identifier ${resource_name} \\<br>--auto-minor-version-upgrade \\<br>--apply-immediately<br><br><h4>Fix - Buildtime</h4>CloudFormation<br>YAMLResources:<br>Example:<br>Type: 'AWS::RDS::DBInstance'<br>Properties:<br>DBName: 'example'<br>DBInstanceClass: 'db.t3.micro'<br>Engine: 'mysql'<br>MasterUsername: 'master'<br>MasterUserPassword: 'password'<br>+     AutoMinorVersionUpgrade: true<br><br>Terraform<br>Goresource \"aws_db_instance\" \"example\" {<br>allocated_storage          = 20<br>engine                     = \"mysql\"<br>engine_version             = \"5.7\"<br>instance_class             = \"db.t3.micro\"<br>name                       = \"mydb\"<br>username                   = \"foo\"<br>password                   = \"foobarbaz\"<br>parameter_group_name       = \"default.mysql5.7\"<br>+ auto_minor_version_upgrade = true<br>}<br>"
    },
    "CKV_AWS_229": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-nacl-does-not-allow-ingress-from-00000-to-port-21",
        "severity": "LOW",
        "description": "<h4>AWS NACL allows ingress from 0.0.0.0/0 to port 21</h4><h4>Description</h4>Network Access Control List (NACL) is stateless and provides filtering of ingress/egress network traffic to AWS resources. We recommend that NACLs do not allow unrestricted ingress access to port 21. Removing unfettered connectivity to remote console services, such as FTP, reduces a server's exposure to risk.<br><h4>Fix - Buildtime</h4>CloudFormation<br>YAMLResources:<br>InboundRule:<br>Type: AWS::EC2::NetworkAclEntry<br>Properties:<br>NetworkAclId:<br>Ref: MyNACL<br>RuleNumber: 200<br>Protocol: 6<br>RuleAction: allow<br>-      CidrBlock: 0.0.0.0/0<br>+      CidrBlock: 10.0.0.0/32<br>PortRange:<br>From: 21<br>To: 21<br><br>Terraform<br>Goresource \"aws_network_acl_rule\" \"example\" {<br>network_acl_id = aws_network_acl.example.id<br>rule_number    = 200<br>egress         = false<br>protocol       = \"tcp\"<br>rule_action    = \"allow\"<br>- cidr_block     = \"0.0.0.0/0\"<br>+ cidr_block     = \"10.0.0.0/32\"<br>from_port      = 21<br>to_port        = 21<br>}<br>"
    },
    "CKV_AWS_216": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-cloudfront-distribution-is-enabled",
        "severity": "LOW",
        "description": "<h4>AWS Cloudfront distribution is disabled</h4><h4>Description</h4>When a CloudFront distribution is enabled, it will continue to incur charges for data transfer and requests, even if it is not being used by your application. Disabling the distribution can help to reduce these costs. In addition, leaving an unused CloudFront distribution enabled can also pose a security risk, as it may be vulnerable to attack or misuse. Disabling the distribution can help to mitigate these risks.<br>However, it is important to note that disabling a CloudFront distribution may cause any applications or websites that rely on it to become unavailable.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_cloudfront_distribution\" \"pass\" {<br>dynamic \"origin\" {<br>for_each = local.origins<br>content {<br>domain_name = origin.value[\"domain_name\"]<br>origin_id   = origin.value[\"origin_id\"]<br><br>s3_origin_config {<br>origin_access_identity = origin.value[\"origin_access_identity\"]<br>}<br>}<br>}<br><br>enabled             = true<br>is_ipv6_enabled     = true<br>default_root_object = \"index.html\"<br><br>default_cache_behavior {<br>allowed_methods  = var.default_behaviour.allowed_methods<br>cached_methods   = var.default_behaviour.cached_methods<br>target_origin_id = var.default_behaviour.origin_id<br><br>forwarded_values {<br>query_string = var.default_behaviour.query_string<br><br>cookies {<br>forward = var.default_behaviour.forward<br>}<br>}<br><br>viewer_protocol_policy = \"allow-all\"<br>min_ttl                = var.default_behaviour.min_ttl<br>default_ttl            = var.default_behaviour.default_ttl<br>max_ttl                = var.default_behaviour.max_ttl<br>}<br><br>dynamic \"ordered_cache_behavior\" {<br>for_each = var.behaviours<br>content {<br>path_pattern     = ordered_cache_behavior.value[\"path_pattern\"]<br>allowed_methods  = ordered_cache_behavior.value[\"allowed_methods\"]<br>cached_methods   = ordered_cache_behavior.value[\"cached_methods\"]<br>target_origin_id = ordered_cache_behavior.value[\"origin_id\"]<br>forwarded_values {<br>headers      = ordered_cache_behavior.value[\"headers\"]<br>query_string = ordered_cache_behavior.value[\"query_string\"]<br>cookies {<br>forward = ordered_cache_behavior.value[\"forward\"]<br>}<br>}<br>min_ttl                = ordered_cache_behavior.value[\"min_ttl\"]<br>default_ttl            = ordered_cache_behavior.value[\"default_ttl\"]<br>max_ttl                = ordered_cache_behavior.value[\"max_ttl\"]<br>compress               = ordered_cache_behavior.value[\"compress\"]<br>viewer_protocol_policy = \"allow-all\"<br>}<br>}<br><br>price_class = \"PriceClass_200\"<br><br>restrictions {<br>geo_restriction {<br>restriction_type = var.geo_restrictions[\"restriction_type\"]<br>locations        = var.geo_restrictions[\"locations\"]<br>}<br>}<br><br>viewer_certificate {<br>cloudfront_default_certificate = var.viewer_certificate[\"cloudfront_default_certificate\"]<br>minimum_protocol_version       = var.viewer_certificate[\"minimum_protocol_version\"]<br>}<br><br>lifecycle {<br>ignore_changes = [tags]<br>}<br>tags = {<br>\"key\" = \"value\"<br>}<br>}<br>"
    },
    "CKV_AWS_264": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-app-flow-connector-profile-uses-customer-managed-keys-cmks",
        "severity": "LOW",
        "description": "<h4>AWS App Flow connector profile does not use Customer Managed Keys (CMKs)</h4><h4>Description</h4>This policy identifies App Flow connector profile which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your App Flow connector profile data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_appflow_connector_profile\" \"pass\" {<br>name            = \"example_profile\"<br>connector_type  = \"Redshift\"<br>connection_mode = \"Public\"<br>kms_arn = aws_kms_key.example.arn<br><br><br>connector_profile_config {<br><br>connector_profile_credentials {<br>redshift {<br>password = aws_redshift_cluster.example.master_password<br>username = aws_redshift_cluster.example.master_username<br>}<br>}<br><br>connector_profile_properties {<br>redshift {<br>bucket_name  = aws_s3_bucket.example.name<br>database_url = \"jdbc:redshift://${aws_redshift_cluster.example.endpoint}/${aws_redshift_cluster.example.database_name}\"<br>role_arn     = aws_iam_role.example.arn<br>}<br>}<br>}<br>}<br>"
    },
    "CKV_AWS_194": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-appsync-has-field-level-logs-enabled",
        "severity": "LOW",
        "description": "<h4>AWS AppSync has field-level logs disabled</h4><h4>Description</h4>It is recommended to have a proper logging process for AWS AppSync in order to detect anomalous configuration activity. It is used to track configuration changes conducted manually and programmatically and trace back unapproved changes.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_appsync_graphql_api\" \"all\" {<br>authentication_type = \"API_KEY\"<br>name                = \"example\"<br><br>log_config {<br>cloudwatch_logs_role_arn = \"aws_iam_role.example.arn\"<br>field_log_level          = \"ALL\"<br>}<br>}<br>"
    },
    "CKV_AWS_246": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-rds-cluster-activity-streams-are-encrypted-by-key-management-service-kms-using-customer-managed-keys-cmks",
        "severity": "LOW",
        "description": "<h4>AWS RDS Cluster activity streams are not encrypted by Key Management Service (KMS) using Customer Managed Keys (CMKs)</h4><h4>Description</h4>This policy identifies RDS Cluster activity streams which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your RDS Cluster activity streams data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br>Resource: aws_rds_cluster_activity_stream<br>Arguments: kms_key_id<br>Goresource \"aws_rds_cluster_activity_stream\" \"pass\" {<br>resource_arn = aws_rds_cluster.default.arn<br>mode         = \"async\"<br>kms_key_id   = aws_kms_key.default.key_id<br><br>depends_on = [aws_rds_cluster_instance.default]<br>}<br>"
    },
    "CKV_AWS_259": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-cloudfront-response-header-policy-enforces-strict-transport-security",
        "severity": "LOW",
        "description": "<h4>AWS CloudFront response header policy does not enforce Strict Transport Security</h4><h4>Description</h4>Enforcing Strict Transport Security (HSTS) in your AWS CloudFront response header policy can help to improve the security of your website or application.<br>HSTS is a security feature that tells web browsers to only communicate with a website using secure HTTPS connections, rather than insecure HTTP connections. This helps to prevent man-in-the-middle attacks and other types of vulnerabilities that could be exploited over an unencrypted connection.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_cloudfront_response_headers_policy\" \"pass\" {<br>name    = \"test\"<br><br>security_headers_config {<br>strict_transport_security {<br>access_control_max_age_sec = 31536000<br>include_subdomains         = true<br>override                   = true<br>preload                    = true<br>}<br>}<br>}<br>"
    },
    "CKV_AWS_256": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-dlm-cross-region-schedules-are-encrypted-using-a-customer-managed-key-cmk",
        "severity": "LOW",
        "description": "<h4>AWS DLM cross-region schedules are not encrypted using a Customer Managed Key (CMK)</h4><h4>Description</h4>This policy identifies Elastic File DLM cross-region schedules which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your DLM cross-region schedules data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Resource: aws_dlm_lifecycle_policy<br>Arguments: cross_region_copy_rule.cmk_arn<br>Textresource \"aws_dlm_lifecycle_policy\" \"pass\" {<br>description        = \"example DLM lifecycle policy\"<br>execution_role_arn = aws_iam_role.dlm_lifecycle_role.arn<br>state              = \"ENABLED\"<br><br>policy_details {<br>resource_types = [\"VOLUME\"]<br><br>schedule {<br>name = \"2 weeks of daily snapshots\"<br><br>create_rule {<br>interval      = 24<br>interval_unit = \"HOURS\"<br>times         = [\"23:45\"]<br>}<br><br>retain_rule {<br>count = 14<br>}<br><br>tags_to_add = {<br>SnapshotCreator = \"DLM\"<br>}<br><br>copy_tags = false<br><br>cross_region_copy_rule {<br>target    = \"us-west-2\"<br>encrypted = true<br>cmk_arn   = aws_kms_key.dlm_cross_region_copy_cmk.arn<br>copy_tags = true<br>retain_rule {<br>interval      = 30<br>interval_unit = \"DAYS\"<br>}<br>}<br><br>cross_region_copy_rule {<br>target    = \"us-west-2\"<br>encrypted = true<br>cmk_arn   = aws_kms_key.dlm_cross_region_copy_cmk.arn<br>copy_tags = true<br>retain_rule {<br>interval      = 20<br>interval_unit = \"DAYS\"<br>}<br>}<br>}<br><br>target_tags = {<br>Snapshot = \"true\"<br>}<br>}<br>tags = {<br>test = \"failed\"<br>}<br>}<br>"
    },
    "CKV2_AWS_16": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-auto-scaling-is-enabled-on-your-dynamodb-tables",
        "severity": "LOW",
        "description": "<h4>DynamoDB Tables do not have Auto Scaling enabled</h4><h4>Description</h4>Checks if DynamoDB tables have autoscaling configuration. Note that for tables with billing_mode = \"PAY_PER_REQUEST\" such configuration is embedded by default.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_appautoscaling_target, aws_appautoscaling_policy, aws_dynamodb_table<br><br>Goresource \"aws_dynamodb_table\" \"pass\" {<br>name           = \"user\"<br>hash_key       = \"user-id\"<br>billing_mode   = \"PROVISIONED\"<br>read_capacity  = 10<br>write_capacity = 10<br>attribute {<br>name = \"user-id\"<br>type = \"S\"<br>}<br>}<br><br>resource \"aws_appautoscaling_target\" \"pass\" {<br>resource_id        = \"table/${aws_dynamodb_table.pass.name}\"<br>scalable_dimension = \"dynamodb:table:ReadCapacityUnits\"<br>service_namespace  = \"dynamodb\"<br>min_capacity       = 1<br>max_capacity       = 15<br>}<br><br>resource \"aws_appautoscaling_policy\" \"pass\" {<br>name               = \"rcu-auto-scaling\"<br>service_namespace  = aws_appautoscaling_target.pass.service_namespace<br>scalable_dimension = aws_appautoscaling_target.pass.scalable_dimension<br>resource_id        = aws_appautoscaling_target.pass.resource_id<br>policy_type        = \"TargetTrackingScaling\"<br><br>target_tracking_scaling_policy_configuration {<br>predefined_metric_specification {<br>predefined_metric_type = \"RDSReaderAverageCPUUtilization\"<br>predefined_metric_type = \"DynamoDBReadCapacityUtilization\"<br>}<br>}<br>}<br><br>// or:<br><br>resource \"aws_dynamodb_table\" \"pass_on_demand\" {<br>name           = \"user\"<br>hash_key       = \"user-id\"<br>billing_mode   = \"PAY_PER_REQUEST\"<br><br>attribute {<br>name = \"user-id\"<br>type = \"S\"<br>}<br>}<br>"
    },
    "CKV2_AWS_45": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-config-recorder-is-enabled-to-record-all-supported-resources",
        "severity": "MEDIUM",
        "description": "<h4>AWS Config Recording is disabled</h4><h4>Description</h4>AWS Config is a web service that performs configuration management of supported AWS resources within your account and delivers log files to you. AWS config uses configuration recorder to detect changes in your resource configurations and capture these changes as configuration items. It continuously monitors and records your AWS resource configurations and allows you to automate the evaluation of recorded configurations against desired configurations. This policy generates alerts when AWS Config recorder is not enabled.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_config_configuration_recorder\" \"pass_recorder\" {<br>name     = \"example\"<br>role_arn = aws_iam_role.r.arn<br><br>recording_group {<br>include_global_resource_types = true<br>}<br><br>}<br><br>resource \"aws_config_configuration_recorder_status\" \"pass\" {<br>name       = aws_config_configuration_recorder.pass_recorder.name<br>is_enabled = true<br>}<br>"
    },
    "CKV2_AWS_49": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-database-migration-service-endpoints-have-ssl-configured",
        "severity": "HIGH",
        "description": "<h4>AWS Database Migration Service endpoint do not have SSL configured</h4><h4>Description</h4>This policy identifies Database Migration Service (DMS) endpoints that are not configured with SSL to encrypt connections for source and target endpoints. It is recommended to use SSL connection for source and target endpoints; enforcing SSL connections help protect against 'man in the middle' attacks by encrypting the data stream between endpoint connections.\\n\\nNOTE: Not all databases use SSL in the same way. An Amazon Redshift endpoint already uses an SSL connection and does not require an SSL connection set up by AWS DMS. So there are some exlcusions included in policy RQL to report only those endpoints which can be configured using DMS SSL feature. \\n\\nFor more details:\\nhttps://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.SSL<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_dms_endpoint\" \"pass_source_1\" {<br>certificate_arn             = \"arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012\"<br>database_name               = \"test\"<br>endpoint_id                 = \"test-dms-endpoint-tf\"<br>endpoint_type               = \"source\"<br>engine_name                 = \"aurora\"<br>extra_connection_attributes = \"\"<br>kms_key_arn                 = \"arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012\"<br>password                    = \"test\"<br>port                        = 3306<br>server_name                 = \"test\"<br>ssl_mode                    = \"require\"<br>username = \"test\"<br>}<br>"
    },
    "CKV_AWS_18": {
        "url": "https://docs.bridgecrew.io/docs/s3_13-enable-logging",
        "severity": "LOW",
        "description": "<h4>AWS access logging is not enabled on S3 buckets</h4><h4>Description</h4>Access logging provides detailed audit logging for all objects and folders in an S3 bucket.<br><h4>Fix - Runtime</h4>AWS Console<br>To change the policy using the AWS Console, follow these steps:<br><br>Lo gin to the AWS Management Console at https://console.aws.amazon.com/.<br>Open the Amazon S3 console.<br>Navigate to the Bucket name list.<br>To enable server access logging for a bucket, select the name of the bucket.<br>Click Properties.<br>Click Server access logging.<br>Click Enable Logging.<br><br>\ud83d\udcd8Notes<br>For the target, select the name of the bucket that you want to receive the log record objects.<br>The target bucket must be in the same Region as the source bucket and must not have a default retention period configuration.<br><br><br>Click Save.<br><br>CLI Command<br>The example below sets the logging policy for MyBucket.<br>The AWS user [email\u00a0protected] will have full control over the log files, no one else has any access.<br>S3 logging### First, grant S3 permission with put-bucket-acl:<br>aws s3api put-bucket-acl --bucket MyBucket --grant-write URI=http://acs.amazonaws.com/groups/s3/LogDelivery --grant-read-acp URI=http://acs.amazonaws.com/groups/s3/LogDelivery<br><br>### Then apply the logging policy:<br>aws s3api put-bucket-logging --bucket MyBucket --bucket-logging-status file://logging.json<br><br>### logging.json is a JSON document in the current folder that contains the logging policy:<br>{<br>\"LoggingEnabled\": {<br>\"TargetBucket\": \"MyBucket\",<br>\"TargetPrefix\": \"MyBucketLogs/\",<br>\"TargetGrants\": [<br>{<br>\"Grantee\": {<br>\"Type\": \"AmazonCustomerByEmail\",<br>\"EmailAddress\": \"[email\u00a0protected]\"<br>},<br>\"Permission\": \"FULL_CONTROL\"<br>}<br>]<br>}<br>}<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_s3_bucket<br>Argument: logging. This example uses a dynamic block to enable the feature, the purpose here is to be able to add or not logging details by making a list of 0 or more entries.<br><br>aws_s3_bucket.bucket.tfresource \"aws_s3_bucket\" \"bucket\" {<br>acl    = var.s3_bucket_acl<br>bucket = var.s3_bucket_name<br>policy = var.s3_bucket_policy<br><br>force_destroy = var.s3_bucket_force_destroy<br>versioning {<br>enabled    = var.versioning<br>mfa_delete = var.mfa_delete<br>}<br><br>+  dynamic \"logging\" {<br>+    for_each = var.logging<br>+    content {<br>+      target_bucket = logging.value[\"target_bucket\"]<br>+      target_prefix = \"log/${var.s3_bucket_name}\"<br>+    }<br>+  }<br>}<br><br>Alternatively you could just always define the logging block:<br>Goresource \"aws_s3_bucket\" \"bucket\" {<br>acl    = var.s3_bucket_acl<br>bucket = var.s3_bucket_name<br>policy = var.s3_bucket_policy<br><br>force_destroy = var.s3_bucket_force_destroy<br>versioning {<br>enabled    = var.versioning<br>mfa_delete = var.mfa_delete<br>}<br><br>+  logging {<br>+      target_bucket = var.target_bucket<br>+      target_prefix = \"log/${var.s3_bucket_name}\"<br>+   }<br>}<br>"
    },
    "CKV2_AWS_21": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-all-iam-users-are-members-of-at-least-one-iam-group",
        "severity": "LOW",
        "description": "<h4>Not all IAM users are members of at least one IAM group</h4><h4>Description</h4>It is generally a best practice to assign all IAM users to at least one IAM group. This can help to ensure that each user has the necessary permissions to perform their tasks and responsibilities.<br>By assigning users to groups, you can more easily manage the permissions for those users. For example, if you need to change the permissions for a group of users, you can simply update the group's policy rather than updating the policies for each individual user.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_iam_group_membership, aws_iam_group, aws_iam_user<br>Argument: users and group of aws_iam_group_membership<br><br>Goresource \"aws_iam_group_membership\" \"ok_group\" {<br>name = \"tf-testing-group-membership\"<br><br>users = [<br>aws_iam_user.user_good.name,<br>]<br><br>group = aws_iam_group.group.name<br>}<br><br>resource \"aws_iam_group\" \"group\" {<br>name = \"test-group\"<br>}<br><br>resource \"aws_iam_user\" \"user_good\" {<br>name = \"test-user\"<br>}<br>"
    },
    "CKV_AWS_238": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-guardduty-detector-is-enabled",
        "severity": "LOW",
        "description": "<h4>AWS GuardDuty detector is enabled</h4><h4>Description</h4>Enabling the AWS GuardDuty detector can help protect your Amazon Web Services (AWS) resources from various types of threats, such as malware, data breaches, and unauthorized access. GuardDuty is a threat detection service that uses machine learning and other techniques to analyze data from various sources (such as VPC Flow Logs, AWS CloudTrail logs, and DNS logs) and identify potential security threats.<br>By ensuring that the GuardDuty detector is enabled, you can take advantage of this service and receive alerts when potential threats are detected. This can help you take timely action to address any security issues and prevent security incidents from occurring.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_guardduty_detector\" \"pass\" {<br>enable = true<br>tags   = { test = \"Fail\" }<br>}<br>"
    },
    "CKV2_AWS_28": {
        "url": "https://docs.bridgecrew.io/docs/ensure-public-facing-alb-are-protected-by-waf",
        "severity": "MEDIUM",
        "description": "<h4>Application Load Balancer (ALB) not configured with AWS Web Application Firewall v2 (AWS WAFv2)</h4><h4>Description</h4>AWS WAF is a web application firewall service that helps protect your web applications from common web exploits that could affect your application's availability, integrity, or confidentiality.<br>By attaching AWS WAF to your public-facing ALBs, you can create rules that block or allow traffic based on the characteristics of the traffic, such as the IP address, the HTTP method, or the values of specific headers. This can help to protect your application from common web exploits such as SQL injection attacks, cross-site scripting attacks, and other types of malicious traffic.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_lb\" \"lb_good_1\" {<br>internal= false<br>}<br><br><br>resource \"aws_wafregional_web_acl_association\" \"foo\" {<br>resource_arn = aws_lb.lb_good_1.arn<br>web_acl_id = aws_wafregional_web_acl.foo.id<br>}<br>"
    },
    "CKV2_AWS_7": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-amazon-emr-clusters-security-groups-are-not-open-to-the-world",
        "severity": "LOW",
        "description": "<h4>Amazon EMR clusters' security groups are open to the world</h4><h4>Description</h4>It is generally a good security practice to ensure that the security groups for your Amazon EMR clusters are not open to the world, as this means that the clusters are only accessible from within your private network or from certain approved IP addresses or security groups. This can help to protect your EMR clusters from unauthorized access, as external parties will not be able to connect to them over the internet.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_emr_cluster and aws_security_group<br>Argument: ingress of aws_security_group<br><br>Goresource \"aws_emr_cluster\" \"cluster_ok\" {<br>name          = \"emr-test-arn\"<br>release_label = \"emr-4.6.0\"<br>applications  = [\"Spark\"]<br><br>ec2_attributes {<br>emr_managed_master_security_group = aws_security_group.block_access_ok.id<br>emr_managed_slave_security_group  = aws_security_group.block_access_ok.id<br>instance_profile                  = \"connected_to_aws_iam_instance_profile\"<br>}<br>}<br><br>resource \"aws_security_group\" \"block_access_ok\" {<br>name        = \"block_access\"<br>description = \"Block all traffic\"<br><br>ingress {<br>from_port   = 0<br>to_port     = 0<br>protocol    = \"-1\"<br>cidr_blocks = [\"10.0.0.0/16\"]<br>}<br><br>egress {<br>from_port   = 0<br>to_port     = 0<br>protocol    = \"-1\"<br>cidr_blocks = [\"10.0.0.0/16\"]<br>}<br>}<br>"
    },
    "CKV_AWS_103": {
        "url": "https://docs.bridgecrew.io/docs/bc_aws_general_43",
        "severity": "HIGH",
        "description": "<h4>AWS Load Balancer is not using TLS 1.2</h4><h4>Description</h4>A listener in an AWS Load Balancer is a process that checks for connection requests. Users can define a listener when creating a load balancer, and add listeners to the load balancer at any time. The HTTPS listener enables traffic encryption between your load balancer and the clients that initiate SSL or TLS sessions.<br><h4>Fix - Runtime</h4>AWS Console<br><br>Go to the Amazon EC2 console at https://console.aws.amazon.com/ec2/.<br>On the navigation pane, under LOAD BALANCING, select Load Balancers.<br>Select the load balancer and choose Listeners.<br>4.Select the check box for the TLS listener and choose Edit.<br>For Security policy, choose a security policy.<br><br>CLI Command<br>Textmodify-listener<br>--listener-arn <value><br>[--port <value>]<br>[--protocol <value>]<br>[--ssl-policy <value>]<br><br><h4>Fix - Buildtime</h4>Terraform<br>Resource: aws_lb_listener<br>Attribute: protocol - (Optional) The protocol for connections from clients to the load balancer. For Application Load Balancers, valid values are HTTP and HTTPS, with a default of HTTP. For Network Load Balancers, valid values are TCP, TLS, UDP, and TCP_UDP. Not valid to use UDP or TCP_UDP if dual-stack mode is enabled. Not valid for Gateway Load Balancers.<br>aws_db_parameter_group.custom.tfresource \"aws_lb_listener\" \"front_end\" {<br>load_balancer_arn = aws_lb.front_end.arn<br>port              = \"443\"<br>protocol          = \"HTTPS\"<br>+ ssl_policy        = \"ELBSecurityPolicy-TLS13-1-2-2021-06\"<br>certificate_arn   = \"arn:aws:acm:eu-west-2:999999999:certificate/77777777-5d4a-457f-8888-02550c8c9244\"<br><br>default_action {<br>type             = \"forward\"<br>target_group_arn = aws_lb_target_group.front_end.arn<br>}<br>}<br>"
    },
    "CKV2_AWS_27": {
        "url": "https://docs.bridgecrew.io/docs/ensure-postgres-rds-has-query-logging-enabled",
        "severity": "LOW",
        "description": "<h4>Ensure Postgres RDS as aws_rds_cluster has Query Logging enabled</h4><h4>Description</h4>This check ensures that you have enabled query logging set up for your PostgreSQL database cluster. A cluster needs to have a non-default parameter group and two parameters set - that of log_statement and log_min_duration_statement, these need to be set to all and 1 respectively to get sufficient logs.<br>Note<br>Setting querying logging can expose secrets (including passwords) from your queries, - restrict and encrypt to mitigate.<br><h4>Fix - Buildtime</h4>Terraform<br>You will need to have a resource aws_rds_cluster_parameter_group that is referred to your aws_rds_cluster_parameter_group attribute: db_cluster_parameter_group_name. With that in place the following parameters need to be set:<br>aws_rds_cluster_parameter_group.examplea.tfresource \"aws_rds_cluster_parameter_group\" \"examplea\" {<br>name = \"rds-cluster-pg\"<br>family      = \"aurora5.7\"<br>description = \"RDS default cluster parameter group\"<br><br>+  parameter {<br>+    name=\"log_statement\"<br>+    value=\"all\"<br>+  }<br><br>+  parameter {<br>+    name=\"log_min_duration_statement\"<br>+    value=\"1\"<br>+  }<br>}<br><br>For more details see the aws docs here: https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.Concepts.PostgreSQL.html<br>"
    },
    "CKV2_AWS_46": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-cloudfromt-distribution-with-s3-have-origin-access-set-to-enabled",
        "severity": "MEDIUM",
        "description": "<h4>AWS Cloudfront Distribution with S3 have Origin Access set to disabled</h4><h4>Description</h4>This policy identifies the AWS CloudFront distributions which are utilizing S3 bucket and have Origin Access Disabled. The origin access identity feature should be enabled for all your AWS CloudFront CDN distributions in order to restrict any direct access to your objects through Amazon S3 URLs.<br><h4>Fix - Buidtime</h4>Terraform<br>YAMLresource \"aws_s3_bucket\" \"b\" {<br>bucket = \"mybucket\"<br><br>tags = {<br>Name = \"My bucket\"<br>}<br>}<br><br>resource \"aws_cloudfront_distribution\" \"pass_1\" {<br><br><br>origin {<br>domain_name = aws_s3_bucket.b.bucket_regional_domain_name<br>origin_id   = \"failoverS3\"<br>s3_origin_config {<br>origin_access_identity = aws_cloudfront_origin_access_identity.default.cloudfront_access_identity_path<br>}<br><br>}<br><br><br><br><br>enabled             = true<br>is_ipv6_enabled     = true<br>comment             = \"Some comment\"<br>default_root_object = \"index.html\"<br><br>logging_config {<br>include_cookies = false<br>bucket          = \"mylogs.s3.amazonaws.com\"<br>prefix          = \"myprefix\"<br>}<br><br>aliases = [\"mysite.example.com\", \"yoursite.example.com\"]<br><br>default_cache_behavior {<br>allowed_methods  = [\"DELETE\", \"GET\", \"HEAD\", \"OPTIONS\", \"PATCH\", \"POST\", \"PUT\"]<br>cached_methods   = [\"GET\", \"HEAD\"]<br>target_origin_id = local.s3_origin_id<br><br>forwarded_values {<br>query_string = false<br><br>cookies {<br>forward = \"none\"<br>}<br>}<br><br>viewer_protocol_policy = \"allow-all\"<br>min_ttl                = 0<br>default_ttl            = 3600<br>max_ttl                = 86400<br>}<br><br># Cache behavior with precedence 0<br>ordered_cache_behavior {<br>path_pattern     = \"/content/immutable/*\"<br>allowed_methods  = [\"GET\", \"HEAD\", \"OPTIONS\"]<br>cached_methods   = [\"GET\", \"HEAD\", \"OPTIONS\"]<br>target_origin_id = local.s3_origin_id<br><br>forwarded_values {<br>query_string = false<br>headers      = [\"Origin\"]<br><br>cookies {<br>forward = \"none\"<br>}<br>}<br><br>min_ttl                = 0<br>default_ttl            = 86400<br>max_ttl                = 31536000<br>compress               = true<br>viewer_protocol_policy = \"redirect-to-https\"<br>}<br><br># Cache behavior with precedence 1<br>ordered_cache_behavior {<br>path_pattern     = \"/content/*\"<br>allowed_methods  = [\"GET\", \"HEAD\", \"OPTIONS\"]<br>cached_methods   = [\"GET\", \"HEAD\"]<br>target_origin_id = local.s3_origin_id<br><br>forwarded_values {<br>query_string = false<br><br>cookies {<br>forward = \"none\"<br>}<br>}<br><br>min_ttl                = 0<br>default_ttl            = 3600<br>max_ttl                = 86400<br>compress               = true<br>viewer_protocol_policy = \"redirect-to-https\"<br>}<br><br>price_class = \"PriceClass_200\"<br><br>restrictions {<br>geo_restriction {<br>restriction_type = \"whitelist\"<br>locations        = [\"US\", \"CA\", \"GB\", \"DE\"]<br>}<br>}<br><br>tags = {<br>Environment = \"production\"<br>}<br><br>viewer_certificate {<br>cloudfront_default_certificate = true<br>}<br>web_acl_id = aws_wafv2_web_acl.example.arn<br>}<br>"
    },
    "CKV_AWS_250": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-rds-postgresql-instances-use-a-non-vulnerable-version-of-log_fdw-extension",
        "severity": "LOW",
        "description": "<h4>AWS RDS PostgreSQL exposed to local file read vulnerability</h4><h4>Description</h4>The log_fdw extension for Amazon Relational Database Service (AWS RDS) PostgreSQL instances allows you to query log files from foreign servers as if they were tables in a database. However, certain versions of the log_fdw extension may contain vulnerabilities that can be exploited by attackers.<br>By ensuring that your AWS RDS PostgreSQL instances use a non-vulnerable version of the log_fdw extension, you can help protect your database from potential security threats.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_db_instance\" \"pass\" {<br>name           = \"name\"<br>instance_class = \"db.t3.micro\"<br>engine         = \"postgres\"<br>engine_version = \"13.3\"<br>}<br><br>resource \"aws_rds_cluster\" \"pass\" {<br>engine = \"aurora-postgresql\"<br>engine_version = \"11.9\"<br>}<br>"
    },
    "CKV_AWS_223": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-ecs-cluster-enables-logging-of-ecs-exec",
        "severity": "LOW",
        "description": "<h4>AWS ECS Cluster does not enable logging of ECS Exec</h4><h4>Description</h4>It is recommended to have a proper logging process for AWS ECS Cluster in order to track configuration changes conducted manually and programmatically and trace back unapproved changes.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_ecs_cluster\" \"pass2\" {<br>name = \"white-hart\"<br>configuration {<br>execute_command_configuration {<br># kms_key_id = aws_kms_key.example.arn<br>logging = \"DEFAULT\"<br><br>log_configuration {<br># cloud_watch_encryption_enabled = true<br># cloud_watch_log_group_name     = aws_cloudwatch_log_group.example.name<br><br># or<br># s3_bucket_name=   and<br># s3_bucket_encryption_enabled =true<br>}<br>}<br>}<br>tags = { test = \"fail\" }<br>}<br>"
    },
    "CKV_AWS_262": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-kendra-index-server-side-encryption-uses-customer-managed-keys-cmks-1",
        "severity": "LOW",
        "description": "<h4>AWS Kendra index server side encryption does not use Customer Managed Keys (CMKs)</h4><h4>Description</h4>This policy identifies Kendra index servers which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your Kendra index server data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br>Resource: aws_kendra_index<br>Arguments: server_side_encryption_configuration.kms_key_id<br>Goresource \"aws_kendra_index\" \"pass\" {<br>name     = \"example\"<br>role_arn = aws_iam_role.this.arn<br><br>server_side_encryption_configuration {<br>kms_key_id = data.aws_kms_key.this.arn<br>}<br>}<br>"
    },
    "CKV_AWS_217": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-api-deployments-enable-create-before-destroy",
        "severity": "LOW",
        "description": "<h4>AWS API deployments do not enable Create before Destroy</h4><h4>Description</h4>It is recommended to enable create_before_destroy argument inside the resource lifecycle configuration block to avoid possible return errors such as BadRequestException: Active stages pointing to this deployment must be moved or deleted on recreation.<br><h4>Fix - Buildtime</h4>CloudFormation<br>CloudFormation creates a new deployment first and then will delete the old one automatically.<br>Terraform<br>Goresource \"aws_api_gateway_deployment\" \"example\" {<br>rest_api_id = aws_api_gateway_rest_api.example.id<br>stage_name  = \"example\"<br><br>+ lifecycle {<br>+   create_before_destroy = true<br>+ }<br>}<br>"
    },
    "CKV_AWS_231": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-nacl-does-not-allow-ingress-from-00000-to-port-3389",
        "severity": "LOW",
        "description": "<h4>AWS NACL allows ingress from 0.0.0.0/0 to port 3389</h4><h4>Description</h4>Network Access Control List (NACL) is stateless and provides filtering of ingress/egress network traffic to AWS resources. We recommend that NACLs do not allow unrestricted ingress access to port 3389. Removing unfettered connectivity to remote console services, such as RDP, reduces a server's exposure to risk.<br><h4>Fix - Buildtime</h4>CloudFormation<br>YAMLResources:<br>InboundRule:<br>Type: AWS::EC2::NetworkAclEntry<br>Properties:<br>NetworkAclId:<br>Ref: MyNACL<br>RuleNumber: 200<br>Protocol: 6<br>RuleAction: allow<br>-      CidrBlock: 0.0.0.0/0<br>+      CidrBlock: 10.0.0.0/32<br>PortRange:<br>From: 3389<br>To: 3389<br><br>Terraform<br>Goresource \"aws_network_acl_rule\" \"example\" {<br>network_acl_id = aws_network_acl.example.id<br>rule_number    = 200<br>egress         = false<br>protocol       = \"tcp\"<br>rule_action    = \"allow\"<br>- cidr_block     = \"0.0.0.0/0\"<br>+ cidr_block     = \"10.0.0.0/32\"<br>from_port      = 3389<br>to_port        = 3389<br>}<br>"
    },
    "CKV_AWS_213": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-elb-policy-uses-only-secure-protocols",
        "severity": "LOW",
        "description": "<h4>AWS ELB Policy uses some unsecure protocols</h4><h4>Description</h4>By ensuring that your AWS ELB policy only uses secure protocols, you can help prevent attackers from intercepting and reading sensitive information that is transmitted between your ELB and its clients. This can help protect your network and data from various types of attacks, including man-in-the-middle attacks, eavesdropping, and other types of data interception.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_load_balancer_policy\" \"pass\" {<br>load_balancer_name = aws_elb.wu-tang.name<br>policy_name        = \"wu-tang-ssl\"<br>policy_type_name   = \"SSLNegotiationPolicyType\"<br><br>policy_attribute {<br>name  = \"Protocol-TLSv1.2\"<br>value = \"true\"<br>}<br>}<br>"
    },
    "CKV_AWS_261": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-kendra-index-server-side-encryption-uses-customer-managed-keys-cmks",
        "severity": "LOW",
        "description": "<h4>AWS HTTP and HTTPS target groups do not define health check</h4><h4>Description</h4>Health checks ensure that a target is reachable before sending traffic from a load balancer to the endpoint. This is a best practice compared to blindly sending traffic to what can be unhealthy targets.<br><h4>Fix - Runtime</h4>The way you enable health checks varies by the endpoint. If you are using an autoscaling group:<br><br>Go to the EC2 console and select Auto Scaling Groups<br>Select the check box next to an existing group<br>On the Details tab, choose Health checks and Edit<br>Select your health check type<br>Add a Health check grace period<br>Select update<br><br>Or for the load balancer:<br><br>Open the Amazon EC2 console<br>Under Load Balancing, select Load Balancers<br>Select your load balancer<br>On the Health Check tab, choose Edit Health Check<br>On the Configure Health Check page, configure your health check<br>Select Save<br><br><h4>Fix - Buildtime</h4><br>Resource: aws_lb_target_group, aws_alb_target_group<br>Argument: health_check<br><br>Goresource \"aws_alb_target_group\" \"example\" {<br>name = \"target-group-1\"<br>port = 80<br>protocol = \"HTTP\"<br><br>+  health_check {<br>+    path = \"/api/1/resolve/default?path=/service/my-service\"<br>+    ...<br>+    matcher = \"200\"  # has to be HTTP 200 or fails<br>+  }<br>}<br>"
    },
    "CKV_AWS_225": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-api-gateway-method-settings-enable-caching",
        "severity": "LOW",
        "description": "<h4>AWS API Gateway method settings do not enable caching</h4><h4>Description</h4>Enabling caching for API Gateway helps improve your API's performance by allowing clients to retrieve responses from a cache instead of making a request to the backend service. This can reduce the load on your backend service and improve the overall responsiveness of your API. It can reduce the cost of using your API by reducing the number of requests your backend service needs to handle. It can also improve the reliability of your API by allowing it to continue functioning even if the backend service is unavailable or experiencing problems.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_api_gateway_method_settings\" \"pass\" {<br>rest_api_id = aws_api_gateway_rest_api.fail.id<br>stage_name  = aws_api_gateway_stage.fail.stage_name<br>method_path = \"path1/GET\"<br><br>settings {<br>caching_enabled      = true<br>metrics_enabled      = false<br>logging_level        = \"INFO\"<br>cache_data_encrypted = true<br>data_trace_enabled   = false<br>}<br>}<br>"
    },
    "CKV2_AWS_6": {
        "url": "https://docs.bridgecrew.io/docs/s3-bucket-should-have-public-access-blocks-defaults-to-false-if-the-public-access-block-is-not-attached",
        "severity": "LOW",
        "description": "<h4>S3 Bucket does not have public access blocks</h4><h4>Description</h4>When you create an S3 bucket, it is good practice to set the additional resource  aws_s3_bucket_public_access_block to ensure the bucket is never accidentally public.<br>We recommend you ensure S3 bucket has public access blocks. If the public access block is not attached it defaults to False.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_s3_bucket, aws_s3_bucket_public_access_block<br>Argument: bucket and of block_public_acls aws_s3_bucket_public_access_block<br><br>Goresource \"aws_s3_bucket\" \"bucket_good_1\" {<br>bucket = \"bucket_good\"<br>}<br><br>resource \"aws_s3_bucket_public_access_block\" \"access_good_1\" {<br>bucket = aws_s3_bucket.bucket_good_1.id<br><br>block_public_acls   = true<br>block_public_policy = true<br>}<br>"
    },
    "CKV_AWS_258": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-authtype-for-your-lambda-function-urls-is-defined",
        "severity": "LOW",
        "description": "<h4>AWS Lambda function URLs AuthType is not defined</h4><h4>Description</h4>The AWS AuthType for your Lambda function URLs determines how users are authenticated when they access the URLs of your Lambda functions. It is important to ensure that the AWS AuthType for your Lambda function URLs is defined because it helps to secure your functions and protect them from unauthorized access.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_lambda_function_url\" \"pass\" {<br>function_name      = aws_lambda_function.test.function_name<br>qualifier          = \"my_alias\"<br>authorization_type = \"AWS_IAM\"<br>}<br>"
    },
    "CKV_AWS_257": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-codecommit-branch-changes-have-at-least-2-approvals",
        "severity": "LOW",
        "description": "<h4>AWS Codecommit branch changes has less than 2 approvals</h4><h4>Description</h4>The best practice for merging new code into a code base is to have at least two reviewers. AWS CodeCommit can enforce this policy.<br><h4>Fix - Runtime</h4><br>In the AWS console, go to CodeCommit.<br>Select Approval Rule Templates and then Create Template.<br>Under Number of approvals needed, add at least two approvals.<br><br><h4>Fix - Buildtime</h4>Terraform<br>resource \"aws_codecommit_approval_rule_template\" \"example\" {<br>...<br>content = <<EOF<br>{<br>\"Version\": \"2018-11-08\",<br>\"DestinationReferences\": [\"refs/heads/master\"],<br>\"Statements\": [{<br>\"Type\": \"Approvers\",<br>+        \"NumberOfApprovalsNeeded\": 2,<br>\"ApprovalPoolMembers\": [\"arn:aws:sts::123456789012:assumed-role/CodeCommitReview/*\"]<br>}]<br>}<br>EOF<br>...<br>}<br>"
    },
    "CKV_AWS_210": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-batch-job-is-not-defined-as-a-privileged-container",
        "severity": "LOW",
        "description": "<h4>AWS Batch Job is defined as a privileged container</h4><h4>Description</h4>By defining your AWS Batch job as a privileged container, you can ensure that it has the necessary privileges to access system devices, such as GPUs or hardware accelerators, modify system-level configuration files, and more.<br>That said, making a job overly permissive might increase the potential security risks, as the job will have more access to sensitive system resources\u05e5<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_batch_job_definition\" \"pass\" {<br>name = \"tf_test_batch_job_definition\"<br>type = \"container\"<br><br>container_properties = <<CONTAINER_PROPERTIES<br>{<br>\"command\": [\"ls\", \"-la\"],<br>\"image\": \"busybox\",<br>\"memory\": 1024,<br>\"vcpus\": 1,<br>\"privileged\": false,<br>\"volumes\": [<br>{<br>\"host\": {<br>\"sourcePath\": \"/tmp\"<br>},<br>\"name\": \"tmp\"<br>}<br>],<br>\"environment\": [<br>{\"name\": \"VARNAME\", \"value\": \"VARVAL\"}<br>],<br>\"mountPoints\": [<br>{<br>\"sourceVolume\": \"tmp\",<br>\"containerPath\": \"/tmp\",<br>\"readOnly\": false<br>}<br>],<br>\"ulimits\": [<br>{<br>\"hardLimit\": 1024,<br>\"name\": \"nofile\",<br>\"softLimit\": 1024<br>}<br>]<br>}<br>CONTAINER_PROPERTIES<br>}<br>"
    },
    "CKV_AWS_212": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-ebs-volume-is-encrypted-by-key-management-service-kms-using-a-customer-managed-key-cmk",
        "severity": "LOW",
        "description": "<h4>AWS EBS Volume is not encrypted by Key Management Service (KMS) using a Customer Managed Key (CMK)</h4><h4>Description</h4>This policy identifies Elastic File Systems (EFSs) which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your EFS data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br>Resource: aws_ebs_volume<br>Arguments: kms_key_id<br>Goresource \"aws_ebs_volume\" \"pass\" {<br>availability_zone = data.aws_availability_zones.available.names[0]<br>size              = 1<br>encrypted         = true<br>kms_key_id        = aws_kms_key.test.arn<br><br>tags = {<br>Name = \"taggy\"<br>}<br>}<br>"
    },
    "CKV_AWS_254": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-dlm-cross-region-events-are-encrypted-with-a-customer-managed-key-cmk",
        "severity": "LOW",
        "description": "<h4>AWS DLM cross-region events are not encrypted with a Customer Managed Key (CMK)</h4><h4>Description</h4>This policy identifies DLM cross-region events) which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your DLM cross-region events data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br>Resource: aws_dlm_lifecycle_policy<br>Arguments: action.cross_region_copy.encryption_configuration.cmk_arn<br>Goresource \"aws_dlm_lifecycle_policy\" \"pass\" {<br>description        = \"tf-acc-basic\"<br>execution_role_arn = aws_iam_role.example.arn<br><br>policy_details {<br>policy_type = \"EVENT_BASED_POLICY\"<br><br>resource_types = []<br>target_tags    = {}<br><br>action {<br>name = \"tf-acc-basic\"<br>cross_region_copy {<br>encryption_configuration {<br>cmk_arn    = aws_kms_key.test.arn<br>encryption = true<br>}<br>retain_rule {<br>interval      = 15<br>interval_unit = \"MONTHS\"<br>}<br><br>}<br>}<br><br>event_source {<br>type = \"MANAGED_CWE\"<br>parameters {<br>description_regex = \"^.*Created for policy: policy-1234567890abcdef0.*$\"<br>event_type        = \"shareSnapshot\"<br>snapshot_owner    = [data.aws_caller_identity.current.account_id]<br>}<br>}<br>}<br>}<br>"
    },
    "CKV_AWS_219": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-codepipeline-artifactstore-is-not-encrypted-by-key-management-service-kms-using-a-customer-managed-key-cmk",
        "severity": "LOW",
        "description": "<h4>AWS CodePipeline artifactStore is not encrypted by Key Management Service (KMS) using a Customer Managed Key (CMK)</h4><h4>Description</h4>This policy identifies CodePipeline artifactStores which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your CodePipeline artifactStore  data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Resource: aws_codepipeline<br>Arguments: encryption_key<br>Textresource \"aws_codepipeline\" \"pass\" {<br>name     = \"tf-test-pipeline\"<br>role_arn = aws_iam_role.codepipeline_role.arn<br><br>artifact_store {<br>location = aws_s3_bucket.codepipeline_bucket.bucket<br>type     = \"S3\"<br><br>encryption_key {<br>id   = data.aws_kms_alias.s3kmskey.arn<br>type = \"KMS\"<br>}<br>}<br>"
    },
    "CKV_AWS_253": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-dlm-cross-region-events-are-encrypted",
        "severity": "LOW",
        "description": "<h4>AWS DLM cross-region events are not encrypted</h4><h4>Description</h4>As a best practice enable encryption for your AWS DLM cross-region events to improve data security without making changes to your business or applications.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_dlm_lifecycle_policy\" \"pass\" {<br>description        = \"tf-acc-basic\"<br>execution_role_arn = aws_iam_role.example.arn<br><br>policy_details {<br>policy_type = \"EVENT_BASED_POLICY\"<br><br>resource_types = []<br>target_tags    = {}<br><br>action {<br>name = \"tf-acc-basic\"<br>cross_region_copy {<br>encryption_configuration {<br>cmk_arn    = aws_kms_key.test.arn<br>encryption = true<br>}<br>retain_rule {<br>interval      = 15<br>interval_unit = \"MONTHS\"<br>}<br><br>}<br>}<br><br>event_source {<br>type = \"MANAGED_CWE\"<br>parameters {<br>description_regex = \"^.*Created for policy: policy-1234567890abcdef0.*$\"<br>event_type        = \"shareSnapshot\"<br>snapshot_owner    = [data.aws_caller_identity.current.account_id]<br>}<br>}<br>}<br>}<br>"
    },
    "CKV_AWS_233": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-acm-certificate-enables-create-before-destroy",
        "severity": "LOW",
        "description": "<h4>AWS ACM certificate does not enable Create before Destroy</h4><h4>Description</h4>It is recommended to enable create_before_destroy argument inside the resource lifecycle configuration block to avoid a possible outage when the certificate needs to be recreated during an update.<br><h4>Fix - Buildtime</h4>CloudFormation<br>CloudFormation creates a new certificate first and then will delete the old one automatically.<br>Terraform<br>Goresource \"aws_acm_certificate\" \"example\" {<br>domain_name       = \"example.com\"<br>validation_method = \"DNS\"<br><br>+ lifecycle {<br>+   create_before_destroy = true<br>+ }<br>}<br>"
    },
    "CKV_AWS_215": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-appsync-api-cache-is-encrypted-in-transit",
        "severity": "LOW",
        "description": "<h4>AWS Appsync API Cache is not encrypted in transit</h4><h4>Description</h4>This policy identifies the AWS Appsync API that are configured with disabled in-transit data encryption. It is recommended that these resources will be configured with in-transit data encryption to minimize risk for sensitive data being leaked.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_appsync_api_cache\" \"pass\" {<br>api_id                     = aws_appsync_graphql_api.default.id<br>transit_encryption_enabled = true<br>at_rest_encryption_enabled = true<br>ttl                        = 60<br>type                       = \"SMALL\"<br>api_caching_behavior       = \"FULL_REQUEST_CACHING\"<br>}<br>"
    },
    "CKV_AWS_201": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-memorydb-is-encrypted-at-rest-by-aws-key-management-service-kms-using-cmks",
        "severity": "LOW",
        "description": "<h4>AWS MemoryDB is not encrypted at rest by AWS' Key Management Service KMS using CMKs</h4><h4>Description</h4>This policy identifies MemoryDB which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your MemoryDB data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br>Resource: aws_memorydb_cluster<br>Arguments: kms_key_arn<br>Goresource \"aws_memorydb_cluster\" \"pass\" {<br>acl_name                 = \"open-access\"<br>name                     = \"my-cluster\"<br>node_type                = \"db.t4g.small\"<br>num_shards               = 2<br>security_group_ids       = [aws_security_group.example.id]<br>snapshot_retention_limit = 7<br>subnet_group_name        = aws_memorydb_subnet_group.example.id<br>kms_key_arn              = aws_kms_key.example.arn<br>}<br>"
    },
    "CKV_AWS_220": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-cloudsearch-uses-https",
        "severity": "LOW",
        "description": "<h4>AWS Cloudsearch does not use HTTPS</h4><h4>Description</h4>CloudSearch is a managed search service for your web service. CloudSearch Domains allow you to enforce that requests come over HTTPS, encrypting those requests.<br><h4>Fix - Runtime</h4><br>In the AWS Console, go to CloudSearch.<br>Select the domain you wish to edit.<br>Under Domain configuration, next to HTTPS options, select Edit.<br>Enable Toggle HTTPS options.<br>Select Submit.<br><br><h4>Fix - Buildtime</h4>Terraform<br>resource \"aws_cloudsearch_domain\" \"example\" {<br>...<br>+   endpoint_options {<br>+     enforce_https = true<br>+   }<br>...<br>}<br>"
    },
    "CKV_AWS_239": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-dax-cluster-endpoint-uses-transport-layer-security-tls",
        "severity": "LOW",
        "description": "<h4>AWS DAX cluster endpoint does not use TLS (Transport Layer Security)</h4><h4>Description</h4>The Transport Layer Security (TLS) protocol secures transmission of data between servers and web browsers, over the Internet, using standard encryption technology. To follow security best practices and the latest PCI compliance standards, enable the latest version of TLS protocol (i.e. TLS 1.2) for all yourDAX Servers.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_dax_cluster\" \"pass\" {<br>cluster_name                     = var.cluster_name<br>iam_role_arn                     = var.iam_role_arn<br>parameter_group_name             = aws_dax_parameter_group.example.name<br>subnet_group_name                = aws_dax_subnet_group.example.name<br>cluster_endpoint_encryption_type = \"TLS\"<br>server_side_encryption {<br>enabled = false #default is false<br>}<br>tags = { test = \"Fail\" }<br>}<br>"
    },
    "CKV_AWS_206": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-api-gateway-domain-uses-a-modern-security-policy",
        "severity": "LOW",
        "description": "<h4>AWS API Gateway Domain does not use a modern security policy</h4><h4>Description</h4>AWS API Gateway Domain allows you to set the security policy. Using TLS 1_0 allows you to use insecure cypher suites.<br><h4>Fix - Runtime</h4><br>In the AWS console, go to API Gateway.<br>Select Custom Domain Names.<br>Select the domain name to update and then Edit.<br>For Minimum TLS version, select TLS 1.2.<br>Select Save.<br><br><h4>Fix - Buildtime</h4>Terraform<br>resource \"aws_api_gateway_domain_name\" \"example\" {<br>...<br>+ security_policy = TLS_1_2<br>...<br>}<br>"
    },
    "CKV_AWS_204": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-amis-are-encrypted-by-key-management-service-kms-using-customer-managed-keys-cmks",
        "severity": "LOW",
        "description": "<h4>AWS AMIs are not encrypted by Key Management Service (KMS) using Customer Managed Keys (CMKs)</h4><h4>Description</h4>This policy identifies AMIs which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your EFS data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Go75 lines (62 sloc)  1.41 KB<br><br>resource \"aws_ami\" \"pass\" {<br>name                = \"terraform-example\"<br>virtualization_type = \"hvm\"<br>root_device_name    = \"/dev/xvda1\"<br><br>ebs_block_device {<br>device_name = \"/dev/xvda1\"<br>volume_size = 8<br>snapshot_id = \"someid\"<br>}<br><br>ebs_block_device {<br>device_name = \"/dev/xvda2\"<br>volume_size = 8<br>encrypted   = true<br>}<br>}<br>"
    },
    "CKV_AWS_247": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-all-data-stored-in-the-elasticsearch-domain-is-encrypted-using-a-customer-managed-key-cmk",
        "severity": "LOW",
        "description": "<h4>Note all AWS data stored in the Elasticsearch domain is encrypted using a Customer Managed Key (CMK)</h4><h4>Description</h4>This policy identifies Elasticsearch domain which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your Elasticsearch domain data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_elasticsearch_domain\" \"pass\" {<br>domain_name = \"example\"<br><br>cluster_config {<br>instance_type = \"r5.large.elasticsearch\"<br>}<br><br>encrypt_at_rest {<br>kms_key_id = aws_kms_key.example.arn<br>}<br>}<br>"
    },
    "CKV_AWS_205": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-ami-launch-permissions-are-limited",
        "severity": "LOW",
        "description": "<h4>AWS AMI launch permissions are not limited</h4><h4>Description</h4>It is recommended not to give the ability to launch AMIs across multiple accounts, and if it is implemented, make sure it is properly used.<br><h4>Fix - Runtime</h4>TBA<br><h4>Fix - Buildtime</h4>Terraform<br>Go- resource \"aws_ami_launch_permission\" \"remove_equivalent_block\" {<br>-   image_id   = \"ami-2345678\"<br>-   account_id = \"987654321\"<br>- }<br>"
    },
    "CKV_AWS_266": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-rds-db-snapshot-uses-customer-managed-keys-cmks",
        "severity": "LOW",
        "description": "<h4>AWS RDS DB snapshot does not use Customer Managed Keys (CMKs)</h4><h4>Description</h4>This policy identifies database snapshots that were not encrypted with KMS. It is a best practice to manage your own encryption keys for all storage volumes and snapshots.<br><h4>Fix - Runtime</h4>Changing the encryption method cannot be done for existing snapshots. Instead, create a new snapshot and add the CMK encryption.<br><br>Open the Amazon RDS console.<br>In the navigation pane, choose Databases.<br>Choose the DB instance for which you want to create a manual snapshot.<br>Create a manual snapshot for your DB instance.<br>In the navigation pane, choose Snapshots.<br>Select the manual snapshot that you created.<br>Choose Actions, and then choose Copy Snapshot.<br>Under Encryption, select Enable Encryption.<br>For AWS KMS Key, choose the new encryption key that you want to use.<br>Choose Copy snapshot.<br>Restore the copied snapshot.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_db_snapshot_copy<br>Argument: kms_key_id<br><br>Goresource \"aws_db_snapshot_copy\" \"pass\" {<br>source_db_snapshot_identifier = aws_db_snapshot.example.db_snapshot_arn<br>target_db_snapshot_identifier = \"testsnapshot1234-copy\"<br>+  kms_key_id= aws_kms_key.example.id<br>}<br>"
    },
    "CKV_AWS_241": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-kinesis-firehose-delivery-streams-are-encrypted-with-cmk",
        "severity": "LOW",
        "description": "<h4>AWS Kinesis Firehose Delivery Streams are not encrypted with CMK</h4><h4>Description</h4>This policy identifies Elastic File Systems (EFSs) which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your EFS data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br>Resource: aws_kinesis_firehose_delivery_stream<br>Arguments: s3_configuration.server_side_encryption.key_arn<br>Goresource \"aws_kinesis_firehose_delivery_stream\" \"pass\" {<br>name        = \"terraform-kinesis-firehose-test-stream\"<br>destination = \"s3\"<br><br>s3_configuration {<br>role_arn   = aws_iam_role.firehose_role.arn<br>bucket_arn = aws_s3_bucket.bucket.arn<br>}<br><br>server_side_encryption {<br>enabled=true #default is false<br>key_type = \"CUSTOMER_MANAGED_CMK\"<br>key_arn = aws_kms_key.example.arn<br>}<br>tags = {<br>test = \"failed\"<br>}<br>}<br>"
    },
    "CKV_AWS_221": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-code-artifact-domain-is-encrypted-by-kms-using-a-customer-managed-key-cmk",
        "severity": "LOW",
        "description": "<h4>AWS Code Artifact Domain is not encrypted by KMS using a Customer Managed Key (CMK)</h4><h4>Description</h4>This policy identifies Code Artifact Domains which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your Code Artifact Domain data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_codeartifact_domain\" \"pass\" {<br>domain         = \"example\"<br>encryption_key = aws_kms_key.example.arn<br>tags = {<br>\"key\" = \"value\"<br>}<br>}<br>"
    },
    "CKV_AWS_240": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-kinesis-firehoses-delivery-stream-is-encrypted",
        "severity": "LOW",
        "description": "<h4>Ensure AWS Kinesis Firehose's delivery stream is encrypted</h4><h4>Description</h4>As a best practice enable encryption for your AWS Kinesis Firehose's delivery stream to improve data security without making changes to your business or applications.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_kinesis_firehose_delivery_stream\" \"pass\" {<br>name        = \"terraform-kinesis-firehose-test-stream\"<br>destination = \"s3\"<br><br>s3_configuration {<br>role_arn   = aws_iam_role.firehose_role.arn<br>bucket_arn = aws_s3_bucket.bucket.arn<br>}<br><br>server_side_encryption {<br>enabled = true #default is false<br>}<br>tags = {<br>test = \"failed\"<br>}<br>}<br>"
    },
    "CKV_AWS_245": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-dms-instance-receives-all-minor-updates-automatically",
        "severity": "LOW",
        "description": "<h4>AWS DMS instance does not receive all minor updates automatically</h4><h4>Description</h4>When AWS Database Migration Service (AWS DMS) supports a new version, you can upgrade your replication instances to it. There are two kinds of upgrades: major version upgrades and minor version upgrades. Minor upgrades helps maintain a secure and stable DMS with minimal impact on the replication. For this reason, we recommend that your automatic minor upgrade is enabled. Minor version upgrades only occur automatically if a minor upgrade replaces an unsafe version, such as a minor upgrade that contains bug fixes for a previous version.<br><h4>Fix - Runtime</h4>CLI Command<br>Shellaws dms modify-replication-instance \\<br>--region ${region} \\<br>--replication-instance-arn ${resource_arn} \\<br>--auto-minor-version-upgrade \\<br>--apply-immediately<br><br><h4>Fix - Buildtime</h4>CloudFormation<br>YAMLResources:<br>Example:<br>Type: 'AWS::DMS::ReplicationInstance'<br>Properties:<br>EngineVersion: 3.1.4<br>ReplicationInstanceIdentifier: example<br>ReplicationInstanceClass: dms.t2.micro<br>+     AutoMinorVersionUpgrade: true<br><br>Terraform<br>Goresource \"aws_dms_replication_instance\" \"example\" {<br>engine_version               = \"3.1.4\"<br>replication_instance_class   = \"dms.t2.micro\"<br>replication_instance_id      = \"example\"<br>+ auto_minor_version_upgrade   = true<br>}<br>"
    },
    "CKV_AWS_224": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-cluster-logging-is-encrypted-using-a-customer-managed-key-cmk",
        "severity": "LOW",
        "description": "<h4>AWS cluster logging is not encrypted using a Customer Managed Key (CMK)</h4><h4>Description</h4>This policy identifies cluster logging which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your cluster logging data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br>Textresource \"aws_ecs_cluster\" \"pass2\" {<br>name = \"white-hart\"<br>configuration {<br>execute_command_configuration {<br>kms_key_id = aws_kms_key.example.arn<br><br>log_configuration {<br>#        cloud_watch_encryption_enabled = true<br># cloud_watch_log_group_name     = aws_cloudwatch_log_group.example.name<br><br># or<br># s3_bucket_name=   and<br>s3_bucket_encryption_enabled = true<br>}<br>}<br>}<br>tags = { test = \"fail\" }<br>}<br>"
    },
    "CKV_AWS_214": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-appsync-api-cache-is-encrypted-at-rest",
        "severity": "LOW",
        "description": "<h4>AWS Appsync API Cache is not encrypted at rest</h4><h4>Description</h4>Encryption of data at rest is a security feature that helps prevent unauthorized access to your data. The feature uses AWS Key Management Service (AWS KMS) to store and manage your encryption keys and the Advanced Encryption Standard algorithm with 256-bit keys (AES-256) to perform the encryption. If enabled, the feature encrypts the domain's: indices, logs, swap files, all data in the application directory, and automated snapshots.<br>We recommend you implement encryption at rest in order to protect a data store containing sensitive information from unauthorized access, and fulfill compliance requirements.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Goresource \"aws_appsync_api_cache\" \"pass\" {<br>api_id                     = aws_appsync_graphql_api.default.id<br>transit_encryption_enabled = true<br>at_rest_encryption_enabled = true<br>ttl                        = 60<br>type                       = \"SMALL\"<br>api_caching_behavior       = \"FULL_REQUEST_CACHING\"<br>}<br>"
    },
    "CKV_AWS_193": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-appsyncs-logging-is-enabled",
        "severity": "LOW",
        "description": "<h4>AWS AppSync's logging is disabled</h4><h4>Description</h4>It is recommended to have a proper logging process for AWS AppSync in order to track configuration changes conducted manually and programmatically and trace back unapproved changes.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_appsync_graphql_api\" \"enabled\" {<br>authentication_type = \"API_KEY\"<br>name                = \"example\"<br><br>log_config {<br>cloudwatch_logs_role_arn = \"aws_iam_role.example.arn\"<br>field_log_level          = \"ERROR\"<br>}<br>}<br>"
    },
    "CKV_AWS_196": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-elasticache-security-groups-are-defined",
        "severity": "LOW",
        "description": "<h4>AWS Elasticache security groups are not defined</h4><h4>Description</h4>By ensuring that AWS Elasticache security groups are defined, you can help protect your clusters from unauthorized access and ensure that only authorized traffic is allowed to reach your clusters. This can help prevent data breaches and other security incidents, and can also help ensure that your clusters are not overwhelmed by unwanted traffic.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_elasticache_security_group\" \"exists\" {<br>name                 = \"elasticache-security-group\"<br>security_group_names = [aws_security_group.bar.name]<br>}<br><br>resource \"aws_security_group\" \"bar\" {<br>name = \"security-group\"<br>}<br>"
    },
    "CKV_AWS_200": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-image-recipe-ebs-disk-are-encrypted-using-a-customer-managed-key-cmk",
        "severity": "LOW",
        "description": "<h4>AWS Image Recipe EBS Disk are not encrypted using a Customer Managed Key (CMK)</h4><h4>Description</h4>This policy identifies Image Recipe EBS Disks which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your EFS data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4>TBA<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_imagebuilder_image_recipe\" \"pass2\" {<br>block_device_mapping {<br>device_name = \"/dev/xvdb\"<br><br>ebs {<br>encrypted             = true<br>kms_key_id            = aws_kms_key.fail.arn<br>delete_on_termination = true<br>volume_size           = 100<br>volume_type           = \"gp2\"<br>}<br>}<br><br>component {<br>component_arn = aws_imagebuilder_component.fail.arn<br>}<br><br>name         = \"example\"<br>parent_image = \"arn:${data.aws_partition.current.partition}:imagebuilder:${data.aws_region.current.name}:aws:image/amazon-linux-2-x86/x.x.x\"<br>version      = \"1.0.0\"<br>}<br>"
    },
    "CKV_AWS_208": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-mqbroker-version-is-up-to-date",
        "severity": "LOW",
        "description": "<h4>AWS MQBroker version is not up to date</h4><h4>Description</h4>This test examines the value of engine version for MQ, and flags if the version is less than the minimum required:<br>versionsminimumActiveMQ = 5.16<br>minimumRabbitMQ = 3.8<br><br>Current versions supported can be found here:<br>https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/activemq-version-management.html<br>https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/rabbitmq-version-management.html<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Modify the engine version in either aws_mq_configuration or aws_mq_broker, to be higher or equal to the minimums:<br>Goresource \"aws_mq_configuration\" \"example\" {<br>description    = \"Example Configuration\"<br>name           = \"example\"<br>engine_type    = \"ActiveMQ\"<br>+ engine_version = \"5.17.1\"<br><br>data = <<DATA<br><?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><br><broker xmlns=\"http://activemq.apache.org/schema/core\"><br><plugins><br><forcePersistencyModeBrokerPlugin persistenceFlag=\"true\"/><br><statisticsBrokerPlugin/><br><timeStampingBrokerPlugin ttlCeiling=\"86400000\" zeroExpirationOverride=\"86400000\"/><br></plugins><br></broker><br>DATA<br>}<br>"
    },
    "CKV_AWS_249": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-appsync-has-field-level-logs-enabled",
        "severity": "LOW",
        "description": "<h4>AWS AppSync has field-level logs disabled</h4><h4>Description</h4>It is recommended to have a proper logging process for AWS AppSync in order to detect anomalous configuration activity. It is used to track configuration changes conducted manually and programmatically and trace back unapproved changes.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_appsync_graphql_api\" \"all\" {<br>authentication_type = \"API_KEY\"<br>name                = \"example\"<br><br>log_config {<br>cloudwatch_logs_role_arn = \"aws_iam_role.example.arn\"<br>field_log_level          = \"ALL\"<br>}<br>}<br>"
    },
    "CKV_AWS_211": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-rds-uses-a-modern-cacert",
        "severity": "LOW",
        "description": "<h4>AWS RDS does not use a modern CaCert</h4><h4>Description</h4>By ensuring that your AWS RDS uses a modern CA certificate, you can help ensure that the certificate used to secure connections to your database is up to date and free of known vulnerabilities. This can help protect your database from potential attacks and improve the overall security of your system.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_db_instance\" \"pass\" {<br>allocated_storage                   = 20<br>storage_type                        = \"gp2\"<br>engine                              = \"mysql\"<br>engine_version                      = \"5.7\"<br>instance_class                      = \"db.t2.micro\"<br>name                                = \"mydb\"<br>username                            = \"foo\"<br>password                            = \"foobarbaz\"<br>iam_database_authentication_enabled = true<br>storage_encrypted                   = true<br>ca_cert_identifier                  = \"rds-ca-2019\"<br>}<br>"
    },
    "CKV_AWS_199": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-image-builder-distribution-configuration-is-encrypting-ami-by-key-management-service-kms-using-a-customer-managed-key-cmk",
        "severity": "LOW",
        "description": "<h4>AWS Image Builder Distribution Configuration is not encrypting AMI by Key Management Service (KMS) using a Customer Managed Key (CMK)</h4><h4>Description</h4>This policy identifies Elastic File Systems (EFSs) which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your EFS data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br>Resource: aws_imagebuilder_distribution_configuration<br>Arguments: distribution.ami_distribution_configuration.kms_key_id<br>Goresource \"aws_imagebuilder_distribution_configuration\" \"pass\" {<br>name        = \"example\"<br>description = \"non empty value\"<br><br>distribution {<br>ami_distribution_configuration {<br>kms_key_id = aws_kms_key.fail.arn<br>ami_tags = {<br>CostCenter = \"IT\"<br>}<br><br>name = \"example-{{ imagebuilder:buildDate }}\"<br><br>launch_permission {<br>user_ids = [\"123456789012\"]<br>}<br>}<br><br>region = \"us-east-1\"<br>}<br>}<br>"
    },
    "CKV_AWS_236": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-ami-copying-uses-a-customer-managed-key-cmk",
        "severity": "LOW",
        "description": "<h4>AWS AMI copying does not use a Customer Managed Key (CMK)</h4><h4>Description</h4>This policy identifies AMI copies which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer-managed KMS Keys to encrypt your AMI copies data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_ami_copy\" \"pass\" {<br>name              = \"terraform-example\"<br>description       = \"A copy of ami-xxxxxxxx\"<br>source_ami_id     = \"ami-xxxxxxxx\"<br>source_ami_region = \"us-west-1\"<br>encrypted         = true #default is false<br>kms_key_id        = aws_kms_key.copy.arn<br>tags = {<br>Name = \"HelloWorld\"<br>test = \"failed\"<br>}<br>}<br>"
    },
    "CKV_AWS_244": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-mwaa-environment-has-webserver-logs-enabled",
        "severity": "LOW",
        "description": "<h4>AWS MWAA environment has webserver logs disabled</h4><h4>Description</h4>It is recommended to have a proper logging process for AWS MWAA environment webserver in order to track configuration changes conducted manually and programmatically and trace back unapproved changes.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_mwaa_environment\" \"pass\" {<br>dag_s3_path        = \"dags/\"<br>execution_role_arn = \"aws_iam_role.example.arn\"<br><br>logging_configuration {<br>dag_processing_logs {<br>enabled   = true<br>log_level = \"DEBUG\"<br>}<br><br>webserver_logs {<br>enabled   = true<br>log_level = \"INFO\"<br>}<br>}<br><br>name = \"example\"<br><br>network_configuration {<br>security_group_ids = [\"aws_security_group.example.id\"]<br>subnet_ids         = \"aws_subnet.private[*].id\"<br>}<br><br>source_bucket_arn = \"aws_s3_bucket.example.arn\"<br>}<br>"
    },
    "CKV_AWS_265": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-keyspace-table-uses-customer-managed-keys-cmks",
        "severity": "LOW",
        "description": "<h4>AWS Keyspace Table does not use Customer Managed Keys (CMKs)</h4><h4>Description</h4>This policy identifies Keyspace Tables which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your Keyspace Table data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br>Resource: aws_keyspaces_table<br>Arguments: encryption_specification.kms_key_identifier<br>Goresource \"aws_keyspaces_table\" \"pass\" {<br>keyspace_name = aws_keyspaces_keyspace.example.name<br>table_name    = \"my_table\"<br><br>schema_definition {<br>column {<br>name = \"Message\"<br>type = \"ASCII\"<br>}<br><br>partition_key {<br>name = \"Message\"<br>}<br>}<br>encryption_specification {<br>kms_key_identifier=aws_kms_key.example.arn<br>type=\"CUSTOMER_MANAGED_KEY\"<br>}<br>"
    },
    "CKV_AWS_197": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-mqbroker-audit-logging-is-enabled",
        "severity": "LOW",
        "description": "<h4>AWS MQBroker audit logging is disabled</h4><h4>Description</h4>It is recommended to have a proper logging process for AWS MQBroke in order to track configuration changes conducted manually and programmatically and trace back unapproved changes.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_mq_broker\" \"enabled\" {<br>broker_name        = \"example\"<br>engine_type        = \"ActiveMQ\"<br>engine_version     = \"5.16.3\"<br>host_instance_type = \"mq.t3.micro\"<br><br>user {<br>password = \"admin123\"<br>username = \"admin\"<br>}<br><br>logs {<br>general = true<br>audit   = true<br>}<br>}<br>"
    },
    "CKV_AWS_237": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-api-gateway-enables-create-before-destroy",
        "severity": "LOW",
        "description": "<h4>AWS API Gateway does not enable Create before Destroy</h4><h4>Description</h4>It is recommended to enable create_before_destroy argument inside the resource lifecycle configuration block to avoid a possible outage when the API Gateway needs to be recreated during an update.<br><h4>Fix - Buildtime</h4>CloudFormation<br>CloudFormation creates a new API Gateway first and then will delete the old one automatically.<br>Terraform<br>Goresource \"aws_api_gateway_rest_api\" \"example\" {<br>name = \"example\"<br><br>+ lifecycle {<br>+   create_before_destroy = true<br>+ }<br>}<br>"
    },
    "CKV_AWS_222": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-dms-instance-receives-all-minor-updates-automatically",
        "severity": "LOW",
        "description": "<h4>AWS DMS instance does not receive all minor updates automatically</h4><h4>Description</h4>When AWS Database Migration Service (AWS DMS) supports a new version, you can upgrade your replication instances to it. There are two kinds of upgrades: major version upgrades and minor version upgrades. Minor upgrades helps maintain a secure and stable DMS with minimal impact on the replication. For this reason, we recommend that your automatic minor upgrade is enabled. Minor version upgrades only occur automatically if a minor upgrade replaces an unsafe version, such as a minor upgrade that contains bug fixes for a previous version.<br><h4>Fix - Runtime</h4>CLI Command<br>Shellaws dms modify-replication-instance \\<br>--region ${region} \\<br>--replication-instance-arn ${resource_arn} \\<br>--auto-minor-version-upgrade \\<br>--apply-immediately<br><br><h4>Fix - Buildtime</h4>CloudFormation<br>YAMLResources:<br>Example:<br>Type: 'AWS::DMS::ReplicationInstance'<br>Properties:<br>EngineVersion: 3.1.4<br>ReplicationInstanceIdentifier: example<br>ReplicationInstanceClass: dms.t2.micro<br>+     AutoMinorVersionUpgrade: true<br><br>Terraform<br>Goresource \"aws_dms_replication_instance\" \"example\" {<br>engine_version               = \"3.1.4\"<br>replication_instance_class   = \"dms.t2.micro\"<br>replication_instance_id      = \"example\"<br>+ auto_minor_version_upgrade   = true<br>}<br>"
    },
    "CKV_AWS_251": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-cloudtrail-logging-is-enabled",
        "severity": "LOW",
        "description": "<h4>AWS CloudTrail logging is disabled</h4><h4>Description</h4>It is recommended to have a proper logging process for AWS CloudTrail in order to track configuration changes conducted manually and programmatically and trace back unapproved changes.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_cloudtrail\" \"pass\" {<br>name                          = \"TRAIL\"<br>s3_bucket_name                = aws_s3_bucket.test.id<br>include_global_service_events = true<br>enable_logging = true<br>kms_key_id                    = aws_kms_key.test.arn<br>}<br>"
    },
    "CKV_AWS_203": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-fsx-openzfs-file-system-is-encrypted-by-aws-key-management-service-kms-using-a-customer-managed-key-cmk",
        "severity": "LOW",
        "description": "<h4>AWS FSX openzfs is not encrypted by AWS' Key Management Service (KMS) using a Customer Managed Key (CMK)</h4><h4>Description</h4>This policy identifies  FSX openzfs file systems which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your  FSX openzfs file system data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Resource: aws_fsx_openzfs_file_system<br>Arguments: kms_key_id<br>Goresource \"aws_fsx_openzfs_file_system\" \"pass\" {<br>storage_capacity                = var.file_system.storage_capacity<br>subnet_ids                      = var.subnet_ids<br>deployment_type                 = var.file_system.deployment_type<br>throughput_capacity             = var.file_system.throughput_capacity<br>kms_key_id                      = var.kms_key_id<br>automatic_backup_retention_days = 0 #flag as no bckup<br>}<br>"
    },
    "CKV_AWS_202": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-memorydb-data-is-encrypted-in-transit",
        "severity": "LOW",
        "description": "<h4>AWS MemoryDB data is not encrypted in transit</h4><h4>Description</h4>This policy identifies the AWS MemoryDB  that are configured with disabled in-transit data encryption. It is recommended that these resources will be configured with in-transit data encryption to minimize risk for sensitive data being leaked.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_memorydb_cluster\" \"pass2\" {<br>acl_name                 = \"open-access\"<br>name                     = \"my-cluster\"<br>node_type                = \"db.t4g.small\"<br>num_shards               = 2<br>security_group_ids       = [aws_security_group.example.id]<br>snapshot_retention_limit = 7<br>subnet_group_name        = aws_memorydb_subnet_group.example.id<br>tls_enabled              = true<br>}<br>"
    },
    "CKV_AWS_207": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-mqbrokers-minor-version-updates-are-enabled",
        "severity": "LOW",
        "description": "<h4>AWS MQ Broker's minor version updates are disabled</h4><h4>Description</h4>When Amazon MQ supports a new version of a broker engine, you can upgrade your broker instances to the new version. There are two kinds of upgrades: major version upgrades and minor version upgrades. Minor upgrades helps maintain a secure and stable MQ broker with minimal impact on the application. For this reason, we recommend that your automatic minor upgrade is enabled. Minor version upgrades only occur automatically if a minor upgrade replaces an unsafe version, such as a minor upgrade that contains bug fixes for a previous version.<br><h4>Fix - Runtime</h4>CLI Command<br>Shellaws mq update-broker \\<br>--region ${region} \\<br>--broker-id ${resource_id} \\<br>--auto-minor-version-upgrade<br><br><h4>Fix - Buildtime</h4>CloudFormation<br>YAMLResources:<br>Example:<br>Type: \"AWS::AmazonMQ::Broker\"<br>Properties:<br>BrokerName: example<br>EngineType: ActiveMQ<br>EngineVersion: \"5.15.9\"<br>HostInstanceType: mq.t3.micro<br>+     AutoMinorVersionUpgrade: true<br><br>Terraform<br>Goresource \"aws_mq_broker\" \"example\" {<br>broker_name                = \"example\"<br>engine_type                = \"ActiveMQ\"<br>engine_version             = \"5.15.9\"<br>host_instance_type         = \"mq.t3.micro\"<br>+ auto_minor_version_upgrade = true<br>}<br>"
    },
    "CKV_AWS_252": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-cloudtrail-defines-an-sns-topic",
        "severity": "LOW",
        "description": "<h4>AWS CloudTrail does not define an SNS Topic</h4><h4>Description</h4>AWS CloudTrail is a service that records API activity in your AWS account, including all API calls made to AWS services and the associated responses. By sending CloudTrail log events to an SNS topic, you can set up notifications that will be sent to you whenever certain types of activity occur in your AWS environment.<br>In addition, sending CloudTrail log events to an SNS topic also allows you to store the log events in a central location, such as an Amazon S3 bucket, for analysis and reporting purposes. This can be useful for compliance, auditing, and other types of monitoring.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_cloudtrail\" \"pass\" {<br>name                          = \"TRAIL\"<br>s3_bucket_name                = aws_s3_bucket.test.id<br>include_global_service_events = true<br>enable_logging                = false<br>is_multi_region_trail         = false<br>sns_topic_name                = aws_sns_topic.notes.arn<br>tags                          = { test = \"Fail\" }<br>}<br>"
    },
    "CKV_AWS_234": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-acm-certificates-has-logging-preference",
        "severity": "LOW",
        "description": "<h4>AWS ACM certificate does not have logging preference</h4><h4>Description</h4>To guard against SSL/TLS certificates that are issued by mistake or by a compromised CA, some browsers like Chrome require that public certificates issued for a domain be recorded in a certificate transparency log. The domain name is recorded, but not the private key. Certificates that are not logged typically generate an error in the browser.<br><h4>Fix - Runtime</h4>Console<br>It is not possible to adjust transparency logging via console.<br>CLI<br>Shellaws acm request-certificate \\<br>--domain-name example.com \\<br>--validation-method DNS \\<br>--options CertificateTransparencyLoggingPreference=ENABLED \\<br><br><h4>Fix - Buildtime</h4>CloudFormation<br>YAMLResources:<br>Example:<br>Type: \"AWS::CertificateManager::Certificate\"<br>Properties:<br>DomainName: example.com<br>ValidationMethod: DNS<br>+     CertificateTransparencyLoggingPreference: ENABLED<br><br>Terraform<br>Goresource \"aws_acm_certificate\" \"example\" {<br>domain_name       = \"example.com\"<br>validation_method = \"DNS\"<br><br>+ options {<br>+   certificate_transparency_logging_preference = \"ENABLED\"<br>+ }<br>}<br>"
    },
    "CKV_AWS_277": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-security-group-does-not-allow-all-traffic-on-all-ports",
        "severity": "MEDIUM",
        "description": "<h4>AWS Security Group allows all traffic on all ports</h4><h4>Description</h4>By allowing all ingress traffic on all ports, AWS security group permits unrestricted internet access. Make sure that ports are defined properly<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_security_group\" \"example\" {<br>name = \"allow-all-ingress\"<br><br>ingress {<br>cidr_blocks = [\"0.0.0.0/0\"]<br>-    from_port   = -1<br>-    to_port     = -1<br>+    from_port   = 443<br>+    to_port     = 443<br>protocol    = \"tcp\"<br>}<br>}<br>"
    },
    "CKV2_AWS_34": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-ssm-parameter-is-encrypted",
        "severity": "LOW",
        "description": "<h4>AWS SSM Parameter is not encrypted</h4><h4>Description</h4>As a best practice enable encryption for your AWS SSM Parameter to improve data security without making changes to your business or applications.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_ssm_parameter\" \"aws_ssm_parameter_ok\" {<br>name            = \"sample\"<br>type            = \"SecureString\"<br>value           = \"test\"<br>description     = \"policy test\"<br>tier            = \"Standard\"<br>allowed_pattern = \".*\"<br>data_type       = \"text\"<br>}<br>"
    },
    "CKV_AWS_255": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-dlm-cross-region-schedules-are-encrypted",
        "severity": "LOW",
        "description": "<h4>AWS DLM-cross region schedules are not encrypted</h4><h4>Description</h4>As a best practice enable encryption for your AWS DLM-cross region schedules to improve data security without making changes to your business or applications.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_cloudfront_response_headers_policy\" \"pass\" {<br>name    = \"test\"<br><br>security_headers_config {<br>strict_transport_security {<br>access_control_max_age_sec = 31536000<br>include_subdomains         = true<br>override                   = true<br>preload                    = true<br>}<br>}<br>}<br>"
    },
    "CKV_AWS_227": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-key-management-service-kms-key-is-enabled",
        "severity": "LOW",
        "description": "<h4>AWS Key Management Service (KMS) key is disabled</h4><h4>Description</h4>Ensuring that your Amazon Key Management Service (AWS KMS) key is enabled is important because it determines whether the key can be used to perform cryptographic operations. When a key is enabled, it can be used to encrypt, decrypt, and generate data keys. When it is disabled, it cannot be used for these operations.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_kms_key\" \"pass\" {<br>description = \"description\"<br>is_enabled  = true<br>policy      = <<POLICY<br>{<br>\"Version\": \"2012-10-17\",<br>\"Statement\": [<br>{<br>\"Effect\": \"Allow\",<br>\"Principal\": {<br>\"AWS\": \"arn:aws:iam::111122223333:root\"<br>},<br>\"Action\": \"kms:*\",<br>\"Resource\": \"*\"<br>},<br>{<br>\"Effect\": \"Allow\",<br>\"Principal\": {<br>\"AWS\": \"*\"<br>},<br>\"Action\": \"kms:*\",<br>\"Resource\": \"*\"<br>},<br>]<br>}<br>POLICY<br>tags        = { test = \"Fail\" }<br>}<br>"
    },
    "CKV2_AWS_1": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-all-nacl-are-attached-to-subnets",
        "severity": "LOW",
        "description": "<h4>Not all NACL are attached to subnets</h4><h4>Description</h4>Network Access Control Lists (NACLs) are used to allow or deny traffic to and from subnets in a Virtual Private Cloud (VPC) in Amazon Web Services (AWS). It's important to ensure that all NACLs are attached to subnets because this allows you to set specific rules for controlling inbound and outbound traffic for those subnets. This can help to improve the security and connectivity of your VPC by allowing you to specify which traffic is allowed to enter or leave your subnets.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_vpc,  aws_network_acl, aws_subne<br>Argument: subnet_ids of  aws_network_acl<br><br>Goresource \"aws_vpc\" \"ok_vpc\" {<br>cidr_block = \"10.0.0.0/16\"<br>}<br><br>resource \"aws_subnet\" \"main\" {<br>vpc_id     = aws_vpc.ok_vpc.id<br>cidr_block = \"10.0.1.0/24\"<br>}<br><br>resource \"aws_subnet\" \"main\" {<br>cidr_block = \"10.0.1.0/24\"<br>}<br><br>resource \"aws_network_acl\" \"acl_ok\" {<br>vpc_id = aws_vpc.ok_vpc.id<br>subnet_ids = [aws_subnet.main.id]<br>}<br>"
    },
    "CKV2_AWS_18": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-elastic-file-system-amazon-efs-file-systems-are-added-in-the-backup-plans-of-aws-backup",
        "severity": "LOW",
        "description": "<h4>Amazon EFS does not have an AWS Backup backup plan</h4><h4>Description</h4>Ensure that Amazon Elastic File Systems (EFS) are included in your backup plans for the AWS Backup. AWS Backup is a fully managed backup service that helps you protect your data in the cloud by automatically backing up your data to a secure, durable storage location. By creating a backup plan, you can ensure that your data is regularly backed up and can be recovered in the event of data loss or corruption.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_backup_plan, aws_backup_selection, aws_efs_file_system<br>Argument:  plan_id and resources of aws_backup_selection<br><br>Goresource \"aws_backup_plan\" \"example\" {<br>name = \"tf_example_backup_plan\"<br><br>rule {<br>rule_name         = \"tf_example_backup_rule\"<br>target_vault_name = aws_backup_vault.test.name<br>schedule          = \"cron(0 12 * * ? *)\"<br>}<br><br>advanced_backup_setting {<br>backup_options = {<br>WindowsVSS = \"enabled\"<br>}<br>resource_type = \"EC2\"<br>}<br>}<br><br>resource \"aws_backup_selection\" \"ok_backup\" {<br>iam_role_arn = aws_iam_role.example.arn<br>name         = \"tf_example_backup_selection\"<br>plan_id      = aws_backup_plan.example.id<br><br>resources = [<br>aws_db_instance.example.arn,<br>aws_ebs_volume.example.arn,<br>aws_efs_file_system.ok_efs.arn,<br>]<br>}<br><br>resource \"aws_efs_file_system\" \"ok_efs\" {<br>creation_token = \"my-product\"<br><br>tags = {<br>Name = \"MyProduct\"<br>}<br>}<br>"
    },
    "CKV2_AWS_41": {
        "url": "https://docs.bridgecrew.io/docs/ensure-an-iam-role-is-attached-to-ec2-instance",
        "severity": "MEDIUM",
        "description": "<h4>AWS EC2 Instance IAM Role not enabled</h4><h4>Description</h4>AWS provides Identity Access Management (IAM) roles to securely access AWS services and resources. The role is an identity with permission policies that define what the identity can and cannot do in AWS. As a best practice, create IAM roles and attach the role to manage EC2 instance permissions securely instead of distributing or sharing keys or passwords<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: aws_instance<br>Argument: iam_instance_profile<br><br>YAMLresource \"aws_instance\" \"pass\" {<br>ami           = \"ami-005e54dee72cc1d00\" # us-west-2<br>instance_type = \"t2.micro\"<br>iam_instance_profile = \"test\"<br><br>network_interface {<br>network_interface_id = aws_network_interface.foo.id<br>device_index         = 0<br>}<br><br>credit_specification {<br>cpu_credits = \"unlimited\"<br>}<br>}<br>"
    },
    "CKV2_AWS_50": {
        "url": "https://docs.bridgecrew.io/docs/ensure-aws-elasticache-redis-cluster-with-multi-az-automatic-failover-feature-set-to-enabled",
        "severity": "MEDIUM",
        "description": "<h4>AWS ElastiCache Redis cluster with Multi-AZ Automatic Failover feature set to disabled</h4><h4>Description</h4>This policy identifies ElastiCache Redis clusters that have Multi-AZ Automatic Failover feature set to disabled. It is recommended to enable the Multi-AZ Automatic Failover feature for your Redis Cache cluster, which will improve primary node reachability by providing read replica in case of network connectivity loss or loss of availability in the primary's availability zone for read/write operations.\\nNote: Redis cluster Multi-AZ with automatic failover does not support T1 and T2 cache node types and is only available if the cluster has at least one read replica.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"aws_elasticache_replication_group\" \"pass\" {<br>automatic_failover_enabled  = true<br>preferred_cache_cluster_azs = [\"us-west-2a\", \"us-west-2b\"]<br>replication_group_id        = \"tf-rep-group-1\"<br>description                 = \"example description\"<br>node_type                   = \"cache.m4.large\"<br>num_cache_clusters          = 2<br>parameter_group_name        = \"default.redis3.2\"<br>port                        = 6379<br>}<br>"
    },
    "CKV_GCP_19": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_kubernetes_11",
        "severity": "MEDIUM",
        "description": "<h4>GCP Kubernetes engine clusters have basic authentication enabled</h4><h4>Description</h4>GKE supports multiple secure authentication methods, including service account bearer tokens, OAuth tokens, x509 client certificates. Basic authentication and client certificate issuance are disabled by default for clusters created with GKE 1.12 and later.<br>We recommend you use Cloud IAM, or an alternative secure authentication mechanism, as the identity provider for GKE clusters.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_container_cluster\" \"pass2\" {<br>name               = \"google_cluster\"<br>monitoring_service = \"monitoring.googleapis.com\"<br>master_authorized_networks_config {}<br>master_auth {<br>username = \"\"<br>password = \"\"<br>client_certificate_config {<br>issue_client_certificate = false<br>}<br>}<br><br>}<br>"
    },
    "CKV_GCP_29": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_gcs_2",
        "severity": "MEDIUM",
        "description": "<h4>GCP cloud storage bucket with uniform bucket-level access are disabled</h4><h4>Description</h4>For a user to access a Cloud Storage resource only one of the systems needs to grant the user permission. Cloud IAM is used throughout Google Cloud and allows you to grant a variety of permissions at bucket and project levels. ACLs have limited permission options, are used only by Cloud Storage, and allow you to grant permissions on a per-object basis.<br>Cloud Storage has uniform bucket-level access that supports a uniform permissioning system. Using this feature disables ACLs for all Cloud Storage resources. Access to Cloud Storage resources is granted exclusively through Cloud IAM. Enabling uniform bucket-level access guarantees that if a Storage bucket is not publicly accessible, no object in the bucket is publicly accessible.<br>We recommend you enable uniform bucket-level access on Cloud Storage buckets. Uniform bucket-level access is used to unify and simplify how you grant access to your Cloud Storage resources. Cloud Storage offers two systems that act in parallel for granting users permission to access your buckets and objects:<br><br>Cloud Identity and Access Management (Cloud IAM)<br>Access Control Lists (ACLs).<br><br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Cloud Storage.<br>From the list of buckets, select the name of the desired bucket.<br>Near the top of the page, click the Permissions tab.<br>In the text box that begins This bucket uses fine-grained access control, click Edit.<br>A pop-up menu opens. Select Uniform.<br>Click Save.<br><br>CLI Command<br>Set the option to on for uniformbucketlevelaccess, using the following command:<br>gsutil uniformbucketlevelaccess set on gs://BUCKET_NAME/<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_storage_bucket<br>Argument: uniform_bucket_level_access is set to true,<br><br>Goresource \"google_storage_bucket\" \"examplea\" {<br>name     = \"terragoat-${var.environment}\"<br>bucket_policy_only = true<br>+   uniform_bucket_level_access = true<br>}<br>"
    },
    "CKV2_GCP_11": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-gcr-container-vulnerability-scanning-is-enabled",
        "severity": "MEDIUM",
        "description": "<h4>GCP GCR Container Vulnerability Scanning is disabled</h4><h4>Description</h4>This policy identifies GCP accounts where GCR Container Vulnerability Scanning is not enabled. GCR Container Analysis and other third party products allow images stored in GCR to be scanned for known vulnerabilities. Vulnerabilities in software packages can be exploited by hackers or malicious users to obtain unauthorized access to local cloud resources. It is recommended to enable vulnerability scanning for images stored in Google Container Registry.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_project_services\" \"pass_1\" {<br>project = \"your-project-id\"<br>services   = [\"iam.googleapis.com\", \"cloudresourcemanager.googleapis.com\", \"containerscanning.googleapis.com\"]<br>}<br>"
    },
    "CKV_GCP_1": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_kubernetes_1",
        "severity": "MEDIUM",
        "description": "<h4>Stackdriver logging on Kubernetes engine clusters is disabled</h4><h4>Description</h4>Stackdriver is the default logging solution for clusters deployed on GKE. Stackdriver logging is deployed to a new cluster by default, explicitly set to opt-out. Stackdriver logging collects only the container\u2019s standard output and standard error streams. To ingest logs, Stackdriver logging agent must be deployed to each node in the cluster. Stackdriver provides a single-pane-of-glass view of metrics, logs, and traces through Kubernetes Engine clusters and workloads.<br>We recommend you use Stackdriver logging as a unified data logging solution for GKE workloads unless additional observability tooling is already in place.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_container_cluster\" \"primary\" {<br>name     = \"my-gke-cluster\"<br>location = \"us-central1\"<br>remove_default_node_pool = true<br>initial_node_count       = 1<br>logging_service = \"logging.googleapis.com/kubernetes\"<br>}<br>"
    },
    "CKV_GCP_7": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_kubernetes_2",
        "severity": "MEDIUM",
        "description": "<h4>ABAC authorization on Kubernetes engine clusters is enabled</h4><h4>Description</h4>Kubernetes RBAC (Role-Based Access Control) can be used to grant permissions to resources at the cluster and namespace level. It allows defining roles with rules containing a set of permissions. RBAC has significant security advantages and is now stable in Kubernetes, superseding  the benefits of legacy authorization with ABAC (Attribute-Based Access Control).<br>We recommend you disable ABAC authorization and use RBAC in GKE instead.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_container_cluster\" \"primary\" {<br>name     = \"my-gke-cluster\"<br>location = \"us-central1\"<br>remove_default_node_pool = true<br>initial_node_count       = 1<br>logging_service = \"logging.googleapis.com/kubernetes\"<br>enable_legacy_abac = false<br>}<br>"
    },
    "CKV_GCP_8": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_kubernetes_3",
        "severity": "MEDIUM",
        "description": "<h4>GCP Kubernetes Engine Clusters have Cloud Monitoring disabled</h4><h4>Description</h4>Stackdriver is the default logging solution for clusters deployed on GKE. Stackdriver logging is deployed to a new cluster by default, explicitly set to opt-out. Stackdriver logging collects only the container\u2019s standard output and standard error streams. To ingest logs, Stackdriver logging agent must be deployed to each node in the cluster. Stackdriver provides a single-pane-of-glass view of metrics, logs, and traces through Kubernetes Engine clusters and workloads.<br>We recommend you use Stackdriver logging as a unified data logging solution for GKE workloads unless additional observability tooling is already in place.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_container_cluster\" \"primary\" {<br>name     = \"my-gke-cluster\"<br>location = \"us-central1\"<br>remove_default_node_pool = true<br>initial_node_count       = 1<br>monitoring_service = \"monitoring.googleapis.com/kubernetes\"<br>}<br>"
    },
    "CKV_GCP_9": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_kubernetes_4",
        "severity": "MEDIUM",
        "description": "<h4>GCP Kubernetes cluster node auto-repair configuration is disabled</h4><h4>Description</h4>Auto-repairing mode in GKE is an automated service that identifies and repairs a failing node to maintain a healthy running state. GKE makes periodic checks on the health state of each node in the cluster. If a node fails consecutive health checks over an extended time period, GKE initiates a repair process for that node.<br>We recommend automatic node repair is enabled on kubernetes clusters to provide continued operation of mission critical nodes and ensuring applications are operating based on their pre-defined specs, minimized downstream failures and redundant alerting and triage.<br><h4>Fix - Runtime</h4>Gcloud CLI<br>Use the following command line to enable the node-pool automatic repair feature:<br>Bashgcloud container node-pools update pool-name<br>--cluster cluster-name \\<br>--zone compute-zone \\<br>--enable-autorepair<br><br>More information here: https://cloud.google.com/kubernetes-engine/docs/how-to/node-auto-repai<br><h4>Fix - Buildtime</h4>Terraform<br>Add the following code bloc into your google_container_node_pool resource:<br>management {<br>auto_repair  = true<br>}<br><br>If you don't have a separated node-pool resource on your terraform codebase, you can refer to the Gcloud CLI part. You will first need to recover the name of the node pool through the console or the CLI. Please be reminded that it is best practice to delete the default node-pool from the cluster and to create a specific one using the google_container_node_pool resource.<br>More information here: https://cloud.google.com/kubernetes-engine/docs/how-to/node-auto-repair<br>"
    },
    "CKV_GCP_10": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_kubernetes_5",
        "severity": "MEDIUM",
        "description": "<h4>GCP Kubernetes cluster node auto-upgrade configuration is disabled</h4><h4>Description</h4>Node auto-upgrade keeps nodes up-to-date with the latest cluster master version when your master is updated on your behalf. When a new cluster or node pool is created, node auto-upgrade is enabled as default.<br>We recommend you ensure auto-upgrade is enabled. Automatic node upgrade ensures that when new binaries are released you instantly get a fix with the latest security issues resolved. GKE will automatically ensure that security updates are applied and kept up to date.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_container_node_pool\" \"primary_preemptible_nodes\" {<br>name       = \"my-node-pool\"<br>cluster    = google_container_cluster.primary.id<br>node_count = 1<br>management {<br>auto_upgrade = true<br>}<br>]<br>}<br>}<br>"
    },
    "CKV_GCP_25": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_kubernetes_6",
        "severity": "MEDIUM",
        "description": "<h4>Private cluster is disabled when creating Kubernetes clusters</h4><h4>Description</h4>Private clusters enable isolation of nodes from any inbound and outbound connectivity to the public internet. This is achieved as the nodes have internal RFC 1918 IP addresses only. In private clusters, the cluster master has private and public endpoints. You can configure which endpoint should be enabled or disabled to control access to the public internet.<br>We recommend you enable private cluster when creating Kubernetes clusters. By creating a private cluster, the nodes will have a reserved set of IP addresses, ensuring their workloads are isolated from the public internet.<br><h4>Fix - Buildtime</h4>Terraform<br>Add Block: private_cluster_config with attribute  enable_private_nodes set to true.<br>google_container_cluster.cluster.tfresource \"google_container_cluster\" \"cluster\" {<br>...<br>+ private_cluster_config {<br>+   enable_private_nodes=true<br>+ }<br>...<br>}<br>"
    },
    "CKV_GCP_12": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_kubernetes_7",
        "severity": "MEDIUM",
        "description": "<h4>GCP Kubernetes engine clusters have network policy disabled</h4><h4>Description</h4>Defining a network policy helps ensure that a compromised front-end service in your application cannot communicate directly with an external interface, for example, a billing or an accounting service several levels down. Network policy rules can ensure that Pods and Services in a given namespace cannot access other Pods or Services in a different namespace.<br>We recommend you enable Network Policy on kubernetes engine clusters to determine which Pods and Services can access one another inside your cluster. This ensures only the required services are communicating and no explicitly indicated traffic is able to reach private clusters.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_container_cluster\" \"pass\" {<br>name = \"google_cluster\"<br>network_policy {<br>enabled = true<br>}<br>}<br>"
    },
    "CKV_GCP_13": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_kubernetes_8",
        "severity": "LOW",
        "description": "<h4>GCP Kubernetes engine clusters have client certificate enabled</h4><h4>Description</h4>Kubernetes uses client certificates, bearer tokens, an authenticating proxy, HTTP basic auth or OAuth app to authenticate API requests through authentication plugins. As HTTP requests are made to the API server, plugins attempt to associate the following attributes with the request.<br>We recommend you ensure Kubernetes engine clusters are authenticated using OAuth method and not using client certificates as before after service latest upgrade.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_container_cluster\" \"primary\" {<br>name               = \"marcellus-wallace\"<br>location           = \"us-central1-a\"<br>initial_node_count = 3<br>master_auth {<br>client_certificate_config {<br>issue_client_certificate = false<br>}<br>}<br>node_config {<br># Google recommends custom service accounts that have cloud-platform scope and permissions granted via IAM Roles.<br>service_account = google_service_account.default.email<br>oauth_scopes = [<br>\"https://www.googleapis.com/auth/cloud-platform\"<br>]<br>labels = {<br>foo = \"bar\"<br>}<br>tags = [\"foo\", \"bar\"]<br>}<br>timeouts {<br>create = \"30m\"<br>update = \"40m\"<br>}<br>}<br>"
    },
    "CKV_GCP_24": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_kubernetes_9",
        "severity": "LOW",
        "description": "<h4>PodSecurityPolicy controller is not enabled on Kubernetes engine clusters</h4><h4>Description</h4>PodSecurityPolicy is an admission controller resource created to validate requests to create and update Pods on your cluster. The PodSecurityPolicy defines a set of conditions that Pods must meet to be accepted by the cluster. When a request to create or update a Pod does not meet the conditions in the PodSecurityPolicy, that request is rejected and an error is returned.<br>We recommend you enable PodSecurityPolicy Controller on Kubernetes engine clusters.<br><h4>Fix - Runtime</h4>Gcloud CLI<br>To update the cluster to enable the PodSecurityPolicy Controller, use this command:<br>gcloud beta container clusters update cluster-name --enable-pod-security-policy<br><br>More information at: https://cloud.google.com/kubernetes-engine/docs/how-to/pod-security-policies<br><h4>Fix - Buildtime</h4>Terraform<br>First, be sure to have the google-beta provider setup in the google_container_cluster, then add the following block of code:<br>Gopod_security_policy_config {<br>enabled = true<br>}<br><br>More information at: https://www.terraform.io/docs/providers/google/r/container_cluster.html#pod_security_policy_config<br>"
    },
    "CKV_GCP_18": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_kubernetes_10",
        "severity": "LOW",
        "description": "<h4>GKE control plane is public</h4><h4>Description</h4>The GKE cluster control plane and nodes have internet routable addresses that can be accessed from any IP address by default. Direct internet access to nodes can be disabled by specifying the gcloud tool option enable-private-nodes at cluster creation.<br>We recommend you disable direct internet access to nodes at cluster creation and ensure clusters use master authorized networks and private nodes to reach the control plane by whitelisted CIDRs, nodes within the cluster VPC and Google management jobs.<br>We also recommend you limit the exposure of the cluster control plane and nodes to the internet. These settings can only be set at cluster creation time and help ensure sensitive controllers are not exposed to external access.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_container_cluster\" \"primary\" {<br>name               = \"marcellus-wallace\"<br>location           = \"us-central1-a\"<br>initial_node_count = 3<br>private_cluster_config {<br>enable_private_nodes = true<br>}<br>}<br>"
    },
    "CKV_GCP_20": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_kubernetes_12",
        "severity": "MEDIUM",
        "description": "<h4>Master authorized networks are not enabled in GKE clusters</h4><h4>Description</h4>Authorized networks allow whitelisting of specific CIDR ranges and permit IP addresses in those ranges to access the cluster master endpoint using HTTPS. GKE uses both TLS and authentication to secure access to the cluster master endpoint from the public Internet. This approach enables the flexibility to administer the cluster from anywhere.<br>We recommend you enable master authorized networks in GKE clusters. Using authorized networks you will be able further restrict access to specified sets of IP addresses.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_container_cluster\" \"primary\" {<br>name               = \"marcellus-wallace\"<br>location           = \"us-central1-a\"<br>initial_node_count = 3<br>master_auth {<br>client_certificate_config {<br>issue_client_certificate = false<br>}<br>}<br>master_authorized_networks_config {<br>cidr_blocks {<br>cidr_block =\"10.10.10.10/0\"<br>display_name = \"foo\"<br>}<br>}<br>}<br>"
    },
    "CKV_GCP_21": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_kubernetes_13",
        "severity": "LOW",
        "description": "<h4>GCP Kubernetes engine clusters do not have any label information</h4><h4>Description</h4>Labels are key, value pairs that are attached to objects intended to be used to specify identifying attributes of objects that are meaningful and relevant to users, but do not directly imply semantics to the core system.<br>Labels can be used to organize and select subsets of objects. Labels can be attached to objects at creation time and subsequently added and modified at any time. Each object can have a set of key/value labels defined. Each Key must be unique for a given object. Labels enable users to map their own organizational structures onto system objects in a loosely coupled fashion, without requiring clients to store these mappings.<br>We recommend you configure Kubernetes clusters with labels.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_container_cluster\" \"primary\" {<br>name               = \"marcellus-wallace\"<br>location           = \"us-central1-a\"<br>initial_node_count = 3<br>master_auth {<br>client_certificate_config {<br>issue_client_certificate = false<br>}<br>}<br>node_config {<br># Google recommends custom service accounts that have cloud-platform scope and permissions granted via IAM Roles.<br>service_account = google_service_account.default.email<br>oauth_scopes = [<br>\"https://www.googleapis.com/auth/cloud-platform\"<br>]<br>labels = {<br>foo = \"bar\"<br>}<br>tags = [\"foo\", \"bar\"]<br>}<br>timeouts {<br>create = \"30m\"<br>update = \"40m\"<br>}<br>}<br>"
    },
    "CKV_GCP_22": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_kubernetes_14",
        "severity": "LOW",
        "description": "<h4>GCP Kubernetes engine clusters are not using Container-Optimized OS for node image</h4><h4>Description</h4>GKE enables users to select the operating system image that runs on each node. You can also upgrade an existing cluster to use a different node image type. GKE supports several OS images using the main container runtime directly integrated with Kubernetes, including cos_containerd and ubuntu_containerd.<br>We recommend you use cos_containerd and ubuntu_containerd to enhance node security. Containerd is an industry-standard container runtime component that regularly updates security fixes and patches, providing better support, security, and stability than other images.<br><h4>Fix - Runtime</h4>Gcloud CLI<br>Use this following command to upgrade the cluster to use the COS image:<br>Bashgcloud container clusters upgrade --image-type cos cluster-name<br><br>To upgrade a specific node-pool add the flag/argument --node-pool node-pool-name.<br><h4>Fix - Buildtime</h4>Terraform<br>Add the image_type argument into the node_config bloc to your google_container_cluster or google_container_node_pool resource:<br>hcl<br>node_config {<br>image_type   = \"COS\"<br>}<br><br>It should force the cluster to recreate a node following the new configuration.<br>For further information please follow this link: https://www.terraform.io/docs/providers/google/r/container_cluster.html#image_type<br>"
    },
    "CKV_GCP_23": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_kubernetes_15",
        "severity": "LOW",
        "description": "<h4>Kubernetes clusters are not created with alias IP ranges enabled</h4><h4>Description</h4>In GKE, clusters can be set apart based on how they route traffic from one pod to another. A cluster that uses alias IP ranges is called a VPC-native cluster. A cluster that uses Google Cloud Routes is called a routes-based cluster.<br>We recommend you create Kubernetes clusters with alias IP ranges enabled. Alias IP ranges allow Pods to directly access hosted services without using a NAT gateway.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_container_cluster\" \"primary\" {<br>name     = \"my-gke-cluster\"<br>location = \"us-central1\"<br>remove_default_node_pool = true<br>initial_node_count       = 1<br>ip_allocation_policy<br>{<br>}<br>}<br>"
    },
    "CKV_GCP_2": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_networking_1",
        "severity": "CRITICAL",
        "description": "<h4>GCP Firewall rule allows all traffic on SSH port 22</h4><h4>Description</h4>Firewall rules setup fine-grained allow/deny traffic policies to and from a VM. Enabled rules are always enforced, and help protect instances from unwanted traffic. Firewall rules are defined at the network level, and only apply to the network where they are created.<br>Every VPC functions as a distributed firewall. While firewall rules are defined at the network level, connections are allowed or denied on a per-instance basis. A default network is pre-populated with firewall rules that allow incoming traffic to instances. The default-allow-ssh rule permits ingress connections on TCP port 22 from any source to any instance in the network.<br>We recommend you restrict or remove the default-allow-ssh rule when you no longer need it.<br><h4>Fix - Runtime</h4>Procedure<br><br>List your firewall rules. You can view a list of all rules or just those in a particular network.<br>Click the rule default-allow-ssh.<br>Click Delete.<br>Click Delete again to confirm.<br><br>CLI Command<br>gcloud compute firewall-rules delete default-allow-ssh<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_compute_firewall<br>Argument: deny. The deny block supports:<br>protocol (Required)<br>The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, sctp, ipip), or the IP protocol number.<br>ports (Optional)<br>An optional list of ports to which this rule applies. This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: [\"22\"], [\"80\",\"443\"], and [\"12345-12349\"].<br><br>Goresource \"google_compute_firewall\" \"default\" {<br>name    = \"test-firewall\"<br>network = google_compute_network.default.name<br><br>allow {<br>protocol = \"icmp\"<br>}<br><br>deny {<br>protocol = \"ssh\"<br>ports    = [\"22\"]<br>}<br>}<br>"
    },
    "CKV_GCP_3": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_networking_2",
        "severity": "CRITICAL",
        "description": "<h4>GCP Firewall rule allows all traffic on RDP port 3389</h4><h4>Description</h4>Firewall rules setup fine grained allow/deny traffic policies to and from a virtual machine (VM). Enabled rules are always enforced, and help protecting instances from unwanted traffic. Firewall rules are defined at the network level, and only apply to the network where they are created.<br>Every VPC functions as a distributed firewall. While firewall rules are defined at the network level, connections are allowed or denied on a per-instance basis. A default network is pre-populated with firewall rules that allow incoming traffic to instances. The default-allow-rdp rule permits ingress connections on TCP port 3389 from any source to any instance in the network.<br>We recommend you restrict or remove the default-allow-rdp rule when you no longer need it.<br><h4>Fix - Runtime</h4>Procedure<br><br>List your firewall rules. You can view a list of all rules or just those in a particular network.<br>Click the rule \"default-allow-rdp\" to delete.<br>Click Delete.<br>Click Delete again to confirm.<br><br>CLI Command<br>gcloud compute firewall-rules delete default-allow-rdp<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_compute_firewall<br>Argument: deny. The deny block supports:<br>protocol (Required) The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, sctp, ipip), or the IP protocol number.<br>ports (Optional) An optional list of ports to which this rule applies. This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: [\"22\"], [\"80\",\"443\"], and [\"12345-12349\"].<br><br>Goresource \"google_compute_firewall\" \"default\" {<br>name    = \"test-firewall\"<br>network = google_compute_network.default.name<br><br>allow {<br>protocol = \"icmp\"<br>}<br><br>deny {<br>protocol = \"tcp\"<br>ports    = [\"3389\"]<br>}<br>"
    },
    "CKV_GCP_4": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_networking_3",
        "severity": "MEDIUM",
        "description": "<h4>GCP HTTPS load balancer is configured with SSL policy having TLS version 1.1 or lower</h4><h4>Description</h4>Secure Sockets Layer (SSL) policies determine what port Transport Layer Security (TLS) features clients are permitted to use when connecting to load balancers. SSL policies control the features of SSL in Google Cloud SSL proxy load balancer and external HTTP(S) load balancers. By default, HTTP(S) Load Balancing and SSL Proxy Load Balancing use a set of SSL features that provides good security and wide compatibility.<br>To prevent usage of insecure features, SSL policies should use one of the following three options:<br><br>At least TLS 1.2 with the MODERN profile; or<br>The RESTRICTED profile, because it effectively requires clients to use TLS 1.2 regardless of the chosen minimum TLS version; or<br>A CUSTOM profile that does not support any of the following features:<br><br><br>TLS_RSA_WITH_AES_128_GCM_SHA256<br>TLS_RSA_WITH_AES_256_GCM_SHA384<br>TLS_RSA_WITH_AES_128_CBC_SHA<br>TLS_RSA_WITH_AES_256_CBC_SHA<br>TLS_RSA_WITH_3DES_EDE_CBC_SHA<br><br>Load balancers are used to efficiently distribute traffic across multiple servers. Both SSL proxy and HTTPS load balancers are external load balancers: they distribute traffic from the Internet to a GCP network. GCP customers can configure load balancer SSL policies with a minimum TLS version (1.0, 1.1, or 1.2) that clients can use to establish a connection, along with a profile (Compatible, Modern, Restricted, or Custom) that specifies permissible and insecure cipher suites. It is easy for customers to configure a load balancer without knowing they are permitting outdated cipher suites.<br>It is possible to define SSL policies to control the features of SSL that your load balancer negotiates with clients. An SSL policy can be configured to determine the minimum TLS version and SSL features that are enabled in the load balancer. We recommend you select TLS 1.2 as the minimum TLS version supported.<br><h4>Fix - Runtime</h4>GCP Console<br>If the TargetSSLProxy or TargetHttpsProxy does not have an SSL policy configured, create a new SSL policy. Otherwise, modify the existing insecure policy.<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to SSL Policies.<br>Click on the name of the insecure policy to go to its SSL policy details page.<br>Click EDIT.<br>Set Minimum TLS version to TLS 1.2.<br>Set Profile to Modern or Restricted.<br>Alternatively, if the user selects the profile Custom, make sure that the following features are disabled:<br><br><br>TLS_RSA_WITH_AES_128_GCM_SHA256<br>TLS_RSA_WITH_AES_256_GCM_SHA384<br>TLS_RSA_WITH_AES_128_CBC_SHA<br>TLS_RSA_WITH_AES_256_CBC_SHA<br>TLS_RSA_WITH_3DES_EDE_CBC_SHA<br><br>CLI Command<br><br>For each insecure SSL policy, update it to use secure cyphers:<br><br>gcloud compute ssl-policies update NAME<br>[--profile COMPATIBLE|MODERN|RESTRICTED|CUSTOM]<br>--min-tls-version 1.2 [--custom-features FEATURES]<br><br><br>If the target proxy has a GCP default SSL policy, use the following command corresponding to the proxy type to update it:<br><br>gcloud compute target-ssl-proxies update TARGET_SSL_PROXY_NAME<br>--ssl-policy SSL_POLICY_NAME<br>gcloud compute target-https-proxies update TARGET_HTTPS_POLICY_NAME<br>--sslpolicy SSL_POLICY_NAME<br><br><h4>Fix - Buildtime</h4>Terraform<br><br><br>Resource: google_compute_ssl_policy<br><br><br>Argument: profile = MODERN<br><br><br>Resource: google_compute_ssl_policy<br><br><br>Arguments:<br>profile = CUSTOM<br>custom_features = []<br><br><br>Go//Option 1<br>resource \"google_compute_ssl_policy\" \"modern-profile\" {<br>name            = \"nonprod-ssl-policy\"<br>+ profile         = \"MODERN\"<br>+ min_tls_version = \"TLS_1_2\"<br>}<br><br>//Option 2<br>resource \"google_compute_ssl_policy\" \"custom-profile\" {<br>name            = \"custom-ssl-policy\"<br>+ profile         = \"CUSTOM\"<br>min_tls_version = \"TLS_1_2\"<br>+ custom_features = [\"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384\", \"TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384\"]<br>}<br>"
    },
    "CKV_GCP_11": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_networking_4",
        "severity": "HIGH",
        "description": "<h4>Cloud SQL database instances are publicly accessible</h4><h4>Description</h4>Cloud SQL is a fully managed relational database service for MySQL, PostgreSQL, and SQL Server. It offers data encryption at rest and in transit, Private connectivity with VPC and user-controlled network access with firewall protection.<br>It is possible to configure Cloud SQL to have a public IPv4 address. This means your cluster can accept connections from specific IP addresses, or a range of addresses, by adding authorized addresses to your instance. We do not recommend this option.<br>We recommend you ensure Cloud SQL Database Instances are not publicly accessible, to help secure against attackers scanning the internet in search of public databases.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to the Cloud SQL Instances page.<br>Click the instance name to open its Overview page.<br>Select the Connections tab.<br>Select Private IP checkbox.<br>A drop-down list shows the available networks in your project. If your project is the service project of a Shared VPC, VPC networks from the host project are also shown.<br><br>If you have configured private services access:<br>Select the VPC Network you want to use<br><br>A drop-down shows the IP address range you allocated.<br>Click Connect.<br>Click Save.<br><br>To let Cloud SQL allocate an IP address for you.<br><br>Select the default VPC network.<br>Click Allocate and connect.<br>Click Save.<br><br>CLI Command<br>VPC_NETWORK_NAME is the name of your chosen VPC network, for example: my-vpc-network. The --network parameter value is in the format: https://www.googleapis.com/compute/alpha/projects/[PROJECT_ID]/global/networks/[VPC_NETWORK_NAME]<br>Shellgcloud --project=[PROJECT_ID] beta sql instances patch [INSTANCE_ID]<br>--network=[VPC_NETWORK_NAME]<br>--no-assign-ip<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_compute_network<br>Argument: private_network (Optional)<br>The VPC network from which the Cloud SQL instance is accessible for private IP. For example, projects/myProject/global/networks/default. Specifying a network enables private IP. Either ipv4_enabled must be enabled or a private_network must be configured. This setting can be updated, but it cannot be removed after it is set.<br><br>Goresource \"google_compute_network\" \"private_network\" {<br>provider = google-beta<br><br>name = \"private-network\"<br>}<br><br>resource \"google_compute_global_address\" \"private_ip_address\" {<br>provider = google-beta<br><br>name          = \"private-ip-address\"<br>purpose       = \"VPC_PEERING\"<br>address_type  = \"INTERNAL\"<br>prefix_length = 16<br>network       = google_compute_network.private_network.id<br>}<br>"
    },
    "CKV_GCP_16": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_networking_5",
        "severity": "MEDIUM",
        "description": "<h4>GCP Cloud DNS has DNSSEC disabled</h4><h4>Description</h4>DNSSEC is a feature of the Domain Name System that authenticates responses to domain name lookups. DNSSEC prevents attackers from manipulating or poisoning the responses to DNS requests.<br>We recommend you ensure DNSSEC is enabled in: any public DNS zone, the top level domain registry, and in the local DNS resolvers.<br>\ud83d\udcd8NoteIf visibility is set to private, then DNSSEC cannot be set, and this policy will pass.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Click the DNSSEC setting for the existing managed zone.<br>Select \"On\" in the pop-up menu.<br>In the confirmation dialog, click Enable.<br><br>CLI Command<br>You can enable DNSSEC for existing managed zones using the gcloud command line tool or the API:<br>gcloud dns managed-zones update EXAMPLE_ZONE --dnssec-state on<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_dns_managed_zone<br>Argument: dnssec_config (Optional)<br>DNSSEC configuration Structure is documented below.<br><br>Goresource \"google_dns_managed_zone\" \"example\" {<br>description  = \"Company Domain name\"<br>dns_name     = \"example.com.\"<br><br>+ dnssec_config { # forces replacement<br>+ kind          = \"dns#managedZoneDnsSecConfig\" # forces replacement<br>+ non_existence = \"nsec3\" # forces replacement<br>+ state         = \"on\" # forces replacement<br>"
    },
    "CKV_GCP_17": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_networking_6",
        "severity": "MEDIUM",
        "description": "<h4>RSASHA1 is used for Zone-Signing and Key-Signing Keys in Cloud DNS DNSSEC</h4><h4>Description</h4>DNSSEC is a feature of the Domain Name System (DNS) that authenticates responses to domain name lookups. There are several advanced DNSSEC configuration options you can use if DNSSEC is enabled for your managed zones. These include: unique signing algorithms, denial of existence and the ability to use record types that require or recommend DNSSEC for their use.<br>When enabling DNSSEC for a managed zone, or creating a managed zone with DNSSEC, you can select the DNSSEC signing algorithms and the denial-of-existence type. We do not recommend you use RSASHA1 unless you need it for compatibility reasons; there is no security advantage to using it with larger key lengths.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_dns_managed_zone<br>Arguments:<br>zone_signing_keys - A list of Zone-signing key (ZSK) records. Structure is documented below.<br>key_signing_keys - A list of Key-signing key (KSK) records. Structure is documented below.<br><br>Additionally, the DS record is provided:<br>The key_signing_keys and zone_signing_keys block supports:<br>algorithm - String mnemonic specifying the DNSSEC algorithm of this key. Immutable after creation time. Possible values are ecdsap256sha256, ecdsap384sha384, rsasha1, rsasha256, and rsasha512.<br>Goresource \"google_dns_managed_zone\" \"foo\" {<br>name     = \"foobar\"<br>dns_name = \"foo.bar.\"<br><br>zone_signing_keys {<br>-   algorithm = \"rsasha1\"<br>}<br>"
    },
    "CKV_GCP_27": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_networking_7",
        "severity": "MEDIUM",
        "description": "<h4>Default network exists in a project</h4><h4>Description</h4>The default network has a pre-configured network configuration and automatically generates the following insecure firewall rules:<br><br>default-allow-internal: Allows ingress connections for all protocols and ports among instances in the network.<br>default-allow-ssh: Allows ingress connections on TCP port 22(SSH) from any source to any instance in the network.<br>default-allow-rdp: Allows ingress connections on TCP port 3389(RDP) from any source to any instance in the network.<br>default-allow-icmp: Allows ingress ICMP traffic from any source to any instance in<br>the network.<br><br>These automatically created firewall rules do not get audit logged and cannot be configured to enable firewall rule logging. In addition, the default network is an auto mode network, which means that its subnets use the same predefined range of IP addresses. As a result, it is not possible to use Cloud VPN or VPC Network Peering with the default network.<br>We recommend that a project should not have a default network to prevent use of default network. Based on organization security and networking requirements, the organization should create a new network and delete the default network.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to VPC networks.<br>Click the network named default.<br>On the network detail page, click EDIT.<br>Click DELETE VPC NETWORK.<br>If needed, create a new network to replace the default network.<br><br>CLI Command<br>For each Google Cloud Platform project:<br><br>Delete the default network:<br>gcloud compute networks delete default<br>If needed, create a new network to replace it:<br>gcloud compute networks create <network name><br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_project<br>Argument: auto_create_network<br><br>Goresource \"google_project\" \"my_project\" {<br>name       = \"My Project\"<br>project_id = \"your-project-id\"<br>org_id     = \"1234567\"<br>+ auto_create_network   = false<br>}<br>"
    },
    "CKV_GCP_32": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_networking_8",
        "severity": "HIGH",
        "description": "<h4>GCP VM instances have block project-wide SSH keys feature disabled</h4><h4>Description</h4>Project-wide SSH keys are stored in Compute/Project-meta-data. Project wide SSH keys can be used to login into all instances within a project. Using project-wide SSH keys eases SSH key management. If SSH keys are compromised, the potential security risk can impact all instances within a project.<br>We recommend you use Instance specific SSH keys instead of common/shared project-wide SSH key(s), to limit the attack surface should the SSH keys be compromised.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to VM instances.<br>List all the instances in your project.<br>Click the name of the Impacted instance.<br>Click Edit in the toolbar.<br>Under SSH Keys, navigate to Block project-wide SSH keys .<br>To block users with project-wide SSH keys from connecting to this instance, select Block project-wide SSH keys.<br>At the bottom of the page, click Save.<br><br>Repeat these steps for each impacted Instance.<br>CLI Command<br>To block project-wide public SSH keys, set the metadata value to TRUE using the following command:<br>gcloud compute instances add-metadata INSTANCE_NAME<br>--metadata block-projectssh-keys=TRUE<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_compute_instance<br>Field: metadata<br>Argument: block-project-ssh-keys<br><br>Goresource \"google_compute_instance\" \"default\" {<br>name         = \"test\"<br>machine_type = \"n1-standard-1\"<br>zone         = \"us-central1-a\"<br>metadata = {<br>+     block-project-ssh-keys = true<br>}<br>}<br>"
    },
    "CKV_GCP_33": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_networking_9",
        "severity": "HIGH",
        "description": "<h4>GCP projects have OS login disabled</h4><h4>Description</h4>Enabling OSLogin ensures that SSH keys used to connect to instances are mapped with IAM users. Revoking access to IAM user will revoke all the SSH keys associated with that particular user. It facilitates centralized and automated SSH key pair management. This is useful in handling cases such as response to compromised SSH key pairs and/or revocation of external/third-party/Vendor users.<br>We recommend you enable OSLogin to bind SSH certificates to IAM users and facilitates effective SSH certificate management.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Metadata.<br>Click Edit.<br>Add a metadata entry where the key is enable-oslogin and the value is TRUE.<br>To apply changes, click Save.<br>For every instances that overrides the project setting, go to the VM Instances page<br>at https://console.cloud.google.com/compute/instances.<br>Click the name of the instance on which you want to remove the metadata value.<br>To edit the instance settings go to the top of the instance details page and click Edit.<br>Under Custom metadata, remove any entry with key enable-oslogin and the value<br>is FALSE.<br>To apply your changes to the instance, navigate to the bottom of the instance details page and click Save.<br><br>CLI Command<br><br>Configure oslogin on the project using the following command:<br><br>gcloud compute project-info add-metadata --metadata enable-oslogin=TRUE<br><br><br>Remove instance metadata that overrides the project setting, using the following command:<br><br>gcloud compute instances remove-metadata INSTANCE_NAME --keys=enable-oslogin<br><br>Optionally, you can enable two factor authentication for OS login. For more information, see https://cloud.google.com/compute/docs/oslogin/setup-two-factor-authentication.<br><h4>Fix - Buildtime</h4>Terraform<br><br><br>Resource: google_compute_project_metadata<br><br><br>Argument: enable-oslogin<br><br><br>Resource: google_compute_instance<br><br><br>Argument: enable-oslogin<br>Should not override project metadata: should not be set to false.<br><br><br>Go//Option 1<br>resource \"google_compute_project_metadata\" \"default\" {<br>metadata = {<br>+    enable-oslogin = true<br>}<br>}<br><br>//Option 2<br>resource \"google_compute_instance\" \"default\" {<br>name         = \"test\"<br>machine_type = \"n1-standard-1\"<br>zone         = \"us-central1-a\"<br>boot_disk {}<br>metadata = {<br>-     enable-oslogin = false<br>}<br>}<br>"
    },
    "CKV_GCP_34": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_networking_10",
        "severity": "MEDIUM",
        "description": "<h4>Project instance overrides the project setting enabling OSLogin</h4><h4>Description</h4>Enabling OSLogin ensures that SSH keys used to connect to instances are mapped with IAM users. Revoking access to IAM user will revoke all the SSH keys associated with that particular user. It facilitates centralized and automated SSH key pair management. This is useful in handling cases such as response to compromised SSH key pairs and/or revocation of external/third-party/Vendor users.<br>We recommend you enable OSLogin to bind SSH certificates to IAM users and facilitates effective SSH certificate management.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Metadata.<br>Click Edit.<br>Add a metadata entry where the key is enable-oslogin and the value is TRUE.<br>To apply changes, click Save.<br>For every instances that overrides the project setting, go to the VM Instances page<br>at https://console.cloud.google.com/compute/instances.<br>Click the name of the instance on which you want to remove the metadata value.<br>To edit the instance settings go to the top of the instance details page and click Edit.<br>Under Custom metadata, remove any entry with key enable-oslogin and the value<br>is FALSE.<br>To apply your changes to the instance, navigate to the bottom of the instance details page and click Save.<br><br>CLI Command<br><br>To configure oslogin on the project, use the following command:<br><br>gcloud compute project-info add-metadata --metadata enable-oslogin=TRUE<br><br><br>To remove instance metadata that overrides the project setting, use the following command:<br><br>gcloud compute instances remove-metadata INSTANCE_NAME --keys=enable-oslogin<br><br>Optionally, you can enable two factor authentication for OS login. For more information, see https://cloud.google.com/compute/docs/oslogin/setup-two-factor-authentication.<br><h4>Fix - Buildtime</h4>Terraform<br><br><br>Resource: google_compute_project_metadata<br><br><br>Argument: enable-oslogin<br><br><br>Resource: google_compute_instance<br><br><br>Argument: enable-oslogin<br>Should not override project metadata: should not be set to false.<br><br><br>Go//Option 1<br>resource \"google_compute_project_metadata\" \"default\" {<br>metadata = {<br>+    enable-oslogin = true<br>}<br>}<br><br>//Option 2<br>resource \"google_compute_instance\" \"default\" {<br>name         = \"test\"<br>machine_type = \"n1-standard-1\"<br>zone         = \"us-central1-a\"<br>boot_disk {}<br>metadata = {<br>-     enable-oslogin = false<br>}<br>}<br>"
    },
    "CKV_GCP_35": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_networking_11",
        "severity": "MEDIUM",
        "description": "<h4>GCP VM instances have serial port access enabled</h4><h4>Description</h4>Interacting with a serial port is often referred to as the serial console. It is similar to using a terminal window: input and output is entirely in text mode with no graphical interface or mouse support. If the interactive serial console on an instance is enabled, clients can attempt to connect to that instance from any IP address. For security purposes interactive serial console support should be disabled.<br>A virtual machine instance has four virtual serial ports. Interacting with a serial port is similar to using a terminal window: input and output is entirely in text mode with no graphical interface or mouse support. The instance's BIOS operating system and other system-level entities write output to the serial ports and accept input, for example, commands and responses to prompts. Typically, these system-level entities use the first serial port (port 1). Serial port 1 is often referred to as the serial console.<br>The interactive serial console does not support IP-based access restrictions, for example, an IP whitelist. If you enable the interactive serial console on an instance, clients can connect to that instance from any IP address. This allows anybody with the correct SSH key, username, project ID, zone, and instance name to connect to that instance. To stop this type of access interactive serial console support should be disabled.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Computer Engine.<br>Navigate to VM instances.<br>Select the specific VM.<br>Click Edit.<br>Clear the checkbox Enable connecting to serial ports, located below the Remote access block.<br>Click Save.<br><br>CLI Command<br>To disable an instance use one of the following commands:<br>gcloud compute instances add-metadata INSTANCE_NAME<br>--zone=ZONE<br>--metadata=serial-port-enable=false<br><br>OR<br>gcloud compute instances add-metadata INSTANCE_NAME<br>--zone=ZONE<br>--metadata=serial-port-enable=0<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_compute_instance<br>Argument: serial-port-enable<br>By default set to false.<br><br>Goresource \"google_compute_instance\" \"default\" {<br>name         = \"test\"<br>machine_type = \"n1-standard-1\"<br>zone         = \"us-central1-a\"<br>boot_disk {}<br>metadata = {<br>-     serial-port-enable = true<br>}<br>}<br>"
    },
    "CKV_GCP_36": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_networking_12",
        "severity": "MEDIUM",
        "description": "<h4>IP forwarding on instances is enabled</h4><h4>Description</h4>The Compute Engine instance cannot forward a packet unless the source IP address of the packet matches the IP address of the instance. GCP will not deliver a packet with a destination IP address different to the IP address of the instance receiving the packet. Both capabilities are required when using instances to help route packets.<br>To enable this source and destination IP check, disable the canIpForward field. The canIpForward field allows an instance to send and receive packets with non-matching destination or source IPs.<br>We recommend the forwarding of data packets be disabled to prevent data loss and information disclosure.<br><h4>Fix - Runtime</h4>GCP Console<br>The canIpForward setting  can only be edited at instance creation time. It is recommended to<br>delete the instance and create a new one with canIpForward set to False.<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to VM instances.<br>Select the VM Instance to remediate.<br>Click Delete.<br>On the VM Instances page, click CREATE INSTANCE.<br>Create a new instance with the desired configuration.<br><br>\ud83d\udcd8NoteBy default, a new instance is configured to not allow IP forwarding.<br>CLI Command<br><br><br>To delete an instance, use the following command:<br>gcloud compute instances delete INSTANCE_NAME<br><br><br>To create a new instance to replace it with IP forwarding set to Off, use the following command:<br>gcloud compute instances create<br><br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_compute_instance<br>Argument: can_ip_forward<br>By default set to false.<br><br>Goresource \"google_compute_instance\" \"default\" {<br>name         = \"test\"<br>machine_type = \"n1-standard-1\"<br>zone         = \"us-central1-a\"<br>- can_ip_forward = true<br>}<br>"
    },
    "CKV_GCP_37": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_general_x",
        "severity": "LOW",
        "description": "<h4>GCP VM disks not encrypted with CSEKs</h4><h4>Description</h4>Customer-Supplied Encryption Keys (CSEK) are a feature in Google Cloud Storage and Google Compute Engine. Google Compute Engine encrypts all data at rest by default. Compute Engine handles and manages this encryption automatically, with no additional action required. When you provide your own encryption keys Compute Engine uses your key to protect the Google-generated keys used to encrypt and decrypt your data. Only users that provide the correct key can use resources protected by a customer-supplied encryption key. Google does not store your keys on its servers and cannot access your protected data unless you provide the key. If you forget or lose your key Google is unable to recover the key or to recover any data encrypted with that key. To control and manage this encryption yourself, you must provide your own encryption keys.<br>We recommend you supply your own encryption keys for Google to use, at a minimum to encrypt business critical VM disks. This helps protect the Google-generated keys used to encrypt and decrypt your data.<br><h4>Fix - Runtime</h4>GCP Console<br>Currently there is no way to update the encryption of an existing disk.<br>Ensure you create new disks with Encryption set to Customer supplied.<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Compute Engine Disks.<br>Click CREATE DISK.<br>Set Encryption type to Customer supplied.<br>In the dialog box, enter the Key.<br>Select Wrapped key.<br>Click Create.<br><br>CLI Command<br>In the gcloud compute tool, encrypt a disk, use the following command:<br>--csek-key-file flag during instance creation<br>If you are using an RSA-wrapped key, use the gcloud beta component and the following command:<br>gcloud (beta) compute instances create INSTANCE_NAME<br>--csek-key-file <example-file.json><br><br>To encrypt a standalone persistent disk, use the following command:<br>gcloud (beta) compute disks create DISK_NAME<br>--csek-key-file <examplefile.json><br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_compute_disk<br>Field: disk_encryption_key<br><br>Go// Option 1<br>resource \"google_compute_disk\" \"default\" {<br><br>...<br><br>+  disk_encryption_key {<br>+    raw_key = <raw key><br>or<br>+    kms_key_self_link = <key link><br>}<br>+  boot_disk {<br>+    disk_encryption_key_raw = <encryption key><br>}<br><br>}<br>// Option 2<br>resource \"google_compute_instance\" \"default\" {<br><br>...<br><br>+  boot_disk {<br>+    disk_encryption_key_raw = <encryption key><br>}<br>}<br>"
    },
    "CKV_GCP_38": {
        "url": "https://docs.bridgecrew.io/docs/encrypt-boot-disks-for-instances-with-cseks",
        "severity": "CRITICAL",
        "description": "<h4>Boot disks for instances do not use CSEKs</h4><h4>Description</h4>Customer-Supplied Encryption Keys (CSEK) are a feature in Google Cloud Storage and Google Compute Engine. Google Compute Engine encrypts all data at rest by default. Compute Engine handles and manages this encryption automatically, with no additional action required. When you provide your own encryption keys Compute Engine uses your key to protect the Google-generated keys used to encrypt and decrypt your data. Only users that provide the correct key can use resources protected by a customer-supplied encryption key. Google does not store your keys on its servers and cannot access your protected data unless you provide the key. If you forget or lose your key Google is unable to recover the key or to recover any data encrypted with that key. To control and manage this encryption yourself, you must provide your own encryption keys.<br>We recommend you supply your own encryption keys for Google to use, at a minimum to encrypt boot disks for instances. This helps protect the Google-generated keys used to encrypt and decrypt your data.<br><h4>Fix - Runtime</h4>GCP Console<br>Currently there is no way to update the encryption of an existing disk.<br>Ensure you create new disks with Encryption set to Customer supplied.<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Compute Engine Disks.<br>Click CREATE DISK.<br>Set Encryption type to Customer supplied.<br>In the dialog box, enter the Key.<br>Select Wrapped key.<br>Click Create.<br><br>CLI Command<br>In the gcloud compute tool, encrypt a disk, use the following command:<br>--csek-key-file flag during instance creation<br>If you are using an RSA-wrapped key, use the gcloud beta component and the following command:<br>gcloud (beta) compute instances create INSTANCE_NAME --csek-key-file <example-file.json><br>To encrypt a standalone persistent disk, use the following command:<br>gcloud (beta) compute disks create DISK_NAME --csek-key-file <examplefile.json><br><h4>Fix - Buildtime</h4>Terraform<br><br><br>Resource: google_compute_disk<br><br><br>Field: disk_encryption_key<br><br><br>Resource: google_compute_instance<br><br><br>Argument: boot_disk:disk_encryption_key_raw<br><br><br>Go//Option 2<br>resource \"google_compute_disk\" \"default\" {<br>name  = \"test-disk\"<br>type  = \"pd-ssd\"<br>zone  = \"us-central1-a\"<br>image = \"debian-8-jessie-v20170523\"<br>physical_block_size_bytes = 4096<br>+  disk_encryption_key {<br>+    raw_key = <raw key><br>or<br>+    kms_key_self_link = <key link><br>}<br>}<br><br>//Option 2<br>resource \"google_compute_instance\" \"default\" {<br>name         = \"test\"<br>machine_type = \"n1-standard-1\"<br>zone         = \"us-central1-a\"<br>boot_disk {<br>disk_encryption_key_raw = <encryption key><br>}<br>}<br>"
    },
    "CKV_GCP_39": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_general_y",
        "severity": "MEDIUM",
        "description": "<h4>Compute instances launch without shielded VM enabled</h4><h4>Description</h4>Shielded VMs are virtual machines (VMs) on a Google Cloud Platform hardened by a set of security controls that help defend against rootkits and bootkits. Shielded VM offers verifiable integrity on your Compute Engine VM instances, so you can be confident your instances have not been compromised by boot- or kernel-level malware or rootkits. The verifiable integrity of a Shielded VM is achieved through the use of Secure Boot and integrity monitoring, see below for further details.<br>We recommend you launch Compute instances with Shielded VM enabled to defend against advanced threats, and ensure that the boot loader and firmware on your VMs are signed and untampered. Shielded VM instances run firmware signed and verified using Google's Certificate Authority, ensuring the instance's firmware is unmodified and the root of trust for Secure Boot is established.<br>Secure Boot is a virtual trusted platform module (vTPM)-enabled Measured Boot. It helps ensure that the system only runs authentic software by verifying the digital signature of all boot components and halting the boot process if signature verification fails.<br>Integrity monitoring helps you understand and make decisions about the state of your VM instances. The Shielded VM vTPM enables Measured Boot by performing the measurements needed to create the integrity policy baseline used for comparison with measurements from subsequent VM boots to determine any changes.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to VM instances.<br>Select the instance name to view the VM instance details page.<br>Stop the instance, by clicking STOP.<br>When the instance has stopped, click EDIT.<br>In the Shielded VM section, turn on both vTPM and Integrity Monitoring.<br>Optionally, if you do not use any custom or unsigned drivers on the instance, turn on Secure Boot.<br>To modify the instance, click SAVE.<br>To restart the instance, click START.<br><br>CLI Command<br>You can only enable Shielded VM options on instances that have Shielded VM support. For a list of Shielded VM public images, run the gcloud compute images list command with the following flags:<br>gcloud compute images list --project gce-uefi-images --no-standard-images<br><br><br>To stop the instance, use the following command:<br>gcloud compute instances stop INSTANCE_NAME<br><br><br>To update the instance, use the following command:<br>gcloud compute instances update INSTANCE_NAME --shielded-vtpm --shielded-vmintegrity-monitoring<br><br><br>Optionally, if you do not use any custom or unsigned drivers on the instance, to turn on secure boot use the following command:<br>gcloud compute instances update INSTANCE_NAME --shielded-vm-secure-boot<br><br><br>To restart the instance, use the following command:<br>gcloud compute instances start INSTANCE_NAME<br><br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_compute_instance<br>Arguments:<br>enable_integrity_monitoring - set to true by default, should not be overriden, i.e should not be set to false.<br>enable_vtpm - set to true by default, should not be overriden, i.e should not be set to false.<br><br>Goresource \"google_compute_instance\" \"default\" {<br>name         = \"test\"<br>machine_type = \"n1-standard-1\"<br>zone         = \"us-central1-a\"<br>boot_disk {}<br>+    shielded_instance_config {<br>-        enable_integrity_monitoring = false<br>-        enable_vtpm                 = false<br>}<br>}<br>"
    },
    "CKV_GCP_43": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_general_4",
        "severity": "MEDIUM",
        "description": "<h4>GCP KMS encryption key is not rotating every 90 days</h4><h4>Description</h4>Google Cloud Key Management Service stores cryptographic keys in a hierarchical structure designed for access control management. The format for the rotation schedule depends on the client library used. In Terraform, the rotation period unit must be seconds.<br>A key is a named object representing a cryptographic key used for a specific purpose, including data protection. The key material, the actual bits used for encryption, can change over time as new key versions are created. A collection of files could be encrypted with the same key and people with decrypt permissions on that key would be able to decrypt those files.<br>We recommend you set a key rotation period, including start time. A key can be created with a specified rotation period, which is the time when new key versions are generated automatically. A key can also be created with a specified next rotation time.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Cryptographic Keys.<br>Select the specific key ring.<br>From the list of keys, select the specific key and Click on the blade (3 dots) on the right side of the pop up.<br>Click Edit rotation period.<br>On the pop-up window, Select a new rotation period in days; this should be less than 90 days. Then select a Starting on date; this is when the rotation period begins.<br><br>CLI Command<br>Update and schedule rotation by ROTATION_PERIOD and NEXT_ROTATION_TIME for each key:<br>gcloud kms keys update new<br>--keyring=KEY_RING<br>--location=LOCATION<br>--nextrotation-time=NEXT_ROTATION_TIME<br>--rotation-period=ROTATION_PERIOD<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_kms_crypto_key<br>Argument: rotation_period<br><br>Goresource \"google_kms_crypto_key\" \"key\" {<br>name            = \"crypto-key-example\"<br>key_ring        = google_kms_key_ring.keyring.id<br>+ rotation_period = \"7776000s\"<br>}<br>"
    },
    "CKV_GCP_6": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_general_1",
        "severity": "HIGH",
        "description": "<h4>Incoming connections to Cloud SQL database instances do not use SSL</h4><h4>Description</h4>Cloud SQL is a fully managed relational database service for MySQL, PostgreSQL and SQL Server. It offers data encryption at rest and in transit, Private connectivity with VPC and user-controlled network access with firewall protection. Cloud SQL creates a server certificate automatically when a new instance is created.<br>We recommend you enforce all connections to use SSL/TLS.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_sql_database_instance\" \"main\" {<br>name             = \"main-instance\"<br>database_version = \"POSTGRES_14\"<br>region           = \"us-central1\"<br><br>settings {<br># Second-generation instance tiers are based on the machine<br># type. See argument reference below.<br>tier = \"db-f1-micro\"<br>ip_configuration {<br>require_ssl = true<br>}<br>}<br>}<br>"
    },
    "CKV_GCP_14": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_general_2",
        "severity": "HIGH",
        "description": "<h4>Cloud SQL database instances do not have backup configuration enabled</h4><h4>Description</h4>Cloud SQL is a fully managed relational database service for MySQL, PostgreSQL and SQL Server. It offers data encryption at rest and in transit, Private connectivity with VPC and user-controlled network access with firewall protection. Backups provide a way to restore a Cloud SQL instance to recover lost data or recover from a problem with your instance.<br>We recommend you enable automated backups for instances that contain data of high importance.<br>Goresource \"google_sql_database_instance\" \"main\" {<br>name             = \"main-instance\"<br>database_version = \"POSTGRES_14\"<br>region           = \"us-central1\"<br>settings {<br>backup_configuration {<br>enabled = True<br>}<br>}<br>}<br>"
    },
    "CKV_GCP_15": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_general_3",
        "severity": "CRITICAL",
        "description": "<h4>GCP BigQuery dataset is publicly accessible</h4><h4>Description</h4>Dataset-level permissions help determine which users, groups, and service accounts are allowed to access tables, views, and table data in a specific BigQuery dataset. You can configure BigQuery permissions at a higher level in the Cloud IAM resource hierarchy. Your configurations are inherited and based on the IAM structure you select to apply.<br>We recommend you ensure private datasets remain private by avoiding the All Authenticated Users option which  gives all Google account holders access to the dataset, and makes the dataset public.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_bigquery_dataset\" \"pass_special_group\" {<br>dataset_id                  = \"example_dataset\"<br>friendly_name               = \"test\"<br>description                 = \"This is a test description\"<br>location                    = \"US\"<br><br>access {<br>role          = \"READER\"<br>special_group = \"projectReaders\"<br>}<br>}<br>"
    },
    "CKV_GCP_28": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_public_1",
        "severity": "HIGH",
        "description": "<h4>GCP storage buckets are publicly accessible to all authenticated users</h4><h4>Description</h4>Allowing anonymous or public access to a Cloud Storage bucket grants permissions to anyone to access the bucket's content. If you are storing sensitive data in the bucket anonymous and public access may not be desired.<br>We recommend you ensure anonymous and public access to a bucket is not allowed.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Storage.<br>Navigate to Bucket details page, select bucket name.<br>Click Permissions tab.<br>To remove a specific role assignment, to the front of allUsers and allAuthenticatedUsers, click Delete.<br><br>CLI Command<br>To remove access to allUsers and allAuthenticatedUsers, use the following commands:<br>gsutil iam ch -d allUsers gs://BUCKET_NAME<br>gsutil iam ch -d allAuthenticatedUsers gs://BUCKET_NAME<br><h4>Fix - Buildtime</h4>Terraform<br><br><br>Resource: google_storage_bucket_iam_member<br><br><br>Argument: member<br><br><br>Resource: google_storage_bucket_iam_binding<br><br><br>Field: members<br><br><br>Go//Option 1<br>resource \"google_storage_bucket_iam_member\" \"member\" {<br>bucket = google_storage_bucket.default.name<br>role = \"roles/storage.admin\"<br>-  member = \"allUsers\"<br>-  member = \"allAuthenticatedUsers\"<br>}<br><br>//Option 2<br>resource \"google_storage_bucket_iam_binding\" \"binding\" {<br>bucket = google_storage_bucket.default.name<br>role = \"roles/storage.admin\"<br>members = [<br>-    \"allAuthenticatedUsers\",<br>-    \"allUsers\"<br>]<br>}<br>"
    },
    "CKV_GCP_40": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_public_2",
        "severity": "MEDIUM",
        "description": "<h4>Compute instances have public IPs</h4><h4>Description</h4>To reduce your attack surface Compute instances should not have public IP addresses. To minimize the instance's exposure to the internet configure instances behind load balancers.<br>We recommend you ensure compute instances are not configured to have external IP addresses.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to VM instances.<br>For the Instance detail page, click the instance name.<br>Click Edit.<br>For each Network interface, ensure that External IP is set to None.<br>Click Done, then click Save.<br><br>CLI Command<br><br>Describe the instance properties:<br>gcloud compute instances describe INSTANCE_NAME --zone=ZONE<br>Identify the access config name that contains the external IP address. This access<br>config appears in the following format:<br><br>networkInterfaces:- accessConfigs:<br>- kind: compute#accessConfig<br>name: External NAT<br>natIP: 130.211.181.55<br>type: ONE_TO_ONE_NAT<br><br><br>To delete the access config, use the following command:<br><br>gcloud compute instances delete-access-config INSTANCE_NAME<br>--zone=ZONE<br>--access-config-name \"ACCESS_CONFIG_NAME\"<br><br>\ud83d\udcd8NoteIn the above example the ACCESS_CONFIG_NAME is External NAT. The name of your access config may be different.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_compute_instance<br>Field: access_config<br><br>Goresource \"google_compute_instance\" \"example\" {<br>name         = \"test\"<br>machine_type = \"n1-standard-1\"<br>zone         = \"us-central1-a\"<br>boot_disk {}<br>-  access_config {<br>...<br>}<br>}<br>"
    },
    "CKV_GCP_30": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_iam_1",
        "severity": "MEDIUM",
        "description": "<h4>Instances use default Compute Engine service account</h4><h4>Description</h4>The default Compute Engine service account has Editor role on the project, allowing read and write access to most Google Cloud Services.<br>We recommend you configure your instance to not use the default Compute Engine service account.<br>You should create a new service account and assign only the permissions needed by your instance. This helps defend against compromised VM privilege escalations and prevent an attacker from gaining access to all of your project.<br>\ud83d\udcd8NoteThe default Compute Engine service account is named:<br>[PROJECT_NUMBER][email\u00a0protected].<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to VM instances.<br>Click on the instance name to go to its VM instance details page.<br>Click STOP, then click EDIT.<br>Under the section Service Account, select a service account. You may first need to create a new service account.<br><br>\ud83d\udea7WarningDo not select the default Compute Engine service account.<br><br>Click Save and then click START.<br><br>CLI Command<br><br>Stop the instance:<br><br>gcloud compute instances stop INSTANCE_NAME<br><br><br>Update the instance:<br><br>gcloud compute instances set-service-account INSTANCE_NAME -<br>-serviceaccount=SERVICE_ACCOUNT<br><br><br>Restart the instance:<br><br>gcloud compute instances start INSTANCE_NAME<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_compute_instance<br>Field: service_account<br>Argument: email = <email other than the default service_account's><br><br>Goresource \"google_compute_instance\" \"default\" {<br>name         = \"test\"<br>machine_type = \"n1-standard-1\"<br>zone         = \"us-central1-a\"<br>+  service_account {<br>scopes = [\"userinfo-email\", \"compute-ro\", \"storage-ro\"]<br>-    email  = \"[PROJECT_NUMBER][email\u00a0protected]\"<br>+    email  = \"[email\u00a0protected]\"<br>}<br>}<br>"
    },
    "CKV_GCP_31": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_iam_2",
        "severity": "MEDIUM",
        "description": "<h4>Instances use default service account with full access to cloud APIs</h4><h4>Description</h4>When an instance is configured with Compute Engine default service account with Scope Allow full access to all Cloud APIs, based on IAM roles assigned to the user(s) accessing Instance, it may result in privilege escalation. For example, a user may have permission to perform cloud operations and API calls that they are not required to perform.<br>Along with the ability to optionally create, manage and use user managed custom service accounts, Google Compute Engine provides default service account Compute Engine default service account for an instances to access necessary cloud services. Project Editor role is assigned to Compute Engine default service account for this service account to have almost all capabilities over all cloud services, except billing. When Compute Engine default service account is assigned to an instance it can operate in three scopes:<br><br>Allow default access: Allows only minimum access required to run an Instance (Least Privileges).<br>Allow full access to all Cloud APIs: Allows full access to all the cloud APIs/Services (too much access).<br>Set access for each API: Allows Instance administrator to choose only those APIs that are needed to perform specific business functionality expected by instance.<br><br>We recommend you do not assign instances to default service account Compute Engine<br>default service account with Scope Allow full access to all Cloud APIs. This supports the principle of least privileges and helps prevent potential privilege escalation,<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to VM instances.<br>Select the impacted VM instance.<br>If the instance is not stopped, click Stop. Wait for the instance to stop.<br>Click Edit.<br>Scroll down to the Service Account section.<br>Select a different service account or ensure Allow full access to all Cloud APIs is not selected.<br>To save your changes, click Save.<br>Click START.<br><br>CLI Command<br><br>Stop the instance:<br><br>gcloud compute instances stop INSTANCE_NAME<br><br><br>Update the instance:<br><br>gcloud compute instances set-service-account INSTANCE_NAME<br>--serviceaccount=SERVICE_ACCOUNT<br>--scopes [SCOPE1, SCOPE2...]<br><br><br>Restart the instance:<br><br>gcloud compute instances start INSTANCE_NAME<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_compute_instance<br>Field: service_account<br>Argument: If email is set to the default service account, or not specified, scope should not contain full access api.<br><br>Goresource \"google_compute_instance\" \"default\" {<br>name         = \"test\"<br>machine_type = \"n1-standard-1\"<br>zone         = \"us-central1-a\"<br>service_account {<br>-    scopes = [\"https://www.googleapis.com/auth/cloud-platform\"]<br>-    email  = \"[PROJECT_NUMBER][email\u00a0protected]\"\"<br>}<br>}<br>"
    },
    "CKV_GCP_41": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_iam_3",
        "severity": "HIGH",
        "description": "<h4>IAM users are assigned Service Account User or Service Account Token creator roles at project level</h4><h4>Description</h4>A service account is a special Google account that belongs to an application or a VM, instead of to an individual end-user. Application/VM-Instance uses the service account to call the service's Google API so that end-users are not directly involved. The service account resource has IAM policies attached to it to determine who can use the service account.<br>Users with IAM roles to update the App Engine and Compute Engine instances, such as App Engine Deployer and Compute Instance Admin, can run code as the service accounts used to run these instances. This enables users to indirectly gain access to resources for which the service accounts have access. Similarly, SSH access to a Compute Engine instance may also provide the ability to execute code as that instance/Service account.<br>Your organization may have multiple user-managed service accounts configured for a project. Granting the iam.serviceAccountUser or iam.serviceAserviceAccountTokenCreatorccountUser roles to a user for a project gives the user access to all service accounts in the project, including service accounts created in the future. This can result in elevation of privileges by using service accounts and corresponding Compute Engine instances.<br>To implement least privileges best practices, IAM users should not be assigned the Service Account User or Service Account Token Creator roles at the project level. These roles should be assigned to a user for a specific service account, giving that user access to the service account. The Service Account User allows a user to bind a service account to a long-running job service. The Service Account Token Creator role allows a user to directly impersonate, or assert, the identity of a service account.<br>We recommend you assign the Service Account User (iam.serviceAccountUser) and Service Account Token Creator iam.serviceAccountTokenCreator roles to a user for a specific service account rather than assigning the role to a user at project level.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to IAM Admin.<br>Click on the filter table text bar. Type: Role: Service Account User<br>Click the Trash icon in front of the role Service Account User for every user listed as a result of a filter.<br>Click on the filter table text bar. Enter Role: Service Account Token Creator<br>Click the Trash icon in front of the role Service Account Token Creator for every user listed as a result of a filter.<br><br>CLI Command<br><br>Using a text editor, remove the bindings with roles/iam.serviceAccountUser and roles/iam.serviceAccountTokenCreator.<br>Update the project's IAM policy:<br>gcloud projects set-iam-policy PROJECT_ID iam.json.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resources:<br>google_project_iam_binding<br>google_project_iam_member<br>Argument: role<br><br>Goresource \"google_project_iam_binding\" \"project\" {<br>project = \"your-project-id\"<br>- role    = \"roles/iam.serviceAccountTokenCreator\"<br>- role    = \"roles/iam.serviceAccountUser\"<br>}<br>"
    },
    "CKV_GCP_42": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_iam_4",
        "severity": "CRITICAL",
        "description": "<h4>Service Account has admin privileges</h4><h4>Description</h4>A service account is a special Google account that belongs to an application or a VM, not to an individual end-user. The application uses the service account to call the service's Google API so that users are not directly involved.<br>Service accounts represent service-level security of application or VM Resources, determined by the roles assigned to them. Enrolling ServiceAccount with Admin rights gives full access to an assigned application or a VM. A ServiceAccount Access holder can perform critical actions, such as delete and update change settings, without user intervention.<br>We recommend you do not grant Admin privileges for ServiceAccount.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to IAM Admin.<br>Navigate to Members.<br>Identify User-Managed user created service account with roles containing *Admin<br>or *admin or roles matching Editor or Owner.<br>Click the Trash icon to remove the role from the member. In this case service account.<br><br>CLI Command<br><br>Using a text editor, remove Role that contains roles/*Admin or roles/*admin or matches roles/editor or roles/owner. Add a role to the bindings array that defines the group members and the role for those members.<br>Update the project's IAM policy:<br>gcloud projects set-iam-policy PROJECT_ID iam.json<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_project_iam_member<br>Argument: role + member<br><br>Goresource \"google_project_iam_member\" \"project\" {<br>project = \"your-project-id\"<br>-  role    = \"roles/owner\"<br>-  member  = \"user:[email\u00a0protected]\"<br>}<br>"
    },
    "CKV_GCP_26": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_logging_1",
        "severity": "MEDIUM",
        "description": "<h4>GCP VPC flow logs for the subnet is set to Off</h4><h4>Description</h4>Flow Logs capture information about IP traffic going to and from network interfaces. This information can be used to detect anomalous traffic and insight about security workflows. You can view and retrieve flow log data in Stackdriver Logging.<br>VPC networks and subnetworks provide logically isolated and secure network partitions to launch Google Cloud Platform (GCP) resources. When Flow Logs are enabled for a subnet, VMs within that subnet report on all Transmission Control Protocol (TCP) and User Datagram Protocol (UDP) flows. Each VM samples the inbound and outbound TCP and UDP flows it sees, whether the flow is to or from another VM, a host in the on-premises datacenter, a Google service, or a host on the Internet. If two GCP VMs are communicating and both are in subnets that have VPC Flow Logs enabled, both VMs report the flows.<br>We recommended you set Flow Logs to On to capture this data. Because the volume of logs may be high, you may wish to enable flow logs only for business-critical VPC Network Subnets.<br>Flow Logs supports the following use cases:<br><br>Network monitoring<br>Understanding network usage and optimizing network traffic expenses<br>Network forensics<br>Real-time security analysis<br><br><h4>Fix - Runtime</h4>GCP Console<br><br>Open the VPC network GCP Console https://console.cloud.google.com/networking/networks/list.<br>Click the name of a subnet to display the Subnet details page.<br>Click the EDIT button.<br>Set Flow Logs to On.<br>Click Save.<br><br>CLI Command<br>To set Private Google access for a network subnet, run the following command:<br>gcloud compute networks subnets update [SUBNET_NAME]<br>--region [REGION]<br>--enable-flow-logs<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_compute_subnetwork<br>Argument: log_config<br><br>Goresource \"google_compute_subnetwork\" \"example\" {<br>name          = \"log-test-subnetwork\"<br>ip_cidr_range = \"10.2.0.0/16\"<br>region        = \"us-central1\"<br>network       = google_compute_network.custom-test.id<br><br>+ log_config {<br>aggregation_interval = \"INTERVAL_10_MIN\"<br>flow_sampling        = 0.5<br>metadata             = \"INCLUDE_ALL_METADATA\"<br>}<br>}<br>"
    },
    "CKV_GCP_60": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_sql_11",
        "severity": "LOW",
        "description": "<h4>Cloud SQL database instances have public IPs</h4><h4>Description</h4>To lower the organization's attack surface, Cloud SQL databases should not have public IPs. Private IPs provide improved network security and lower latency for your application.<br>We recommend you configure Second Generation SQL instances to use private IPs instead of public IPs.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Cloud SQL Instances.<br>Click the instance name to open its Instance details page.<br>Select Connections.<br>Clear the Public IP checkbox.<br>To update the instance, click Save.<br><br>CLI Command<br><br>For every instance remove its public IP and assign a private IP instead:<br>gcloud beta sql instances patch INSTANCE_NAME --network=VPC_NETWOR_NAME --no- assign-ip<br>Confirm the changes using the following command:<br>gcloud sql instances describe INSTANCE_NAME<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_sql_database_instance<br>Arguments:<br>databaseversion = \"SQLSERVER* \"<br>settings::ip_configuration: by default set to \"true\"<br><br>Goresource \"google_sql_database_instance\" \"default\" {<br>name             = \"master-instance\"<br>database_version = \"SQLSERVER_2017_STANDARD\"<br>region           = \"us-central1\"<br><br>settings {<br>+         ip_configuration{<br>+            ipv4_enabled    = \"false\"<br>}<br>}<br>}<br>"
    },
    "CKV_GCP_44": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_iam_5",
        "severity": "CRITICAL",
        "description": "<h4>Roles impersonate or manage Service Accounts used at folder level</h4><h4>Description</h4>The IAM role is an identity with specific permissions. An IAM role is similar to an IAM user: it has a Google identity with permission policies that determine what the identity can and cannot do in Google Cloud. Certain IAM roles contain permissions that enable a user with the role to impersonate or manage service accounts in a GCP folder through IAM inheritance from a higher resource, i.e., folder binding.<br>We recommend you do not set IAM role bindings with known dangerous roles that enable impersonation at the folder level.<br>The following roles enable identities to impersonate all service account identities within a project if the identity is granted the role at the project, folder, or organization level. The following list includes our current recommendations for dangerous roles, however, it is not exhaustive as permissions and roles change frequently.<br>Primitive Roles:<br><br>roles/owner<br>roles/editor<br><br>Predefined Roles:<br><br>roles/iam.securityAdmin<br>roles/iam.serviceAccountAdmin<br>roles/iam.serviceAccountKeyAdmin<br>roles/iam.serviceAccountUser<br>roles/iam.serviceAccountTokenCreator<br>roles/iam.workloadIdentityUser<br>roles/dataproc.editor<br>roles/dataproc.admin<br>roles/dataflow.developer<br>roles/resourcemanager.folderAdmin<br>roles/resourcemanager.folderIamAdmin<br>roles/resourcemanager.projectIamAdmin<br>roles/resourcemanager.organizationAdmin<br>roles/cloudasset.viewer<br>roles/cloudasset.owner<br><br>Service Agent Roles:<br>Service agent roles should not be used for any identities other than the Google managed service account they are associated with.<br><br>roles/serverless.serviceAgent<br>roles/dataproc.serviceAgent<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resources:<br>google_folder_iam_member<br>google_folder_iam_binding<br>Argument: role<br><br>google_folder_iam_membergoogle_folder_iam_bindingresource \"google_folder_iam_member\" \"example\" {<br>folder  = \"folders/1234567\"<br>- role    =  <ANY OF THE ROLES LISTED ABOVE><br>member  = \"user:[email\u00a0protected]\"<br>}<br>resource \"google_folder_iam_binding\" \"example\" {<br>folder  = \"folders/1234567\"<br>- role    =  <ANY OF THE ROLES LISTED ABOVE><br>members  = [<br>\"user:[email\u00a0protected]\",<br>]<br>}<br>"
    },
    "CKV_GCP_45": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_iam_6",
        "severity": "CRITICAL",
        "description": "<h4>Roles impersonate or manage Service Accounts used at organizational level</h4><h4>Description</h4>The IAM role is an identity with specific permissions. An IAM role is similar to an IAM user: it has a Google identity with permission policies that determine what the identity can and cannot do in Google Cloud. Certain IAM roles contain permissions that enable a user with the role to impersonate or manage service accounts in a GCP folder through IAM inheritance from a higher resource, i.e., folder binding.<br>We recommend you do not set IAM role bindings with known dangerous roles that enable impersonation at the organizational level.<br>The following roles enable identities to impersonate all service account identities within a project if the identity is granted the role at the project, folder, or organization level. The following list includes our current recommendations for dangerous roles, however, it is not exhaustive as permissions and roles change frequently.<br>Primitive Roles:<br><br>roles/owner<br>roles/editor<br><br>Predefined Roles:<br><br>roles/iam.securityAdmin<br>roles/iam.serviceAccountAdmin<br>roles/iam.serviceAccountKeyAdmin<br>roles/iam.serviceAccountUser<br>roles/iam.serviceAccountTokenCreator<br>roles/iam.workloadIdentityUser<br>roles/dataproc.editor<br>roles/dataproc.admin<br>roles/dataflow.developer<br>roles/resourcemanager.folderAdmin<br>roles/resourcemanager.folderIamAdmin<br>roles/resourcemanager.projectIamAdmin<br>roles/resourcemanager.organizationAdmin<br>roles/cloudasset.viewer<br>roles/cloudasset.owner<br><br>Service Agent Roles:<br>Service agent roles should not be used for any identities other than the Google managed service account they are associated with.<br><br>roles/serverless.serviceAgent<br>roles/dataproc.serviceAgent<br><br><h4>Fix - Buildtime</h4>Terraform<br>Resources:<br>google_organization_iam_member<br>google_organization_iam_binding<br>Argument: role<br>google_organization_iam_membergoogle_organization_iam_bindingresource \"google_organization_iam_member\" \"example\" {<br>org_id  = \"your-org-id\"<br>- role    =  <ANY OF THE ROLES LISTED ABOVE><br>member  = \"user:[email\u00a0protected]\"<br>}<br>resource \"google_project_iam_binding\" \"example\" {<br>org_id  = \"your-org-id\"<br>- role    =  <ANY OF THE ROLES LISTED ABOVE><br>members  = [<br>\"user:[email\u00a0protected]\",<br>]<br>}<br>"
    },
    "CKV_GCP_46": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_iam_7",
        "severity": "CRITICAL",
        "description": "<h4>Default Service Account is used at project level</h4><h4>Description</h4>A service account is a special Google account that belongs to an application or a VM, not to an individual end-user. The application uses the service account to call the service's Google API so that users are not directly involved. Service accounts represent service-level security of application or VM Resources, determined by the roles assigned to them. The use of Default service accounts should be avoided, see below for details.<br>We recommend you do not set IAM role bindings using the default Compute Engine and App Engine service account.<br>Default Compute Engine Service Account: Used by GKE, Compute, DataProc, DataFlow, Composer.<br>[email\u00a0protected]<br>Default Appspot Service Account: Used by App Engine, Cloud Functions, App Engine based services.<br>[email\u00a0protected]<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resources:<br>google_project_iam_member<br>google_project_iam_binding<br>Argument: member<br><br>google_project_iam_membergoogle_project_iam_bindingresource \"google_project_iam_member\" \"project\" {<br>project = \"project/1234567\"<br>role    = \"roles/owner\"<br>- member  = \"[email\u00a0protected]\"<br>- member  = \"[email\u00a0protected]\"<br>}<br>resource \"google_project_iam_member\" \"project\" {<br>project = \"project/1234567\"<br>role    = \"roles/owner\"<br>- members  = [<br>\"[email\u00a0protected]\",<br>\"[email\u00a0protected]\"<br>]<br>}<br>"
    },
    "CKV_GCP_47": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_iam_8",
        "severity": "CRITICAL",
        "description": "<h4>Default Service Account is used at organization level</h4><h4>Description</h4>A service account is a special Google account that belongs to an application or a VM, not to an individual end-user. The application uses the service account to call the service's Google API so that users are not directly involved. Service accounts represent service-level security of application or VM Resources, determined by the roles assigned to them. The use of Default service accounts should be avoided, see below for details.<br>We recommend you do not set IAM role bindings using the default Compute Engine and App Engine service account.<br>Default Compute Engine Service Account: Used by GKE, Compute, DataProc, DataFlow, Composer.<br>[email\u00a0protected]<br>Default Appspot Service Account: Used by App Engine, Cloud Functions, App Engine based services.<br>[email\u00a0protected]<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resources:<br>google_organization_iam_member<br>google_organization_iam_binding<br>Argument: member<br><br>google_organization_iam_membergoogle_organization_iam_bindingresource \"google_organization_iam_member\" \"organization\" {<br>org_id = \"your-org-id\"<br>role    = \"roles/owner\"<br>- member  = \"[email\u00a0protected]\"<br>- member  = \"[email\u00a0protected]\"<br>}<br>resource \"google_organization_iam_member\" \"organization\" {<br>org_id = \"your-org-id\"<br>role    = \"roles/owner\"<br>- members  = [<br>\"[email\u00a0protected]\",<br>\"[email\u00a0protected]\"<br>]<br>}<br>"
    },
    "CKV_GCP_48": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_iam_9",
        "severity": "CRITICAL",
        "description": "<h4>Default Service Account is used at folder level</h4><h4>Description</h4>A service account is a special Google account that belongs to an application or a VM, not to an individual end-user. The application uses the service account to call the service's Google API so that users are not directly involved. Service accounts represent service-level security of application or VM Resources, determined by the roles assigned to them. The use of Default service accounts should be avoided, see below for details.<br>We recommend you do not set IAM role bindings using the default Compute Engine and App Engine service account.<br>Default Compute Engine Service Account: Used by GKE, Compute, DataProc, DataFlow, Composer.<br>[email\u00a0protected]<br>Default Appspot Service Account: Used by App Engine, Cloud Functions, App Engine based services.<br>[email\u00a0protected]<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resources:<br>google_folder_iam_member<br>google_folder_iam_binding<br>Argument: role + member<br><br>google_folder_iam_membergoogle_folder_iam_bindingresource \"google_folder_iam_member\" \"folder\" {<br>folder = \"folders/1234567\"<br>role    = \"roles/owner\"<br>- member  = \"[email\u00a0protected]\"<br>- member  = \"[email\u00a0protected]\"<br>}<br>resource \"google_folder_iam_member\" \"folder\" {<br>folder = \"folders/1234567\"<br>role    = \"roles/owner\"<br>- members  = [<br>\"[email\u00a0protected]\",<br>\"[email\u00a0protected]\"<br>]<br>}<br>"
    },
    "CKV_GCP_49": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_iam_10",
        "severity": "MEDIUM",
        "description": "<h4>Roles impersonate or manage Service Accounts used at project level</h4><h4>Description</h4>The IAM role is an identity with specific permissions. An IAM role is similar to an IAM user: it has a Google identity with permission policies that determine what the identity can and cannot do in Google Cloud. Certain IAM roles contain permissions that enable a user with the role to impersonate or manage service accounts in a GCP project through IAM inheritance from a higher resource, i.e., project binding.<br>We recommend you do not set IAM role bindings with known dangerous roles that enable impersonation at the project level.<br>The following roles enable identities to impersonate all service account identities within a project if the identity is granted the role at the project, folder, or organization level. The following list includes our current recommendations for dangerous roles, however, it is not exhaustive as permissions and roles change frequently.<br>Primitive Roles:<br><br>roles/owner<br>roles/editor<br><br>Predefined Roles:<br><br>roles/iam.securityAdmin<br>roles/iam.serviceAccountAdmin<br>roles/iam.serviceAccountKeyAdmin<br>roles/iam.serviceAccountUser<br>roles/iam.serviceAccountTokenCreator<br>roles/iam.workloadIdentityUser<br>roles/dataproc.editor<br>roles/dataproc.admin<br>roles/dataflow.developer<br>roles/resourcemanager.folderAdmin<br>roles/resourcemanager.folderIamAdmin<br>roles/resourcemanager.projectIamAdmin<br>roles/resourcemanager.organizationAdmin<br>roles/cloudasset.viewer<br>roles/cloudasset.owner<br><br>Service Agent Roles: Service agent roles should not be used for any identities other than the Google managed service account they are associated with.<br><br>roles/serverless.serviceAgent<br>roles/dataproc.serviceAgent<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resources:<br>google_project_iam_member<br>google_project_iam_binding<br>Argument: role<br><br>google_project_iam_membergoogle_project_iam_bindingresource \"google_project_iam_member\" \"example\" {<br>project  = \"project/1234567\"<br>- role    =  <ANY OF THE ROLES LISTED ABOVE><br>member  = \"user:[email\u00a0protected]\"<br>}<br>resource \"google_project_iam_binding\" \"example\" {<br>project  = \"project/1234567\"<br>- role    =  <ANY OF THE ROLES LISTED ABOVE><br>members  = [<br>\"user:[email\u00a0protected]\",<br>]<br>}<br>"
    },
    "CKV_GCP_50": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_sql_1",
        "severity": "LOW",
        "description": "<h4>GCP MySQL instance with local_infile database flag is not disabled</h4><h4>Description</h4>The local_infile database flag controls the server-side LOCAL capability for LOAD DATA statements. Depending on the local_infile setting, the server refuses or permits local data loading by clients that have LOCAL enabled on the client side.<br>To explicitly cause the server to refuse LOAD DATA LOCAL statements start mysqld with local_infile disabled, regardless of how client programs and libraries are configured at build time or runtime. local_infile can also be set at runtime.<br>We recommended you set the local_infile database flag for a Cloud SQL MySQL instance to off to address the security issues associated with the flag.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Cloud SQL Instances.<br>Select the MySQL instance where the database flag needs to be enabled.<br>Click Edit.<br>Scroll down to the Flags section.<br>To set a flag that has not been set on the instance before, click Add item.<br>Select the flag local_infile from the drop-down menu, and set its value to off.<br>Click Save.<br>Confirm the changes in the Flags section on the Overview page.<br><br>CLI Command<br><br>List all Cloud SQL database instances using the following command:<br>gcloud sql instances list<br>Configure the local_infile database flag for every Cloud SQL Mysql database instance using the below command:<br>gcloud sql instances patch INSTANCE_NAME --database-flags local_infile=off<br><br>\ud83d\udcd8NoteThis command will overwrite all database flags previously set. To keep those flags, and add new ones, include the values for all flags to be set on the instance. Any flag not specifically included is set to its default value. For flags that do not take a value, specify the flag name followed by an equals sign (=).<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_sql_database_instance<br>Arguments:<br>databaseversion = \"MYSQL* \"<br>settings::database_flags: key:\"local_infile\", value:  by default set to \"on\"<br><br>Goresource \"google_sql_database_instance\" \"default\" {<br>name             = \"master-instance\"<br>database_version = \"MYSQL_8_0\"<br>region           = \"us-central1\"<br><br>settings {<br>+         database_flags {<br>+            name  = \"local_infile\"<br>+            value = \"off\"<br>}<br>}<br>}<br>"
    },
    "CKV_GCP_51": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_sql_2",
        "severity": "LOW",
        "description": "<h4>Cloud SQL PostgreSQL instances have log_checkpoints database flag set to Off</h4><h4>Description</h4>Enabling log_checkpoints causes checkpoints and restart points to be logged in the server log. Some statistics are included in the log messages, including the number of buffers written, and the time spent writing them. This parameter can only be set in the postgresql.conf file or on the server command line.<br>We recommended you set the log_checkpoints database flag for the Cloud SQL PostgreSQL instance to on.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Cloud SQL Instances.<br>Select the PostgreSQL instance where the database flag needs to be enabled.<br>Click Edit.<br>Scroll down to the Flags section.<br>To set a flag that has not been set on the instance before, click Add item.<br>Select the flag log_checkpoints from the drop-down menu, and set its value to On.<br>Click Save.<br>Confirm the changes in the Flags section on the Overview page.<br><br>CLI Command<br><br>List all Cloud SQL database instances using the following command:<br>gcloud sql instances list<br>Configure the log_checkpoints database flag for every Cloud SQL PosgreSQL database instance using the below command:<br>gcloud sql instances patch INSTANCE_NAME --database-flags log_checkpoints=on<br><br>\ud83d\udcd8NoteThis command will overwrite all previously set database flags. To keep those flags, and add new ones, include the values for all flags to be set on the instance. Any flag not specifically included is set to its default value. For flags that do not take a value, specify the flag name followed by an equals sign (=).<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_sql_database_instance<br>Arguments:<br>databaseversion = \"POSTGRES* \"<br>settings::database_flags: key:\"log_checkpoints\", value:  by default set to \"off\"<br><br>Goresource \"google_sql_database_instance\" \"default\" {<br>name             = \"master-instance\"<br>database_version = \"POSTGRES_11\"<br>region           = \"us-central1\"<br><br>settings {<br>+         database_flags {<br>+            name  = \"log_checkpoints\"<br>+            value = \"on\"<br>}<br>}<br>}<br>"
    },
    "CKV_GCP_52": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_sql_3",
        "severity": "LOW",
        "description": "<h4>GCP PostgreSQL instance database flag log_connections is disabled</h4><h4>Description</h4>PostgreSQL does not log attempted connections by default. Enabling the log_connections setting creates log entries for each attempted connection to the server, along with successful completion of client authentication.  This information can be useful in troubleshooting issues and to determine any unusual connection attempts to the server.<br>We recommend you set the log_connections database flag for Cloud SQL PostgreSQL instances to on.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Cloud SQL Instances.<br>Select the PostgreSQL instance for which you want to enable the database flag.<br>Click Edit.<br>Scroll down to the Flags section.<br>To set a flag that has not been set on the instance before, click Add item.<br>Select the flag log_connections from the drop-down menu, and set the value to on.<br>Click Save.<br>Confirm the changes in the Flags section on the Overview page.<br><br>CLI Command<br><br>List all Cloud SQL database instances using the following command:<br>gcloud sql instances list<br>Configure the log_connections database flag for every Cloud SQL PosgreSQL database instance using the following command:<br>gcloud sql instances patch INSTANCE_NAME --database-flags log_connections=on<br><br>\ud83d\udcd8NoteThis command will overwrite all previously set database flags. To keep those and add new ones, include the values for all flags to be set on the instance; any flag not specifically included is set to its default value. For flags that do not take a value, specify the flag name followed by an equals sign (\"=\").se flags. To keep those and add new ones, include the values for all flags to be set on the instance. Any flag not specifically included is set to its default value. For flags that do not take a value, specify the flag name followed by an equals sign (=).<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_sql_database_instance<br>Arguments:<br>databaseversion = \"POSTGRES* \"<br>settings::database_flags: key:\"log_connections\", value:  by default set to \"off\"<br><br>Goresource \"google_sql_database_instance\" \"default\" {<br>name             = \"master-instance\"<br>database_version = \"POSTGRES_11\"<br>region           = \"us-central1\"<br><br>settings {<br>+         database_flags {<br>+            name  = \"log_connections\"<br>+            value = \"on\"<br>}<br>}<br>}<br>"
    },
    "CKV_GCP_53": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_sql_4",
        "severity": "LOW",
        "description": "<h4>GCP PostgreSQL instance database flag log_disconnections is disabled</h4><h4>Description</h4>Enabling the log_disconnections database flag logs the end of each session, including the session duration. PostgreSQL does not log session details by default, including duration and session end details. Enabling the log_disconnections database flag creates log entries at the end of each session, useful when troubleshooting issues and determining unusual activity across a time period.<br>The log_disconnections and log_connections work hand in hand and usually the pair would be enabled/disabled together.<br>We recommended you set the log_disconnections flag for a PostgreSQL instance to On.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Cloud SQL Instances.<br>Select the PostgreSQL instance where the database flag needs to be enabled.<br>Click Edit.<br>Scroll down to the Flags section.<br>To set a flag that has not been set on the instance before, click Add item.<br>Select the flag log_disconnections from the drop-down menu, and set its value to On.<br>Click Save.<br>Confirm the changes in the Flags section on the Overview page.<br><br>CLI Command<br><br>List all Cloud SQL database Instances using the following command:<br>gcloud sql instances list<br>Configure the log_disconnections database flag for every Cloud SQL PosgreSQL database instance using the below command:<br>gcloud sql instances patch INSTANCE_NAME --database-flags log_disconnections=on<br><br>\ud83d\udcd8NoteThis command will overwrite all previously set database flags. To keep those flags, and add new ones, include the values for all flags to be set on the instance. Any flag not specifically included is set to its default value. For flags that do not take a value, specify the flag name followed by an equals sign (=).<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_sql_database_instance<br>Arguments:<br>databaseversion = \"POSTGRES* \"<br>settings::database_flags: key:\"log_disconnections\", value:  by default set to \"off\"<br><br>Goresource \"google_sql_database_instance\" \"default\" {<br>name             = \"master-instance\"<br>database_version = \"POSTGRES_11\"<br>region           = \"us-central1\"<br><br>settings {<br>+         database_flags {<br>+            name  = \"log_disconnections\"<br>+            value = \"on\"<br>}<br>}<br>}<br>"
    },
    "CKV_GCP_54": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_sql_5",
        "severity": "LOW",
        "description": "<h4>GCP PostgreSQL instance database flag log_lock_waits is disabled</h4><h4>Description</h4>Deadlock timeout defines the time to wait on a lock before checking for any conditions. Frequent runovers on deadlock timeout can be an indication of an underlying issue. Log these waits on locks using the log_lock_waits database flag and use the information to identify poor performance due to locking delays, or if a specially-crafted SQL is attempting to starve resources through holding locks for excessive amounts of time.<br>We recommended you set the log_lock_waits flag for a PostgreSQL instance to On.  This will create a log for any session and allow you to identify waits that take longer than the allotted deadlock_timeout time to acquire a lock.<br><h4>Fix - Runtime Remediation</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Cloud SQL Instances.<br>Select the PostgreSQL instance where the database flag needs to be enabled.<br>Click Edit.<br>Scroll down to the Flags section.<br>To set a flag that has not been set on the instance before, click Add item.<br>Select the flag log_lock_waits from the drop-down menu, and set its value to On.<br>Click Save.<br>Confirm the changes in the Flags section on the Overview page.<br><br>CLI Command<br><br>List all Cloud SQL database instances using the following command:<br>gcloud sql instances list<br>Configure the log_lock_waits database flag for every Cloud SQL PosgreSQL database instance using the below command:<br>gcloud sql instances patch INSTANCE_NAME --database-flags log_lock_waits=on<br><br>\ud83d\udcd8NoteThis command will overwrite all database flags previously set. To keep these flags, and add new ones, include the values for all flags to be set on the instance. Any flag not specifically included is set to its default value. For flags that do not take a value, specify the flag name followed by an equals sign (=).<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_sql_database_instance<br>Arguments:<br>databaseversion = \"POSTGRES* \"<br>settings::database_flags: key:\"log_lock_waits\", value:  by default set to \"off\"<br><br>Goresource \"google_sql_database_instance\" \"default\" {<br>name             = \"master-instance\"<br>database_version = \"POSTGRES_11\"<br>region           = \"us-central1\"<br><br>settings {<br>+         database_flags {<br>+            name  = \"log_lock_waits\"<br>+            value = \"on\"<br>}<br>}<br>}<br>"
    },
    "CKV_GCP_55": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_sql_6",
        "severity": "LOW",
        "description": "<h4>GCP PostgreSQL instance database flag log_min_messages is not set</h4><h4>Description</h4>The log_min_error_statement database flag defines the minimum message severity level that is considered to be an error statement. Messages for error statements are logged with the SQL statement. Valid values include: DEBUG5, DEBUG4, DEBUG3, DEBUG2, DEBUG1, INFO, NOTICE, WARNING, ERROR, LOG, FATAL, and PANIC. Each severity level includes subsequent levels.<br>Deadlock timeout defines the time to wait on a lock before checking for any conditions. Frequent runovers on deadlock timeout can be an indication of an underlying issue. Log these waits on locks using the log_lock_waits database flag and use the information to identify poor performance due to locking delays, or if a specially-crafted SQL is attempting to starve resources through holding locks for excessive amounts of time.<br>We recommend you set the log_min_error_statement flag for PostgreSQL database instances in accordance with your organization's logging policy for auditing purposes. Auditing helps you troubleshoot operational problems, and also permits forensic analysis. If log_min_error_statement is not set to the correct value, messages may not be classified as error messages appropriately. Considering general log messages as error messages would make it difficult to find actual errors, while considering only stricter severity levels as error messages may skip actual errors to log their SQL statements.<br>\ud83d\udcd8NoteTo effectively turn off logging failing statements, set this parameter to PANIC.<br>ERROR is considered the best practice setting.<br>Changes should only be made in accordance with the organization's logging policy.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Cloud SQL Instances.<br>Select the PostgreSQL instance where the database flag needs to be enabled.<br>Click Edit.<br>Scroll down to the Flags section.<br>To set a flag that has not been set on the instance before, click Add item.<br>Select the flag log_min_error_statement from the drop-down menu, and set an appropriate value.<br>Click Save.<br>Confirm the changes in the Flags section on the Overview page.<br><br>CLI Command<br><br>List all Cloud SQL database Instances using the following command:<br>gcloud sql instances list<br>Configure the log_min_error_statement database flag for every Cloud SQL PosgreSQL database instance using the below command.<br>gcloud sql instances patch INSTANCE_NAME --database-flags log_min_error_statement=<DEBUG5|DEBUG4|DEBUG3|DEBUG2|DEBUG1|INFO|NOTICE|WARNI NG|ERROR|LOG|FATAL|PANIC><br><br>\ud83d\udcd8NoteThis command will overwrite all database flags previously set. To keep those and add new ones, include the values for all flags to be set on the instance; any flag not specifically included is set to its default value. For flags that do not take a value, specify the flag name followed by an equals sign (=).<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_sql_database_instance<br>Arguments:<br>databaseversion = \"POSTGRES* \"<br>settings::database_flags: key:\"log_min_messages\", value:  by default set to \"ERROR\"<br>Argument value can be one of the following: DEBUG5, DEBUG4, DEBUG3, DEBUG2, DEBUG1, INFO, NOTICE, WARNING, ERROR, LOG, FATAL, and PANIC<br><br>Goresource \"google_sql_database_instance\" \"default\" {<br>name             = \"master-instance\"<br>database_version = \"POSTGRES_11\"<br>region           = \"us-central1\"<br><br>settings {<br>+         database_flags {<br>+            name  = \"log_min_messages\"<br>+            value = \"DEBUG5\"<br>}<br>}<br>}<br>"
    },
    "CKV_GCP_56": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_sql_7",
        "severity": "LOW",
        "description": "<h4>GCP PostgreSQL instance database flag log_temp_files is not set to 0</h4><h4>Description</h4>PostgreSQL can create a temporary file for actions such as sorting, hashing and temporary query results when these operations exceed work_mem. The log_temp_files flag controls logging names and the file size when it is deleted. Configuring log_temp_files to zero (0) causes all temporary file information to be logged, while positive values log only files whose size are greater than or equal to the specified number of kilobytes. A value of -1 disables temporary file information logging.<br>We recommend you set the log_temp_files database flag for Cloud SQL PostgreSQL instances is set to zero (0). If temporary files are not logged, it may be difficult to identify potential performance issues caused by either poor application coding, or deliberate resource starvation attempts.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Cloud SQL Instances.<br>Select the PostgreSQL instance where the database flag needs to be enabled.<br>Click Edit.<br>Scroll down to the Flags section.<br>To set a flag that has not been set on the instance before, click Add item.<br>Select the flag log_temp_files from the drop-down menu, and set its value to 0.<br>Click Save.<br>Confirm the changes in the Flags section on the Overview page.<br><br>CLI Command<br><br>List all Cloud SQL database instances using the following command:<br>gcloud sql instances list<br>Configure the log_temp_files database flag for every Cloud SQL PosgreSQL database instance using the below command.<br>gcloud sql instances patch INSTANCE_NAME --database-flags log_temp_files=0``<br>Note: This command will overwrite all database flags previously set. To keep those and add new ones, include the values for all flags to be set on the instance; any flag not specifically included is set to its default value. For flags that do not take a value, specify the flag name followed by an equals sign (\"=\").<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_sql_database_instance<br>Arguments:<br>databaseversion = \"POSTGRES* \"<br>settings::database_flags: key:\"log_temp_files\", value:  by default set to \"-1\"<br><br>Goresource \"google_sql_database_instance\" \"default\" {<br>name             = \"master-instance\"<br>database_version = \"POSTGRES_11\"<br>region           = \"us-central1\"<br><br>settings {<br>+         database_flags {<br>+            name  = \"log_temp_files\"<br>+            value = \"0\"<br>}<br>}<br>}<br>"
    },
    "CKV_GCP_57": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_sql_8",
        "severity": "LOW",
        "description": "<h4>GCP PostgreSQL instance database flag log_min_duration_statement is not set to -1</h4><h4>Description</h4>Logging SQL statements may include sensitive information that should not be recorded in logs. This recommendation is applicable to PostgreSQL database instances. The log_min_duration_statement database flag defines the minimum amount of execution time in milliseconds of a statement where the total duration of the statement is logged.<br>We recommend you ensure the log_min_duration_statement database flag for Cloud SQL PostgreSQL instances is disabled. To achieve this, set the value to -1.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Cloud SQL Instances.<br>Select the PostgreSQL instance where the database flag needs to be enabled.<br>Click Edit.<br>Scroll down to the Flags section.<br>To set a flag that has not been set on the instance before, click Add item.<br>Select the flag og_min_duration_statement from the drop-down menu, and set its value to -1.<br>Click Save.<br>Confirm the changes in the Flags section on the Overview page.<br><br>CLI Command<br><br>List all Cloud SQL database instances using the following command:<br>gcloud sql instances list<br>Configure the log_min_duration_statement flag for every Cloud SQL PosgreSQL database instance using the below command:<br>gcloud sql instances patch INSTANCE_NAME --database-flags log_min_duration_statement=-1<br><br>\ud83d\udcd8NoteThis command will overwrite all database flags previously set. To keep those and add new ones, include the values for all flags to be set on the instance; any flag not specifically included is set to its default value. For flags that do not take a value, specify the flag name followed by an equals sign (=).<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_sql_database_instance<br>Arguments:<br>databaseversion = \"POSTGRES* \"<br>settings::database_flags: key:\"log_min_duration_statement\", value:  by default set to -1<br><br>Goresource \"google_sql_database_instance\" \"default\" {<br>name             = \"master-instance\"<br>database_version = \"POSTGRES_11\"<br>region           = \"us-central1\"<br><br>settings {<br>+         database_flags {<br>+            name  = \"log_min_duration_statement\"<br>+            value = \"-1\"<br>}<br>}<br>}<br>"
    },
    "CKV_GCP_58": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_sql_9",
        "severity": "MEDIUM",
        "description": "<h4>Cloud SQL SQL server instance database flag cross db ownership chaining is set to On</h4><h4>Description</h4>Use the cross db ownership chaining database flag to configure cross-database ownership chaining for an instance of Microsoft SQL Server. This server option allows you to control cross-database ownership chaining at database-level, or to allow cross-database ownership chaining for all databases.<br>We recommend you disable the cross db ownership chaining flag for Cloud SQL SQL Server instances, by setting it to Off. Enabling cross db ownership chaining is only effective when all of the databases hosted by the instance of SQL Server participate in cross-database ownership chaining, and you are aware of the security implications of this setting.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Cloud SQL Instances.<br>Select the PostgreSQL instance where the database flag needs to be enabled.<br>Click Edit.<br>Scroll down to the Flags section.<br>To set a flag that has not been set on the instance before, click Add item.<br>Select the flag cross db ownership chaining from the drop-down menu, and set its value to Off.<br>Click Save.<br>Confirm the changes in the Flags section on the Overview page.<br><br>CLI Command<br><br>List all Cloud SQL database instances using the following command:<br>gcloud sql instances list<br>Configure the cross db ownership chaining database flag for every Cloud SQL SQL Server database instance using the below command:<br><br>gcloud sql instances patch INSTANCE_NAME<br>--database-flags \"cross db ownership chaining=off\"<br><br>\ud83d\udcd8NoteThis command will overwrite all database flags previously set. To keep those flags, and add new ones, include the values for all flags to be set on the instance. Any flag not specifically included is set to its default value. For flags that do not take a value, specify the flag name followed by an equals sign (=).<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_sql_database_instance<br>Arguments:<br>databaseversion = \"SQLSERVER* \"<br>settings::database_flags: key:\"cross db ownership chaining\", value:  by default set to \"on\"<br><br>Goresource \"google_sql_database_instance\" \"default\" {<br>name             = \"master-instance\"<br>database_version = \"SQLSERVER_2017_STANDARD\"<br>region           = \"us-central1\"<br><br>settings {<br>+         database_flags {<br>+            name  = \"cross db ownership chaining\"\"<br>+            value = \"off\"<br>}<br>}<br>}<br>"
    },
    "CKV_GCP_59": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_sql_10",
        "severity": "MEDIUM",
        "description": "<h4>Cloud SQL SQL server instance contained database authentication database flag is set to On</h4><h4>Description</h4>A contained database includes all database settings and metadata required to define the database. It has no configuration dependencies on the instance of the Database Engine where the database is installed. Users can connect to the database without authenticating a login at the Database Engine level. Isolating the database from the Database Engine makes it possible to easily move the database to another instance of SQL Server. Contained databases have some unique threats that should be understood and mitigated by SQL Server Database Engine administrators. Most of the threats are related to the USER WITH PASSWORD authentication process, which moves the authentication boundary from the Database Engine level to the database level,<br>We recommend you ensure the contained database authentication database flag for SQL Server database instances is disabled. To achieve this, set the value to Off.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Cloud SQL Instances.<br>Select the PostgreSQL instance where the database flag needs to be enabled.<br>Click Edit.<br>Scroll down to the Flags section.<br>To set a flag that has not been set on the instance before, click Add item.<br>Select the flag contained database authentication from the drop-down menu, and set its value to Off.<br>Click Save.<br>Confirm the changes in the Flags section on the Overview page.<br><br>CLI Command<br><br>List all Cloud SQL database Instances using the following command:<br>gcloud sql instances list<br>Configure the contained database authentication database flag for every Cloud SQL SQL Server database instance using the below command:<br><br>gcloud sql instances patch INSTANCE_NAME<br>--database-flags \"contained database authentication=off\"<br><br>\ud83d\udcd8NoteThis command will overwrite all database flags previously set. To keep these flags, and add new ones, include the values for all flags to be set on the instance. Any flag not specifically included is set to its default value. For flags that do not take a value, specify the flag name followed by an equals sign (=).<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_sql_database_instance<br>Arguments:<br>databaseversion = \"SQLSERVER* \"<br>settings::database_flags: key:\"contained database authentication\", value:  by default set to \"on\"<br><br>Goresource \"google_sql_database_instance\" \"default\" {<br>name             = \"master-instance\"<br>database_version = \"SQLSERVER_2017_STANDARD\"<br>region           = \"us-central1\"<br><br>settings {<br>+         database_flags {<br>+            name  = \"cross db ownership chaining\"\"<br>+            value = \"off\"<br>}<br>}<br>}<br>"
    },
    "CKV_GCP_62": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_logging_2",
        "severity": "MEDIUM",
        "description": "<h4>Bucket does not log access</h4><h4>Description</h4>Some resources  require a record of who access them and when.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_storage_bucket<br>Argument: logging/log_bucket to specify a Bucket to store access log in.<br><br>Goresource \"google_storage_bucket\" \"logging\" {<br>name     = \"jgwloggingbucket\"<br>location = var.location<br>uniform_bucket_level_access = true<br>+  logging {<br>+    log_bucket = \"mylovelybucket\"<br>+  }<br>}<br>"
    },
    "CKV_GCP_61": {
        "url": "https://docs.bridgecrew.io/docs/enable-vpc-flow-logs-and-intranode-visibility",
        "severity": "MEDIUM",
        "description": "<h4>VPC flow logs and intranode visibility are disabled</h4><h4>Description</h4>Enable VPC Flow Logs and Intranode Visibility to see pod-level traffic, even for traffic within a worker node. With this feature, you can use VPC Flow Logs or other VPC features for intranode traffic.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_container_cluster<br>Argument: enable_intranode_visibility<br><br>Goresource \"google_container_cluster\" \"example\" {<br>name               = var.name<br>location           = var.location<br>project            = data.google_project.project.name<br>+ enable_intranode_visibility = true<br>"
    },
    "CKV_GCP_66": {
        "url": "https://docs.bridgecrew.io/docs/ensure-use-of-binary-authorization",
        "severity": "MEDIUM",
        "description": "<h4>Binary authorization is not used</h4><h4>Description</h4>Binary Authorization helps to protect supply-chain security by only allowing images with verifiable cryptographically signed metadata into the cluster.<br>Binary Authorization provides software supply-chain security for images that you deploy to GKE from Google Container Registry (GCR) or another container image registry.<br>Binary Authorization requires images to be signed by trusted authorities during the development process. These signatures are then validated at deployment time. By enforcing validation, you can gain tighter control over your container environment by ensuring only verified images are integrated into the build-and-release process.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_container_cluster<br>Argument: enable_binary_authorization<br><br>Goresource \"google_container_cluster\" \"success\" {<br>name               = var.name<br>location           = var.location<br>initial_node_count = 1<br>project            = data.google_project.project.name<br>+ enable_binary_authorization = true<br>"
    },
    "CKV_GCP_68": {
        "url": "https://docs.bridgecrew.io/docs/ensure-secure-boot-for-shielded-gke-nodes-is-enabled",
        "severity": "MEDIUM",
        "description": "<h4>Secure boot for shielded GKE nodes is disabled</h4><h4>Description</h4>Enable Secure Boot for Shielded GKE Nodes to verify the digital signature of node boot components.<br>An attacker may seek to alter boot components to persist malware or root kits during system initialization. Secure Boot helps ensure that the system only runs authentic software by verifying the digital signature of all boot components, and halting the boot process if signature verification fails.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_container_cluster / google_container_node_pool<br>Argument: node_config.shielded_instance_config.enable_secure_boot<br><br>Goresource \"google_container_cluster\" \"success\" {<br>name               = var.name<br><br>...<br>node_config {<br>workload_metadata_config {<br>node_metadata = \"GKE_METADATA_SERVER\"<br>}<br>shielded_instance_config {<br>-     enable_secure_boot = false<br>}<br>}<br>"
    },
    "CKV_GCP_64": {
        "url": "https://docs.bridgecrew.io/docs/ensure-clusters-are-created-with-private-nodes",
        "severity": "MEDIUM",
        "description": "<h4>GCP Kubernetes Engine Clusters not configured with private nodes feature</h4><h4>Description</h4>Disable public IP addresses for cluster nodes, so that they only have private IP addresses. Private Nodes are nodes with no public IP addresses.<br>Disabling public IP addresses on cluster nodes restricts access to only internal networks, forcing attackers to obtain local network access before attempting to compromise the underlying Kubernetes hosts.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_container_cluster<br>Argument: private_cluster_config<br><br>Goresource \"google_container_cluster\" \"example\" {<br>name               = var.name<br>location           = var.location<br>project            = data.google_project.project.name<br><br>+ private_cluster_config {<br>+   enable_private_nodes    = var.private_cluster_config[\"enable_private_nodes\"]<br>+   enable_private_endpoint = var.private_cluster_config[\"enable_private_endpoint\"]<br>+   master_ipv4_cidr_block  = var.private_cluster_config[\"master_ipv4_cidr_block\"]<br>+ }<br>"
    },
    "CKV_GCP_65": {
        "url": "https://docs.bridgecrew.io/docs/manage-kubernetes-rbac-users-with-google-groups-for-gke",
        "severity": "LOW",
        "description": "<h4>Kubernetes RBAC users are not managed with Google Groups for GKE</h4><h4>Description</h4>Cluster Administrators should leverage G Suite Groups and Cloud IAM to assign Kubernetes user roles to a collection of users, instead of to individual emails using only Cloud IAM.<br>On- and off-boarding users is often difficult to automate and prone to error. Using a single source of truth for user permissions via G Suite Groups reduces the number of locations that an individual must be off-boarded from, and prevents users gaining unique permissions sets that increase the cost of audit.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_container_cluster<br>Argument: authenticator_groups_config.security_group<br><br>Goresource \"google_container_cluster\" \"example\" {<br>name               = var.name<br>location           = var.location<br>project            = data.google_project.project.name<br><br>+ authenticator_groups_config{<br>+   security_group=\"[email\u00a0protected]\"<br>+ }<br>"
    },
    "CKV_GCP_67": {
        "url": "https://docs.bridgecrew.io/docs/ensure-legacy-compute-engine-instance-metadata-apis-are-disabled",
        "severity": "MEDIUM",
        "description": "<h4>GCP Kubernetes engine clusters have legacy compute engine metadata endpoints enabled</h4><h4>Description</h4>Disable the legacy GCE instance metadata APIs for GKE nodes. Under some circumstances, these can be used from within a pod to extract the node's credentials.<br>The legacy GCE metadata endpoint allows simple HTTP requests to be made returning sensitive information. To prevent the enumeration of metadata endpoints and data exfiltration, the legacy metadata endpoint must be disabled.<br>Without requiring a custom HTTP header when accessing the legacy GCE metadata endpoint, a flaw in an application that allows an attacker to trick the code into retrieving the contents of an attacker-specified web URL could provide a simple method for enumeration and potential credential exfiltration. By requiring a custom HTTP header, the attacker needs to exploit an application flaw that allows them to control the URL and also add custom headers in order to carry out this attack successfully.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_container_cluster<br>Argument: min_master_version<br><br>Goresource \"google_container_cluster\" \"example\" {<br>name               = var.name<br>location           = var.location<br>initial_node_count = 1<br>project            = data.google_project.project.name<br><br>+ min_master_version = 1.12 // (or higher)<br>}<br>"
    },
    "CKV_GCP_69": {
        "url": "https://docs.bridgecrew.io/docs/ensure-the-gke-metadata-server-is-enabled",
        "severity": "LOW",
        "description": "<h4>The GKE metadata server is disabled</h4><h4>Description</h4>Running the GKE Metadata Server prevents workloads from accessing sensitive instance metadata and facilitates Workload Identity.<br>Every node stores its metadata on a metadata server. Some of this metadata, such as kubelet credentials and the VM instance identity token, is sensitive and should not be exposed to a Kubernetes workload. Enabling the GKE Metadata server prevents pods (that are not running on the host network) from accessing this metadata and facilitates Workload Identity.<br>When unspecified, the default setting allows running pods to have full access to the node's underlying metadata server.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_container_cluster / google_container_node_pool<br>Argument: node_config.workload_metadata_config.node_metadata<br><br>Goresource \"google_container_cluster\" \"example\" {<br>name               = var.name<br>location           = var.location<br>initial_node_count = 1<br>project            = data.google_project.project.name<br><br>+ node_config {<br>+   workload_metadata_config {<br>+     node_metadata = \"GKE_METADATA_SERVER\"<br>+   }<br>+ }<br><br>}<br>"
    },
    "CKV_GCP_71": {
        "url": "https://docs.bridgecrew.io/docs/ensure-shielded-gke-nodes-are-enabled",
        "severity": "MEDIUM",
        "description": "<h4>Shielded GKE nodes are not enabled</h4><h4>Description</h4>Shielded GKE Nodes provides verifiable integrity via secure boot, virtual trusted platform module (vTPM)-enabled measured boot, and integrity monitoring.<br>Shielded GKE nodes protects clusters against boot- or kernel-level malware or rootkits which persist beyond infected OS.<br>Shielded GKE nodes run firmware which is signed and verified using Google's Certificate Authority, ensuring that the nodes' firmware is unmodified and establishing the root of trust for Secure Boot. GKE node identity is strongly protected via virtual Trusted Platform Module (vTPM) and verified remotely by the master node before the node joins the cluster. Lastly, GKE node integrity (i.e., boot sequence and kernel) is measured and can be monitored and verified remotely.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_container_cluster<br>Argument: enable_shielded_nodes<br><br>Goresource \"google_container_cluster\" \"success\" {<br>name               = var.name<br>location           = var.location<br>initial_node_count = 1<br>project            = data.google_project.project.name<br><br>+ enable_shielded_nodes = true<br>}<br>"
    },
    "CKV_GCP_72": {
        "url": "https://docs.bridgecrew.io/docs/ensure-integrity-monitoring-for-shielded-gke-nodes-is-enabled",
        "severity": "MEDIUM",
        "description": "<h4>Integrity monitoring for shielded GKE nodes is not enabled</h4><h4>Description</h4>Enable Integrity Monitoring for Shielded GKE Nodes to be notified of inconsistencies during the node boot sequence.<br>Integrity Monitoring provides active alerting for Shielded GKE nodes which allows administrators to respond to integrity failures and prevent compromised nodes from being deployed into the cluster.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_container_cluster / google_container_node_pool<br>Argument: node_config.shielded_instance_config.enable_integrity_monitoring<br><br>Goresource \"google_container_cluster\" \"fail\" {<br>name               = var.name<br>location           = var.location<br>initial_node_count = 1<br>project            = data.google_project.project.name<br><br>node_config {<br><br>shielded_instance_config {<br>-     enable_integrity_monitoring = false<br>}<br>}<br>"
    },
    "CKV2_GCP_1": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gke-clusters-are-not-running-using-the-compute-engine-default-service-account",
        "severity": "MEDIUM",
        "description": "<h4>Kubernetes engine cluster nodes have default service account for project access</h4><h4>Description</h4>Create and use minimally privileged Service accounts to run GKE cluster nodes instead of using the Compute Engine default Service account. Unnecessary permissions could be abused in the case of a node compromise.<br>A GCP service account (as distinct from a Kubernetes ServiceAccount) is an identity that an instance or an application can use to run GCP API requests on your behalf. This identity is used to identify virtual machine instances to other Google Cloud Platform services. By default, Kubernetes Engine nodes use the Compute Engine default service account. This account has broad access by default, as defined by access scopes, making it useful to a wide variety of applications on the VM, but it has more permissions than are required to run your Kubernetes Engine cluster.<br>You should create and use a minimally privileged service account to run your Kubernetes Engine cluster instead of using the Compute Engine default service account, and create separate service accounts for each Kubernetes Workload (See Recommendation 6.2.2).<br>Kubernetes Engine requires, at a minimum, the node service account to have the monitoring.viewer, monitoring.metricWriter, and logging.logWriter roles. Additional roles may need to be added for the nodes to pull images from GCR.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_container_node_pool / google_container_cluster<br>Argument: google_project_default_service_accounts<br><br>Goresource \"google_project_default_service_accounts\" \"not_ok\" {<br>project = \"my-project-id\"<br>action = \"DELETE\"<br>id=\"1234\"<br>}<br><br>resource \"google_container_node_pool\" \"primary_A_not_ok\" {<br>name       = \"my-node-pool\"<br>...<br><br>-   service_account = google_project_default_service_accounts.not_ok.id<br>oauth_scopes    = [<br>\"https://www.googleapis.com/auth/cloud-platform\"<br>]<br>}<br>}<br><br>resource \"google_container_cluster\" \"primary_B_not_ok\" {<br><br>...<br>node_config {<br>-   service_account = google_project_default_service_accounts.not_ok.id<br>oauth_scopes = [<br>\"https://www.googleapis.com/auth/cloud-platform\"<br>]<br>}<br>}<br>"
    },
    "CKV_GCP_70": {
        "url": "https://docs.bridgecrew.io/docs/ensure-the-gke-release-channel-is-set",
        "severity": "MEDIUM",
        "description": "<h4>Kubernetes Engine cluster not using Release Channel for version management</h4><h4>Description</h4>The release channels allow organizations to better set their expectation of what is stable. GKE\u2019s release channel options include \u201crapid,\u201d \u201cregular,\u201d and \u201cstable.\u201d This allows you to opt for the alpha releases as part of the \u201crapid\u201d option, \u201cregular\u201d for standard release needs and \u201cstable\u201d when the tried-and-tested version becomes available.<br><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_container_cluster\" \"success\" {<br>name               = var.name<br>location           = var.location<br>initial_node_count = 1<br>project            = data.google_project.project.name<br><br>network    = var.network<br>subnetwork = var.subnetwork<br><br>ip_allocation_policy {<br>cluster_ipv4_cidr_block       = var.ip_allocation_policy[\"cluster_ipv4_cidr_block\"]<br>cluster_secondary_range_name  = var.ip_allocation_policy[\"cluster_secondary_range_name\"]<br>services_ipv4_cidr_block      = var.ip_allocation_policy[\"services_ipv4_cidr_block\"]<br>services_secondary_range_name = var.ip_allocation_policy[\"services_secondary_range_name\"]<br>}<br><br>node_config {<br>workload_metadata_config {<br>node_metadata = \"GKE_METADATA_SERVER\"<br>}<br>}<br><br>release_channel {<br>channel = var.release_channel<br>}<br><br>}<br>"
    },
    "CKV2_GCP_12": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-google-compute-firewall-ingress-does-not-allow-unrestricted-access-to-all-ports",
        "severity": "HIGH",
        "description": "<h4>GCP Firewall with Inbound rule overly permissive to All Traffic</h4><h4>Description</h4>This policy identifies GCP Firewall rules which allows inbound traffic on all protocols from public internet. Doing so, may allow a bad actor to brute force their way into the system and potentially get access to the entire network.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Go# pass<br>resource \"google_compute_firewall\" \"compute-firewall-ok-1\" {<br>name    = \"compute-firewall-ok-1\"<br>network = google_compute_network.example.name<br><br>deny {<br>protocol = \"all\"<br>}<br>source_ranges = [\"0.0.0.0/0\"]<br>disabled = false<br>}<br>"
    },
    "CKV2_GCP_7": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-a-mysql-database-instance-does-not-allow-anyone-to-connect-with-administrative-privileges",
        "severity": "LOW",
        "description": "<h4>A MySQL database instance allows anyone to connect with administrative privileges</h4><h4>Description</h4>It is recommended to set a password for the administrative user (root by default) to prevent unauthorized access to the SQL database instances.<br>This recommendation is applicable only for MySQL Instances. PostgreSQL does not offer any setting for No Password from the cloud console.<br>At the time of MySQL Instance creation, not providing an administrative password allows anyone to connect to the SQL database instance with administrative privileges. The root password should be set to ensure only authorized users have these privileges.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_sql_database_instance<br>Argument: google_sql_user<br><br>Goresource \"google_sql_user\" \"root_with_password\" {<br>name     = \"root\"<br>instance = google_sql_database_instance.db_instance.name<br>host     = \"me.com\"<br>+ password = \"1234\"<br>}<br>"
    },
    "CKV2_GCP_3": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-there-are-only-gcp-managed-service-account-keys-for-each-service-account",
        "severity": "LOW",
        "description": "<h4>There are not only GCP-managed service account keys for each service account</h4><h4>Description</h4>Anyone who has access to the keys will be able to access resources through the service account. GCP-managed keys are used by Cloud Platform services such as App Engine and Compute Engine. These keys cannot be downloaded. Google will keep the keys and automatically rotate them on an approximately weekly basis. User-managed keys are created, downloadable, and managed by users. They expire 10 years from creation.<br>For user-managed keys, the user has to take ownership of key management activities which include:<br><br>Key storage<br>Key distribution<br>Key revocation<br>Key rotation<br>Protecting the keys from unauthorized users<br>Key recovery<br>Even with key owner precautions, keys can be easily leaked by common development malpractices like checking keys into the source code or leaving them in the Downloads directory, or accidentally leaving them on support blogs/channels.<br>We recommended you prevent user-managed service account keys.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_service_account, google_service_account_key<br>Argument: service_account_id<br><br>Goresource \"google_service_account\" \"account_ok\" {<br>account_id = \"dev-foo-account\"<br>}<br><br>resource \"google_service_account_key\" \"ok_key\" {<br>service_account_id = google_service_account.account_ok.name<br>}<br>"
    },
    "CKV_GCP_CUSTOM_1": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-resources-that-suppot-labels-have-labels",
        "severity": "LOW",
        "description": "<h4>GCP resources that support labels do not have Labels</h4><h4>Description</h4>Many different types of GCP resources support labels. Labels allow you to add metadata to a resource to help identify ownership, perform cost / billing analysis, and to enrich a resource with other valuable information, such as descriptions and environment names. While there are many ways that labels can be used, we recommend you follow a labeling practice.<br>View Google's recommended labeling best practices here.<br>supported_resourcesgoogle_active_directory_domain<br>google_bigquery_dataset<br>google_bigquery_job<br>google_bigquery_table<br>google_bigtable_instance<br>google_cloud_identity_group<br>google_cloudfunctions_function<br>google_composer_environment<br>google_compute_disk<br>google_compute_image<br>google_compute_instance<br>google_compute_instance_from_template<br>google_compute_instance_template<br>google_compute_region_disk<br>google_compute_snapshot<br>google_dataflow_job<br>google_dataproc_cluster<br>google_dataproc_job<br>google_dns_managed_zone<br>google_eventarc_trigger<br>google_filestore_instance<br>google_game_services_game_server_cluster<br>google_game_services_game_server_config<br>google_game_services_game_server_deployment<br>google_game_services_realm<br>google_healthcare_consent_store<br>google_healthcare_dicom_store<br>google_healthcare_fhir_store<br>google_healthcare_hl7_v2_store<br>google_kms_crypto_key<br>google_ml_engine_model<br>google_monitoring_notification_channel<br>google_network_management_connectivity_test<br>google_notebooks_instance<br>google_project<br>google_pubsub_subscription<br>google_pubsub_topic<br>google_redis_instance<br>google_secret_manager_secret<br>google_spanner_instance<br>google_storage_bucket<br>google_tpu_node<br>google_workflows_workflow'<br><br><h4>Fix - Buildtime</h4>Terraform<br>The example below shows how to label a security group in Terraform. The syntax is generally the same for any label-enabled resource type.<br>Goresource \"google_storage_bucket\" \"auto-expire\" {<br>name          = \"auto-expiring-bucket\"<br>location      = \"US\"<br>force_destroy = true<br><br>+  label {<br>+    type = prod<br>}<br><br>lifecycle_rule {<br>condition {<br>age = 3<br>}<br>action {<br>type = \"Delete\"<br>}<br>}<br>}<br>"
    },
    "CKV2_GCP_6": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-cloud-kms-cryptokeys-are-not-anonymously-or-publicly-accessible",
        "severity": "LOW",
        "description": "<h4>GCP KMS crypto key is anonymously accessible</h4><h4>Description</h4>It is recommended that the IAM policy on Cloud KMS cryptokeys should restrict anonymous and/or public access.<br>Granting permissions to allUsers or allAuthenticatedUsers allows anyone to access the dataset. Such access might not be desirable if sensitive data is stored at the location. In this case, ensure that anonymous and/or public access to a Cloud KMS cryptokey is not allowed.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_kms_crypto_key<br>Argument: google_kms_crypto_key_iam_member / google_kms_crypto_key_iam_binding<br><br>Goresource \"google_kms_key_ring\" \"keyring\" {<br>name = \"keyring-example\"<br>location = \"global\"<br>}<br><br>resource \"google_kms_crypto_key\" \"bad_key\" {<br>name = \"crypto-key-example\"<br>key_ring = google_kms_key_ring.keyring.id<br>rotation_period = \"100000s\"<br>lifecycle {<br>prevent_destroy = true<br>}<br>}<br><br>resource \"google_kms_crypto_key_iam_member\" \"bad_member_1\" {<br>crypto_key_id = google_kms_crypto_key.bad_key.id<br>role          = \"roles/cloudkms.cryptoKeyEncrypter\"<br>- member        = \"allUsers\"<br>}<br><br>resource \"google_kms_crypto_key_iam_member\" \"bad_member_2\" {<br>crypto_key_id = google_kms_crypto_key.bad_key.id<br>role          = \"roles/cloudkms.cryptoKeyEncrypter\"<br>- member        = \"allAuthenticatedUsers\"<br>}<br><br>resource \"google_kms_crypto_key_iam_binding\" \"bad_binding_1\" {<br>crypto_key_id = google_kms_crypto_key.bad_key.id<br>role          = \"roles/cloudkms.cryptoKeyEncrypter\"<br>- members = [<br>-   \"allUsers\",<br>- ]<br>}<br><br>resource \"google_kms_crypto_key_iam_binding\" \"bad_binding_2\" {<br>crypto_key_id = google_kms_crypto_key.bad_key.id<br>role          = \"roles/cloudkms.cryptoKeyEncrypter\"<br>- members = [<br>-   \"allAuthenticatedUsers\",<br>- ]<br>}<br><br>resource \"google_kms_crypto_key\" \"good_key\" {<br>name = \"crypto-key-example\"<br>key_ring = google_kms_key_ring.keyring.id<br>rotation_period = \"100000s\"<br>lifecycle {<br>prevent_destroy = true<br>}<br>}<br><br>resource \"google_kms_crypto_key_iam_member\" \"good_member\" {<br>crypto_key_id = google_kms_crypto_key.good_key.id<br>role = \"roles/cloudkms.cryptoKeyEncrypter\"<br>+ member = \"user:[email\u00a0protected]\"<br>}<br><br>resource \"google_kms_crypto_key_iam_binding\" \"good_binding\" {<br>crypto_key_id = google_kms_crypto_key.good_key.id<br>role          = \"roles/cloudkms.cryptoKeyEncrypter\"<br>+ members = [<br>+   \"user:[email\u00a0protected]\",<br>+ ]<br>}<br>"
    },
    "CKV_GCP_73": {
        "url": "https://docs.bridgecrew.io/docs/ensure-cloud-armor-prevents-message-lookup-in-log4j2",
        "severity": "MEDIUM",
        "description": "<h4>Front Door WAF allows message lookup in Log4j2</h4><h4>Description</h4>Using a vulnerable version of Apache Log4j library might enable attackers to exploit a Lookup mechanism that supports making requests using special syntax in a format string which can potentially lead to a risky code execution, data leakage and more.<br>Set your Cloud Armor to prevent executing such mechanism using the rule definition below.<br>Learn more around CVE-2021-44228<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_compute_security_policy<br><br>Goresource \"google_compute_security_policy\" \"example\" {<br>name = \"example\"<br><br>rule {<br>action   = \"deny(403)\"<br>priority = 1<br>match {<br>expr {<br>expression = \"evaluatePreconfiguredExpr('cve-canary')\"<br>}<br>}<br>}<br>}<br>"
    },
    "CKV2_GCP_5": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-cloud-audit-logging-is-configured-properly-across-all-services-and-all-users-from-a-project",
        "severity": "MEDIUM",
        "description": "<h4>GCP project audit logging is not configured properly across all services and all users in a project</h4><h4>Description</h4>It is recommended that Cloud Audit Logging is configured to track all admin activities and read, write access to user data.<br>Cloud Audit Logging maintains two audit logs for each project, folder, and organization: Admin Activity and Data Access.<br><br>Admin Activity logs contain log entries for API calls or other administrative actions that modify the configuration or metadata of resources. Admin Activity audit logs are enabled for all services and cannot be configured.<br>Data Access audit logs record API calls that create, modify, or read user-provided data. These are disabled by default and should be enabled.<br>There are three kinds of Data Access audit log information:<br><br><br>Admin read: Records operations that read metadata or configuration information. Admin Activity audit logs record writes of metadata and configuration information that cannot be disabled.<br>Data read: Records operations that read user-provided data. o Data write: Records operations that write user-provided data.<br>It is recommended to have an effective default audit config configured in such a way that:<br><br><br>logtype is set to DATA_READ (to log user activity tracking) and DATA_WRITES (to log changes/tampering to user data).<br>audit config is enabled for all the services supported by the Data Access audit logs feature.<br>Logs should be captured for all users, i.e., there are no exempted users in any of the audit config sections. This will ensure overriding the audit config will not contradict the requirement.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_project<br>Argument: google_project_iam_audit_config<br><br>Goresource \"google_project\" \"good_project\" {<br>name = \"good\"<br>project_id = \"123456\"<br>}<br><br>resource \"google_project\" \"bad_project\" {<br>name = \"bad\"<br>project_id = \"123456\"<br>}<br><br>resource \"google_project_iam_audit_config\" \"project_good_audit\" {<br>project = google_project.good_project.id<br>+ service = \"allServices\"<br>audit_log_config {<br>log_type = \"ADMIN_READ\"<br>}<br>audit_log_config {<br>log_type = \"DATA_READ\"<br>}<br>audit_log_config {<br>log_type = \"DATA_WRITE\"<br>}<br>}<br><br>resource \"google_project_iam_audit_config\" \"project_bad_audit\" {<br>project = google_project.bad_project.id<br>- service = \"someService\"<br>audit_log_config {<br>log_type = \"ADMIN_READ\"<br>}<br>audit_log_config {<br>log_type = \"DATA_READ\"<br>-   exempted_members = [<br>-     \"user:[email\u00a0protected]\",<br>-   ]<br>}<br>}<br>"
    },
    "CKV2_GCP_10": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-cloud-function-http-trigger-is-secured",
        "severity": "MEDIUM",
        "description": "<h4>GCP Cloud Function HTTP trigger is not secured</h4><h4>Description</h4>This policy identifies GCP Cloud Functions for which the HTTP trigger is not secured. When you configure HTTP functions to be triggered only with HTTPS, user requests will be redirected to use the HTTPS protocol, which is more secure. It is recommended to set the 'Require HTTPS' for configuring HTTP triggers while deploying your function.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_cloudfunctions_function\" \"pass\" {<br>name        = \"function-test\"<br>description = \"My function\"<br>runtime     = \"nodejs16\"<br><br>available_memory_mb          = 128<br>source_archive_bucket        = google_storage_bucket.bucket.name<br>source_archive_object        = google_storage_bucket_object.archive.name<br>trigger_http                 = true<br>https_trigger_security_level = \"SECURE_ALWAYS\"<br>timeout                      = 60<br>entry_point                  = \"helloGET\"<br>labels = {<br>my-label = \"my-label-value\"<br>}<br>}<br>"
    },
    "CKV2_GCP_4": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-retention-policies-on-log-buckets-are-configured-using-bucket-lock",
        "severity": "MEDIUM",
        "description": "<h4>GCP log bucket retention policy is not configured using bucket lock</h4><h4>Description</h4>Enabling retention policies on log buckets will protect logs stored in cloud storage buckets from being overwritten or accidentally deleted. It is recommended to set up retention policies and configure Bucket Lock on all storage buckets that are used as log sinks.<br>Logs can be exported by creating one or more sinks that include a log filter and a destination. As Stackdriver Logging receives new log entries, they are compared against each sink. If a log entry matches a sink's filter, then a copy of the log entry is written to the destination.<br>Sinks can be configured to export logs in storage buckets. It is recommended to configure a data retention policy for these cloud storage buckets and to lock the data retention policy; thus permanently preventing the policy from being reduced or removed. This way, if the system is ever compromised by an attacker or a malicious insider who wants to cover their tracks, the activity logs are definitely preserved for forensics and security investigations.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_logging_folder_sink / google_logging_project_sink / google_logging_organization_sink<br>Argument: google_storage_bucket<br><br>Goresource \"google_storage_bucket\" \"log_bucket_bad\" {<br>name = \"organization-logging-bucket\"<br><br>retention_policy {<br>retention_period = 604800<br>-   is_locked = false<br>}<br>}<br><br>resource \"google_storage_bucket\" \"log_bucket_good\" {<br>name = \"organization-logging-bucket\"<br><br>retention_policy {<br>retention_period = 604800<br>+   is_locked = true<br>}<br>}<br>"
    },
    "CKV_GCP_100": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-bigquery-table-is-not-publicly-accessible",
        "severity": "HIGH",
        "description": "<h4>GCP BigQuery Tables are anonymously or publicly accessible</h4><h4>Description</h4>GCP BigQuery tables are the resources in BigQuery that contain your data records, and each BigQuery table belongs to a dataset. Every BigQuery table inherits the IAM policies attached to it's dataset, but each table can also have it's own IAM policies directly applied. These table-level IAM policies can be set for public access via the allUsers and allAuthenticatedUsers IAM principals which can inadvertently expose your data to the public.<br>We recommend you ensure anonymous and public access to BigQuery tables is not allowed.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to BigQuery.<br>On the Dataset Explorer details page, expand the dataset that contains your table.<br>Select your target table's kebab menu and then select open.<br>Click the SHARE button to open the table's IAM policies.<br>To remove a specific role assignment, to the front of allUsers and allAuthenticatedUsers, click Delete.<br><br>CLI Command<br>To remove access to allUsers and allAuthenticatedUsers, you need to first get the BigQuery tables existing IAM policy. To retrieve the existing policy and copy it to a local file:<br>Shellbq get-iam-policy --format=prettyjson \\<br>PROJECT-ID:DATASET.TABLE \\<br>> policy.jso<br><br>Replace PROJECT-ID with the project ID where the BigQuery table lives. Replace DATASET with the name of the BigQuery dataset that contains the table. Replace TABLE with the table name.<br>Next, locate and remove the IAM bindings with either allUsers or allAuthenticatedUsers depending on your Checkov error. After modifying the policy.json file, update BigQuery table with the following command:<br>Shellbq set-iam-policy \\<br>PROJECT-ID:DATASET.TABLE \\<br>policy.json<br><br>Replace PROJECT-ID with the project ID where the BigQuery table lives. Replace DATASET with the name of the BigQuery dataset that contains the table. Replace TABLE with the table name.<br><h4>Fix - Buildtime</h4>Terraform<br><br><br>Resource: google_bigquery_table_iam_member<br><br><br>Field: member<br><br><br>Resource: google_bigquery_table_iam_binding<br><br><br>Field: members<br><br><br>Go//Option 1<br>resource \"google_bigquery_table_iam_member\" \"member\" {<br>dataset_id = google_bigquery_table.default.dataset_id<br>table_id = google_bigquery_table.default.table_id<br>role = \"roles/bigquery.dataOwner\"<br>-  member        = \"allUsers\"<br>-  member        = \"allAuthenticatedUsers\"<br>}<br><br>//Option 2<br>resource \"google_bigquery_table_iam_binding\" \"binding\" {<br>dataset_id = google_bigquery_table.default.dataset_id<br>table_id = google_bigquery_table.default.table_id<br>role = \"roles/bigquery.dataOwner\"<br>members = [<br>-    \"allUsers\",<br>-    \"allAuthenticatedUsers\"<br>]<br>}<br>"
    },
    "CKV_GCP_77": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-google-compute-firewall-ingress-does-not-allow-ftp-port-20-access",
        "severity": "LOW",
        "description": "<h4>GCP Google compute firewall ingress allows FTP port (20) access</h4><h4>Description</h4>It is a best practice to ensure that your firewall ingress rules do not allow unrestricted access to FTP port 20, as it can increase the risk of unauthorized access or attacks on your network. FTP (File Transfer Protocol) is a widely used protocol for transferring files between computers, but it can also be a potential security risk if not properly configured. By restricting access to only specific IP addresses or ranges that you trust, you can help secure your network from potential threats.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_compute_firewall\" \"restricted\" {<br>name    = \"example\"<br>network = \"google_compute_network.vpc.name\"<br><br>allow {<br>protocol = \"tcp\"<br>ports    = [\"20\"]<br>}<br><br>source_ranges = [\"172.1.2.3/32\"]<br>target_tags   = [\"ftp\"]<br>}<br>"
    },
    "CKV_GCP_101": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-artifact-registry-repository-is-not-anonymously-or-publicly-accessible",
        "severity": "HIGH",
        "description": "<h4>GCP Artifact Registry repositories are anonymously or publicly accessible</h4><h4>Description</h4>Artifact Registry is a service that stores artifacts and build dependencies for your GCP applications. Artifact registry repositories can contain sensitive credentials that are baked into containers, personal data (like PII), or confidential data that you may not want publicly accessible. Repositories can be made anonymously or publicly accessible via IAM policies containing the IAM members allUsers or allAuthenticatedUsers.<br>We recommend you ensure that neither anonymous or public access to Artifact Registry repositories is allowed.<br><h4>Fix - Runtime</h4>GCP Console<br>To remove anonymous or public access for your Artifact Registry repository:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Repositories.<br>Select the target Artifact Registry repository.<br>Expand the Info Panel by selecting Show Info Panel.<br>To remove a specific role assignment, select allUsers or allAuthenticatedUsers, and then click Remove member.<br><br>CLI Command<br>To remove anonymous or public access for your Artifact Registry repositories use the following command:<br>Shellgcloud artifacts repositories remove-iam-policy-binding REPOSITORY  \\<br>--member=MEMBER  \\<br>--role=ROLE<br><br>Replace REPOSITORY with your repository ID. Replace MEMBER with allUsers or allAuthenticatedUsers depending on your Checkov alert. Replace ROLE with the member's role.<br><h4>Fix - Buildtime</h4>Terraform<br><br><br>Resource: google_artifact_registry_repository_iam_binding<br><br><br>Field: members<br><br><br>Resource: google_storage_bucket_iam_member<br><br><br>Field: member<br><br><br>Goresource \"google_artifact_registry_repository_iam_binding\" \"public_binding\" {<br>provider = google-beta<br>location = google_artifact_registry_repository.my-repo.location<br>repository = google_artifact_registry_repository.my-repo.name<br>role = \"roles/artifactregistry.writer\"<br><br>members = [<br>-    \"allUsers\",<br>-    \"allAuthenticatedUsers\",<br>]<br>}<br><br>Goresource \"google_artifact_registry_repository_iam_member\" \"public_member\" {<br>provider = google-beta<br>location = google_artifact_registry_repository.my-repo.location<br>repository = google_artifact_registry_repository.my-repo.name<br>role = \"roles/artifactregistry.writer\"<br><br>-  member = \"allUsers\"<br>-  member = \"allAuthenticatedUsers\"<br>}<br>"
    },
    "CKV_GCP_78": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-cloud-storage-has-versioning-enabled",
        "severity": "LOW",
        "description": "<h4>GCP Cloud storage does not have versioning enabled</h4><h4>Description</h4>Enabling versioning for your Google Cloud Platform (GCP) Cloud Storage can help improve the security and management of your data. Versioning allows you to keep multiple versions of an object in your storage bucket, and can be useful for a variety of purposes.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_storage_bucket\" \"pass\" {<br>name     = \"foo\"<br>location = \"EU\"<br><br>versioning = {<br>enabled = true<br>}=<br>}<br>"
    },
    "CKV_GCP_98": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-dataproc-cluster-is-not-anonymously-or-publicly-accessible",
        "severity": "HIGH",
        "description": "<h4>GCP Dataproc cluster is anonymously or publicly accessible</h4><h4>Description</h4>Dataproc is commonly used for data lake modernization, ETL, and data science workloads. A Dataproc cluster contains at least one \"management\" VM and one \"compute\" VM. Access to Dataproc clusters is controlled via IAM policies. These IAM policies can be set for public access via the allUsers and allAuthenticatedUsers IAM principals which can inadvertently expose your data to the public.<br>We recommend you ensure anonymous and public access to Dataproc clusters is not allowed.<br><h4>Fix - Runtime</h4>GCP Console<br>To remove anonymous or public access for Dataproc clusters:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Clusters.<br>Select the target Dataproc cluster.<br>Expand the Info Panel by selecting Show Info Panel.<br>To remove a specific role assignment, select allUsers or allAuthenticatedUsers, and then click Remove member.<br><br>CLI Command<br>To remove access for allUsers and allAuthenticatedUsers, you need to first get the Dataproc cluster's existing IAM policy. To retrieve the existing policy and copy it to a local file:<br>Shellgcloud dataproc clusters get-iam-policy CLUSTER-ID  \\<br>--format json > policy.json<br><br>Replace CLUSTER-ID with your Dataproc cluster ID.<br>Next, locate and remove the IAM bindings with either allUsers or allAuthenticatedUsers depending on your Checkov error. After modifying the policy.json file, update the Dataproc cluster with the following command:<br>Shellgcloud dataproc clusters set-iam-policy CLUSTER-ID policy.json<br><br>Replace CLUSTER-ID with your Dataproc cluster ID.<br><h4>Fix - Buildtime</h4>Terraform<br><br><br>Resource: google_dataproc_cluster_iam_member<br><br><br>Field: member<br><br><br>Resource: google_dataproc_cluster_iam_binding<br><br><br>Field: members<br><br><br>Go//Option 1<br>resource \"google_dataproc_cluster_iam_member\" \"editor\" {<br>cluster = \"your-dataproc-cluster\"<br>role    = \"roles/editor\"<br>-  member        = \"allUsers\"<br>-  member        = \"allAuthenticatedUsers\"<br>}<br><br>//Option 2<br>resource \"google_dataproc_cluster_iam_binding\" \"editor\" {<br>cluster = \"your-dataproc-cluster\"<br>role    = \"roles/editor\"<br>members = [<br>-    \"allUsers\",<br>-    \"allAuthenticatedUsers\"<br>]<br>}<br>"
    },
    "CKV_GCP_92": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-vertex-ai-datasets-use-a-customer-manager-key-cmk",
        "severity": "LOW",
        "description": "<h4>GCP Vertex AI datasets do not use a Customer Manager Key (CMK)</h4><h4>Description</h4>This policy identifies Vertex AI datasets which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer managed KMS Keys to encrypt your Vertex AI datasets data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_vertex_ai_dataset<br>Arguments:  region.encryption_spec.kms_key_name<br><br>Goresource \"google_vertex_ai_dataset\" \"pass\" {<br>display_name        = \"terraform\"<br>metadata_schema_uri = \"gs://google-cloud-aiplatform/schema/dataset/metadata/image_1.0.0.yaml\"<br>region              = \"us-central1\"<br>encryption_spec {<br>kms_key_name=google_kms_crypto_key.example.name<br>}<br><br>}<br>"
    },
    "CKV_GCP_84": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-artifact-registry-repositories-are-encrypted-with-customer-supplied-encryption-keys-csek",
        "severity": "LOW",
        "description": "<h4>GCP Artifact Registry repositories are not encrypted with Customer Supplied Encryption Keys (CSEK)</h4><h4>Description</h4>Customer-Supplied Encryption Keys (CSEK) are a feature in Google Cloud Storage and Google Compute Engine. Google Compute Engine encrypts all data at rest by default. Compute Engine handles and manages this encryption automatically, with no additional action required. When you provide your own encryption keys Compute Engine uses your key to protect the Google-generated keys used to encrypt and decrypt your data. Only users that provide the correct key can use resources protected by a customer-supplied encryption key. Google does not store your keys on its servers and cannot access your protected data unless you provide the key. If you forget or lose your key Google is unable to recover the key or to recover any data encrypted with that key. To control and manage this encryption yourself, you must provide your own encryption keys.<br>We recommend you supply your own encryption keys for Google to use, at a minimum to encrypt business critical Artifact Registry repositories. This helps protect the Google-generated keys used to encrypt and decrypt your data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_artifact_registry_repository<br>Arguments: kms_key_name<br><br>Goresource \"google_artifact_registry_repository\" \"pass\" {<br>provider = google-beta<br><br>location      = \"us-central1\"<br>repository_id = \"my-repository\"<br>description   = \"example docker repository with cmek\"<br>format        = \"DOCKER\"<br>kms_key_name  = google_kms_crypto_key.example.name<br>}<br>"
    },
    "CKV2_GCP_9": {
        "url": "https://docs.bridgecrew.io/docs/ensure-google-container-registry-repository-is-not-anonymously-or-publicly-accessible",
        "severity": "HIGH",
        "description": "<h4>GCP Container Registry repositories are anonymously or publicly accessible</h4><h4>Description</h4>Google Container Registry (GCR) is a GCP service that contains repositories for your container images. A GCR repo is publicly accessible if the host location's underlying storage bucket is publicly accessible because GCR images are stored in GCS. Public GCR repositories can put your data at risk of exposure and should be adjusted to a more secure configuration (private).<br>We recommend you ensure that neither anonymous or public access to GCR Repositories is allowed.<br><h4>Fix - Runtime</h4>GCP Console<br>To remove anonymous or public access to your GCR repositories:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to GCR Settings.<br>Under Public access locate the repositories that say PUBLIC under the Visibility column.<br>Select the dropdown and switch to PRIVATE.<br><br>CLI Command<br>To remove anonymous or public access to your GCR repositories use the gsutil command:<br>Shellgsutil iam ch -d PRINCIPAL gs://BUCKET-NAME<br><br>Replace PRINCIPAL with either allUsers or allAuthenticatedUsers depending on your Checkov alert. Replace BUCKET-NAME with the GCS bucket where your images are stored.<br>The BUCKET-NAME can be determined by executing gsutil ls and your Container Registry bucket URL will be listed as gs://artifacts.PROJECT-ID.appspot.com or gs://STORAGE-REGION.artifacts.PROJECT-ID.appspot.com. PROJECT-ID and STORAGE-REGION will be replaced with your GCP project ID or the region where your GCR repository is configured.<br><h4>Fix - Buildtime</h4>Terraform<br><br><br>Resource: google_storage_bucket_iam_binding<br><br><br>Field: members<br><br><br>Resource: google_storage_bucket_iam_member<br><br><br>Field: member<br><br><br>Google Container Registry (GCR) does not have IAM-specific resources in Terraform. Instead, GCR IAM is handled via GCS IAM resources as seen in the below examples.<br>Goresource \"google_storage_bucket_iam_binding\" \"gcr_public_binding\" {<br>bucket = google_storage_bucket.default.name<br>role = \"roles/storage.viewer\"<br><br>members = [<br>-    \"allUsers\",<br>-    \"allAuthenticatedUsers\",<br>]<br>}<br><br>Goresource \"google_artifact_registry_repository_iam_member\" \"public_member\" {<br>provider = google-beta<br>location = google_artifact_registry_repository.my-repo.location<br>repository = google_artifact_registry_repository.my-repo.name<br>role = \"roles/artifactregistry.writer\"<br><br>-  member = \"allUsers\"<br>-  member = \"allAuthenticatedUsers\"<br>}<br><br>Goresource \"google_storage_bucket_iam_member\" \"gcr_public_member\" {<br>bucket = google_storage_bucket.default.name<br>role = \"roles/storage.viewer\"<br><br>-  member = \"allUsers\"<br>-  member = \"allAuthenticatedUsers\"<br>}<br>"
    },
    "CKV_GCP_99": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-pubsub-topic-is-not-anonymously-or-publicly-accessible",
        "severity": "MEDIUM",
        "description": "<h4>Pub/Sub Topic is anonymously or publicly accessible</h4><h4>Description</h4>Pub/Sub is commonly used for asynchronous communication for applications in GCP. Messages are published to a Pub/Sub Topic and the ability to publish a message is controlled via IAM policies. It is possible to make Pub/Sub Topics publicly or anonymously accessible. Public notification topics can expose sensitive data and are a target for data exfiltration.<br>We recommend you ensure that neither anonymous or public access to Pub/Sub Topics is allowed.<br><h4>Fix - Runtime</h4>GCP Console<br>To remove anonymous or public access to your Pub/Sub Topic:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Topics.<br>Select the Pub/Sub Topic checkbox next to your Topic ID.<br>Select the INFO PANEL tab to view the topic's permissions.<br>To remove a specific role assignment, select allUsers or allAuthenticatedUsers, and then click Delete.<br><br>CLI Command<br>To remove access to allUsers and allAuthenticatedUsers, you need to first get the Pub/Sub Topic's existing IAM policy. To retrieve the existing policy and copy it to a local file:<br>Shellgcloud pubsub topics get-iam-policy \\<br>projects/PROJECT/topics/TOPIC \\<br>--format json > topic_policy.json<br><br>Replace PROJECT with the project ID where your Pub/Sub Topic is located. Replace TOPIC with the Pub/Sub Topic ID.<br>Next, locate and remove the IAM bindings with either allUsers or allAuthenticatedUsers depending on your Checkov error. After modifying the topic_policy.json file, update Pub/Sub Topic with the following command:<br>Shellgcloud pubsub topics set-iam-policy  \\<br>projects/PROJECT/topics/TOPIC  \\<br>topic_policy.json<br><br>Replace PROJECT with the project ID where your Pub/Sub Topic is located. Replace TOPIC with the Pub/Sub Topic ID.<br><h4>Fix - Buildtime</h4>Terraform<br><br><br>Resource: google_pubsub_topic_iam_binding<br><br><br>Field: members<br><br><br>Resource: google_pubsub_topic_iam_member<br><br><br>Field: member<br><br><br>Goresource \"google_pubsub_topic_iam_binding\" \"public_binding\" {<br>topic = google_pubsub_topic.example.name<br>role = \"roles/pubsub.publisher\"<br><br>members = [<br>-    \"allUsers\",<br>-    \"allAuthenticatedUsers\",<br>]<br>}<br><br>Goresource \"google_pubsub_topic_iam_member\" \"public_member\" {<br>topic = google_pubsub_topic.example.name<br>role = \"roles/pubsub.publisher\"<br><br>-  member = \"allUsers\"<br>-  member = \"allAuthenticatedUsers\"<br>}<br>"
    },
    "CKV_GCP_93": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-spanner-database-is-encrypted-with-customer-supplied-encryption-keys-cseks",
        "severity": "LOW",
        "description": "<h4>GCP Spanner Database is not encrypted with Customer Supplied Encryption Keys (CSEKs)</h4><h4>Description</h4>Customer-Supplied Encryption Keys (CSEK) are a feature in Google Cloud Storage and Google Compute Engine. Google Compute Engine encrypts all data at rest by default. Compute Engine handles and manages this encryption automatically, with no additional action required. When you provide your own encryption keys Compute Engine uses your key to protect the Google-generated keys used to encrypt and decrypt your data. Only users that provide the correct key can use resources protected by a customer-supplied encryption key. Google does not store your keys on its servers and cannot access your protected data unless you provide the key. If you forget or lose your key Google is unable to recover the key or to recover any data encrypted with that key. To control and manage this encryption yourself, you must provide your own encryption keys.<br>We recommend you supply your own encryption keys for Google to use, at a minimum to encrypt business critical Spanner Database. This helps protect the Google-generated keys used to encrypt and decrypt your data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_spanner_database<br>Arguments:  encryption_config.kms_key_name<br><br>Goresource \"google_spanner_database\" \"pass\" {<br>instance = google_spanner_instance.example.name<br>name     = \"my-database\"<br>ddl = [<br>\"CREATE TABLE t1 (t1 INT64 NOT NULL,) PRIMARY KEY(t1)\",<br>\"CREATE TABLE t2 (t2 INT64 NOT NULL,) PRIMARY KEY(t2)\",<br>]<br>deletion_protection = false<br>encryption_config {<br>kms_key_name= google_kms_crypto_key.example.name<br>}<br>}<br>"
    },
    "CKV_GCP_63": {
        "url": "https://docs.bridgecrew.io/docs/bc_gcp_logging_3",
        "severity": "LOW",
        "description": "<h4>Bucket logs to itself</h4><h4>Description</h4>A check to ensure that the specified logging bucket is not itself. A bucket must not log access to itself, logging requires a second separate bucket.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_storage_bucket<br>This check will trigger if you attempt to self reference:<br><br>google_storage_bucket.mylovelybucket,tfresource \"google_storage_bucket\" \"mylovelybucket\" {<br>name     = \"mylovelybucket\"<br>location = var.location<br>uniform_bucket_level_access = true<br>logging {<br>log_bucket = \"mylovelybucket\"<br>}<br>}<br>"
    },
    "CKV_GCP_94": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-cloud-dataflow-job-has-public-ips",
        "severity": "HIGH",
        "description": "<h4>GCP Dataflow jobs are not private</h4><h4>Description</h4>Cloud Dataflow in GCP is a service used for streaming and batch data processing. A Dataflow job consists of at least one management node and one compute node (both are GCE VMs). By default, these nodes are configured with public IPs that allow them to communicate with the public internet, but this also means they increase your potential attack surface by being publicly accessible.<br>We recommend you remove the public IPs for your Dataflow jobs. View the official Google documentation for the currently supported internet access configuration options.<br><h4>Fix - Runtime</h4>GCP Console<br>Making Dataflow jobs private via the console is not currently supported.<br>CLI Command<br>Making running Dataflow jobs private via the gcloud CLI is not currently supported. Instead, you need to drain or cancel your job and then re-create with the correct flag configured.<br>Shell# To cancel a Dataflow job<br>gcloud dataflow jobs cancel JOB_ID<br><br>Replace JOB_ID with your Dataflow job ID.<br>Shell# To drain a Dataflow job<br>gcloud dataflow jobs drain JOB_ID<br><br>Replace JOB_ID with your Dataflow job ID.<br>Shell# To create a new Dataflow job without public IPs<br>gcloud dataflow jobs run JOB_NAME \\<br>--disable-public-ips \\<br>--gcs-location=GCS_LOCATION<br><br>Replace JOB_ID with your Dataflow job ID. Replace GCS_LOCATION with the GCS bucket name where your job template lives. Must be a URL beginning with gs://.<br>Google also provides documentation on how to Turn off external IP address for your Dataflow jobs. This documentation has examples for Java and Python.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_dataflow_job<br>Field: ip_configuration<br><br>Goresource \"google_dataflow_job\" \"big_data_job\" {<br>name              = \"dataflow-job\"<br>template_gcs_path = \"gs://my-bucket/templates/template_file\"<br>temp_gcs_location = \"gs://my-bucket/tmp_dir\"<br>parameters = {<br>foo = \"bar\"<br>baz = \"qux\"<br>}<br><br>-  ip_configuration = \"WORKER_IP_PUBLIC\"<br>+  ip_configuration = \"WORKER_IP_PRIVATE\"<br>}<br>"
    },
    "CKV_GCP_96": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-vertex-ai-metadata-store-uses-a-customer-manager-key-cmk",
        "severity": "LOW",
        "description": "<h4>GCP Vertex AI Metadata Store does not use a Customer Manager Key (CMK)</h4><h4>Description</h4>This policy identifies Vertex AI Metadata Stores which are encrypted with default KMS keys and not with Keys managed by Customer. It is a best practice to use customer-managed KMS Keys to encrypt your Vertex AI Metadata Store data. It gives you full control over the encrypted data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_vertex_ai_metadata_store<br>Arguments: region.encryption_spec.kms_key_name<br><br>Goresource \"google_vertex_ai_metadata_store\" \"pass\" {<br>name        = \"test-store\"<br>description = \"Store to test the terraform module\"<br>region      = \"us-central1\"<br>encryption_spec {<br>kms_key_name=google_kms_crypto_key.example.name<br>}<br>}<br>"
    },
    "CKV_GCP_89": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-vertex-ai-workbench-does-not-have-public-ips",
        "severity": "HIGH",
        "description": "<h4>GCP Vertex AI instances are not private</h4><h4>Description</h4>Vertex AI Workbench is a data science service offered by GCP that leverages JupyterLab to explore and access data. Workbenches have public IPs assigned by default which can increase your attack surface and expose sensitive data.<br>We recommend you only assign private IPs to Vertex AI Workbenches.<br><h4>Fix - Runtime</h4>GCP Console<br>It's not currently possible to edit a Vertex AI workbench network setting to remove or add a public IP.<br>To create a Vertex AI Workbench with a private IP:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Vertex AI Workbench.<br>Scroll down to the Networking section and expand.<br>Locate the External IP dropdown and select None.<br><br>CLI Command<br>It's not currently possible to edit a Vertex AI workbench network settings to remove or add a public IP.<br>To create a private Vertex AI Workbench you'll need to specify the --no-public-ip command. For example:<br>Shell# To create an instance from a VmImage name<br>gcloud beta notebooks instances create example-instance  \\<br>--vm-image-project=deeplearning-platform-release  \\<br>--vm-image-name=tf2-2-1-cu101-notebooks-20200110  \\<br>--machine-type=n1-standard-4  \\<br>--location=us-central1-b  \\<br>--no-public-ip<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_notebooks_instance<br>Field: no_public_ip<br><br>Goresource \"google_notebooks_instance\" \"public_instance\" {<br>name = \"my-notebook\"<br>location = \"us-west1-a\"<br>machine_type = \"e2-medium\"<br>vm_image {<br>project      = \"deeplearning-platform-release\"<br>image_family = \"tf-latest-cpu\"<br><br>- no_public_ip = false<br>+ no_public_ip = true<br>}<br>}<br>"
    },
    "CKV_GCP_79": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-sql-database-uses-the-latest-major-version",
        "severity": "LOW",
        "description": "<h4>GCP SQL database does not use the latest Major version</h4><h4>Description</h4>Using the latest major version for your Google Cloud Platform (GCP) SQL database can help improve the security and reliability of your database. Newer versions of software often include security updates and bug fixes that can help protect your database from potential threats and improve its performance.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_sql_database_instance\" \"pass\" {<br>provider = google-beta<br><br>name             = \"private-instance-${random_id.db_name_suffix.hex}\"<br>region           = \"us-central1\"<br>database_version = \"MYSQL_8_0\"<br><br>depends_on = [google_service_networking_connection.private_vpc_connection]<br><br>settings {<br>tier = \"db-f1-micro\"<br>ip_configuration {<br>ipv4_enabled    = false<br>private_network = google_compute_network.private_network.id<br>}<br>}<br>}<br>"
    },
    "CKV_GCP_95": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-memorystore-for-redis-is-auth-enabled",
        "severity": "MEDIUM",
        "description": "<h4>GCP Memorystore for Redis has AUTH disabled</h4>Memorystore for Redis has AUTH disabled<br><h4>Description</h4>AUTH is an optional security feature on Memorystore for Redis that requires incoming connections to authenticate with an AUTH string. Every AUTH string is a Universally Unique Identifier (UUID), and each Redis instance with AUTH enabled has a unique AUTH string.<br>When you enable the AUTH feature on your Memorystore instance, incoming client connections must authenticate in order to connect. Once a client authenticates with an AUTH string, it remains authenticated for the lifetime of that connection, even if you change the AUTH string.<br>We recommend that you enble AUTH on your Memorystore for Redis database to protect against unwanted or non-approved connections.<br><h4>Fix - Runtime</h4>GCP Console<br>To enable AUTH on your Memorystore for Redis database:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Memorystore for Redis.<br>View your instance's Instance details page by clicking on your Instance ID.<br>Select the EDIT button.<br>Scroll to the Security section and select the checkbox for Enable AUTH.<br><br>CLI Command<br>To enable AUTH on your Memorystore for Redis instance execute the following command:<br>supported_resourcesgcloud beta redis instances update INSTANCE-ID \\<br>--enable-auth \\<br>--region=REGION<br><br>Replace INSTANCE-ID with your Memorystore for Redis instance ID. Replace REGION with the region where your Memorystore for Redis database lives.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_redis_instance<br>Field: auth_enabled<br><br>Goresource \"google_redis_instance\" \"cache\" {<br>name           = \"memory-cache\"<br>display_name   = \"memory cache db\"<br>tier           = \"STANDARD_HA\"<br>memory_size_gb = 1<br><br>- auth_enabled = false<br>+ auth_enabled = true<br>"
    },
    "CKV_GCP_88": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-compute-firewall-ingress-does-not-allow-unrestricted-mysql-access",
        "severity": "LOW",
        "description": "<h4>GCP Firewall rule allows all traffic on MySQL DB port (3306)</h4><h4>Description</h4>It is a best practice to ensure that your firewall ingress rules do not allow unrestricted access to your MySQL database, as it can increase the risk of unauthorized access or attacks on your database. By restricting access to only specific IP addresses or ranges that you trust, you can help secure your database from potential threats. Additionally, you can use tools like SSL/TLS to encrypt the connection between your database and client, which can help protect against interception of sensitive data.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_compute_firewall\" \"restricted\" {<br>name    = \"example\"<br>network = \"google_compute_network.vpc.name\"<br><br>allow {<br>protocol = \"tcp\"<br>ports    = [\"3306\"]<br>}<br><br>source_ranges = [\"172.1.2.3/32\"]<br>}<br>"
    },
    "CKV_GCP_106": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-google-compute-firewall-ingress-does-not-allow-unrestricted-http-port-80-access",
        "severity": "LOW",
        "description": "<h4>GCP Firewall rule allows all traffic on HTTP port (80)</h4><h4>Description</h4>You should also consider restricting access to HTTP port 80 to only the IP addresses or ranges that need it. This can help reduce the risk of your network being accessed by unauthorized users or devices, and can also help reduce the risk of attacks such as denial of service (DoS) or distributed denial of service (DDoS) attacks.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_compute_firewall\" \"restricted\" {<br>name    = \"example\"<br>network = \"google_compute_network.vpc.name\"<br><br>allow {<br>protocol = \"tcp\"<br>ports    = [\"80\"]<br>}<br><br>source_ranges = [\"172.1.2.3/32\"]<br>target_tags   = [\"ssh\"]<br>}<br>"
    },
    "CKV_GCP_86": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-cloud-build-workers-are-private",
        "severity": "LOW",
        "description": "<h4>GCP cloud build workers are not private</h4><h4>Description</h4>Google Cloud Build is a fully managed continuous integration and delivery platform that allows developers to build, test, and deploy applications on Google Cloud Platform. When you create a build using Cloud Build, the service automatically provisions a build worker to execute the build.<br>Build workers are virtual machines that are used to run the build steps defined in your build configuration. They are responsible for executing the commands specified in your build configuration, such as building a Docker image, running tests, or deploying an application.<br>Build workers can be either public or private. Public build workers have internet access and can access external resources or services, while private build workers do not have internet access and are isolated from external networks. You can choose which type of worker to use based on your build requirements and the level of security and isolation you need.<br>We recommend you remove the public IPs for your Data Fusion instance. By isolating your build workers from the internet, you can reduce the risk of external threats such as hackers or malware infiltrating your build environment.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_cloudbuild_worker_pool\" \"pass\" {<br>name = \"my-pool\"<br>location = \"europe-west1\"<br>worker_config {<br>disk_size_gb = 100<br>machine_type = \"e2-standard-4\"<br>no_external_ip = true<br>}<br>}<br>"
    },
    "CKV_GCP_85": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-big-table-instances-are-encrypted-with-customer-supplied-encryption-keys-cseks",
        "severity": "LOW",
        "description": "<h4>GCP Big Table Instances are not encrypted with Customer Supplied Encryption Keys (CSEKs)</h4><h4>Description</h4>Customer-Supplied Encryption Keys (CSEK) are a feature in Google Cloud Storage and Google Compute Engine. Google Compute Engine encrypts all data at rest by default. Compute Engine handles and manages this encryption automatically, with no additional action required. When you provide your own encryption keys Compute Engine uses your key to protect the Google-generated keys used to encrypt and decrypt your data. Only users that provide the correct key can use resources protected by a customer-supplied encryption key. Google does not store your keys on its servers and cannot access your protected data unless you provide the key. If you forget or lose your key Google is unable to recover the key or to recover any data encrypted with that key. To control and manage this encryption yourself, you must provide your own encryption keys.<br>We recommend you supply your own encryption keys for Google to use, at a minimum to encrypt business critical Big Table Instances. This helps protect the Google-generated keys used to encrypt and decrypt your data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_bigtable_instance<br>Arguments: cluster.kms_key_name<br><br>Goresource \"google_bigtable_instance\" \"pass\" {<br>name = \"tf-instance\"<br><br>cluster {<br>cluster_id   = \"tf-instance-cluster\"<br>num_nodes    = 1<br>storage_type = \"HDD\"<br>kms_key_name = google_kms_crypto_key.example.name<br>}<br><br>labels = {<br>my-label = \"prod-label\"<br>}<br>}<br>"
    },
    "CKV_GCP_80": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-big-query-tables-are-encrypted-with-customer-supplied-encryption-keys-csek",
        "severity": "LOW",
        "description": "<h4>GCP Big Query Tables are not encrypted with Customer Supplied Encryption Keys (CSEK)</h4><h4>Description</h4>Customer-Supplied Encryption Keys (CSEK) are a feature in Google Cloud Storage and Google Compute Engine. Google Compute Engine encrypts all data at rest by default. Compute Engine handles and manages this encryption automatically, with no additional action required. When you provide your own encryption keys Compute Engine uses your key to protect the Google-generated keys used to encrypt and decrypt your data. Only users that provide the correct key can use resources protected by a customer-supplied encryption key. Google does not store your keys on its servers and cannot access your protected data unless you provide the key. If you forget or lose your key Google is unable to recover the key or to recover any data encrypted with that key. To control and manage this encryption yourself, you must provide your own encryption keys.<br>We recommend you supply your own encryption keys for Google to use, at a minimum to encrypt business critical Big Query Tables. This helps protect the Google-generated keys used to encrypt and decrypt your data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_bigquery_table<br>Arguments: encryption_configuration.kms_key_name<br><br>Goresource \"google_bigquery_table\" \"pass\" {<br>dataset_id = google_bigquery_dataset.default.dataset_id<br>table_id   = \"sheet\"<br><br>external_data_configuration {<br>autodetect    = true<br>source_format = \"GOOGLE_SHEETS\"<br><br>google_sheets_options {<br>skip_leading_rows = 1<br>}<br><br>source_uris = [<br>\"https://docs.google.com/spreadsheets/d/123456789012345\",<br>]<br>}<br><br>encryption_configuration {<br>kms_key_name = var.kms_key_name<br>}<br>}<br>"
    },
    "CKV_GCP_103": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-dataproc-cluster-does-not-have-a-public-ip",
        "severity": "HIGH",
        "description": "<h4>GCP Dataproc Clusters have public IPs</h4><h4>Description</h4>Dataproc is commonly used for data lake modernization, ETL, and data science workloads. A Dataproc cluster contains at least one \"management\" VM and one \"compute\" VM which are deployed into a VPC network. A common misconfiguration is creating a Dataproc cluster with public IPs. This security misconfiguration could put your data at risk of accidental exposure, because a public IP accompanied by an open firewall rule allows potentially unauthorized access to the underlining Dataproc VMs.<br>We recommend you only assign private IPs to your Dataproc clusters.<br><h4>Fix - Runtime</h4>GCP Console<br>It is not currently possible to edit a running Dataproc cluster to remove it's public IPs.<br>To create a Dataproc cluster with only private IPs:<br><br>Log in to the GCP Console.<br>Navigate to Dataproc.<br>Select Customize Cluster to view Network Configuration settings.<br>Locate the Internal IP Only section and select the checkbox next to Configure all instances to have only internal IP addresses<br><br>CLI Command<br>It is not currently possible to edit a running Dataproc cluster to remove it's public IPs.<br>To create a Dataproc cluster with only private IPs you need to specify the --no-address flag. As an example:<br>Shellgcloud beta dataproc clusters create my_cluster  \\<br>--region=us-central1  \\<br>--no-address<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_dataproc_cluster<br>Field: internal_ip_only<br><br>Goresource \"google_dataproc_cluster\" \"accelerated_cluster\" {<br>name   = \"my-cluster-with-gpu\"<br>region = \"us-central1\"<br><br>cluster_config {<br>gce_cluster_config {<br>zone = \"us-central1-a\"<br>-     internal_ip_only = false<br>+     internal_ip_only = true<br>}<br><br>master_config {<br>accelerators {<br>accelerator_type  = \"nvidia-tesla-k80\"<br>accelerator_count = \"1\"<br>}<br>}<br>}<br>}<br>"
    },
    "CKV_GCP_82": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-kms-keys-are-protected-from-deletion",
        "severity": "LOW",
        "description": "<h4>GCP KMS keys are not protected from deletion</h4><h4>Description</h4>Protecting your Google Cloud Platform (GCP) KMS keys from deletion can help ensure the security and integrity of your keys. KMS keys are used to encrypt and decrypt data, and deleting them can cause data loss and disrupt the operation of your systems.<br>By protecting your KMS keys from deletion, you can help prevent accidental or unauthorized deletion of your keys. This can help ensure that your keys are always available when needed, and can help protect your data from potential security threats such as data breaches or unauthorized access.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_kms_crypto_key\" \"pass\" {<br>name            = \"crypto-key-example\"<br>key_ring        = google_kms_key_ring.keyring.id<br>rotation_period = \"15552000s\"<br><br>lifecycle {<br>prevent_destroy = true<br>}<br>}<br>"
    },
    "CKV_GCP_76": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-private-google-access-is-enabled-for-ipv6",
        "severity": "LOW",
        "description": "<h4>GCP VPC Network subnets have Private Google access disabled</h4><h4>Description</h4>Enabling Private Google Access for IPv6 can help improve the security of your Google Cloud Platform (GCP) resources by allowing them to access Google APIs and services over IPv6 networks, rather than over the public internet. This can help reduce the risk of your traffic being intercepted or tampered with, as it is routed through Google's private network. Additionally, Private Google Access can help improve the performance and reliability of your GCP resources by reducing network latency and eliminating the need to route traffic through third-party networks.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_compute_subnetwork\" \"pass_bidi\" {<br>name             = \"log-test-subnetwork\"<br>ip_cidr_range    = \"10.2.0.0/16\"<br>stack_type       = \"IPV4_IPV6\"<br>ipv6_access_type = \"EXTERNAL\"<br>region           = \"us-central1\"<br>network          = google_compute_network.custom-test.id<br># purpose=\"INTERNAL_HTTPS_LOAD_BALANCER\" if set ignored<br># log_config {<br>#   metadata=\"EXCLUDE_ALL_METADATA\"<br># }<br>private_ip_google_access   = true<br>private_ipv6_google_access = \"ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE\"<br>}<br>"
    },
    "CKV_GCP_90": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-data-flow-jobs-are-encrypted-with-customer-supplied-encryption-keys-csek",
        "severity": "LOW",
        "description": "<h4>GCP data flow jobs are not encrypted with Customer Supplied Encryption Keys (CSEK)</h4><h4>Description</h4>Customer-Supplied Encryption Keys (CSEK) are a feature in Google Cloud Storage and Google Compute Engine. Google Compute Engine encrypts all data at rest by default. Compute Engine handles and manages this encryption automatically, with no additional action required. When you provide your own encryption keys Compute Engine uses your key to protect the Google-generated keys used to encrypt and decrypt your data. Only users that provide the correct key can use resources protected by a customer-supplied encryption key. Google does not store your keys on its servers and cannot access your protected data unless you provide the key. If you forget or lose your key Google is unable to recover the key or to recover any data encrypted with that key. To control and manage this encryption yourself, you must provide your own encryption keys.<br>We recommend you supply your own encryption keys for Google to use, at a minimum to encrypt business critical data flow jobs. This helps protect the Google-generated keys used to encrypt and decrypt your data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_dataflow_job<br>Arguments: kms_key_name<br><br>Goresource \"google_dataflow_job\" \"pass\" {<br>name              = \"dataflow-job\"<br>template_gcs_path = \"gs://my-bucket/templates/template_file\"<br>temp_gcs_location = \"gs://my-bucket/tmp_dir\"<br>parameters = {<br>foo = \"bar\"<br>baz = \"qux\"<br>}<br>kms_key_name = \"SecretSquirrel\"<br>}<br>"
    },
    "CKV2_GCP_2": {
        "url": "https://docs.bridgecrew.io/docs/ensure-legacy-networks-do-not-exist-for-a-project",
        "severity": "MEDIUM",
        "description": "<h4>GCP project is configured with legacy network</h4><h4>Description</h4>In order to prevent use of legacy networks, a project should not have a legacy network configured.<br>Legacy networks have a single network IPv4 prefix range and a single gateway IP address for the whole network. The network is global in scope and spans all cloud regions. Subnetworks cannot be created in a legacy network and are unable to switch from legacy to auto or custom subnet networks. Legacy networks can have an impact for high network traffic projects and are subject to a single point of contention or failure.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_project<br>Argument: google_compute_network<br><br>Goresource \"google_project\" \"bad_project\" {<br>name       = \"My Project\"<br>project_id = \"bad\"<br>org_id     = \"1234567\"<br>}<br><br>resource \"google_compute_network\" \"vpc_network_bad\" {<br>name = \"vpc-legacy\"<br>- auto_create_subnetworks = true<br>project = google_project.bad_project.id<br>}<br>"
    },
    "CKV_GCP_104": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-datafusion-has-stack-driver-logging-enabled",
        "severity": "LOW",
        "description": "<h4>GCP DataFusion does not have stack driver logging enabled</h4><h4>Description</h4>It is recommended to have a proper logging process for GCP DataFusion stack driver in order to track configuration changes conducted manually and programmatically and trace back unapproved changes.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_data_fusion_instance\" \"pass\" {<br>project                       = \"examplea\"<br>provider                      = google-beta<br>name                          = \"my-instance\"<br>description                   = \"My Data Fusion instance\"<br>region                        = \"us-central1\"<br>type                          = \"BASIC\"<br>enable_stackdriver_logging    = true<br>enable_stackdriver_monitoring = true<br>labels = {<br>example_key = \"example_value\"<br>}<br>//private_instance = false<br>network_config {<br>network       = \"default\"<br>ip_allocation = \"10.89.48.0/22\"<br>}<br>version                  = \"6.3.0\"<br>dataproc_service_account = data.google_app_engine_default_service_account.default.email<br>}<br>"
    },
    "CKV_GCP_83": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-pubsub-topics-are-encrypted-with-customer-supplied-encryption-keys-csek",
        "severity": "LOW",
        "description": "<h4>GCP Pub/Sub Topics are not encrypted with Customer Supplied Encryption Keys (CSEK)</h4><h4>Description</h4>Customer-Supplied Encryption Keys (CSEK) are a feature in Google Cloud Storage and Google Compute Engine. Google Compute Engine encrypts all data at rest by default. Compute Engine handles and manages this encryption automatically, with no additional action required. When you provide your own encryption keys Compute Engine uses your key to protect the Google-generated keys used to encrypt and decrypt your data. Only users that provide the correct key can use resources protected by a customer-supplied encryption key. Google does not store your keys on its servers and cannot access your protected data unless you provide the key. If you forget or lose your key Google is unable to recover the key or to recover any data encrypted with that key. To control and manage this encryption yourself, you must provide your own encryption keys.<br>We recommend you supply your own encryption keys for Google to use, at a minimum to encrypt business critical Pub/Sub Topics. This helps protect the Google-generated keys used to encrypt and decrypt your data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_pubsub_topic<br>Arguments: kms_key_name<br><br>Goresource \"google_pubsub_topic\" \"pass\" {<br>name         = \"example-topic\"<br>kms_key_name = google_kms_crypto_key.crypto_key.id<br>}<br>"
    },
    "CKV_GCP_75": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-google-compute-firewall-ingress-does-not-allow-unrestricted-ftp-access",
        "severity": "LOW",
        "description": "<h4>GCP Firewall rule allows all traffic on FTP port (21)</h4><h4>Description</h4><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Go# pass<br><br>resource \"google_compute_firewall\" \"restricted\" {<br>name    = \"example\"<br>network = \"google_compute_network.vpc.name\"<br><br>allow {<br>protocol = \"tcp\"<br>ports    = [\"21\"]<br>}<br><br>source_ranges = [\"172.1.2.3/32\"]<br>target_tags   = [\"ftp\"]<br>}<br>"
    },
    "CKV_GCP_105": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-datafusion-has-stack-driver-monitoring-enabled",
        "severity": "LOW",
        "description": "<h4>GCP DataFusion does not have stack driver monitoring enabled</h4><h4>Description</h4>Enabling Stackdriver monitoring for your Google Cloud Platform (GCP) DataFusion instance can help improve the security and management of your data. Stackdriver is a monitoring and logging service that allows you to track the performance and health of your GCP resources.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_data_fusion_instance\" \"pass\" {<br>project                       = \"examplea\"<br>provider                      = google-beta<br>name                          = \"my-instance\"<br>description                   = \"My Data Fusion instance\"<br>region                        = \"us-central1\"<br>type                          = \"BASIC\"<br>enable_stackdriver_logging    = true<br>enable_stackdriver_monitoring = true<br>labels = {<br>example_key = \"example_value\"<br>}<br>//private_instance = false<br>network_config {<br>network       = \"default\"<br>ip_allocation = \"10.89.48.0/22\"<br>}<br>version                  = \"6.3.0\"<br>dataproc_service_account = data.google_app_engine_default_service_account.default.email<br>}<br>"
    },
    "CKV_GCP_91": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-dataproc-cluster-is-encrypted-with-customer-supplied-encryption-keys-cseks",
        "severity": "LOW",
        "description": "<h4>GCP Dataproc cluster is not encrypted with Customer Supplied Encryption Keys (CSEKs)</h4><h4>Description</h4>Customer-Supplied Encryption Keys (CSEK) are a feature in Google Cloud Storage and Google Compute Engine. Google Compute Engine encrypts all data at rest by default. Compute Engine handles and manages this encryption automatically, with no additional action required. When you provide your own encryption keys Compute Engine uses your key to protect the Google-generated keys used to encrypt and decrypt your data. Only users that provide the correct key can use resources protected by a customer-supplied encryption key. Google does not store your keys on its servers and cannot access your protected data unless you provide the key. If you forget or lose your key Google is unable to recover the key or to recover any data encrypted with that key. To control and manage this encryption yourself, you must provide your own encryption keys.<br>We recommend you supply your own encryption keys for Google to use, at a minimum to encrypt business critical Dataproc cluster. This helps protect the Google-generated keys used to encrypt and decrypt your data.<br><h4>Fix - Runtime</h4>TBD<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource:google_dataproc_cluster<br>Arguments: cluster_config.encryption_config.kms_key_name<br><br>Goresource \"google_dataproc_cluster\" \"pass\" {<br>name   = \"simplecluster\"<br>region = \"us-central1\"<br>cluster_config {<br>encryption_config{<br>kms_key_name=\"SecretSquirrel\"<br>}<br>}<br>}<br>"
    },
    "CKV_GCP_81": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-big-query-tables-are-encrypted-with-customer-supplied-encryption-keys-csek-1",
        "severity": "LOW",
        "description": "<h4>GCP Big Query Tables are not encrypted with Customer Supplied Encryption Keys (CSEK)</h4><h4>Description</h4>Customer-Supplied Encryption Keys (CSEK) are a feature in Google Cloud Storage that is available for Big Query Tables. Google does not store your keys on its servers and cannot access your protected data unless you provide the key. If you forget or lose your key Google is unable to recover the key or to recover any data encrypted with that key. To control and manage this encryption yourself, you must provide your own encryption keys.<br>We recommend you supply your own encryption keys for Google to use, at a minimum to encrypt business critical Big Query Tables. This helps protect the Google-generated keys used to encrypt and decrypt your data.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_bigquery_dataset\" \"pass\" {<br>dataset_id                  = var.dataset.dataset_id<br>friendly_name               = var.dataset.friendly_name<br>description                 = var.dataset.description<br>location                    = var.location<br>default_table_expiration_ms = var.dataset.default_table_expiration_ms<br><br>default_encryption_configuration {<br>kms_key_name = google_kms_crypto_key.example.name<br>}<br>}<br>"
    },
    "CKV_GCP_97": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-memorystore-for-redis-uses-intransit-encryption",
        "severity": "LOW",
        "description": "<h4>GCP Memorystore for Redis does not use intransit encryption</h4><h4>Description</h4>This policy identifies the GCP Memorystore for Redis that are configured with disabled in-transit data encryption. It is recommended that these resources will be configured with in-transit data encryption to minimize risk for sensitive data being leaked.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goesource \"google_redis_instance\" \"pass\" {<br>provider       = google-beta<br>name           = \"mrr-memory-cache\"<br>tier           = \"STANDARD_HA\"<br>memory_size_gb = 5<br><br>location_id             = \"us-central1-a\"<br>alternative_location_id = \"us-central1-f\"<br><br>authorized_network = data.google_compute_network.redis-network.id<br><br>redis_version      = \"REDIS_6_X\"<br>display_name       = \"Terraform Test Instance\"<br>reserved_ip_range  = \"192.168.0.0/28\"<br>replica_count      = 5<br>read_replicas_mode = \"READ_REPLICAS_ENABLED\"<br># auth_enabled=true<br>labels = {<br>my_key    = \"my_val\"<br>other_key = \"other_val\"<br>}<br>transit_encryption_mode = \"SERVER_AUTHENTICATION\"<br>}<br>"
    },
    "CKV_GCP_74": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-subnet-has-a-private-ip-google-access",
        "severity": "LOW",
        "description": "<h4>GCP subnet does not have a private IP Google access</h4><h4>Description</h4>Enabling private IP Google access for your Google Cloud Platform (GCP) subnet can help improve the security and performance of your network. Private IP Google access allows resources in your subnet to access Google APIs and services over a private IP connection, rather than a public connection.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_compute_subnetwork\" \"pass\" {<br>name          = \"example\"<br>ip_cidr_range = \"10.0.0.0/16\"<br>network       = \"google_compute_network.vpc.self_link\"<br><br>log_config {<br>aggregation_interval = \"INTERVAL_10_MIN\"<br>flow_sampling        = 0.5<br>metadata             = \"INCLUDE_ALL_METADATA\"<br>}<br>private_ip_google_access = true<br>}<br>"
    },
    "CKV_GCP_87": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-data-fusion-instances-are-private",
        "severity": "LOW",
        "description": "<h4>GCP data fusion instances are not private</h4><h4>Description</h4>GCP Data fusion is a fully managed, cloud-native data integration service that helps users build and manage ETL (extract, transform, and load) pipelines. It is designed to simplify and accelerate the process of building and maintaining data pipelines, allowing users to create data pipelines that can ingest data from a variety of sources, transform and cleanse the data, and then load the data into a destination of their choice.<br>A Data Fusion instance is a logical container that is used to host and run data pipelines. It is created within a Google Cloud project, and users can create multiple instances within a single project. Each instance has its own resources and configuration settings, allowing users to tailor the instance to their specific needs.<br>We recommend you remove the public IPs for your Data Fusion instance.<br><h4>Fix - Runtime</h4><h4>Fix - Buildtime</h4>Terraform<br>Goresource \"google_data_fusion_instance\" \"pass\" {<br>provider = google-beta<br>name = \"my-instance\"<br>description = \"My Data Fusion instance\"<br>region = \"us-central1\"<br>type = \"BASIC\"<br>enable_stackdriver_logging = true<br>enable_stackdriver_monitoring = true<br>labels = {<br>example_key = \"example_value\"<br>}<br>private_instance = true<br>network_config {<br>network = \"default\"<br>ip_allocation = \"10.89.48.0/22\"<br>}<br>version = \"6.3.0\"<br>dataproc_service_account = data.google_app_engine_default_service_account.default.email<br>}<br>"
    },
    "CKV_GCP_102": {
        "url": "https://docs.bridgecrew.io/docs/ensure-cloud-run-service-is-not-anonymously-or-publicly-accessible",
        "severity": "MEDIUM",
        "description": "<h4>GCP Cloud Run services are anonymously or publicly accessible</h4><h4>Description</h4>Cloud Run services are fully managed serverless environments used to develop and deploy containerized applications. In GCP, Cloud Run services support a wide variety of authentication methods to execute (invoke) the container. One of those methods is based to the usage of two special IAM principals: allUsers and allAuthenticatedUsers. When those IAM principals have access to the Cloud Run service - anyone on the internet can execute or access the Cloud Run service.<br>We recommend you ensure that neither anonymous or public access to Cloud Run services are allowed.<br><h4>Fix - Runtime</h4>GCP Console<br>To remove anonymous or public access to your Cloud Run service:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Cloud Run.<br>View your service's Service details page by clicking on your Service Name.<br>Select the PERMISSIONS tab.<br>To remove a specific role assignment, select allUsers or allAuthenticatedUsers, and then click Delete.<br><br>CLI Command<br>To remove anonymous or public access to your Cloud Run service execute the following command:<br>Shellgcloud run services remove-iam-policy-binding SERVICE-NAME \\<br>--member=MEMBER-TYPE \\<br>--role=ROLE<br><br>Replace SERVICE-NAME with your Cloud Run service name. Replace MEMBER-TYPE with the member you want to delete (either allUsers or allAuthenticatedUsers). Replace ROLE the IAM member's assigned role.<br><h4>Fix - Buildtime</h4>Terraform<br><br><br>Resource: google_cloud_run_service_iam_binding<br><br><br>Field: members<br><br><br>Resource: google_cloud_run_service_iam_member<br><br><br>Field: member<br><br><br>Goresource \"google_cloud_run_service_iam_binding\" \"public_binding\" {<br>location = google_cloud_run_service.default.location<br>service = google_cloud_run_service.default.name<br>role = \"roles/run.invoker\"<br><br>members = [<br>-    \"allUsers\",<br>-    \"allAuthenticatedUsers\",<br>]<br>}<br><br>resource \"google_cloud_run_service_iam_member\" \"public_member\" {<br>location = google_cloud_run_service.default.location<br>service = google_cloud_run_service.default.name<br>role = \"roles/run.invoker\"<br><br>-  member = \"allUsers\"<br>-  member = \"allAuthenticatedUsers\"<br>}<br>"
    },
    "CKV2_GCP_8": {
        "url": "https://docs.bridgecrew.io/docs/ensure-gcp-cloud-kms-key-rings-is-not-publicly-accessible-1",
        "severity": "HIGH",
        "description": "<h4>GCP Cloud KMS Key Rings are anonymously or publicly accessible</h4><h4>Description</h4>GCP Cloud KMS key rings contain your encryption keys, and allowing anonymous or public access to a key ring grants permissions for anyone to access the cryptokeys stored inside the ring. CryptoKeys should only be accessed by trusted parties because they are commonly used to protect sensitive data.<br>\u200b<br>We recommend you ensure anonymous and public access to KMS key rings is not allowed.<br><h4>Fix - Runtime</h4>GCP Console<br>To change the policy using the GCP Console, follow these steps:<br><br>Log in to the GCP Console at https://console.cloud.google.com.<br>Navigate to Key Management.<br>On the Key Rings details page, select your key ring.<br>Click the SHOW INFO PANEL side bar.<br>To remove a specific role assignment, to the front of allUsers and allAuthenticatedUsers, click Delete.<br><br>CLI Command<br>To remove access to allUsers and allAuthenticatedUsers, use the following command:<br>gcloud kms keyrings remove-iam-policy-binding KEY-RING \\<br>--location LOCATION \\<br>--member PRINCIPAL \\<br>--role roles/ROLE-NAME<br><br>Replace KEY-RING with the name of the key ring. Replace LOCATION with the location of the key ring. Replace PRINCIPAL with either allUsers or allAuthenticatedUsers. Replace ROLE-NAME with the name of the role to remove.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: google_kms_key_ring_iam_member<br>Field: member<br>\u200b<br>Resource: google_kms_key_ring_iam_binding<br>Field: members<br><br>Text//Option 1<br>resource \"google_kms_key_ring_iam_member\" \"member\" {<br>key_ring_id = google_kms_key_ring.default.id<br>role          = \"roles/cloudkms.cryptoKeyEncrypter\"<br>-  member        = \"allUsers\"<br>-  member        = \"allAuthenticatedUsers\"<br>}<br>\u200b<br>//Option 2<br>resource \"google_kms_key_ring_iam_binding\" \"binding\" {<br>key_ring_id = google_kms_key_ring.default.id<br>role          = \"roles/cloudkms.cryptoKeyEncrypter\"<br>members = [<br>-    \"allUsers\",<br>-    \"allAuthenticatedUsers\"<br>]<br>}<br>"
    },
    "CKV2_AZURE_5": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-va-setting-also-send-email-notifications-to-admins-and-subscription-owners-is-set-for-an-sql-server",
        "severity": "LOW",
        "description": "<h4>Azure SQL server ADS VA Also send email notifications to admins and subscription owners is disabled</h4><h4>Description</h4>Enable Vulnerability Assessment (VA) setting 'Also send email notifications to admins and subscription owners'.<br>VA scan reports and alerts will be sent to admins and subscription owners by enabling setting 'Also send email notifications to admins and subscription owners'. This may help in reducing time required for identifying risks and taking corrective measures.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_resource_group, azurerm_sql_server, azurerm_storage_account, azurerm_storage_container, azurerm_mssql_server_security_alert_policy, azurerm_mssql_server_vulnerability_assessment<br><br>Goresource \"azurerm_resource_group\" \"okExample\" {<br>name     = \"okExample-resources\"<br>location = \"West Europe\"<br>}<br><br>resource \"azurerm_sql_server\" \"okExample\" {<br>name                         = \"mysqlserver\"<br>resource_group_name          = azurerm_resource_group.okExample.name<br>location                     = azurerm_resource_group.okExample.location<br>version                      = \"12.0\"<br>administrator_login          = \"4dm1n157r470r\"<br>administrator_login_password = \"4-v3ry-53cr37-p455w0rd\"<br>}<br><br>resource \"azurerm_storage_account\" \"okExample\" {<br>name                     = \"accteststorageaccount\"<br>resource_group_name      = azurerm_resource_group.okExample.name<br>location                 = azurerm_resource_group.okExample.location<br>account_tier             = \"Standard\"<br>account_replication_type = \"GRS\"<br>}<br><br>resource \"azurerm_storage_container\" \"okExample\" {<br>name                  = \"accteststoragecontainer\"<br>storage_account_name  = azurerm_storage_account.okExample.name<br>container_access_type = \"private\"<br>}<br><br>resource \"azurerm_mssql_server_security_alert_policy\" \"okExample\" {<br>resource_group_name = azurerm_resource_group.okExample.name<br>server_name         = azurerm_sql_server.okExample.name<br>state               = \"Enabled\"<br>}<br><br>resource \"azurerm_mssql_server_vulnerability_assessment\" \"okExample\" {<br>server_security_alert_policy_id = azurerm_mssql_server_security_alert_policy.okExample.id<br>storage_container_path          = \"${azurerm_storage_account.okExample.primary_blob_endpoint}${azurerm_storage_container.okExample.name}/\"<br>storage_account_access_key      = azurerm_storage_account.okExample.primary_access_key<br><br>recurring_scans {<br>enabled                   = true<br>email_subscription_admins = true<br>emails = [<br>\"[email\u00a0protected]\",<br>\"[email\u00a0protected]\"<br>]<br>}<br>}<br>"
    },
    "CKV2_AZURE_4": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-va-setting-send-scan-reports-to-is-configured-for-a-sql-server",
        "severity": "LOW",
        "description": "<h4>Azure SQL server ADS VA Send scan reports to is not configured</h4><h4>Description</h4>Configure 'Send scan reports to' with email ids of concerned data owners/stakeholders for a critical SQL servers.<br>Vulnerability Assessment (VA) scan reports and alerts will be sent to email ids configured at Send scan reports to. This may help in reducing time required for identifying risks and taking corrective measures.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_resource_group, azurerm_sql_server, azurerm_storage_account, azurerm_storage_container, azurerm_mssql_server_security_alert_policy, azurerm_mssql_server_vulnerability_assessment<br><br>Goresource \"azurerm_resource_group\" \"okExample\" {<br>name     = \"okExample-resources\"<br>location = \"West Europe\"<br>}<br><br>resource \"azurerm_sql_server\" \"okExample\" {<br>name                         = \"mysqlserver\"<br>resource_group_name          = azurerm_resource_group.okExample.name<br>location                     = azurerm_resource_group.okExample.location<br>version                      = \"12.0\"<br>administrator_login          = \"4dm1n157r470r\"<br>administrator_login_password = \"4-v3ry-53cr37-p455w0rd\"<br>}<br><br>resource \"azurerm_storage_account\" \"okExample\" {<br>name                     = \"accteststorageaccount\"<br>resource_group_name      = azurerm_resource_group.okExample.name<br>location                 = azurerm_resource_group.okExample.location<br>account_tier             = \"Standard\"<br>account_replication_type = \"GRS\"<br>}<br><br>resource \"azurerm_storage_container\" \"okExample\" {<br>name                  = \"accteststoragecontainer\"<br>storage_account_name  = azurerm_storage_account.okExample.name<br>container_access_type = \"private\"<br>}<br><br>resource \"azurerm_mssql_server_security_alert_policy\" \"okExample\" {<br>resource_group_name = azurerm_resource_group.okExample.name<br>server_name         = azurerm_sql_server.okExample.name<br>state               = \"Enabled\"<br>}<br><br>resource \"azurerm_mssql_server_vulnerability_assessment\" \"okExample\" {<br>server_security_alert_policy_id = azurerm_mssql_server_security_alert_policy.okExample.id<br>storage_container_path          = \"${azurerm_storage_account.okExample.primary_blob_endpoint}${azurerm_storage_container.okExample.name}/\"<br>storage_account_access_key      = azurerm_storage_account.okExample.primary_access_key<br><br>recurring_scans {<br>enabled                   = true<br>email_subscription_admins = true<br>emails = [<br>\"[email\u00a0protected]\",<br>\"[email\u00a0protected]\"<br>]<br>}<br>}<br>"
    },
    "CKV_AZURE_23": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_logging_2",
        "severity": "HIGH",
        "description": "<h4>Azure SQL server auditing is disabled</h4><h4>Description</h4>The Azure platform allows a SQL server to be created as a service. Auditing tracks database events and writes them to an audit log in the Azure storage account. It also helps to maintain regulatory compliance, understand database activity, and gain insight into discrepancies and anomalies that could indicate business concerns or suspected security violations.<br>We recommend you enable auditing at the server level, ensuring all existing and newly created databases on the SQL server instance are audited.<br>\ud83d\udcd8NoteAn auditing policy applied to a SQL database does not override an auditing policy or settings applied on the SQL server where the database is hosted.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to SQL servers.<br>For each server instance:<br>a) Click Auditing.<br>b) Set Auditing to On.<br><br>CLI Command<br>To get the list of all SQL Servers, use the following command:<br>Get-AzureRmSqlServer<br>To enable auditing for each Server, use the following command:<br>Set-AzureRmSqlServerAuditingPolicy<br>-ResourceGroupName <resource group name><br>-ServerName <server name><br>-AuditType <audit type><br>-StorageAccountName <storage account name><br><br><h4>Fix - Buildtime</h4>ARM<br><br>Resource: Microsoft.Sql/servers/databases<br><br>JSON{<br>\"type\": \"Microsoft.Sql/servers\",<br>\"apiVersion\": \"2019-06-01-preview\",<br>\"location\": \"[parameters('location')]\",<br>\"name\": \"[parameters('sqlServerName')]\",<br>\"identity\": \"[if(parameters('isStorageBehindVnet'), json('{\\\"type\\\":\\\"SystemAssigned\\\"}'), json('null'))]\",<br>\"properties\": {<br>\"administratorLogin\": \"[parameters('sqlAdministratorLogin')]\",<br>\"administratorLoginPassword\": \"[parameters('sqlAdministratorLoginPassword')]\",<br>\"version\": \"12.0\"<br>},<br>\"tags\": {<br>\"displayName\": \"[parameters('sqlServerName')]\"<br>},<br>\"resources\": [<br>{<br>\"type\": \"auditingSettings\",<br>\"apiVersion\": \"2019-06-01-preview\",<br>\"name\": \"DefaultAuditingSettings\",<br>\"dependsOn\": [<br>\"[parameters('sqlServerName')]\",<br>\"[parameters('storageAccountName')]\",<br>\"[extensionResourceId(resourceId('Microsoft.Storage/storageAccounts', parameters('storageAccountName')), 'Microsoft.Authorization/roleAssignments/', variables('uniqueRoleGuid'))]\"<br>],<br>\"properties\": {<br>+       \"state\": \"Enabled\",<br>\"storageEndpoint\": \"[reference(resourceId('Microsoft.Storage/storageAccounts', parameters('storageAccountName')), '2019-06-01').PrimaryEndpoints.Blob]\",<br>\"storageAccountAccessKey\": \"[if(parameters('isStorageBehindVnet'), json('null'), listKeys(resourceId('Microsoft.Storage/storageAccounts', parameters('storageAccountName')), '2019-06-01').keys[0].value)]\",<br>\"storageAccountSubscriptionId\": \"[subscription().subscriptionId]\",<br>\"isStorageSecondaryKeyInUse\": false<br>}<br>}<br>]<br>}<br><br>Terraform<br><br>Resource: azurerm_sql_server, azurerm_mssql_server<br>Field: extended_auditing_policy<br><br>Goresource \"azurerm_sql_server\" \"example\" {<br>...<br>+   extended_auditing_policy {<br>storage_endpoint           = azurerm_storage_account.example.primary_blob_endpoint<br>storage_account_access_key = azurerm_storage_account.example.primary_access_key<br>storage_account_access_key_is_secondary = true<br>retention_in_days                       = 90<br>}<br>}<br>"
    },
    "CKV_AZURE_1": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_networking_1",
        "severity": "HIGH",
        "description": "<h4>Azure instance does not authenticate using SSH keys</h4><h4>Description</h4>SSH is an encrypted connection protocol that allows secure sign-ins over unsecured connections. SSH is the default connection protocol for Linux VMs hosted in Azure. Using secure shell (SSH) key pair, it is possible to spin up a Linux virtual machine on Azure that defaults to using SSH keys for authentication, eliminating the need for passwords to sign in.<br>We recommend connecting to a VM using SSH keys. Using basic authentication with SSH connections leaves VMs vulnerable to brute-force attacks or guessing of passwords.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Enter virtual machines in the search bar.<br>Under Services, select Virtual machines.<br>Under Administrator account, select SSH public key.<br>For SSH public key source, use the default Generate new key pair, then for Key pair name enter myKey.<br>Under Inbound port rules > Public inbound ports, select Allow selected ports, then select SSH (22) and HTTP (80) from the drop-down.<br>Leave the remaining defaults settings. At the bottom of the page click Review + create.<br><br>CLI Command<br>The --generate-ssh-keys parameter is used to automatically generate an SSH key, and put it in the default key location (~/.ssh).<br>Shellaz vm create \\<br>--resource-group myResourceGroup \\<br>--name myVM \\<br>--image UbuntuLTS \\<br>--admin-username azureuser \\<br>--generate-ssh-keys<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_linux_virtual_machine<br>Argument: admin_ssh_key<br><br>Goresource \"azurerm_linux_virtual_machine\" \"example\" {<br>...<br><br>+  admin_ssh_key {<br>username   = \"adminuser\"<br>public_key = file(\"~/.ssh/id_rsa.pub\")<br>}<br><br>ARM Template<br><br>Resource: Microsoft.Compute/virtualMachines<br>Argument: disablePasswordAuthentication<br><br>Go...<br>\"linuxConfiguration\": {<br>+       \"disablePasswordAuthentication\": \"true\",<br>\"ssh\": {<br>\"publicKeys\": [<br>{<br>\"path\": \"string\",<br>\"keyData\": \"string\"<br>}<br>]<br>...<br>"
    },
    "CKV_AZURE_9": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_networking_2",
        "severity": "CRITICAL",
        "description": "<h4>RDP Internet access is not restricted</h4><h4>Description</h4>A potential security problem using RDP over the Internet is that attackers can use various brute force techniques to gain access to Azure Virtual Machines. Once the attackers gain access, they can use a virtual machine as a launch point for compromising other machines on the Azure Virtual Network. The attackers could also access and attack networked devices outside of Azure.<br>We recommend you disable RDP access over the internet to Network Security Groups.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>For each VM, open the Networking blade.<br>Verify that the INBOUND PORT RULES does not have a rule for RDP. For example:<br><br><br>Port = 3389<br>Protocol = TCP<br>Source = Any OR Internet<br><br>CLI Command<br>To list Network Security Groups with the corresponding non-default Security rules, use the following command:<br>az network nsg list --query [*].[name,securityRules]<br>Ensure that the NSGs do not have any of the following security rules:<br><br>\"access\" : \"Allow\"<br>\"destinationPortRange\" : \"3389\" or \"*\" or \"[port range containing 3389]\"<br>\"direction\" : \"Inbound\"<br>\"protocol\" : \"TCP\"<br>\"sourceAddressPrefix\" : \"*\" or \"0.0.0.0\" or \"/0\" or \"/0\" or \"internet\" or \"any\"<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_network_security_rule<br>Argument: access + protocol + destination_port_range + source_address_prefix<br><br>Goresource \"azurerm_network_security_rule\" \"example\" {<br>...<br>-    access                      = \"Allow\"<br>-    protocol                    = \"TCP\"<br>-    destination_port_range      = [\"3389\" / <port range including 3389>]]<br>-    source_address_prefix       = \"*\" / \"0.0.0.0\" / \"<nw>/0\" / \"/0\" / \"internet\" / \"any\"<br>...<br>}<br>"
    },
    "CKV_AZURE_10": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_networking_3",
        "severity": "CRITICAL",
        "description": "<h4>SSH Internet access is not restricted</h4><h4>Description</h4>A potential security problem using SSH over the Internet is that attackers can use various brute force techniques to gain access to Azure Virtual Machines. Once the attackers gain access, they can use a virtual machine as a launch point for compromising other machines on the Azure Virtual Network. The attackers could also access and attack networked devices outside of Azure.<br>We recommend you disable SSH access over the internet to Network Security Groups.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>For each VM, open the Networking blade.<br>Verify that the INBOUND PORT RULES does not have a rule for SSH. For example:<br><br><br>Port = 22<br>Protocol = TCP<br>Source = Any OR Internet<br><br>CLI Command<br>To list Network Security Groups with corresponding non-default Security rules, use the following command:<br>az network nsg list --query [*].[name,securityRules]<br>Ensure that the NSGs do not have any of the following security rules:<br><br>\"access\" : \"Allow\"<br>\"destinationPortRange\" : \"22\" or \"*\" or \"[port range containing 22]\"<br>\"direction\" : \"Inbound\"<br>\"protocol\" : \"TCP\"<br>\"sourceAddressPrefix\" : \"*\" or \"0.0.0.0\" or \"/0\" or \"/0\" or \"internet\" or \"any\"<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_network_security_rule<br>Arguments: access + protocol + destination_port_range + source_address_prefix<br><br>Goresource \"azurerm_network_security_rule\" \"example\" {<br>-    access                      = \"Allow\"<br>-    protocol                    = \"TCP\"<br>-    destination_port_range      = [\"22\" / <port range including 22>]]<br>-    source_address_prefix       = \"*\" / \"0.0.0.0\" / \"<nw>/0\" / \"/0\" / \"internet\" / \"any\"<br>}<br>"
    },
    "CKV_AZURE_11": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_networking_4",
        "severity": "CRITICAL",
        "description": "<h4>SQL databases allow ingress from 0.0.0.0/0</h4><h4>Description</h4>SQL Server includes a firewall to block access to unauthorized connections. More granular IP addresses can be defined by referencing the range of addresses available from specific datacenters.<br>The SQL server default Firewall exists with StartIp of 0.0.0.0 and EndIP of 0.0.0.0, allowing access to all Azure services. A custom rule can be set with StartIp of 0.0.0.0 and EndIP of 255.255.255.255, allowing access from any IP over the Internet. To reduce the potential attack surface for a SQL server, firewall rules should be defined with more granular IP addresses. This is achieved by referencing the range of addresses available from specific datacenters.<br>We recommend SQL Databases do not allow ingress from 0.0.0.0/0, that is, any IP.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to SQL servers.<br>For each SQL server:<br>a) Click Firewall / Virtual Networks.<br>b) Set Allow access to Azure services to OFF.<br>c) Set firewall rules to limit access to authorized connections.<br><br>CLI Command<br>To disable default Firewall rule Allow access to Azure services, use the following commands:<br>Remove-AzureRmSqlServerFirewallRule -FirewallRuleName<br>\"AllowAllWindowsAzureIps\"<br>-ResourceGroupName <resource group name><br>-ServerName <server name><br><br>To remove a custom Firewall rule, use the following command:<br>Remove-AzureRmSqlServerFirewallRule<br>-FirewallRuleName \"<firewallRuleName>\"<br>-ResourceGroupName <resource group name><br>-ServerName <server name><br><br>To set the appropriate firewall rules, use the following command:<br>Set-AzureRmSqlServerFirewallRule<br>-ResourceGroupName <resource group name><br>-ServerName <server name><br>-FirewallRuleName \"<Fw rule Name>\"<br>-StartIpAddress \"<IP Address other than 0.0.0.0>\"<br>-EndIpAddress \"<IP Address other than0.0.0.0 or 255.255.255.255>\"<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resources:<br>azurerm_mariadb_firewall_rule<br>azurerm_sql_firewall_rule<br>azurerm_postgresql_firewall_rule<br>azurerm_mysql_firewall_rule<br>Argument: start_ip_address<br><br>Goresource \"azurerm_mysql_firewall_rule\" \"example\" {<br>...<br>-   start_ip_address    = \"0.0.0.0\"<br>-   end_ip_address      = \"255.255.255.255\"<br>}<br>"
    },
    "CKV_AZURE_14": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_networking_5",
        "severity": "MEDIUM",
        "description": "<h4>Azure App Service Web app does not redirect HTTP to HTTPS</h4><h4>Description</h4>Azure Web Apps by default allows sites to run under both HTTP and HTTPS, and can be accessed by anyone using non-secure HTTP links. Non-secure HTTP requests can be restricted and all HTTP requests redirected to the secure HTTPS port.<br>We recommend you enforce HTTPS-only traffic to increase security. This will redirect all non-secure HTTP requests to HTTPS ports. HTTPS uses the SSL/TLS protocol to provide a secure connection, which is both encrypted and authenticated.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to App Services.<br>For each App, click App.<br>a) Navigate to the Setting section.<br>b) Click SSL settings.<br>c) Navigate to the Protocol Settings section.<br>d) Set HTTPS Only to On.<br><br>CLI Command<br>To set HTTPS-only traffic for an existing app, use the following command:<br>az webapp update<br>--resource-group <RESOURCE_GROUP_NAME><br>--name <APP_NAME><br>--set httpsOnly=false<br><br><h4>Fix - Buildtime</h4>Terraform<br>Resource: azurerm_app_service<br>Argument: https_only<br>Goresource \"azurerm_app_service\" \"example\" {<br>...<br>+   https_only          = true<br>}<br>"
    },
    "CKV_AZURE_15": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_networking_6",
        "severity": "MEDIUM",
        "description": "<h4>Web App does not use the latest version of TLS encryption</h4><h4>Description</h4>The Transport Layer Security (TLS) protocol secures transmission of data over the internet using standard encryption technology. Encryption should be set with the latest version of TLS. App service allows TLS 1.2 by default, which is the recommended TLS level by industry standards, for example, PCI DSS.<br>App service currently allows the web app to set TLS versions 1.0, 1.1 and 1.2. For secure web app connections it is highly recommended to only use the latest TLS 1.2 version.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to App Services.<br>For each Web App, click App.<br>a) Navigate to Setting section.<br>b) Click SSL Settings.<br>c)  Navigate to Protocol Settings section.<br>d) Set Minimum TLS Version to 1.2.<br><br>CLI Command<br>To set TLS Version for an existing app, use the following command:<br>az webapp config set<br>--resource-group <RESOURCE_GROUP_NAME><br>--name <APP_NAME><br>--min-tls-version 1.2<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_app_service<br>Argument: min_tls_version<br><br>Goresource \"azurerm_app_service\" \"example\" {<br>...<br>-   min_tls_version = <version><br>}<br>}<br>"
    },
    "CKV_AZURE_17": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_networking_7",
        "severity": "MEDIUM",
        "description": "<h4>Azure App Service Web app client certificate is disabled</h4><h4>Description</h4>Client certificates allow the Web App to require a certificate for incoming requests. Only clients that have a valid certificate will be able to reach the app.<br>The TLS mutual authentication technique in enterprise environments ensures the authenticity of clients to the server. If incoming client certificates are enabled only an authenticated client with valid certificates can access the app.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to App Services.<br>For each Web App, click App.<br>a) Navigate to Setting section.<br>b) Click SSL Settings.<br>c)  Navigate to Protocol Settings section.<br>d) Set Incoming client certificates to On.<br><br>CLI Command<br>To set Incoming client certificates value for an existing app, use the following command:<br>az webapp update<br>--resource-group <RESOURCE_GROUP_NAME><br>--name <APP_NAME><br>--set clientCertEnabled=true<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_app_service<br>Argument: client_cert_enabled<br><br>Goresource \"azurerm_app_service\" \"example\" {<br>...<br>+   client_cert_enabled          = true<br>}<br>"
    },
    "CKV_AZURE_18": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_networking_8",
        "severity": "MEDIUM",
        "description": "<h4>Web App does not use the latest version of HTTP</h4><h4>Description</h4>Periodically, new versions of HTTP are released to address security flaws and include additional functionality. HTTP 2.0 has additional performance improvements on the head-of-line blocking problem of the older HTTP version, header compression, and prioritization of requests. HTTP 2.0 no longer supports HTTP 1.1's chunked transfer encoding mechanism, as it provides its own more efficient mechanisms for data streaming.<br>We recommend you use the latest HTTP version for web apps and take advantage of any security fixes and new functionalities featured. With each software installation you can determine if a given update meets your organization's requirements. Organizations should verify the compatibility and support provided for any additional software, assessing the current version against the update revision being considered.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to App Services.<br>For each Web App, click App.<br>a) Navigate to Setting section.<br>b) Click Application Settings.<br>c)  Navigate to General Settings section.<br>d) Set HTTP version to 2.0.<br><br>\ud83d\udcd8NoteMost modern browsers support the HTTP 2.0 protocol over TLS only, with non-encrypted traffic using HTTP 1.1. To ensure that client browsers connect to your app with HTTP/2, either by an App Service Certificate for your app's custom domain or by binding a third party certificate.<br>CLI Command<br>To set HTTP 2.0 version for an existing app, use the following command:<br>az webapp config set<br>--resource-group <RESOURCE_GROUP_NAME><br>--name <APP_NAME><br>--http20-enabled true<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_app_service<br>Argument: http2_enabled<br><br>Goresource \"azurerm_app_service\" \"example\" {<br>...<br><br>+    site_config {<br>+        http2_enabled = true<br>}<br>}<br>"
    },
    "CKV_AZURE_28": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_networking_9",
        "severity": "MEDIUM",
        "description": "<h4>MySQL server databases do not have Enforce SSL connection enabled</h4><h4>Description</h4>SSL connectivity provides a new layer of security by connecting a database server to client applications using Secure Sockets Layer (SSL). Enforcing SSL connections between a database server and client applications helps protect against man-in-the-middle attacks. This is achieved by encrypting the data stream between the server and application.<br>We recommend you set Enforce SSL connection to Enable on MYSQL Server databases.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to Azure Database for MySQL server.<br>For each database:<br>a) Click Connection security.<br>b) Navigate to SSL Settings section.<br>c) To Enforce SSL connection click ENABLED.<br><br>CLI Command<br>To set MYSQL Databases to Enforce SSL connection, use the following command:<br>az mysql server update<br>--resource-group <resourceGroupName><br>--name <serverName><br>--ssl-enforcement Enabled<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_mysql_server<br>Argument: ssl_enforcement_enabled<br><br>Goresource \"azurerm_mysql_server\" \"example\" {<br>...<br>+  ssl_enforcement_enabled             = true<br>}<br>"
    },
    "CKV_AZURE_29": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_networking_10",
        "severity": "MEDIUM",
        "description": "<h4>Azure PostgreSQL database server with SSL connection is disabled</h4><h4>Description</h4>SSL connectivity provides a new layer of security by connecting a database server to client applications using a Secure Sockets Layer (SSL). Enforcing SSL connections between a database server and client applications helps protect against man-in-the-middle attacks. This is achieved by encrypting the data stream between the server and application.<br>We recommend you set Enforce SSL connection to Enable on PostgreSQL Server databases.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to Azure Database for PostgreSQL server.<br>For each database:<br>a) Click Connection security.<br>b) Navigate to SSL Settings section.<br>c) To Enforce SSL connection click ENABLED.<br><br>CLI Command<br>To set Enforce SSL Connection for  aPostgreSQL Database, use the following command:<br>az postgres server update<br>--resource-group <resourceGroupName><br>--name <serverName><br>--ssl-enforcement Enabled<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_postgresql_server<br>Argument: ssl_enforcement_enabled<br><br>Goresource \"azurerm_postgresql_server\" \"example\" {<br>...<br>+  ssl_enforcement_enabled             = true<br>}<br>"
    },
    "CKV_AZURE_30": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_networking_11",
        "severity": "MEDIUM",
        "description": "<h4>Azure PostgreSQL database server with log checkpoints parameter is disabled</h4><h4>Description</h4>Enabling log_checkpoints helps the PostgreSQL Database to log each checkpoint and generate query and error logs. Access to transaction logs is not supported. Query and error logs can be used to identify, troubleshoot, repair configuration errors, and address sub-optimal performance issues.<br>We recommend you set log_checkpoints to On for PostgreSQL Server Databases.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to Azure Database for PostgreSQL server.<br>For each database:<br>a) Click Server parameters.<br>b) Navigate to log_checkpoints.<br>c) Click On.<br>d) Click Save.<br><br>CLI Command<br>To update the log_checkpoints configuration, use the following command:<br>az postgres server configuration set<br>--resource-group <resourceGroupName><br>--server-name <serverName><br>--name log_checkpoints<br>--value on<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_postgresql_configuration<br>Argument: name + value<br><br>Go- resource \"azurerm_postgresql_configuration\" \"example\" {<br>-    name                = \"log_checkpoints\"<br>-    resource_group_name = data.azurerm_resource_group.example.name<br>-    server_name         = azurerm_postgresql_server.example.name<br>-    value               = \"off\"<br>}<br>"
    },
    "CKV_AZURE_31": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_networking_12",
        "severity": "MEDIUM",
        "description": "<h4>Azure PostgreSQL database server with log connections parameter is disabled</h4><h4>Description</h4>Enabling log_connections allows a PostgreSQL Database to log attempted connections to the<br>server in addition to logging the successful completion of client authentication. Log data can be used to identify, troubleshoot, repair configuration errors, and identify sub-optimal performance issues.<br>We recommend you set log_connections to On for PostgreSQL Server Databases.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to Azure Database for PostgreSQL server.<br>For each database:<br>a) Click Server parameters.<br>b) Navigate to log_connections.<br>c) Click On.<br>d) Click Save.<br><br>CLI Command<br>To update the log_connections configuration, use the following command:<br>az postgres server configuration set<br>--resource-group <resourceGroupName><br>--server-name <serverName><br>--name log_connections<br>--value on<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_postgresql_configuration<br>Argument: name + value<br><br>Go- resource \"azurerm_postgresql_configuration\" \"example\" {<br>-    name                = \"log_connections\"<br>-    resource_group_name = data.azurerm_resource_group.example.name<br>-    server_name         = azurerm_postgresql_server.example.name<br>-    value               = \"off\"<br>}<br>"
    },
    "CKV_AZURE_32": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_networking_13",
        "severity": "MEDIUM",
        "description": "<h4>Azure PostgreSQL database server with connection throttling parameter is disabled</h4><h4>Description</h4>Enabling connection_throttling allows the PostgreSQL Database to set the verbosity of logged messages. It generates query and error logs with respect to concurrent connections that could lead to a successful Denial of Service (DoS) attack by exhausting connection resources. A system can also fail or be degraded by an overload of legitimate users. Query and error logs can be used to identify, troubleshoot, repair configuration errors, and address sub-optimal performance issues.<br>We recommend you set connection_throttling to On for PostgreSQL Server Databases.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to Azure Database for PostgreSQL server.<br>For each database:<br>a) Click Server parameters.<br>b) Navigate to connection_throttling.<br>c) Click On.<br>d) Click Save.<br><br>CLI Command<br>To update the connection_throttling configuration, use the following command:<br>az postgres server configuration set<br>--resource-group <resourceGroupName><br>--server-name <serverName><br>--name connection_throttling<br>--value on<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_postgresql_configuration<br>Arguments: name + value<br><br>Go- resource \"azurerm_postgresql_configuration\" \"example\" {<br>-    name                = \"connection_throttling\"<br>-    resource_group_name = data.azurerm_resource_group.example.name<br>-    server_name         = azurerm_postgresql_server.example.name<br>-    value               = \"off\"<br>}<br>"
    },
    "CKV_AZURE_34": {
        "url": "https://docs.bridgecrew.io/docs/set-public-access-level-to-private-for-blob-containers",
        "severity": "CRITICAL",
        "description": "<h4>Public access level for  Blob Containers is not set to private</h4><h4>Description</h4>Anonymous, public read access to a container and its blobs can be enabled in Azure Blob storage. It grants read-only access to these resources without sharing the account key or requiring a shared access signature.<br>We recommend you do not provide anonymous access to blob containers until, and unless, it is strongly desired. A shared access signature token should be used for providing controlled and timed access to blob containers.<br><h4>Fix - Runtime</h4>Azure Portal<br>To begin, follow Microsoft documentation and create shared access signature tokens for your blob containers. When complete, change the policy using the Azure Portal to deny anonymous access following these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to Storage Accounts.<br>For each storage account:<br>a) Navigate to BLOB SERVICE.<br>b) Select Containers.<br>c) For each Container:<br>(i) Click Access policy.<br>(ii) Set Public Access Level to Private.<br><br>CLI Command<br>To set the permission for public access to private (off) for a specific blob container, use the container's name with the following command:<br>az storage container set-permission<br>--name <containerName><br>--public-access off<br>--account-name <accountName><br>--account-key <accountKey><br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_storage_container<br>Argument: container_access_type<br><br>Goresource \"azurerm_storage_container\" \"example\" {<br>...<br>+   container_access_type = \"private\"<br>}<br>"
    },
    "CKV_AZURE_35": {
        "url": "https://docs.bridgecrew.io/docs/set-default-network-access-rule-for-storage-accounts-to-deny",
        "severity": "MEDIUM",
        "description": "<h4>Azure Storage Account default network access is set to Allow</h4><h4>Description</h4>Restricting default network access helps to provide an additional layer of security. By default, storage accounts accept connections from clients on any network. To limit access to selected networks, the default action must be changed.<br>We recommend you configure storage accounts to deny access to traffic from all networks, including internet traffic. At an appropriate time, access can be granted to traffic from specific Azure Virtual networks, allowing a secure network boundary for specific applications to be built. Access can also be granted to public internet IP address ranges enabling connections from specific internet or on-premises clients. When network rules are configured only applications from allowed networks can access a storage account. When calling from an allowed network applications continue to require authorization, such as a valid access key or SAS token, to access the storage account.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to Storage Accounts.<br>For each storage account:<br>a) Navigate to Settings menu.<br>b) Click Firewalls and virtual networks.<br>c) For selected networks, select Allow access.<br>d) Add rules to allow traffic from specific network.<br>e) To apply changes,click Save.<br><br>CLI Command<br>To update default-action to Deny, use the following command:<br>az storage account update<br>--name <StorageAccountName><br>--resource-group <resourceGroupName><br>--default-action Deny<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_storage_account_network_rules<br>Argument: default_action<br><br>Goresource \"azurerm_storage_account_network_rules\" \"test\" {<br>resource_group_name  = azurerm_resource_group.test.name<br>storage_account_name = azurerm_storage_account.test.name<br><br>+   default_action             = \"Deny\"<br>}<br><br>In a Storage Account:<br>azurerm_storage_account.test.tfresource \"azurerm_storage_account\" \"test\" {<br>name                = var.watcher<br>resource_group_name = azurerm_resource_group.test.name<br>location            = azurerm_resource_group.test.location<br><br>+  network_rules {<br>+    default_action=\"Deny\"<br>+  }<br><br>account_tier              = \"Standard\"<br>account_kind              = \"StorageV2\"<br>account_replication_type  = \"LRS\"<br>enable_https_traffic_only = true<br>}<br><br>Suppression Advice<br>This can trigger incorrectly on azurerm_storage_account when using correctly configured azurerm_storage_account_network_rules, if this occurs suppression is reasonable.<br>"
    },
    "CKV_AZURE_36": {
        "url": "https://docs.bridgecrew.io/docs/enable-trusted-microsoft-services-for-storage-account-access",
        "severity": "MEDIUM",
        "description": "<h4>Azure Storage Account Trusted Microsoft Services access is not enabled</h4><h4>Description</h4>Some Microsoft services that interact with storage accounts operate from networks that cannot be granted access through network rules. To help this type of service work as intended, you can allow the set of trusted Microsoft services to bypass the network rules. These services will use strong authentication to access the storage account. Allowing trusted Microsoft services grants access to the storage account for the following services: Azure Backup, Azure Site Recovery, Azure DevTest Labs, Azure Event Grid, Azure Event Hubs, Azure Networking, Azure Monitor and Azure SQL Data Warehouse (when registered in the subscription).<br>Turning on firewall rules for a storage account will block access to incoming requests for data, including from other Azure services, such as using the portal and writing logs. Functionality can be re-enabled. The customer can get access to services like Monitor, Networking, Hubs, and Event Grid by enabling Trusted Microsoft Services through exceptions. Backup and Restore of Virtual Machines using unmanaged disks in storage accounts with network rules applied is supported by creating an exception.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to Storage Accounts.<br>For each storage account:<br>a) Navigate to Settings menu.<br>b) Click Firewalls and virtual networks.<br>c) For selected networks, select Allow access.<br>d) Select Allow trusted Microsoft services to access this storage account.<br>e) To apply changes,click Save.<br><br>CLI Command<br>To update trusted Microsoft services, use the following command:<br>az storage account update<br>--name <StorageAccountName><br>--resource-group <resourceGroupName><br>--bypass AzureServices<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resources:<br>azurerm_storage_account<br>azurerm_storage_account_network_rules<br>Argument: bypass<br><br>Goresource \"azurerm_storage_account\" \"example\" {<br>...<br>+   bypass                     = [\"AzureServices\"]<br>}<br>}<br>"
    },
    "CKV_AZURE_12": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_logging_1",
        "severity": "MEDIUM",
        "description": "<h4>Azure Network Watcher NSG flow logs retention is less than 90 days</h4><h4>Description</h4>Flow logs enable capturing information about IP traffic flowing in and out of network security groups. Logs can be used to check for anomalies and give insight into suspected breaches.<br>We recommend your Network Security Group (NSG) Flow Log Retention Period is set to greater than or equal to 90 days.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to Network Watcher >  Logs section.<br>Select the NSG flow logs blade.<br>For each Network Security Group in the list:<br>a) Set Status to On.<br>b) Set Retention (days) to greater than 90 days.<br>c) In Storage account select your storage account.<br>d) Click Save.<br><br>CLI Command<br>To enable the NSG flow logs and set the Retention (days)  to greater than or equal to 90 days, use the following command:<br>az network watcher flow-log configure<br>--nsg <NameorID of the Network Security Group><br>--enabled true<br>--resource-group <resourceGroupName><br>--retention 91<br>--storage-account <NameorID of the storage account to save flow logs><br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_network_watcher_flow_log<br>Argument: days<br><br>Goresource \"azurerm_network_watcher_flow_log\" \"test\" {<br>...<br>+   retention_policy {<br>+   enabled = true<br>+   days    = <90 or greater><br>}<br>}<br>"
    },
    "CKV_AZURE_24": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_logging_3",
        "severity": "HIGH",
        "description": "<h4>Azure SQL server audit log retention is less than 91 days</h4><h4>Description</h4>Audit Logs can be used to check for anomalies and give insight into suspected breaches or misuse of information and access.<br>We recommend you configure SQL server audit retention to be greater than 90 days.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>2 Navigate to SQL servers.<br>For each server instance:<br>a) Click Auditing.<br>b) Select Storage Details.<br>c) Set Retention (days) to greater than 90 days.<br>d) Click OK.<br>e) Click Save.<br><br>CLI Command<br>To set the retention policy for more than or equal to 90 days, for each server, use the following command:<br>set-AzureRmSqlServerAuditing<br>-ResourceGroupName <resource group name><br>-ServerName <server name><br>-RetentionInDays <Number of Days to retain the audit logs, should be 90days minimum><br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_sql_server, azurerm_mssql_server<br>Argument: retention_in_days*<br><br>Goresource \"azurerm_sql_server\" \"example\" {<br>...<br>extended_auditing_policy {<br>storage_endpoint            = azurerm_storage_account.example.primary_blob_endpoint<br>storage_account_access_key  = azurerm_storage_account.example.primary_access_key<br>storage_account_access_key_is_secondary = true<br>+       retention_in_days                       = <90 or greater><br>}<br>}<br>"
    },
    "CKV_AZURE_33": {
        "url": "https://docs.bridgecrew.io/docs/enable-requests-on-storage-logging-for-queue-service",
        "severity": "MEDIUM",
        "description": "<h4>Storage logging for queue service does not have read, write, and delete requests enabled</h4><h4>Description</h4>The Azure Queue Storage service stores messages that may be read by any client with access to the storage account. A queue may contain an unlimited number of messages, each of which can be up to 64KB in size when using version 2011-08-18 or newer.<br>Storage Logging takes place server-side recording details in the storage account for both successful and failed requests. These logs allow users to see the details of read, write, and delete operations against the queues. Storage Logging log entries contain the following information about individual requests: timing information, for example start time, end-to-end latency, server latency, authentication details, concurrency information, and the size of request and response messages.<br>Storage Analytics logs contain detailed information about successful and failed requests to a storage service. This information can be used to monitor individual requests and to diagnose issues with a storage service. Requests are logged on a best-effort basis. Storage Analytics logging is not enabled by default for your storage account.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to Storage Accounts.<br>Select the specific Storage Account.<br>From the Monitoring (classic) section, select the Diagnostics logs (classic) blade.<br>Set the Status to On.<br>Select Queue properties.<br>Navigate to the Logging section to enable Storage Logging for Queue service.<br>Select Read, Write and Delete options.<br><br>CLI Command<br>To enable the Storage Logging for Queue service, use the following command:<br>storage logging update--account-name <storageAccountName><br>--account-key <storageAccountKey><br>--services q<br>--log rwd<br>--retention 90<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_storage_account<br>Argument: logging + hour_metrics + minute_metrics<br><br>Goresource \"azurerm_storage_account\" \"example\" {<br>name                     = \"example\"<br>resource_group_name      = data.azurerm_resource_group.example.name<br>location                 = data.azurerm_resource_group.example.location<br>account_tier             = \"Standard\"<br>account_replication_type = \"GRS\"<br>queue_properties  {<br>+   logging {<br>delete                = true<br>read                  = true<br>write                 = true<br>version               = \"1.0\"<br>retention_policy_days = 10<br>}<br>}<br>}<br><br>The logging field should be enough to enable logging. As Terraform apply might fail, it is recommended to also configure the hour_metrics and minute_metrics fields.<br>To do this, insert the following code in the queue_properties section of the code above.<br>Go+   hour_metrics {<br>enabled               = true<br>include_apis          = true<br>version               = \"1.0\"<br>retention_policy_days = 10<br>}<br>+   minute_metrics {<br>enabled               = true<br>include_apis          = true<br>version               = \"1.0\"<br>retention_policy_days = 10<br>}<br>"
    },
    "CKV_AZURE_37": {
        "url": "https://docs.bridgecrew.io/docs/set-activity-log-retention-to-365-days-or-greater",
        "severity": "MEDIUM",
        "description": "<h4>Activity log retention is set to less than 365 days</h4><h4>Description</h4>A log profile controls how the activity log is exported and retained. Since the average time to detect a breach is 210 days, the activity log should be retained for 365 days or more, providing time to respond to any incidents.<br>We recommend you set activity log retention for 365 days or greater.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to the Activity log.<br>Select Export.<br>Set Retention (days) to 365 or 0.<br>Click Save.<br><br>CLI Command<br>To set Activity log Retention (days) to 365 or greater, use the following command:<br>az monitor log-profiles update<br>--name <logProfileName><br>--set retentionPolicy.days=<number of days> retentionPolicy.enabled=true<br><br>To store logs for fo<br>##Terrarever (indefinitely), use the following command:<br>az monitor log-profiles update<br>--name <logProfileName><br>--set retentionPolicy.days=0 retentionPolicy.enabled=false<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_monitor_log_profile<br>Argument: retention policy<br><br>Option 1<br>Goresource \"azurerm_monitor_log_profile\" \"example\" {<br>name = \"default\"<br>categories = [<br>\"Action\",<br>\"Delete\",<br>\"Write\",<br>]<br>locations = [<br>\"westus\",<br>\"global\",<br>]<br>+    retention_policy {<br>+    enabled = true<br>+    days    = 365<br>}<br>}<br><br>Option 2<br>Goresource \"azurerm_monitor_log_profile\" \"example\" {<br>name = \"default\"<br>categories = [<br>\"Action\",<br>\"Delete\",<br>\"Write\",<br>]<br>locations = [<br>\"westus\",<br>\"global\",<br>]<br>+    retention_policy {<br>+    enabled = false<br>+    days    = 0<br>}<br>}<br>"
    },
    "CKV_AZURE_38": {
        "url": "https://docs.bridgecrew.io/docs/ensure-audit-profile-captures-all-activities",
        "severity": "LOW",
        "description": "<h4>Log profile is not configured to capture all activities</h4><h4>Description</h4>A log profile controls how the activity log is exported. Configuring the log profile to collect logs for the categories Write, Delete and Action ensures that all control/management plane activities performed on the subscription are exported.<br>We recommend you configure the log profile to export all activities from the control/management plane.<br><h4>Fix - Runtime</h4>Azure Portal<br>The Azure portal currently has no provision to check or set categories.<br>CLI Command<br>To update an existing default log profile, use the following command:<br>az monitor log-profiles update --name default<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_monitor_log_profile<br>Argument: categories<br><br>Goresource \"azurerm_monitor_log_profile\" \"example\" {<br>...<br>categories = [<br>+   \"Action\",<br>+   \"Delete\",<br>+   \"Write\",<br>]<br>}<br>"
    },
    "CKV_AZURE_2": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_general_1",
        "severity": "HIGH",
        "description": "<h4>Azure VM data disk is encrypted with the default encryption key instead of ADE/CMK</h4><h4>Description</h4>Azure encrypts data disks by default Server-Side Encryption (SSE) with platform-managed keys [SSE with PMK]. It is recommended to use either SSE with Azure Disk Encryption [SSE with PMK+ADE] or Customer Managed Key [SSE with CMK] which improves on platform-managed keys by giving you control of the encryption keys to meet your compliance need.  Encryption does not impact the performance of managed disks and there is no additional cost for the encryption.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Select the Management tab and verify that you have a Diagnostics Storage Account. If you have no storage accounts, select Create New, give your new account a name, then select OK.<br>When the VM deployment is complete, select Go to resource.<br>On the left-hand sidebar, select Disks. On the Disks screen, select Encryption.<br>On the Create key vault screen, ensure that the Resource Group is the same as the one you used to create the VM.<br>Name your key vault.<br>On the Access Policies tab, check the Azure Disk Encryption for volume encryption.<br>After the key vault has passed validation, select Create. Leave the Key field blank, then click Select.<br>At the top of the Encryption screen, click Save. A popup will warn you that the VM will reboot. Click Yes.<br><br>CLI Command<br>Encrypt your VM with az vm encryption, providing your unique Key Vault name to the --disk-encryption-keyvault parameter.<br>Shellaz vm encryption enable -g MyResourceGroup --name MyVM --disk-encryption-keyvault myKV<br><br>## You can verify that encryption is enabled on your VM with az vm show<br>az vm show --name MyVM -g MyResourceGroup<br><br>## You will see the following in the returned output:<br>\"EncryptionOperation\": \"EnableEncryption\"<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_managed_disk<br>Argument: encryption_settings - Is Encryption enabled on this Managed Disk? Changing this forces a new resource to be created.<br>Add the encryption_settings block as show:<br><br>azurerm_managed_disk.example.tfresource \"azurerm_managed_disk\" \"example\" {<br>name                 = var.disk_name<br>location             = var.location<br>resource_group_name  = var.resource_group_name<br>storage_account_type = var.storage_account_type<br>create_option        = \"Empty\"<br>disk_size_gb         = var.disk_size_gb<br>+ encryption_settings {<br>+   enabled = true<br>+ }<br>tags = var.common_tags<br>}<br><br>ARM Templates<br><br>Resource: encryptionOperation<br>Argument: EnableEncryption<br><br>Go{<br>\"$schema\": \"https://schema.management.azure.com/schemas/2019-04-01/deploymentTemplate.json#\",<br>\"contentVersion\": \"1.0.0.0\",<br>\"parameters\": {<br>\"vmName\": {<br>\"type\": \"string\",<br>\"metadata\": {<br>\"description\": \"Name of the virtual machine\"<br>}<br>},<br>\"volumeType\": {<br>\"type\": \"string\",<br>\"defaultValue\": \"Data\",<br>\"allowedValues\": [<br>\"Data\"<br>],<br>\"metadata\": {<br>\"description\": \"Decryption is supported only on data drives for Linux VMs.\"<br>}<br>},<br>\"sequenceVersion\": {<br>\"type\": \"string\",<br>\"defaultValue\": \"1.0\",<br>\"metadata\": {<br>\"description\": \"Pass in an unique value like a GUID everytime the operation needs to be force run\"<br>}<br>},<br>\"location\": {<br>\"type\": \"string\",<br>\"defaultValue\": \"[resourceGroup().location]\",<br>\"metadata\": {<br>\"description\": \"Location for all resources.\"<br>}<br>}<br>},<br>\"variables\": {<br>\"extensionName\": \"AzureDiskEncryptionForLinux\",<br>\"extensionVersion\": \"0.1\",<br>+   \"encryptionOperation\": \"EnableEncryption\",<br><br>...<br>"
    },
    "CKV_AZURE_13": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_general_2",
        "severity": "MEDIUM",
        "description": "<h4>Azure App Service Web app authentication is Off</h4><h4>Description</h4>Azure App Service Authentication is a feature that prevents anonymous HTTP requests from reaching the API app. Users with tokens are authenticated before they reach the API app. If an anonymous request is received from a browser, App Service redirects to a logon page. To handle the logon process select from a set of identity providers, or implement a custom authentication mechanism.<br>Enabling App Service Authentication allows every incoming HTTP request to pass through it before being handled by the application code. Authentication of users with specified providers are handled, for example, Azure Active Directory, Facebook, Google, Microsoft Account, and Twitter. It also handles authentication of validation, storing and refreshing of tokens, managing the authenticated sessions, and injecting identity information into request headers.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to App Services.<br>Click each App.<br>Navigate to the Setting section, click Authentication / Authorization.<br>Set App Service Authentication to On.<br>Select additional parameters as per your requirements.<br>Click Save.<br><br>CLI Command<br>To set App Service Authentication for an existing app, use the following command:<br>az webapp auth update<br>--resource-group <RESOURCE_GROUP_NAME><br>--name <APP_NAME><br>--enabled true<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_app_service<br>Argument: auth_settings:enabled<br><br>Goresource \"azurerm_app_service\" \"example\" {<br>...<br>+   auth_settings {<br>+       enabled          = true<br>...<br>}<br>}<br>"
    },
    "CKV_AZURE_20": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_general_3",
        "severity": "LOW",
        "description": "<h4>No security contact phone number is present</h4><h4>Description</h4>Microsoft reaches out to the designated security contact in case its security team finds that the organization's resources are compromised. This ensures that the correct people are aware of any potential compromise and can mitigate the risk in a timely fashion.<br>We recommend you provide a security contact phone number, but before taking any action make sure that the information provided is valid because the communication is not digitally signed.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to the Security Center.<br>Click Security Policy.<br>For the security policy subscription, click Edit Settings.<br>Click Email notifications.<br>Enter a valid security contact Phone Number.<br>Click Save.<br><br>CLI Command<br>To set a phone number for contact at time of a potential security breach, use the following command:<br>az account get-access-token<br>--query \"{subscription:subscription,accessToken:accessToken}\"<br>--out tsv | xargs -L1 bash -c 'curl -X PUT -H \"Authorization: Bearer $1\"<br>-H \"Content-Type:application/json\"<br>https://management.azure.com/subscriptions/$0/providers/Microsoft.Security/<br>securityContacts/default1?api-version=2017-08-01-preview [email\u00a0protected]\"*input.json*\"'<br><br>Where input.json contains the Request body json data, detailed below.<br>Replace validEmailAddress with email ids csv for multiple.<br>Replace phoneNumber with the valid phone number.<br>Go{<br>\"id\":<br>\"/subscriptions/<Your_Subscription_Id>/providers/Microsoft.Security/<br>securityContacts/default1\",<br>\"name\": \"default1\",<br>\"type\": \"Microsoft.Security/securityContacts\",<br>\"properties\": {<br>\"email\": \"<validEmailAddress>\",<br>\"phone\": \"<phone_number>\",<br>\"alertNotifications\": \"On\",<br>\"alertsToAdmins\": \"On\"<br>}<br>}<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_security_center_contact<br>Argument: phone<br><br>Goresource \"azurerm_security_center_contact\" \"example\" {<br>email = \"[email\u00a0protected]\"<br>phone = \"+1-555-555-5555\"<br>}<br>"
    },
    "CKV_AZURE_21": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_general_4",
        "severity": "LOW",
        "description": "<h4>Send email notification for high severity alerts is not enabled</h4><h4>Description</h4>Enabling email security alerts to be automatically sent to your organization's security staff ensures that the correct people are aware of any potential security issues, and can mitigate the risk.<br>Setting the security alert Send email notification for high severity alerts to On ensures that emails are sent from Microsoft if their security team determines a potential security breach has taken place.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to the Security Center.<br>Click Security Policy.<br>For the security policy subscription, click Edit Settings.<br>Click Email notifications.<br>Set Send email notification for high severity alerts to On.<br>Click Save.<br><br>CLI Command<br>To set Send email notification for high severity alerts to On, use the following command:<br>az account get-access-token --query<br>\"{subscription:subscription,accessToken:accessToken}\" --out tsv | xargs -L1<br>bash -c 'curl -X PUT -H \"Authorization: Bearer $1\" -H \"Content-Type:application/json\"<br>https://management.azure.com/subscriptions/$0/providers/Microsoft.Security/<br>securityContacts/default1?api-version=2017-08-01-preview [email\u00a0protected]\"input.json\"'<br><br>Where input.json contains the Request body json data, detailed below.<br>Replace validEmailAddress with email ids csv for multiple.<br>Replace phoneNumber with the valid phone number.<br>{<br>\"id\":<br>\"/subscriptions/<Your_Subscription_Id>/providers/Microsoft.Security/<br>securityContacts/default1\",<br>\"name\": \"default1\",<br>\"type\": \"Microsoft.Security/securityContacts\",<br>\"properties\": {<br>\"email\": \"<validEmailAddress>\",<br>\"phone\": \"<phone_number>\",<br>\"alertNotifications\": \"On\",<br>\"alertsToAdmins\": \"On\"<br>}<br>}<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_security_center_contact<br>Argument: alert_notifications<br><br>Goresource \"azurerm_security_center_contact\" \"example\" {<br>...<br>+   alert_notifications = true<br>}<br>"
    },
    "CKV_AZURE_22": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_general_5",
        "severity": "MEDIUM",
        "description": "<h4>Send email notification for high severity alerts to admins is not enabled</h4><h4>Description</h4>Enabling security alert emails to subscription owners ensures that they receive security alert emails from Microsoft. This ensures that they are aware of any potential security issues and can mitigate the risk identified in a timely fashion.<br>We recommend set security alert emails to be sent to subscription owners.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to the Security Center.<br>Click Security Policy.<br>Navigate to Security Policy Subscription, click Edit Settings.<br>Click Email notifications.<br>Set Send email also to subscription owners to On.<br>Click Save.<br><br>CLI Command<br>To set Send email also to subscription owners to On, use the following command:<br>az account get-access-token --query<br>\"{subscription:subscription,accessToken:accessToken}\" --out tsv | xargs -L1<br>bash -c 'curl -X PUT -H \"Authorization: Bearer $1\" -H \"Content-Type:<br>application/json\"<br>https://management.azure.com/subscriptions/$0/providers/Microsoft.Security/se<br>curityContacts/default1?api-version=2017-08-01-preview [email\u00a0protected]\"input.json\"'<br><br>Where input.json contains the Request body json data, detailed below.<br>Replace validEmailAddress with email ids csv for multiple.<br>Replace phoneNumber with a valid phone number.<br>{<br>\"id\":<br>\"/subscriptions/<Your_Subscription_Id>/providers/Microsoft.Security/securityC<br>ontacts/default1\",<br>\"name\": \"default1\",<br>\"type\": \"Microsoft.Security/securityContacts\",<br>\"properties\": {<br>\"email\": \"<validEmailAddress>\",<br>\"phone\": \"<phone_number>\",<br>\"alertNotifications\": \"On\",<br>\"alertsToAdmins\": \"On\"<br>}<br>}<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_security_center_contact<br>Argument: alerts_to_admins<br><br>Goresource \"azurerm_security_center_contact\" \"example\" {<br>...<br>+   alerts_to_admins    = true<br>}<br>"
    },
    "CKV_AZURE_25": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_general_6",
        "severity": "HIGH",
        "description": "<h4>Azure SQL Server threat detection alerts are not enabled for all threat types</h4><h4>Description</h4>Enabling all Threat Detection Types protects against SQL injection, database vulnerabilities, and any other anomalous activities. We recommend you enable all types of threat detection on SQL servers.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to SQL servers.<br>For each server instance:<br>a) Click Advanced Data Security.<br>b) Navigate to Threat Detection Settings section.<br>c) Set Threat Detection Types to All.<br><br>CLI Command<br>To set each server's ExcludedDetectionTypes to None, use the following command:<br>Set-AzureRmSqlServerThreatDetectionPolicy<br>-ResourceGroupName <resource group name><br>-ServerName <server name><br>-ExcludedDetectionType \"None\"<br><br><h4>Fix - Buildtime</h4>ARM<br><br>Resource: Microsoft.Sql/servers/databases<br><br>JSON{<br>\"type\": \"Microsoft.Sql/servers/databases\",<br>\"apiVersion\": \"2020-08-01-preview\",<br>\"name\": \"[variables('dbName')]\",<br>\"location\": \"[parameters('location')]\",<br>\"sku\": {<br>\"name\": \"[parameters('sku')]\"<br>},<br>\"kind\": \"v12.0,user\",<br>\"properties\": {<br>\"collation\": \"SQL_Latin1_General_CP1_CI_AS\",<br>\"maxSizeBytes\": \"[mul(parameters('maxSizeMB'), 1048576)]\",<br>\"catalogCollation\": \"SQL_Latin1_General_CP1_CI_AS\",<br>\"zoneRedundant\": false,<br>\"readScale\": \"Disabled\",<br>\"storageAccountType\": \"GRS\"<br>},<br>\"resources\": [<br>{<br>\"type\": \"Microsoft.Sql/servers/databases/securityAlertPolicies\",<br>\"apiVersion\": \"2014-04-01\",<br>\"name\": \"[concat(variables('dbName'), '/current')]\",<br>\"location\": \"[parameters('location')]\",<br>\"dependsOn\": [<br>\"[resourceId('Microsoft.Sql/servers/databases', parameters('serverName'), parameters('databaseName'))]\"<br>],<br>\"properties\": {<br>+               \"state\": \"Enabled\",<br>+               \"disabledAlerts\": \"\",<br>\"emailAddresses\": \"[variables('emailAddresses')[copyIndex()]]\",<br>\"emailAccountAdmins\": \"Enabled\"<br>}<br>}<br>]<br>}<br><br>Terraform<br><br>Resource: azurerm_mssql_server_security_alert_policy<br>Argument: disabled_alerts<br><br>Goresource \"azurerm_mssql_server_security_alert_policy\" \"example\" {<br>...<br>+   disabled_alerts = []<br>}<br>"
    },
    "CKV_AZURE_26": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_general_7",
        "severity": "HIGH",
        "description": "<h4>Azure SQL server send alerts to field value is not set</h4><h4>Description</h4>Provide the email address where alerts will be sent when anomalous activities are detected on SQL servers. Providing the email address to receive alerts ensures that any detection of anomalous activities is reported as soon as possible, enabling early mitigation of any potential risk detected.<br>We recommend you add an email address to the Send Alerts to field value for MSSQL servers.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to SQL servers.<br>For each server instance:<br>a) Click Advanced Threat Protection.<br>b) In Send alerts to enter email addresses as appropriate.<br><br>CLI Command<br>To set each server's Send alerts to, use the following command:<br>Set-AzureRmSqlServerThreatDetectionPolicy<br>-ResourceGroupName <resource group name><br>-ServerName <server name><br>-NotificationRecipientsEmails \"<Recipient Email ID>\"<br><br><h4>Fix - Buildtime</h4><h4>Fix - Buildtime</h4>ARM<br><br>Resource: Microsoft.Sql/servers/databases<br><br>JSON{<br>\"type\": \"Microsoft.Sql/servers/databases\",<br>\"apiVersion\": \"2020-08-01-preview\",<br>\"name\": \"[variables('dbName')]\",<br>\"location\": \"[parameters('location')]\",<br>\"sku\": {<br>\"name\": \"[parameters('sku')]\"<br>},<br>\"kind\": \"v12.0,user\",<br>\"properties\": {<br>\"collation\": \"SQL_Latin1_General_CP1_CI_AS\",<br>\"maxSizeBytes\": \"[mul(parameters('maxSizeMB'), 1048576)]\",<br>\"catalogCollation\": \"SQL_Latin1_General_CP1_CI_AS\",<br>\"zoneRedundant\": false,<br>\"readScale\": \"Disabled\",<br>\"storageAccountType\": \"GRS\"<br>},<br>\"resources\": [<br>{<br>\"type\": \"Microsoft.Sql/servers/databases/securityAlertPolicies\",<br>\"apiVersion\": \"2014-04-01\",<br>\"name\": \"[concat(variables('dbName'), '/current')]\",<br>\"location\": \"[parameters('location')]\",<br>\"dependsOn\": [<br>\"[resourceId('Microsoft.Sql/servers/databases', parameters('serverName'), parameters('databaseName'))]\"<br>],<br>\"properties\": {<br>\"state\": \"Enabled\",<br>\"disabledAlerts\": \"\",<br>+               \"emailAddresses\": \"[variables('emailAddresses')[copyIndex()]]\",<br>\"emailAccountAdmins\": \"Enabled\"<br>}<br>}<br>]<br>}<br><br>Terraform<br><br>Resource: azurerm_mssql_server_security_alert_policy<br>Argument: email_addresses<br><br>Goresource \"azurerm_mssql_server_security_alert_policy\" \"example\" {<br>...<br>+   email_addresses = [\"[email\u00a0protected]\"]<br>}<br>"
    },
    "CKV_AZURE_27": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_general_8",
        "severity": "MEDIUM",
        "description": "<h4>MSSQL servers do not have email service and co-administrators enabled</h4><h4>Description</h4>Enable Service and Co-administrators to receive security alerts from the SQL server. Providing the email address to receive alerts ensures that any detection of anomalous activities is reported as soon as possible, enabling early mitigation of any potential risk detected.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to SQL servers.<br>For each server instance:<br>a) Click Advanced Data Security.<br>b) Navigate to Threat Detection Settings section.<br>c) Enable Email service and co-administrators.<br><br>CLI Command<br>To enable each server's Email service and co-administrators for MSSQL, use the following command:<br>Set-AzureRmSqlServerThreatDetectionPolicy<br>-ResourceGroupName <resource group name><br>-ServerName <server name><br>-EmailAdmins $True<br><br><h4>Fix - Buildtime</h4>ARM<br><br>Resource: Microsoft.Sql/servers/databases<br><br>JSON{<br>\"type\": \"Microsoft.Sql/servers/databases\",<br>\"apiVersion\": \"2020-08-01-preview\",<br>\"name\": \"[variables('dbName')]\",<br>\"location\": \"[parameters('location')]\",<br>\"sku\": {<br>\"name\": \"[parameters('sku')]\"<br>},<br>\"kind\": \"v12.0,user\",<br>\"properties\": {<br>\"collation\": \"SQL_Latin1_General_CP1_CI_AS\",<br>\"maxSizeBytes\": \"[mul(parameters('maxSizeMB'), 1048576)]\",<br>\"catalogCollation\": \"SQL_Latin1_General_CP1_CI_AS\",<br>\"zoneRedundant\": false,<br>\"readScale\": \"Disabled\",<br>\"storageAccountType\": \"GRS\"<br>},<br>\"resources\": [<br>{<br>\"type\": \"Microsoft.Sql/servers/databases/securityAlertPolicies\",<br>\"apiVersion\": \"2014-04-01\",<br>\"name\": \"[concat(variables('dbName'), '/current')]\",<br>\"location\": \"[parameters('location')]\",<br>\"dependsOn\": [<br>\"[resourceId('Microsoft.Sql/servers/databases', parameters('serverName'), parameters('databaseName'))]\"<br>],<br>\"properties\": {<br>\"state\": \"Enabled\",<br>\"disabledAlerts\": \"\",<br>\"emailAddresses\": \"[variables('emailAddresses')[copyIndex()]]\",<br>+               \"emailAccountAdmins\": \"Enabled\"<br>}<br>}<br>]<br>}<br><br>Terraform<br><br>Resource: azurerm_mssql_server_security_alert_policy<br>Argument: email_account_admins<br><br>Goresource \"azurerm_mssql_server_security_alert_policy\" \"example\" {<br>...<br>+   email_account_admins       = true<br>}<br>"
    },
    "CKV_AZURE_19": {
        "url": "https://docs.bridgecrew.io/docs/ensure-standard-pricing-tier-is-selected",
        "severity": "MEDIUM",
        "description": "<h4>Standard pricing tier is not selected</h4><h4>Description</h4>The standard pricing tier enables threat detection for networks and virtual machines and allows greater defense-in-depth. It provides threat intelligence, anomaly detection, and behavior analytics in the Azure Security Center. Threat detection is provided by the Microsoft Security Response Center (MSRC).<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to the Azure Security Center.<br>Select Security policy blade.<br>To alter the the security policy for a subscription, click Edit Settings.<br>Select Pricing tier blade.<br>Select Standard.<br>Select Save.<br><br>CLI Command<br>To set the Pricing Tier to Standard, use the following command:<br>Shellaz account get-access-token<br>--query<br>\"{subscription:subscription,accessToken:accessToken}\"<br>--out tsv | xargs -L1 bash -c 'curl -X PUT -H \"Authorization: Bearer $1\" -H \"Content-Type:<br>application/json\"<br>https://management.azure.com/subscriptions/$0/providers/Microsoft.Security/pr<br>icings/default?api-version=2017-08-01-preview [email\u00a0protected]\"input.json\"'<br><br>Where input.json contains the Request body json data, detailed below.<br>Shell{<br>\"id\":<br>\"/subscriptions/<Your_Subscription_Id>/providers/Microsoft.Security/pricings/<br>default\",<br>\"name\": \"default\",<br>\"type\": \"Microsoft.Security/pricings\",<br>\"properties\": {<br>\"pricingTier\": \"Standard\"<br>}<br>}<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_security_center_subscription_pricing<br>Argument: tier<br><br>Goresource \"azurerm_security_center_subscription_pricing\" \"example\" {<br>-   tier = \"Free\"<br>+   tier = \"Standard\"<br>}<br>"
    },
    "CKV_AZURE_40": {
        "url": "https://docs.bridgecrew.io/docs/set-an-expiration-date-on-all-keys",
        "severity": "CRITICAL",
        "description": "<h4>Not all keys have an expiration date</h4><h4>Description</h4>The Azure Key Vault enables users to store and use cryptographic keys within the Microsoft Azure environment. The exp (expiration time) attribute identifies the expiration time on or after which the key must not be used for a cryptographic operation. Keys are not set to expire by default.<br>We recommend you rotate keys in the key vault and set an explicit expiration time for all keys in the Azure Key Vault. This ensures that the keys cannot be used beyond their assigned lifetimes.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to Key vaults.<br>For each Key vault:<br>a) Click Keys.<br>b) Navigate to the Settings section.<br>c) Set Enabled? to Yes.<br>d) Set an appropriate EXPIRATION DATE on all keys.<br><br>CLI Command<br>To update the EXPIRATION DATE for the key, use the following command:<br>az keyvault key set-attributes<br>--name <keyName><br>--vault-name <vaultName><br>--expires Y-m-d'T'H:M:S'Z'<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_key_vault_key<br>Argument: expiration_date<br><br>Goresource \"azurerm_key_vault_key\" \"generated\" {<br>...<br>+   expiration_date = \"2020-12-30T20:00:00Z\"<br>}<br>"
    },
    "CKV_AZURE_42": {
        "url": "https://docs.bridgecrew.io/docs/ensure-the-key-vault-is-recoverable",
        "severity": "MEDIUM",
        "description": "<h4>Azure key vault is not recoverable</h4><h4>Description</h4>The key vault contains object keys, secrets and certificates. Accidental unavailability of a key vault can cause immediate data loss or loss of security functions supported by the key vault objects, such as authentication, validation, verification, and non-repudiation. Deleting or purging a key vault leads to immediate data loss as keys encrypting data, including storage accounts, SQL databases, and/or dependent services provided by key vault objects, such as keys, secrets, and certificates.<br>We recommended you make the key vault recoverable by enabling the Do Not Purge and Soft Delete functions. This will prevent accidental deletion by a user running the delete/purge command on the key vault, or an attacker/malicious user does to deliberately to cause disruption.<br><h4>Fix - Runtime</h4>Procedure<br>There are two key vault properties that play roles in the permanent unavailability of a key vault.<br><br><br>EnablePurgeProtection:<br>enableSoftDelete only ensures that the key vault is not deleted permanently and is recoverable for 90 days from the date of deletion. There are scenarios where the key vault and/or its objects are accidentally purged will not be recoverable.<br>Setting enablePurgeProtection to \"true\" ensures the key vault and its objects cannot be purged. Enabling both the parameters on key vaults ensures that key vaults and their objects cannot be deleted/purged permanently.<br><br><br>SetSoftDeleteRetentionDays (Optional):<br>Set the number of days that items should be retained for once soft-deleted. This value can be between 7 and 90 (the default) days.<br><br><br>Azure Portal<br>The Azure Portal does not currently have provision to update the respective configurations.<br>CLI Command<br>Use the following command:<br>az resource update<br>--id /subscriptions/xxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx/resourceGroups/<br><resourceGroupName>/providers/Microsoft.KeyVault/vaults/<keyVaultName><br>--set properties.enablePurgeProtection=true properties.enableSoftDelete=true<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_key_vault<br>Argument: soft_delete_enabled + purge_protection_enabled<br><br>Goresource \"azurerm_key_vault\" \"example\" {<br>...<br>+   purge_protection_enabled    = true<br>+   soft_delete_retention_days  = 7     # Default is 90<br>}<br>"
    },
    "CKV_AZURE_16": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_iam_1",
        "severity": "MEDIUM",
        "description": "<h4>App Service is not registered with an Azure Active Directory account</h4><h4>Description</h4>Managed service identity in App Service increases security by eliminating secrets from the app, for example, credentials in the connection strings. App Service provides a highly-scalable, self-patching web hosting service in Azure. It also provides a managed identity for apps, which is a turn-key solution for securing access to an Azure SQL Database and other Azure services.<br>We recommend you register the App Service with your Azure Active Directory account ensuring the app will connect securely to other Azure services without the need of usernames and passwords.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to App Services.<br>For each App, click the App.<br>a) Navigate to the Setting section.<br>b) Click Identity.<br>c) Set Status to On.<br><br>CLI Command<br>To set the Register with Azure Active Directory feature for an existing app, use the following command:<br>az webapp identity assign<br>--resource-group <RESOURCE_GROUP_NAME><br>--name <APP_NAME><br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_app_service<br>Field: identity<br><br>Goresource \"azurerm_app_service\" \"example\" {<br>...<br>+    identity {<br>+        type = \"UserAssigned\"<br>+        identity_ids = \"12345\"<br>}<br>}<br>"
    },
    "CKV_AZURE_39": {
        "url": "https://docs.bridgecrew.io/docs/do-not-create-custom-subscription-owner-roles",
        "severity": "CRITICAL",
        "description": "<h4>Azure subscriptions with custom roles are overly permissive</h4><h4>Description</h4>Subscription ownership should not include permission to create custom owner roles. The principle of least privilege should be followed and only necessary privileges be assigned instead of allowing full administrative access. Classic subscription admin roles offer basic access management and include Account Administrator, Service Administrator, and Co-Administrators.<br>We recommend the minimum permissions necessary be given to subscription owner accounts initially. Permissions can be added as needed by the account holder. This ensures the account holder cannot perform actions which were not intended.<br><h4>Fix - Runtime</h4>CLI Command<br>To provide a list of the role identified, use the following command:<br>az role definition list<br>Check for entries with assignableScope of / or a subscription, and an action of *.<br>To verify the usage and impact of removing the role identified, use the following command:<br>az role definition delete --name \"rolename\"<br><h4>Fix - Buildtime</h4>Terraform<br>Option 1<br><br>Resource: azurerm_role_definition<br>Argument: actions<br><br>Goresource \"azurerm_role_definition\" \"example\" {<br>name        = \"my-custom-role\"<br>scope       = data.azurerm_subscription.primary.id<br>description = \"This is a custom role created via Terraform\"<br><br>permissions {<br>actions     = [<br>-    \"*\"<br>+    <selected actions><br>]<br>not_actions = []<br>}<br><br>assignable_scopes = [<br>\"/\"<br>]<br>}<br><br>Option 2<br><br>Resource: azurerm_role_definition<br>Argument: assignable_scopes<br><br>JSONresource \"azurerm_role_definition\" \"example\" {<br>name        = \"my-custom-role\"<br>scope       = data.azurerm_subscription.primary.id<br>description = \"This is a custom role created via Terraform\"<br>permissions {<br>actions     = [<br>\"*\"<br>]<br>not_actions = []<br>}<br><br>assignable_scopes = [<br>+    <narrower scopes than subscriptions><br>-    \"/\"<br>-   data.azurerm_subscription.primary.id<br>-   resource.azurerm_subscription.primary.id<br>]<br>}<br>"
    },
    "CKV_AZURE_41": {
        "url": "https://docs.bridgecrew.io/docs/set-an-expiration-date-on-all-secrets",
        "severity": "CRITICAL",
        "description": "<h4>AKV secrets do not have an expiration date set</h4><h4>Description</h4>The Azure Key Vault (AKV) enables users to store and keep secrets within the Microsoft Azure environment. Secrets in the AKV are octet sequences with a maximum size of 25k bytes each.<br>The exp (expiration time) attribute identifies the expiration time on or after which the secret must not be used. By default, secrets do not expire.<br>We recommend you rotate secrets in the key vault and set an explicit expiration time for all secrets. This ensures that the secrets cannot be used beyond their assigned lifetimes.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to Key vaults.<br>For each Key vault:<br>a) Click Secrets.<br>b) Navigate to Settings.<br>c) Set Enabled? to Yes.<br>d) Set an appropriate EXPIRATION DATE on all secrets.<br><br>CLI Command<br>To set an EXPIRATION DATE on all secrets, use the following command:<br>az keyvault secret set-attributes<br>--name <secretName><br>--vault-name <vaultName><br>--expires Y-m-d'T'H:M:S'Z'<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_key_vault_secret<br>Argument: expiration_date<br><br>Goresource \"azurerm_key_vault_secret\" \"example\" {<br>...<br>+   expiration_date = \"2020-12-30T20:00:00Z\"<br>}<br>"
    },
    "CKV_AZURE_45": {
        "url": "https://docs.bridgecrew.io/docs/set-an-expiration-date-on-all-secrets",
        "severity": "CRITICAL",
        "description": "<h4>AKV secrets do not have an expiration date set</h4><h4>Description</h4>The Azure Key Vault (AKV) enables users to store and keep secrets within the Microsoft Azure environment. Secrets in the AKV are octet sequences with a maximum size of 25k bytes each.<br>The exp (expiration time) attribute identifies the expiration time on or after which the secret must not be used. By default, secrets do not expire.<br>We recommend you rotate secrets in the key vault and set an explicit expiration time for all secrets. This ensures that the secrets cannot be used beyond their assigned lifetimes.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to Key vaults.<br>For each Key vault:<br>a) Click Secrets.<br>b) Navigate to Settings.<br>c) Set Enabled? to Yes.<br>d) Set an appropriate EXPIRATION DATE on all secrets.<br><br>CLI Command<br>To set an EXPIRATION DATE on all secrets, use the following command:<br>az keyvault secret set-attributes<br>--name <secretName><br>--vault-name <vaultName><br>--expires Y-m-d'T'H:M:S'Z'<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_key_vault_secret<br>Argument: expiration_date<br><br>Goresource \"azurerm_key_vault_secret\" \"example\" {<br>...<br>+   expiration_date = \"2020-12-30T20:00:00Z\"<br>}<br>"
    },
    "CKV_AZURE_4": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_kubernetes_1",
        "severity": "MEDIUM",
        "description": "<h4>Azure AKS cluster monitoring is not enabled</h4><h4>Description</h4>The Azure Monitoring service collects and stores valuable telemetry reported by AKS. This includes: memory and processor metrics for controllers, nodes and containers logs, and logs from the individual containers. This data is accessible through Azure Log Analytics for the AKS cluster and Azure Monitor instance.<br>We recommend storing memory and processor metrics from containers, nodes, and controllers. This enables strong real-time and post-mortem analysis of unknown behaviors in AKS clusters.<br><h4>Fix - Runtime</h4>CLI Command<br>To enable Azure Monitor for an existing AKS cluster, use the following command:<br>az aks enable-addons<br>-a monitoring -n rg-weu-my-cluster -g rg-weu-my-cluster-group<br>--workspace-resource-id 4ab81b6f-c07d-d174-ef26-f4344bad14a<br><br>Use the default Log Analytics workspace:<br>az aks enable-addons<br>-a monitoring -n rg-weu-my-cluster -g rg-weu-my-cluster-group<br><br>This will take a few moments. When complete, you can verify using the show command:<br>az aks show -n rg-weu-my-cluster -g rg-weu-my-cluster-group<br><br>This provides general AKS information, including the following portion for:<br>ShelladdonProfiles<br>\"addonProfiles\": {<br>\"omsagent\": {<br>\"config\": {<br>\"logAnalyticsWorkspaceResourceID\":<br>\"/subscriptions/GUID/resourcegroups/defaultresourcegroup-weu/providers<br>/microsoft.operationalinsights/workspaces/defaultworkspace-GUID-weu\"<br>},<br>\"enabled\": true<br>}<br>},<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_kubernetes_cluster<br>Argument: log_analytics_workspace_id<br><br>Goresource \"azurerm_resource_group\" \"example\" {<br>name     = \"example-resources\"<br>location = \"West Europe\"<br>}<br><br>resource \"azurerm_kubernetes_cluster\" \"example\" {<br>name                = \"example-aks1\"<br>location            = azurerm_resource_group.example.location<br>resource_group_name = azurerm_resource_group.example.name<br>dns_prefix          = \"exampleaks1\"<br><br>default_node_pool {<br>name       = \"default\"<br>node_count = 1<br>vm_size    = \"Standard_D2_v2\"<br>}<br><br>addon_profile {<br>oms_agent {<br>enabled                    = true<br>log_analytics_workspace_id = \"workspaceResourceId\"<br>}<br>}<br><br>tags = {<br>Environment = \"Production\"<br>}<br>}<br><br>output \"client_certificate\" {<br>value = azurerm_kubernetes_cluster.example.kube_config.0.client_certificate<br>}<br><br>output \"kube_config\" {<br>value = azurerm_kubernetes_cluster.example.kube_config_raw<br>}<br><br>ARM Template<br><br>Resource: Microsoft.ContainerService/managedClusters<br>Argument: logAnalyticsWorkspaceResourceID<br><br>Go{<br>\"$schema\": \"https://schema.management.azure.com/schemas/2015-01-01/deploymentTemplate.json#\",<br>\"contentVersion\": \"1.0.0.0\",<br>\"parameters\": {<br>\"aksResourceId\": {<br>\"type\": \"string\",<br>\"metadata\": {<br>\"description\": \"AKS Cluster Resource ID\"<br>}<br>},<br>\"aksResourceLocation\": {<br>\"type\": \"string\",<br>\"metadata\": {<br>\"description\": \"Location of the AKS resource e.g. \\\"East US\\\"\"<br>}<br>},<br>\"aksResourceTagValues\": {<br>\"type\": \"object\",<br>\"metadata\": {<br>\"description\": \"Existing all tags on AKS Cluster Resource\"<br>}<br>},<br>\"workspaceResourceId\": {<br>\"type\": \"string\",<br>\"metadata\": {<br>\"description\": \"Azure Monitor Log Analytics Resource ID\"<br>}<br>}<br>},<br>\"resources\": [<br>{<br>\"name\": \"[split(parameters('aksResourceId'),'/')[8]]\",<br>\"type\": \"Microsoft.ContainerService/managedClusters\",<br>\"location\": \"[parameters('aksResourceLocation')]\",<br>\"tags\": \"[parameters('aksResourceTagValues')]\",<br>\"apiVersion\": \"2018-03-31\",<br>\"properties\": {<br>\"mode\": \"Incremental\",<br>\"id\": \"[parameters('aksResourceId')]\",<br>\"addonProfiles\": {<br>\"omsagent\": {<br>\"enabled\": true,<br>\"config\": {<br>+             \"logAnalyticsWorkspaceResourceID\": \"[parameters('workspaceResourceId')]\"<br>}<br>}<br>}<br>}<br>}<br>]<br>}<br>"
    },
    "CKV_AZURE_5": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_kubernetes_2",
        "severity": "HIGH",
        "description": "<h4>Azure AKS enable RBAC not enforced</h4><h4>Description</h4>Azure Kubernetes Service (AKS) can be configured to use Azure Active Directory (AD) and Kubernetes Role-based Access Control (RBAC). RBAC is designed to work on resources within your AKS clusters. With RBAC, you can create a role definition that outlines the permissions to be applied. A user or group is then assigned this role definition for a particular scope, which could be an individual resource, a resource group, or across the subscription.<br>We recommend you sign in to an AKS cluster using an Azure AD authentication token and configure Kubernetes RBAC. This will limit access to cluster resources based a user's identity or group membership.<br><h4>Fix - Buildtime</h4>Terraform<br>Resource: azurerm_kubernetes_cluster<br>Argument: role_based_access_control_enabled<br>azurerm_kubernetes_cluster.pike.tfresource \"azurerm_kubernetes_cluster\" \"pike\" {<br>...<br>+ role_based_access_control_enabled = true<br>...<br>}<br>"
    },
    "CKV_AZURE_6": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_kubernetes_3",
        "severity": "LOW",
        "description": "<h4>AKS API server does not define authorized IP ranges</h4><h4>Description</h4>The AKS API server receives requests to perform actions in the cluster , for example, to create resources, and scale the number of nodes. The API server provides a secure way to manage a cluster.<br>To enhance cluster security and minimize attacks, the API server should only be accessible from a limited set of IP address ranges. These IP ranges allow defined IP address ranges to communicate with the API server. A request made to the API server from an IP address that is not part of these authorized IP ranges is blocked.<br><h4>Fix - Runtime</h4>CLI Command<br>When you specify a CIDR range, start with the first IP address in the range.<br>Shellaz aks create \\<br>--resource-group myResourceGroup \\<br>--name myAKSCluster \\<br>--node-count 1 \\<br>--vm-set-type VirtualMachineScaleSets \\<br>--load-balancer-sku standard \\<br>--api-server-authorized-ip-ranges 73.140.245.0/24 \\<br>--generate-ssh-keys<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_kubernetes_cluster<br>Argument: api_server_authorized_ip_ranges (Optional)<br>The IP ranges to whitelist for incoming traffic to the masters.<br><br>Goresource \"azurerm_resource_group\" \"example\" {<br>name     = \"example-resources\"<br>location = \"West Europe\"<br>}<br><br>resource \"azurerm_kubernetes_cluster\" \"example\" {<br>...<br>+   api_server_authorized_ip_ranges = '192.168.0.0/16'<br>...<br>}<br><br>output \"client_certificate\" {<br>value = azurerm_kubernetes_cluster.example.kube_config.0.client_certificate<br>}<br><br>output \"kube_config\" {<br>value = azurerm_kubernetes_cluster.example.kube_config_raw<br>}<br><br>ARM Templates<br><br>Resource: Microsoft.ContainerService/managedClusters<br>Argument: apiServerAuthorizedIPRanges<br><br>Go{<br>\"name\": \"string\",<br>\"type\": \"Microsoft.ContainerService/managedClusters\",<br>\"apiVersion\": \"2019-06-01\",<br>\"location\": \"string\",<br>\"tags\": {},<br>\"properties\": {<br>\"kubernetesVersion\": \"string\",<br>\"dnsPrefix\": \"string\",<br>\"agentPoolProfiles\": [<br>{<br>\"count\": \"integer\",<br>\"vmSize\": \"string\",<br>\"osDiskSizeGB\": \"integer\",<br>\"vnetSubnetID\": \"string\",<br>\"maxPods\": \"integer\",<br>\"osType\": \"string\",<br>\"maxCount\": \"integer\",<br>\"minCount\": \"integer\",<br>\"enableAutoScaling\": \"boolean\",<br>\"type\": \"string\",<br>\"orchestratorVersion\": \"string\",<br>\"availabilityZones\": [<br>\"string\"<br>],<br>\"enableNodePublicIP\": \"boolean\",<br>\"scaleSetPriority\": \"string\",<br>\"scaleSetEvictionPolicy\": \"string\",<br>\"nodeTaints\": [<br>\"string\"<br>],<br>\"name\": \"string\"<br>}<br>],<br>\"linuxProfile\": {<br>\"adminUsername\": \"string\",<br>\"ssh\": {<br>\"publicKeys\": [<br>{<br>\"keyData\": \"string\"<br>}<br>]<br>}<br>},<br>\"windowsProfile\": {<br>\"adminUsername\": \"string\",<br>\"adminPassword\": \"string\"<br>},<br>\"servicePrincipalProfile\": {<br>\"clientId\": \"string\",<br>\"secret\": \"string\"<br>},<br>\"addonProfiles\": {},<br>\"nodeResourceGroup\": \"string\",<br>\"enableRBAC\": \"boolean\",<br>\"enablePodSecurityPolicy\": \"boolean\",<br>\"networkProfile\": {<br>\"networkPlugin\": \"string\",<br>\"networkPolicy\": \"string\",<br>\"podCidr\": \"string\",<br>\"serviceCidr\": \"string\",<br>\"dnsServiceIP\": \"string\",<br>\"dockerBridgeCidr\": \"string\",<br>\"loadBalancerSku\": \"string\"<br>},<br>\"aadProfile\": {<br>\"clientAppID\": \"string\",<br>\"serverAppID\": \"string\",<br>\"serverAppSecret\": \"string\",<br>\"tenantID\": \"string\"<br>},<br>+  \"apiServerAuthorizedIPRanges\": [<br>\"string\"<br>]<br>},<br>\"identity\": {<br>\"type\": \"string\"<br>},<br>\"resources\": []<br>}<br>"
    },
    "CKV_AZURE_7": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_kubernetes_4",
        "severity": "LOW",
        "description": "<h4>AKS cluster network policies are not enforced</h4><h4>Description</h4>Network policy options in AKS include two ways to implement a network policy. You can choose between Azure Network Policies or Calico Network Policies. In both cases, the underlying controlling layer is based on Linux IPTables to enforce the specified policies. Policies are translated into sets of allowed and disallowed IP pairs. These pairs are then programmed as IPTable rules.<br>The principle of least privilege should be applied to how traffic can flow between pods in an AKS cluster. We recommend you select a preferred network policy framework and enforce granular usage-based policies on the architecture and business logic of you applications.<br><h4>Fix - Buildtime</h4>Terraform<br>Resource: azurerm_kubernetes_cluster<br>Argument: network_plugin<br>azurerm_kubernetes_cluster.pike.tfresource \"azurerm_kubernetes_cluster\" \"pike\" {<br>...<br>network_profile {<br>network_plugin=\"azure\"<br>}<br>...<br>}<br>"
    },
    "CKV_AZURE_8": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_kubernetes_5",
        "severity": "LOW",
        "description": "<h4>Kubernetes dashboard is not disabled</h4><h4>Description</h4>The Terraform provider for Azure provides the capability to disable the Kubernetes dashboard on an AKS cluster. This is achieved by providing the Kubernetes dashboard as an AKS add-on like the Azure Monitor for containers integration, AKS virtual nodes, or HTTP application routing. The dashboard add-on is disabled by default for all new clusters created on Kubernetes 1.18 or greater.<br>In mid-2019 Tesla was hacked and their Kubernetes dashboard was open to the internet. Hackers browsed around and found credentials, eventually managing to deploy pods running bitcoin mining software.<br>We recommend you disable the Kubernetes dashboard to prevent the need to manage its individual access interface, eliminating it as an attack vector.<br><h4>Fix - Runtime</h4>CLI Command<br>az aks disable-addons -g myRG -n myAKScluster -a kube-dashboard<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_kubernetes_cluster<br>Argument: kube_dashboard (required): Is the Kubernetes Dashboard enabled?<br><br>Go...<br>addon_profile {<br>kube_dashboard {<br>enabled = false<br>}<br>}<br>...<br><br>ARM Templates<br><br>Resource: Microsoft.ContainerService/managedClusters<br>Argument: kubeDashboard<br><br>Go...<br>\"addonProfiles\": {<br>\"kubeDashboard\": {<br>\"enabled\": false<br>}<br>},<br>...<br>"
    },
    "CKV_AZURE_44": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_storage_2",
        "severity": "MEDIUM",
        "description": "<h4>Storage account does not use the latest version of TLS encryption</h4><h4>Description</h4>Communication between a client application and an Azure Storage account is encrypted using Transport Layer Security (TLS). TLS is a standard cryptographic protocol that ensures privacy and data integrity between clients and services over the Internet.<br>Azure Storage currently supports three versions of the TLS protocol: 1.0, 1.1, and 1.2. Azure Storage uses TLS 1.2 on public HTTPS endpoints, but TLS 1.0 and TLS 1.1 are still supported for backward compatibility.<br>To follow security best practices and the latest PCI compliance standards, Microsoft recommends enabling the latest version of TLS protocol (TLS 1.2) for all your Microsoft Azure App Service web applications. PCI DSS information security standard requires that all websites accepting credit card payments uses TLS 1.2 after June 30, 2018.<br><h4>Fix - Runtime</h4>Azure Portal<br>To change the policy using the Azure Portal, follow these steps:<br><br>Log in to the Azure Portal at https://portal.azure.com.<br>Navigate to your storage account.<br>Select Configuration.<br>Under Minimum TLS version, use the drop-down to select the minimum version of TLS required to access data in this storage account, as shown in the following image.<br><br>CLI Command<br>The minimumTlsVersion property is not set by default when you create a storage account with Azure CLI. This property does not return a value until you explicitly set it. The storage account permits requests sent with TLS version 1.0 or greater if the property value is null.<br>Shellaz storage account create \\<br>--name <storage-account> \\<br>--resource-group <resource-group> \\<br>--kind StorageV2 \\<br>--location <location> \\<br>--min-tls-version TLS1_1<br><br>az storage account show \\<br>--name <storage-account> \\<br>--resource-group <resource-group> \\<br>--query minimumTlsVersion \\<br>--output tsv<br><br>az storage account update \\<br>--name <storage-account> \\<br>--resource-group <resource-group> \\<br>--min-tls-version TLS1_2<br><br>az storage account show \\<br>--name <storage-account> \\<br>--resource-group <resource-group> \\<br>--query minimumTlsVersion \\<br>--output tsv<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_storage_account<br>Attribute: min_tls_version (Optional)<br>The minimum supported TLS version for the storage account. Possible values are TLS1_0, TLS1_1, and TLS1_2. Defaults to TLS1_0 for new storage accounts. Use TLS1_2.<br><br>Goresource \"azurerm_storage_account\" \"test\" {<br>...<br>+  min_tls_version      = \"TLS1_2\"<br>...<br>}<br><br>ARM Template<br><br>Resource: Microsoft.Storage/storageAccounts<br>Argument: minimumTlsVersion<br>To configure the minimum TLS version for a storage account with a template, create a template with the MinimumTLSVersion property set to TLS1_0, TLS1_1, or TLS1_2.<br><br>Go{<br>\"$schema\": \"https://schema.management.azure.com/schemas/2015-01-01/deploymentTemplate.json#\",<br>\"contentVersion\": \"1.0.0.0\",<br>\"parameters\": {},<br>\"variables\": {<br>\"storageAccountName\": \"[concat(uniqueString(subscription().subscriptionId), 'tls')]\"<br>},<br>\"resources\": [<br>{<br>\"name\": \"[variables('storageAccountName')]\",<br>\"type\": \"Microsoft.Storage/storageAccounts\",<br>\"apiVersion\": \"2019-06-01\",<br>\"location\": \"<location>\",<br>\"properties\": {<br>\"minimumTlsVersion\": \"TLS1_2\"<br>},<br>\"dependsOn\": [],<br>\"sku\": {<br>\"name\": \"Standard_GRS\"<br>},<br>\"kind\": \"StorageV2\",<br>\"tags\": {}<br>}<br>]<br>}<br>"
    },
    "CKV_AZURE_47": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_networking_17",
        "severity": "HIGH",
        "description": "<h4>Azure MariaDB database server with SSL connection disabled</h4><h4>Description</h4>Azure Database for MariaDB supports connecting your Azure Database for MariaDB server to client applications using Secure Sockets Layer (SSL). Enforcing SSL connections between your database server and your client applications helps protect against 'man in the middle' attacks by encrypting the data stream between the server and your application. This configuration enforces that SSL is always enabled for accessing your database server.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resources: azurerm_mariadb_server<br>Argument: ssl_enforcement_enabled<br><br>Goresource \"azurerm_mariadb_server\" \"example\" {<br>...<br>+  ssl_enforcement_enabled = true<br>}<br>"
    },
    "CKV_AZURE_48": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_public_1",
        "severity": "HIGH",
        "description": "<h4>MariaDB servers do not have public network access enabled set to False</h4><h4>Description</h4>It is generally a good security practice to ensure that your MariaDB servers do not have public network access enabled, as this means that they are only accessible from within your private network. This can help to protect your database servers from unauthorized access, as external parties will not be able to connect to them over the internet. It is especially important to ensure that public network access is disabled if your MariaDB servers contain sensitive or confidential data.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resources: azurerm_mariadb_server<br>Argument: public_network_access_enabled is set to False.<br><br>Goresource \"azurerm_mariadb_server\" \"example\" {<br>...<br>+  public_network_access_enabled = false<br><br>}<br>"
    },
    "CKV_AZURE_49": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_general_13",
        "severity": "HIGH",
        "description": "<h4>Azure Linux scale set does not use an SSH key</h4><h4>Description</h4>The default option for a Linux scale set uses basic authentication as an access credential for the secure shell network protocol.<br>Using SSH keys instead of common credentials (i.e. username and password) represents the best way to secure your Linux scale sets against malicious activities such as brute-force attacks, by providing a level of authorization that can only be fulfilled by privileged users who have ownership to the private key associated with the public key created on these sets. An attacker may be able to get access to the linux scale set\u2019s public key, but without the associated private key, he/she will be unable to gain shell access to the server.<br><h4>Fix - Buildtime</h4>Terraform<br>Resource: azurerm_linux_virtual_machine_scale_set<br>Attribute: disable_password_authentication<br>azurerm_linux_virtual_machine_scale_set.example.tfresource \"azurerm_linux_virtual_machine_scale_set\" \"example\" {<br>...<br>~ disable_password_authentication = true<br>}<br>"
    },
    "CKV_AZURE_50": {
        "url": "https://docs.bridgecrew.io/docs/bc_azr_general_14",
        "severity": "MEDIUM",
        "description": "<h4>Virtual Machine extensions are installed</h4><h4>Description</h4>Ensure that your Microsoft Azure virtual machines (VMs) does not have extensions installed in order to follow your organization's security and compliance requirements. Azure virtual machine extensions are small cloud applications that provide post-deployment configuration and automation tasks for virtual machines. These extensions run with administrative privileges and could potentially access any configuration file or piece of data on a virtual machine.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_virtual_machine, azurerm_linux_virtual_machine<br>Argument: allow_extension_operations<br><br>azurerm_linux_virtual_machine.example.tfresource \"azurerm_linux_virtual_machine\" \"example\" {<br>...<br>~  allow_extension_operations=false<br>}<br>"
    },
    "CKV_AZURE_60": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-storage-account-enables-secure-transfer",
        "severity": "MEDIUM",
        "description": "<h4>Storage accounts without secure transfer enabled</h4><h4>Description</h4>The secure transfer option enhances the security of a storage account by only allowing requests to the storage account by a secure connection. For example, when calling REST APIs to access storage accounts, the connection must use HTTPS. Any requests using HTTP will be rejected when 'secure transfer required' is enabled. When using the Azure files service, connection without encryption will fail, including scenarios using SMB 2.1, SMB 3.0 without encryption, and some flavors of the Linux SMB client. Because Azure storage doesn\u2019t support HTTPS for custom domain names, this option is not applied when using a custom domain name.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_storage_account<br>Argument:  enable_https_traffic_only<br><br>Goresource \"azurerm_storage_account\" \"example\" {<br>...<br>+  enable_https_traffic_only = true<br>}<br>"
    },
    "CKV_AZURE_63": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-app-service-enables-http-logging",
        "severity": "LOW",
        "description": "<h4>App service does not enable HTTP logging</h4><h4>Description</h4>By enabling HTTP logging for your app service, you can collect this information and use it to monitor and troubleshoot your app, as well as identify any potential security issues or threats. This can help to ensure that your app is running smoothly and is secure from potential attacks.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_app_service<br>Argument: logs.http_logs<br><br>Goresource \"azurerm_app_service\" \"example\" {<br>name                = \"example-app-service\"<br>location            = azurerm_resource_group.example.location<br>resource_group_name = azurerm_resource_group.example.name<br>app_service_plan_id = azurerm_app_service_plan.example.id<br><br>+             logs {<br>+               http_logs {<br>retention_in_days = 4<br>retention_in_mb = 10<br>}<br>}<br><br>app_settings = {<br>\"SOME_KEY\" = \"some-value\"<br>}<br><br>connection_string {<br>name  = \"Database\"<br>type  = \"SQLServer\"<br>value = \"Server=some-server.mydomain.com;Integrated Security=SSPI\"<br>}<br>}<br>"
    },
    "CKV_AZURE_68": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-postgresql-server-disables-public-network-access",
        "severity": "LOW",
        "description": "<h4>PostgreSQL server does not disable public network access</h4><h4>Description</h4>Disabling the public network access property improves security by ensuring your Azure Database for PostgreSQL single servers can only be accessed from a private endpoint. This configuration strictly disables access from any public address space outside of Azure IP range and denies all logins that match IP or virtual network-based firewall rules.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_postgresql_server<br>Argument: public_network_access_enabled<br><br>Goresource \"azurerm_postgresql_server\" \"example\" {<br>...<br>+             public_network_access_enabled    = false<br>...<br>}<br>"
    },
    "CKV_AZURE_69": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-azure-defender-is-set-to-on-for-azure-sql-database-servers",
        "severity": "MEDIUM",
        "description": "<h4>Azure Security Center Defender is set to Off for Azure SQL database servers</h4><h4>Description</h4>Azure Defender is a cloud workload protection service that utilizes and agent-based deployment to analyze signals from Azure network fabric and the service control plane, to detect threats across all Azure resources. It can also analyze non-Azure resources, utilizing Azure Arc, including those on-premises and in both AWS and GCP (once they've been onboarded).<br>Azure Defender for SQL servers on machines extends the protections for your Azure-native SQL Servers to fully support hybrid environments and protect SQL servers (all supported version) hosted in Azure<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_security_center_subscription_pricing<br>Argument: resource_type - (Required) The resource type this setting affects. Ensure that SqlServers and SqlServerVirtualMachines are declared to pass this check.<br><br>Goresource \"azurerm_security_center_subscription_pricing\" \"example\" {<br>tier          = \"Standard\"<br>resource_type = \"AppServices,ContainerRegistry,KeyVaults,KubernetesService,SqlServers,SqlServerVirtualMachines,StorageAccounts,VirtualMachines,ARM,DNS\"<br>}<br>"
    },
    "CKV_AZURE_70": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-function-apps-is-only-accessible-over-https",
        "severity": "MEDIUM",
        "description": "<h4>Function apps are not only accessible over HTTPS</h4><h4>Description</h4>By ensuring that function apps are only accessible over HTTPS, you can help to protect the data transmitted to and from your app from being accessed or modified by unauthorized parties. This can help to improve the security of your app and protect it from potential threats such as man-in-the-middle attacks or data breaches.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_app_service<br>Argument:https_only<br><br>Goresource \"azurerm_app_service\" \"example\" {<br>...<br>+            https_only          = true<br>}<br>"
    },
    "CKV_AZURE_71": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-managed-identity-provider-is-enabled-for-app-services",
        "severity": "LOW",
        "description": "<h4>Azure App Service Web app does not have a Managed Service Identity</h4><h4>Description</h4>Managed service identity in App Service makes the app more secure by eliminating secrets from the app, such as credentials in the connection strings. When registering with Azure Active Directory in the app service, the app will connect to other Azure services securely without the need of username and passwords.<br><h4>Fix - Runtime</h4>In Azure Console<br><br>Log in to the Azure portal.<br>Navigate to App Services.<br>Click on the reported App.<br>Under Setting section, Click on 'Identity'.<br>Ensure that 'Status' is set to 'On'.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_app_service<br>Argument: identity.type<br><br>Goresource \"azurerm_app_service\" \"example\" {<br>...<br>+           identity {<br>+             type = \"SystemAssigned\"<br>}<br>}<br>"
    },
    "CKV_AZURE_73": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-automation-account-variables-are-encrypted",
        "severity": "LOW",
        "description": "<h4>Azure Automation account variables are not encrypted</h4><h4>Description</h4>If you have Automation Account Variables storing sensitive data that are not already encrypted, then you will need to delete them and recreate them as encrypted variables.<br><h4>Fix - Runtime</h4>In Azure CLI<br>TextSet-AzAutomationVariable -AutomationAccountName '{AutomationAccountName}' -Encrypted $true -Name '{VariableName}' -ResourceGroupName '{ResourceGroupName}' -Value '{Value}'<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_automation_variable_int<br>Argument: encrypted<br><br>Goresource \"azurerm_automation_variable_int\" \"example\" {<br>...<br>+ encrypted               = true<br>}<br>"
    },
    "CKV_AZURE_74": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-azure-data-explorer-uses-disk-encryption",
        "severity": "LOW",
        "description": "<h4>Azure Data Explorer does not use disk encryption</h4><h4>Description</h4>Enabling encryption at rest using a customer-managed key on your Azure Data Explorer cluster provides additional control over the key being used by the encryption at rest. This feature is oftentimes applicable to customers with special compliance requirements and requires a Key Vault to managing the keys.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_kusto_cluster<br>Argument: enable_disk_encryption<br><br>Goresource \"azurerm_kusto_cluster\" \"example\" {<br>...<br>+ enable_disk_encryption = true<br>}<br>"
    },
    "CKV_AZURE_75": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-azure-data-explorer-uses-double-encryption",
        "severity": "LOW",
        "description": "<h4>Azure Data Explorer does not use double encryption</h4><h4>Description</h4>Enabling double encryption helps protect and safeguard your data to meet your organizational security and compliance commitments. When double encryption has been enabled, data in the storage account is encrypted twice, once at the service level and once at the infrastructure level, using two different encryption algorithms and two different keys.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_kusto_cluster<br>Argument: double_encryption_enabled<br><br>Goresource \"azurerm_kusto_cluster\" \"example\" {<br>...<br>+ double_encryption_enabled = true<br>}<br>"
    },
    "CKV_AZURE_76": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-azure-batch-account-uses-key-vault-to-encrypt-data",
        "severity": "LOW",
        "description": "<h4>Azure Batch account does not use key vault to encrypt data</h4><h4>Description</h4>Use customer-managed keys to manage the encryption at rest of your Batch account's data. By default, customer data is encrypted with service-managed keys, but customer-managed keys are commonly required to meet regulatory compliance standards. Customer-managed keys enable the data to be encrypted with an Azure Key Vault key created and owned by you. You have full control and responsibility for the key lifecycle, including rotation and management.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_batch_account<br>Argument: key_vault_reference<br><br>Goresource \"azurerm_batch_account\" \"example\" {<br>...<br>+             key_vault_reference {<br>id = \"test\"<br>url = \"https://test.com\"<br>}<br>}<br>"
    },
    "CKV_AZURE_77": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-udp-services-are-restricted-from-the-internet",
        "severity": "HIGH",
        "description": "<h4>UDP Services are not restricted from the Internet</h4><h4>Description</h4>Disable Internet exposed UDP ports on network security groups. The potential security problem with broadly exposing UDP services over the Internet is that attackers can use DDoS amplification techniques to reflect spoofed UDP traffic from Azure Virtual Machines. The most common types of these attacks use exposed DNS, NTP, SSDP, SNMP, CLDAP and other UDP-based services as amplification source for disrupting services of other machines on the Azure Virtual Network or even attack networked devices outside of Azure.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_network_security_group<br>Argument:  protocol<br><br>Goresource \"azurerm_network_security_group\" \"example\" {<br><br>security_rule {<br>name                       = \"test123\"<br>priority                   = 100<br>direction                  = \"Inbound\"<br>+               access                     = \"Deny\"<br>+               protocol                   = \"Udp\"<br>source_port_range          = \"*\"<br>destination_port_range     = \"*\"<br>source_address_prefix      = \"*\"<br>destination_address_prefix = \"*\"<br>}<br>...<br>}<br>"
    },
    "CKV_AZURE_78": {
        "url": "https://docs.bridgecrew.io/docs/ensure-ftp-deployments-are-disabled",
        "severity": "MEDIUM",
        "description": "<h4>Azure App Services FTP deployment is All allowed</h4><h4>Description</h4>FTPS (Secure FTP) is used to enhance security for Azure web application using App Service as it adds an extra layer of security to the FTP protocol, and help you to comply with the industry standards and regulations. For enhanced security, it is highly advices to use FTP over TLS/SSL only. You can also disable both FTP and FTPS if you don't use FTP deployment.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_app_service<br>Argument: ftps_state - (Optional) State of FTP / FTPS service for this App Service. Possible values include: AllAllowed, FtpsOnly and Disabled.<br><br>Goresource \"azurerm_app_service\" \"example\" {<br>...<br>+ ftps_state = \"FtpsOnly\"<br>}<br>"
    },
    "CKV_AZURE_79": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-azure-defender-is-set-to-on-for-sql-servers-on-machines",
        "severity": "MEDIUM",
        "description": "<h4>Azure Defender is set to Off for SQL servers on machines</h4><h4>Description</h4>Azure Defender is a cloud workload protection service that utilizes and agent-based deployment to analyze signals from Azure network fabric and the service control plane, to detect threats across all Azure resources. It can also analyze non-Azure resources, utilizing Azure Arc, including those on-premises and in both AWS and GCP (once they've been onboarded).<br>Azure Defender for SQL servers on machines extends the protections for your Azure-native SQL Servers to fully support hybrid environments and protect SQL servers (all supported version) hosted in Azure.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_security_center_subscription_pricing<br>Argument: resource_type - (Required) The resource type this setting affects. Ensure that SqlServers and SqlServerVirtualMachines are declared to pass this check.<br><br>Goresource \"azurerm_security_center_subscription_pricing\" \"example\" {<br>tier          = \"Standard\"<br>resource_type = \"AppServices,ContainerRegistry,KeyVaults,KubernetesService,SqlServers,SqlServerVirtualMachines,StorageAccounts,VirtualMachines,ARM,DNS\"<br>}<br>"
    },
    "CKV_AZURE_72": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-remote-debugging-is-not-enabled-for-app-services",
        "severity": "LOW",
        "description": "<h4>Remote debugging is enabled for app services</h4><h4>Description</h4>Remote debugging allows you to remotely connect to a running app and debug it from a different location. While this can be useful for developers who need to troubleshoot issues with their app, it also introduces a potential security risk because it allows someone to remotely access your app and potentially modify its code or behavior.<br>If remote debugging is enabled for your app services, it could potentially be exploited by an attacker to gain unauthorized access to your app and potentially compromise it. This could result in data loss, financial damage, or other negative consequences.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_app_service<br>Argument: remote_debugging_enabled<br><br>Goresource \"azurerm_app_service\" \"example\" {<br>...<br>+                  remote_debugging_enabled = false<br>}<br>"
    },
    "CKV_AZURE_85": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-azure-defender-is-set-to-on-for-kubernetes",
        "severity": "HIGH",
        "description": "<h4>Azure Security Center Defender is set to Off for Kubernetes</h4><h4>Description</h4>Azure Defender is a cloud workload protection service that utilizes and agent-based deployment to analyze signals from Azure network fabric and the service control plane, to detect threats across all Azure resources. It can also analyze non-Azure resources, utilizing Azure Arc, including those on-premises and in both AWS and GCP (once they've been onboarded).<br>Azure Defender for Kubernetes provides cluster-level threat protection by monitoring your AKS-managed services through the logs retrieved by Azure Kubernetes Service (AKS).<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_security_center_subscription_pricing<br>Argument: resource_type - (Required) The resource type this setting affects. Ensure that KubernetesService is declared to pass this check.<br><br>Goresource \"azurerm_security_center_subscription_pricing\" \"example\" {<br>tier          = \"Standard\"<br>resource_type = \"AppServices,ContainerRegistry,KeyVaults,KubernetesService,SqlServers,SqlServerVirtualMachines,StorageAccounts,VirtualMachines,ARM,DNS\"<br>}<br>"
    },
    "CKV_AZURE_86": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-azure-defender-is-set-to-on-for-container-registries",
        "severity": "HIGH",
        "description": "<h4>Azure Defender is set to Off for container registries</h4><h4>Description</h4>Azure Defender is a cloud workload protection service that utilizes and agent-based deployment to analyze signals from Azure network fabric and the service control plane, to detect threats across all Azure resources. It can also analyze non-Azure resources, utilizing Azure Arc, including those on-premises and in both AWS and GCP (once they've been onboarded).<br>Azure Defender for container registries includes a vulnerability scanner to scan the images in Azure Resource Manager-based Azure Container Registry registries and provide deeper visibility image vulnerabilities.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_security_center_subscription_pricing<br>Argument: resource_type - (Required) The resource type this setting affects. Ensure that ContainerRegistry is declared to pass this check.<br><br>Goresource \"azurerm_security_center_subscription_pricing\" \"example\" {<br>tier          = \"Standard\"<br>resource_type = \"AppServices,ContainerRegistry,KeyVaults,KubernetesService,SqlServers,SqlServerVirtualMachines,StorageAccounts,VirtualMachines,ARM,DNS\"<br>}<br>"
    },
    "CKV_AZURE_87": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-azure-defender-is-set-to-on-for-key-vault",
        "severity": "MEDIUM",
        "description": "<h4>Azure Security Center Defender set to Off for Key Vault</h4><h4>Description</h4>Azure Defender is a cloud workload protection service that utilizes and agent-based deployment to analyze signals from Azure network fabric and the service control plane, to detect threats across all Azure resources. It can also analyze non-Azure resources, utilizing Azure Arc, including those on-premises and in both AWS and GCP (once they've been onboarded).<br>Azure Defender detects unusual and potentially harmful attempts to access or exploit Key Vault accounts.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_security_center_subscription_pricing<br>Argument: resource_type - (Required) The resource type this setting affects. Ensure that KeyVaults is declared to pass this check.<br><br>Goresource \"azurerm_security_center_subscription_pricing\" \"example\" {<br>tier          = \"Standard\"<br>resource_type = \"AppServices,ContainerRegistry,KeyVaults,KubernetesService,SqlServers,SqlServerVirtualMachines,StorageAccounts,VirtualMachines,ARM,DNS\"<br>}<br>"
    },
    "CKV_AZURE_92": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-virtual-machines-use-managed-disks",
        "severity": "LOW",
        "description": "<h4>Azure Virtual Machines are not utilizing managed disks</h4><h4>Description</h4>Using Azure Managed disk over traditional BLOB based VHD's has more advantage features like Managed disks are by default encrypted, reduces cost over storage accounts and more resilient as Microsoft will manage the disk storage and move around if underlying hardware goes faulty. It is recommended to move BLOB based VHD's to Managed Disks.<br><h4>Fix - Runtime</h4>In Azure CLI<br><br>Log in to the Azure Portal<br>Select 'Virtual Machines' from the left pane<br>Select the reported virtual machine<br>Select 'Disks' under 'Settings'<br>Click on 'Migrate to managed disks'<br>Select 'Migrate'\", \"remediable\": false,<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_windows_virtual_machine<br>Argument: storage_os_disk<br><br>Goresource \"azurerm_windows_virtual_machine\" \"example\" {<br>...<br>+ storage_os_disk {<br>name              = \"myosdisk1\"<br>caching           = \"ReadWrite\"<br>create_option     = \"FromImage\"<br>managed_disk_type = \"Standard_LRS\"<br>}<br>...<br>}<br>"
    },
    "CKV_AZURE_95": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-automatic-os-image-patching-is-enabled-for-virtual-machine-scale-sets",
        "severity": "LOW",
        "description": "<h4>Automatic OS image patching is disabled for Virtual Machine scale sets</h4><h4>Description</h4>This policy enforces enabling automatic OS image patching on Virtual Machine Scale Sets to always keep Virtual Machines secure by safely applying latest security patches every month.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_virtual_machine_scale_set<br>Argument: automatic_os_upgrade<br><br>Goresource \"azurerm_virtual_machine_scale_set\" \"example\" {<br>...<br>+        automatic_os_upgrade = true<br>...<br>}<br>"
    },
    "CKV_AZURE_96": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-postgresql-server-enables-infrastructure-encryption-1",
        "severity": "LOW",
        "description": "<h4>MySQL server disables infrastructure encryption</h4><h4>Description</h4>Enable infrastructure encryption for Azure Database for MySQL servers to have higher level of assurance that the data is secure. When infrastructure encryption is enabled, the data at rest is encrypted twice using FIPS 140-2 compliant Microsoft managed keys.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_mysql_server<br>Argument: infrastructure_encryption_enabled<br><br>Goresource \"azurerm_mysql_server\" \"example\" {<br>...<br>+ infrastructure_encryption_enabled = true<br>}<br>"
    },
    "CKV_AZURE_98": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-azure-container-container-group-is-deployed-into-virtual-network",
        "severity": "LOW",
        "description": "<h4>Azure container container group is not deployed into a virtual network</h4><h4>Description</h4>A virtual network is a logical network in Azure that is isolated from other networks. When you deploy a container group into a virtual network, you can control the inbound and outbound network traffic to and from your container group using network security groups (NSGs) and service endpoints. This can help to improve the security of your container group and protect it from unauthorized access or attacks.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_container_group<br>Argument: network_profile_id<br><br>Goresource \"azurerm_container_group\" \"example\" {<br>...<br><br>+           network_profile_id = \"network_profile_id\"<br>}<br>"
    },
    "CKV_AZURE_99": {
        "url": "https://docs.bridgecrew.io/docs/ensure-cosmos-db-accounts-have-restricted-access",
        "severity": "LOW",
        "description": "<h4>Cosmos DB accounts do not have restricted access</h4><h4>Description</h4>Cosmos DB is a globally distributed database service that provides multiple ways to secure and protect your data, such as network isolation, virtual networks, Azure Private Link, and Azure AD authentication. By restricting access to your Cosmos DB account, you can control who can access your database and what actions they can perform on it.<br>By ensuring that your Cosmos DB accounts have restricted access, you can help to improve the security of your database and protect it from unauthorized access or attacks. This can help to ensure that your database is secure and available for your users.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_cosmosdb_account<br>Argument:public_network_access_enabled<br><br>Goresource \"azurerm_cosmosdb_account\" \"db\" {<br>...<br>+            public_network_access_enabled = false<br>...<br>}<br>"
    },
    "CKV_AZURE_100": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-cosmos-db-accounts-have-customer-managed-keys-to-encrypt-data-at-rest",
        "severity": "LOW",
        "description": "<h4>Cosmos DB Accounts do not have customer-managed keys encrypting data at rest</h4><h4>Description</h4>Data stored in Azure Cosmos account is automatically encrypted with keys managed by Microsoft (service-managed keys). Customer-managed keys (CMKs) give users total control over the keys used by Azure Cosmos DB to encrypt their data at rest. Built as an additional encryption layer on top of the Azure Cosmos DB default encryption at rest with service managed keys, it uses Azure Key Vault to store encryption keys and provides a way to implement double encryption.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_cosmosdb_account<br>Argument: key_vault_key_id - (Optional) A versionless Key Vault Key ID for CMK encryption. Changing this forces a new resource to be created.<br><br>Goresource \"azurerm_cosmosdb_account\" \"db\" {<br>name                = \"tfex-cosmos-db-${random_integer.ri.result}\"<br>location            = azurerm_resource_group.rg.location<br>resource_group_name = azurerm_resource_group.rg.name<br>offer_type          = \"Standard\"<br>kind                = \"GlobalDocumentDB\"<br><br>enable_automatic_failover = true<br><br>capabilities {<br>name = \"EnableAggregationPipeline\"<br>}<br><br>capabilities {<br>name = \"mongoEnableDocLevelTTL\"<br>}<br><br>capabilities {<br>name = \"MongoDBv3.4\"<br>}<br><br>consistency_policy {<br>consistency_level       = \"BoundedStaleness\"<br>max_interval_in_seconds = 10<br>max_staleness_prefix    = 200<br>}<br><br>geo_location {<br>location          = var.failover_location<br>failover_priority = 1<br>}<br><br>geo_location {<br>location          = azurerm_resource_group.rg.location<br>failover_priority = 0<br>}<br>}<br>"
    },
    "CKV_AZURE_110": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-key-vault-enables-purge-protection",
        "severity": "MEDIUM",
        "description": "<h4>Key vault disables purge protection</h4><h4>Description</h4>Purge protection is an optional Key Vault behavior and is not enabled by default. Purge protection can only be enabled once soft-delete is enabled. It can be turned on via CLI or PowerShell. When purge protection is on, a vault or an object in the deleted state cannot be purged until the retention period has passed. Soft-deleted vaults and objects can still be recovered, ensuring that the retention policy will be followed. The default retention period is 90 days, but it is possible to set the retention policy interval to a value from 7 to 90 days through the Azure portal. Once the retention policy interval is set and saved it cannot be changed for that vault.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_key_vault<br>Argument: purge_protection_enabled - (Optional) Is Purge Protection enabled for this Key Vault? Defaults to false.<br><br>Goresource \"azurerm_key_vault\" \"example\" {<br>...<br>+  purge_protection_enabled    = true<br>}<br>"
    },
    "CKV_AZURE_115": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-aks-enables-private-clusters",
        "severity": "LOW",
        "description": "<h4>AKS is not enabled for private clusters</h4><h4>Description</h4>Enable the private cluster feature for your Azure Kubernetes Service cluster to ensure network traffic between your API server and your node pools remains on the private network only. This is a common requirement in many regulatory and industry compliance standards.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_kubernetes_cluster<br>Argument: private_cluster_enabled<br><br>Goresource \"azurerm_kubernetes_cluster\" \"example\" {<br>...<br>+               private_cluster_enabled = true<br><br>}<br>"
    },
    "CKV_AZURE_118": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-network-interfaces-disable-ip-forwarding",
        "severity": "MEDIUM",
        "description": "<h4>Azure virtual machine NIC has IP forwarding enabled</h4><h4>Description</h4>By disabling IP forwarding on the NIC of your Azure virtual machine, you can help to prevent the virtual machine from acting as a router and forwarding traffic to unintended destinations. This can help to improve the security of your virtual machine and protect it from potential threats such as man-in-the-middle attacks or data breaches.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource:azurerm_network_interface<br>Argument: enable_ip_forwarding<br><br>Goresource \"azurerm_network_interface\" \"example\" {<br>...<br>+                enable_ip_forwarding = false<br>}<br>"
    },
    "CKV_AZURE_121": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-azure-front-door-enables-waf",
        "severity": "MEDIUM",
        "description": "<h4>Azure front door does not have WAF enabled</h4><h4>Description</h4>WAF is a security feature that provides protection for web applications by inspecting incoming traffic and blocking malicious requests before they reach the application. When WAF is enabled on an Azure Front Door, it analyzes incoming traffic to the front door and blocks requests that are determined to be malicious based on a set of rules. This can help to protect your application from a variety of threats, such as SQL injection attacks, cross-site scripting (XSS) attacks, and other types of attacks.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_frontdoor<br>Argument: web_application_firewall_policy_link_id<br><br>Goresource \"azurerm_frontdoor\" \"example\" {<br>...<br>+             web_application_firewall_policy_link_id = \"this_is_id\"<br>...<br>}<br>"
    },
    "CKV_AZURE_127": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-my-sql-server-enables-threat-detection-policy",
        "severity": "LOW",
        "description": "<h4>My SQL server does not enable Threat Detection policy</h4><h4>Description</h4>Enable Advanced Threat Detection on your non-Basic tier Azure database for MySQL servers to detect anomalous activities indicating unusual and potentially harmful attempts to access or exploit databases.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_mysql_server<br>Argument: threat_detection_policy.enabled<br><br>Goresource \"azurerm_mysql_server\" \"example\" {<br>...<br>+             threat_detection_policy {<br>+                 enabled = true<br>}<br>}<br>"
    },
    "CKV_AZURE_128": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-postgresql-server-enables-threat-detection-policy",
        "severity": "LOW",
        "description": "<h4>PostgreSQL server does not enable Threat Detection policy</h4><h4>Description</h4>Enable Advanced Threat Detection on your non-Basic tier Azure database for PostgreSQL servers to detect anomalous activities indicating unusual and potentially harmful attempts to access or exploit databases.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_postgresql_server<br>Argument:threat_detection_policy.enabled<br><br>Goresource \"azurerm_postgresql_server\" \"example\" {<br>...<br>+             threat_detection_policy {<br>+                 enabled = true<br>}<br>}<br>"
    },
    "CKV_AZURE_129": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-mariadb-server-enables-geo-redundant-backups",
        "severity": "LOW",
        "description": "<h4>MariaDB server does not enable geo-redundant backups</h4><h4>Description</h4>Ensure that your Microsoft Azure MariaDB database servers have geo-redundant backups enabled, to allow you to restore your MariaDB servers to a different Azure region in the event of a regional outage or a disaster.<br>Geo-restore is the default recovery option when your MariaDB database server is unavailable because of a large-scale incident, such as a natural disaster, occurs in the region where the database server is hosted. .During geo-restore, the MariaDB server configuration can be changed. These configuration changes include compute generation, vCore, backup retention period and backup redundancy options.<br><h4>Fix - Runtime</h4>In Azure console<br><br>Sign in to Azure Management Console.<br>Navigate to All resources blade at https://portal.azure.com/#blade/HubsExtension/BrowseAll to access all your Microsoft Azure resources.<br>From the Type filter box, select Azure Database for MariaDB server to list the MariaDB servers provisioned within your Azure account.<br>Click on the name of the MariaDB database server that you want to examine.<br>In the navigation panel, under Settings, select Pricing tier to access the pricing tier settings available for the selected MariaDB server.<br>On the Pricing tier page, in the Backup Redundancy Options section, check the backup redundancy tier configured for the database server. If the selected tier is Locally Redundant, the data can be recovered from within the current region only, therefore the Geo-Redundant backup feature is not enabled for the selected Microsoft Azure MariaDB database server.<br>Repeat steps no. 4 \u2013 6 for each MariaDB database server available in the current Azure subscription.<br>Repeat steps no. 3 \u2013 7 for each subscription created in your Microsoft Azure cloud account.<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_mariadb_server<br>Argument: geo_redundant_backup_enabled<br><br>Goresource \"azurerm_mariadb_server\" \"example\" {<br>...<br>+           geo_redundant_backup_enabled  = true<br>}<br>"
    },
    "CKV_AZURE_103": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-azure-data-factory-uses-git-repository-for-source-control",
        "severity": "LOW",
        "description": "<h4>Azure Data Factory does not use Git repository for source control</h4><h4>Description</h4>Azure Data Factory is an ETL service for  serverless data integration and data transformation. Azure Data Factory allows you to configure a Git repository with either Azure Repos or GitHub. Git is a version control system that allows for easier change tracking and collaboration.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_data_factory<br>Argument: github_configuration - (Optional) A github_configuration block as defined below.<br><br>Goresource \"azurerm_data_factory\" \"example\" {<br>....<br>github_configuration {<br>account_name    = \"${var.account_name}\"<br>branch_name     = \"${var.branch_name}\"<br>git_url         = \"${var.git_url}\"<br>repository_name = \"${var.repository_name}\"<br>root_folder     = \"${var.root_folder}\"<br>}<br><br>}<br>"
    },
    "CKV_AZURE_104": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-azure-data-factory-public-network-access-is-disabled",
        "severity": "HIGH",
        "description": "<h4>Azure Data Factory (V2) configured with overly permissive network access</h4><h4>Description</h4>By ensuring that your Azure Data factory is not public, you can help protect your data from unauthorized access or tampering. Public Azure Data factory instances are accessible over the internet, which can make them vulnerable to external threats such as hackers or malware. By making it private, you can help ensure that only authorized users can access the data.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_data_factory<br>Argument: public_network_enabled<br><br>Goresource \"azurerm_data_factory\" \"example\" {<br>...<br>+             public_network_enabled = false<br>}<br>"
    },
    "CKV_AZURE_55": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-azure-defender-is-set-to-on-for-servers",
        "severity": "MEDIUM",
        "description": "<h4>Azure Security Center Defender is set to Off for servers</h4><h4>Description</h4>Azure Defender is a cloud workload protection service that utilizes and agent-based deployment to analyze signals from Azure network fabric and the service control plane, to detect threats across all Azure resources. It can also analyze non-Azure resources, utilizing Azure Arc, including those on-premises and in both AWS and GCP (once they've been onboarded).<br>Azure Defender for servers adds threat detection and advanced defenses for Windows and Linux machines.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_security_center_subscription_pricing<br>Argument: resource_type - (Required) The resource type this setting affects. Ensure that SqlServers is declared to pass this check.<br><br>Goresource \"azurerm_security_center_subscription_pricing\" \"example\" {<br>tier          = \"Standard\"<br>resource_type = \"AppServices,ContainerRegistry,KeyVaults,KubernetesService,SqlServers,SqlServerVirtualMachines,StorageAccounts,VirtualMachines,ARM,DNS\"<br>}<br>"
    },
    "CKV_AZURE_56": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-function-apps-enables-authentication",
        "severity": "MEDIUM",
        "description": "<h4>Azure function app authentication is off</h4><h4>Description</h4>Azure App Service Authentication is a feature that can prevent anonymous HTTP requests from reaching the Function app, or authenticate those that have tokens before they reach the Function app.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_function_app<br>Argument: auth_settings.enabled<br><br>Goresource \"azurerm_function_app\" \"example\" {<br>...<br>+            auth_settings {<br>+              enabled = true<br>}<br>}<br>"
    },
    "CKV_AZURE_57": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-cors-disallows-every-resource-to-access-app-services",
        "severity": "LOW",
        "description": "<h4>CORS allows resource to access app services</h4><h4>Description</h4>Cross-Origin Resource Sharing (CORS) should not allow all domains to access your web application. Allow only required domains to interact with your web app.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_app_service<br>Argument: cors<br><br>Goresource \"azurerm_app_service\" \"example\" {<br>...<br>site_config {<br>+             cors {<br>+                    allowed_origins = [\"192.0.0.1\"]<br>+                                   }<br>}<br>"
    },
    "CKV_AZURE_58": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-azure-synapse-workspaces-enables-managed-virtual-networks",
        "severity": "LOW",
        "description": "<h4>Azure Synapse Workspaces do not enable managed virtual networks</h4><h4>Description</h4>Enabling managed virtual networks in Azure Synapse Workspaces can help to improve security and isolation for your data and workloads. By using a managed virtual network, you can control access to your data and resources by defining network security rules and configuring network routing. Managed virtual networks can also help to improve the performance of your data and analytics workloads by reducing network latency and optimizing network traffic.<br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_synapse_workspace<br>Argument: managed_virtual_network_enabled<br><br>Goresource \"azurerm_synapse_workspace\" \"example\" {<br>...<br>+             managed_virtual_network_enabled      = true<br>}<br>"
    },
    "CKV_AZURE_59": {
        "url": "https://docs.bridgecrew.io/docs/ensure-that-storage-accounts-disallow-public-access",
        "severity": "LOW",
        "description": "<h4>Ensure that Storage accounts disallow public access</h4><h4>Description</h4>As a best practice, do not allow anonymous/public access to storage accounts unless you have a very good reason. The all networks option includes the internet.<br><h4>Fix - Runtime</h4>In Azure Console<br><br>Log in to the Azure portal<br>Navigate to 'Storage Accounts'<br>Select the reported storage account<br>Under 'Security + networking section' section, Select 'Networking'<br>Under Firewall and virtual networks<br>Click on 'Change access level'<br>Set 'Public networks access' to 'anything but 'Enabled from all networks'<br>Click on Save'<br><br><h4>Fix - Buildtime</h4>Terraform<br><br>Resource: azurerm_storage_account<br>Argument: public_network_access_enabled<br><br>azurerm_storage_account.pike.tfres