import os
import sys
sys.path.insert(0, os.path.abspath('..'))
import iceprod
from iceprod.util import VERSION_STRING

# the dbmethod decorator and docstrings don't get along
# so turn the decorator off
def nodecorate(func):
    return func
#import iceprod.server.dbmethods
#iceprod.server.dbmethods.dbmethod = nodecorate

master_doc = "index"

project = 'IceProd'
copyright = '2016, IceCube Collaboration'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
is_master = False
try:
    with open('../.git/HEAD') as f:
        is_master = 'master' in f.read()
except:
    pass
if is_master:
    release = 'master'
    version = VERSION_STRING
else:
    release = VERSION_STRING
    version = VERSION_STRING

extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.coverage',
    'sphinx.ext.extlinks',
    'sphinx.ext.autosectionlabel',
    'sphinx.ext.intersphinx',
    'sphinx.ext.viewcode',
    'sphinx.ext.mathjax',
    'sphinx.ext.napoleon',
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = '.rst'


# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
#today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = []

# The reST default role (used for this markup: `text`) to use for all documents.
#default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
show_authors = True

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# A list of ignored prefixes for module index sorting.
#modindex_common_prefix = []

# -- Autodoc options -----------------------------------------------------------------

autodoc_member_order = 'bysource'
autoclass_content = 'both'
autodoc_default_options = {
  'members': True,
  'undoc-members': True,
}

# Without this line sphinx includes a copy of object.__init__'s docstring
# on any class that doesn't define __init__.
# https://bitbucket.org/birkenfeld/sphinx/issue/1337/autoclass_content-both-uses-object__init__
autodoc_docstring_signature = False

coverage_skip_undoc_in_source = True
coverage_ignore_modules = [
    'iceprod.core.tests'
    'iceprod.server.tests',
    ]
coverage_ignore_classes = [
    ]

coverage_ignore_functions = [
    # various modules
    "test",
    "main",
]

# -- Options for HTML output ---------------------------------------------------

html_theme = '_theme'
html_theme_path = ['.']

#html_favicon = None

# -- Options for LaTeX output --------------------------------------------------

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass [howto/manual]).
latex_documents = [
  ('index', 'IceProd.tex', u'IceProd Documentation',
   u'David Schultz', 'manual'),
]

intersphinx_mapping = {
    'python': ('https://docs.python.org/3.6/', None),
    'tornado': ('http://tornado.readthedocs.io/en/stable/', None),
    }
