HoToPy - A toolbox for X-ray holo-tomography in Python

# HoToPy

## Installation

### pip installation

HoToPy can be installed through pip by running
```commandline
pip install hotopy
```
for a basic HoToPy installation. 

The basic version does not contain the [`astra-toolbox`][astra] for tomographic reconstructions. If you intend to use
the _tomographic reconstruction functions_ in `hotopy.tomo` you can install its dependencies either by running
```commandline
pip install hotopy[tomo]
```
or you can have a look at the [astra-toolbox][astra] documentation for an installation method that fits your needs.

## Getting started

You can find examples in the dedicated [HoToPy-Examples repository](https://gitlab.gwdg.de/irp/hotopy-examples).

## Documentation

https://irp.pages.gwdg.de/hotopy/

## Paper & Citation

If you use HoToPy, please cite the paper [HoToPy: a toolbox for X-ray holo-tomography in Python][paper]

```
@article{Lucht2025_hotopy,
    author = "Lucht, Jens and Meyer, Paul and Lohse, Leon Merten and Salditt, Tim",
    title = "{{\it HoToPy}: a toolbox for X-ray holo-tomography in Python}",
    journal = "Journal of Synchrotron Radiation",
    year = "2025",
    volume = "32",
    number = "6",
    pages = "1586--1594",
    month = "Nov",
    doi = {10.1107/S1600577525008550},
    url = {https://doi.org/10.1107/S1600577525008550},
    keywords = {X-ray imaging, phase retrieval, computed tomography, phase contrast, holography},
}
```

[holotomo]: https://gitlab.gwdg.de/irp/holotomotoolbox
[astra]: https://astra-toolbox.com/
[paper]: https://doi.org/10.1107/S1600577525008550
