# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### BitmapDashboard <a name="BitmapDashboard" id="cdk-monitoring-constructs.BitmapDashboard"></a>

Specific subtype of dashboard that renders supported widgets as bitmaps, while preserving the overall layout.

#### Initializers <a name="Initializers" id="cdk-monitoring-constructs.BitmapDashboard.Initializer"></a>

```typescript
import { BitmapDashboard } from 'cdk-monitoring-constructs'

new BitmapDashboard(scope: Construct, id: string, props: DashboardProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.BitmapDashboard.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.BitmapDashboard.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.BitmapDashboard.Initializer.parameter.props">props</a></code> | <code>aws-cdk-lib.aws_cloudwatch.DashboardProps</code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-monitoring-constructs.BitmapDashboard.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-monitoring-constructs.BitmapDashboard.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.BitmapDashboard.Initializer.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.DashboardProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-monitoring-constructs.BitmapDashboard.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-monitoring-constructs.BitmapDashboard.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-monitoring-constructs.BitmapDashboard.addWidgets">addWidgets</a></code> | Add a widget to the dashboard. |

---

##### `toString` <a name="toString" id="cdk-monitoring-constructs.BitmapDashboard.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-monitoring-constructs.BitmapDashboard.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-monitoring-constructs.BitmapDashboard.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addWidgets` <a name="addWidgets" id="cdk-monitoring-constructs.BitmapDashboard.addWidgets"></a>

```typescript
public addWidgets(widgets: IWidget): void
```

Add a widget to the dashboard.

Widgets given in multiple calls to add() will be laid out stacked on
top of each other.

Multiple widgets added in the same call to add() will be laid out next
to each other.

###### `widgets`<sup>Required</sup> <a name="widgets" id="cdk-monitoring-constructs.BitmapDashboard.addWidgets.parameter.widgets"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.IWidget

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-monitoring-constructs.BitmapDashboard.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-monitoring-constructs.BitmapDashboard.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-monitoring-constructs.BitmapDashboard.isConstruct"></a>

```typescript
import { BitmapDashboard } from 'cdk-monitoring-constructs'

BitmapDashboard.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-monitoring-constructs.BitmapDashboard.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isResource` <a name="isResource" id="cdk-monitoring-constructs.BitmapDashboard.isResource"></a>

```typescript
import { BitmapDashboard } from 'cdk-monitoring-constructs'

BitmapDashboard.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-monitoring-constructs.BitmapDashboard.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.BitmapDashboard.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-monitoring-constructs.BitmapDashboard.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-monitoring-constructs.BitmapDashboard.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-monitoring-constructs.BitmapDashboard.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-monitoring-constructs.BitmapDashboard.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-monitoring-constructs.BitmapDashboard.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---


### BitmapWidgetRenderingSupport <a name="BitmapWidgetRenderingSupport" id="cdk-monitoring-constructs.BitmapWidgetRenderingSupport"></a>

Support for rendering bitmap widgets on the server side.

It is a custom widget lambda with some additional roles and helper methods.

#### Initializers <a name="Initializers" id="cdk-monitoring-constructs.BitmapWidgetRenderingSupport.Initializer"></a>

```typescript
import { BitmapWidgetRenderingSupport } from 'cdk-monitoring-constructs'

new BitmapWidgetRenderingSupport(scope: Construct, id: string)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.BitmapWidgetRenderingSupport.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.BitmapWidgetRenderingSupport.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-monitoring-constructs.BitmapWidgetRenderingSupport.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-monitoring-constructs.BitmapWidgetRenderingSupport.Initializer.parameter.id"></a>

- *Type:* string

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-monitoring-constructs.BitmapWidgetRenderingSupport.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-monitoring-constructs.BitmapWidgetRenderingSupport.asBitmap">asBitmap</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="cdk-monitoring-constructs.BitmapWidgetRenderingSupport.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `asBitmap` <a name="asBitmap" id="cdk-monitoring-constructs.BitmapWidgetRenderingSupport.asBitmap"></a>

```typescript
public asBitmap(widget: IWidget): CustomWidget
```

###### `widget`<sup>Required</sup> <a name="widget" id="cdk-monitoring-constructs.BitmapWidgetRenderingSupport.asBitmap.parameter.widget"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.IWidget

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-monitoring-constructs.BitmapWidgetRenderingSupport.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-monitoring-constructs.BitmapWidgetRenderingSupport.isConstruct"></a>

```typescript
import { BitmapWidgetRenderingSupport } from 'cdk-monitoring-constructs'

BitmapWidgetRenderingSupport.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-monitoring-constructs.BitmapWidgetRenderingSupport.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.BitmapWidgetRenderingSupport.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-monitoring-constructs.BitmapWidgetRenderingSupport.property.handler">handler</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-monitoring-constructs.BitmapWidgetRenderingSupport.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `handler`<sup>Required</sup> <a name="handler" id="cdk-monitoring-constructs.BitmapWidgetRenderingSupport.property.handler"></a>

```typescript
public readonly handler: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---


### DashboardWithBitmapCopy <a name="DashboardWithBitmapCopy" id="cdk-monitoring-constructs.DashboardWithBitmapCopy"></a>

Composite dashboard which keeps a normal dashboard with its bitmap copy.

The bitmap copy name will be derived from the primary dashboard name, if specified.

#### Initializers <a name="Initializers" id="cdk-monitoring-constructs.DashboardWithBitmapCopy.Initializer"></a>

```typescript
import { DashboardWithBitmapCopy } from 'cdk-monitoring-constructs'

new DashboardWithBitmapCopy(scope: Construct, id: string, props: DashboardProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.DashboardWithBitmapCopy.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DashboardWithBitmapCopy.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DashboardWithBitmapCopy.Initializer.parameter.props">props</a></code> | <code>aws-cdk-lib.aws_cloudwatch.DashboardProps</code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-monitoring-constructs.DashboardWithBitmapCopy.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-monitoring-constructs.DashboardWithBitmapCopy.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.DashboardWithBitmapCopy.Initializer.parameter.props"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.DashboardProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-monitoring-constructs.DashboardWithBitmapCopy.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-monitoring-constructs.DashboardWithBitmapCopy.applyRemovalPolicy">applyRemovalPolicy</a></code> | Apply the given removal policy to this resource. |
| <code><a href="#cdk-monitoring-constructs.DashboardWithBitmapCopy.addWidgets">addWidgets</a></code> | Add a widget to the dashboard. |

---

##### `toString` <a name="toString" id="cdk-monitoring-constructs.DashboardWithBitmapCopy.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `applyRemovalPolicy` <a name="applyRemovalPolicy" id="cdk-monitoring-constructs.DashboardWithBitmapCopy.applyRemovalPolicy"></a>

```typescript
public applyRemovalPolicy(policy: RemovalPolicy): void
```

Apply the given removal policy to this resource.

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

###### `policy`<sup>Required</sup> <a name="policy" id="cdk-monitoring-constructs.DashboardWithBitmapCopy.applyRemovalPolicy.parameter.policy"></a>

- *Type:* aws-cdk-lib.RemovalPolicy

---

##### `addWidgets` <a name="addWidgets" id="cdk-monitoring-constructs.DashboardWithBitmapCopy.addWidgets"></a>

```typescript
public addWidgets(widgets: IWidget): void
```

Add a widget to the dashboard.

Widgets given in multiple calls to add() will be laid out stacked on
top of each other.

Multiple widgets added in the same call to add() will be laid out next
to each other.

###### `widgets`<sup>Required</sup> <a name="widgets" id="cdk-monitoring-constructs.DashboardWithBitmapCopy.addWidgets.parameter.widgets"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.IWidget

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-monitoring-constructs.DashboardWithBitmapCopy.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-monitoring-constructs.DashboardWithBitmapCopy.isResource">isResource</a></code> | Check whether the given construct is a Resource. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-monitoring-constructs.DashboardWithBitmapCopy.isConstruct"></a>

```typescript
import { DashboardWithBitmapCopy } from 'cdk-monitoring-constructs'

DashboardWithBitmapCopy.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-monitoring-constructs.DashboardWithBitmapCopy.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `isResource` <a name="isResource" id="cdk-monitoring-constructs.DashboardWithBitmapCopy.isResource"></a>

```typescript
import { DashboardWithBitmapCopy } from 'cdk-monitoring-constructs'

DashboardWithBitmapCopy.isResource(construct: IConstruct)
```

Check whether the given construct is a Resource.

###### `construct`<sup>Required</sup> <a name="construct" id="cdk-monitoring-constructs.DashboardWithBitmapCopy.isResource.parameter.construct"></a>

- *Type:* constructs.IConstruct

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.DashboardWithBitmapCopy.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-monitoring-constructs.DashboardWithBitmapCopy.property.env">env</a></code> | <code>aws-cdk-lib.ResourceEnvironment</code> | The environment this resource belongs to. |
| <code><a href="#cdk-monitoring-constructs.DashboardWithBitmapCopy.property.stack">stack</a></code> | <code>aws-cdk-lib.Stack</code> | The stack in which this resource is defined. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-monitoring-constructs.DashboardWithBitmapCopy.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `env`<sup>Required</sup> <a name="env" id="cdk-monitoring-constructs.DashboardWithBitmapCopy.property.env"></a>

```typescript
public readonly env: ResourceEnvironment;
```

- *Type:* aws-cdk-lib.ResourceEnvironment

The environment this resource belongs to.

For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

---

##### `stack`<sup>Required</sup> <a name="stack" id="cdk-monitoring-constructs.DashboardWithBitmapCopy.property.stack"></a>

```typescript
public readonly stack: Stack;
```

- *Type:* aws-cdk-lib.Stack

The stack in which this resource is defined.

---


### DefaultDashboardFactory <a name="DefaultDashboardFactory" id="cdk-monitoring-constructs.DefaultDashboardFactory"></a>

- *Implements:* <a href="#cdk-monitoring-constructs.IDashboardFactory">IDashboardFactory</a>

#### Initializers <a name="Initializers" id="cdk-monitoring-constructs.DefaultDashboardFactory.Initializer"></a>

```typescript
import { DefaultDashboardFactory } from 'cdk-monitoring-constructs'

new DefaultDashboardFactory(scope: Construct, id: string, props: MonitoringDashboardsProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.DefaultDashboardFactory.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DefaultDashboardFactory.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DefaultDashboardFactory.Initializer.parameter.props">props</a></code> | <code><a href="#cdk-monitoring-constructs.MonitoringDashboardsProps">MonitoringDashboardsProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-monitoring-constructs.DefaultDashboardFactory.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-monitoring-constructs.DefaultDashboardFactory.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.DefaultDashboardFactory.Initializer.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.MonitoringDashboardsProps">MonitoringDashboardsProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-monitoring-constructs.DefaultDashboardFactory.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-monitoring-constructs.DefaultDashboardFactory.addSegment">addSegment</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DefaultDashboardFactory.createdAlarmDashboard">createdAlarmDashboard</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DefaultDashboardFactory.createdDashboard">createdDashboard</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DefaultDashboardFactory.createdSummaryDashboard">createdSummaryDashboard</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="cdk-monitoring-constructs.DefaultDashboardFactory.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addSegment` <a name="addSegment" id="cdk-monitoring-constructs.DefaultDashboardFactory.addSegment"></a>

```typescript
public addSegment(props: IDashboardFactoryProps): void
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.DefaultDashboardFactory.addSegment.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.IDashboardFactoryProps">IDashboardFactoryProps</a>

---

##### `createdAlarmDashboard` <a name="createdAlarmDashboard" id="cdk-monitoring-constructs.DefaultDashboardFactory.createdAlarmDashboard"></a>

```typescript
public createdAlarmDashboard(): Dashboard
```

##### `createdDashboard` <a name="createdDashboard" id="cdk-monitoring-constructs.DefaultDashboardFactory.createdDashboard"></a>

```typescript
public createdDashboard(): Dashboard
```

##### `createdSummaryDashboard` <a name="createdSummaryDashboard" id="cdk-monitoring-constructs.DefaultDashboardFactory.createdSummaryDashboard"></a>

```typescript
public createdSummaryDashboard(): Dashboard
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-monitoring-constructs.DefaultDashboardFactory.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-monitoring-constructs.DefaultDashboardFactory.isConstruct"></a>

```typescript
import { DefaultDashboardFactory } from 'cdk-monitoring-constructs'

DefaultDashboardFactory.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-monitoring-constructs.DefaultDashboardFactory.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.DefaultDashboardFactory.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-monitoring-constructs.DefaultDashboardFactory.property.anyDashboardCreated">anyDashboardCreated</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DefaultDashboardFactory.property.alarmDashboard">alarmDashboard</a></code> | <code>aws-cdk-lib.aws_cloudwatch.Dashboard</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DefaultDashboardFactory.property.dashboard">dashboard</a></code> | <code>aws-cdk-lib.aws_cloudwatch.Dashboard</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DefaultDashboardFactory.property.summaryDashboard">summaryDashboard</a></code> | <code>aws-cdk-lib.aws_cloudwatch.Dashboard</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-monitoring-constructs.DefaultDashboardFactory.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `anyDashboardCreated`<sup>Required</sup> <a name="anyDashboardCreated" id="cdk-monitoring-constructs.DefaultDashboardFactory.property.anyDashboardCreated"></a>

```typescript
public readonly anyDashboardCreated: boolean;
```

- *Type:* boolean

---

##### `alarmDashboard`<sup>Optional</sup> <a name="alarmDashboard" id="cdk-monitoring-constructs.DefaultDashboardFactory.property.alarmDashboard"></a>

```typescript
public readonly alarmDashboard: Dashboard;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.Dashboard

---

##### `dashboard`<sup>Optional</sup> <a name="dashboard" id="cdk-monitoring-constructs.DefaultDashboardFactory.property.dashboard"></a>

```typescript
public readonly dashboard: Dashboard;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.Dashboard

---

##### `summaryDashboard`<sup>Optional</sup> <a name="summaryDashboard" id="cdk-monitoring-constructs.DefaultDashboardFactory.property.summaryDashboard"></a>

```typescript
public readonly summaryDashboard: Dashboard;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.Dashboard

---


### MonitoringFacade <a name="MonitoringFacade" id="cdk-monitoring-constructs.MonitoringFacade"></a>

Main entry point to create your monitoring.

#### Initializers <a name="Initializers" id="cdk-monitoring-constructs.MonitoringFacade.Initializer"></a>

```typescript
import { MonitoringFacade } from 'cdk-monitoring-constructs'

new MonitoringFacade(scope: Construct, id: string, props?: MonitoringFacadeProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.Initializer.parameter.props">props</a></code> | <code><a href="#cdk-monitoring-constructs.MonitoringFacadeProps">MonitoringFacadeProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-monitoring-constructs.MonitoringFacade.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-monitoring-constructs.MonitoringFacade.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.Initializer.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.MonitoringFacadeProps">MonitoringFacadeProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.createAlarmFactory">createAlarmFactory</a></code> | Creates a new alarm factory. |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.createAwsConsoleUrlFactory">createAwsConsoleUrlFactory</a></code> | Creates a new factory that creates AWS Console URLs. |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.createMetricFactory">createMetricFactory</a></code> | Creates a new metric factory. |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.createWidgetFactory">createWidgetFactory</a></code> | Creates a new widget factory. |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.addLargeHeader">addLargeHeader</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.addMediumHeader">addMediumHeader</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.addSegment">addSegment</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.addSmallHeader">addSmallHeader</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.addWidget">addWidget</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.createCompositeAlarmUsingDisambiguator">createCompositeAlarmUsingDisambiguator</a></code> | Finds a subset of created alarms that are marked by a specific disambiguator and creates a composite alarm. |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.createCompositeAlarmUsingTag">createCompositeAlarmUsingTag</a></code> | Finds a subset of created alarms that are marked by a specific custom tag and creates a composite alarm. |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.createdAlarmDashboard">createdAlarmDashboard</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.createdAlarms">createdAlarms</a></code> | Returns the created alarms across all the monitorings added up until now. |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.createdAlarmsWithDisambiguator">createdAlarmsWithDisambiguator</a></code> | Returns a subset of created alarms that are marked by a specific disambiguator. |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.createdAlarmsWithTag">createdAlarmsWithTag</a></code> | Returns a subset of created alarms that are marked by a specific custom tag. |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.createdDashboard">createdDashboard</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.createdMonitorings">createdMonitorings</a></code> | Returns the created monitorings added up until now. |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.createdSummaryDashboard">createdSummaryDashboard</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorApiGateway">monitorApiGateway</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorApiGatewayV2HttpApi">monitorApiGatewayV2HttpApi</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorAppSyncApi">monitorAppSyncApi</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorAutoScalingGroup">monitorAutoScalingGroup</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorBilling">monitorBilling</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorCertificate">monitorCertificate</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorCloudFrontDistribution">monitorCloudFrontDistribution</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorCodeBuildProject">monitorCodeBuildProject</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorCustom">monitorCustom</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorDocumentDbCluster">monitorDocumentDbCluster</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorDynamoTable">monitorDynamoTable</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorDynamoTableGlobalSecondaryIndex">monitorDynamoTableGlobalSecondaryIndex</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorEc2ApplicationLoadBalancer">monitorEc2ApplicationLoadBalancer</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorEC2Instances">monitorEC2Instances</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorEc2NetworkLoadBalancer">monitorEc2NetworkLoadBalancer</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorEc2Service">monitorEc2Service</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorElastiCacheCluster">monitorElastiCacheCluster</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorElasticsearchCluster">monitorElasticsearchCluster</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorFargateApplicationLoadBalancer">monitorFargateApplicationLoadBalancer</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorFargateNetworkLoadBalancer">monitorFargateNetworkLoadBalancer</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorFargateService">monitorFargateService</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorGlueJob">monitorGlueJob</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorKinesisDataAnalytics">monitorKinesisDataAnalytics</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorKinesisDataStream">monitorKinesisDataStream</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorKinesisFirehose">monitorKinesisFirehose</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorLambdaFunction">monitorLambdaFunction</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorLog">monitorLog</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorNetworkLoadBalancer">monitorNetworkLoadBalancer</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorOpenSearchCluster">monitorOpenSearchCluster</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorQueueProcessingEc2Service">monitorQueueProcessingEc2Service</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorQueueProcessingFargateService">monitorQueueProcessingFargateService</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorRdsCluster">monitorRdsCluster</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorRedshiftCluster">monitorRedshiftCluster</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorS3Bucket">monitorS3Bucket</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorScope">monitorScope</a></code> | Monitor all the resources in the given scope. |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorSecretsManagerSecret">monitorSecretsManagerSecret</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorSimpleEc2Service">monitorSimpleEc2Service</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorSimpleFargateService">monitorSimpleFargateService</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorSnsTopic">monitorSnsTopic</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorSqsQueue">monitorSqsQueue</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorSqsQueueWithDlq">monitorSqsQueueWithDlq</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorStepFunction">monitorStepFunction</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorStepFunctionActivity">monitorStepFunctionActivity</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorStepFunctionLambdaIntegration">monitorStepFunctionLambdaIntegration</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorStepFunctionServiceIntegration">monitorStepFunctionServiceIntegration</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorSyntheticsCanary">monitorSyntheticsCanary</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.monitorWebApplicationFirewallAclV2">monitorWebApplicationFirewallAclV2</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="cdk-monitoring-constructs.MonitoringFacade.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `createAlarmFactory` <a name="createAlarmFactory" id="cdk-monitoring-constructs.MonitoringFacade.createAlarmFactory"></a>

```typescript
public createAlarmFactory(alarmNamePrefix: string): AlarmFactory
```

Creates a new alarm factory.

Alarms created will be named with the given prefix, unless a local name override is present.

###### `alarmNamePrefix`<sup>Required</sup> <a name="alarmNamePrefix" id="cdk-monitoring-constructs.MonitoringFacade.createAlarmFactory.parameter.alarmNamePrefix"></a>

- *Type:* string

---

##### `createAwsConsoleUrlFactory` <a name="createAwsConsoleUrlFactory" id="cdk-monitoring-constructs.MonitoringFacade.createAwsConsoleUrlFactory"></a>

```typescript
public createAwsConsoleUrlFactory(): AwsConsoleUrlFactory
```

Creates a new factory that creates AWS Console URLs.

##### `createMetricFactory` <a name="createMetricFactory" id="cdk-monitoring-constructs.MonitoringFacade.createMetricFactory"></a>

```typescript
public createMetricFactory(): MetricFactory
```

Creates a new metric factory.

##### `createWidgetFactory` <a name="createWidgetFactory" id="cdk-monitoring-constructs.MonitoringFacade.createWidgetFactory"></a>

```typescript
public createWidgetFactory(): IWidgetFactory
```

Creates a new widget factory.

##### `addLargeHeader` <a name="addLargeHeader" id="cdk-monitoring-constructs.MonitoringFacade.addLargeHeader"></a>

```typescript
public addLargeHeader(text: string, addToSummary?: boolean, addToAlarm?: boolean): MonitoringFacade
```

###### `text`<sup>Required</sup> <a name="text" id="cdk-monitoring-constructs.MonitoringFacade.addLargeHeader.parameter.text"></a>

- *Type:* string

---

###### `addToSummary`<sup>Optional</sup> <a name="addToSummary" id="cdk-monitoring-constructs.MonitoringFacade.addLargeHeader.parameter.addToSummary"></a>

- *Type:* boolean

---

###### `addToAlarm`<sup>Optional</sup> <a name="addToAlarm" id="cdk-monitoring-constructs.MonitoringFacade.addLargeHeader.parameter.addToAlarm"></a>

- *Type:* boolean

---

##### `addMediumHeader` <a name="addMediumHeader" id="cdk-monitoring-constructs.MonitoringFacade.addMediumHeader"></a>

```typescript
public addMediumHeader(text: string, addToSummary?: boolean, addToAlarm?: boolean): MonitoringFacade
```

###### `text`<sup>Required</sup> <a name="text" id="cdk-monitoring-constructs.MonitoringFacade.addMediumHeader.parameter.text"></a>

- *Type:* string

---

###### `addToSummary`<sup>Optional</sup> <a name="addToSummary" id="cdk-monitoring-constructs.MonitoringFacade.addMediumHeader.parameter.addToSummary"></a>

- *Type:* boolean

---

###### `addToAlarm`<sup>Optional</sup> <a name="addToAlarm" id="cdk-monitoring-constructs.MonitoringFacade.addMediumHeader.parameter.addToAlarm"></a>

- *Type:* boolean

---

##### `addSegment` <a name="addSegment" id="cdk-monitoring-constructs.MonitoringFacade.addSegment"></a>

```typescript
public addSegment(segment: IDashboardSegment, overrideProps?: MonitoringDashboardsOverrideProps): MonitoringFacade
```

###### `segment`<sup>Required</sup> <a name="segment" id="cdk-monitoring-constructs.MonitoringFacade.addSegment.parameter.segment"></a>

- *Type:* <a href="#cdk-monitoring-constructs.IDashboardSegment">IDashboardSegment</a>

---

###### `overrideProps`<sup>Optional</sup> <a name="overrideProps" id="cdk-monitoring-constructs.MonitoringFacade.addSegment.parameter.overrideProps"></a>

- *Type:* <a href="#cdk-monitoring-constructs.MonitoringDashboardsOverrideProps">MonitoringDashboardsOverrideProps</a>

---

##### `addSmallHeader` <a name="addSmallHeader" id="cdk-monitoring-constructs.MonitoringFacade.addSmallHeader"></a>

```typescript
public addSmallHeader(text: string, addToSummary?: boolean, addToAlarm?: boolean): MonitoringFacade
```

###### `text`<sup>Required</sup> <a name="text" id="cdk-monitoring-constructs.MonitoringFacade.addSmallHeader.parameter.text"></a>

- *Type:* string

---

###### `addToSummary`<sup>Optional</sup> <a name="addToSummary" id="cdk-monitoring-constructs.MonitoringFacade.addSmallHeader.parameter.addToSummary"></a>

- *Type:* boolean

---

###### `addToAlarm`<sup>Optional</sup> <a name="addToAlarm" id="cdk-monitoring-constructs.MonitoringFacade.addSmallHeader.parameter.addToAlarm"></a>

- *Type:* boolean

---

##### `addWidget` <a name="addWidget" id="cdk-monitoring-constructs.MonitoringFacade.addWidget"></a>

```typescript
public addWidget(widget: IWidget, addToSummary?: boolean, addToAlarm?: boolean): MonitoringFacade
```

###### `widget`<sup>Required</sup> <a name="widget" id="cdk-monitoring-constructs.MonitoringFacade.addWidget.parameter.widget"></a>

- *Type:* aws-cdk-lib.aws_cloudwatch.IWidget

---

###### `addToSummary`<sup>Optional</sup> <a name="addToSummary" id="cdk-monitoring-constructs.MonitoringFacade.addWidget.parameter.addToSummary"></a>

- *Type:* boolean

---

###### `addToAlarm`<sup>Optional</sup> <a name="addToAlarm" id="cdk-monitoring-constructs.MonitoringFacade.addWidget.parameter.addToAlarm"></a>

- *Type:* boolean

---

##### `createCompositeAlarmUsingDisambiguator` <a name="createCompositeAlarmUsingDisambiguator" id="cdk-monitoring-constructs.MonitoringFacade.createCompositeAlarmUsingDisambiguator"></a>

```typescript
public createCompositeAlarmUsingDisambiguator(alarmDisambiguator: string, props?: AddCompositeAlarmProps): CompositeAlarm
```

Finds a subset of created alarms that are marked by a specific disambiguator and creates a composite alarm.

This composite alarm is created with an 'OR' condition, so it triggers with any child alarm.
NOTE: This composite alarm is not added among other alarms, so it is not returned by createdAlarms() calls.

###### `alarmDisambiguator`<sup>Required</sup> <a name="alarmDisambiguator" id="cdk-monitoring-constructs.MonitoringFacade.createCompositeAlarmUsingDisambiguator.parameter.alarmDisambiguator"></a>

- *Type:* string

disambiguator to filter alarms by.

---

###### `props`<sup>Optional</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.createCompositeAlarmUsingDisambiguator.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.AddCompositeAlarmProps">AddCompositeAlarmProps</a>

customization options.

---

##### `createCompositeAlarmUsingTag` <a name="createCompositeAlarmUsingTag" id="cdk-monitoring-constructs.MonitoringFacade.createCompositeAlarmUsingTag"></a>

```typescript
public createCompositeAlarmUsingTag(customTag: string, props?: AddCompositeAlarmProps): CompositeAlarm
```

Finds a subset of created alarms that are marked by a specific custom tag and creates a composite alarm.

This composite alarm is created with an 'OR' condition, so it triggers with any child alarm.
NOTE: This composite alarm is not added among other alarms, so it is not returned by createdAlarms() calls.

###### `customTag`<sup>Required</sup> <a name="customTag" id="cdk-monitoring-constructs.MonitoringFacade.createCompositeAlarmUsingTag.parameter.customTag"></a>

- *Type:* string

tag to filter alarms by.

---

###### `props`<sup>Optional</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.createCompositeAlarmUsingTag.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.AddCompositeAlarmProps">AddCompositeAlarmProps</a>

customization options.

---

##### `createdAlarmDashboard` <a name="createdAlarmDashboard" id="cdk-monitoring-constructs.MonitoringFacade.createdAlarmDashboard"></a>

```typescript
public createdAlarmDashboard(): Dashboard
```

##### `createdAlarms` <a name="createdAlarms" id="cdk-monitoring-constructs.MonitoringFacade.createdAlarms"></a>

```typescript
public createdAlarms(): AlarmWithAnnotation[]
```

Returns the created alarms across all the monitorings added up until now.

##### `createdAlarmsWithDisambiguator` <a name="createdAlarmsWithDisambiguator" id="cdk-monitoring-constructs.MonitoringFacade.createdAlarmsWithDisambiguator"></a>

```typescript
public createdAlarmsWithDisambiguator(disambiguator: string): AlarmWithAnnotation[]
```

Returns a subset of created alarms that are marked by a specific disambiguator.

###### `disambiguator`<sup>Required</sup> <a name="disambiguator" id="cdk-monitoring-constructs.MonitoringFacade.createdAlarmsWithDisambiguator.parameter.disambiguator"></a>

- *Type:* string

disambiguator to filter alarms by.

---

##### `createdAlarmsWithTag` <a name="createdAlarmsWithTag" id="cdk-monitoring-constructs.MonitoringFacade.createdAlarmsWithTag"></a>

```typescript
public createdAlarmsWithTag(customTag: string): AlarmWithAnnotation[]
```

Returns a subset of created alarms that are marked by a specific custom tag.

###### `customTag`<sup>Required</sup> <a name="customTag" id="cdk-monitoring-constructs.MonitoringFacade.createdAlarmsWithTag.parameter.customTag"></a>

- *Type:* string

tag to filter alarms by.

---

##### `createdDashboard` <a name="createdDashboard" id="cdk-monitoring-constructs.MonitoringFacade.createdDashboard"></a>

```typescript
public createdDashboard(): Dashboard
```

##### `createdMonitorings` <a name="createdMonitorings" id="cdk-monitoring-constructs.MonitoringFacade.createdMonitorings"></a>

```typescript
public createdMonitorings(): Monitoring[]
```

Returns the created monitorings added up until now.

##### `createdSummaryDashboard` <a name="createdSummaryDashboard" id="cdk-monitoring-constructs.MonitoringFacade.createdSummaryDashboard"></a>

```typescript
public createdSummaryDashboard(): Dashboard
```

##### `monitorApiGateway` <a name="monitorApiGateway" id="cdk-monitoring-constructs.MonitoringFacade.monitorApiGateway"></a>

```typescript
public monitorApiGateway(props: ApiGatewayMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorApiGateway.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps">ApiGatewayMonitoringProps</a>

---

##### `monitorApiGatewayV2HttpApi` <a name="monitorApiGatewayV2HttpApi" id="cdk-monitoring-constructs.MonitoringFacade.monitorApiGatewayV2HttpApi"></a>

```typescript
public monitorApiGatewayV2HttpApi(props: ApiGatewayV2HttpApiMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorApiGatewayV2HttpApi.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps">ApiGatewayV2HttpApiMonitoringProps</a>

---

##### `monitorAppSyncApi` <a name="monitorAppSyncApi" id="cdk-monitoring-constructs.MonitoringFacade.monitorAppSyncApi"></a>

```typescript
public monitorAppSyncApi(props: AppSyncMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorAppSyncApi.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.AppSyncMonitoringProps">AppSyncMonitoringProps</a>

---

##### `monitorAutoScalingGroup` <a name="monitorAutoScalingGroup" id="cdk-monitoring-constructs.MonitoringFacade.monitorAutoScalingGroup"></a>

```typescript
public monitorAutoScalingGroup(props: AutoScalingGroupMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorAutoScalingGroup.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.AutoScalingGroupMonitoringProps">AutoScalingGroupMonitoringProps</a>

---

##### `monitorBilling` <a name="monitorBilling" id="cdk-monitoring-constructs.MonitoringFacade.monitorBilling"></a>

```typescript
public monitorBilling(props?: BillingMonitoringProps): MonitoringFacade
```

###### `props`<sup>Optional</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorBilling.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.BillingMonitoringProps">BillingMonitoringProps</a>

---

##### `monitorCertificate` <a name="monitorCertificate" id="cdk-monitoring-constructs.MonitoringFacade.monitorCertificate"></a>

```typescript
public monitorCertificate(props: CertificateManagerMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorCertificate.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.CertificateManagerMonitoringProps">CertificateManagerMonitoringProps</a>

---

##### `monitorCloudFrontDistribution` <a name="monitorCloudFrontDistribution" id="cdk-monitoring-constructs.MonitoringFacade.monitorCloudFrontDistribution"></a>

```typescript
public monitorCloudFrontDistribution(props: CloudFrontDistributionMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorCloudFrontDistribution.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps">CloudFrontDistributionMonitoringProps</a>

---

##### `monitorCodeBuildProject` <a name="monitorCodeBuildProject" id="cdk-monitoring-constructs.MonitoringFacade.monitorCodeBuildProject"></a>

```typescript
public monitorCodeBuildProject(props: CodeBuildProjectMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorCodeBuildProject.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringProps">CodeBuildProjectMonitoringProps</a>

---

##### `monitorCustom` <a name="monitorCustom" id="cdk-monitoring-constructs.MonitoringFacade.monitorCustom"></a>

```typescript
public monitorCustom(props: CustomMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorCustom.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.CustomMonitoringProps">CustomMonitoringProps</a>

---

##### `monitorDocumentDbCluster` <a name="monitorDocumentDbCluster" id="cdk-monitoring-constructs.MonitoringFacade.monitorDocumentDbCluster"></a>

```typescript
public monitorDocumentDbCluster(props: DocumentDbMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorDocumentDbCluster.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.DocumentDbMonitoringProps">DocumentDbMonitoringProps</a>

---

##### `monitorDynamoTable` <a name="monitorDynamoTable" id="cdk-monitoring-constructs.MonitoringFacade.monitorDynamoTable"></a>

```typescript
public monitorDynamoTable(props: DynamoTableMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorDynamoTable.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps">DynamoTableMonitoringProps</a>

---

##### `monitorDynamoTableGlobalSecondaryIndex` <a name="monitorDynamoTableGlobalSecondaryIndex" id="cdk-monitoring-constructs.MonitoringFacade.monitorDynamoTableGlobalSecondaryIndex"></a>

```typescript
public monitorDynamoTableGlobalSecondaryIndex(props: DynamoTableGlobalSecondaryIndexMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorDynamoTableGlobalSecondaryIndex.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps">DynamoTableGlobalSecondaryIndexMonitoringProps</a>

---

##### `monitorEc2ApplicationLoadBalancer` <a name="monitorEc2ApplicationLoadBalancer" id="cdk-monitoring-constructs.MonitoringFacade.monitorEc2ApplicationLoadBalancer"></a>

```typescript
public monitorEc2ApplicationLoadBalancer(props: Ec2ApplicationLoadBalancerMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorEc2ApplicationLoadBalancer.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps">Ec2ApplicationLoadBalancerMonitoringProps</a>

---

##### `monitorEC2Instances` <a name="monitorEC2Instances" id="cdk-monitoring-constructs.MonitoringFacade.monitorEC2Instances"></a>

```typescript
public monitorEC2Instances(props: EC2MonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorEC2Instances.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.EC2MonitoringProps">EC2MonitoringProps</a>

---

##### `monitorEc2NetworkLoadBalancer` <a name="monitorEc2NetworkLoadBalancer" id="cdk-monitoring-constructs.MonitoringFacade.monitorEc2NetworkLoadBalancer"></a>

```typescript
public monitorEc2NetworkLoadBalancer(props: Ec2NetworkLoadBalancerMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorEc2NetworkLoadBalancer.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps">Ec2NetworkLoadBalancerMonitoringProps</a>

---

##### `monitorEc2Service` <a name="monitorEc2Service" id="cdk-monitoring-constructs.MonitoringFacade.monitorEc2Service"></a>

```typescript
public monitorEc2Service(props: Ec2ServiceMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorEc2Service.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.Ec2ServiceMonitoringProps">Ec2ServiceMonitoringProps</a>

---

##### `monitorElastiCacheCluster` <a name="monitorElastiCacheCluster" id="cdk-monitoring-constructs.MonitoringFacade.monitorElastiCacheCluster"></a>

```typescript
public monitorElastiCacheCluster(props: ElastiCacheClusterMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorElastiCacheCluster.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps">ElastiCacheClusterMonitoringProps</a>

---

##### `monitorElasticsearchCluster` <a name="monitorElasticsearchCluster" id="cdk-monitoring-constructs.MonitoringFacade.monitorElasticsearchCluster"></a>

```typescript
public monitorElasticsearchCluster(props: OpenSearchClusterMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorElasticsearchCluster.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.OpenSearchClusterMonitoringProps">OpenSearchClusterMonitoringProps</a>

---

##### `monitorFargateApplicationLoadBalancer` <a name="monitorFargateApplicationLoadBalancer" id="cdk-monitoring-constructs.MonitoringFacade.monitorFargateApplicationLoadBalancer"></a>

```typescript
public monitorFargateApplicationLoadBalancer(props: FargateApplicationLoadBalancerMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorFargateApplicationLoadBalancer.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps">FargateApplicationLoadBalancerMonitoringProps</a>

---

##### `monitorFargateNetworkLoadBalancer` <a name="monitorFargateNetworkLoadBalancer" id="cdk-monitoring-constructs.MonitoringFacade.monitorFargateNetworkLoadBalancer"></a>

```typescript
public monitorFargateNetworkLoadBalancer(props: FargateNetworkLoadBalancerMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorFargateNetworkLoadBalancer.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps">FargateNetworkLoadBalancerMonitoringProps</a>

---

##### `monitorFargateService` <a name="monitorFargateService" id="cdk-monitoring-constructs.MonitoringFacade.monitorFargateService"></a>

```typescript
public monitorFargateService(props: FargateServiceMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorFargateService.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.FargateServiceMonitoringProps">FargateServiceMonitoringProps</a>

---

##### `monitorGlueJob` <a name="monitorGlueJob" id="cdk-monitoring-constructs.MonitoringFacade.monitorGlueJob"></a>

```typescript
public monitorGlueJob(props: GlueJobMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorGlueJob.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.GlueJobMonitoringProps">GlueJobMonitoringProps</a>

---

##### `monitorKinesisDataAnalytics` <a name="monitorKinesisDataAnalytics" id="cdk-monitoring-constructs.MonitoringFacade.monitorKinesisDataAnalytics"></a>

```typescript
public monitorKinesisDataAnalytics(props: KinesisDataAnalyticsMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorKinesisDataAnalytics.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps">KinesisDataAnalyticsMonitoringProps</a>

---

##### `monitorKinesisDataStream` <a name="monitorKinesisDataStream" id="cdk-monitoring-constructs.MonitoringFacade.monitorKinesisDataStream"></a>

```typescript
public monitorKinesisDataStream(props: KinesisDataStreamMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorKinesisDataStream.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringProps">KinesisDataStreamMonitoringProps</a>

---

##### `monitorKinesisFirehose` <a name="monitorKinesisFirehose" id="cdk-monitoring-constructs.MonitoringFacade.monitorKinesisFirehose"></a>

```typescript
public monitorKinesisFirehose(props: KinesisFirehoseMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorKinesisFirehose.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.KinesisFirehoseMonitoringProps">KinesisFirehoseMonitoringProps</a>

---

##### `monitorLambdaFunction` <a name="monitorLambdaFunction" id="cdk-monitoring-constructs.MonitoringFacade.monitorLambdaFunction"></a>

```typescript
public monitorLambdaFunction(props: LambdaFunctionMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorLambdaFunction.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps">LambdaFunctionMonitoringProps</a>

---

##### `monitorLog` <a name="monitorLog" id="cdk-monitoring-constructs.MonitoringFacade.monitorLog"></a>

```typescript
public monitorLog(props: LogMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorLog.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.LogMonitoringProps">LogMonitoringProps</a>

---

##### `monitorNetworkLoadBalancer` <a name="monitorNetworkLoadBalancer" id="cdk-monitoring-constructs.MonitoringFacade.monitorNetworkLoadBalancer"></a>

```typescript
public monitorNetworkLoadBalancer(props: NetworkLoadBalancerMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorNetworkLoadBalancer.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.NetworkLoadBalancerMonitoringProps">NetworkLoadBalancerMonitoringProps</a>

---

##### `monitorOpenSearchCluster` <a name="monitorOpenSearchCluster" id="cdk-monitoring-constructs.MonitoringFacade.monitorOpenSearchCluster"></a>

```typescript
public monitorOpenSearchCluster(props: OpenSearchClusterMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorOpenSearchCluster.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.OpenSearchClusterMonitoringProps">OpenSearchClusterMonitoringProps</a>

---

##### `monitorQueueProcessingEc2Service` <a name="monitorQueueProcessingEc2Service" id="cdk-monitoring-constructs.MonitoringFacade.monitorQueueProcessingEc2Service"></a>

```typescript
public monitorQueueProcessingEc2Service(props: QueueProcessingEc2ServiceMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorQueueProcessingEc2Service.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.QueueProcessingEc2ServiceMonitoringProps">QueueProcessingEc2ServiceMonitoringProps</a>

---

##### `monitorQueueProcessingFargateService` <a name="monitorQueueProcessingFargateService" id="cdk-monitoring-constructs.MonitoringFacade.monitorQueueProcessingFargateService"></a>

```typescript
public monitorQueueProcessingFargateService(props: QueueProcessingFargateServiceMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorQueueProcessingFargateService.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.QueueProcessingFargateServiceMonitoringProps">QueueProcessingFargateServiceMonitoringProps</a>

---

##### `monitorRdsCluster` <a name="monitorRdsCluster" id="cdk-monitoring-constructs.MonitoringFacade.monitorRdsCluster"></a>

```typescript
public monitorRdsCluster(props: RdsClusterMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorRdsCluster.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.RdsClusterMonitoringProps">RdsClusterMonitoringProps</a>

---

##### `monitorRedshiftCluster` <a name="monitorRedshiftCluster" id="cdk-monitoring-constructs.MonitoringFacade.monitorRedshiftCluster"></a>

```typescript
public monitorRedshiftCluster(props: RedshiftClusterMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorRedshiftCluster.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.RedshiftClusterMonitoringProps">RedshiftClusterMonitoringProps</a>

---

##### `monitorS3Bucket` <a name="monitorS3Bucket" id="cdk-monitoring-constructs.MonitoringFacade.monitorS3Bucket"></a>

```typescript
public monitorS3Bucket(props: S3BucketMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorS3Bucket.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.S3BucketMonitoringProps">S3BucketMonitoringProps</a>

---

##### `monitorScope` <a name="monitorScope" id="cdk-monitoring-constructs.MonitoringFacade.monitorScope"></a>

```typescript
public monitorScope(scope: Construct, aspectProps?: MonitoringAspectProps): void
```

Monitor all the resources in the given scope.

###### `scope`<sup>Required</sup> <a name="scope" id="cdk-monitoring-constructs.MonitoringFacade.monitorScope.parameter.scope"></a>

- *Type:* constructs.Construct

---

###### `aspectProps`<sup>Optional</sup> <a name="aspectProps" id="cdk-monitoring-constructs.MonitoringFacade.monitorScope.parameter.aspectProps"></a>

- *Type:* <a href="#cdk-monitoring-constructs.MonitoringAspectProps">MonitoringAspectProps</a>

---

##### `monitorSecretsManagerSecret` <a name="monitorSecretsManagerSecret" id="cdk-monitoring-constructs.MonitoringFacade.monitorSecretsManagerSecret"></a>

```typescript
public monitorSecretsManagerSecret(props: SecretsManagerSecretMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorSecretsManagerSecret.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.SecretsManagerSecretMonitoringProps">SecretsManagerSecretMonitoringProps</a>

---

##### `monitorSimpleEc2Service` <a name="monitorSimpleEc2Service" id="cdk-monitoring-constructs.MonitoringFacade.monitorSimpleEc2Service"></a>

```typescript
public monitorSimpleEc2Service(props: SimpleEc2ServiceMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorSimpleEc2Service.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.SimpleEc2ServiceMonitoringProps">SimpleEc2ServiceMonitoringProps</a>

---

##### `monitorSimpleFargateService` <a name="monitorSimpleFargateService" id="cdk-monitoring-constructs.MonitoringFacade.monitorSimpleFargateService"></a>

```typescript
public monitorSimpleFargateService(props: SimpleFargateServiceMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorSimpleFargateService.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.SimpleFargateServiceMonitoringProps">SimpleFargateServiceMonitoringProps</a>

---

##### `monitorSnsTopic` <a name="monitorSnsTopic" id="cdk-monitoring-constructs.MonitoringFacade.monitorSnsTopic"></a>

```typescript
public monitorSnsTopic(props: SnsTopicMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorSnsTopic.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.SnsTopicMonitoringProps">SnsTopicMonitoringProps</a>

---

##### `monitorSqsQueue` <a name="monitorSqsQueue" id="cdk-monitoring-constructs.MonitoringFacade.monitorSqsQueue"></a>

```typescript
public monitorSqsQueue(props: SqsQueueMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorSqsQueue.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.SqsQueueMonitoringProps">SqsQueueMonitoringProps</a>

---

##### `monitorSqsQueueWithDlq` <a name="monitorSqsQueueWithDlq" id="cdk-monitoring-constructs.MonitoringFacade.monitorSqsQueueWithDlq"></a>

```typescript
public monitorSqsQueueWithDlq(props: SqsQueueMonitoringWithDlqProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorSqsQueueWithDlq.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.SqsQueueMonitoringWithDlqProps">SqsQueueMonitoringWithDlqProps</a>

---

##### `monitorStepFunction` <a name="monitorStepFunction" id="cdk-monitoring-constructs.MonitoringFacade.monitorStepFunction"></a>

```typescript
public monitorStepFunction(props: StepFunctionMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorStepFunction.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.StepFunctionMonitoringProps">StepFunctionMonitoringProps</a>

---

##### `monitorStepFunctionActivity` <a name="monitorStepFunctionActivity" id="cdk-monitoring-constructs.MonitoringFacade.monitorStepFunctionActivity"></a>

```typescript
public monitorStepFunctionActivity(props: StepFunctionActivityMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorStepFunctionActivity.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.StepFunctionActivityMonitoringProps">StepFunctionActivityMonitoringProps</a>

---

##### `monitorStepFunctionLambdaIntegration` <a name="monitorStepFunctionLambdaIntegration" id="cdk-monitoring-constructs.MonitoringFacade.monitorStepFunctionLambdaIntegration"></a>

```typescript
public monitorStepFunctionLambdaIntegration(props: StepFunctionLambdaIntegrationMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorStepFunctionLambdaIntegration.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.StepFunctionLambdaIntegrationMonitoringProps">StepFunctionLambdaIntegrationMonitoringProps</a>

---

##### `monitorStepFunctionServiceIntegration` <a name="monitorStepFunctionServiceIntegration" id="cdk-monitoring-constructs.MonitoringFacade.monitorStepFunctionServiceIntegration"></a>

```typescript
public monitorStepFunctionServiceIntegration(props: StepFunctionServiceIntegrationMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorStepFunctionServiceIntegration.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.StepFunctionServiceIntegrationMonitoringProps">StepFunctionServiceIntegrationMonitoringProps</a>

---

##### `monitorSyntheticsCanary` <a name="monitorSyntheticsCanary" id="cdk-monitoring-constructs.MonitoringFacade.monitorSyntheticsCanary"></a>

```typescript
public monitorSyntheticsCanary(props: SyntheticsCanaryMonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorSyntheticsCanary.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.SyntheticsCanaryMonitoringProps">SyntheticsCanaryMonitoringProps</a>

---

##### `monitorWebApplicationFirewallAclV2` <a name="monitorWebApplicationFirewallAclV2" id="cdk-monitoring-constructs.MonitoringFacade.monitorWebApplicationFirewallAclV2"></a>

```typescript
public monitorWebApplicationFirewallAclV2(props: WafV2MonitoringProps): MonitoringFacade
```

###### `props`<sup>Required</sup> <a name="props" id="cdk-monitoring-constructs.MonitoringFacade.monitorWebApplicationFirewallAclV2.parameter.props"></a>

- *Type:* <a href="#cdk-monitoring-constructs.WafV2MonitoringProps">WafV2MonitoringProps</a>

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-monitoring-constructs.MonitoringFacade.isConstruct"></a>

```typescript
import { MonitoringFacade } from 'cdk-monitoring-constructs'

MonitoringFacade.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-monitoring-constructs.MonitoringFacade.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.MonitoringFacade.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-monitoring-constructs.MonitoringFacade.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---


### MonitoringScope <a name="MonitoringScope" id="cdk-monitoring-constructs.MonitoringScope"></a>

A scope (construct) where all monitoring constructs are living in.

#### Initializers <a name="Initializers" id="cdk-monitoring-constructs.MonitoringScope.Initializer"></a>

```typescript
import { MonitoringScope } from 'cdk-monitoring-constructs'

new MonitoringScope(scope: Construct, id: string)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.MonitoringScope.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#cdk-monitoring-constructs.MonitoringScope.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk-monitoring-constructs.MonitoringScope.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk-monitoring-constructs.MonitoringScope.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings. If
the ID includes a path separator (`/`), then it will be replaced by double
dash `--`.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-monitoring-constructs.MonitoringScope.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-monitoring-constructs.MonitoringScope.createAlarmFactory">createAlarmFactory</a></code> | Creates a new alarm factory. |
| <code><a href="#cdk-monitoring-constructs.MonitoringScope.createAwsConsoleUrlFactory">createAwsConsoleUrlFactory</a></code> | Creates a new factory that creates AWS Console URLs. |
| <code><a href="#cdk-monitoring-constructs.MonitoringScope.createMetricFactory">createMetricFactory</a></code> | Creates a new metric factory. |
| <code><a href="#cdk-monitoring-constructs.MonitoringScope.createWidgetFactory">createWidgetFactory</a></code> | Creates a new widget factory. |

---

##### `toString` <a name="toString" id="cdk-monitoring-constructs.MonitoringScope.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `createAlarmFactory` <a name="createAlarmFactory" id="cdk-monitoring-constructs.MonitoringScope.createAlarmFactory"></a>

```typescript
public createAlarmFactory(alarmNamePrefix: string): AlarmFactory
```

Creates a new alarm factory.

Alarms created will be named with the given prefix, unless a local name override is present.

###### `alarmNamePrefix`<sup>Required</sup> <a name="alarmNamePrefix" id="cdk-monitoring-constructs.MonitoringScope.createAlarmFactory.parameter.alarmNamePrefix"></a>

- *Type:* string

alarm name prefix.

---

##### `createAwsConsoleUrlFactory` <a name="createAwsConsoleUrlFactory" id="cdk-monitoring-constructs.MonitoringScope.createAwsConsoleUrlFactory"></a>

```typescript
public createAwsConsoleUrlFactory(): AwsConsoleUrlFactory
```

Creates a new factory that creates AWS Console URLs.

##### `createMetricFactory` <a name="createMetricFactory" id="cdk-monitoring-constructs.MonitoringScope.createMetricFactory"></a>

```typescript
public createMetricFactory(): MetricFactory
```

Creates a new metric factory.

##### `createWidgetFactory` <a name="createWidgetFactory" id="cdk-monitoring-constructs.MonitoringScope.createWidgetFactory"></a>

```typescript
public createWidgetFactory(): IWidgetFactory
```

Creates a new widget factory.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-monitoring-constructs.MonitoringScope.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-monitoring-constructs.MonitoringScope.isConstruct"></a>

```typescript
import { MonitoringScope } from 'cdk-monitoring-constructs'

MonitoringScope.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-monitoring-constructs.MonitoringScope.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.MonitoringScope.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-monitoring-constructs.MonitoringScope.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---


### SecretsManagerMetricsPublisher <a name="SecretsManagerMetricsPublisher" id="cdk-monitoring-constructs.SecretsManagerMetricsPublisher"></a>

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-monitoring-constructs.SecretsManagerMetricsPublisher.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk-monitoring-constructs.SecretsManagerMetricsPublisher.addSecret">addSecret</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="cdk-monitoring-constructs.SecretsManagerMetricsPublisher.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addSecret` <a name="addSecret" id="cdk-monitoring-constructs.SecretsManagerMetricsPublisher.addSecret"></a>

```typescript
public addSecret(secret: ISecret): void
```

###### `secret`<sup>Required</sup> <a name="secret" id="cdk-monitoring-constructs.SecretsManagerMetricsPublisher.addSecret.parameter.secret"></a>

- *Type:* aws-cdk-lib.aws_secretsmanager.ISecret

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk-monitoring-constructs.SecretsManagerMetricsPublisher.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk-monitoring-constructs.SecretsManagerMetricsPublisher.getInstance">getInstance</a></code> | *No description.* |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="cdk-monitoring-constructs.SecretsManagerMetricsPublisher.isConstruct"></a>

```typescript
import { SecretsManagerMetricsPublisher } from 'cdk-monitoring-constructs'

SecretsManagerMetricsPublisher.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="cdk-monitoring-constructs.SecretsManagerMetricsPublisher.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `getInstance` <a name="getInstance" id="cdk-monitoring-constructs.SecretsManagerMetricsPublisher.getInstance"></a>

```typescript
import { SecretsManagerMetricsPublisher } from 'cdk-monitoring-constructs'

SecretsManagerMetricsPublisher.getInstance(scope: MonitoringScope)
```

###### `scope`<sup>Required</sup> <a name="scope" id="cdk-monitoring-constructs.SecretsManagerMetricsPublisher.getInstance.parameter.scope"></a>

- *Type:* <a href="#cdk-monitoring-constructs.MonitoringScope">MonitoringScope</a>

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.SecretsManagerMetricsPublisher.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk-monitoring-constructs.SecretsManagerMetricsPublisher.property.lambda">lambda</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk-monitoring-constructs.SecretsManagerMetricsPublisher.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `lambda`<sup>Required</sup> <a name="lambda" id="cdk-monitoring-constructs.SecretsManagerMetricsPublisher.property.lambda"></a>

```typescript
public readonly lambda: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---


## Structs <a name="Structs" id="Structs"></a>

### AddAlarmProps <a name="AddAlarmProps" id="cdk-monitoring-constructs.AddAlarmProps"></a>

Properties necessary to create a single alarm and configure it.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AddAlarmProps.Initializer"></a>

```typescript
import { AddAlarmProps } from 'cdk-monitoring-constructs'

const addAlarmProps: AddAlarmProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.alarmDescription">alarmDescription</a></code> | <code>string</code> | Alarm description is included in the ticket and therefore should describe what happened, with as much context as possible. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.alarmNameSuffix">alarmNameSuffix</a></code> | <code>string</code> | Suffix added to base alarm name. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.comparisonOperator">comparisonOperator</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.threshold">threshold</a></code> | <code>number</code> | Threshold to alarm on. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.treatMissingData">treatMissingData</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default action strategy. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.alarmDedupeStringSuffix">alarmDedupeStringSuffix</a></code> | <code>string</code> | If this is defined, the default resource-specific alarm dedupe string will be set and this will be added as a suffix. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.disambiguator">disambiguator</a></code> | <code>string</code> | Disambiguator is a string that differentiates this alarm from other similar ones. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.overrideAnnotationColor">overrideAnnotationColor</a></code> | <code>string</code> | If specified, it modifies the final alarm annotation color. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.overrideAnnotationLabel">overrideAnnotationLabel</a></code> | <code>string</code> | If specified, it modifies the final alarm annotation label. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.overrideAnnotationVisibility">overrideAnnotationVisibility</a></code> | <code>boolean</code> | If specified, it modifies the final alarm annotation visibility. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.AddAlarmProps.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |

---

##### `alarmDescription`<sup>Required</sup> <a name="alarmDescription" id="cdk-monitoring-constructs.AddAlarmProps.property.alarmDescription"></a>

```typescript
public readonly alarmDescription: string;
```

- *Type:* string

Alarm description is included in the ticket and therefore should describe what happened, with as much context as possible.

---

##### `alarmNameSuffix`<sup>Required</sup> <a name="alarmNameSuffix" id="cdk-monitoring-constructs.AddAlarmProps.property.alarmNameSuffix"></a>

```typescript
public readonly alarmNameSuffix: string;
```

- *Type:* string

Suffix added to base alarm name.

Alarm names need to be unique.

---

##### `comparisonOperator`<sup>Required</sup> <a name="comparisonOperator" id="cdk-monitoring-constructs.AddAlarmProps.property.comparisonOperator"></a>

```typescript
public readonly comparisonOperator: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator

Comparison operator used to compare actual value against the threshold.

---

##### `threshold`<sup>Required</sup> <a name="threshold" id="cdk-monitoring-constructs.AddAlarmProps.property.threshold"></a>

```typescript
public readonly threshold: number;
```

- *Type:* number

Threshold to alarm on.

---

##### `treatMissingData`<sup>Required</sup> <a name="treatMissingData" id="cdk-monitoring-constructs.AddAlarmProps.property.treatMissingData"></a>

```typescript
public readonly treatMissingData: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData

Behaviour in case the metric data is missing.

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.AddAlarmProps.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* default action will be used

Allows to override the default action strategy.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.AddAlarmProps.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDedupeStringSuffix`<sup>Optional</sup> <a name="alarmDedupeStringSuffix" id="cdk-monitoring-constructs.AddAlarmProps.property.alarmDedupeStringSuffix"></a>

```typescript
public readonly alarmDedupeStringSuffix: string;
```

- *Type:* string
- *Default:* undefined (no suffix)

If this is defined, the default resource-specific alarm dedupe string will be set and this will be added as a suffix.

This allows you to specify the same dedupe string for a family of alarms.
Cannot be defined at the same time as alarmDedupeStringOverride.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.AddAlarmProps.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.AddAlarmProps.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.AddAlarmProps.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.AddAlarmProps.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.AddAlarmProps.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.AddAlarmProps.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `disambiguator`<sup>Optional</sup> <a name="disambiguator" id="cdk-monitoring-constructs.AddAlarmProps.property.disambiguator"></a>

```typescript
public readonly disambiguator: string;
```

- *Type:* string
- *Default:* undefined (no disambiguator)

Disambiguator is a string that differentiates this alarm from other similar ones.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.AddAlarmProps.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.AddAlarmProps.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.AddAlarmProps.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* Same as datapointsToAlarm.

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.AddAlarmProps.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.AddAlarmProps.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, an artificial composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
The newly created composite alarm will be returned as a result, and it will take the original alarm actions.

---

##### `overrideAnnotationColor`<sup>Optional</sup> <a name="overrideAnnotationColor" id="cdk-monitoring-constructs.AddAlarmProps.property.overrideAnnotationColor"></a>

```typescript
public readonly overrideAnnotationColor: string;
```

- *Type:* string
- *Default:* no override (default color)

If specified, it modifies the final alarm annotation color.

---

##### `overrideAnnotationLabel`<sup>Optional</sup> <a name="overrideAnnotationLabel" id="cdk-monitoring-constructs.AddAlarmProps.property.overrideAnnotationLabel"></a>

```typescript
public readonly overrideAnnotationLabel: string;
```

- *Type:* string
- *Default:* no override (default label)

If specified, it modifies the final alarm annotation label.

---

##### `overrideAnnotationVisibility`<sup>Optional</sup> <a name="overrideAnnotationVisibility" id="cdk-monitoring-constructs.AddAlarmProps.property.overrideAnnotationVisibility"></a>

```typescript
public readonly overrideAnnotationVisibility: boolean;
```

- *Type:* boolean
- *Default:* no override (default visibility)

If specified, it modifies the final alarm annotation visibility.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.AddAlarmProps.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.AddAlarmProps.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

### AddCompositeAlarmProps <a name="AddCompositeAlarmProps" id="cdk-monitoring-constructs.AddCompositeAlarmProps"></a>

Properties necessary to create a composite alarm and configure it.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AddCompositeAlarmProps.Initializer"></a>

```typescript
import { AddCompositeAlarmProps } from 'cdk-monitoring-constructs'

const addCompositeAlarmProps: AddCompositeAlarmProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AddCompositeAlarmProps.property.disambiguator">disambiguator</a></code> | <code>string</code> | Disambiguator is a string that differentiates this alarm from other similar ones. |
| <code><a href="#cdk-monitoring-constructs.AddCompositeAlarmProps.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default action strategy. |
| <code><a href="#cdk-monitoring-constructs.AddCompositeAlarmProps.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.AddCompositeAlarmProps.property.alarmDedupeStringSuffix">alarmDedupeStringSuffix</a></code> | <code>string</code> | If this is defined, the default resource-specific alarm dedupe string will be set and this will be added as a suffix. |
| <code><a href="#cdk-monitoring-constructs.AddCompositeAlarmProps.property.alarmDescription">alarmDescription</a></code> | <code>string</code> | Alarm description is included in the ticket and therefore should describe what happened, with as much context as possible. |
| <code><a href="#cdk-monitoring-constructs.AddCompositeAlarmProps.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.AddCompositeAlarmProps.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.AddCompositeAlarmProps.property.alarmNameSuffix">alarmNameSuffix</a></code> | <code>string</code> | Suffix added to base alarm name. |
| <code><a href="#cdk-monitoring-constructs.AddCompositeAlarmProps.property.compositeOperator">compositeOperator</a></code> | <code><a href="#cdk-monitoring-constructs.CompositeAlarmOperator">CompositeAlarmOperator</a></code> | Logical operator used to aggregate the status individual alarms. |
| <code><a href="#cdk-monitoring-constructs.AddCompositeAlarmProps.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.AddCompositeAlarmProps.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.AddCompositeAlarmProps.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.AddCompositeAlarmProps.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.AddCompositeAlarmProps.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.AddCompositeAlarmProps.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |

---

##### `disambiguator`<sup>Required</sup> <a name="disambiguator" id="cdk-monitoring-constructs.AddCompositeAlarmProps.property.disambiguator"></a>

```typescript
public readonly disambiguator: string;
```

- *Type:* string

Disambiguator is a string that differentiates this alarm from other similar ones.

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.AddCompositeAlarmProps.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* default action will be used

Allows to override the default action strategy.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.AddCompositeAlarmProps.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDedupeStringSuffix`<sup>Optional</sup> <a name="alarmDedupeStringSuffix" id="cdk-monitoring-constructs.AddCompositeAlarmProps.property.alarmDedupeStringSuffix"></a>

```typescript
public readonly alarmDedupeStringSuffix: string;
```

- *Type:* string
- *Default:* undefined (no suffix)

If this is defined, the default resource-specific alarm dedupe string will be set and this will be added as a suffix.

This allows you to specify the same dedupe string for a family of alarms.
Cannot be defined at the same time as alarmDedupeStringOverride.

---

##### `alarmDescription`<sup>Optional</sup> <a name="alarmDescription" id="cdk-monitoring-constructs.AddCompositeAlarmProps.property.alarmDescription"></a>

```typescript
public readonly alarmDescription: string;
```

- *Type:* string
- *Default:* no description

Alarm description is included in the ticket and therefore should describe what happened, with as much context as possible.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.AddCompositeAlarmProps.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.AddCompositeAlarmProps.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `alarmNameSuffix`<sup>Optional</sup> <a name="alarmNameSuffix" id="cdk-monitoring-constructs.AddCompositeAlarmProps.property.alarmNameSuffix"></a>

```typescript
public readonly alarmNameSuffix: string;
```

- *Type:* string
- *Default:* no suffix

Suffix added to base alarm name.

Alarm names need to be unique.

---

##### `compositeOperator`<sup>Optional</sup> <a name="compositeOperator" id="cdk-monitoring-constructs.AddCompositeAlarmProps.property.compositeOperator"></a>

```typescript
public readonly compositeOperator: CompositeAlarmOperator;
```

- *Type:* <a href="#cdk-monitoring-constructs.CompositeAlarmOperator">CompositeAlarmOperator</a>
- *Default:* OR

Logical operator used to aggregate the status individual alarms.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.AddCompositeAlarmProps.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.AddCompositeAlarmProps.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.AddCompositeAlarmProps.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.AddCompositeAlarmProps.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.AddCompositeAlarmProps.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.AddCompositeAlarmProps.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

### AlarmActionStrategyProps <a name="AlarmActionStrategyProps" id="cdk-monitoring-constructs.AlarmActionStrategyProps"></a>

Properties necessary to append actions to an alarm.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AlarmActionStrategyProps.Initializer"></a>

```typescript
import { AlarmActionStrategyProps } from 'cdk-monitoring-constructs'

const alarmActionStrategyProps: AlarmActionStrategyProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AlarmActionStrategyProps.property.action">action</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmActionStrategyProps.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmActionStrategyProps.property.customTags">customTags</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmActionStrategyProps.property.dedupeString">dedupeString</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmActionStrategyProps.property.disambiguator">disambiguator</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmActionStrategyProps.property.alarm">alarm</a></code> | <code>aws-cdk-lib.aws_cloudwatch.AlarmBase</code> | *No description.* |

---

##### `action`<sup>Required</sup> <a name="action" id="cdk-monitoring-constructs.AlarmActionStrategyProps.property.action"></a>

```typescript
public readonly action: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.AlarmActionStrategyProps.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.AlarmActionStrategyProps.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]

---

##### `dedupeString`<sup>Optional</sup> <a name="dedupeString" id="cdk-monitoring-constructs.AlarmActionStrategyProps.property.dedupeString"></a>

```typescript
public readonly dedupeString: string;
```

- *Type:* string

---

##### `disambiguator`<sup>Optional</sup> <a name="disambiguator" id="cdk-monitoring-constructs.AlarmActionStrategyProps.property.disambiguator"></a>

```typescript
public readonly disambiguator: string;
```

- *Type:* string

---

##### `alarm`<sup>Required</sup> <a name="alarm" id="cdk-monitoring-constructs.AlarmActionStrategyProps.property.alarm"></a>

```typescript
public readonly alarm: AlarmBase;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.AlarmBase

---

### AlarmAnnotationStrategyProps <a name="AlarmAnnotationStrategyProps" id="cdk-monitoring-constructs.AlarmAnnotationStrategyProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AlarmAnnotationStrategyProps.Initializer"></a>

```typescript
import { AlarmAnnotationStrategyProps } from 'cdk-monitoring-constructs'

const alarmAnnotationStrategyProps: AlarmAnnotationStrategyProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.action">action</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.customTags">customTags</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.dedupeString">dedupeString</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.disambiguator">disambiguator</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.alarm">alarm</a></code> | <code>aws-cdk-lib.aws_cloudwatch.Alarm</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.comparisonOperator">comparisonOperator</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.metric">metric</a></code> | <code>aws-cdk-lib.aws_cloudwatch.Metric \| aws-cdk-lib.aws_cloudwatch.MathExpression</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.threshold">threshold</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.overrideAnnotationColor">overrideAnnotationColor</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.overrideAnnotationLabel">overrideAnnotationLabel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.overrideAnnotationVisibility">overrideAnnotationVisibility</a></code> | <code>boolean</code> | *No description.* |

---

##### `action`<sup>Required</sup> <a name="action" id="cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.action"></a>

```typescript
public readonly action: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]

---

##### `dedupeString`<sup>Optional</sup> <a name="dedupeString" id="cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.dedupeString"></a>

```typescript
public readonly dedupeString: string;
```

- *Type:* string

---

##### `disambiguator`<sup>Optional</sup> <a name="disambiguator" id="cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.disambiguator"></a>

```typescript
public readonly disambiguator: string;
```

- *Type:* string

---

##### `alarm`<sup>Required</sup> <a name="alarm" id="cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.alarm"></a>

```typescript
public readonly alarm: Alarm;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.Alarm

---

##### `comparisonOperator`<sup>Required</sup> <a name="comparisonOperator" id="cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.comparisonOperator"></a>

```typescript
public readonly comparisonOperator: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator

---

##### `datapointsToAlarm`<sup>Required</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number

---

##### `evaluationPeriods`<sup>Required</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number

---

##### `fillAlarmRange`<sup>Required</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean

---

##### `metric`<sup>Required</sup> <a name="metric" id="cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.metric"></a>

```typescript
public readonly metric: Metric | MathExpression;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.Metric | aws-cdk-lib.aws_cloudwatch.MathExpression

---

##### `threshold`<sup>Required</sup> <a name="threshold" id="cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.threshold"></a>

```typescript
public readonly threshold: number;
```

- *Type:* number

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number

---

##### `overrideAnnotationColor`<sup>Optional</sup> <a name="overrideAnnotationColor" id="cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.overrideAnnotationColor"></a>

```typescript
public readonly overrideAnnotationColor: string;
```

- *Type:* string

---

##### `overrideAnnotationLabel`<sup>Optional</sup> <a name="overrideAnnotationLabel" id="cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.overrideAnnotationLabel"></a>

```typescript
public readonly overrideAnnotationLabel: string;
```

- *Type:* string

---

##### `overrideAnnotationVisibility`<sup>Optional</sup> <a name="overrideAnnotationVisibility" id="cdk-monitoring-constructs.AlarmAnnotationStrategyProps.property.overrideAnnotationVisibility"></a>

```typescript
public readonly overrideAnnotationVisibility: boolean;
```

- *Type:* boolean

---

### AlarmFactoryDefaults <a name="AlarmFactoryDefaults" id="cdk-monitoring-constructs.AlarmFactoryDefaults"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AlarmFactoryDefaults.Initializer"></a>

```typescript
import { AlarmFactoryDefaults } from 'cdk-monitoring-constructs'

const alarmFactoryDefaults: AlarmFactoryDefaults = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AlarmFactoryDefaults.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean \| {[ key: string ]: boolean}</code> | Enables the configured CloudWatch alarm ticketing actions for either all severities, or per severity. |
| <code><a href="#cdk-monitoring-constructs.AlarmFactoryDefaults.property.alarmNamePrefix">alarmNamePrefix</a></code> | <code>string</code> | Global prefix for all alarm names. |
| <code><a href="#cdk-monitoring-constructs.AlarmFactoryDefaults.property.action">action</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Default alarm action used for each alarm, unless it is overridden. |
| <code><a href="#cdk-monitoring-constructs.AlarmFactoryDefaults.property.annotationStrategy">annotationStrategy</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmAnnotationStrategy">IAlarmAnnotationStrategy</a></code> | Custom strategy to create annotations for alarms. |
| <code><a href="#cdk-monitoring-constructs.AlarmFactoryDefaults.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.AlarmFactoryDefaults.property.dedupeStringProcessor">dedupeStringProcessor</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmDedupeStringProcessor">IAlarmDedupeStringProcessor</a></code> | Custom strategy to process dedupe strings of the alarms. |
| <code><a href="#cdk-monitoring-constructs.AlarmFactoryDefaults.property.disambiguatorAction">disambiguatorAction</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>}</code> | Optional alarm action for each disambiguator. |
| <code><a href="#cdk-monitoring-constructs.AlarmFactoryDefaults.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.AlarmFactoryDefaults.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.AlarmFactoryDefaults.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.AlarmFactoryDefaults.property.useDefaultDedupeForError">useDefaultDedupeForError</a></code> | <code>boolean</code> | If this is defined as false and dedupeStringOverride is undefined, the alarm prefix will be part of the dedupe string. |
| <code><a href="#cdk-monitoring-constructs.AlarmFactoryDefaults.property.useDefaultDedupeForLatency">useDefaultDedupeForLatency</a></code> | <code>boolean</code> | If this is defined as false and dedupeStringOverride is undefined, the alarm prefix will be part of the dedupe string. |

---

##### `actionsEnabled`<sup>Required</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.AlarmFactoryDefaults.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean | {[ key: string ]: boolean};
```

- *Type:* boolean | {[ key: string ]: boolean}

Enables the configured CloudWatch alarm ticketing actions for either all severities, or per severity.

---

##### `alarmNamePrefix`<sup>Required</sup> <a name="alarmNamePrefix" id="cdk-monitoring-constructs.AlarmFactoryDefaults.property.alarmNamePrefix"></a>

```typescript
public readonly alarmNamePrefix: string;
```

- *Type:* string

Global prefix for all alarm names.

This should be something unique to avoid collisions with other CTIs.
This is ignored if an alarm's dedupeStringOverride is declared.

---

##### `action`<sup>Optional</sup> <a name="action" id="cdk-monitoring-constructs.AlarmFactoryDefaults.property.action"></a>

```typescript
public readonly action: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* no action.

Default alarm action used for each alarm, unless it is overridden.

---

##### `annotationStrategy`<sup>Optional</sup> <a name="annotationStrategy" id="cdk-monitoring-constructs.AlarmFactoryDefaults.property.annotationStrategy"></a>

```typescript
public readonly annotationStrategy: IAlarmAnnotationStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmAnnotationStrategy">IAlarmAnnotationStrategy</a>
- *Default:* default annotations

Custom strategy to create annotations for alarms.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.AlarmFactoryDefaults.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* 3

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringProcessor`<sup>Optional</sup> <a name="dedupeStringProcessor" id="cdk-monitoring-constructs.AlarmFactoryDefaults.property.dedupeStringProcessor"></a>

```typescript
public readonly dedupeStringProcessor: IAlarmDedupeStringProcessor;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmDedupeStringProcessor">IAlarmDedupeStringProcessor</a>
- *Default:* default behaviour (no change)

Custom strategy to process dedupe strings of the alarms.

---

##### `disambiguatorAction`<sup>Optional</sup> <a name="disambiguatorAction" id="cdk-monitoring-constructs.AlarmFactoryDefaults.property.disambiguatorAction"></a>

```typescript
public readonly disambiguatorAction: {[ key: string ]: IAlarmActionStrategy};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>}
- *Default:* Global alarm action if defined.

Optional alarm action for each disambiguator.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.AlarmFactoryDefaults.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string

An optional link included in the generated ticket description body.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.AlarmFactoryDefaults.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* Same as datapointsToAlarm.

Number of periods to consider when checking the number of breaching datapoints.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.AlarmFactoryDefaults.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string

An optional link included in the generated ticket description body.

---

##### `useDefaultDedupeForError`<sup>Optional</sup> <a name="useDefaultDedupeForError" id="cdk-monitoring-constructs.AlarmFactoryDefaults.property.useDefaultDedupeForError"></a>

```typescript
public readonly useDefaultDedupeForError: boolean;
```

- *Type:* boolean
- *Default:* undefined (true)

If this is defined as false and dedupeStringOverride is undefined, the alarm prefix will be part of the dedupe string.

This essentially stops the dedupe of different errors together.

---

##### `useDefaultDedupeForLatency`<sup>Optional</sup> <a name="useDefaultDedupeForLatency" id="cdk-monitoring-constructs.AlarmFactoryDefaults.property.useDefaultDedupeForLatency"></a>

```typescript
public readonly useDefaultDedupeForLatency: boolean;
```

- *Type:* boolean
- *Default:* undefined (true)

If this is defined as false and dedupeStringOverride is undefined, the alarm prefix will be part of the dedupe string.

This essentially stops the dedupe of different latency issues together.

---

### AlarmFactoryProps <a name="AlarmFactoryProps" id="cdk-monitoring-constructs.AlarmFactoryProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AlarmFactoryProps.Initializer"></a>

```typescript
import { AlarmFactoryProps } from 'cdk-monitoring-constructs'

const alarmFactoryProps: AlarmFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AlarmFactoryProps.property.globalAlarmDefaults">globalAlarmDefaults</a></code> | <code><a href="#cdk-monitoring-constructs.AlarmFactoryDefaults">AlarmFactoryDefaults</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmFactoryProps.property.globalMetricDefaults">globalMetricDefaults</a></code> | <code><a href="#cdk-monitoring-constructs.MetricFactoryDefaults">MetricFactoryDefaults</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmFactoryProps.property.localAlarmNamePrefix">localAlarmNamePrefix</a></code> | <code>string</code> | *No description.* |

---

##### `globalAlarmDefaults`<sup>Required</sup> <a name="globalAlarmDefaults" id="cdk-monitoring-constructs.AlarmFactoryProps.property.globalAlarmDefaults"></a>

```typescript
public readonly globalAlarmDefaults: AlarmFactoryDefaults;
```

- *Type:* <a href="#cdk-monitoring-constructs.AlarmFactoryDefaults">AlarmFactoryDefaults</a>

---

##### `globalMetricDefaults`<sup>Required</sup> <a name="globalMetricDefaults" id="cdk-monitoring-constructs.AlarmFactoryProps.property.globalMetricDefaults"></a>

```typescript
public readonly globalMetricDefaults: MetricFactoryDefaults;
```

- *Type:* <a href="#cdk-monitoring-constructs.MetricFactoryDefaults">MetricFactoryDefaults</a>

---

##### `localAlarmNamePrefix`<sup>Required</sup> <a name="localAlarmNamePrefix" id="cdk-monitoring-constructs.AlarmFactoryProps.property.localAlarmNamePrefix"></a>

```typescript
public readonly localAlarmNamePrefix: string;
```

- *Type:* string

---

### AlarmMatrixWidgetProps <a name="AlarmMatrixWidgetProps" id="cdk-monitoring-constructs.AlarmMatrixWidgetProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AlarmMatrixWidgetProps.Initializer"></a>

```typescript
import { AlarmMatrixWidgetProps } from 'cdk-monitoring-constructs'

const alarmMatrixWidgetProps: AlarmMatrixWidgetProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AlarmMatrixWidgetProps.property.alarms">alarms</a></code> | <code>aws-cdk-lib.aws_cloudwatch.IAlarm[]</code> | list of alarms to show. |
| <code><a href="#cdk-monitoring-constructs.AlarmMatrixWidgetProps.property.height">height</a></code> | <code>number</code> | desired height. |
| <code><a href="#cdk-monitoring-constructs.AlarmMatrixWidgetProps.property.title">title</a></code> | <code>string</code> | widget title. |

---

##### `alarms`<sup>Required</sup> <a name="alarms" id="cdk-monitoring-constructs.AlarmMatrixWidgetProps.property.alarms"></a>

```typescript
public readonly alarms: IAlarm[];
```

- *Type:* aws-cdk-lib.aws_cloudwatch.IAlarm[]

list of alarms to show.

---

##### `height`<sup>Optional</sup> <a name="height" id="cdk-monitoring-constructs.AlarmMatrixWidgetProps.property.height"></a>

```typescript
public readonly height: number;
```

- *Type:* number
- *Default:* auto calculated based on alarm number (3 to 8)

desired height.

---

##### `title`<sup>Optional</sup> <a name="title" id="cdk-monitoring-constructs.AlarmMatrixWidgetProps.property.title"></a>

```typescript
public readonly title: string;
```

- *Type:* string
- *Default:* no title

widget title.

---

### AlarmMetadata <a name="AlarmMetadata" id="cdk-monitoring-constructs.AlarmMetadata"></a>

Metadata of an alarm.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AlarmMetadata.Initializer"></a>

```typescript
import { AlarmMetadata } from 'cdk-monitoring-constructs'

const alarmMetadata: AlarmMetadata = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AlarmMetadata.property.action">action</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmMetadata.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmMetadata.property.customTags">customTags</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmMetadata.property.dedupeString">dedupeString</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmMetadata.property.disambiguator">disambiguator</a></code> | <code>string</code> | *No description.* |

---

##### `action`<sup>Required</sup> <a name="action" id="cdk-monitoring-constructs.AlarmMetadata.property.action"></a>

```typescript
public readonly action: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.AlarmMetadata.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.AlarmMetadata.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]

---

##### `dedupeString`<sup>Optional</sup> <a name="dedupeString" id="cdk-monitoring-constructs.AlarmMetadata.property.dedupeString"></a>

```typescript
public readonly dedupeString: string;
```

- *Type:* string

---

##### `disambiguator`<sup>Optional</sup> <a name="disambiguator" id="cdk-monitoring-constructs.AlarmMetadata.property.disambiguator"></a>

```typescript
public readonly disambiguator: string;
```

- *Type:* string

---

### AlarmNamingInput <a name="AlarmNamingInput" id="cdk-monitoring-constructs.AlarmNamingInput"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AlarmNamingInput.Initializer"></a>

```typescript
import { AlarmNamingInput } from 'cdk-monitoring-constructs'

const alarmNamingInput: AlarmNamingInput = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AlarmNamingInput.property.alarmNameSuffix">alarmNameSuffix</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmNamingInput.property.alarmDedupeStringSuffix">alarmDedupeStringSuffix</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmNamingInput.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmNamingInput.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmNamingInput.property.disambiguator">disambiguator</a></code> | <code>string</code> | *No description.* |

---

##### `alarmNameSuffix`<sup>Required</sup> <a name="alarmNameSuffix" id="cdk-monitoring-constructs.AlarmNamingInput.property.alarmNameSuffix"></a>

```typescript
public readonly alarmNameSuffix: string;
```

- *Type:* string

---

##### `alarmDedupeStringSuffix`<sup>Optional</sup> <a name="alarmDedupeStringSuffix" id="cdk-monitoring-constructs.AlarmNamingInput.property.alarmDedupeStringSuffix"></a>

```typescript
public readonly alarmDedupeStringSuffix: string;
```

- *Type:* string

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.AlarmNamingInput.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.AlarmNamingInput.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string

---

##### `disambiguator`<sup>Optional</sup> <a name="disambiguator" id="cdk-monitoring-constructs.AlarmNamingInput.property.disambiguator"></a>

```typescript
public readonly disambiguator: string;
```

- *Type:* string

---

### AlarmSummaryMatrixWidgetPropertiesJson <a name="AlarmSummaryMatrixWidgetPropertiesJson" id="cdk-monitoring-constructs.AlarmSummaryMatrixWidgetPropertiesJson"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AlarmSummaryMatrixWidgetPropertiesJson.Initializer"></a>

```typescript
import { AlarmSummaryMatrixWidgetPropertiesJson } from 'cdk-monitoring-constructs'

const alarmSummaryMatrixWidgetPropertiesJson: AlarmSummaryMatrixWidgetPropertiesJson = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AlarmSummaryMatrixWidgetPropertiesJson.property.alarms">alarms</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmSummaryMatrixWidgetPropertiesJson.property.title">title</a></code> | <code>string</code> | *No description.* |

---

##### `alarms`<sup>Required</sup> <a name="alarms" id="cdk-monitoring-constructs.AlarmSummaryMatrixWidgetPropertiesJson.property.alarms"></a>

```typescript
public readonly alarms: string[];
```

- *Type:* string[]

---

##### `title`<sup>Optional</sup> <a name="title" id="cdk-monitoring-constructs.AlarmSummaryMatrixWidgetPropertiesJson.property.title"></a>

```typescript
public readonly title: string;
```

- *Type:* string

---

### AlarmSummaryMatrixWidgetProps <a name="AlarmSummaryMatrixWidgetProps" id="cdk-monitoring-constructs.AlarmSummaryMatrixWidgetProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AlarmSummaryMatrixWidgetProps.Initializer"></a>

```typescript
import { AlarmSummaryMatrixWidgetProps } from 'cdk-monitoring-constructs'

const alarmSummaryMatrixWidgetProps: AlarmSummaryMatrixWidgetProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AlarmSummaryMatrixWidgetProps.property.height">height</a></code> | <code>number</code> | Height of the widget. |
| <code><a href="#cdk-monitoring-constructs.AlarmSummaryMatrixWidgetProps.property.region">region</a></code> | <code>string</code> | The region the metrics of this graph should be taken from. |
| <code><a href="#cdk-monitoring-constructs.AlarmSummaryMatrixWidgetProps.property.title">title</a></code> | <code>string</code> | Title for the graph. |
| <code><a href="#cdk-monitoring-constructs.AlarmSummaryMatrixWidgetProps.property.width">width</a></code> | <code>number</code> | Width of the widget, in a grid of 24 units wide. |
| <code><a href="#cdk-monitoring-constructs.AlarmSummaryMatrixWidgetProps.property.alarmArns">alarmArns</a></code> | <code>string[]</code> | *No description.* |

---

##### `height`<sup>Optional</sup> <a name="height" id="cdk-monitoring-constructs.AlarmSummaryMatrixWidgetProps.property.height"></a>

```typescript
public readonly height: number;
```

- *Type:* number
- *Default:* 6 for Alarm and Graph widgets. 3 for single value widgets where most recent value of a metric is displayed.

Height of the widget.

---

##### `region`<sup>Optional</sup> <a name="region" id="cdk-monitoring-constructs.AlarmSummaryMatrixWidgetProps.property.region"></a>

```typescript
public readonly region: string;
```

- *Type:* string
- *Default:* Current region

The region the metrics of this graph should be taken from.

---

##### `title`<sup>Optional</sup> <a name="title" id="cdk-monitoring-constructs.AlarmSummaryMatrixWidgetProps.property.title"></a>

```typescript
public readonly title: string;
```

- *Type:* string
- *Default:* None

Title for the graph.

---

##### `width`<sup>Optional</sup> <a name="width" id="cdk-monitoring-constructs.AlarmSummaryMatrixWidgetProps.property.width"></a>

```typescript
public readonly width: number;
```

- *Type:* number
- *Default:* 6

Width of the widget, in a grid of 24 units wide.

---

##### `alarmArns`<sup>Required</sup> <a name="alarmArns" id="cdk-monitoring-constructs.AlarmSummaryMatrixWidgetProps.property.alarmArns"></a>

```typescript
public readonly alarmArns: string[];
```

- *Type:* string[]

---

### AlarmWithAnnotation <a name="AlarmWithAnnotation" id="cdk-monitoring-constructs.AlarmWithAnnotation"></a>

Representation of an alarm with additional information.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AlarmWithAnnotation.Initializer"></a>

```typescript
import { AlarmWithAnnotation } from 'cdk-monitoring-constructs'

const alarmWithAnnotation: AlarmWithAnnotation = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AlarmWithAnnotation.property.action">action</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmWithAnnotation.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmWithAnnotation.property.customTags">customTags</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmWithAnnotation.property.dedupeString">dedupeString</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmWithAnnotation.property.disambiguator">disambiguator</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmWithAnnotation.property.alarm">alarm</a></code> | <code>aws-cdk-lib.aws_cloudwatch.AlarmBase</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmWithAnnotation.property.alarmDescription">alarmDescription</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmWithAnnotation.property.alarmLabel">alarmLabel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmWithAnnotation.property.alarmName">alarmName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmWithAnnotation.property.alarmNameSuffix">alarmNameSuffix</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmWithAnnotation.property.alarmRuleWhenAlarming">alarmRuleWhenAlarming</a></code> | <code>aws-cdk-lib.aws_cloudwatch.IAlarmRule</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmWithAnnotation.property.alarmRuleWhenInsufficientData">alarmRuleWhenInsufficientData</a></code> | <code>aws-cdk-lib.aws_cloudwatch.IAlarmRule</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmWithAnnotation.property.alarmRuleWhenOk">alarmRuleWhenOk</a></code> | <code>aws-cdk-lib.aws_cloudwatch.IAlarmRule</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AlarmWithAnnotation.property.annotation">annotation</a></code> | <code>aws-cdk-lib.aws_cloudwatch.HorizontalAnnotation</code> | *No description.* |

---

##### `action`<sup>Required</sup> <a name="action" id="cdk-monitoring-constructs.AlarmWithAnnotation.property.action"></a>

```typescript
public readonly action: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.AlarmWithAnnotation.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.AlarmWithAnnotation.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]

---

##### `dedupeString`<sup>Optional</sup> <a name="dedupeString" id="cdk-monitoring-constructs.AlarmWithAnnotation.property.dedupeString"></a>

```typescript
public readonly dedupeString: string;
```

- *Type:* string

---

##### `disambiguator`<sup>Optional</sup> <a name="disambiguator" id="cdk-monitoring-constructs.AlarmWithAnnotation.property.disambiguator"></a>

```typescript
public readonly disambiguator: string;
```

- *Type:* string

---

##### `alarm`<sup>Required</sup> <a name="alarm" id="cdk-monitoring-constructs.AlarmWithAnnotation.property.alarm"></a>

```typescript
public readonly alarm: AlarmBase;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.AlarmBase

---

##### `alarmDescription`<sup>Required</sup> <a name="alarmDescription" id="cdk-monitoring-constructs.AlarmWithAnnotation.property.alarmDescription"></a>

```typescript
public readonly alarmDescription: string;
```

- *Type:* string

---

##### `alarmLabel`<sup>Required</sup> <a name="alarmLabel" id="cdk-monitoring-constructs.AlarmWithAnnotation.property.alarmLabel"></a>

```typescript
public readonly alarmLabel: string;
```

- *Type:* string

---

##### `alarmName`<sup>Required</sup> <a name="alarmName" id="cdk-monitoring-constructs.AlarmWithAnnotation.property.alarmName"></a>

```typescript
public readonly alarmName: string;
```

- *Type:* string

---

##### `alarmNameSuffix`<sup>Required</sup> <a name="alarmNameSuffix" id="cdk-monitoring-constructs.AlarmWithAnnotation.property.alarmNameSuffix"></a>

```typescript
public readonly alarmNameSuffix: string;
```

- *Type:* string

---

##### `alarmRuleWhenAlarming`<sup>Required</sup> <a name="alarmRuleWhenAlarming" id="cdk-monitoring-constructs.AlarmWithAnnotation.property.alarmRuleWhenAlarming"></a>

```typescript
public readonly alarmRuleWhenAlarming: IAlarmRule;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.IAlarmRule

---

##### `alarmRuleWhenInsufficientData`<sup>Required</sup> <a name="alarmRuleWhenInsufficientData" id="cdk-monitoring-constructs.AlarmWithAnnotation.property.alarmRuleWhenInsufficientData"></a>

```typescript
public readonly alarmRuleWhenInsufficientData: IAlarmRule;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.IAlarmRule

---

##### `alarmRuleWhenOk`<sup>Required</sup> <a name="alarmRuleWhenOk" id="cdk-monitoring-constructs.AlarmWithAnnotation.property.alarmRuleWhenOk"></a>

```typescript
public readonly alarmRuleWhenOk: IAlarmRule;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.IAlarmRule

---

##### `annotation`<sup>Required</sup> <a name="annotation" id="cdk-monitoring-constructs.AlarmWithAnnotation.property.annotation"></a>

```typescript
public readonly annotation: HorizontalAnnotation;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.HorizontalAnnotation

---

### AnomalyDetectionThreshold <a name="AnomalyDetectionThreshold" id="cdk-monitoring-constructs.AnomalyDetectionThreshold"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.Initializer"></a>

```typescript
import { AnomalyDetectionThreshold } from 'cdk-monitoring-constructs'

const anomalyDetectionThreshold: AnomalyDetectionThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.alarmWhenAboveTheBand">alarmWhenAboveTheBand</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.alarmWhenBelowTheBand">alarmWhenBelowTheBand</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.standardDeviationForAlarm">standardDeviationForAlarm</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold.property.additionalDescription">additionalDescription</a></code> | <code>string</code> | *No description.* |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, a composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
This composite alarm will be returned as a result and uses the specified alarm actions.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `treatMissingDataOverride`<sup>Optional</sup> <a name="treatMissingDataOverride" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.treatMissingDataOverride"></a>

```typescript
public readonly treatMissingDataOverride: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData
- *Default:* alarm-specific default

Behaviour in case the metric data is missing.

---

##### `alarmWhenAboveTheBand`<sup>Required</sup> <a name="alarmWhenAboveTheBand" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.alarmWhenAboveTheBand"></a>

```typescript
public readonly alarmWhenAboveTheBand: boolean;
```

- *Type:* boolean

---

##### `alarmWhenBelowTheBand`<sup>Required</sup> <a name="alarmWhenBelowTheBand" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.alarmWhenBelowTheBand"></a>

```typescript
public readonly alarmWhenBelowTheBand: boolean;
```

- *Type:* boolean

---

##### `standardDeviationForAlarm`<sup>Required</sup> <a name="standardDeviationForAlarm" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.standardDeviationForAlarm"></a>

```typescript
public readonly standardDeviationForAlarm: number;
```

- *Type:* number

---

##### `additionalDescription`<sup>Optional</sup> <a name="additionalDescription" id="cdk-monitoring-constructs.AnomalyDetectionThreshold.property.additionalDescription"></a>

```typescript
public readonly additionalDescription: string;
```

- *Type:* string

---

### ApiGatewayMetricFactoryProps <a name="ApiGatewayMetricFactoryProps" id="cdk-monitoring-constructs.ApiGatewayMetricFactoryProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.ApiGatewayMetricFactoryProps.Initializer"></a>

```typescript
import { ApiGatewayMetricFactoryProps } from 'cdk-monitoring-constructs'

const apiGatewayMetricFactoryProps: ApiGatewayMetricFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMetricFactoryProps.property.api">api</a></code> | <code>aws-cdk-lib.aws_apigateway.RestApiBase</code> | API to monitor (cannot use IRestApi, since it does not provide API name). |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMetricFactoryProps.property.apiMethod">apiMethod</a></code> | <code>string</code> | On undefined value is not set in dimensions. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMetricFactoryProps.property.apiResource">apiResource</a></code> | <code>string</code> | On undefined value is not set in dimensions. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMetricFactoryProps.property.apiStage">apiStage</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMetricFactoryProps.property.fillTpsWithZeroes">fillTpsWithZeroes</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMetricFactoryProps.property.rateComputationMethod">rateComputationMethod</a></code> | <code><a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a></code> | *No description.* |

---

##### `api`<sup>Required</sup> <a name="api" id="cdk-monitoring-constructs.ApiGatewayMetricFactoryProps.property.api"></a>

```typescript
public readonly api: RestApiBase;
```

- *Type:* aws-cdk-lib.aws_apigateway.RestApiBase

API to monitor (cannot use IRestApi, since it does not provide API name).

---

##### `apiMethod`<sup>Optional</sup> <a name="apiMethod" id="cdk-monitoring-constructs.ApiGatewayMetricFactoryProps.property.apiMethod"></a>

```typescript
public readonly apiMethod: string;
```

- *Type:* string

On undefined value is not set in dimensions.

---

##### `apiResource`<sup>Optional</sup> <a name="apiResource" id="cdk-monitoring-constructs.ApiGatewayMetricFactoryProps.property.apiResource"></a>

```typescript
public readonly apiResource: string;
```

- *Type:* string

On undefined value is not set in dimensions.

---

##### `apiStage`<sup>Optional</sup> <a name="apiStage" id="cdk-monitoring-constructs.ApiGatewayMetricFactoryProps.property.apiStage"></a>

```typescript
public readonly apiStage: string;
```

- *Type:* string
- *Default:* prod

---

##### `fillTpsWithZeroes`<sup>Optional</sup> <a name="fillTpsWithZeroes" id="cdk-monitoring-constructs.ApiGatewayMetricFactoryProps.property.fillTpsWithZeroes"></a>

```typescript
public readonly fillTpsWithZeroes: boolean;
```

- *Type:* boolean
- *Default:* true

---

##### `rateComputationMethod`<sup>Optional</sup> <a name="rateComputationMethod" id="cdk-monitoring-constructs.ApiGatewayMetricFactoryProps.property.rateComputationMethod"></a>

```typescript
public readonly rateComputationMethod: RateComputationMethod;
```

- *Type:* <a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a>
- *Default:* average

---

### ApiGatewayMonitoringOptions <a name="ApiGatewayMonitoringOptions" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.Initializer"></a>

```typescript
import { ApiGatewayMonitoringOptions } from 'cdk-monitoring-constructs'

const apiGatewayMonitoringOptions: ApiGatewayMonitoringOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.add4XXErrorCountAlarm">add4XXErrorCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.add4XXErrorRateAlarm">add4XXErrorRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.add5XXFaultCountAlarm">add5XXFaultCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.add5XXFaultRateAlarm">add5XXFaultRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addHighTpsAlarm">addHighTpsAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HighTpsThreshold">HighTpsThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyAverageAlarm">addLatencyAverageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyP100Alarm">addLatencyP100Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyP50Alarm">addLatencyP50Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyP70Alarm">addLatencyP70Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyP90Alarm">addLatencyP90Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyP95Alarm">addLatencyP95Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyP9999Alarm">addLatencyP9999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyP999Alarm">addLatencyP999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyP99Alarm">addLatencyP99Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyTM50Alarm">addLatencyTM50Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyTM70Alarm">addLatencyTM70Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyTM90Alarm">addLatencyTM90Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyTM95Alarm">addLatencyTM95Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyTM9999Alarm">addLatencyTM9999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyTM999Alarm">addLatencyTM999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyTM99Alarm">addLatencyTM99Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLowTpsAlarm">addLowTpsAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LowTpsThreshold">LowTpsThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.latencyTypesToRender">latencyTypesToRender</a></code> | <code><a href="#cdk-monitoring-constructs.LatencyType">LatencyType</a>[]</code> | You can specify what latency types you want to be rendered in the dashboards. |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `add4XXErrorCountAlarm`<sup>Optional</sup> <a name="add4XXErrorCountAlarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.add4XXErrorCountAlarm"></a>

```typescript
public readonly add4XXErrorCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `add4XXErrorRateAlarm`<sup>Optional</sup> <a name="add4XXErrorRateAlarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.add4XXErrorRateAlarm"></a>

```typescript
public readonly add4XXErrorRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

##### `add5XXFaultCountAlarm`<sup>Optional</sup> <a name="add5XXFaultCountAlarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.add5XXFaultCountAlarm"></a>

```typescript
public readonly add5XXFaultCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `add5XXFaultRateAlarm`<sup>Optional</sup> <a name="add5XXFaultRateAlarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.add5XXFaultRateAlarm"></a>

```typescript
public readonly add5XXFaultRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

##### `addHighTpsAlarm`<sup>Optional</sup> <a name="addHighTpsAlarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addHighTpsAlarm"></a>

```typescript
public readonly addHighTpsAlarm: {[ key: string ]: HighTpsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HighTpsThreshold">HighTpsThreshold</a>}

---

##### `addLatencyAverageAlarm`<sup>Optional</sup> <a name="addLatencyAverageAlarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyAverageAlarm"></a>

```typescript
public readonly addLatencyAverageAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP100Alarm`<sup>Optional</sup> <a name="addLatencyP100Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyP100Alarm"></a>

```typescript
public readonly addLatencyP100Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP50Alarm`<sup>Optional</sup> <a name="addLatencyP50Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyP50Alarm"></a>

```typescript
public readonly addLatencyP50Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP70Alarm`<sup>Optional</sup> <a name="addLatencyP70Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyP70Alarm"></a>

```typescript
public readonly addLatencyP70Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP90Alarm`<sup>Optional</sup> <a name="addLatencyP90Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyP90Alarm"></a>

```typescript
public readonly addLatencyP90Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP95Alarm`<sup>Optional</sup> <a name="addLatencyP95Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyP95Alarm"></a>

```typescript
public readonly addLatencyP95Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP9999Alarm`<sup>Optional</sup> <a name="addLatencyP9999Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyP9999Alarm"></a>

```typescript
public readonly addLatencyP9999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP999Alarm`<sup>Optional</sup> <a name="addLatencyP999Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyP999Alarm"></a>

```typescript
public readonly addLatencyP999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP99Alarm`<sup>Optional</sup> <a name="addLatencyP99Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyP99Alarm"></a>

```typescript
public readonly addLatencyP99Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM50Alarm`<sup>Optional</sup> <a name="addLatencyTM50Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyTM50Alarm"></a>

```typescript
public readonly addLatencyTM50Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM70Alarm`<sup>Optional</sup> <a name="addLatencyTM70Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyTM70Alarm"></a>

```typescript
public readonly addLatencyTM70Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM90Alarm`<sup>Optional</sup> <a name="addLatencyTM90Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyTM90Alarm"></a>

```typescript
public readonly addLatencyTM90Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM95Alarm`<sup>Optional</sup> <a name="addLatencyTM95Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyTM95Alarm"></a>

```typescript
public readonly addLatencyTM95Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM9999Alarm`<sup>Optional</sup> <a name="addLatencyTM9999Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyTM9999Alarm"></a>

```typescript
public readonly addLatencyTM9999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM999Alarm`<sup>Optional</sup> <a name="addLatencyTM999Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyTM999Alarm"></a>

```typescript
public readonly addLatencyTM999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM99Alarm`<sup>Optional</sup> <a name="addLatencyTM99Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLatencyTM99Alarm"></a>

```typescript
public readonly addLatencyTM99Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLowTpsAlarm`<sup>Optional</sup> <a name="addLowTpsAlarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.addLowTpsAlarm"></a>

```typescript
public readonly addLowTpsAlarm: {[ key: string ]: LowTpsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LowTpsThreshold">LowTpsThreshold</a>}

---

##### `latencyTypesToRender`<sup>Optional</sup> <a name="latencyTypesToRender" id="cdk-monitoring-constructs.ApiGatewayMonitoringOptions.property.latencyTypesToRender"></a>

```typescript
public readonly latencyTypesToRender: LatencyType[];
```

- *Type:* <a href="#cdk-monitoring-constructs.LatencyType">LatencyType</a>[]
- *Default:* p50, p90, p99 (

You can specify what latency types you want to be rendered in the dashboards.

Note: any latency type with an alarm will be also added automatically.
If the list is undefined, default values will be shown.
If the list is empty, only the latency types with an alarm will be shown (if any).

> [DefaultLatencyTypesToRender)](DefaultLatencyTypesToRender))

---

### ApiGatewayMonitoringProps <a name="ApiGatewayMonitoringProps" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.Initializer"></a>

```typescript
import { ApiGatewayMonitoringProps } from 'cdk-monitoring-constructs'

const apiGatewayMonitoringProps: ApiGatewayMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.api">api</a></code> | <code>aws-cdk-lib.aws_apigateway.RestApiBase</code> | API to monitor (cannot use IRestApi, since it does not provide API name). |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.apiMethod">apiMethod</a></code> | <code>string</code> | On undefined value is not set in dimensions. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.apiResource">apiResource</a></code> | <code>string</code> | On undefined value is not set in dimensions. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.apiStage">apiStage</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.fillTpsWithZeroes">fillTpsWithZeroes</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.rateComputationMethod">rateComputationMethod</a></code> | <code><a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.add4XXErrorCountAlarm">add4XXErrorCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.add4XXErrorRateAlarm">add4XXErrorRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.add5XXFaultCountAlarm">add5XXFaultCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.add5XXFaultRateAlarm">add5XXFaultRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addHighTpsAlarm">addHighTpsAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HighTpsThreshold">HighTpsThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyAverageAlarm">addLatencyAverageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyP100Alarm">addLatencyP100Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyP50Alarm">addLatencyP50Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyP70Alarm">addLatencyP70Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyP90Alarm">addLatencyP90Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyP95Alarm">addLatencyP95Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyP9999Alarm">addLatencyP9999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyP999Alarm">addLatencyP999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyP99Alarm">addLatencyP99Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyTM50Alarm">addLatencyTM50Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyTM70Alarm">addLatencyTM70Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyTM90Alarm">addLatencyTM90Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyTM95Alarm">addLatencyTM95Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyTM9999Alarm">addLatencyTM9999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyTM999Alarm">addLatencyTM999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyTM99Alarm">addLatencyTM99Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLowTpsAlarm">addLowTpsAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LowTpsThreshold">LowTpsThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.latencyTypesToRender">latencyTypesToRender</a></code> | <code><a href="#cdk-monitoring-constructs.LatencyType">LatencyType</a>[]</code> | You can specify what latency types you want to be rendered in the dashboards. |

---

##### `api`<sup>Required</sup> <a name="api" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.api"></a>

```typescript
public readonly api: RestApiBase;
```

- *Type:* aws-cdk-lib.aws_apigateway.RestApiBase

API to monitor (cannot use IRestApi, since it does not provide API name).

---

##### `apiMethod`<sup>Optional</sup> <a name="apiMethod" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.apiMethod"></a>

```typescript
public readonly apiMethod: string;
```

- *Type:* string

On undefined value is not set in dimensions.

---

##### `apiResource`<sup>Optional</sup> <a name="apiResource" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.apiResource"></a>

```typescript
public readonly apiResource: string;
```

- *Type:* string

On undefined value is not set in dimensions.

---

##### `apiStage`<sup>Optional</sup> <a name="apiStage" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.apiStage"></a>

```typescript
public readonly apiStage: string;
```

- *Type:* string
- *Default:* prod

---

##### `fillTpsWithZeroes`<sup>Optional</sup> <a name="fillTpsWithZeroes" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.fillTpsWithZeroes"></a>

```typescript
public readonly fillTpsWithZeroes: boolean;
```

- *Type:* boolean
- *Default:* true

---

##### `rateComputationMethod`<sup>Optional</sup> <a name="rateComputationMethod" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.rateComputationMethod"></a>

```typescript
public readonly rateComputationMethod: RateComputationMethod;
```

- *Type:* <a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a>
- *Default:* average

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `add4XXErrorCountAlarm`<sup>Optional</sup> <a name="add4XXErrorCountAlarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.add4XXErrorCountAlarm"></a>

```typescript
public readonly add4XXErrorCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `add4XXErrorRateAlarm`<sup>Optional</sup> <a name="add4XXErrorRateAlarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.add4XXErrorRateAlarm"></a>

```typescript
public readonly add4XXErrorRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

##### `add5XXFaultCountAlarm`<sup>Optional</sup> <a name="add5XXFaultCountAlarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.add5XXFaultCountAlarm"></a>

```typescript
public readonly add5XXFaultCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `add5XXFaultRateAlarm`<sup>Optional</sup> <a name="add5XXFaultRateAlarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.add5XXFaultRateAlarm"></a>

```typescript
public readonly add5XXFaultRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

##### `addHighTpsAlarm`<sup>Optional</sup> <a name="addHighTpsAlarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addHighTpsAlarm"></a>

```typescript
public readonly addHighTpsAlarm: {[ key: string ]: HighTpsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HighTpsThreshold">HighTpsThreshold</a>}

---

##### `addLatencyAverageAlarm`<sup>Optional</sup> <a name="addLatencyAverageAlarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyAverageAlarm"></a>

```typescript
public readonly addLatencyAverageAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP100Alarm`<sup>Optional</sup> <a name="addLatencyP100Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyP100Alarm"></a>

```typescript
public readonly addLatencyP100Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP50Alarm`<sup>Optional</sup> <a name="addLatencyP50Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyP50Alarm"></a>

```typescript
public readonly addLatencyP50Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP70Alarm`<sup>Optional</sup> <a name="addLatencyP70Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyP70Alarm"></a>

```typescript
public readonly addLatencyP70Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP90Alarm`<sup>Optional</sup> <a name="addLatencyP90Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyP90Alarm"></a>

```typescript
public readonly addLatencyP90Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP95Alarm`<sup>Optional</sup> <a name="addLatencyP95Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyP95Alarm"></a>

```typescript
public readonly addLatencyP95Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP9999Alarm`<sup>Optional</sup> <a name="addLatencyP9999Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyP9999Alarm"></a>

```typescript
public readonly addLatencyP9999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP999Alarm`<sup>Optional</sup> <a name="addLatencyP999Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyP999Alarm"></a>

```typescript
public readonly addLatencyP999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP99Alarm`<sup>Optional</sup> <a name="addLatencyP99Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyP99Alarm"></a>

```typescript
public readonly addLatencyP99Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM50Alarm`<sup>Optional</sup> <a name="addLatencyTM50Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyTM50Alarm"></a>

```typescript
public readonly addLatencyTM50Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM70Alarm`<sup>Optional</sup> <a name="addLatencyTM70Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyTM70Alarm"></a>

```typescript
public readonly addLatencyTM70Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM90Alarm`<sup>Optional</sup> <a name="addLatencyTM90Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyTM90Alarm"></a>

```typescript
public readonly addLatencyTM90Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM95Alarm`<sup>Optional</sup> <a name="addLatencyTM95Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyTM95Alarm"></a>

```typescript
public readonly addLatencyTM95Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM9999Alarm`<sup>Optional</sup> <a name="addLatencyTM9999Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyTM9999Alarm"></a>

```typescript
public readonly addLatencyTM9999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM999Alarm`<sup>Optional</sup> <a name="addLatencyTM999Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyTM999Alarm"></a>

```typescript
public readonly addLatencyTM999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM99Alarm`<sup>Optional</sup> <a name="addLatencyTM99Alarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLatencyTM99Alarm"></a>

```typescript
public readonly addLatencyTM99Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLowTpsAlarm`<sup>Optional</sup> <a name="addLowTpsAlarm" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.addLowTpsAlarm"></a>

```typescript
public readonly addLowTpsAlarm: {[ key: string ]: LowTpsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LowTpsThreshold">LowTpsThreshold</a>}

---

##### `latencyTypesToRender`<sup>Optional</sup> <a name="latencyTypesToRender" id="cdk-monitoring-constructs.ApiGatewayMonitoringProps.property.latencyTypesToRender"></a>

```typescript
public readonly latencyTypesToRender: LatencyType[];
```

- *Type:* <a href="#cdk-monitoring-constructs.LatencyType">LatencyType</a>[]
- *Default:* p50, p90, p99 (

You can specify what latency types you want to be rendered in the dashboards.

Note: any latency type with an alarm will be also added automatically.
If the list is undefined, default values will be shown.
If the list is empty, only the latency types with an alarm will be shown (if any).

> [DefaultLatencyTypesToRender)](DefaultLatencyTypesToRender))

---

### ApiGatewayV2HttpApiMetricFactoryProps <a name="ApiGatewayV2HttpApiMetricFactoryProps" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMetricFactoryProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMetricFactoryProps.Initializer"></a>

```typescript
import { ApiGatewayV2HttpApiMetricFactoryProps } from 'cdk-monitoring-constructs'

const apiGatewayV2HttpApiMetricFactoryProps: ApiGatewayV2HttpApiMetricFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMetricFactoryProps.property.api">api</a></code> | <code>@aws-cdk/aws-apigatewayv2-alpha.IHttpApi</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMetricFactoryProps.property.apiMethod">apiMethod</a></code> | <code>string</code> | On undefined value is not set in dimensions. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMetricFactoryProps.property.apiResource">apiResource</a></code> | <code>string</code> | On undefined value is not set in dimensions. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMetricFactoryProps.property.apiStage">apiStage</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMetricFactoryProps.property.fillTpsWithZeroes">fillTpsWithZeroes</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMetricFactoryProps.property.rateComputationMethod">rateComputationMethod</a></code> | <code><a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a></code> | *No description.* |

---

##### `api`<sup>Required</sup> <a name="api" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMetricFactoryProps.property.api"></a>

```typescript
public readonly api: IHttpApi;
```

- *Type:* @aws-cdk/aws-apigatewayv2-alpha.IHttpApi

---

##### `apiMethod`<sup>Optional</sup> <a name="apiMethod" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMetricFactoryProps.property.apiMethod"></a>

```typescript
public readonly apiMethod: string;
```

- *Type:* string

On undefined value is not set in dimensions.

---

##### `apiResource`<sup>Optional</sup> <a name="apiResource" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMetricFactoryProps.property.apiResource"></a>

```typescript
public readonly apiResource: string;
```

- *Type:* string

On undefined value is not set in dimensions.

---

##### `apiStage`<sup>Optional</sup> <a name="apiStage" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMetricFactoryProps.property.apiStage"></a>

```typescript
public readonly apiStage: string;
```

- *Type:* string
- *Default:* $default

---

##### `fillTpsWithZeroes`<sup>Optional</sup> <a name="fillTpsWithZeroes" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMetricFactoryProps.property.fillTpsWithZeroes"></a>

```typescript
public readonly fillTpsWithZeroes: boolean;
```

- *Type:* boolean
- *Default:* true

---

##### `rateComputationMethod`<sup>Optional</sup> <a name="rateComputationMethod" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMetricFactoryProps.property.rateComputationMethod"></a>

```typescript
public readonly rateComputationMethod: RateComputationMethod;
```

- *Type:* <a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a>
- *Default:* average

---

### ApiGatewayV2HttpApiMonitoringProps <a name="ApiGatewayV2HttpApiMonitoringProps" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.Initializer"></a>

```typescript
import { ApiGatewayV2HttpApiMonitoringProps } from 'cdk-monitoring-constructs'

const apiGatewayV2HttpApiMonitoringProps: ApiGatewayV2HttpApiMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.api">api</a></code> | <code>@aws-cdk/aws-apigatewayv2-alpha.IHttpApi</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.apiMethod">apiMethod</a></code> | <code>string</code> | On undefined value is not set in dimensions. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.apiResource">apiResource</a></code> | <code>string</code> | On undefined value is not set in dimensions. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.apiStage">apiStage</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.fillTpsWithZeroes">fillTpsWithZeroes</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.rateComputationMethod">rateComputationMethod</a></code> | <code><a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.add4xxCountAlarm">add4xxCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.add4xxRateAlarm">add4xxRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.add5xxCountAlarm">add5xxCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.add5xxRateAlarm">add5xxRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addHighTpsAlarm">addHighTpsAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HighTpsThreshold">HighTpsThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyAverageAlarm">addIntegrationLatencyAverageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyP100Alarm">addIntegrationLatencyP100Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyP50Alarm">addIntegrationLatencyP50Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyP70Alarm">addIntegrationLatencyP70Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyP90Alarm">addIntegrationLatencyP90Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyP95Alarm">addIntegrationLatencyP95Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyP9999Alarm">addIntegrationLatencyP9999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyP999Alarm">addIntegrationLatencyP999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyP99Alarm">addIntegrationLatencyP99Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyTM50Alarm">addIntegrationLatencyTM50Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyTM70Alarm">addIntegrationLatencyTM70Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyTM90Alarm">addIntegrationLatencyTM90Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyTM95Alarm">addIntegrationLatencyTM95Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyTM9999Alarm">addIntegrationLatencyTM9999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyTM999Alarm">addIntegrationLatencyTM999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyTM99Alarm">addIntegrationLatencyTM99Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyAverageAlarm">addLatencyAverageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyP100Alarm">addLatencyP100Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyP50Alarm">addLatencyP50Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyP70Alarm">addLatencyP70Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyP90Alarm">addLatencyP90Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyP95Alarm">addLatencyP95Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyP9999Alarm">addLatencyP9999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyP999Alarm">addLatencyP999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyP99Alarm">addLatencyP99Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyTM50Alarm">addLatencyTM50Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyTM70Alarm">addLatencyTM70Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyTM90Alarm">addLatencyTM90Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyTM95Alarm">addLatencyTM95Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyTM9999Alarm">addLatencyTM9999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyTM999Alarm">addLatencyTM999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyTM99Alarm">addLatencyTM99Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLowTpsAlarm">addLowTpsAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LowTpsThreshold">LowTpsThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.latencyTypesToRender">latencyTypesToRender</a></code> | <code><a href="#cdk-monitoring-constructs.LatencyType">LatencyType</a>[]</code> | You can specify what latency types you want to be rendered in the dashboards. |

---

##### `api`<sup>Required</sup> <a name="api" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.api"></a>

```typescript
public readonly api: IHttpApi;
```

- *Type:* @aws-cdk/aws-apigatewayv2-alpha.IHttpApi

---

##### `apiMethod`<sup>Optional</sup> <a name="apiMethod" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.apiMethod"></a>

```typescript
public readonly apiMethod: string;
```

- *Type:* string

On undefined value is not set in dimensions.

---

##### `apiResource`<sup>Optional</sup> <a name="apiResource" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.apiResource"></a>

```typescript
public readonly apiResource: string;
```

- *Type:* string

On undefined value is not set in dimensions.

---

##### `apiStage`<sup>Optional</sup> <a name="apiStage" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.apiStage"></a>

```typescript
public readonly apiStage: string;
```

- *Type:* string
- *Default:* $default

---

##### `fillTpsWithZeroes`<sup>Optional</sup> <a name="fillTpsWithZeroes" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.fillTpsWithZeroes"></a>

```typescript
public readonly fillTpsWithZeroes: boolean;
```

- *Type:* boolean
- *Default:* true

---

##### `rateComputationMethod`<sup>Optional</sup> <a name="rateComputationMethod" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.rateComputationMethod"></a>

```typescript
public readonly rateComputationMethod: RateComputationMethod;
```

- *Type:* <a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a>
- *Default:* average

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `add4xxCountAlarm`<sup>Optional</sup> <a name="add4xxCountAlarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.add4xxCountAlarm"></a>

```typescript
public readonly add4xxCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `add4xxRateAlarm`<sup>Optional</sup> <a name="add4xxRateAlarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.add4xxRateAlarm"></a>

```typescript
public readonly add4xxRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

##### `add5xxCountAlarm`<sup>Optional</sup> <a name="add5xxCountAlarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.add5xxCountAlarm"></a>

```typescript
public readonly add5xxCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `add5xxRateAlarm`<sup>Optional</sup> <a name="add5xxRateAlarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.add5xxRateAlarm"></a>

```typescript
public readonly add5xxRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

##### `addHighTpsAlarm`<sup>Optional</sup> <a name="addHighTpsAlarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addHighTpsAlarm"></a>

```typescript
public readonly addHighTpsAlarm: {[ key: string ]: HighTpsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HighTpsThreshold">HighTpsThreshold</a>}

---

##### `addIntegrationLatencyAverageAlarm`<sup>Optional</sup> <a name="addIntegrationLatencyAverageAlarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyAverageAlarm"></a>

```typescript
public readonly addIntegrationLatencyAverageAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyP100Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyP100Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyP100Alarm"></a>

```typescript
public readonly addIntegrationLatencyP100Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyP50Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyP50Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyP50Alarm"></a>

```typescript
public readonly addIntegrationLatencyP50Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyP70Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyP70Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyP70Alarm"></a>

```typescript
public readonly addIntegrationLatencyP70Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyP90Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyP90Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyP90Alarm"></a>

```typescript
public readonly addIntegrationLatencyP90Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyP95Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyP95Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyP95Alarm"></a>

```typescript
public readonly addIntegrationLatencyP95Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyP9999Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyP9999Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyP9999Alarm"></a>

```typescript
public readonly addIntegrationLatencyP9999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyP999Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyP999Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyP999Alarm"></a>

```typescript
public readonly addIntegrationLatencyP999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyP99Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyP99Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyP99Alarm"></a>

```typescript
public readonly addIntegrationLatencyP99Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyTM50Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyTM50Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyTM50Alarm"></a>

```typescript
public readonly addIntegrationLatencyTM50Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyTM70Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyTM70Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyTM70Alarm"></a>

```typescript
public readonly addIntegrationLatencyTM70Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyTM90Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyTM90Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyTM90Alarm"></a>

```typescript
public readonly addIntegrationLatencyTM90Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyTM95Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyTM95Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyTM95Alarm"></a>

```typescript
public readonly addIntegrationLatencyTM95Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyTM9999Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyTM9999Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyTM9999Alarm"></a>

```typescript
public readonly addIntegrationLatencyTM9999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyTM999Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyTM999Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyTM999Alarm"></a>

```typescript
public readonly addIntegrationLatencyTM999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyTM99Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyTM99Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addIntegrationLatencyTM99Alarm"></a>

```typescript
public readonly addIntegrationLatencyTM99Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyAverageAlarm`<sup>Optional</sup> <a name="addLatencyAverageAlarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyAverageAlarm"></a>

```typescript
public readonly addLatencyAverageAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP100Alarm`<sup>Optional</sup> <a name="addLatencyP100Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyP100Alarm"></a>

```typescript
public readonly addLatencyP100Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP50Alarm`<sup>Optional</sup> <a name="addLatencyP50Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyP50Alarm"></a>

```typescript
public readonly addLatencyP50Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP70Alarm`<sup>Optional</sup> <a name="addLatencyP70Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyP70Alarm"></a>

```typescript
public readonly addLatencyP70Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP90Alarm`<sup>Optional</sup> <a name="addLatencyP90Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyP90Alarm"></a>

```typescript
public readonly addLatencyP90Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP95Alarm`<sup>Optional</sup> <a name="addLatencyP95Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyP95Alarm"></a>

```typescript
public readonly addLatencyP95Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP9999Alarm`<sup>Optional</sup> <a name="addLatencyP9999Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyP9999Alarm"></a>

```typescript
public readonly addLatencyP9999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP999Alarm`<sup>Optional</sup> <a name="addLatencyP999Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyP999Alarm"></a>

```typescript
public readonly addLatencyP999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP99Alarm`<sup>Optional</sup> <a name="addLatencyP99Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyP99Alarm"></a>

```typescript
public readonly addLatencyP99Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM50Alarm`<sup>Optional</sup> <a name="addLatencyTM50Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyTM50Alarm"></a>

```typescript
public readonly addLatencyTM50Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM70Alarm`<sup>Optional</sup> <a name="addLatencyTM70Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyTM70Alarm"></a>

```typescript
public readonly addLatencyTM70Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM90Alarm`<sup>Optional</sup> <a name="addLatencyTM90Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyTM90Alarm"></a>

```typescript
public readonly addLatencyTM90Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM95Alarm`<sup>Optional</sup> <a name="addLatencyTM95Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyTM95Alarm"></a>

```typescript
public readonly addLatencyTM95Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM9999Alarm`<sup>Optional</sup> <a name="addLatencyTM9999Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyTM9999Alarm"></a>

```typescript
public readonly addLatencyTM9999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM999Alarm`<sup>Optional</sup> <a name="addLatencyTM999Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyTM999Alarm"></a>

```typescript
public readonly addLatencyTM999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM99Alarm`<sup>Optional</sup> <a name="addLatencyTM99Alarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLatencyTM99Alarm"></a>

```typescript
public readonly addLatencyTM99Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLowTpsAlarm`<sup>Optional</sup> <a name="addLowTpsAlarm" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.addLowTpsAlarm"></a>

```typescript
public readonly addLowTpsAlarm: {[ key: string ]: LowTpsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LowTpsThreshold">LowTpsThreshold</a>}

---

##### `latencyTypesToRender`<sup>Optional</sup> <a name="latencyTypesToRender" id="cdk-monitoring-constructs.ApiGatewayV2HttpApiMonitoringProps.property.latencyTypesToRender"></a>

```typescript
public readonly latencyTypesToRender: LatencyType[];
```

- *Type:* <a href="#cdk-monitoring-constructs.LatencyType">LatencyType</a>[]
- *Default:* p50, p90, p99 (

You can specify what latency types you want to be rendered in the dashboards.

Note: any latency type with an alarm will be also added automatically.
If the list is undefined, default values will be shown.
If the list is empty, only the latency types with an alarm will be shown (if any).

> [DefaultLatencyTypesShown)](DefaultLatencyTypesShown))

---

### ApiGatewayV2MonitoringOptions <a name="ApiGatewayV2MonitoringOptions" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.Initializer"></a>

```typescript
import { ApiGatewayV2MonitoringOptions } from 'cdk-monitoring-constructs'

const apiGatewayV2MonitoringOptions: ApiGatewayV2MonitoringOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.add4xxCountAlarm">add4xxCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.add4xxRateAlarm">add4xxRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.add5xxCountAlarm">add5xxCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.add5xxRateAlarm">add5xxRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addHighTpsAlarm">addHighTpsAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HighTpsThreshold">HighTpsThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyAverageAlarm">addIntegrationLatencyAverageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyP100Alarm">addIntegrationLatencyP100Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyP50Alarm">addIntegrationLatencyP50Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyP70Alarm">addIntegrationLatencyP70Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyP90Alarm">addIntegrationLatencyP90Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyP95Alarm">addIntegrationLatencyP95Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyP9999Alarm">addIntegrationLatencyP9999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyP999Alarm">addIntegrationLatencyP999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyP99Alarm">addIntegrationLatencyP99Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyTM50Alarm">addIntegrationLatencyTM50Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyTM70Alarm">addIntegrationLatencyTM70Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyTM90Alarm">addIntegrationLatencyTM90Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyTM95Alarm">addIntegrationLatencyTM95Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyTM9999Alarm">addIntegrationLatencyTM9999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyTM999Alarm">addIntegrationLatencyTM999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyTM99Alarm">addIntegrationLatencyTM99Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyAverageAlarm">addLatencyAverageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyP100Alarm">addLatencyP100Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyP50Alarm">addLatencyP50Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyP70Alarm">addLatencyP70Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyP90Alarm">addLatencyP90Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyP95Alarm">addLatencyP95Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyP9999Alarm">addLatencyP9999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyP999Alarm">addLatencyP999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyP99Alarm">addLatencyP99Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyTM50Alarm">addLatencyTM50Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyTM70Alarm">addLatencyTM70Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyTM90Alarm">addLatencyTM90Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyTM95Alarm">addLatencyTM95Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyTM9999Alarm">addLatencyTM9999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyTM999Alarm">addLatencyTM999Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyTM99Alarm">addLatencyTM99Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLowTpsAlarm">addLowTpsAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LowTpsThreshold">LowTpsThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.latencyTypesToRender">latencyTypesToRender</a></code> | <code><a href="#cdk-monitoring-constructs.LatencyType">LatencyType</a>[]</code> | You can specify what latency types you want to be rendered in the dashboards. |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `add4xxCountAlarm`<sup>Optional</sup> <a name="add4xxCountAlarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.add4xxCountAlarm"></a>

```typescript
public readonly add4xxCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `add4xxRateAlarm`<sup>Optional</sup> <a name="add4xxRateAlarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.add4xxRateAlarm"></a>

```typescript
public readonly add4xxRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

##### `add5xxCountAlarm`<sup>Optional</sup> <a name="add5xxCountAlarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.add5xxCountAlarm"></a>

```typescript
public readonly add5xxCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `add5xxRateAlarm`<sup>Optional</sup> <a name="add5xxRateAlarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.add5xxRateAlarm"></a>

```typescript
public readonly add5xxRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

##### `addHighTpsAlarm`<sup>Optional</sup> <a name="addHighTpsAlarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addHighTpsAlarm"></a>

```typescript
public readonly addHighTpsAlarm: {[ key: string ]: HighTpsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HighTpsThreshold">HighTpsThreshold</a>}

---

##### `addIntegrationLatencyAverageAlarm`<sup>Optional</sup> <a name="addIntegrationLatencyAverageAlarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyAverageAlarm"></a>

```typescript
public readonly addIntegrationLatencyAverageAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyP100Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyP100Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyP100Alarm"></a>

```typescript
public readonly addIntegrationLatencyP100Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyP50Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyP50Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyP50Alarm"></a>

```typescript
public readonly addIntegrationLatencyP50Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyP70Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyP70Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyP70Alarm"></a>

```typescript
public readonly addIntegrationLatencyP70Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyP90Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyP90Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyP90Alarm"></a>

```typescript
public readonly addIntegrationLatencyP90Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyP95Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyP95Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyP95Alarm"></a>

```typescript
public readonly addIntegrationLatencyP95Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyP9999Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyP9999Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyP9999Alarm"></a>

```typescript
public readonly addIntegrationLatencyP9999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyP999Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyP999Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyP999Alarm"></a>

```typescript
public readonly addIntegrationLatencyP999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyP99Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyP99Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyP99Alarm"></a>

```typescript
public readonly addIntegrationLatencyP99Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyTM50Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyTM50Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyTM50Alarm"></a>

```typescript
public readonly addIntegrationLatencyTM50Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyTM70Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyTM70Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyTM70Alarm"></a>

```typescript
public readonly addIntegrationLatencyTM70Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyTM90Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyTM90Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyTM90Alarm"></a>

```typescript
public readonly addIntegrationLatencyTM90Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyTM95Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyTM95Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyTM95Alarm"></a>

```typescript
public readonly addIntegrationLatencyTM95Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyTM9999Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyTM9999Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyTM9999Alarm"></a>

```typescript
public readonly addIntegrationLatencyTM9999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyTM999Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyTM999Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyTM999Alarm"></a>

```typescript
public readonly addIntegrationLatencyTM999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addIntegrationLatencyTM99Alarm`<sup>Optional</sup> <a name="addIntegrationLatencyTM99Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addIntegrationLatencyTM99Alarm"></a>

```typescript
public readonly addIntegrationLatencyTM99Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyAverageAlarm`<sup>Optional</sup> <a name="addLatencyAverageAlarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyAverageAlarm"></a>

```typescript
public readonly addLatencyAverageAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP100Alarm`<sup>Optional</sup> <a name="addLatencyP100Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyP100Alarm"></a>

```typescript
public readonly addLatencyP100Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP50Alarm`<sup>Optional</sup> <a name="addLatencyP50Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyP50Alarm"></a>

```typescript
public readonly addLatencyP50Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP70Alarm`<sup>Optional</sup> <a name="addLatencyP70Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyP70Alarm"></a>

```typescript
public readonly addLatencyP70Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP90Alarm`<sup>Optional</sup> <a name="addLatencyP90Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyP90Alarm"></a>

```typescript
public readonly addLatencyP90Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP95Alarm`<sup>Optional</sup> <a name="addLatencyP95Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyP95Alarm"></a>

```typescript
public readonly addLatencyP95Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP9999Alarm`<sup>Optional</sup> <a name="addLatencyP9999Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyP9999Alarm"></a>

```typescript
public readonly addLatencyP9999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP999Alarm`<sup>Optional</sup> <a name="addLatencyP999Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyP999Alarm"></a>

```typescript
public readonly addLatencyP999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP99Alarm`<sup>Optional</sup> <a name="addLatencyP99Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyP99Alarm"></a>

```typescript
public readonly addLatencyP99Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM50Alarm`<sup>Optional</sup> <a name="addLatencyTM50Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyTM50Alarm"></a>

```typescript
public readonly addLatencyTM50Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM70Alarm`<sup>Optional</sup> <a name="addLatencyTM70Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyTM70Alarm"></a>

```typescript
public readonly addLatencyTM70Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM90Alarm`<sup>Optional</sup> <a name="addLatencyTM90Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyTM90Alarm"></a>

```typescript
public readonly addLatencyTM90Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM95Alarm`<sup>Optional</sup> <a name="addLatencyTM95Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyTM95Alarm"></a>

```typescript
public readonly addLatencyTM95Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM9999Alarm`<sup>Optional</sup> <a name="addLatencyTM9999Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyTM9999Alarm"></a>

```typescript
public readonly addLatencyTM9999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM999Alarm`<sup>Optional</sup> <a name="addLatencyTM999Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyTM999Alarm"></a>

```typescript
public readonly addLatencyTM999Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyTM99Alarm`<sup>Optional</sup> <a name="addLatencyTM99Alarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLatencyTM99Alarm"></a>

```typescript
public readonly addLatencyTM99Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLowTpsAlarm`<sup>Optional</sup> <a name="addLowTpsAlarm" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.addLowTpsAlarm"></a>

```typescript
public readonly addLowTpsAlarm: {[ key: string ]: LowTpsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LowTpsThreshold">LowTpsThreshold</a>}

---

##### `latencyTypesToRender`<sup>Optional</sup> <a name="latencyTypesToRender" id="cdk-monitoring-constructs.ApiGatewayV2MonitoringOptions.property.latencyTypesToRender"></a>

```typescript
public readonly latencyTypesToRender: LatencyType[];
```

- *Type:* <a href="#cdk-monitoring-constructs.LatencyType">LatencyType</a>[]
- *Default:* p50, p90, p99 (

You can specify what latency types you want to be rendered in the dashboards.

Note: any latency type with an alarm will be also added automatically.
If the list is undefined, default values will be shown.
If the list is empty, only the latency types with an alarm will be shown (if any).

> [DefaultLatencyTypesShown)](DefaultLatencyTypesShown))

---

### ApplicationLoadBalancerMetricFactoryProps <a name="ApplicationLoadBalancerMetricFactoryProps" id="cdk-monitoring-constructs.ApplicationLoadBalancerMetricFactoryProps"></a>

Props to create ApplicationLoadBalancerMetricFactory.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.ApplicationLoadBalancerMetricFactoryProps.Initializer"></a>

```typescript
import { ApplicationLoadBalancerMetricFactoryProps } from 'cdk-monitoring-constructs'

const applicationLoadBalancerMetricFactoryProps: ApplicationLoadBalancerMetricFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.ApplicationLoadBalancerMetricFactoryProps.property.applicationLoadBalancer">applicationLoadBalancer</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.ApplicationLoadBalancerMetricFactoryProps.property.applicationTargetGroup">applicationTargetGroup</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup</code> | *No description.* |

---

##### `applicationLoadBalancer`<sup>Required</sup> <a name="applicationLoadBalancer" id="cdk-monitoring-constructs.ApplicationLoadBalancerMetricFactoryProps.property.applicationLoadBalancer"></a>

```typescript
public readonly applicationLoadBalancer: ApplicationLoadBalancer;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer

---

##### `applicationTargetGroup`<sup>Required</sup> <a name="applicationTargetGroup" id="cdk-monitoring-constructs.ApplicationLoadBalancerMetricFactoryProps.property.applicationTargetGroup"></a>

```typescript
public readonly applicationTargetGroup: ApplicationTargetGroup;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup

---

### AppSyncMetricFactoryProps <a name="AppSyncMetricFactoryProps" id="cdk-monitoring-constructs.AppSyncMetricFactoryProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AppSyncMetricFactoryProps.Initializer"></a>

```typescript
import { AppSyncMetricFactoryProps } from 'cdk-monitoring-constructs'

const appSyncMetricFactoryProps: AppSyncMetricFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AppSyncMetricFactoryProps.property.api">api</a></code> | <code>@aws-cdk/aws-appsync-alpha.GraphqlApi</code> | the GraphQL API to monitor. |
| <code><a href="#cdk-monitoring-constructs.AppSyncMetricFactoryProps.property.fillTpsWithZeroes">fillTpsWithZeroes</a></code> | <code>boolean</code> | whether the TPS should be filled with zeroes. |
| <code><a href="#cdk-monitoring-constructs.AppSyncMetricFactoryProps.property.rateComputationMethod">rateComputationMethod</a></code> | <code><a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a></code> | method to compute TPS. |

---

##### `api`<sup>Required</sup> <a name="api" id="cdk-monitoring-constructs.AppSyncMetricFactoryProps.property.api"></a>

```typescript
public readonly api: GraphqlApi;
```

- *Type:* @aws-cdk/aws-appsync-alpha.GraphqlApi

the GraphQL API to monitor.

---

##### `fillTpsWithZeroes`<sup>Optional</sup> <a name="fillTpsWithZeroes" id="cdk-monitoring-constructs.AppSyncMetricFactoryProps.property.fillTpsWithZeroes"></a>

```typescript
public readonly fillTpsWithZeroes: boolean;
```

- *Type:* boolean
- *Default:* true

whether the TPS should be filled with zeroes.

---

##### `rateComputationMethod`<sup>Optional</sup> <a name="rateComputationMethod" id="cdk-monitoring-constructs.AppSyncMetricFactoryProps.property.rateComputationMethod"></a>

```typescript
public readonly rateComputationMethod: RateComputationMethod;
```

- *Type:* <a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a>
- *Default:* average

method to compute TPS.

---

### AppSyncMonitoringOptions <a name="AppSyncMonitoringOptions" id="cdk-monitoring-constructs.AppSyncMonitoringOptions"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AppSyncMonitoringOptions.Initializer"></a>

```typescript
import { AppSyncMonitoringOptions } from 'cdk-monitoring-constructs'

const appSyncMonitoringOptions: AppSyncMonitoringOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringOptions.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringOptions.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringOptions.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringOptions.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringOptions.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringOptions.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringOptions.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringOptions.property.add4XXErrorCountAlarm">add4XXErrorCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringOptions.property.add4XXErrorRateAlarm">add4XXErrorRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringOptions.property.add5XXFaultCountAlarm">add5XXFaultCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringOptions.property.add5XXFaultRateAlarm">add5XXFaultRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringOptions.property.addHighTpsAlarm">addHighTpsAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HighTpsThreshold">HighTpsThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringOptions.property.addLatencyP50Alarm">addLatencyP50Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringOptions.property.addLatencyP90Alarm">addLatencyP90Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringOptions.property.addLatencyP99Alarm">addLatencyP99Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringOptions.property.addLowTpsAlarm">addLowTpsAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LowTpsThreshold">LowTpsThreshold</a>}</code> | *No description.* |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.AppSyncMonitoringOptions.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.AppSyncMonitoringOptions.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.AppSyncMonitoringOptions.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.AppSyncMonitoringOptions.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.AppSyncMonitoringOptions.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.AppSyncMonitoringOptions.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.AppSyncMonitoringOptions.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `add4XXErrorCountAlarm`<sup>Optional</sup> <a name="add4XXErrorCountAlarm" id="cdk-monitoring-constructs.AppSyncMonitoringOptions.property.add4XXErrorCountAlarm"></a>

```typescript
public readonly add4XXErrorCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `add4XXErrorRateAlarm`<sup>Optional</sup> <a name="add4XXErrorRateAlarm" id="cdk-monitoring-constructs.AppSyncMonitoringOptions.property.add4XXErrorRateAlarm"></a>

```typescript
public readonly add4XXErrorRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

##### `add5XXFaultCountAlarm`<sup>Optional</sup> <a name="add5XXFaultCountAlarm" id="cdk-monitoring-constructs.AppSyncMonitoringOptions.property.add5XXFaultCountAlarm"></a>

```typescript
public readonly add5XXFaultCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `add5XXFaultRateAlarm`<sup>Optional</sup> <a name="add5XXFaultRateAlarm" id="cdk-monitoring-constructs.AppSyncMonitoringOptions.property.add5XXFaultRateAlarm"></a>

```typescript
public readonly add5XXFaultRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

##### `addHighTpsAlarm`<sup>Optional</sup> <a name="addHighTpsAlarm" id="cdk-monitoring-constructs.AppSyncMonitoringOptions.property.addHighTpsAlarm"></a>

```typescript
public readonly addHighTpsAlarm: {[ key: string ]: HighTpsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HighTpsThreshold">HighTpsThreshold</a>}

---

##### `addLatencyP50Alarm`<sup>Optional</sup> <a name="addLatencyP50Alarm" id="cdk-monitoring-constructs.AppSyncMonitoringOptions.property.addLatencyP50Alarm"></a>

```typescript
public readonly addLatencyP50Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP90Alarm`<sup>Optional</sup> <a name="addLatencyP90Alarm" id="cdk-monitoring-constructs.AppSyncMonitoringOptions.property.addLatencyP90Alarm"></a>

```typescript
public readonly addLatencyP90Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP99Alarm`<sup>Optional</sup> <a name="addLatencyP99Alarm" id="cdk-monitoring-constructs.AppSyncMonitoringOptions.property.addLatencyP99Alarm"></a>

```typescript
public readonly addLatencyP99Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLowTpsAlarm`<sup>Optional</sup> <a name="addLowTpsAlarm" id="cdk-monitoring-constructs.AppSyncMonitoringOptions.property.addLowTpsAlarm"></a>

```typescript
public readonly addLowTpsAlarm: {[ key: string ]: LowTpsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LowTpsThreshold">LowTpsThreshold</a>}

---

### AppSyncMonitoringProps <a name="AppSyncMonitoringProps" id="cdk-monitoring-constructs.AppSyncMonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AppSyncMonitoringProps.Initializer"></a>

```typescript
import { AppSyncMonitoringProps } from 'cdk-monitoring-constructs'

const appSyncMonitoringProps: AppSyncMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringProps.property.add4XXErrorCountAlarm">add4XXErrorCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringProps.property.add4XXErrorRateAlarm">add4XXErrorRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringProps.property.add5XXFaultCountAlarm">add5XXFaultCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringProps.property.add5XXFaultRateAlarm">add5XXFaultRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringProps.property.addHighTpsAlarm">addHighTpsAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HighTpsThreshold">HighTpsThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringProps.property.addLatencyP50Alarm">addLatencyP50Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringProps.property.addLatencyP90Alarm">addLatencyP90Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringProps.property.addLatencyP99Alarm">addLatencyP99Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringProps.property.addLowTpsAlarm">addLowTpsAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LowTpsThreshold">LowTpsThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringProps.property.api">api</a></code> | <code>@aws-cdk/aws-appsync-alpha.GraphqlApi</code> | the GraphQL API to monitor. |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringProps.property.fillTpsWithZeroes">fillTpsWithZeroes</a></code> | <code>boolean</code> | whether the TPS should be filled with zeroes. |
| <code><a href="#cdk-monitoring-constructs.AppSyncMonitoringProps.property.rateComputationMethod">rateComputationMethod</a></code> | <code><a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a></code> | method to compute TPS. |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.AppSyncMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.AppSyncMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.AppSyncMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.AppSyncMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.AppSyncMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.AppSyncMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.AppSyncMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `add4XXErrorCountAlarm`<sup>Optional</sup> <a name="add4XXErrorCountAlarm" id="cdk-monitoring-constructs.AppSyncMonitoringProps.property.add4XXErrorCountAlarm"></a>

```typescript
public readonly add4XXErrorCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `add4XXErrorRateAlarm`<sup>Optional</sup> <a name="add4XXErrorRateAlarm" id="cdk-monitoring-constructs.AppSyncMonitoringProps.property.add4XXErrorRateAlarm"></a>

```typescript
public readonly add4XXErrorRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

##### `add5XXFaultCountAlarm`<sup>Optional</sup> <a name="add5XXFaultCountAlarm" id="cdk-monitoring-constructs.AppSyncMonitoringProps.property.add5XXFaultCountAlarm"></a>

```typescript
public readonly add5XXFaultCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `add5XXFaultRateAlarm`<sup>Optional</sup> <a name="add5XXFaultRateAlarm" id="cdk-monitoring-constructs.AppSyncMonitoringProps.property.add5XXFaultRateAlarm"></a>

```typescript
public readonly add5XXFaultRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

##### `addHighTpsAlarm`<sup>Optional</sup> <a name="addHighTpsAlarm" id="cdk-monitoring-constructs.AppSyncMonitoringProps.property.addHighTpsAlarm"></a>

```typescript
public readonly addHighTpsAlarm: {[ key: string ]: HighTpsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HighTpsThreshold">HighTpsThreshold</a>}

---

##### `addLatencyP50Alarm`<sup>Optional</sup> <a name="addLatencyP50Alarm" id="cdk-monitoring-constructs.AppSyncMonitoringProps.property.addLatencyP50Alarm"></a>

```typescript
public readonly addLatencyP50Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP90Alarm`<sup>Optional</sup> <a name="addLatencyP90Alarm" id="cdk-monitoring-constructs.AppSyncMonitoringProps.property.addLatencyP90Alarm"></a>

```typescript
public readonly addLatencyP90Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP99Alarm`<sup>Optional</sup> <a name="addLatencyP99Alarm" id="cdk-monitoring-constructs.AppSyncMonitoringProps.property.addLatencyP99Alarm"></a>

```typescript
public readonly addLatencyP99Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLowTpsAlarm`<sup>Optional</sup> <a name="addLowTpsAlarm" id="cdk-monitoring-constructs.AppSyncMonitoringProps.property.addLowTpsAlarm"></a>

```typescript
public readonly addLowTpsAlarm: {[ key: string ]: LowTpsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LowTpsThreshold">LowTpsThreshold</a>}

---

##### `api`<sup>Required</sup> <a name="api" id="cdk-monitoring-constructs.AppSyncMonitoringProps.property.api"></a>

```typescript
public readonly api: GraphqlApi;
```

- *Type:* @aws-cdk/aws-appsync-alpha.GraphqlApi

the GraphQL API to monitor.

---

##### `fillTpsWithZeroes`<sup>Optional</sup> <a name="fillTpsWithZeroes" id="cdk-monitoring-constructs.AppSyncMonitoringProps.property.fillTpsWithZeroes"></a>

```typescript
public readonly fillTpsWithZeroes: boolean;
```

- *Type:* boolean
- *Default:* true

whether the TPS should be filled with zeroes.

---

##### `rateComputationMethod`<sup>Optional</sup> <a name="rateComputationMethod" id="cdk-monitoring-constructs.AppSyncMonitoringProps.property.rateComputationMethod"></a>

```typescript
public readonly rateComputationMethod: RateComputationMethod;
```

- *Type:* <a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a>
- *Default:* average

method to compute TPS.

---

### AutoScalingGroupMetricFactoryProps <a name="AutoScalingGroupMetricFactoryProps" id="cdk-monitoring-constructs.AutoScalingGroupMetricFactoryProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AutoScalingGroupMetricFactoryProps.Initializer"></a>

```typescript
import { AutoScalingGroupMetricFactoryProps } from 'cdk-monitoring-constructs'

const autoScalingGroupMetricFactoryProps: AutoScalingGroupMetricFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AutoScalingGroupMetricFactoryProps.property.autoScalingGroup">autoScalingGroup</a></code> | <code>aws-cdk-lib.aws_autoscaling.IAutoScalingGroup</code> | *No description.* |

---

##### `autoScalingGroup`<sup>Required</sup> <a name="autoScalingGroup" id="cdk-monitoring-constructs.AutoScalingGroupMetricFactoryProps.property.autoScalingGroup"></a>

```typescript
public readonly autoScalingGroup: IAutoScalingGroup;
```

- *Type:* aws-cdk-lib.aws_autoscaling.IAutoScalingGroup

---

### AutoScalingGroupMonitoringOptions <a name="AutoScalingGroupMonitoringOptions" id="cdk-monitoring-constructs.AutoScalingGroupMonitoringOptions"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AutoScalingGroupMonitoringOptions.Initializer"></a>

```typescript
import { AutoScalingGroupMonitoringOptions } from 'cdk-monitoring-constructs'

const autoScalingGroupMonitoringOptions: AutoScalingGroupMonitoringOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AutoScalingGroupMonitoringOptions.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.AutoScalingGroupMonitoringOptions.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.AutoScalingGroupMonitoringOptions.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.AutoScalingGroupMonitoringOptions.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.AutoScalingGroupMonitoringOptions.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.AutoScalingGroupMonitoringOptions.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.AutoScalingGroupMonitoringOptions.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.AutoScalingGroupMonitoringOptions.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.AutoScalingGroupMonitoringOptions.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.AutoScalingGroupMonitoringOptions.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.AutoScalingGroupMonitoringOptions.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.AutoScalingGroupMonitoringOptions.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.AutoScalingGroupMonitoringOptions.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.AutoScalingGroupMonitoringOptions.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

### AutoScalingGroupMonitoringProps <a name="AutoScalingGroupMonitoringProps" id="cdk-monitoring-constructs.AutoScalingGroupMonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AutoScalingGroupMonitoringProps.Initializer"></a>

```typescript
import { AutoScalingGroupMonitoringProps } from 'cdk-monitoring-constructs'

const autoScalingGroupMonitoringProps: AutoScalingGroupMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AutoScalingGroupMonitoringProps.property.autoScalingGroup">autoScalingGroup</a></code> | <code>aws-cdk-lib.aws_autoscaling.IAutoScalingGroup</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AutoScalingGroupMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.AutoScalingGroupMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.AutoScalingGroupMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.AutoScalingGroupMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.AutoScalingGroupMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.AutoScalingGroupMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.AutoScalingGroupMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |

---

##### `autoScalingGroup`<sup>Required</sup> <a name="autoScalingGroup" id="cdk-monitoring-constructs.AutoScalingGroupMonitoringProps.property.autoScalingGroup"></a>

```typescript
public readonly autoScalingGroup: IAutoScalingGroup;
```

- *Type:* aws-cdk-lib.aws_autoscaling.IAutoScalingGroup

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.AutoScalingGroupMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.AutoScalingGroupMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.AutoScalingGroupMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.AutoScalingGroupMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.AutoScalingGroupMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.AutoScalingGroupMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.AutoScalingGroupMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

### AvailabilityThreshold <a name="AvailabilityThreshold" id="cdk-monitoring-constructs.AvailabilityThreshold"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AvailabilityThreshold.Initializer"></a>

```typescript
import { AvailabilityThreshold } from 'cdk-monitoring-constructs'

const availabilityThreshold: AvailabilityThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AvailabilityThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.AvailabilityThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.AvailabilityThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.AvailabilityThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.AvailabilityThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.AvailabilityThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.AvailabilityThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.AvailabilityThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.AvailabilityThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.AvailabilityThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.AvailabilityThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.AvailabilityThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.AvailabilityThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.AvailabilityThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.AvailabilityThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.AvailabilityThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.AvailabilityThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.AvailabilityThreshold.property.minAvailabilityPercent">minAvailabilityPercent</a></code> | <code>number</code> | *No description.* |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.AvailabilityThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.AvailabilityThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.AvailabilityThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.AvailabilityThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.AvailabilityThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.AvailabilityThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.AvailabilityThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.AvailabilityThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.AvailabilityThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.AvailabilityThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.AvailabilityThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.AvailabilityThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.AvailabilityThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.AvailabilityThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, a composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
This composite alarm will be returned as a result and uses the specified alarm actions.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.AvailabilityThreshold.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.AvailabilityThreshold.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `treatMissingDataOverride`<sup>Optional</sup> <a name="treatMissingDataOverride" id="cdk-monitoring-constructs.AvailabilityThreshold.property.treatMissingDataOverride"></a>

```typescript
public readonly treatMissingDataOverride: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData
- *Default:* alarm-specific default

Behaviour in case the metric data is missing.

---

##### `minAvailabilityPercent`<sup>Required</sup> <a name="minAvailabilityPercent" id="cdk-monitoring-constructs.AvailabilityThreshold.property.minAvailabilityPercent"></a>

```typescript
public readonly minAvailabilityPercent: number;
```

- *Type:* number

---

### AwsConsoleUrlFactoryProps <a name="AwsConsoleUrlFactoryProps" id="cdk-monitoring-constructs.AwsConsoleUrlFactoryProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.AwsConsoleUrlFactoryProps.Initializer"></a>

```typescript
import { AwsConsoleUrlFactoryProps } from 'cdk-monitoring-constructs'

const awsConsoleUrlFactoryProps: AwsConsoleUrlFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.AwsConsoleUrlFactoryProps.property.awsAccountId">awsAccountId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.AwsConsoleUrlFactoryProps.property.awsAccountRegion">awsAccountRegion</a></code> | <code>string</code> | *No description.* |

---

##### `awsAccountId`<sup>Required</sup> <a name="awsAccountId" id="cdk-monitoring-constructs.AwsConsoleUrlFactoryProps.property.awsAccountId"></a>

```typescript
public readonly awsAccountId: string;
```

- *Type:* string

---

##### `awsAccountRegion`<sup>Required</sup> <a name="awsAccountRegion" id="cdk-monitoring-constructs.AwsConsoleUrlFactoryProps.property.awsAccountRegion"></a>

```typescript
public readonly awsAccountRegion: string;
```

- *Type:* string

---

### BaseDlqAlarms <a name="BaseDlqAlarms" id="cdk-monitoring-constructs.BaseDlqAlarms"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.BaseDlqAlarms.Initializer"></a>

```typescript
import { BaseDlqAlarms } from 'cdk-monitoring-constructs'

const baseDlqAlarms: BaseDlqAlarms = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.BaseDlqAlarms.property.addDeadLetterQueueMaxIncomingMessagesAlarm">addDeadLetterQueueMaxIncomingMessagesAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MaxIncomingMessagesCountThreshold">MaxIncomingMessagesCountThreshold</a>}</code> | Alarm on the number of messages added to a queue. |
| <code><a href="#cdk-monitoring-constructs.BaseDlqAlarms.property.addDeadLetterQueueMaxMessageAgeAlarm">addDeadLetterQueueMaxMessageAgeAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MaxMessageAgeThreshold">MaxMessageAgeThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.BaseDlqAlarms.property.addDeadLetterQueueMaxSizeAlarm">addDeadLetterQueueMaxSizeAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MaxMessageCountThreshold">MaxMessageCountThreshold</a>}</code> | *No description.* |

---

##### `addDeadLetterQueueMaxIncomingMessagesAlarm`<sup>Optional</sup> <a name="addDeadLetterQueueMaxIncomingMessagesAlarm" id="cdk-monitoring-constructs.BaseDlqAlarms.property.addDeadLetterQueueMaxIncomingMessagesAlarm"></a>

```typescript
public readonly addDeadLetterQueueMaxIncomingMessagesAlarm: {[ key: string ]: MaxIncomingMessagesCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MaxIncomingMessagesCountThreshold">MaxIncomingMessagesCountThreshold</a>}

Alarm on the number of messages added to a queue.

Note that this corresponds with the NumberOfMessagesSent metric, which does not capture messages sent to the DLQ
as a result of a failed processing attempt.

> [https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html#sqs-dlq-number-of-messages](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html#sqs-dlq-number-of-messages)

---

##### `addDeadLetterQueueMaxMessageAgeAlarm`<sup>Optional</sup> <a name="addDeadLetterQueueMaxMessageAgeAlarm" id="cdk-monitoring-constructs.BaseDlqAlarms.property.addDeadLetterQueueMaxMessageAgeAlarm"></a>

```typescript
public readonly addDeadLetterQueueMaxMessageAgeAlarm: {[ key: string ]: MaxMessageAgeThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MaxMessageAgeThreshold">MaxMessageAgeThreshold</a>}

---

##### `addDeadLetterQueueMaxSizeAlarm`<sup>Optional</sup> <a name="addDeadLetterQueueMaxSizeAlarm" id="cdk-monitoring-constructs.BaseDlqAlarms.property.addDeadLetterQueueMaxSizeAlarm"></a>

```typescript
public readonly addDeadLetterQueueMaxSizeAlarm: {[ key: string ]: MaxMessageCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MaxMessageCountThreshold">MaxMessageCountThreshold</a>}

---

### BaseEc2ServiceAlarms <a name="BaseEc2ServiceAlarms" id="cdk-monitoring-constructs.BaseEc2ServiceAlarms"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.BaseEc2ServiceAlarms.Initializer"></a>

```typescript
import { BaseEc2ServiceAlarms } from 'cdk-monitoring-constructs'

const baseEc2ServiceAlarms: BaseEc2ServiceAlarms = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.BaseEc2ServiceAlarms.property.addCpuUsageAlarm">addCpuUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.BaseEc2ServiceAlarms.property.addMemoryUsageAlarm">addMemoryUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.BaseEc2ServiceAlarms.property.addRunningTaskCountAlarm">addRunningTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}</code> | Container Insights needs to be enabled for the cluster for this alarm. |
| <code><a href="#cdk-monitoring-constructs.BaseEc2ServiceAlarms.property.maxAutoScalingTaskCount">maxAutoScalingTaskCount</a></code> | <code>number</code> | maximum number of tasks, as specified in your auto scaling config. |
| <code><a href="#cdk-monitoring-constructs.BaseEc2ServiceAlarms.property.minAutoScalingTaskCount">minAutoScalingTaskCount</a></code> | <code>number</code> | minimum number of tasks, as specified in your auto scaling config. |

---

##### `addCpuUsageAlarm`<sup>Optional</sup> <a name="addCpuUsageAlarm" id="cdk-monitoring-constructs.BaseEc2ServiceAlarms.property.addCpuUsageAlarm"></a>

```typescript
public readonly addCpuUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addMemoryUsageAlarm`<sup>Optional</sup> <a name="addMemoryUsageAlarm" id="cdk-monitoring-constructs.BaseEc2ServiceAlarms.property.addMemoryUsageAlarm"></a>

```typescript
public readonly addMemoryUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addRunningTaskCountAlarm`<sup>Optional</sup> <a name="addRunningTaskCountAlarm" id="cdk-monitoring-constructs.BaseEc2ServiceAlarms.property.addRunningTaskCountAlarm"></a>

```typescript
public readonly addRunningTaskCountAlarm: {[ key: string ]: RunningTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}

Container Insights needs to be enabled for the cluster for this alarm.

---

##### `maxAutoScalingTaskCount`<sup>Optional</sup> <a name="maxAutoScalingTaskCount" id="cdk-monitoring-constructs.BaseEc2ServiceAlarms.property.maxAutoScalingTaskCount"></a>

```typescript
public readonly maxAutoScalingTaskCount: number;
```

- *Type:* number

maximum number of tasks, as specified in your auto scaling config.

---

##### `minAutoScalingTaskCount`<sup>Optional</sup> <a name="minAutoScalingTaskCount" id="cdk-monitoring-constructs.BaseEc2ServiceAlarms.property.minAutoScalingTaskCount"></a>

```typescript
public readonly minAutoScalingTaskCount: number;
```

- *Type:* number

minimum number of tasks, as specified in your auto scaling config.

---

### BaseFargateServiceAlarms <a name="BaseFargateServiceAlarms" id="cdk-monitoring-constructs.BaseFargateServiceAlarms"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.BaseFargateServiceAlarms.Initializer"></a>

```typescript
import { BaseFargateServiceAlarms } from 'cdk-monitoring-constructs'

const baseFargateServiceAlarms: BaseFargateServiceAlarms = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.BaseFargateServiceAlarms.property.addCpuUsageAlarm">addCpuUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.BaseFargateServiceAlarms.property.addMemoryUsageAlarm">addMemoryUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.BaseFargateServiceAlarms.property.addRunningTaskCountAlarm">addRunningTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}</code> | Container Insights needs to be enabled for the cluster for this alarm. |
| <code><a href="#cdk-monitoring-constructs.BaseFargateServiceAlarms.property.maxAutoScalingTaskCount">maxAutoScalingTaskCount</a></code> | <code>number</code> | maximum number of tasks, as specified in your auto scaling config. |
| <code><a href="#cdk-monitoring-constructs.BaseFargateServiceAlarms.property.minAutoScalingTaskCount">minAutoScalingTaskCount</a></code> | <code>number</code> | minimum number of tasks, as specified in your auto scaling config. |

---

##### `addCpuUsageAlarm`<sup>Optional</sup> <a name="addCpuUsageAlarm" id="cdk-monitoring-constructs.BaseFargateServiceAlarms.property.addCpuUsageAlarm"></a>

```typescript
public readonly addCpuUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addMemoryUsageAlarm`<sup>Optional</sup> <a name="addMemoryUsageAlarm" id="cdk-monitoring-constructs.BaseFargateServiceAlarms.property.addMemoryUsageAlarm"></a>

```typescript
public readonly addMemoryUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addRunningTaskCountAlarm`<sup>Optional</sup> <a name="addRunningTaskCountAlarm" id="cdk-monitoring-constructs.BaseFargateServiceAlarms.property.addRunningTaskCountAlarm"></a>

```typescript
public readonly addRunningTaskCountAlarm: {[ key: string ]: RunningTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}

Container Insights needs to be enabled for the cluster for this alarm.

---

##### `maxAutoScalingTaskCount`<sup>Optional</sup> <a name="maxAutoScalingTaskCount" id="cdk-monitoring-constructs.BaseFargateServiceAlarms.property.maxAutoScalingTaskCount"></a>

```typescript
public readonly maxAutoScalingTaskCount: number;
```

- *Type:* number

maximum number of tasks, as specified in your auto scaling config.

---

##### `minAutoScalingTaskCount`<sup>Optional</sup> <a name="minAutoScalingTaskCount" id="cdk-monitoring-constructs.BaseFargateServiceAlarms.property.minAutoScalingTaskCount"></a>

```typescript
public readonly minAutoScalingTaskCount: number;
```

- *Type:* number

minimum number of tasks, as specified in your auto scaling config.

---

### BaseMonitoringProps <a name="BaseMonitoringProps" id="cdk-monitoring-constructs.BaseMonitoringProps"></a>

Base class for properties passed to each monitoring construct.

It contains (mostly optional) properties to specify naming, placement, and so on.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.BaseMonitoringProps.Initializer"></a>

```typescript
import { BaseMonitoringProps } from 'cdk-monitoring-constructs'

const baseMonitoringProps: BaseMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.BaseMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.BaseMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.BaseMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.BaseMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.BaseMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.BaseMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.BaseMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.BaseMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.BaseMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.BaseMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.BaseMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.BaseMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.BaseMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.BaseMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

### BaseServiceMetricFactoryProps <a name="BaseServiceMetricFactoryProps" id="cdk-monitoring-constructs.BaseServiceMetricFactoryProps"></a>

Props to create BaseServiceMetricFactory.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.BaseServiceMetricFactoryProps.Initializer"></a>

```typescript
import { BaseServiceMetricFactoryProps } from 'cdk-monitoring-constructs'

const baseServiceMetricFactoryProps: BaseServiceMetricFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.BaseServiceMetricFactoryProps.property.service">service</a></code> | <code>aws-cdk-lib.aws_ecs.BaseService</code> | *No description.* |

---

##### `service`<sup>Required</sup> <a name="service" id="cdk-monitoring-constructs.BaseServiceMetricFactoryProps.property.service"></a>

```typescript
public readonly service: BaseService;
```

- *Type:* aws-cdk-lib.aws_ecs.BaseService

---

### BaseSqsQueueAlarms <a name="BaseSqsQueueAlarms" id="cdk-monitoring-constructs.BaseSqsQueueAlarms"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.BaseSqsQueueAlarms.Initializer"></a>

```typescript
import { BaseSqsQueueAlarms } from 'cdk-monitoring-constructs'

const baseSqsQueueAlarms: BaseSqsQueueAlarms = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.BaseSqsQueueAlarms.property.addQueueMaxIncomingMessagesAlarm">addQueueMaxIncomingMessagesAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MaxIncomingMessagesCountThreshold">MaxIncomingMessagesCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.BaseSqsQueueAlarms.property.addQueueMaxMessageAgeAlarm">addQueueMaxMessageAgeAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MaxMessageAgeThreshold">MaxMessageAgeThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.BaseSqsQueueAlarms.property.addQueueMaxSizeAlarm">addQueueMaxSizeAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MaxMessageCountThreshold">MaxMessageCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.BaseSqsQueueAlarms.property.addQueueMaxTimeToDrainMessagesAlarm">addQueueMaxTimeToDrainMessagesAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MaxTimeToDrainThreshold">MaxTimeToDrainThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.BaseSqsQueueAlarms.property.addQueueMinIncomingMessagesAlarm">addQueueMinIncomingMessagesAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MinIncomingMessagesCountThreshold">MinIncomingMessagesCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.BaseSqsQueueAlarms.property.addQueueMinSizeAlarm">addQueueMinSizeAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MinMessageCountThreshold">MinMessageCountThreshold</a>}</code> | *No description.* |

---

##### `addQueueMaxIncomingMessagesAlarm`<sup>Optional</sup> <a name="addQueueMaxIncomingMessagesAlarm" id="cdk-monitoring-constructs.BaseSqsQueueAlarms.property.addQueueMaxIncomingMessagesAlarm"></a>

```typescript
public readonly addQueueMaxIncomingMessagesAlarm: {[ key: string ]: MaxIncomingMessagesCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MaxIncomingMessagesCountThreshold">MaxIncomingMessagesCountThreshold</a>}

---

##### `addQueueMaxMessageAgeAlarm`<sup>Optional</sup> <a name="addQueueMaxMessageAgeAlarm" id="cdk-monitoring-constructs.BaseSqsQueueAlarms.property.addQueueMaxMessageAgeAlarm"></a>

```typescript
public readonly addQueueMaxMessageAgeAlarm: {[ key: string ]: MaxMessageAgeThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MaxMessageAgeThreshold">MaxMessageAgeThreshold</a>}

---

##### `addQueueMaxSizeAlarm`<sup>Optional</sup> <a name="addQueueMaxSizeAlarm" id="cdk-monitoring-constructs.BaseSqsQueueAlarms.property.addQueueMaxSizeAlarm"></a>

```typescript
public readonly addQueueMaxSizeAlarm: {[ key: string ]: MaxMessageCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MaxMessageCountThreshold">MaxMessageCountThreshold</a>}

---

##### `addQueueMaxTimeToDrainMessagesAlarm`<sup>Optional</sup> <a name="addQueueMaxTimeToDrainMessagesAlarm" id="cdk-monitoring-constructs.BaseSqsQueueAlarms.property.addQueueMaxTimeToDrainMessagesAlarm"></a>

```typescript
public readonly addQueueMaxTimeToDrainMessagesAlarm: {[ key: string ]: MaxTimeToDrainThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MaxTimeToDrainThreshold">MaxTimeToDrainThreshold</a>}

---

##### `addQueueMinIncomingMessagesAlarm`<sup>Optional</sup> <a name="addQueueMinIncomingMessagesAlarm" id="cdk-monitoring-constructs.BaseSqsQueueAlarms.property.addQueueMinIncomingMessagesAlarm"></a>

```typescript
public readonly addQueueMinIncomingMessagesAlarm: {[ key: string ]: MinIncomingMessagesCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MinIncomingMessagesCountThreshold">MinIncomingMessagesCountThreshold</a>}

---

##### `addQueueMinSizeAlarm`<sup>Optional</sup> <a name="addQueueMinSizeAlarm" id="cdk-monitoring-constructs.BaseSqsQueueAlarms.property.addQueueMinSizeAlarm"></a>

```typescript
public readonly addQueueMinSizeAlarm: {[ key: string ]: MinMessageCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MinMessageCountThreshold">MinMessageCountThreshold</a>}

---

### BillingMonitoringOptions <a name="BillingMonitoringOptions" id="cdk-monitoring-constructs.BillingMonitoringOptions"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.BillingMonitoringOptions.Initializer"></a>

```typescript
import { BillingMonitoringOptions } from 'cdk-monitoring-constructs'

const billingMonitoringOptions: BillingMonitoringOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.BillingMonitoringOptions.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.BillingMonitoringOptions.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.BillingMonitoringOptions.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.BillingMonitoringOptions.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.BillingMonitoringOptions.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.BillingMonitoringOptions.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.BillingMonitoringOptions.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.BillingMonitoringOptions.property.addTotalCostAnomalyAlarm">addTotalCostAnomalyAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold">AnomalyDetectionThreshold</a>}</code> | *No description.* |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.BillingMonitoringOptions.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.BillingMonitoringOptions.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.BillingMonitoringOptions.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.BillingMonitoringOptions.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.BillingMonitoringOptions.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.BillingMonitoringOptions.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.BillingMonitoringOptions.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addTotalCostAnomalyAlarm`<sup>Optional</sup> <a name="addTotalCostAnomalyAlarm" id="cdk-monitoring-constructs.BillingMonitoringOptions.property.addTotalCostAnomalyAlarm"></a>

```typescript
public readonly addTotalCostAnomalyAlarm: {[ key: string ]: AnomalyDetectionThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold">AnomalyDetectionThreshold</a>}

---

### BillingMonitoringProps <a name="BillingMonitoringProps" id="cdk-monitoring-constructs.BillingMonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.BillingMonitoringProps.Initializer"></a>

```typescript
import { BillingMonitoringProps } from 'cdk-monitoring-constructs'

const billingMonitoringProps: BillingMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.BillingMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.BillingMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.BillingMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.BillingMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.BillingMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.BillingMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.BillingMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.BillingMonitoringProps.property.addTotalCostAnomalyAlarm">addTotalCostAnomalyAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold">AnomalyDetectionThreshold</a>}</code> | *No description.* |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.BillingMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.BillingMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.BillingMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.BillingMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.BillingMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.BillingMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.BillingMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addTotalCostAnomalyAlarm`<sup>Optional</sup> <a name="addTotalCostAnomalyAlarm" id="cdk-monitoring-constructs.BillingMonitoringProps.property.addTotalCostAnomalyAlarm"></a>

```typescript
public readonly addTotalCostAnomalyAlarm: {[ key: string ]: AnomalyDetectionThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold">AnomalyDetectionThreshold</a>}

---

### CertificateManagerMetricFactoryProps <a name="CertificateManagerMetricFactoryProps" id="cdk-monitoring-constructs.CertificateManagerMetricFactoryProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.CertificateManagerMetricFactoryProps.Initializer"></a>

```typescript
import { CertificateManagerMetricFactoryProps } from 'cdk-monitoring-constructs'

const certificateManagerMetricFactoryProps: CertificateManagerMetricFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.CertificateManagerMetricFactoryProps.property.certificate">certificate</a></code> | <code>aws-cdk-lib.aws_certificatemanager.ICertificate</code> | *No description.* |

---

##### `certificate`<sup>Required</sup> <a name="certificate" id="cdk-monitoring-constructs.CertificateManagerMetricFactoryProps.property.certificate"></a>

```typescript
public readonly certificate: ICertificate;
```

- *Type:* aws-cdk-lib.aws_certificatemanager.ICertificate

---

### CertificateManagerMonitoringOptions <a name="CertificateManagerMonitoringOptions" id="cdk-monitoring-constructs.CertificateManagerMonitoringOptions"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.CertificateManagerMonitoringOptions.Initializer"></a>

```typescript
import { CertificateManagerMonitoringOptions } from 'cdk-monitoring-constructs'

const certificateManagerMonitoringOptions: CertificateManagerMonitoringOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.CertificateManagerMonitoringOptions.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.CertificateManagerMonitoringOptions.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.CertificateManagerMonitoringOptions.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.CertificateManagerMonitoringOptions.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.CertificateManagerMonitoringOptions.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.CertificateManagerMonitoringOptions.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.CertificateManagerMonitoringOptions.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.CertificateManagerMonitoringOptions.property.addDaysToExpiryAlarm">addDaysToExpiryAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.DaysToExpiryThreshold">DaysToExpiryThreshold</a>}</code> | *No description.* |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.CertificateManagerMonitoringOptions.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.CertificateManagerMonitoringOptions.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.CertificateManagerMonitoringOptions.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.CertificateManagerMonitoringOptions.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.CertificateManagerMonitoringOptions.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.CertificateManagerMonitoringOptions.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.CertificateManagerMonitoringOptions.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addDaysToExpiryAlarm`<sup>Optional</sup> <a name="addDaysToExpiryAlarm" id="cdk-monitoring-constructs.CertificateManagerMonitoringOptions.property.addDaysToExpiryAlarm"></a>

```typescript
public readonly addDaysToExpiryAlarm: {[ key: string ]: DaysToExpiryThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.DaysToExpiryThreshold">DaysToExpiryThreshold</a>}

---

### CertificateManagerMonitoringProps <a name="CertificateManagerMonitoringProps" id="cdk-monitoring-constructs.CertificateManagerMonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.CertificateManagerMonitoringProps.Initializer"></a>

```typescript
import { CertificateManagerMonitoringProps } from 'cdk-monitoring-constructs'

const certificateManagerMonitoringProps: CertificateManagerMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.CertificateManagerMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.CertificateManagerMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.CertificateManagerMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.CertificateManagerMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.CertificateManagerMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.CertificateManagerMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.CertificateManagerMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.CertificateManagerMonitoringProps.property.addDaysToExpiryAlarm">addDaysToExpiryAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.DaysToExpiryThreshold">DaysToExpiryThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CertificateManagerMonitoringProps.property.certificate">certificate</a></code> | <code>aws-cdk-lib.aws_certificatemanager.ICertificate</code> | *No description.* |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.CertificateManagerMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.CertificateManagerMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.CertificateManagerMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.CertificateManagerMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.CertificateManagerMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.CertificateManagerMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.CertificateManagerMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addDaysToExpiryAlarm`<sup>Optional</sup> <a name="addDaysToExpiryAlarm" id="cdk-monitoring-constructs.CertificateManagerMonitoringProps.property.addDaysToExpiryAlarm"></a>

```typescript
public readonly addDaysToExpiryAlarm: {[ key: string ]: DaysToExpiryThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.DaysToExpiryThreshold">DaysToExpiryThreshold</a>}

---

##### `certificate`<sup>Required</sup> <a name="certificate" id="cdk-monitoring-constructs.CertificateManagerMonitoringProps.property.certificate"></a>

```typescript
public readonly certificate: ICertificate;
```

- *Type:* aws-cdk-lib.aws_certificatemanager.ICertificate

---

### CloudFrontDistributionMetricFactoryProps <a name="CloudFrontDistributionMetricFactoryProps" id="cdk-monitoring-constructs.CloudFrontDistributionMetricFactoryProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.CloudFrontDistributionMetricFactoryProps.Initializer"></a>

```typescript
import { CloudFrontDistributionMetricFactoryProps } from 'cdk-monitoring-constructs'

const cloudFrontDistributionMetricFactoryProps: CloudFrontDistributionMetricFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMetricFactoryProps.property.distribution">distribution</a></code> | <code>aws-cdk-lib.aws_cloudfront.IDistribution</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMetricFactoryProps.property.additionalMetricsEnabled">additionalMetricsEnabled</a></code> | <code>boolean</code> | Generate dashboard charts for additional CloudFront distribution metrics. |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMetricFactoryProps.property.fillTpsWithZeroes">fillTpsWithZeroes</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMetricFactoryProps.property.rateComputationMethod">rateComputationMethod</a></code> | <code><a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a></code> | *No description.* |

---

##### `distribution`<sup>Required</sup> <a name="distribution" id="cdk-monitoring-constructs.CloudFrontDistributionMetricFactoryProps.property.distribution"></a>

```typescript
public readonly distribution: IDistribution;
```

- *Type:* aws-cdk-lib.aws_cloudfront.IDistribution

---

##### `additionalMetricsEnabled`<sup>Optional</sup> <a name="additionalMetricsEnabled" id="cdk-monitoring-constructs.CloudFrontDistributionMetricFactoryProps.property.additionalMetricsEnabled"></a>

```typescript
public readonly additionalMetricsEnabled: boolean;
```

- *Type:* boolean
- *Default:* true

Generate dashboard charts for additional CloudFront distribution metrics.

To enable additional metrics on your CloudFront distribution, see
https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html#monitoring-console.distributions-additional

---

##### `fillTpsWithZeroes`<sup>Optional</sup> <a name="fillTpsWithZeroes" id="cdk-monitoring-constructs.CloudFrontDistributionMetricFactoryProps.property.fillTpsWithZeroes"></a>

```typescript
public readonly fillTpsWithZeroes: boolean;
```

- *Type:* boolean
- *Default:* true

---

##### `rateComputationMethod`<sup>Optional</sup> <a name="rateComputationMethod" id="cdk-monitoring-constructs.CloudFrontDistributionMetricFactoryProps.property.rateComputationMethod"></a>

```typescript
public readonly rateComputationMethod: RateComputationMethod;
```

- *Type:* <a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a>
- *Default:* average

---

### CloudFrontDistributionMonitoringOptions <a name="CloudFrontDistributionMonitoringOptions" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringOptions"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringOptions.Initializer"></a>

```typescript
import { CloudFrontDistributionMonitoringOptions } from 'cdk-monitoring-constructs'

const cloudFrontDistributionMonitoringOptions: CloudFrontDistributionMonitoringOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringOptions.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringOptions.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringOptions.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringOptions.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringOptions.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringOptions.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringOptions.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringOptions.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringOptions.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringOptions.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringOptions.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringOptions.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringOptions.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringOptions.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

### CloudFrontDistributionMonitoringProps <a name="CloudFrontDistributionMonitoringProps" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.Initializer"></a>

```typescript
import { CloudFrontDistributionMonitoringProps } from 'cdk-monitoring-constructs'

const cloudFrontDistributionMonitoringProps: CloudFrontDistributionMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.distribution">distribution</a></code> | <code>aws-cdk-lib.aws_cloudfront.IDistribution</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.additionalMetricsEnabled">additionalMetricsEnabled</a></code> | <code>boolean</code> | Generate dashboard charts for additional CloudFront distribution metrics. |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.fillTpsWithZeroes">fillTpsWithZeroes</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.rateComputationMethod">rateComputationMethod</a></code> | <code><a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.addError4xxRate">addError4xxRate</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.addFault5xxRate">addFault5xxRate</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.addHighTpsAlarm">addHighTpsAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HighTpsThreshold">HighTpsThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.addLowTpsAlarm">addLowTpsAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LowTpsThreshold">LowTpsThreshold</a>}</code> | *No description.* |

---

##### `distribution`<sup>Required</sup> <a name="distribution" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.distribution"></a>

```typescript
public readonly distribution: IDistribution;
```

- *Type:* aws-cdk-lib.aws_cloudfront.IDistribution

---

##### `additionalMetricsEnabled`<sup>Optional</sup> <a name="additionalMetricsEnabled" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.additionalMetricsEnabled"></a>

```typescript
public readonly additionalMetricsEnabled: boolean;
```

- *Type:* boolean
- *Default:* true

Generate dashboard charts for additional CloudFront distribution metrics.

To enable additional metrics on your CloudFront distribution, see
https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html#monitoring-console.distributions-additional

---

##### `fillTpsWithZeroes`<sup>Optional</sup> <a name="fillTpsWithZeroes" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.fillTpsWithZeroes"></a>

```typescript
public readonly fillTpsWithZeroes: boolean;
```

- *Type:* boolean
- *Default:* true

---

##### `rateComputationMethod`<sup>Optional</sup> <a name="rateComputationMethod" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.rateComputationMethod"></a>

```typescript
public readonly rateComputationMethod: RateComputationMethod;
```

- *Type:* <a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a>
- *Default:* average

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addError4xxRate`<sup>Optional</sup> <a name="addError4xxRate" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.addError4xxRate"></a>

```typescript
public readonly addError4xxRate: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

##### `addFault5xxRate`<sup>Optional</sup> <a name="addFault5xxRate" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.addFault5xxRate"></a>

```typescript
public readonly addFault5xxRate: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

##### `addHighTpsAlarm`<sup>Optional</sup> <a name="addHighTpsAlarm" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.addHighTpsAlarm"></a>

```typescript
public readonly addHighTpsAlarm: {[ key: string ]: HighTpsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HighTpsThreshold">HighTpsThreshold</a>}

---

##### `addLowTpsAlarm`<sup>Optional</sup> <a name="addLowTpsAlarm" id="cdk-monitoring-constructs.CloudFrontDistributionMonitoringProps.property.addLowTpsAlarm"></a>

```typescript
public readonly addLowTpsAlarm: {[ key: string ]: LowTpsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LowTpsThreshold">LowTpsThreshold</a>}

---

### CodeBuildProjectMetricFactoryProps <a name="CodeBuildProjectMetricFactoryProps" id="cdk-monitoring-constructs.CodeBuildProjectMetricFactoryProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.CodeBuildProjectMetricFactoryProps.Initializer"></a>

```typescript
import { CodeBuildProjectMetricFactoryProps } from 'cdk-monitoring-constructs'

const codeBuildProjectMetricFactoryProps: CodeBuildProjectMetricFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMetricFactoryProps.property.project">project</a></code> | <code>aws-cdk-lib.aws_codebuild.IProject</code> | *No description.* |

---

##### `project`<sup>Required</sup> <a name="project" id="cdk-monitoring-constructs.CodeBuildProjectMetricFactoryProps.property.project"></a>

```typescript
public readonly project: IProject;
```

- *Type:* aws-cdk-lib.aws_codebuild.IProject

---

### CodeBuildProjectMonitoringOptions <a name="CodeBuildProjectMonitoringOptions" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.Initializer"></a>

```typescript
import { CodeBuildProjectMonitoringOptions } from 'cdk-monitoring-constructs'

const codeBuildProjectMonitoringOptions: CodeBuildProjectMonitoringOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.addDurationP50Alarm">addDurationP50Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.addDurationP90Alarm">addDurationP90Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.addDurationP99Alarm">addDurationP99Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.addFailedBuildCountAlarm">addFailedBuildCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.addFailedBuildRateAlarm">addFailedBuildRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addDurationP50Alarm`<sup>Optional</sup> <a name="addDurationP50Alarm" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.addDurationP50Alarm"></a>

```typescript
public readonly addDurationP50Alarm: {[ key: string ]: DurationThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}

---

##### `addDurationP90Alarm`<sup>Optional</sup> <a name="addDurationP90Alarm" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.addDurationP90Alarm"></a>

```typescript
public readonly addDurationP90Alarm: {[ key: string ]: DurationThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}

---

##### `addDurationP99Alarm`<sup>Optional</sup> <a name="addDurationP99Alarm" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.addDurationP99Alarm"></a>

```typescript
public readonly addDurationP99Alarm: {[ key: string ]: DurationThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}

---

##### `addFailedBuildCountAlarm`<sup>Optional</sup> <a name="addFailedBuildCountAlarm" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.addFailedBuildCountAlarm"></a>

```typescript
public readonly addFailedBuildCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `addFailedBuildRateAlarm`<sup>Optional</sup> <a name="addFailedBuildRateAlarm" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringOptions.property.addFailedBuildRateAlarm"></a>

```typescript
public readonly addFailedBuildRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

### CodeBuildProjectMonitoringProps <a name="CodeBuildProjectMonitoringProps" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringProps"></a>

Monitoring props for CodeBuild projects.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.Initializer"></a>

```typescript
import { CodeBuildProjectMonitoringProps } from 'cdk-monitoring-constructs'

const codeBuildProjectMonitoringProps: CodeBuildProjectMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.project">project</a></code> | <code>aws-cdk-lib.aws_codebuild.IProject</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.addDurationP50Alarm">addDurationP50Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.addDurationP90Alarm">addDurationP90Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.addDurationP99Alarm">addDurationP99Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.addFailedBuildCountAlarm">addFailedBuildCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.addFailedBuildRateAlarm">addFailedBuildRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |

---

##### `project`<sup>Required</sup> <a name="project" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.project"></a>

```typescript
public readonly project: IProject;
```

- *Type:* aws-cdk-lib.aws_codebuild.IProject

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addDurationP50Alarm`<sup>Optional</sup> <a name="addDurationP50Alarm" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.addDurationP50Alarm"></a>

```typescript
public readonly addDurationP50Alarm: {[ key: string ]: DurationThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}

---

##### `addDurationP90Alarm`<sup>Optional</sup> <a name="addDurationP90Alarm" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.addDurationP90Alarm"></a>

```typescript
public readonly addDurationP90Alarm: {[ key: string ]: DurationThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}

---

##### `addDurationP99Alarm`<sup>Optional</sup> <a name="addDurationP99Alarm" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.addDurationP99Alarm"></a>

```typescript
public readonly addDurationP99Alarm: {[ key: string ]: DurationThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}

---

##### `addFailedBuildCountAlarm`<sup>Optional</sup> <a name="addFailedBuildCountAlarm" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.addFailedBuildCountAlarm"></a>

```typescript
public readonly addFailedBuildCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `addFailedBuildRateAlarm`<sup>Optional</sup> <a name="addFailedBuildRateAlarm" id="cdk-monitoring-constructs.CodeBuildProjectMonitoringProps.property.addFailedBuildRateAlarm"></a>

```typescript
public readonly addFailedBuildRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

### ConsumedCapacityThreshold <a name="ConsumedCapacityThreshold" id="cdk-monitoring-constructs.ConsumedCapacityThreshold"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.ConsumedCapacityThreshold.Initializer"></a>

```typescript
import { ConsumedCapacityThreshold } from 'cdk-monitoring-constructs'

const consumedCapacityThreshold: ConsumedCapacityThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold.property.maxConsumedCapacityUnits">maxConsumedCapacityUnits</a></code> | <code>number</code> | *No description.* |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.ConsumedCapacityThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.ConsumedCapacityThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.ConsumedCapacityThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.ConsumedCapacityThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.ConsumedCapacityThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.ConsumedCapacityThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.ConsumedCapacityThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.ConsumedCapacityThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.ConsumedCapacityThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.ConsumedCapacityThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.ConsumedCapacityThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.ConsumedCapacityThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.ConsumedCapacityThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.ConsumedCapacityThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, a composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
This composite alarm will be returned as a result and uses the specified alarm actions.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.ConsumedCapacityThreshold.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.ConsumedCapacityThreshold.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `treatMissingDataOverride`<sup>Optional</sup> <a name="treatMissingDataOverride" id="cdk-monitoring-constructs.ConsumedCapacityThreshold.property.treatMissingDataOverride"></a>

```typescript
public readonly treatMissingDataOverride: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData
- *Default:* alarm-specific default

Behaviour in case the metric data is missing.

---

##### `maxConsumedCapacityUnits`<sup>Required</sup> <a name="maxConsumedCapacityUnits" id="cdk-monitoring-constructs.ConsumedCapacityThreshold.property.maxConsumedCapacityUnits"></a>

```typescript
public readonly maxConsumedCapacityUnits: number;
```

- *Type:* number

---

### CustomAlarmThreshold <a name="CustomAlarmThreshold" id="cdk-monitoring-constructs.CustomAlarmThreshold"></a>

Common customization that can be attached to each alarm.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.CustomAlarmThreshold.Initializer"></a>

```typescript
import { CustomAlarmThreshold } from 'cdk-monitoring-constructs'

const customAlarmThreshold: CustomAlarmThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.CustomAlarmThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.CustomAlarmThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.CustomAlarmThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.CustomAlarmThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.CustomAlarmThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.CustomAlarmThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.CustomAlarmThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.CustomAlarmThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.CustomAlarmThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.CustomAlarmThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.CustomAlarmThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.CustomAlarmThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.CustomAlarmThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.CustomAlarmThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.CustomAlarmThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.CustomAlarmThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.CustomAlarmThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.CustomAlarmThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.CustomAlarmThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.CustomAlarmThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.CustomAlarmThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.CustomAlarmThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.CustomAlarmThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.CustomAlarmThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.CustomAlarmThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.CustomAlarmThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.CustomAlarmThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.CustomAlarmThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.CustomAlarmThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.CustomAlarmThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.CustomAlarmThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, a composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
This composite alarm will be returned as a result and uses the specified alarm actions.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.CustomAlarmThreshold.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.CustomAlarmThreshold.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `treatMissingDataOverride`<sup>Optional</sup> <a name="treatMissingDataOverride" id="cdk-monitoring-constructs.CustomAlarmThreshold.property.treatMissingDataOverride"></a>

```typescript
public readonly treatMissingDataOverride: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData
- *Default:* alarm-specific default

Behaviour in case the metric data is missing.

---

### CustomEc2ServiceMonitoringProps <a name="CustomEc2ServiceMonitoringProps" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.Initializer"></a>

```typescript
import { CustomEc2ServiceMonitoringProps } from 'cdk-monitoring-constructs'

const customEc2ServiceMonitoringProps: CustomEc2ServiceMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.addCpuUsageAlarm">addCpuUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.addMemoryUsageAlarm">addMemoryUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.addRunningTaskCountAlarm">addRunningTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}</code> | Container Insights needs to be enabled for the cluster for this alarm. |
| <code><a href="#cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.maxAutoScalingTaskCount">maxAutoScalingTaskCount</a></code> | <code>number</code> | maximum number of tasks, as specified in your auto scaling config. |
| <code><a href="#cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.minAutoScalingTaskCount">minAutoScalingTaskCount</a></code> | <code>number</code> | minimum number of tasks, as specified in your auto scaling config. |
| <code><a href="#cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.ec2Service">ec2Service</a></code> | <code>aws-cdk-lib.aws_ecs.Ec2Service</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.addHealthyTaskCountAlarm">addHealthyTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold">HealthyTaskCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.addHealthyTaskPercentAlarm">addHealthyTaskPercentAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold">HealthyTaskPercentThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.addMinProcessedBytesAlarm">addMinProcessedBytesAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MinProcessedBytesThreshold">MinProcessedBytesThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.addUnhealthyTaskCountAlarm">addUnhealthyTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UnhealthyTaskCountThreshold">UnhealthyTaskCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.loadBalancer">loadBalancer</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer \| aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.targetGroup">targetGroup</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup \| aws-cdk-lib.aws_elasticloadbalancingv2.NetworkTargetGroup</code> | *No description.* |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addCpuUsageAlarm`<sup>Optional</sup> <a name="addCpuUsageAlarm" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.addCpuUsageAlarm"></a>

```typescript
public readonly addCpuUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addMemoryUsageAlarm`<sup>Optional</sup> <a name="addMemoryUsageAlarm" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.addMemoryUsageAlarm"></a>

```typescript
public readonly addMemoryUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addRunningTaskCountAlarm`<sup>Optional</sup> <a name="addRunningTaskCountAlarm" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.addRunningTaskCountAlarm"></a>

```typescript
public readonly addRunningTaskCountAlarm: {[ key: string ]: RunningTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}

Container Insights needs to be enabled for the cluster for this alarm.

---

##### `maxAutoScalingTaskCount`<sup>Optional</sup> <a name="maxAutoScalingTaskCount" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.maxAutoScalingTaskCount"></a>

```typescript
public readonly maxAutoScalingTaskCount: number;
```

- *Type:* number

maximum number of tasks, as specified in your auto scaling config.

---

##### `minAutoScalingTaskCount`<sup>Optional</sup> <a name="minAutoScalingTaskCount" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.minAutoScalingTaskCount"></a>

```typescript
public readonly minAutoScalingTaskCount: number;
```

- *Type:* number

minimum number of tasks, as specified in your auto scaling config.

---

##### `ec2Service`<sup>Required</sup> <a name="ec2Service" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.ec2Service"></a>

```typescript
public readonly ec2Service: Ec2Service;
```

- *Type:* aws-cdk-lib.aws_ecs.Ec2Service

---

##### `addHealthyTaskCountAlarm`<sup>Optional</sup> <a name="addHealthyTaskCountAlarm" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.addHealthyTaskCountAlarm"></a>

```typescript
public readonly addHealthyTaskCountAlarm: {[ key: string ]: HealthyTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold">HealthyTaskCountThreshold</a>}

---

##### `addHealthyTaskPercentAlarm`<sup>Optional</sup> <a name="addHealthyTaskPercentAlarm" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.addHealthyTaskPercentAlarm"></a>

```typescript
public readonly addHealthyTaskPercentAlarm: {[ key: string ]: HealthyTaskPercentThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold">HealthyTaskPercentThreshold</a>}

---

##### `addMinProcessedBytesAlarm`<sup>Optional</sup> <a name="addMinProcessedBytesAlarm" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.addMinProcessedBytesAlarm"></a>

```typescript
public readonly addMinProcessedBytesAlarm: {[ key: string ]: MinProcessedBytesThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MinProcessedBytesThreshold">MinProcessedBytesThreshold</a>}

---

##### `addUnhealthyTaskCountAlarm`<sup>Optional</sup> <a name="addUnhealthyTaskCountAlarm" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.addUnhealthyTaskCountAlarm"></a>

```typescript
public readonly addUnhealthyTaskCountAlarm: {[ key: string ]: UnhealthyTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UnhealthyTaskCountThreshold">UnhealthyTaskCountThreshold</a>}

---

##### `loadBalancer`<sup>Optional</sup> <a name="loadBalancer" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.loadBalancer"></a>

```typescript
public readonly loadBalancer: ApplicationLoadBalancer | NetworkLoadBalancer;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer | aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer

---

##### `targetGroup`<sup>Optional</sup> <a name="targetGroup" id="cdk-monitoring-constructs.CustomEc2ServiceMonitoringProps.property.targetGroup"></a>

```typescript
public readonly targetGroup: ApplicationTargetGroup | NetworkTargetGroup;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup | aws-cdk-lib.aws_elasticloadbalancingv2.NetworkTargetGroup

---

### CustomFargateServiceMonitoringProps <a name="CustomFargateServiceMonitoringProps" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.Initializer"></a>

```typescript
import { CustomFargateServiceMonitoringProps } from 'cdk-monitoring-constructs'

const customFargateServiceMonitoringProps: CustomFargateServiceMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.addCpuUsageAlarm">addCpuUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.addMemoryUsageAlarm">addMemoryUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.addRunningTaskCountAlarm">addRunningTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}</code> | Container Insights needs to be enabled for the cluster for this alarm. |
| <code><a href="#cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.maxAutoScalingTaskCount">maxAutoScalingTaskCount</a></code> | <code>number</code> | maximum number of tasks, as specified in your auto scaling config. |
| <code><a href="#cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.minAutoScalingTaskCount">minAutoScalingTaskCount</a></code> | <code>number</code> | minimum number of tasks, as specified in your auto scaling config. |
| <code><a href="#cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.fargateService">fargateService</a></code> | <code>aws-cdk-lib.aws_ecs.FargateService</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.addHealthyTaskCountAlarm">addHealthyTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold">HealthyTaskCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.addHealthyTaskPercentAlarm">addHealthyTaskPercentAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold">HealthyTaskPercentThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.addMinProcessedBytesAlarm">addMinProcessedBytesAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MinProcessedBytesThreshold">MinProcessedBytesThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.addUnhealthyTaskCountAlarm">addUnhealthyTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UnhealthyTaskCountThreshold">UnhealthyTaskCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.loadBalancer">loadBalancer</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer \| aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.targetGroup">targetGroup</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup \| aws-cdk-lib.aws_elasticloadbalancingv2.NetworkTargetGroup</code> | *No description.* |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addCpuUsageAlarm`<sup>Optional</sup> <a name="addCpuUsageAlarm" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.addCpuUsageAlarm"></a>

```typescript
public readonly addCpuUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addMemoryUsageAlarm`<sup>Optional</sup> <a name="addMemoryUsageAlarm" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.addMemoryUsageAlarm"></a>

```typescript
public readonly addMemoryUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addRunningTaskCountAlarm`<sup>Optional</sup> <a name="addRunningTaskCountAlarm" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.addRunningTaskCountAlarm"></a>

```typescript
public readonly addRunningTaskCountAlarm: {[ key: string ]: RunningTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}

Container Insights needs to be enabled for the cluster for this alarm.

---

##### `maxAutoScalingTaskCount`<sup>Optional</sup> <a name="maxAutoScalingTaskCount" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.maxAutoScalingTaskCount"></a>

```typescript
public readonly maxAutoScalingTaskCount: number;
```

- *Type:* number

maximum number of tasks, as specified in your auto scaling config.

---

##### `minAutoScalingTaskCount`<sup>Optional</sup> <a name="minAutoScalingTaskCount" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.minAutoScalingTaskCount"></a>

```typescript
public readonly minAutoScalingTaskCount: number;
```

- *Type:* number

minimum number of tasks, as specified in your auto scaling config.

---

##### `fargateService`<sup>Required</sup> <a name="fargateService" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.fargateService"></a>

```typescript
public readonly fargateService: FargateService;
```

- *Type:* aws-cdk-lib.aws_ecs.FargateService

---

##### `addHealthyTaskCountAlarm`<sup>Optional</sup> <a name="addHealthyTaskCountAlarm" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.addHealthyTaskCountAlarm"></a>

```typescript
public readonly addHealthyTaskCountAlarm: {[ key: string ]: HealthyTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold">HealthyTaskCountThreshold</a>}

---

##### `addHealthyTaskPercentAlarm`<sup>Optional</sup> <a name="addHealthyTaskPercentAlarm" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.addHealthyTaskPercentAlarm"></a>

```typescript
public readonly addHealthyTaskPercentAlarm: {[ key: string ]: HealthyTaskPercentThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold">HealthyTaskPercentThreshold</a>}

---

##### `addMinProcessedBytesAlarm`<sup>Optional</sup> <a name="addMinProcessedBytesAlarm" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.addMinProcessedBytesAlarm"></a>

```typescript
public readonly addMinProcessedBytesAlarm: {[ key: string ]: MinProcessedBytesThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MinProcessedBytesThreshold">MinProcessedBytesThreshold</a>}

---

##### `addUnhealthyTaskCountAlarm`<sup>Optional</sup> <a name="addUnhealthyTaskCountAlarm" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.addUnhealthyTaskCountAlarm"></a>

```typescript
public readonly addUnhealthyTaskCountAlarm: {[ key: string ]: UnhealthyTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UnhealthyTaskCountThreshold">UnhealthyTaskCountThreshold</a>}

---

##### `loadBalancer`<sup>Optional</sup> <a name="loadBalancer" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.loadBalancer"></a>

```typescript
public readonly loadBalancer: ApplicationLoadBalancer | NetworkLoadBalancer;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer | aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer

---

##### `targetGroup`<sup>Optional</sup> <a name="targetGroup" id="cdk-monitoring-constructs.CustomFargateServiceMonitoringProps.property.targetGroup"></a>

```typescript
public readonly targetGroup: ApplicationTargetGroup | NetworkTargetGroup;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup | aws-cdk-lib.aws_elasticloadbalancingv2.NetworkTargetGroup

---

### CustomMetricGroup <a name="CustomMetricGroup" id="cdk-monitoring-constructs.CustomMetricGroup"></a>

Custom metric group represents a single widget.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.CustomMetricGroup.Initializer"></a>

```typescript
import { CustomMetricGroup } from 'cdk-monitoring-constructs'

const customMetricGroup: CustomMetricGroup = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.CustomMetricGroup.property.metrics">metrics</a></code> | <code>aws-cdk-lib.aws_cloudwatch.Metric \| aws-cdk-lib.aws_cloudwatch.MathExpression \| <a href="#cdk-monitoring-constructs.CustomMetricWithAlarm">CustomMetricWithAlarm</a> \| <a href="#cdk-monitoring-constructs.CustomMetricWithAnomalyDetection">CustomMetricWithAnomalyDetection</a> \| <a href="#cdk-monitoring-constructs.CustomMetricSearch">CustomMetricSearch</a>[]</code> | list of metrics in the group (can be defined in different ways, see the type documentation). |
| <code><a href="#cdk-monitoring-constructs.CustomMetricGroup.property.title">title</a></code> | <code>string</code> | title of the whole group. |
| <code><a href="#cdk-monitoring-constructs.CustomMetricGroup.property.graphWidgetAxis">graphWidgetAxis</a></code> | <code>aws-cdk-lib.aws_cloudwatch.YAxisProps</code> | optional axis. |
| <code><a href="#cdk-monitoring-constructs.CustomMetricGroup.property.graphWidgetLegend">graphWidgetLegend</a></code> | <code>aws-cdk-lib.aws_cloudwatch.LegendPosition</code> | graph widget legend. |
| <code><a href="#cdk-monitoring-constructs.CustomMetricGroup.property.graphWidgetRightAxis">graphWidgetRightAxis</a></code> | <code>aws-cdk-lib.aws_cloudwatch.YAxisProps</code> | optional right axis. |
| <code><a href="#cdk-monitoring-constructs.CustomMetricGroup.property.graphWidgetType">graphWidgetType</a></code> | <code><a href="#cdk-monitoring-constructs.GraphWidgetType">GraphWidgetType</a></code> | type of the widget. |
| <code><a href="#cdk-monitoring-constructs.CustomMetricGroup.property.horizontalAnnotations">horizontalAnnotations</a></code> | <code>aws-cdk-lib.aws_cloudwatch.HorizontalAnnotation[]</code> | optional custom horizontal annotations which will be displayed over the metrics on the left axis (if there are any alarms, any existing annotations will be merged together). |
| <code><a href="#cdk-monitoring-constructs.CustomMetricGroup.property.horizontalRightAnnotations">horizontalRightAnnotations</a></code> | <code>aws-cdk-lib.aws_cloudwatch.HorizontalAnnotation[]</code> | optional custom horizontal annotations which will be displayed over the metrics on the right axis (if there are any alarms, any existing annotations will be merged together). |
| <code><a href="#cdk-monitoring-constructs.CustomMetricGroup.property.important">important</a></code> | <code>boolean</code> | Flag indicating, whether this is an important metric group that should be included in the summary as well. |

---

##### `metrics`<sup>Required</sup> <a name="metrics" id="cdk-monitoring-constructs.CustomMetricGroup.property.metrics"></a>

```typescript
public readonly metrics: Metric | MathExpression | CustomMetricWithAlarm | CustomMetricWithAnomalyDetection | CustomMetricSearch[];
```

- *Type:* aws-cdk-lib.aws_cloudwatch.Metric | aws-cdk-lib.aws_cloudwatch.MathExpression | <a href="#cdk-monitoring-constructs.CustomMetricWithAlarm">CustomMetricWithAlarm</a> | <a href="#cdk-monitoring-constructs.CustomMetricWithAnomalyDetection">CustomMetricWithAnomalyDetection</a> | <a href="#cdk-monitoring-constructs.CustomMetricSearch">CustomMetricSearch</a>[]

list of metrics in the group (can be defined in different ways, see the type documentation).

---

##### `title`<sup>Required</sup> <a name="title" id="cdk-monitoring-constructs.CustomMetricGroup.property.title"></a>

```typescript
public readonly title: string;
```

- *Type:* string

title of the whole group.

---

##### `graphWidgetAxis`<sup>Optional</sup> <a name="graphWidgetAxis" id="cdk-monitoring-constructs.CustomMetricGroup.property.graphWidgetAxis"></a>

```typescript
public readonly graphWidgetAxis: YAxisProps;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.YAxisProps
- *Default:* undefined

optional axis.

---

##### `graphWidgetLegend`<sup>Optional</sup> <a name="graphWidgetLegend" id="cdk-monitoring-constructs.CustomMetricGroup.property.graphWidgetLegend"></a>

```typescript
public readonly graphWidgetLegend: LegendPosition;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.LegendPosition
- *Default:* BOTTOM

graph widget legend.

---

##### `graphWidgetRightAxis`<sup>Optional</sup> <a name="graphWidgetRightAxis" id="cdk-monitoring-constructs.CustomMetricGroup.property.graphWidgetRightAxis"></a>

```typescript
public readonly graphWidgetRightAxis: YAxisProps;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.YAxisProps
- *Default:* undefined

optional right axis.

---

##### `graphWidgetType`<sup>Optional</sup> <a name="graphWidgetType" id="cdk-monitoring-constructs.CustomMetricGroup.property.graphWidgetType"></a>

```typescript
public readonly graphWidgetType: GraphWidgetType;
```

- *Type:* <a href="#cdk-monitoring-constructs.GraphWidgetType">GraphWidgetType</a>
- *Default:* line

type of the widget.

---

##### `horizontalAnnotations`<sup>Optional</sup> <a name="horizontalAnnotations" id="cdk-monitoring-constructs.CustomMetricGroup.property.horizontalAnnotations"></a>

```typescript
public readonly horizontalAnnotations: HorizontalAnnotation[];
```

- *Type:* aws-cdk-lib.aws_cloudwatch.HorizontalAnnotation[]

optional custom horizontal annotations which will be displayed over the metrics on the left axis (if there are any alarms, any existing annotations will be merged together).

---

##### `horizontalRightAnnotations`<sup>Optional</sup> <a name="horizontalRightAnnotations" id="cdk-monitoring-constructs.CustomMetricGroup.property.horizontalRightAnnotations"></a>

```typescript
public readonly horizontalRightAnnotations: HorizontalAnnotation[];
```

- *Type:* aws-cdk-lib.aws_cloudwatch.HorizontalAnnotation[]

optional custom horizontal annotations which will be displayed over the metrics on the right axis (if there are any alarms, any existing annotations will be merged together).

---

##### `important`<sup>Optional</sup> <a name="important" id="cdk-monitoring-constructs.CustomMetricGroup.property.important"></a>

```typescript
public readonly important: boolean;
```

- *Type:* boolean
- *Default:* false

Flag indicating, whether this is an important metric group that should be included in the summary as well.

---

### CustomMetricGroupWithAnnotations <a name="CustomMetricGroupWithAnnotations" id="cdk-monitoring-constructs.CustomMetricGroupWithAnnotations"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.CustomMetricGroupWithAnnotations.Initializer"></a>

```typescript
import { CustomMetricGroupWithAnnotations } from 'cdk-monitoring-constructs'

const customMetricGroupWithAnnotations: CustomMetricGroupWithAnnotations = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.CustomMetricGroupWithAnnotations.property.annotations">annotations</a></code> | <code>aws-cdk-lib.aws_cloudwatch.HorizontalAnnotation[]</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomMetricGroupWithAnnotations.property.metricGroup">metricGroup</a></code> | <code><a href="#cdk-monitoring-constructs.CustomMetricGroup">CustomMetricGroup</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomMetricGroupWithAnnotations.property.rightAnnotations">rightAnnotations</a></code> | <code>aws-cdk-lib.aws_cloudwatch.HorizontalAnnotation[]</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomMetricGroupWithAnnotations.property.titleAddons">titleAddons</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomMetricGroupWithAnnotations.property.height">height</a></code> | <code>number</code> | *No description.* |

---

##### `annotations`<sup>Required</sup> <a name="annotations" id="cdk-monitoring-constructs.CustomMetricGroupWithAnnotations.property.annotations"></a>

```typescript
public readonly annotations: HorizontalAnnotation[];
```

- *Type:* aws-cdk-lib.aws_cloudwatch.HorizontalAnnotation[]

---

##### `metricGroup`<sup>Required</sup> <a name="metricGroup" id="cdk-monitoring-constructs.CustomMetricGroupWithAnnotations.property.metricGroup"></a>

```typescript
public readonly metricGroup: CustomMetricGroup;
```

- *Type:* <a href="#cdk-monitoring-constructs.CustomMetricGroup">CustomMetricGroup</a>

---

##### `rightAnnotations`<sup>Required</sup> <a name="rightAnnotations" id="cdk-monitoring-constructs.CustomMetricGroupWithAnnotations.property.rightAnnotations"></a>

```typescript
public readonly rightAnnotations: HorizontalAnnotation[];
```

- *Type:* aws-cdk-lib.aws_cloudwatch.HorizontalAnnotation[]

---

##### `titleAddons`<sup>Required</sup> <a name="titleAddons" id="cdk-monitoring-constructs.CustomMetricGroupWithAnnotations.property.titleAddons"></a>

```typescript
public readonly titleAddons: string[];
```

- *Type:* string[]

---

##### `height`<sup>Optional</sup> <a name="height" id="cdk-monitoring-constructs.CustomMetricGroupWithAnnotations.property.height"></a>

```typescript
public readonly height: number;
```

- *Type:* number

---

### CustomMetricSearch <a name="CustomMetricSearch" id="cdk-monitoring-constructs.CustomMetricSearch"></a>

Custom metric search.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.CustomMetricSearch.Initializer"></a>

```typescript
import { CustomMetricSearch } from 'cdk-monitoring-constructs'

const customMetricSearch: CustomMetricSearch = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.CustomMetricSearch.property.dimensionsMap">dimensionsMap</a></code> | <code>{[ key: string ]: string}</code> | search dimensions (can be empty). |
| <code><a href="#cdk-monitoring-constructs.CustomMetricSearch.property.searchQuery">searchQuery</a></code> | <code>string</code> | search query (can be empty). |
| <code><a href="#cdk-monitoring-constructs.CustomMetricSearch.property.statistic">statistic</a></code> | <code><a href="#cdk-monitoring-constructs.MetricStatistic">MetricStatistic</a></code> | metric statistic. |
| <code><a href="#cdk-monitoring-constructs.CustomMetricSearch.property.label">label</a></code> | <code>string</code> | custom label for the metrics. |
| <code><a href="#cdk-monitoring-constructs.CustomMetricSearch.property.namespace">namespace</a></code> | <code>string</code> | metric namespace. |
| <code><a href="#cdk-monitoring-constructs.CustomMetricSearch.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | metric period. |
| <code><a href="#cdk-monitoring-constructs.CustomMetricSearch.property.position">position</a></code> | <code><a href="#cdk-monitoring-constructs.AxisPosition">AxisPosition</a></code> | axis (right or left) on which to graph metric default: AxisPosition.LEFT. |

---

##### `dimensionsMap`<sup>Required</sup> <a name="dimensionsMap" id="cdk-monitoring-constructs.CustomMetricSearch.property.dimensionsMap"></a>

```typescript
public readonly dimensionsMap: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

search dimensions (can be empty).

---

##### `searchQuery`<sup>Required</sup> <a name="searchQuery" id="cdk-monitoring-constructs.CustomMetricSearch.property.searchQuery"></a>

```typescript
public readonly searchQuery: string;
```

- *Type:* string

search query (can be empty).

---

##### `statistic`<sup>Required</sup> <a name="statistic" id="cdk-monitoring-constructs.CustomMetricSearch.property.statistic"></a>

```typescript
public readonly statistic: MetricStatistic;
```

- *Type:* <a href="#cdk-monitoring-constructs.MetricStatistic">MetricStatistic</a>

metric statistic.

---

##### `label`<sup>Optional</sup> <a name="label" id="cdk-monitoring-constructs.CustomMetricSearch.property.label"></a>

```typescript
public readonly label: string;
```

- *Type:* string
- *Default:* " "

custom label for the metrics.

---

##### `namespace`<sup>Optional</sup> <a name="namespace" id="cdk-monitoring-constructs.CustomMetricSearch.property.namespace"></a>

```typescript
public readonly namespace: string;
```

- *Type:* string
- *Default:* none

metric namespace.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.CustomMetricSearch.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* global default

metric period.

---

##### `position`<sup>Optional</sup> <a name="position" id="cdk-monitoring-constructs.CustomMetricSearch.property.position"></a>

```typescript
public readonly position: AxisPosition;
```

- *Type:* <a href="#cdk-monitoring-constructs.AxisPosition">AxisPosition</a>

axis (right or left) on which to graph metric default: AxisPosition.LEFT.

---

### CustomMetricWithAlarm <a name="CustomMetricWithAlarm" id="cdk-monitoring-constructs.CustomMetricWithAlarm"></a>

Custom metric with an alarm defined.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.CustomMetricWithAlarm.Initializer"></a>

```typescript
import { CustomMetricWithAlarm } from 'cdk-monitoring-constructs'

const customMetricWithAlarm: CustomMetricWithAlarm = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.CustomMetricWithAlarm.property.addAlarm">addAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.CustomThreshold">CustomThreshold</a>}</code> | alarm definitions. |
| <code><a href="#cdk-monitoring-constructs.CustomMetricWithAlarm.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | alarm friendly name. |
| <code><a href="#cdk-monitoring-constructs.CustomMetricWithAlarm.property.metric">metric</a></code> | <code>aws-cdk-lib.aws_cloudwatch.Metric \| aws-cdk-lib.aws_cloudwatch.MathExpression</code> | metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.CustomMetricWithAlarm.property.position">position</a></code> | <code><a href="#cdk-monitoring-constructs.AxisPosition">AxisPosition</a></code> | axis (right or left) on which to graph metric default: AxisPosition.LEFT. |

---

##### `addAlarm`<sup>Required</sup> <a name="addAlarm" id="cdk-monitoring-constructs.CustomMetricWithAlarm.property.addAlarm"></a>

```typescript
public readonly addAlarm: {[ key: string ]: CustomThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.CustomThreshold">CustomThreshold</a>}

alarm definitions.

---

##### `alarmFriendlyName`<sup>Required</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.CustomMetricWithAlarm.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string

alarm friendly name.

---

##### `metric`<sup>Required</sup> <a name="metric" id="cdk-monitoring-constructs.CustomMetricWithAlarm.property.metric"></a>

```typescript
public readonly metric: Metric | MathExpression;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.Metric | aws-cdk-lib.aws_cloudwatch.MathExpression

metric to alarm on.

---

##### `position`<sup>Optional</sup> <a name="position" id="cdk-monitoring-constructs.CustomMetricWithAlarm.property.position"></a>

```typescript
public readonly position: AxisPosition;
```

- *Type:* <a href="#cdk-monitoring-constructs.AxisPosition">AxisPosition</a>

axis (right or left) on which to graph metric default: AxisPosition.LEFT.

---

### CustomMetricWithAnomalyDetection <a name="CustomMetricWithAnomalyDetection" id="cdk-monitoring-constructs.CustomMetricWithAnomalyDetection"></a>

Custom metric with anomaly detection.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.CustomMetricWithAnomalyDetection.Initializer"></a>

```typescript
import { CustomMetricWithAnomalyDetection } from 'cdk-monitoring-constructs'

const customMetricWithAnomalyDetection: CustomMetricWithAnomalyDetection = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.CustomMetricWithAnomalyDetection.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | alarm friendly name. |
| <code><a href="#cdk-monitoring-constructs.CustomMetricWithAnomalyDetection.property.anomalyDetectionStandardDeviationToRender">anomalyDetectionStandardDeviationToRender</a></code> | <code>number</code> | standard deviation for the anomaly detection to be rendered on the graph widget. |
| <code><a href="#cdk-monitoring-constructs.CustomMetricWithAnomalyDetection.property.metric">metric</a></code> | <code>aws-cdk-lib.aws_cloudwatch.Metric \| aws-cdk-lib.aws_cloudwatch.MathExpression</code> | metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.CustomMetricWithAnomalyDetection.property.addAlarmOnAnomaly">addAlarmOnAnomaly</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold">AnomalyDetectionThreshold</a>}</code> | adds alarm on a detected anomaly. |
| <code><a href="#cdk-monitoring-constructs.CustomMetricWithAnomalyDetection.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | anomaly detection period. |

---

##### `alarmFriendlyName`<sup>Required</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.CustomMetricWithAnomalyDetection.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string

alarm friendly name.

---

##### `anomalyDetectionStandardDeviationToRender`<sup>Required</sup> <a name="anomalyDetectionStandardDeviationToRender" id="cdk-monitoring-constructs.CustomMetricWithAnomalyDetection.property.anomalyDetectionStandardDeviationToRender"></a>

```typescript
public readonly anomalyDetectionStandardDeviationToRender: number;
```

- *Type:* number

standard deviation for the anomaly detection to be rendered on the graph widget.

---

##### `metric`<sup>Required</sup> <a name="metric" id="cdk-monitoring-constructs.CustomMetricWithAnomalyDetection.property.metric"></a>

```typescript
public readonly metric: Metric | MathExpression;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.Metric | aws-cdk-lib.aws_cloudwatch.MathExpression

metric to alarm on.

---

##### `addAlarmOnAnomaly`<sup>Optional</sup> <a name="addAlarmOnAnomaly" id="cdk-monitoring-constructs.CustomMetricWithAnomalyDetection.property.addAlarmOnAnomaly"></a>

```typescript
public readonly addAlarmOnAnomaly: {[ key: string ]: AnomalyDetectionThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.AnomalyDetectionThreshold">AnomalyDetectionThreshold</a>}

adds alarm on a detected anomaly.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.CustomMetricWithAnomalyDetection.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* metric period (if defined) or global default

anomaly detection period.

---

### CustomMonitoringProps <a name="CustomMonitoringProps" id="cdk-monitoring-constructs.CustomMonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.CustomMonitoringProps.Initializer"></a>

```typescript
import { CustomMonitoringProps } from 'cdk-monitoring-constructs'

const customMonitoringProps: CustomMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.CustomMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.CustomMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.CustomMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.CustomMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.CustomMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.CustomMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.CustomMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.CustomMonitoringProps.property.metricGroups">metricGroups</a></code> | <code><a href="#cdk-monitoring-constructs.CustomMetricGroup">CustomMetricGroup</a>[]</code> | define metric groups and metrics inside them (each metric group represents a widget). |
| <code><a href="#cdk-monitoring-constructs.CustomMonitoringProps.property.description">description</a></code> | <code>string</code> | optional description of the whole section, in markdown. |
| <code><a href="#cdk-monitoring-constructs.CustomMonitoringProps.property.descriptionWidgetHeight">descriptionWidgetHeight</a></code> | <code>number</code> | optional height of the description widget, so the content fits. |
| <code><a href="#cdk-monitoring-constructs.CustomMonitoringProps.property.height">height</a></code> | <code>number</code> | height override. |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.CustomMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.CustomMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.CustomMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.CustomMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.CustomMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.CustomMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.CustomMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `metricGroups`<sup>Required</sup> <a name="metricGroups" id="cdk-monitoring-constructs.CustomMonitoringProps.property.metricGroups"></a>

```typescript
public readonly metricGroups: CustomMetricGroup[];
```

- *Type:* <a href="#cdk-monitoring-constructs.CustomMetricGroup">CustomMetricGroup</a>[]

define metric groups and metrics inside them (each metric group represents a widget).

---

##### `description`<sup>Optional</sup> <a name="description" id="cdk-monitoring-constructs.CustomMonitoringProps.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string
- *Default:* no description

optional description of the whole section, in markdown.

---

##### `descriptionWidgetHeight`<sup>Optional</sup> <a name="descriptionWidgetHeight" id="cdk-monitoring-constructs.CustomMonitoringProps.property.descriptionWidgetHeight"></a>

```typescript
public readonly descriptionWidgetHeight: number;
```

- *Type:* number
- *Default:* minimum height (should fit one or two lines of text)

optional height of the description widget, so the content fits.

---

##### `height`<sup>Optional</sup> <a name="height" id="cdk-monitoring-constructs.CustomMonitoringProps.property.height"></a>

```typescript
public readonly height: number;
```

- *Type:* number
- *Default:* default height

height override.

---

### CustomThreshold <a name="CustomThreshold" id="cdk-monitoring-constructs.CustomThreshold"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.CustomThreshold.Initializer"></a>

```typescript
import { CustomThreshold } from 'cdk-monitoring-constructs'

const customThreshold: CustomThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.comparisonOperator">comparisonOperator</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.threshold">threshold</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.additionalDescription">additionalDescription</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.CustomThreshold.property.dedupeString">dedupeString</a></code> | <code>string</code> | *No description.* |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.CustomThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.CustomThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.CustomThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.CustomThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.CustomThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.CustomThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.CustomThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.CustomThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.CustomThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.CustomThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.CustomThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.CustomThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.CustomThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.CustomThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, a composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
This composite alarm will be returned as a result and uses the specified alarm actions.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.CustomThreshold.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.CustomThreshold.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `treatMissingDataOverride`<sup>Optional</sup> <a name="treatMissingDataOverride" id="cdk-monitoring-constructs.CustomThreshold.property.treatMissingDataOverride"></a>

```typescript
public readonly treatMissingDataOverride: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData
- *Default:* alarm-specific default

Behaviour in case the metric data is missing.

---

##### `comparisonOperator`<sup>Required</sup> <a name="comparisonOperator" id="cdk-monitoring-constructs.CustomThreshold.property.comparisonOperator"></a>

```typescript
public readonly comparisonOperator: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator

---

##### `threshold`<sup>Required</sup> <a name="threshold" id="cdk-monitoring-constructs.CustomThreshold.property.threshold"></a>

```typescript
public readonly threshold: number;
```

- *Type:* number

---

##### `additionalDescription`<sup>Optional</sup> <a name="additionalDescription" id="cdk-monitoring-constructs.CustomThreshold.property.additionalDescription"></a>

```typescript
public readonly additionalDescription: string;
```

- *Type:* string

---

##### `dedupeString`<sup>Optional</sup> <a name="dedupeString" id="cdk-monitoring-constructs.CustomThreshold.property.dedupeString"></a>

```typescript
public readonly dedupeString: string;
```

- *Type:* string

---

### CustomWidgetProps <a name="CustomWidgetProps" id="cdk-monitoring-constructs.CustomWidgetProps"></a>

Properties of a custom widget.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.CustomWidgetProps.Initializer"></a>

```typescript
import { CustomWidgetProps } from 'cdk-monitoring-constructs'

const customWidgetProps: CustomWidgetProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.CustomWidgetProps.property.handler">handler</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | Lambda providing the widget contents. |
| <code><a href="#cdk-monitoring-constructs.CustomWidgetProps.property.handlerParams">handlerParams</a></code> | <code>any</code> | Arguments to pass to the Lambda. |
| <code><a href="#cdk-monitoring-constructs.CustomWidgetProps.property.height">height</a></code> | <code>number</code> | Height of the widget. |
| <code><a href="#cdk-monitoring-constructs.CustomWidgetProps.property.title">title</a></code> | <code>string</code> | Title for the graph. |
| <code><a href="#cdk-monitoring-constructs.CustomWidgetProps.property.updateOnRefresh">updateOnRefresh</a></code> | <code>boolean</code> | Whether the widget should be updated (by calling the Lambda again) on refresh. |
| <code><a href="#cdk-monitoring-constructs.CustomWidgetProps.property.updateOnResize">updateOnResize</a></code> | <code>boolean</code> | Whether the widget should be updated (by calling the Lambda again) on resize. |
| <code><a href="#cdk-monitoring-constructs.CustomWidgetProps.property.updateOnTimeRangeChange">updateOnTimeRangeChange</a></code> | <code>boolean</code> | Whether the widget should be updated (by calling the Lambda again) on time range change. |
| <code><a href="#cdk-monitoring-constructs.CustomWidgetProps.property.width">width</a></code> | <code>number</code> | Width of the widget, in a grid of 24 units wide. |

---

##### `handler`<sup>Required</sup> <a name="handler" id="cdk-monitoring-constructs.CustomWidgetProps.property.handler"></a>

```typescript
public readonly handler: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

Lambda providing the widget contents.

The Lambda function should return HTML with widget code.
The simplest Lambda example:
```typescript
exports.handler = function (event, context, callback) {
   return callback(null, "<h1>Hello! This is a custom widget.</h1><pre>" + JSON.stringify(event, null, 2) + "</pre>");
};
```

---

##### `handlerParams`<sup>Optional</sup> <a name="handlerParams" id="cdk-monitoring-constructs.CustomWidgetProps.property.handlerParams"></a>

```typescript
public readonly handlerParams: any;
```

- *Type:* any

Arguments to pass to the Lambda.

These arguments will be available in the Lambda context.

---

##### `height`<sup>Optional</sup> <a name="height" id="cdk-monitoring-constructs.CustomWidgetProps.property.height"></a>

```typescript
public readonly height: number;
```

- *Type:* number
- *Default:* 6

Height of the widget.

---

##### `title`<sup>Optional</sup> <a name="title" id="cdk-monitoring-constructs.CustomWidgetProps.property.title"></a>

```typescript
public readonly title: string;
```

- *Type:* string

Title for the graph.

---

##### `updateOnRefresh`<sup>Optional</sup> <a name="updateOnRefresh" id="cdk-monitoring-constructs.CustomWidgetProps.property.updateOnRefresh"></a>

```typescript
public readonly updateOnRefresh: boolean;
```

- *Type:* boolean
- *Default:* true

Whether the widget should be updated (by calling the Lambda again) on refresh.

---

##### `updateOnResize`<sup>Optional</sup> <a name="updateOnResize" id="cdk-monitoring-constructs.CustomWidgetProps.property.updateOnResize"></a>

```typescript
public readonly updateOnResize: boolean;
```

- *Type:* boolean
- *Default:* true

Whether the widget should be updated (by calling the Lambda again) on resize.

---

##### `updateOnTimeRangeChange`<sup>Optional</sup> <a name="updateOnTimeRangeChange" id="cdk-monitoring-constructs.CustomWidgetProps.property.updateOnTimeRangeChange"></a>

```typescript
public readonly updateOnTimeRangeChange: boolean;
```

- *Type:* boolean
- *Default:* true

Whether the widget should be updated (by calling the Lambda again) on time range change.

---

##### `width`<sup>Optional</sup> <a name="width" id="cdk-monitoring-constructs.CustomWidgetProps.property.width"></a>

```typescript
public readonly width: number;
```

- *Type:* number
- *Default:* 6

Width of the widget, in a grid of 24 units wide.

---

### DaysSinceUpdateThreshold <a name="DaysSinceUpdateThreshold" id="cdk-monitoring-constructs.DaysSinceUpdateThreshold"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.DaysSinceUpdateThreshold.Initializer"></a>

```typescript
import { DaysSinceUpdateThreshold } from 'cdk-monitoring-constructs'

const daysSinceUpdateThreshold: DaysSinceUpdateThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.maxDaysSinceUpdate">maxDaysSinceUpdate</a></code> | <code>number</code> | *No description.* |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, a composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
This composite alarm will be returned as a result and uses the specified alarm actions.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `treatMissingDataOverride`<sup>Optional</sup> <a name="treatMissingDataOverride" id="cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.treatMissingDataOverride"></a>

```typescript
public readonly treatMissingDataOverride: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData
- *Default:* alarm-specific default

Behaviour in case the metric data is missing.

---

##### `maxDaysSinceUpdate`<sup>Required</sup> <a name="maxDaysSinceUpdate" id="cdk-monitoring-constructs.DaysSinceUpdateThreshold.property.maxDaysSinceUpdate"></a>

```typescript
public readonly maxDaysSinceUpdate: number;
```

- *Type:* number

---

### DaysToExpiryThreshold <a name="DaysToExpiryThreshold" id="cdk-monitoring-constructs.DaysToExpiryThreshold"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.DaysToExpiryThreshold.Initializer"></a>

```typescript
import { DaysToExpiryThreshold } from 'cdk-monitoring-constructs'

const daysToExpiryThreshold: DaysToExpiryThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.DaysToExpiryThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.DaysToExpiryThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.DaysToExpiryThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.DaysToExpiryThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.DaysToExpiryThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.DaysToExpiryThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.DaysToExpiryThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.DaysToExpiryThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.DaysToExpiryThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.DaysToExpiryThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.DaysToExpiryThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.DaysToExpiryThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.DaysToExpiryThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.DaysToExpiryThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.DaysToExpiryThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.DaysToExpiryThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.DaysToExpiryThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.DaysToExpiryThreshold.property.minDaysToExpiry">minDaysToExpiry</a></code> | <code>number</code> | *No description.* |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.DaysToExpiryThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.DaysToExpiryThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.DaysToExpiryThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.DaysToExpiryThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.DaysToExpiryThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.DaysToExpiryThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.DaysToExpiryThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.DaysToExpiryThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.DaysToExpiryThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.DaysToExpiryThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.DaysToExpiryThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.DaysToExpiryThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.DaysToExpiryThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.DaysToExpiryThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, a composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
This composite alarm will be returned as a result and uses the specified alarm actions.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.DaysToExpiryThreshold.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.DaysToExpiryThreshold.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `treatMissingDataOverride`<sup>Optional</sup> <a name="treatMissingDataOverride" id="cdk-monitoring-constructs.DaysToExpiryThreshold.property.treatMissingDataOverride"></a>

```typescript
public readonly treatMissingDataOverride: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData
- *Default:* alarm-specific default

Behaviour in case the metric data is missing.

---

##### `minDaysToExpiry`<sup>Required</sup> <a name="minDaysToExpiry" id="cdk-monitoring-constructs.DaysToExpiryThreshold.property.minDaysToExpiry"></a>

```typescript
public readonly minDaysToExpiry: number;
```

- *Type:* number

---

### DocumentDbMetricFactoryProps <a name="DocumentDbMetricFactoryProps" id="cdk-monitoring-constructs.DocumentDbMetricFactoryProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.DocumentDbMetricFactoryProps.Initializer"></a>

```typescript
import { DocumentDbMetricFactoryProps } from 'cdk-monitoring-constructs'

const documentDbMetricFactoryProps: DocumentDbMetricFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.DocumentDbMetricFactoryProps.property.cluster">cluster</a></code> | <code>aws-cdk-lib.aws_docdb.IDatabaseCluster</code> | database cluster. |

---

##### `cluster`<sup>Required</sup> <a name="cluster" id="cdk-monitoring-constructs.DocumentDbMetricFactoryProps.property.cluster"></a>

```typescript
public readonly cluster: IDatabaseCluster;
```

- *Type:* aws-cdk-lib.aws_docdb.IDatabaseCluster

database cluster.

---

### DocumentDbMonitoringOptions <a name="DocumentDbMonitoringOptions" id="cdk-monitoring-constructs.DocumentDbMonitoringOptions"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.DocumentDbMonitoringOptions.Initializer"></a>

```typescript
import { DocumentDbMonitoringOptions } from 'cdk-monitoring-constructs'

const documentDbMonitoringOptions: DocumentDbMonitoringOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.DocumentDbMonitoringOptions.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.DocumentDbMonitoringOptions.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.DocumentDbMonitoringOptions.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.DocumentDbMonitoringOptions.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.DocumentDbMonitoringOptions.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.DocumentDbMonitoringOptions.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.DocumentDbMonitoringOptions.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.DocumentDbMonitoringOptions.property.addCpuUsageAlarm">addCpuUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.DocumentDbMonitoringOptions.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.DocumentDbMonitoringOptions.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.DocumentDbMonitoringOptions.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.DocumentDbMonitoringOptions.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.DocumentDbMonitoringOptions.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.DocumentDbMonitoringOptions.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.DocumentDbMonitoringOptions.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addCpuUsageAlarm`<sup>Optional</sup> <a name="addCpuUsageAlarm" id="cdk-monitoring-constructs.DocumentDbMonitoringOptions.property.addCpuUsageAlarm"></a>

```typescript
public readonly addCpuUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

### DocumentDbMonitoringProps <a name="DocumentDbMonitoringProps" id="cdk-monitoring-constructs.DocumentDbMonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.DocumentDbMonitoringProps.Initializer"></a>

```typescript
import { DocumentDbMonitoringProps } from 'cdk-monitoring-constructs'

const documentDbMonitoringProps: DocumentDbMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.DocumentDbMonitoringProps.property.cluster">cluster</a></code> | <code>aws-cdk-lib.aws_docdb.IDatabaseCluster</code> | database cluster. |
| <code><a href="#cdk-monitoring-constructs.DocumentDbMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.DocumentDbMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.DocumentDbMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.DocumentDbMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.DocumentDbMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.DocumentDbMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.DocumentDbMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.DocumentDbMonitoringProps.property.addCpuUsageAlarm">addCpuUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |

---

##### `cluster`<sup>Required</sup> <a name="cluster" id="cdk-monitoring-constructs.DocumentDbMonitoringProps.property.cluster"></a>

```typescript
public readonly cluster: IDatabaseCluster;
```

- *Type:* aws-cdk-lib.aws_docdb.IDatabaseCluster

database cluster.

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.DocumentDbMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.DocumentDbMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.DocumentDbMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.DocumentDbMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.DocumentDbMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.DocumentDbMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.DocumentDbMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addCpuUsageAlarm`<sup>Optional</sup> <a name="addCpuUsageAlarm" id="cdk-monitoring-constructs.DocumentDbMonitoringProps.property.addCpuUsageAlarm"></a>

```typescript
public readonly addCpuUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

### DoubleAxisGraphWidgetProps <a name="DoubleAxisGraphWidgetProps" id="cdk-monitoring-constructs.DoubleAxisGraphWidgetProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.DoubleAxisGraphWidgetProps.Initializer"></a>

```typescript
import { DoubleAxisGraphWidgetProps } from 'cdk-monitoring-constructs'

const doubleAxisGraphWidgetProps: DoubleAxisGraphWidgetProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.DoubleAxisGraphWidgetProps.property.height">height</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DoubleAxisGraphWidgetProps.property.leftAxis">leftAxis</a></code> | <code>aws-cdk-lib.aws_cloudwatch.YAxisProps</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DoubleAxisGraphWidgetProps.property.leftMetrics">leftMetrics</a></code> | <code>aws-cdk-lib.aws_cloudwatch.IMetric[]</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DoubleAxisGraphWidgetProps.property.rightAxis">rightAxis</a></code> | <code>aws-cdk-lib.aws_cloudwatch.YAxisProps</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DoubleAxisGraphWidgetProps.property.rightMetrics">rightMetrics</a></code> | <code>aws-cdk-lib.aws_cloudwatch.IMetric[]</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DoubleAxisGraphWidgetProps.property.width">width</a></code> | <code>number</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DoubleAxisGraphWidgetProps.property.leftAnnotations">leftAnnotations</a></code> | <code>aws-cdk-lib.aws_cloudwatch.HorizontalAnnotation[]</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DoubleAxisGraphWidgetProps.property.rightAnnotations">rightAnnotations</a></code> | <code>aws-cdk-lib.aws_cloudwatch.HorizontalAnnotation[]</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DoubleAxisGraphWidgetProps.property.title">title</a></code> | <code>string</code> | *No description.* |

---

##### `height`<sup>Required</sup> <a name="height" id="cdk-monitoring-constructs.DoubleAxisGraphWidgetProps.property.height"></a>

```typescript
public readonly height: number;
```

- *Type:* number

---

##### `leftAxis`<sup>Required</sup> <a name="leftAxis" id="cdk-monitoring-constructs.DoubleAxisGraphWidgetProps.property.leftAxis"></a>

```typescript
public readonly leftAxis: YAxisProps;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.YAxisProps

---

##### `leftMetrics`<sup>Required</sup> <a name="leftMetrics" id="cdk-monitoring-constructs.DoubleAxisGraphWidgetProps.property.leftMetrics"></a>

```typescript
public readonly leftMetrics: IMetric[];
```

- *Type:* aws-cdk-lib.aws_cloudwatch.IMetric[]

---

##### `rightAxis`<sup>Required</sup> <a name="rightAxis" id="cdk-monitoring-constructs.DoubleAxisGraphWidgetProps.property.rightAxis"></a>

```typescript
public readonly rightAxis: YAxisProps;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.YAxisProps

---

##### `rightMetrics`<sup>Required</sup> <a name="rightMetrics" id="cdk-monitoring-constructs.DoubleAxisGraphWidgetProps.property.rightMetrics"></a>

```typescript
public readonly rightMetrics: IMetric[];
```

- *Type:* aws-cdk-lib.aws_cloudwatch.IMetric[]

---

##### `width`<sup>Required</sup> <a name="width" id="cdk-monitoring-constructs.DoubleAxisGraphWidgetProps.property.width"></a>

```typescript
public readonly width: number;
```

- *Type:* number

---

##### `leftAnnotations`<sup>Optional</sup> <a name="leftAnnotations" id="cdk-monitoring-constructs.DoubleAxisGraphWidgetProps.property.leftAnnotations"></a>

```typescript
public readonly leftAnnotations: HorizontalAnnotation[];
```

- *Type:* aws-cdk-lib.aws_cloudwatch.HorizontalAnnotation[]

---

##### `rightAnnotations`<sup>Optional</sup> <a name="rightAnnotations" id="cdk-monitoring-constructs.DoubleAxisGraphWidgetProps.property.rightAnnotations"></a>

```typescript
public readonly rightAnnotations: HorizontalAnnotation[];
```

- *Type:* aws-cdk-lib.aws_cloudwatch.HorizontalAnnotation[]

---

##### `title`<sup>Optional</sup> <a name="title" id="cdk-monitoring-constructs.DoubleAxisGraphWidgetProps.property.title"></a>

```typescript
public readonly title: string;
```

- *Type:* string

---

### DurationThreshold <a name="DurationThreshold" id="cdk-monitoring-constructs.DurationThreshold"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.DurationThreshold.Initializer"></a>

```typescript
import { DurationThreshold } from 'cdk-monitoring-constructs'

const durationThreshold: DurationThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.DurationThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.DurationThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.DurationThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.DurationThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.DurationThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.DurationThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.DurationThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.DurationThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.DurationThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.DurationThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.DurationThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.DurationThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.DurationThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.DurationThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.DurationThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.DurationThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.DurationThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.DurationThreshold.property.maxDuration">maxDuration</a></code> | <code>aws-cdk-lib.Duration</code> | *No description.* |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.DurationThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.DurationThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.DurationThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.DurationThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.DurationThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.DurationThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.DurationThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.DurationThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.DurationThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.DurationThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.DurationThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.DurationThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.DurationThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.DurationThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, a composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
This composite alarm will be returned as a result and uses the specified alarm actions.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.DurationThreshold.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.DurationThreshold.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `treatMissingDataOverride`<sup>Optional</sup> <a name="treatMissingDataOverride" id="cdk-monitoring-constructs.DurationThreshold.property.treatMissingDataOverride"></a>

```typescript
public readonly treatMissingDataOverride: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData
- *Default:* alarm-specific default

Behaviour in case the metric data is missing.

---

##### `maxDuration`<sup>Required</sup> <a name="maxDuration" id="cdk-monitoring-constructs.DurationThreshold.property.maxDuration"></a>

```typescript
public readonly maxDuration: Duration;
```

- *Type:* aws-cdk-lib.Duration

---

### DynamoTableGlobalSecondaryIndexMetricFactoryProps <a name="DynamoTableGlobalSecondaryIndexMetricFactoryProps" id="cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMetricFactoryProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMetricFactoryProps.Initializer"></a>

```typescript
import { DynamoTableGlobalSecondaryIndexMetricFactoryProps } from 'cdk-monitoring-constructs'

const dynamoTableGlobalSecondaryIndexMetricFactoryProps: DynamoTableGlobalSecondaryIndexMetricFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMetricFactoryProps.property.globalSecondaryIndexName">globalSecondaryIndexName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMetricFactoryProps.property.table">table</a></code> | <code>aws-cdk-lib.aws_dynamodb.ITable</code> | *No description.* |

---

##### `globalSecondaryIndexName`<sup>Required</sup> <a name="globalSecondaryIndexName" id="cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMetricFactoryProps.property.globalSecondaryIndexName"></a>

```typescript
public readonly globalSecondaryIndexName: string;
```

- *Type:* string

---

##### `table`<sup>Required</sup> <a name="table" id="cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMetricFactoryProps.property.table"></a>

```typescript
public readonly table: ITable;
```

- *Type:* aws-cdk-lib.aws_dynamodb.ITable

---

### DynamoTableGlobalSecondaryIndexMonitoringProps <a name="DynamoTableGlobalSecondaryIndexMonitoringProps" id="cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps.Initializer"></a>

```typescript
import { DynamoTableGlobalSecondaryIndexMonitoringProps } from 'cdk-monitoring-constructs'

const dynamoTableGlobalSecondaryIndexMonitoringProps: DynamoTableGlobalSecondaryIndexMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps.property.globalSecondaryIndexName">globalSecondaryIndexName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps.property.table">table</a></code> | <code>aws-cdk-lib.aws_dynamodb.ITable</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |

---

##### `globalSecondaryIndexName`<sup>Required</sup> <a name="globalSecondaryIndexName" id="cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps.property.globalSecondaryIndexName"></a>

```typescript
public readonly globalSecondaryIndexName: string;
```

- *Type:* string

---

##### `table`<sup>Required</sup> <a name="table" id="cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps.property.table"></a>

```typescript
public readonly table: ITable;
```

- *Type:* aws-cdk-lib.aws_dynamodb.ITable

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

### DynamoTableMetricFactoryProps <a name="DynamoTableMetricFactoryProps" id="cdk-monitoring-constructs.DynamoTableMetricFactoryProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.DynamoTableMetricFactoryProps.Initializer"></a>

```typescript
import { DynamoTableMetricFactoryProps } from 'cdk-monitoring-constructs'

const dynamoTableMetricFactoryProps: DynamoTableMetricFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMetricFactoryProps.property.table">table</a></code> | <code>aws-cdk-lib.aws_dynamodb.ITable</code> | table to monitor. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMetricFactoryProps.property.billingMode">billingMode</a></code> | <code>aws-cdk-lib.aws_dynamodb.BillingMode</code> | table billing mode. |

---

##### `table`<sup>Required</sup> <a name="table" id="cdk-monitoring-constructs.DynamoTableMetricFactoryProps.property.table"></a>

```typescript
public readonly table: ITable;
```

- *Type:* aws-cdk-lib.aws_dynamodb.ITable

table to monitor.

---

##### `billingMode`<sup>Optional</sup> <a name="billingMode" id="cdk-monitoring-constructs.DynamoTableMetricFactoryProps.property.billingMode"></a>

```typescript
public readonly billingMode: BillingMode;
```

- *Type:* aws-cdk-lib.aws_dynamodb.BillingMode
- *Default:* best effort auto-detection or PROVISIONED as a fallback

table billing mode.

---

### DynamoTableMonitoringOptions <a name="DynamoTableMonitoringOptions" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.Initializer"></a>

```typescript
import { DynamoTableMonitoringOptions } from 'cdk-monitoring-constructs'

const dynamoTableMonitoringOptions: DynamoTableMonitoringOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addAverageSuccessfulBatchGetItemLatencyAlarm">addAverageSuccessfulBatchGetItemLatencyAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addAverageSuccessfulBatchWriteItemLatencyAlarm">addAverageSuccessfulBatchWriteItemLatencyAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addAverageSuccessfulDeleteItemLatencyAlarm">addAverageSuccessfulDeleteItemLatencyAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addAverageSuccessfulGetItemLatencyAlarm">addAverageSuccessfulGetItemLatencyAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addAverageSuccessfulGetRecordsLatencyAlarm">addAverageSuccessfulGetRecordsLatencyAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addAverageSuccessfulPutItemLatencyAlarm">addAverageSuccessfulPutItemLatencyAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addAverageSuccessfulQueryLatencyAlarm">addAverageSuccessfulQueryLatencyAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addAverageSuccessfulScanLatencyAlarm">addAverageSuccessfulScanLatencyAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addAverageSuccessfulUpdateItemLatencyAlarm">addAverageSuccessfulUpdateItemLatencyAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addConsumedReadCapacityAlarm">addConsumedReadCapacityAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold">ConsumedCapacityThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addConsumedWriteCapacityAlarm">addConsumedWriteCapacityAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold">ConsumedCapacityThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addReadThrottledEventsCountAlarm">addReadThrottledEventsCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ThrottledEventsThreshold">ThrottledEventsThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addSystemErrorCountAlarm">addSystemErrorCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addWriteThrottledEventsCountAlarm">addWriteThrottledEventsCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ThrottledEventsThreshold">ThrottledEventsThreshold</a>}</code> | *No description.* |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addAverageSuccessfulBatchGetItemLatencyAlarm`<sup>Optional</sup> <a name="addAverageSuccessfulBatchGetItemLatencyAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addAverageSuccessfulBatchGetItemLatencyAlarm"></a>

```typescript
public readonly addAverageSuccessfulBatchGetItemLatencyAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addAverageSuccessfulBatchWriteItemLatencyAlarm`<sup>Optional</sup> <a name="addAverageSuccessfulBatchWriteItemLatencyAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addAverageSuccessfulBatchWriteItemLatencyAlarm"></a>

```typescript
public readonly addAverageSuccessfulBatchWriteItemLatencyAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addAverageSuccessfulDeleteItemLatencyAlarm`<sup>Optional</sup> <a name="addAverageSuccessfulDeleteItemLatencyAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addAverageSuccessfulDeleteItemLatencyAlarm"></a>

```typescript
public readonly addAverageSuccessfulDeleteItemLatencyAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addAverageSuccessfulGetItemLatencyAlarm`<sup>Optional</sup> <a name="addAverageSuccessfulGetItemLatencyAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addAverageSuccessfulGetItemLatencyAlarm"></a>

```typescript
public readonly addAverageSuccessfulGetItemLatencyAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addAverageSuccessfulGetRecordsLatencyAlarm`<sup>Optional</sup> <a name="addAverageSuccessfulGetRecordsLatencyAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addAverageSuccessfulGetRecordsLatencyAlarm"></a>

```typescript
public readonly addAverageSuccessfulGetRecordsLatencyAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addAverageSuccessfulPutItemLatencyAlarm`<sup>Optional</sup> <a name="addAverageSuccessfulPutItemLatencyAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addAverageSuccessfulPutItemLatencyAlarm"></a>

```typescript
public readonly addAverageSuccessfulPutItemLatencyAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addAverageSuccessfulQueryLatencyAlarm`<sup>Optional</sup> <a name="addAverageSuccessfulQueryLatencyAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addAverageSuccessfulQueryLatencyAlarm"></a>

```typescript
public readonly addAverageSuccessfulQueryLatencyAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addAverageSuccessfulScanLatencyAlarm`<sup>Optional</sup> <a name="addAverageSuccessfulScanLatencyAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addAverageSuccessfulScanLatencyAlarm"></a>

```typescript
public readonly addAverageSuccessfulScanLatencyAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addAverageSuccessfulUpdateItemLatencyAlarm`<sup>Optional</sup> <a name="addAverageSuccessfulUpdateItemLatencyAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addAverageSuccessfulUpdateItemLatencyAlarm"></a>

```typescript
public readonly addAverageSuccessfulUpdateItemLatencyAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addConsumedReadCapacityAlarm`<sup>Optional</sup> <a name="addConsumedReadCapacityAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addConsumedReadCapacityAlarm"></a>

```typescript
public readonly addConsumedReadCapacityAlarm: {[ key: string ]: ConsumedCapacityThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold">ConsumedCapacityThreshold</a>}

---

##### `addConsumedWriteCapacityAlarm`<sup>Optional</sup> <a name="addConsumedWriteCapacityAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addConsumedWriteCapacityAlarm"></a>

```typescript
public readonly addConsumedWriteCapacityAlarm: {[ key: string ]: ConsumedCapacityThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold">ConsumedCapacityThreshold</a>}

---

##### `addReadThrottledEventsCountAlarm`<sup>Optional</sup> <a name="addReadThrottledEventsCountAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addReadThrottledEventsCountAlarm"></a>

```typescript
public readonly addReadThrottledEventsCountAlarm: {[ key: string ]: ThrottledEventsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ThrottledEventsThreshold">ThrottledEventsThreshold</a>}

---

##### `addSystemErrorCountAlarm`<sup>Optional</sup> <a name="addSystemErrorCountAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addSystemErrorCountAlarm"></a>

```typescript
public readonly addSystemErrorCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `addWriteThrottledEventsCountAlarm`<sup>Optional</sup> <a name="addWriteThrottledEventsCountAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringOptions.property.addWriteThrottledEventsCountAlarm"></a>

```typescript
public readonly addWriteThrottledEventsCountAlarm: {[ key: string ]: ThrottledEventsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ThrottledEventsThreshold">ThrottledEventsThreshold</a>}

---

### DynamoTableMonitoringProps <a name="DynamoTableMonitoringProps" id="cdk-monitoring-constructs.DynamoTableMonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.Initializer"></a>

```typescript
import { DynamoTableMonitoringProps } from 'cdk-monitoring-constructs'

const dynamoTableMonitoringProps: DynamoTableMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.table">table</a></code> | <code>aws-cdk-lib.aws_dynamodb.ITable</code> | table to monitor. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.billingMode">billingMode</a></code> | <code>aws-cdk-lib.aws_dynamodb.BillingMode</code> | table billing mode. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addAverageSuccessfulBatchGetItemLatencyAlarm">addAverageSuccessfulBatchGetItemLatencyAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addAverageSuccessfulBatchWriteItemLatencyAlarm">addAverageSuccessfulBatchWriteItemLatencyAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addAverageSuccessfulDeleteItemLatencyAlarm">addAverageSuccessfulDeleteItemLatencyAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addAverageSuccessfulGetItemLatencyAlarm">addAverageSuccessfulGetItemLatencyAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addAverageSuccessfulGetRecordsLatencyAlarm">addAverageSuccessfulGetRecordsLatencyAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addAverageSuccessfulPutItemLatencyAlarm">addAverageSuccessfulPutItemLatencyAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addAverageSuccessfulQueryLatencyAlarm">addAverageSuccessfulQueryLatencyAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addAverageSuccessfulScanLatencyAlarm">addAverageSuccessfulScanLatencyAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addAverageSuccessfulUpdateItemLatencyAlarm">addAverageSuccessfulUpdateItemLatencyAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addConsumedReadCapacityAlarm">addConsumedReadCapacityAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold">ConsumedCapacityThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addConsumedWriteCapacityAlarm">addConsumedWriteCapacityAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold">ConsumedCapacityThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addReadThrottledEventsCountAlarm">addReadThrottledEventsCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ThrottledEventsThreshold">ThrottledEventsThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addSystemErrorCountAlarm">addSystemErrorCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addWriteThrottledEventsCountAlarm">addWriteThrottledEventsCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ThrottledEventsThreshold">ThrottledEventsThreshold</a>}</code> | *No description.* |

---

##### `table`<sup>Required</sup> <a name="table" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.table"></a>

```typescript
public readonly table: ITable;
```

- *Type:* aws-cdk-lib.aws_dynamodb.ITable

table to monitor.

---

##### `billingMode`<sup>Optional</sup> <a name="billingMode" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.billingMode"></a>

```typescript
public readonly billingMode: BillingMode;
```

- *Type:* aws-cdk-lib.aws_dynamodb.BillingMode
- *Default:* best effort auto-detection or PROVISIONED as a fallback

table billing mode.

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addAverageSuccessfulBatchGetItemLatencyAlarm`<sup>Optional</sup> <a name="addAverageSuccessfulBatchGetItemLatencyAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addAverageSuccessfulBatchGetItemLatencyAlarm"></a>

```typescript
public readonly addAverageSuccessfulBatchGetItemLatencyAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addAverageSuccessfulBatchWriteItemLatencyAlarm`<sup>Optional</sup> <a name="addAverageSuccessfulBatchWriteItemLatencyAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addAverageSuccessfulBatchWriteItemLatencyAlarm"></a>

```typescript
public readonly addAverageSuccessfulBatchWriteItemLatencyAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addAverageSuccessfulDeleteItemLatencyAlarm`<sup>Optional</sup> <a name="addAverageSuccessfulDeleteItemLatencyAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addAverageSuccessfulDeleteItemLatencyAlarm"></a>

```typescript
public readonly addAverageSuccessfulDeleteItemLatencyAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addAverageSuccessfulGetItemLatencyAlarm`<sup>Optional</sup> <a name="addAverageSuccessfulGetItemLatencyAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addAverageSuccessfulGetItemLatencyAlarm"></a>

```typescript
public readonly addAverageSuccessfulGetItemLatencyAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addAverageSuccessfulGetRecordsLatencyAlarm`<sup>Optional</sup> <a name="addAverageSuccessfulGetRecordsLatencyAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addAverageSuccessfulGetRecordsLatencyAlarm"></a>

```typescript
public readonly addAverageSuccessfulGetRecordsLatencyAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addAverageSuccessfulPutItemLatencyAlarm`<sup>Optional</sup> <a name="addAverageSuccessfulPutItemLatencyAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addAverageSuccessfulPutItemLatencyAlarm"></a>

```typescript
public readonly addAverageSuccessfulPutItemLatencyAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addAverageSuccessfulQueryLatencyAlarm`<sup>Optional</sup> <a name="addAverageSuccessfulQueryLatencyAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addAverageSuccessfulQueryLatencyAlarm"></a>

```typescript
public readonly addAverageSuccessfulQueryLatencyAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addAverageSuccessfulScanLatencyAlarm`<sup>Optional</sup> <a name="addAverageSuccessfulScanLatencyAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addAverageSuccessfulScanLatencyAlarm"></a>

```typescript
public readonly addAverageSuccessfulScanLatencyAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addAverageSuccessfulUpdateItemLatencyAlarm`<sup>Optional</sup> <a name="addAverageSuccessfulUpdateItemLatencyAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addAverageSuccessfulUpdateItemLatencyAlarm"></a>

```typescript
public readonly addAverageSuccessfulUpdateItemLatencyAlarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addConsumedReadCapacityAlarm`<sup>Optional</sup> <a name="addConsumedReadCapacityAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addConsumedReadCapacityAlarm"></a>

```typescript
public readonly addConsumedReadCapacityAlarm: {[ key: string ]: ConsumedCapacityThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold">ConsumedCapacityThreshold</a>}

---

##### `addConsumedWriteCapacityAlarm`<sup>Optional</sup> <a name="addConsumedWriteCapacityAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addConsumedWriteCapacityAlarm"></a>

```typescript
public readonly addConsumedWriteCapacityAlarm: {[ key: string ]: ConsumedCapacityThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ConsumedCapacityThreshold">ConsumedCapacityThreshold</a>}

---

##### `addReadThrottledEventsCountAlarm`<sup>Optional</sup> <a name="addReadThrottledEventsCountAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addReadThrottledEventsCountAlarm"></a>

```typescript
public readonly addReadThrottledEventsCountAlarm: {[ key: string ]: ThrottledEventsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ThrottledEventsThreshold">ThrottledEventsThreshold</a>}

---

##### `addSystemErrorCountAlarm`<sup>Optional</sup> <a name="addSystemErrorCountAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addSystemErrorCountAlarm"></a>

```typescript
public readonly addSystemErrorCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `addWriteThrottledEventsCountAlarm`<sup>Optional</sup> <a name="addWriteThrottledEventsCountAlarm" id="cdk-monitoring-constructs.DynamoTableMonitoringProps.property.addWriteThrottledEventsCountAlarm"></a>

```typescript
public readonly addWriteThrottledEventsCountAlarm: {[ key: string ]: ThrottledEventsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ThrottledEventsThreshold">ThrottledEventsThreshold</a>}

---

### Ec2ApplicationLoadBalancerMonitoringProps <a name="Ec2ApplicationLoadBalancerMonitoringProps" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps"></a>

Monitoring props for EC2 service with application load balancer and plain service.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.Initializer"></a>

```typescript
import { Ec2ApplicationLoadBalancerMonitoringProps } from 'cdk-monitoring-constructs'

const ec2ApplicationLoadBalancerMonitoringProps: Ec2ApplicationLoadBalancerMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.applicationLoadBalancer">applicationLoadBalancer</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.applicationTargetGroup">applicationTargetGroup</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.addCpuUsageAlarm">addCpuUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.addMemoryUsageAlarm">addMemoryUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.addRunningTaskCountAlarm">addRunningTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}</code> | Container Insights needs to be enabled for the cluster for this alarm. |
| <code><a href="#cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.maxAutoScalingTaskCount">maxAutoScalingTaskCount</a></code> | <code>number</code> | maximum number of tasks, as specified in your auto scaling config. |
| <code><a href="#cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.minAutoScalingTaskCount">minAutoScalingTaskCount</a></code> | <code>number</code> | minimum number of tasks, as specified in your auto scaling config. |
| <code><a href="#cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.ec2Service">ec2Service</a></code> | <code>aws-cdk-lib.aws_ecs.Ec2Service</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.addHealthyTaskCountAlarm">addHealthyTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold">HealthyTaskCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.addHealthyTaskPercentAlarm">addHealthyTaskPercentAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold">HealthyTaskPercentThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.addMinProcessedBytesAlarm">addMinProcessedBytesAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MinProcessedBytesThreshold">MinProcessedBytesThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.addUnhealthyTaskCountAlarm">addUnhealthyTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UnhealthyTaskCountThreshold">UnhealthyTaskCountThreshold</a>}</code> | *No description.* |

---

##### `applicationLoadBalancer`<sup>Required</sup> <a name="applicationLoadBalancer" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.applicationLoadBalancer"></a>

```typescript
public readonly applicationLoadBalancer: ApplicationLoadBalancer;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer

---

##### `applicationTargetGroup`<sup>Required</sup> <a name="applicationTargetGroup" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.applicationTargetGroup"></a>

```typescript
public readonly applicationTargetGroup: ApplicationTargetGroup;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addCpuUsageAlarm`<sup>Optional</sup> <a name="addCpuUsageAlarm" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.addCpuUsageAlarm"></a>

```typescript
public readonly addCpuUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addMemoryUsageAlarm`<sup>Optional</sup> <a name="addMemoryUsageAlarm" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.addMemoryUsageAlarm"></a>

```typescript
public readonly addMemoryUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addRunningTaskCountAlarm`<sup>Optional</sup> <a name="addRunningTaskCountAlarm" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.addRunningTaskCountAlarm"></a>

```typescript
public readonly addRunningTaskCountAlarm: {[ key: string ]: RunningTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}

Container Insights needs to be enabled for the cluster for this alarm.

---

##### `maxAutoScalingTaskCount`<sup>Optional</sup> <a name="maxAutoScalingTaskCount" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.maxAutoScalingTaskCount"></a>

```typescript
public readonly maxAutoScalingTaskCount: number;
```

- *Type:* number

maximum number of tasks, as specified in your auto scaling config.

---

##### `minAutoScalingTaskCount`<sup>Optional</sup> <a name="minAutoScalingTaskCount" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.minAutoScalingTaskCount"></a>

```typescript
public readonly minAutoScalingTaskCount: number;
```

- *Type:* number

minimum number of tasks, as specified in your auto scaling config.

---

##### `ec2Service`<sup>Required</sup> <a name="ec2Service" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.ec2Service"></a>

```typescript
public readonly ec2Service: Ec2Service;
```

- *Type:* aws-cdk-lib.aws_ecs.Ec2Service

---

##### `addHealthyTaskCountAlarm`<sup>Optional</sup> <a name="addHealthyTaskCountAlarm" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.addHealthyTaskCountAlarm"></a>

```typescript
public readonly addHealthyTaskCountAlarm: {[ key: string ]: HealthyTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold">HealthyTaskCountThreshold</a>}

---

##### `addHealthyTaskPercentAlarm`<sup>Optional</sup> <a name="addHealthyTaskPercentAlarm" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.addHealthyTaskPercentAlarm"></a>

```typescript
public readonly addHealthyTaskPercentAlarm: {[ key: string ]: HealthyTaskPercentThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold">HealthyTaskPercentThreshold</a>}

---

##### `addMinProcessedBytesAlarm`<sup>Optional</sup> <a name="addMinProcessedBytesAlarm" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.addMinProcessedBytesAlarm"></a>

```typescript
public readonly addMinProcessedBytesAlarm: {[ key: string ]: MinProcessedBytesThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MinProcessedBytesThreshold">MinProcessedBytesThreshold</a>}

---

##### `addUnhealthyTaskCountAlarm`<sup>Optional</sup> <a name="addUnhealthyTaskCountAlarm" id="cdk-monitoring-constructs.Ec2ApplicationLoadBalancerMonitoringProps.property.addUnhealthyTaskCountAlarm"></a>

```typescript
public readonly addUnhealthyTaskCountAlarm: {[ key: string ]: UnhealthyTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UnhealthyTaskCountThreshold">UnhealthyTaskCountThreshold</a>}

---

### EC2MetricFactoryProps <a name="EC2MetricFactoryProps" id="cdk-monitoring-constructs.EC2MetricFactoryProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.EC2MetricFactoryProps.Initializer"></a>

```typescript
import { EC2MetricFactoryProps } from 'cdk-monitoring-constructs'

const eC2MetricFactoryProps: EC2MetricFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.EC2MetricFactoryProps.property.autoScalingGroup">autoScalingGroup</a></code> | <code>aws-cdk-lib.aws_autoscaling.IAutoScalingGroup</code> | Auto-Scaling Group to monitor. |
| <code><a href="#cdk-monitoring-constructs.EC2MetricFactoryProps.property.instanceIds">instanceIds</a></code> | <code>string[]</code> | Selected IDs of EC2 instances to monitor. |

---

##### `autoScalingGroup`<sup>Optional</sup> <a name="autoScalingGroup" id="cdk-monitoring-constructs.EC2MetricFactoryProps.property.autoScalingGroup"></a>

```typescript
public readonly autoScalingGroup: IAutoScalingGroup;
```

- *Type:* aws-cdk-lib.aws_autoscaling.IAutoScalingGroup
- *Default:* no Auto-Scaling Group filter

Auto-Scaling Group to monitor.

---

##### `instanceIds`<sup>Optional</sup> <a name="instanceIds" id="cdk-monitoring-constructs.EC2MetricFactoryProps.property.instanceIds"></a>

```typescript
public readonly instanceIds: string[];
```

- *Type:* string[]
- *Default:* no instance filter

Selected IDs of EC2 instances to monitor.

---

### EC2MonitoringOptions <a name="EC2MonitoringOptions" id="cdk-monitoring-constructs.EC2MonitoringOptions"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.EC2MonitoringOptions.Initializer"></a>

```typescript
import { EC2MonitoringOptions } from 'cdk-monitoring-constructs'

const eC2MonitoringOptions: EC2MonitoringOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.EC2MonitoringOptions.property.autoScalingGroup">autoScalingGroup</a></code> | <code>aws-cdk-lib.aws_autoscaling.IAutoScalingGroup</code> | Auto-Scaling Group to monitor. |
| <code><a href="#cdk-monitoring-constructs.EC2MonitoringOptions.property.instanceIds">instanceIds</a></code> | <code>string[]</code> | Selected IDs of EC2 instances to monitor. |
| <code><a href="#cdk-monitoring-constructs.EC2MonitoringOptions.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.EC2MonitoringOptions.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.EC2MonitoringOptions.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.EC2MonitoringOptions.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.EC2MonitoringOptions.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.EC2MonitoringOptions.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.EC2MonitoringOptions.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |

---

##### `autoScalingGroup`<sup>Optional</sup> <a name="autoScalingGroup" id="cdk-monitoring-constructs.EC2MonitoringOptions.property.autoScalingGroup"></a>

```typescript
public readonly autoScalingGroup: IAutoScalingGroup;
```

- *Type:* aws-cdk-lib.aws_autoscaling.IAutoScalingGroup
- *Default:* no Auto-Scaling Group filter

Auto-Scaling Group to monitor.

---

##### `instanceIds`<sup>Optional</sup> <a name="instanceIds" id="cdk-monitoring-constructs.EC2MonitoringOptions.property.instanceIds"></a>

```typescript
public readonly instanceIds: string[];
```

- *Type:* string[]
- *Default:* no instance filter

Selected IDs of EC2 instances to monitor.

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.EC2MonitoringOptions.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.EC2MonitoringOptions.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.EC2MonitoringOptions.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.EC2MonitoringOptions.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.EC2MonitoringOptions.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.EC2MonitoringOptions.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.EC2MonitoringOptions.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

### EC2MonitoringProps <a name="EC2MonitoringProps" id="cdk-monitoring-constructs.EC2MonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.EC2MonitoringProps.Initializer"></a>

```typescript
import { EC2MonitoringProps } from 'cdk-monitoring-constructs'

const eC2MonitoringProps: EC2MonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.EC2MonitoringProps.property.autoScalingGroup">autoScalingGroup</a></code> | <code>aws-cdk-lib.aws_autoscaling.IAutoScalingGroup</code> | Auto-Scaling Group to monitor. |
| <code><a href="#cdk-monitoring-constructs.EC2MonitoringProps.property.instanceIds">instanceIds</a></code> | <code>string[]</code> | Selected IDs of EC2 instances to monitor. |
| <code><a href="#cdk-monitoring-constructs.EC2MonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.EC2MonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.EC2MonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.EC2MonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.EC2MonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.EC2MonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.EC2MonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |

---

##### `autoScalingGroup`<sup>Optional</sup> <a name="autoScalingGroup" id="cdk-monitoring-constructs.EC2MonitoringProps.property.autoScalingGroup"></a>

```typescript
public readonly autoScalingGroup: IAutoScalingGroup;
```

- *Type:* aws-cdk-lib.aws_autoscaling.IAutoScalingGroup
- *Default:* no Auto-Scaling Group filter

Auto-Scaling Group to monitor.

---

##### `instanceIds`<sup>Optional</sup> <a name="instanceIds" id="cdk-monitoring-constructs.EC2MonitoringProps.property.instanceIds"></a>

```typescript
public readonly instanceIds: string[];
```

- *Type:* string[]
- *Default:* no instance filter

Selected IDs of EC2 instances to monitor.

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.EC2MonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.EC2MonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.EC2MonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.EC2MonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.EC2MonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.EC2MonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.EC2MonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

### Ec2NetworkLoadBalancerMonitoringProps <a name="Ec2NetworkLoadBalancerMonitoringProps" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps"></a>

Monitoring props for EC2 service with network load balancer and plain service.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.Initializer"></a>

```typescript
import { Ec2NetworkLoadBalancerMonitoringProps } from 'cdk-monitoring-constructs'

const ec2NetworkLoadBalancerMonitoringProps: Ec2NetworkLoadBalancerMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.networkLoadBalancer">networkLoadBalancer</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.networkTargetGroup">networkTargetGroup</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.NetworkTargetGroup</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.addCpuUsageAlarm">addCpuUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.addMemoryUsageAlarm">addMemoryUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.addRunningTaskCountAlarm">addRunningTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}</code> | Container Insights needs to be enabled for the cluster for this alarm. |
| <code><a href="#cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.maxAutoScalingTaskCount">maxAutoScalingTaskCount</a></code> | <code>number</code> | maximum number of tasks, as specified in your auto scaling config. |
| <code><a href="#cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.minAutoScalingTaskCount">minAutoScalingTaskCount</a></code> | <code>number</code> | minimum number of tasks, as specified in your auto scaling config. |
| <code><a href="#cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.ec2Service">ec2Service</a></code> | <code>aws-cdk-lib.aws_ecs.Ec2Service</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.addHealthyTaskCountAlarm">addHealthyTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold">HealthyTaskCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.addHealthyTaskPercentAlarm">addHealthyTaskPercentAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold">HealthyTaskPercentThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.addMinProcessedBytesAlarm">addMinProcessedBytesAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MinProcessedBytesThreshold">MinProcessedBytesThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.addUnhealthyTaskCountAlarm">addUnhealthyTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UnhealthyTaskCountThreshold">UnhealthyTaskCountThreshold</a>}</code> | *No description.* |

---

##### `networkLoadBalancer`<sup>Required</sup> <a name="networkLoadBalancer" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.networkLoadBalancer"></a>

```typescript
public readonly networkLoadBalancer: NetworkLoadBalancer;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer

---

##### `networkTargetGroup`<sup>Required</sup> <a name="networkTargetGroup" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.networkTargetGroup"></a>

```typescript
public readonly networkTargetGroup: NetworkTargetGroup;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.NetworkTargetGroup

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addCpuUsageAlarm`<sup>Optional</sup> <a name="addCpuUsageAlarm" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.addCpuUsageAlarm"></a>

```typescript
public readonly addCpuUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addMemoryUsageAlarm`<sup>Optional</sup> <a name="addMemoryUsageAlarm" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.addMemoryUsageAlarm"></a>

```typescript
public readonly addMemoryUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addRunningTaskCountAlarm`<sup>Optional</sup> <a name="addRunningTaskCountAlarm" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.addRunningTaskCountAlarm"></a>

```typescript
public readonly addRunningTaskCountAlarm: {[ key: string ]: RunningTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}

Container Insights needs to be enabled for the cluster for this alarm.

---

##### `maxAutoScalingTaskCount`<sup>Optional</sup> <a name="maxAutoScalingTaskCount" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.maxAutoScalingTaskCount"></a>

```typescript
public readonly maxAutoScalingTaskCount: number;
```

- *Type:* number

maximum number of tasks, as specified in your auto scaling config.

---

##### `minAutoScalingTaskCount`<sup>Optional</sup> <a name="minAutoScalingTaskCount" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.minAutoScalingTaskCount"></a>

```typescript
public readonly minAutoScalingTaskCount: number;
```

- *Type:* number

minimum number of tasks, as specified in your auto scaling config.

---

##### `ec2Service`<sup>Required</sup> <a name="ec2Service" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.ec2Service"></a>

```typescript
public readonly ec2Service: Ec2Service;
```

- *Type:* aws-cdk-lib.aws_ecs.Ec2Service

---

##### `addHealthyTaskCountAlarm`<sup>Optional</sup> <a name="addHealthyTaskCountAlarm" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.addHealthyTaskCountAlarm"></a>

```typescript
public readonly addHealthyTaskCountAlarm: {[ key: string ]: HealthyTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold">HealthyTaskCountThreshold</a>}

---

##### `addHealthyTaskPercentAlarm`<sup>Optional</sup> <a name="addHealthyTaskPercentAlarm" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.addHealthyTaskPercentAlarm"></a>

```typescript
public readonly addHealthyTaskPercentAlarm: {[ key: string ]: HealthyTaskPercentThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold">HealthyTaskPercentThreshold</a>}

---

##### `addMinProcessedBytesAlarm`<sup>Optional</sup> <a name="addMinProcessedBytesAlarm" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.addMinProcessedBytesAlarm"></a>

```typescript
public readonly addMinProcessedBytesAlarm: {[ key: string ]: MinProcessedBytesThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MinProcessedBytesThreshold">MinProcessedBytesThreshold</a>}

---

##### `addUnhealthyTaskCountAlarm`<sup>Optional</sup> <a name="addUnhealthyTaskCountAlarm" id="cdk-monitoring-constructs.Ec2NetworkLoadBalancerMonitoringProps.property.addUnhealthyTaskCountAlarm"></a>

```typescript
public readonly addUnhealthyTaskCountAlarm: {[ key: string ]: UnhealthyTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UnhealthyTaskCountThreshold">UnhealthyTaskCountThreshold</a>}

---

### Ec2ServiceMonitoringProps <a name="Ec2ServiceMonitoringProps" id="cdk-monitoring-constructs.Ec2ServiceMonitoringProps"></a>

Monitoring props for load-balanced EC2 service.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.Ec2ServiceMonitoringProps.Initializer"></a>

```typescript
import { Ec2ServiceMonitoringProps } from 'cdk-monitoring-constructs'

const ec2ServiceMonitoringProps: Ec2ServiceMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.addCpuUsageAlarm">addCpuUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.addMemoryUsageAlarm">addMemoryUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.addRunningTaskCountAlarm">addRunningTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}</code> | Container Insights needs to be enabled for the cluster for this alarm. |
| <code><a href="#cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.maxAutoScalingTaskCount">maxAutoScalingTaskCount</a></code> | <code>number</code> | maximum number of tasks, as specified in your auto scaling config. |
| <code><a href="#cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.minAutoScalingTaskCount">minAutoScalingTaskCount</a></code> | <code>number</code> | minimum number of tasks, as specified in your auto scaling config. |
| <code><a href="#cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.ec2Service">ec2Service</a></code> | <code>aws-cdk-lib.aws_ecs_patterns.NetworkLoadBalancedEc2Service \| aws-cdk-lib.aws_ecs_patterns.ApplicationLoadBalancedEc2Service</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.addHealthyTaskCountAlarm">addHealthyTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold">HealthyTaskCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.addHealthyTaskPercentAlarm">addHealthyTaskPercentAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold">HealthyTaskPercentThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.addMinProcessedBytesAlarm">addMinProcessedBytesAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MinProcessedBytesThreshold">MinProcessedBytesThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.addUnhealthyTaskCountAlarm">addUnhealthyTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UnhealthyTaskCountThreshold">UnhealthyTaskCountThreshold</a>}</code> | *No description.* |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addCpuUsageAlarm`<sup>Optional</sup> <a name="addCpuUsageAlarm" id="cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.addCpuUsageAlarm"></a>

```typescript
public readonly addCpuUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addMemoryUsageAlarm`<sup>Optional</sup> <a name="addMemoryUsageAlarm" id="cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.addMemoryUsageAlarm"></a>

```typescript
public readonly addMemoryUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addRunningTaskCountAlarm`<sup>Optional</sup> <a name="addRunningTaskCountAlarm" id="cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.addRunningTaskCountAlarm"></a>

```typescript
public readonly addRunningTaskCountAlarm: {[ key: string ]: RunningTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}

Container Insights needs to be enabled for the cluster for this alarm.

---

##### `maxAutoScalingTaskCount`<sup>Optional</sup> <a name="maxAutoScalingTaskCount" id="cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.maxAutoScalingTaskCount"></a>

```typescript
public readonly maxAutoScalingTaskCount: number;
```

- *Type:* number

maximum number of tasks, as specified in your auto scaling config.

---

##### `minAutoScalingTaskCount`<sup>Optional</sup> <a name="minAutoScalingTaskCount" id="cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.minAutoScalingTaskCount"></a>

```typescript
public readonly minAutoScalingTaskCount: number;
```

- *Type:* number

minimum number of tasks, as specified in your auto scaling config.

---

##### `ec2Service`<sup>Required</sup> <a name="ec2Service" id="cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.ec2Service"></a>

```typescript
public readonly ec2Service: NetworkLoadBalancedEc2Service | ApplicationLoadBalancedEc2Service;
```

- *Type:* aws-cdk-lib.aws_ecs_patterns.NetworkLoadBalancedEc2Service | aws-cdk-lib.aws_ecs_patterns.ApplicationLoadBalancedEc2Service

---

##### `addHealthyTaskCountAlarm`<sup>Optional</sup> <a name="addHealthyTaskCountAlarm" id="cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.addHealthyTaskCountAlarm"></a>

```typescript
public readonly addHealthyTaskCountAlarm: {[ key: string ]: HealthyTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold">HealthyTaskCountThreshold</a>}

---

##### `addHealthyTaskPercentAlarm`<sup>Optional</sup> <a name="addHealthyTaskPercentAlarm" id="cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.addHealthyTaskPercentAlarm"></a>

```typescript
public readonly addHealthyTaskPercentAlarm: {[ key: string ]: HealthyTaskPercentThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold">HealthyTaskPercentThreshold</a>}

---

##### `addMinProcessedBytesAlarm`<sup>Optional</sup> <a name="addMinProcessedBytesAlarm" id="cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.addMinProcessedBytesAlarm"></a>

```typescript
public readonly addMinProcessedBytesAlarm: {[ key: string ]: MinProcessedBytesThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MinProcessedBytesThreshold">MinProcessedBytesThreshold</a>}

---

##### `addUnhealthyTaskCountAlarm`<sup>Optional</sup> <a name="addUnhealthyTaskCountAlarm" id="cdk-monitoring-constructs.Ec2ServiceMonitoringProps.property.addUnhealthyTaskCountAlarm"></a>

```typescript
public readonly addUnhealthyTaskCountAlarm: {[ key: string ]: UnhealthyTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UnhealthyTaskCountThreshold">UnhealthyTaskCountThreshold</a>}

---

### ElastiCacheClusterMetricFactoryProps <a name="ElastiCacheClusterMetricFactoryProps" id="cdk-monitoring-constructs.ElastiCacheClusterMetricFactoryProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.ElastiCacheClusterMetricFactoryProps.Initializer"></a>

```typescript
import { ElastiCacheClusterMetricFactoryProps } from 'cdk-monitoring-constructs'

const elastiCacheClusterMetricFactoryProps: ElastiCacheClusterMetricFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMetricFactoryProps.property.clusterId">clusterId</a></code> | <code>string</code> | Cluster to monitor. |

---

##### `clusterId`<sup>Optional</sup> <a name="clusterId" id="cdk-monitoring-constructs.ElastiCacheClusterMetricFactoryProps.property.clusterId"></a>

```typescript
public readonly clusterId: string;
```

- *Type:* string
- *Default:* monitor all clusters

Cluster to monitor.

---

### ElastiCacheClusterMonitoringOptions <a name="ElastiCacheClusterMonitoringOptions" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.Initializer"></a>

```typescript
import { ElastiCacheClusterMonitoringOptions } from 'cdk-monitoring-constructs'

const elastiCacheClusterMonitoringOptions: ElastiCacheClusterMonitoringOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.clusterType">clusterType</a></code> | <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterType">ElastiCacheClusterType</a></code> | Cluster type (needed, since each type has their own specific metrics). |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.addCpuUsageAlarm">addCpuUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | Add CPU usage alarm. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.addMaxEvictedItemsCountAlarm">addMaxEvictedItemsCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MaxItemsCountThreshold">MaxItemsCountThreshold</a>}</code> | Add alarm on number of evicted items. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.addMaxItemsCountAlarm">addMaxItemsCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MaxItemsCountThreshold">MaxItemsCountThreshold</a>}</code> | Add alarm on total number of items. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.addMaxUsedSwapMemoryAlarm">addMaxUsedSwapMemoryAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MaxUsedSwapMemoryThreshold">MaxUsedSwapMemoryThreshold</a>}</code> | Add alarm on amount of used swap memory. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.addMinFreeableMemoryAlarm">addMinFreeableMemoryAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MinFreeableMemoryThreshold">MinFreeableMemoryThreshold</a>}</code> | Add alarm on amount of freeable memory. |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `clusterType`<sup>Required</sup> <a name="clusterType" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.clusterType"></a>

```typescript
public readonly clusterType: ElastiCacheClusterType;
```

- *Type:* <a href="#cdk-monitoring-constructs.ElastiCacheClusterType">ElastiCacheClusterType</a>

Cluster type (needed, since each type has their own specific metrics).

---

##### `addCpuUsageAlarm`<sup>Optional</sup> <a name="addCpuUsageAlarm" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.addCpuUsageAlarm"></a>

```typescript
public readonly addCpuUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

Add CPU usage alarm.

---

##### `addMaxEvictedItemsCountAlarm`<sup>Optional</sup> <a name="addMaxEvictedItemsCountAlarm" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.addMaxEvictedItemsCountAlarm"></a>

```typescript
public readonly addMaxEvictedItemsCountAlarm: {[ key: string ]: MaxItemsCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MaxItemsCountThreshold">MaxItemsCountThreshold</a>}

Add alarm on number of evicted items.

---

##### `addMaxItemsCountAlarm`<sup>Optional</sup> <a name="addMaxItemsCountAlarm" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.addMaxItemsCountAlarm"></a>

```typescript
public readonly addMaxItemsCountAlarm: {[ key: string ]: MaxItemsCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MaxItemsCountThreshold">MaxItemsCountThreshold</a>}

Add alarm on total number of items.

---

##### `addMaxUsedSwapMemoryAlarm`<sup>Optional</sup> <a name="addMaxUsedSwapMemoryAlarm" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.addMaxUsedSwapMemoryAlarm"></a>

```typescript
public readonly addMaxUsedSwapMemoryAlarm: {[ key: string ]: MaxUsedSwapMemoryThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MaxUsedSwapMemoryThreshold">MaxUsedSwapMemoryThreshold</a>}

Add alarm on amount of used swap memory.

---

##### `addMinFreeableMemoryAlarm`<sup>Optional</sup> <a name="addMinFreeableMemoryAlarm" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringOptions.property.addMinFreeableMemoryAlarm"></a>

```typescript
public readonly addMinFreeableMemoryAlarm: {[ key: string ]: MinFreeableMemoryThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MinFreeableMemoryThreshold">MinFreeableMemoryThreshold</a>}

Add alarm on amount of freeable memory.

---

### ElastiCacheClusterMonitoringProps <a name="ElastiCacheClusterMonitoringProps" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.Initializer"></a>

```typescript
import { ElastiCacheClusterMonitoringProps } from 'cdk-monitoring-constructs'

const elastiCacheClusterMonitoringProps: ElastiCacheClusterMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.clusterId">clusterId</a></code> | <code>string</code> | Cluster to monitor. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.clusterType">clusterType</a></code> | <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterType">ElastiCacheClusterType</a></code> | Cluster type (needed, since each type has their own specific metrics). |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.addCpuUsageAlarm">addCpuUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | Add CPU usage alarm. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.addMaxEvictedItemsCountAlarm">addMaxEvictedItemsCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MaxItemsCountThreshold">MaxItemsCountThreshold</a>}</code> | Add alarm on number of evicted items. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.addMaxItemsCountAlarm">addMaxItemsCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MaxItemsCountThreshold">MaxItemsCountThreshold</a>}</code> | Add alarm on total number of items. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.addMaxUsedSwapMemoryAlarm">addMaxUsedSwapMemoryAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MaxUsedSwapMemoryThreshold">MaxUsedSwapMemoryThreshold</a>}</code> | Add alarm on amount of used swap memory. |
| <code><a href="#cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.addMinFreeableMemoryAlarm">addMinFreeableMemoryAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MinFreeableMemoryThreshold">MinFreeableMemoryThreshold</a>}</code> | Add alarm on amount of freeable memory. |

---

##### `clusterId`<sup>Optional</sup> <a name="clusterId" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.clusterId"></a>

```typescript
public readonly clusterId: string;
```

- *Type:* string
- *Default:* monitor all clusters

Cluster to monitor.

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `clusterType`<sup>Required</sup> <a name="clusterType" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.clusterType"></a>

```typescript
public readonly clusterType: ElastiCacheClusterType;
```

- *Type:* <a href="#cdk-monitoring-constructs.ElastiCacheClusterType">ElastiCacheClusterType</a>

Cluster type (needed, since each type has their own specific metrics).

---

##### `addCpuUsageAlarm`<sup>Optional</sup> <a name="addCpuUsageAlarm" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.addCpuUsageAlarm"></a>

```typescript
public readonly addCpuUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

Add CPU usage alarm.

---

##### `addMaxEvictedItemsCountAlarm`<sup>Optional</sup> <a name="addMaxEvictedItemsCountAlarm" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.addMaxEvictedItemsCountAlarm"></a>

```typescript
public readonly addMaxEvictedItemsCountAlarm: {[ key: string ]: MaxItemsCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MaxItemsCountThreshold">MaxItemsCountThreshold</a>}

Add alarm on number of evicted items.

---

##### `addMaxItemsCountAlarm`<sup>Optional</sup> <a name="addMaxItemsCountAlarm" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.addMaxItemsCountAlarm"></a>

```typescript
public readonly addMaxItemsCountAlarm: {[ key: string ]: MaxItemsCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MaxItemsCountThreshold">MaxItemsCountThreshold</a>}

Add alarm on total number of items.

---

##### `addMaxUsedSwapMemoryAlarm`<sup>Optional</sup> <a name="addMaxUsedSwapMemoryAlarm" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.addMaxUsedSwapMemoryAlarm"></a>

```typescript
public readonly addMaxUsedSwapMemoryAlarm: {[ key: string ]: MaxUsedSwapMemoryThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MaxUsedSwapMemoryThreshold">MaxUsedSwapMemoryThreshold</a>}

Add alarm on amount of used swap memory.

---

##### `addMinFreeableMemoryAlarm`<sup>Optional</sup> <a name="addMinFreeableMemoryAlarm" id="cdk-monitoring-constructs.ElastiCacheClusterMonitoringProps.property.addMinFreeableMemoryAlarm"></a>

```typescript
public readonly addMinFreeableMemoryAlarm: {[ key: string ]: MinFreeableMemoryThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MinFreeableMemoryThreshold">MinFreeableMemoryThreshold</a>}

Add alarm on amount of freeable memory.

---

### ErrorCountThreshold <a name="ErrorCountThreshold" id="cdk-monitoring-constructs.ErrorCountThreshold"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.ErrorCountThreshold.Initializer"></a>

```typescript
import { ErrorCountThreshold } from 'cdk-monitoring-constructs'

const errorCountThreshold: ErrorCountThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.ErrorCountThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.ErrorCountThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.ErrorCountThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.ErrorCountThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.ErrorCountThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.ErrorCountThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.ErrorCountThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.ErrorCountThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.ErrorCountThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.ErrorCountThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.ErrorCountThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.ErrorCountThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.ErrorCountThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.ErrorCountThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.ErrorCountThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.ErrorCountThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.ErrorCountThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.ErrorCountThreshold.property.maxErrorCount">maxErrorCount</a></code> | <code>number</code> | *No description.* |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.ErrorCountThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.ErrorCountThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.ErrorCountThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.ErrorCountThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.ErrorCountThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.ErrorCountThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.ErrorCountThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.ErrorCountThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.ErrorCountThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.ErrorCountThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.ErrorCountThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.ErrorCountThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.ErrorCountThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.ErrorCountThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, a composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
This composite alarm will be returned as a result and uses the specified alarm actions.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.ErrorCountThreshold.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.ErrorCountThreshold.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `treatMissingDataOverride`<sup>Optional</sup> <a name="treatMissingDataOverride" id="cdk-monitoring-constructs.ErrorCountThreshold.property.treatMissingDataOverride"></a>

```typescript
public readonly treatMissingDataOverride: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData
- *Default:* alarm-specific default

Behaviour in case the metric data is missing.

---

##### `maxErrorCount`<sup>Required</sup> <a name="maxErrorCount" id="cdk-monitoring-constructs.ErrorCountThreshold.property.maxErrorCount"></a>

```typescript
public readonly maxErrorCount: number;
```

- *Type:* number

---

### ErrorRateThreshold <a name="ErrorRateThreshold" id="cdk-monitoring-constructs.ErrorRateThreshold"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.ErrorRateThreshold.Initializer"></a>

```typescript
import { ErrorRateThreshold } from 'cdk-monitoring-constructs'

const errorRateThreshold: ErrorRateThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.ErrorRateThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.ErrorRateThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.ErrorRateThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.ErrorRateThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.ErrorRateThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.ErrorRateThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.ErrorRateThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.ErrorRateThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.ErrorRateThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.ErrorRateThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.ErrorRateThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.ErrorRateThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.ErrorRateThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.ErrorRateThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.ErrorRateThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.ErrorRateThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.ErrorRateThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.ErrorRateThreshold.property.maxErrorRate">maxErrorRate</a></code> | <code>number</code> | *No description.* |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.ErrorRateThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.ErrorRateThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.ErrorRateThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.ErrorRateThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.ErrorRateThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.ErrorRateThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.ErrorRateThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.ErrorRateThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.ErrorRateThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.ErrorRateThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.ErrorRateThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.ErrorRateThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.ErrorRateThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.ErrorRateThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, a composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
This composite alarm will be returned as a result and uses the specified alarm actions.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.ErrorRateThreshold.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.ErrorRateThreshold.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `treatMissingDataOverride`<sup>Optional</sup> <a name="treatMissingDataOverride" id="cdk-monitoring-constructs.ErrorRateThreshold.property.treatMissingDataOverride"></a>

```typescript
public readonly treatMissingDataOverride: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData
- *Default:* alarm-specific default

Behaviour in case the metric data is missing.

---

##### `maxErrorRate`<sup>Required</sup> <a name="maxErrorRate" id="cdk-monitoring-constructs.ErrorRateThreshold.property.maxErrorRate"></a>

```typescript
public readonly maxErrorRate: number;
```

- *Type:* number

---

### FargateApplicationLoadBalancerMonitoringProps <a name="FargateApplicationLoadBalancerMonitoringProps" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps"></a>

Monitoring props for Fargate service with application load balancer and plain service.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.Initializer"></a>

```typescript
import { FargateApplicationLoadBalancerMonitoringProps } from 'cdk-monitoring-constructs'

const fargateApplicationLoadBalancerMonitoringProps: FargateApplicationLoadBalancerMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.applicationLoadBalancer">applicationLoadBalancer</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.applicationTargetGroup">applicationTargetGroup</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.addCpuUsageAlarm">addCpuUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.addMemoryUsageAlarm">addMemoryUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.addRunningTaskCountAlarm">addRunningTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}</code> | Container Insights needs to be enabled for the cluster for this alarm. |
| <code><a href="#cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.maxAutoScalingTaskCount">maxAutoScalingTaskCount</a></code> | <code>number</code> | maximum number of tasks, as specified in your auto scaling config. |
| <code><a href="#cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.minAutoScalingTaskCount">minAutoScalingTaskCount</a></code> | <code>number</code> | minimum number of tasks, as specified in your auto scaling config. |
| <code><a href="#cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.fargateService">fargateService</a></code> | <code>aws-cdk-lib.aws_ecs.FargateService</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.addHealthyTaskCountAlarm">addHealthyTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold">HealthyTaskCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.addHealthyTaskPercentAlarm">addHealthyTaskPercentAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold">HealthyTaskPercentThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.addMinProcessedBytesAlarm">addMinProcessedBytesAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MinProcessedBytesThreshold">MinProcessedBytesThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.addUnhealthyTaskCountAlarm">addUnhealthyTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UnhealthyTaskCountThreshold">UnhealthyTaskCountThreshold</a>}</code> | *No description.* |

---

##### `applicationLoadBalancer`<sup>Required</sup> <a name="applicationLoadBalancer" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.applicationLoadBalancer"></a>

```typescript
public readonly applicationLoadBalancer: ApplicationLoadBalancer;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer

---

##### `applicationTargetGroup`<sup>Required</sup> <a name="applicationTargetGroup" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.applicationTargetGroup"></a>

```typescript
public readonly applicationTargetGroup: ApplicationTargetGroup;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addCpuUsageAlarm`<sup>Optional</sup> <a name="addCpuUsageAlarm" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.addCpuUsageAlarm"></a>

```typescript
public readonly addCpuUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addMemoryUsageAlarm`<sup>Optional</sup> <a name="addMemoryUsageAlarm" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.addMemoryUsageAlarm"></a>

```typescript
public readonly addMemoryUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addRunningTaskCountAlarm`<sup>Optional</sup> <a name="addRunningTaskCountAlarm" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.addRunningTaskCountAlarm"></a>

```typescript
public readonly addRunningTaskCountAlarm: {[ key: string ]: RunningTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}

Container Insights needs to be enabled for the cluster for this alarm.

---

##### `maxAutoScalingTaskCount`<sup>Optional</sup> <a name="maxAutoScalingTaskCount" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.maxAutoScalingTaskCount"></a>

```typescript
public readonly maxAutoScalingTaskCount: number;
```

- *Type:* number

maximum number of tasks, as specified in your auto scaling config.

---

##### `minAutoScalingTaskCount`<sup>Optional</sup> <a name="minAutoScalingTaskCount" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.minAutoScalingTaskCount"></a>

```typescript
public readonly minAutoScalingTaskCount: number;
```

- *Type:* number

minimum number of tasks, as specified in your auto scaling config.

---

##### `fargateService`<sup>Required</sup> <a name="fargateService" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.fargateService"></a>

```typescript
public readonly fargateService: FargateService;
```

- *Type:* aws-cdk-lib.aws_ecs.FargateService

---

##### `addHealthyTaskCountAlarm`<sup>Optional</sup> <a name="addHealthyTaskCountAlarm" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.addHealthyTaskCountAlarm"></a>

```typescript
public readonly addHealthyTaskCountAlarm: {[ key: string ]: HealthyTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold">HealthyTaskCountThreshold</a>}

---

##### `addHealthyTaskPercentAlarm`<sup>Optional</sup> <a name="addHealthyTaskPercentAlarm" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.addHealthyTaskPercentAlarm"></a>

```typescript
public readonly addHealthyTaskPercentAlarm: {[ key: string ]: HealthyTaskPercentThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold">HealthyTaskPercentThreshold</a>}

---

##### `addMinProcessedBytesAlarm`<sup>Optional</sup> <a name="addMinProcessedBytesAlarm" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.addMinProcessedBytesAlarm"></a>

```typescript
public readonly addMinProcessedBytesAlarm: {[ key: string ]: MinProcessedBytesThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MinProcessedBytesThreshold">MinProcessedBytesThreshold</a>}

---

##### `addUnhealthyTaskCountAlarm`<sup>Optional</sup> <a name="addUnhealthyTaskCountAlarm" id="cdk-monitoring-constructs.FargateApplicationLoadBalancerMonitoringProps.property.addUnhealthyTaskCountAlarm"></a>

```typescript
public readonly addUnhealthyTaskCountAlarm: {[ key: string ]: UnhealthyTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UnhealthyTaskCountThreshold">UnhealthyTaskCountThreshold</a>}

---

### FargateNetworkLoadBalancerMonitoringProps <a name="FargateNetworkLoadBalancerMonitoringProps" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps"></a>

Monitoring props for Fargate service with network load balancer and plain service.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.Initializer"></a>

```typescript
import { FargateNetworkLoadBalancerMonitoringProps } from 'cdk-monitoring-constructs'

const fargateNetworkLoadBalancerMonitoringProps: FargateNetworkLoadBalancerMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.networkLoadBalancer">networkLoadBalancer</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.networkTargetGroup">networkTargetGroup</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.NetworkTargetGroup</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.addCpuUsageAlarm">addCpuUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.addMemoryUsageAlarm">addMemoryUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.addRunningTaskCountAlarm">addRunningTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}</code> | Container Insights needs to be enabled for the cluster for this alarm. |
| <code><a href="#cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.maxAutoScalingTaskCount">maxAutoScalingTaskCount</a></code> | <code>number</code> | maximum number of tasks, as specified in your auto scaling config. |
| <code><a href="#cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.minAutoScalingTaskCount">minAutoScalingTaskCount</a></code> | <code>number</code> | minimum number of tasks, as specified in your auto scaling config. |
| <code><a href="#cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.fargateService">fargateService</a></code> | <code>aws-cdk-lib.aws_ecs.FargateService</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.addHealthyTaskCountAlarm">addHealthyTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold">HealthyTaskCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.addHealthyTaskPercentAlarm">addHealthyTaskPercentAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold">HealthyTaskPercentThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.addMinProcessedBytesAlarm">addMinProcessedBytesAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MinProcessedBytesThreshold">MinProcessedBytesThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.addUnhealthyTaskCountAlarm">addUnhealthyTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UnhealthyTaskCountThreshold">UnhealthyTaskCountThreshold</a>}</code> | *No description.* |

---

##### `networkLoadBalancer`<sup>Required</sup> <a name="networkLoadBalancer" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.networkLoadBalancer"></a>

```typescript
public readonly networkLoadBalancer: NetworkLoadBalancer;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer

---

##### `networkTargetGroup`<sup>Required</sup> <a name="networkTargetGroup" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.networkTargetGroup"></a>

```typescript
public readonly networkTargetGroup: NetworkTargetGroup;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.NetworkTargetGroup

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addCpuUsageAlarm`<sup>Optional</sup> <a name="addCpuUsageAlarm" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.addCpuUsageAlarm"></a>

```typescript
public readonly addCpuUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addMemoryUsageAlarm`<sup>Optional</sup> <a name="addMemoryUsageAlarm" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.addMemoryUsageAlarm"></a>

```typescript
public readonly addMemoryUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addRunningTaskCountAlarm`<sup>Optional</sup> <a name="addRunningTaskCountAlarm" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.addRunningTaskCountAlarm"></a>

```typescript
public readonly addRunningTaskCountAlarm: {[ key: string ]: RunningTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}

Container Insights needs to be enabled for the cluster for this alarm.

---

##### `maxAutoScalingTaskCount`<sup>Optional</sup> <a name="maxAutoScalingTaskCount" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.maxAutoScalingTaskCount"></a>

```typescript
public readonly maxAutoScalingTaskCount: number;
```

- *Type:* number

maximum number of tasks, as specified in your auto scaling config.

---

##### `minAutoScalingTaskCount`<sup>Optional</sup> <a name="minAutoScalingTaskCount" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.minAutoScalingTaskCount"></a>

```typescript
public readonly minAutoScalingTaskCount: number;
```

- *Type:* number

minimum number of tasks, as specified in your auto scaling config.

---

##### `fargateService`<sup>Required</sup> <a name="fargateService" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.fargateService"></a>

```typescript
public readonly fargateService: FargateService;
```

- *Type:* aws-cdk-lib.aws_ecs.FargateService

---

##### `addHealthyTaskCountAlarm`<sup>Optional</sup> <a name="addHealthyTaskCountAlarm" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.addHealthyTaskCountAlarm"></a>

```typescript
public readonly addHealthyTaskCountAlarm: {[ key: string ]: HealthyTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold">HealthyTaskCountThreshold</a>}

---

##### `addHealthyTaskPercentAlarm`<sup>Optional</sup> <a name="addHealthyTaskPercentAlarm" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.addHealthyTaskPercentAlarm"></a>

```typescript
public readonly addHealthyTaskPercentAlarm: {[ key: string ]: HealthyTaskPercentThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold">HealthyTaskPercentThreshold</a>}

---

##### `addMinProcessedBytesAlarm`<sup>Optional</sup> <a name="addMinProcessedBytesAlarm" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.addMinProcessedBytesAlarm"></a>

```typescript
public readonly addMinProcessedBytesAlarm: {[ key: string ]: MinProcessedBytesThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MinProcessedBytesThreshold">MinProcessedBytesThreshold</a>}

---

##### `addUnhealthyTaskCountAlarm`<sup>Optional</sup> <a name="addUnhealthyTaskCountAlarm" id="cdk-monitoring-constructs.FargateNetworkLoadBalancerMonitoringProps.property.addUnhealthyTaskCountAlarm"></a>

```typescript
public readonly addUnhealthyTaskCountAlarm: {[ key: string ]: UnhealthyTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UnhealthyTaskCountThreshold">UnhealthyTaskCountThreshold</a>}

---

### FargateServiceMonitoringProps <a name="FargateServiceMonitoringProps" id="cdk-monitoring-constructs.FargateServiceMonitoringProps"></a>

Monitoring props for load-balanced Fargate service.

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.FargateServiceMonitoringProps.Initializer"></a>

```typescript
import { FargateServiceMonitoringProps } from 'cdk-monitoring-constructs'

const fargateServiceMonitoringProps: FargateServiceMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.FargateServiceMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.FargateServiceMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.FargateServiceMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.FargateServiceMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.FargateServiceMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.FargateServiceMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.FargateServiceMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.FargateServiceMonitoringProps.property.addCpuUsageAlarm">addCpuUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateServiceMonitoringProps.property.addMemoryUsageAlarm">addMemoryUsageAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateServiceMonitoringProps.property.addRunningTaskCountAlarm">addRunningTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}</code> | Container Insights needs to be enabled for the cluster for this alarm. |
| <code><a href="#cdk-monitoring-constructs.FargateServiceMonitoringProps.property.maxAutoScalingTaskCount">maxAutoScalingTaskCount</a></code> | <code>number</code> | maximum number of tasks, as specified in your auto scaling config. |
| <code><a href="#cdk-monitoring-constructs.FargateServiceMonitoringProps.property.minAutoScalingTaskCount">minAutoScalingTaskCount</a></code> | <code>number</code> | minimum number of tasks, as specified in your auto scaling config. |
| <code><a href="#cdk-monitoring-constructs.FargateServiceMonitoringProps.property.fargateService">fargateService</a></code> | <code>aws-cdk-lib.aws_ecs_patterns.NetworkLoadBalancedFargateService \| aws-cdk-lib.aws_ecs_patterns.ApplicationLoadBalancedFargateService</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateServiceMonitoringProps.property.addHealthyTaskCountAlarm">addHealthyTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold">HealthyTaskCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateServiceMonitoringProps.property.addHealthyTaskPercentAlarm">addHealthyTaskPercentAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold">HealthyTaskPercentThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateServiceMonitoringProps.property.addMinProcessedBytesAlarm">addMinProcessedBytesAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MinProcessedBytesThreshold">MinProcessedBytesThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.FargateServiceMonitoringProps.property.addUnhealthyTaskCountAlarm">addUnhealthyTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UnhealthyTaskCountThreshold">UnhealthyTaskCountThreshold</a>}</code> | *No description.* |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.FargateServiceMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.FargateServiceMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.FargateServiceMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.FargateServiceMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.FargateServiceMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.FargateServiceMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.FargateServiceMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addCpuUsageAlarm`<sup>Optional</sup> <a name="addCpuUsageAlarm" id="cdk-monitoring-constructs.FargateServiceMonitoringProps.property.addCpuUsageAlarm"></a>

```typescript
public readonly addCpuUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addMemoryUsageAlarm`<sup>Optional</sup> <a name="addMemoryUsageAlarm" id="cdk-monitoring-constructs.FargateServiceMonitoringProps.property.addMemoryUsageAlarm"></a>

```typescript
public readonly addMemoryUsageAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addRunningTaskCountAlarm`<sup>Optional</sup> <a name="addRunningTaskCountAlarm" id="cdk-monitoring-constructs.FargateServiceMonitoringProps.property.addRunningTaskCountAlarm"></a>

```typescript
public readonly addRunningTaskCountAlarm: {[ key: string ]: RunningTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}

Container Insights needs to be enabled for the cluster for this alarm.

---

##### `maxAutoScalingTaskCount`<sup>Optional</sup> <a name="maxAutoScalingTaskCount" id="cdk-monitoring-constructs.FargateServiceMonitoringProps.property.maxAutoScalingTaskCount"></a>

```typescript
public readonly maxAutoScalingTaskCount: number;
```

- *Type:* number

maximum number of tasks, as specified in your auto scaling config.

---

##### `minAutoScalingTaskCount`<sup>Optional</sup> <a name="minAutoScalingTaskCount" id="cdk-monitoring-constructs.FargateServiceMonitoringProps.property.minAutoScalingTaskCount"></a>

```typescript
public readonly minAutoScalingTaskCount: number;
```

- *Type:* number

minimum number of tasks, as specified in your auto scaling config.

---

##### `fargateService`<sup>Required</sup> <a name="fargateService" id="cdk-monitoring-constructs.FargateServiceMonitoringProps.property.fargateService"></a>

```typescript
public readonly fargateService: NetworkLoadBalancedFargateService | ApplicationLoadBalancedFargateService;
```

- *Type:* aws-cdk-lib.aws_ecs_patterns.NetworkLoadBalancedFargateService | aws-cdk-lib.aws_ecs_patterns.ApplicationLoadBalancedFargateService

---

##### `addHealthyTaskCountAlarm`<sup>Optional</sup> <a name="addHealthyTaskCountAlarm" id="cdk-monitoring-constructs.FargateServiceMonitoringProps.property.addHealthyTaskCountAlarm"></a>

```typescript
public readonly addHealthyTaskCountAlarm: {[ key: string ]: HealthyTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold">HealthyTaskCountThreshold</a>}

---

##### `addHealthyTaskPercentAlarm`<sup>Optional</sup> <a name="addHealthyTaskPercentAlarm" id="cdk-monitoring-constructs.FargateServiceMonitoringProps.property.addHealthyTaskPercentAlarm"></a>

```typescript
public readonly addHealthyTaskPercentAlarm: {[ key: string ]: HealthyTaskPercentThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold">HealthyTaskPercentThreshold</a>}

---

##### `addMinProcessedBytesAlarm`<sup>Optional</sup> <a name="addMinProcessedBytesAlarm" id="cdk-monitoring-constructs.FargateServiceMonitoringProps.property.addMinProcessedBytesAlarm"></a>

```typescript
public readonly addMinProcessedBytesAlarm: {[ key: string ]: MinProcessedBytesThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MinProcessedBytesThreshold">MinProcessedBytesThreshold</a>}

---

##### `addUnhealthyTaskCountAlarm`<sup>Optional</sup> <a name="addUnhealthyTaskCountAlarm" id="cdk-monitoring-constructs.FargateServiceMonitoringProps.property.addUnhealthyTaskCountAlarm"></a>

```typescript
public readonly addUnhealthyTaskCountAlarm: {[ key: string ]: UnhealthyTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UnhealthyTaskCountThreshold">UnhealthyTaskCountThreshold</a>}

---

### FullRestartCountThreshold <a name="FullRestartCountThreshold" id="cdk-monitoring-constructs.FullRestartCountThreshold"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.FullRestartCountThreshold.Initializer"></a>

```typescript
import { FullRestartCountThreshold } from 'cdk-monitoring-constructs'

const fullRestartCountThreshold: FullRestartCountThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.FullRestartCountThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.FullRestartCountThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.FullRestartCountThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.FullRestartCountThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.FullRestartCountThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.FullRestartCountThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.FullRestartCountThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.FullRestartCountThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.FullRestartCountThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.FullRestartCountThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.FullRestartCountThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.FullRestartCountThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.FullRestartCountThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.FullRestartCountThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.FullRestartCountThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.FullRestartCountThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.FullRestartCountThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.FullRestartCountThreshold.property.maxFullRestartCount">maxFullRestartCount</a></code> | <code>number</code> | *No description.* |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.FullRestartCountThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.FullRestartCountThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.FullRestartCountThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.FullRestartCountThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.FullRestartCountThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.FullRestartCountThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.FullRestartCountThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.FullRestartCountThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.FullRestartCountThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.FullRestartCountThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.FullRestartCountThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.FullRestartCountThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.FullRestartCountThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.FullRestartCountThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, a composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
This composite alarm will be returned as a result and uses the specified alarm actions.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.FullRestartCountThreshold.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.FullRestartCountThreshold.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `treatMissingDataOverride`<sup>Optional</sup> <a name="treatMissingDataOverride" id="cdk-monitoring-constructs.FullRestartCountThreshold.property.treatMissingDataOverride"></a>

```typescript
public readonly treatMissingDataOverride: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData
- *Default:* alarm-specific default

Behaviour in case the metric data is missing.

---

##### `maxFullRestartCount`<sup>Required</sup> <a name="maxFullRestartCount" id="cdk-monitoring-constructs.FullRestartCountThreshold.property.maxFullRestartCount"></a>

```typescript
public readonly maxFullRestartCount: number;
```

- *Type:* number

---

### GlueJobMetricFactoryProps <a name="GlueJobMetricFactoryProps" id="cdk-monitoring-constructs.GlueJobMetricFactoryProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.GlueJobMetricFactoryProps.Initializer"></a>

```typescript
import { GlueJobMetricFactoryProps } from 'cdk-monitoring-constructs'

const glueJobMetricFactoryProps: GlueJobMetricFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.GlueJobMetricFactoryProps.property.jobName">jobName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.GlueJobMetricFactoryProps.property.rateComputationMethod">rateComputationMethod</a></code> | <code><a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a></code> | *No description.* |

---

##### `jobName`<sup>Required</sup> <a name="jobName" id="cdk-monitoring-constructs.GlueJobMetricFactoryProps.property.jobName"></a>

```typescript
public readonly jobName: string;
```

- *Type:* string

---

##### `rateComputationMethod`<sup>Optional</sup> <a name="rateComputationMethod" id="cdk-monitoring-constructs.GlueJobMetricFactoryProps.property.rateComputationMethod"></a>

```typescript
public readonly rateComputationMethod: RateComputationMethod;
```

- *Type:* <a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a>
- *Default:* average

---

### GlueJobMonitoringOptions <a name="GlueJobMonitoringOptions" id="cdk-monitoring-constructs.GlueJobMonitoringOptions"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.GlueJobMonitoringOptions.Initializer"></a>

```typescript
import { GlueJobMonitoringOptions } from 'cdk-monitoring-constructs'

const glueJobMonitoringOptions: GlueJobMonitoringOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringOptions.property.jobName">jobName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringOptions.property.rateComputationMethod">rateComputationMethod</a></code> | <code><a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringOptions.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringOptions.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringOptions.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringOptions.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringOptions.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringOptions.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringOptions.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringOptions.property.addFailedTaskCountAlarm">addFailedTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringOptions.property.addFailedTaskRateAlarm">addFailedTaskRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringOptions.property.addKilledTaskCountAlarm">addKilledTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringOptions.property.addKilledTaskRateAlarm">addKilledTaskRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |

---

##### `jobName`<sup>Required</sup> <a name="jobName" id="cdk-monitoring-constructs.GlueJobMonitoringOptions.property.jobName"></a>

```typescript
public readonly jobName: string;
```

- *Type:* string

---

##### `rateComputationMethod`<sup>Optional</sup> <a name="rateComputationMethod" id="cdk-monitoring-constructs.GlueJobMonitoringOptions.property.rateComputationMethod"></a>

```typescript
public readonly rateComputationMethod: RateComputationMethod;
```

- *Type:* <a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a>
- *Default:* average

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.GlueJobMonitoringOptions.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.GlueJobMonitoringOptions.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.GlueJobMonitoringOptions.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.GlueJobMonitoringOptions.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.GlueJobMonitoringOptions.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.GlueJobMonitoringOptions.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.GlueJobMonitoringOptions.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addFailedTaskCountAlarm`<sup>Optional</sup> <a name="addFailedTaskCountAlarm" id="cdk-monitoring-constructs.GlueJobMonitoringOptions.property.addFailedTaskCountAlarm"></a>

```typescript
public readonly addFailedTaskCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `addFailedTaskRateAlarm`<sup>Optional</sup> <a name="addFailedTaskRateAlarm" id="cdk-monitoring-constructs.GlueJobMonitoringOptions.property.addFailedTaskRateAlarm"></a>

```typescript
public readonly addFailedTaskRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

##### `addKilledTaskCountAlarm`<sup>Optional</sup> <a name="addKilledTaskCountAlarm" id="cdk-monitoring-constructs.GlueJobMonitoringOptions.property.addKilledTaskCountAlarm"></a>

```typescript
public readonly addKilledTaskCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `addKilledTaskRateAlarm`<sup>Optional</sup> <a name="addKilledTaskRateAlarm" id="cdk-monitoring-constructs.GlueJobMonitoringOptions.property.addKilledTaskRateAlarm"></a>

```typescript
public readonly addKilledTaskRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

### GlueJobMonitoringProps <a name="GlueJobMonitoringProps" id="cdk-monitoring-constructs.GlueJobMonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.GlueJobMonitoringProps.Initializer"></a>

```typescript
import { GlueJobMonitoringProps } from 'cdk-monitoring-constructs'

const glueJobMonitoringProps: GlueJobMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringProps.property.jobName">jobName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringProps.property.rateComputationMethod">rateComputationMethod</a></code> | <code><a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringProps.property.addFailedTaskCountAlarm">addFailedTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringProps.property.addFailedTaskRateAlarm">addFailedTaskRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringProps.property.addKilledTaskCountAlarm">addKilledTaskCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.GlueJobMonitoringProps.property.addKilledTaskRateAlarm">addKilledTaskRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |

---

##### `jobName`<sup>Required</sup> <a name="jobName" id="cdk-monitoring-constructs.GlueJobMonitoringProps.property.jobName"></a>

```typescript
public readonly jobName: string;
```

- *Type:* string

---

##### `rateComputationMethod`<sup>Optional</sup> <a name="rateComputationMethod" id="cdk-monitoring-constructs.GlueJobMonitoringProps.property.rateComputationMethod"></a>

```typescript
public readonly rateComputationMethod: RateComputationMethod;
```

- *Type:* <a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a>
- *Default:* average

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.GlueJobMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.GlueJobMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.GlueJobMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.GlueJobMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.GlueJobMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.GlueJobMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.GlueJobMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addFailedTaskCountAlarm`<sup>Optional</sup> <a name="addFailedTaskCountAlarm" id="cdk-monitoring-constructs.GlueJobMonitoringProps.property.addFailedTaskCountAlarm"></a>

```typescript
public readonly addFailedTaskCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `addFailedTaskRateAlarm`<sup>Optional</sup> <a name="addFailedTaskRateAlarm" id="cdk-monitoring-constructs.GlueJobMonitoringProps.property.addFailedTaskRateAlarm"></a>

```typescript
public readonly addFailedTaskRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

##### `addKilledTaskCountAlarm`<sup>Optional</sup> <a name="addKilledTaskCountAlarm" id="cdk-monitoring-constructs.GlueJobMonitoringProps.property.addKilledTaskCountAlarm"></a>

```typescript
public readonly addKilledTaskCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `addKilledTaskRateAlarm`<sup>Optional</sup> <a name="addKilledTaskRateAlarm" id="cdk-monitoring-constructs.GlueJobMonitoringProps.property.addKilledTaskRateAlarm"></a>

```typescript
public readonly addKilledTaskRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

### HealthyTaskCountThreshold <a name="HealthyTaskCountThreshold" id="cdk-monitoring-constructs.HealthyTaskCountThreshold"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.HealthyTaskCountThreshold.Initializer"></a>

```typescript
import { HealthyTaskCountThreshold } from 'cdk-monitoring-constructs'

const healthyTaskCountThreshold: HealthyTaskCountThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskCountThreshold.property.minHealthyTasks">minHealthyTasks</a></code> | <code>number</code> | *No description.* |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.HealthyTaskCountThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.HealthyTaskCountThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.HealthyTaskCountThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.HealthyTaskCountThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.HealthyTaskCountThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.HealthyTaskCountThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.HealthyTaskCountThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.HealthyTaskCountThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.HealthyTaskCountThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.HealthyTaskCountThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.HealthyTaskCountThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.HealthyTaskCountThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.HealthyTaskCountThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.HealthyTaskCountThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, a composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
This composite alarm will be returned as a result and uses the specified alarm actions.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.HealthyTaskCountThreshold.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.HealthyTaskCountThreshold.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `treatMissingDataOverride`<sup>Optional</sup> <a name="treatMissingDataOverride" id="cdk-monitoring-constructs.HealthyTaskCountThreshold.property.treatMissingDataOverride"></a>

```typescript
public readonly treatMissingDataOverride: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData
- *Default:* alarm-specific default

Behaviour in case the metric data is missing.

---

##### `minHealthyTasks`<sup>Required</sup> <a name="minHealthyTasks" id="cdk-monitoring-constructs.HealthyTaskCountThreshold.property.minHealthyTasks"></a>

```typescript
public readonly minHealthyTasks: number;
```

- *Type:* number

---

### HealthyTaskPercentThreshold <a name="HealthyTaskPercentThreshold" id="cdk-monitoring-constructs.HealthyTaskPercentThreshold"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.HealthyTaskPercentThreshold.Initializer"></a>

```typescript
import { HealthyTaskPercentThreshold } from 'cdk-monitoring-constructs'

const healthyTaskPercentThreshold: HealthyTaskPercentThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.minHealthyTaskPercent">minHealthyTaskPercent</a></code> | <code>number</code> | *No description.* |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, a composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
This composite alarm will be returned as a result and uses the specified alarm actions.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `treatMissingDataOverride`<sup>Optional</sup> <a name="treatMissingDataOverride" id="cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.treatMissingDataOverride"></a>

```typescript
public readonly treatMissingDataOverride: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData
- *Default:* alarm-specific default

Behaviour in case the metric data is missing.

---

##### `minHealthyTaskPercent`<sup>Required</sup> <a name="minHealthyTaskPercent" id="cdk-monitoring-constructs.HealthyTaskPercentThreshold.property.minHealthyTaskPercent"></a>

```typescript
public readonly minHealthyTaskPercent: number;
```

- *Type:* number

---

### HighConnectionCountThreshold <a name="HighConnectionCountThreshold" id="cdk-monitoring-constructs.HighConnectionCountThreshold"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.HighConnectionCountThreshold.Initializer"></a>

```typescript
import { HighConnectionCountThreshold } from 'cdk-monitoring-constructs'

const highConnectionCountThreshold: HighConnectionCountThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.HighConnectionCountThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.HighConnectionCountThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.HighConnectionCountThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.HighConnectionCountThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.HighConnectionCountThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.HighConnectionCountThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.HighConnectionCountThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.HighConnectionCountThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.HighConnectionCountThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.HighConnectionCountThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.HighConnectionCountThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.HighConnectionCountThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.HighConnectionCountThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.HighConnectionCountThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.HighConnectionCountThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.HighConnectionCountThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.HighConnectionCountThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.HighConnectionCountThreshold.property.maxConnectionCount">maxConnectionCount</a></code> | <code>number</code> | *No description.* |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.HighConnectionCountThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.HighConnectionCountThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.HighConnectionCountThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.HighConnectionCountThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.HighConnectionCountThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.HighConnectionCountThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.HighConnectionCountThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.HighConnectionCountThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.HighConnectionCountThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.HighConnectionCountThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.HighConnectionCountThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.HighConnectionCountThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.HighConnectionCountThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.HighConnectionCountThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, a composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
This composite alarm will be returned as a result and uses the specified alarm actions.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.HighConnectionCountThreshold.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.HighConnectionCountThreshold.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `treatMissingDataOverride`<sup>Optional</sup> <a name="treatMissingDataOverride" id="cdk-monitoring-constructs.HighConnectionCountThreshold.property.treatMissingDataOverride"></a>

```typescript
public readonly treatMissingDataOverride: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData
- *Default:* alarm-specific default

Behaviour in case the metric data is missing.

---

##### `maxConnectionCount`<sup>Required</sup> <a name="maxConnectionCount" id="cdk-monitoring-constructs.HighConnectionCountThreshold.property.maxConnectionCount"></a>

```typescript
public readonly maxConnectionCount: number;
```

- *Type:* number

---

### HighMessagesPublishedThreshold <a name="HighMessagesPublishedThreshold" id="cdk-monitoring-constructs.HighMessagesPublishedThreshold"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.HighMessagesPublishedThreshold.Initializer"></a>

```typescript
import { HighMessagesPublishedThreshold } from 'cdk-monitoring-constructs'

const highMessagesPublishedThreshold: HighMessagesPublishedThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.maxMessagesPublishedCount">maxMessagesPublishedCount</a></code> | <code>number</code> | *No description.* |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, a composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
This composite alarm will be returned as a result and uses the specified alarm actions.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `treatMissingDataOverride`<sup>Optional</sup> <a name="treatMissingDataOverride" id="cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.treatMissingDataOverride"></a>

```typescript
public readonly treatMissingDataOverride: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData
- *Default:* alarm-specific default

Behaviour in case the metric data is missing.

---

##### `maxMessagesPublishedCount`<sup>Required</sup> <a name="maxMessagesPublishedCount" id="cdk-monitoring-constructs.HighMessagesPublishedThreshold.property.maxMessagesPublishedCount"></a>

```typescript
public readonly maxMessagesPublishedCount: number;
```

- *Type:* number

---

### HighTpsThreshold <a name="HighTpsThreshold" id="cdk-monitoring-constructs.HighTpsThreshold"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.HighTpsThreshold.Initializer"></a>

```typescript
import { HighTpsThreshold } from 'cdk-monitoring-constructs'

const highTpsThreshold: HighTpsThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.HighTpsThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.HighTpsThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.HighTpsThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.HighTpsThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.HighTpsThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.HighTpsThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.HighTpsThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.HighTpsThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.HighTpsThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.HighTpsThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.HighTpsThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.HighTpsThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.HighTpsThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.HighTpsThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.HighTpsThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.HighTpsThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.HighTpsThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.HighTpsThreshold.property.maxTps">maxTps</a></code> | <code>number</code> | *No description.* |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.HighTpsThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.HighTpsThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.HighTpsThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.HighTpsThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.HighTpsThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.HighTpsThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.HighTpsThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.HighTpsThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.HighTpsThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.HighTpsThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.HighTpsThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.HighTpsThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.HighTpsThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.HighTpsThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, a composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
This composite alarm will be returned as a result and uses the specified alarm actions.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.HighTpsThreshold.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.HighTpsThreshold.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `treatMissingDataOverride`<sup>Optional</sup> <a name="treatMissingDataOverride" id="cdk-monitoring-constructs.HighTpsThreshold.property.treatMissingDataOverride"></a>

```typescript
public readonly treatMissingDataOverride: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData
- *Default:* alarm-specific default

Behaviour in case the metric data is missing.

---

##### `maxTps`<sup>Required</sup> <a name="maxTps" id="cdk-monitoring-constructs.HighTpsThreshold.property.maxTps"></a>

```typescript
public readonly maxTps: number;
```

- *Type:* number

---

### KinesisDataAnalyticsMetricFactoryProps <a name="KinesisDataAnalyticsMetricFactoryProps" id="cdk-monitoring-constructs.KinesisDataAnalyticsMetricFactoryProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.KinesisDataAnalyticsMetricFactoryProps.Initializer"></a>

```typescript
import { KinesisDataAnalyticsMetricFactoryProps } from 'cdk-monitoring-constructs'

const kinesisDataAnalyticsMetricFactoryProps: KinesisDataAnalyticsMetricFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMetricFactoryProps.property.application">application</a></code> | <code>string</code> | *No description.* |

---

##### `application`<sup>Required</sup> <a name="application" id="cdk-monitoring-constructs.KinesisDataAnalyticsMetricFactoryProps.property.application"></a>

```typescript
public readonly application: string;
```

- *Type:* string

---

### KinesisDataAnalyticsMonitoringOptions <a name="KinesisDataAnalyticsMonitoringOptions" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringOptions"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringOptions.Initializer"></a>

```typescript
import { KinesisDataAnalyticsMonitoringOptions } from 'cdk-monitoring-constructs'

const kinesisDataAnalyticsMonitoringOptions: KinesisDataAnalyticsMonitoringOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringOptions.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringOptions.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringOptions.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringOptions.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringOptions.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringOptions.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringOptions.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringOptions.property.addDowntimeAlarm">addDowntimeAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MaxDowntimeThreshold">MaxDowntimeThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringOptions.property.addFullRestartCountAlarm">addFullRestartCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.FullRestartCountThreshold">FullRestartCountThreshold</a>}</code> | *No description.* |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringOptions.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringOptions.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringOptions.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringOptions.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringOptions.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringOptions.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringOptions.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addDowntimeAlarm`<sup>Optional</sup> <a name="addDowntimeAlarm" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringOptions.property.addDowntimeAlarm"></a>

```typescript
public readonly addDowntimeAlarm: {[ key: string ]: MaxDowntimeThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MaxDowntimeThreshold">MaxDowntimeThreshold</a>}

---

##### `addFullRestartCountAlarm`<sup>Optional</sup> <a name="addFullRestartCountAlarm" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringOptions.property.addFullRestartCountAlarm"></a>

```typescript
public readonly addFullRestartCountAlarm: {[ key: string ]: FullRestartCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.FullRestartCountThreshold">FullRestartCountThreshold</a>}

---

### KinesisDataAnalyticsMonitoringProps <a name="KinesisDataAnalyticsMonitoringProps" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.Initializer"></a>

```typescript
import { KinesisDataAnalyticsMonitoringProps } from 'cdk-monitoring-constructs'

const kinesisDataAnalyticsMonitoringProps: KinesisDataAnalyticsMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.property.application">application</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.property.addDowntimeAlarm">addDowntimeAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MaxDowntimeThreshold">MaxDowntimeThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.property.addFullRestartCountAlarm">addFullRestartCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.FullRestartCountThreshold">FullRestartCountThreshold</a>}</code> | *No description.* |

---

##### `application`<sup>Required</sup> <a name="application" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.property.application"></a>

```typescript
public readonly application: string;
```

- *Type:* string

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addDowntimeAlarm`<sup>Optional</sup> <a name="addDowntimeAlarm" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.property.addDowntimeAlarm"></a>

```typescript
public readonly addDowntimeAlarm: {[ key: string ]: MaxDowntimeThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MaxDowntimeThreshold">MaxDowntimeThreshold</a>}

---

##### `addFullRestartCountAlarm`<sup>Optional</sup> <a name="addFullRestartCountAlarm" id="cdk-monitoring-constructs.KinesisDataAnalyticsMonitoringProps.property.addFullRestartCountAlarm"></a>

```typescript
public readonly addFullRestartCountAlarm: {[ key: string ]: FullRestartCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.FullRestartCountThreshold">FullRestartCountThreshold</a>}

---

### KinesisDataStreamMetricFactoryProps <a name="KinesisDataStreamMetricFactoryProps" id="cdk-monitoring-constructs.KinesisDataStreamMetricFactoryProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.KinesisDataStreamMetricFactoryProps.Initializer"></a>

```typescript
import { KinesisDataStreamMetricFactoryProps } from 'cdk-monitoring-constructs'

const kinesisDataStreamMetricFactoryProps: KinesisDataStreamMetricFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMetricFactoryProps.property.streamName">streamName</a></code> | <code>string</code> | *No description.* |

---

##### `streamName`<sup>Required</sup> <a name="streamName" id="cdk-monitoring-constructs.KinesisDataStreamMetricFactoryProps.property.streamName"></a>

```typescript
public readonly streamName: string;
```

- *Type:* string

---

### KinesisDataStreamMonitoringOptions <a name="KinesisDataStreamMonitoringOptions" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.Initializer"></a>

```typescript
import { KinesisDataStreamMonitoringOptions } from 'cdk-monitoring-constructs'

const kinesisDataStreamMonitoringOptions: KinesisDataStreamMonitoringOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.addIteratorMaxAgeAlarm">addIteratorMaxAgeAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MaxIteratorAgeThreshold">MaxIteratorAgeThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.addPutRecordsFailedAlarm">addPutRecordsFailedAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsFailedThreshold">RecordsFailedThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.addPutRecordsThrottledAlarm">addPutRecordsThrottledAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsThrottledThreshold">RecordsThrottledThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.addReadProvisionedThroughputExceededAlarm">addReadProvisionedThroughputExceededAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsThrottledThreshold">RecordsThrottledThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.addThrottledRecordsAlarm">addThrottledRecordsAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsThrottledThreshold">RecordsThrottledThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.addWriteProvisionedThroughputExceededAlarm">addWriteProvisionedThroughputExceededAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsThrottledThreshold">RecordsThrottledThreshold</a>}</code> | *No description.* |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addIteratorMaxAgeAlarm`<sup>Optional</sup> <a name="addIteratorMaxAgeAlarm" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.addIteratorMaxAgeAlarm"></a>

```typescript
public readonly addIteratorMaxAgeAlarm: {[ key: string ]: MaxIteratorAgeThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MaxIteratorAgeThreshold">MaxIteratorAgeThreshold</a>}

---

##### `addPutRecordsFailedAlarm`<sup>Optional</sup> <a name="addPutRecordsFailedAlarm" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.addPutRecordsFailedAlarm"></a>

```typescript
public readonly addPutRecordsFailedAlarm: {[ key: string ]: RecordsFailedThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsFailedThreshold">RecordsFailedThreshold</a>}

---

##### `addPutRecordsThrottledAlarm`<sup>Optional</sup> <a name="addPutRecordsThrottledAlarm" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.addPutRecordsThrottledAlarm"></a>

```typescript
public readonly addPutRecordsThrottledAlarm: {[ key: string ]: RecordsThrottledThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsThrottledThreshold">RecordsThrottledThreshold</a>}

---

##### `addReadProvisionedThroughputExceededAlarm`<sup>Optional</sup> <a name="addReadProvisionedThroughputExceededAlarm" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.addReadProvisionedThroughputExceededAlarm"></a>

```typescript
public readonly addReadProvisionedThroughputExceededAlarm: {[ key: string ]: RecordsThrottledThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsThrottledThreshold">RecordsThrottledThreshold</a>}

---

##### `addThrottledRecordsAlarm`<sup>Optional</sup> <a name="addThrottledRecordsAlarm" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.addThrottledRecordsAlarm"></a>

```typescript
public readonly addThrottledRecordsAlarm: {[ key: string ]: RecordsThrottledThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsThrottledThreshold">RecordsThrottledThreshold</a>}

---

##### `addWriteProvisionedThroughputExceededAlarm`<sup>Optional</sup> <a name="addWriteProvisionedThroughputExceededAlarm" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringOptions.property.addWriteProvisionedThroughputExceededAlarm"></a>

```typescript
public readonly addWriteProvisionedThroughputExceededAlarm: {[ key: string ]: RecordsThrottledThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsThrottledThreshold">RecordsThrottledThreshold</a>}

---

### KinesisDataStreamMonitoringProps <a name="KinesisDataStreamMonitoringProps" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.Initializer"></a>

```typescript
import { KinesisDataStreamMonitoringProps } from 'cdk-monitoring-constructs'

const kinesisDataStreamMonitoringProps: KinesisDataStreamMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.streamName">streamName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.addIteratorMaxAgeAlarm">addIteratorMaxAgeAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MaxIteratorAgeThreshold">MaxIteratorAgeThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.addPutRecordsFailedAlarm">addPutRecordsFailedAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsFailedThreshold">RecordsFailedThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.addPutRecordsThrottledAlarm">addPutRecordsThrottledAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsThrottledThreshold">RecordsThrottledThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.addReadProvisionedThroughputExceededAlarm">addReadProvisionedThroughputExceededAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsThrottledThreshold">RecordsThrottledThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.addThrottledRecordsAlarm">addThrottledRecordsAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsThrottledThreshold">RecordsThrottledThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.addWriteProvisionedThroughputExceededAlarm">addWriteProvisionedThroughputExceededAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsThrottledThreshold">RecordsThrottledThreshold</a>}</code> | *No description.* |

---

##### `streamName`<sup>Required</sup> <a name="streamName" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.streamName"></a>

```typescript
public readonly streamName: string;
```

- *Type:* string

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addIteratorMaxAgeAlarm`<sup>Optional</sup> <a name="addIteratorMaxAgeAlarm" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.addIteratorMaxAgeAlarm"></a>

```typescript
public readonly addIteratorMaxAgeAlarm: {[ key: string ]: MaxIteratorAgeThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MaxIteratorAgeThreshold">MaxIteratorAgeThreshold</a>}

---

##### `addPutRecordsFailedAlarm`<sup>Optional</sup> <a name="addPutRecordsFailedAlarm" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.addPutRecordsFailedAlarm"></a>

```typescript
public readonly addPutRecordsFailedAlarm: {[ key: string ]: RecordsFailedThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsFailedThreshold">RecordsFailedThreshold</a>}

---

##### `addPutRecordsThrottledAlarm`<sup>Optional</sup> <a name="addPutRecordsThrottledAlarm" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.addPutRecordsThrottledAlarm"></a>

```typescript
public readonly addPutRecordsThrottledAlarm: {[ key: string ]: RecordsThrottledThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsThrottledThreshold">RecordsThrottledThreshold</a>}

---

##### `addReadProvisionedThroughputExceededAlarm`<sup>Optional</sup> <a name="addReadProvisionedThroughputExceededAlarm" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.addReadProvisionedThroughputExceededAlarm"></a>

```typescript
public readonly addReadProvisionedThroughputExceededAlarm: {[ key: string ]: RecordsThrottledThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsThrottledThreshold">RecordsThrottledThreshold</a>}

---

##### `addThrottledRecordsAlarm`<sup>Optional</sup> <a name="addThrottledRecordsAlarm" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.addThrottledRecordsAlarm"></a>

```typescript
public readonly addThrottledRecordsAlarm: {[ key: string ]: RecordsThrottledThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsThrottledThreshold">RecordsThrottledThreshold</a>}

---

##### `addWriteProvisionedThroughputExceededAlarm`<sup>Optional</sup> <a name="addWriteProvisionedThroughputExceededAlarm" id="cdk-monitoring-constructs.KinesisDataStreamMonitoringProps.property.addWriteProvisionedThroughputExceededAlarm"></a>

```typescript
public readonly addWriteProvisionedThroughputExceededAlarm: {[ key: string ]: RecordsThrottledThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsThrottledThreshold">RecordsThrottledThreshold</a>}

---

### KinesisFirehoseMetricFactoryProps <a name="KinesisFirehoseMetricFactoryProps" id="cdk-monitoring-constructs.KinesisFirehoseMetricFactoryProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.KinesisFirehoseMetricFactoryProps.Initializer"></a>

```typescript
import { KinesisFirehoseMetricFactoryProps } from 'cdk-monitoring-constructs'

const kinesisFirehoseMetricFactoryProps: KinesisFirehoseMetricFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.KinesisFirehoseMetricFactoryProps.property.deliveryStreamName">deliveryStreamName</a></code> | <code>string</code> | *No description.* |

---

##### `deliveryStreamName`<sup>Required</sup> <a name="deliveryStreamName" id="cdk-monitoring-constructs.KinesisFirehoseMetricFactoryProps.property.deliveryStreamName"></a>

```typescript
public readonly deliveryStreamName: string;
```

- *Type:* string

---

### KinesisFirehoseMonitoringOptions <a name="KinesisFirehoseMonitoringOptions" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringOptions"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringOptions.Initializer"></a>

```typescript
import { KinesisFirehoseMonitoringOptions } from 'cdk-monitoring-constructs'

const kinesisFirehoseMonitoringOptions: KinesisFirehoseMonitoringOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.KinesisFirehoseMonitoringOptions.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.KinesisFirehoseMonitoringOptions.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.KinesisFirehoseMonitoringOptions.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.KinesisFirehoseMonitoringOptions.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.KinesisFirehoseMonitoringOptions.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.KinesisFirehoseMonitoringOptions.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.KinesisFirehoseMonitoringOptions.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.KinesisFirehoseMonitoringOptions.property.addRecordsThrottledAlarm">addRecordsThrottledAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsThrottledThreshold">RecordsThrottledThreshold</a>}</code> | *No description.* |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringOptions.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringOptions.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringOptions.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringOptions.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringOptions.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringOptions.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringOptions.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addRecordsThrottledAlarm`<sup>Optional</sup> <a name="addRecordsThrottledAlarm" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringOptions.property.addRecordsThrottledAlarm"></a>

```typescript
public readonly addRecordsThrottledAlarm: {[ key: string ]: RecordsThrottledThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsThrottledThreshold">RecordsThrottledThreshold</a>}

---

### KinesisFirehoseMonitoringProps <a name="KinesisFirehoseMonitoringProps" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringProps.Initializer"></a>

```typescript
import { KinesisFirehoseMonitoringProps } from 'cdk-monitoring-constructs'

const kinesisFirehoseMonitoringProps: KinesisFirehoseMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.KinesisFirehoseMonitoringProps.property.deliveryStreamName">deliveryStreamName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.KinesisFirehoseMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.KinesisFirehoseMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.KinesisFirehoseMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.KinesisFirehoseMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.KinesisFirehoseMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.KinesisFirehoseMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.KinesisFirehoseMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.KinesisFirehoseMonitoringProps.property.addRecordsThrottledAlarm">addRecordsThrottledAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsThrottledThreshold">RecordsThrottledThreshold</a>}</code> | *No description.* |

---

##### `deliveryStreamName`<sup>Required</sup> <a name="deliveryStreamName" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringProps.property.deliveryStreamName"></a>

```typescript
public readonly deliveryStreamName: string;
```

- *Type:* string

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addRecordsThrottledAlarm`<sup>Optional</sup> <a name="addRecordsThrottledAlarm" id="cdk-monitoring-constructs.KinesisFirehoseMonitoringProps.property.addRecordsThrottledAlarm"></a>

```typescript
public readonly addRecordsThrottledAlarm: {[ key: string ]: RecordsThrottledThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RecordsThrottledThreshold">RecordsThrottledThreshold</a>}

---

### LambdaFunctionMetricFactoryProps <a name="LambdaFunctionMetricFactoryProps" id="cdk-monitoring-constructs.LambdaFunctionMetricFactoryProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.LambdaFunctionMetricFactoryProps.Initializer"></a>

```typescript
import { LambdaFunctionMetricFactoryProps } from 'cdk-monitoring-constructs'

const lambdaFunctionMetricFactoryProps: LambdaFunctionMetricFactoryProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMetricFactoryProps.property.lambdaFunction">lambdaFunction</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMetricFactoryProps.property.fillTpsWithZeroes">fillTpsWithZeroes</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMetricFactoryProps.property.lambdaInsightsEnabled">lambdaInsightsEnabled</a></code> | <code>boolean</code> | Generate dashboard charts for Lambda Insights metrics. |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMetricFactoryProps.property.rateComputationMethod">rateComputationMethod</a></code> | <code><a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a></code> | *No description.* |

---

##### `lambdaFunction`<sup>Required</sup> <a name="lambdaFunction" id="cdk-monitoring-constructs.LambdaFunctionMetricFactoryProps.property.lambdaFunction"></a>

```typescript
public readonly lambdaFunction: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

##### `fillTpsWithZeroes`<sup>Optional</sup> <a name="fillTpsWithZeroes" id="cdk-monitoring-constructs.LambdaFunctionMetricFactoryProps.property.fillTpsWithZeroes"></a>

```typescript
public readonly fillTpsWithZeroes: boolean;
```

- *Type:* boolean
- *Default:* true

---

##### `lambdaInsightsEnabled`<sup>Optional</sup> <a name="lambdaInsightsEnabled" id="cdk-monitoring-constructs.LambdaFunctionMetricFactoryProps.property.lambdaInsightsEnabled"></a>

```typescript
public readonly lambdaInsightsEnabled: boolean;
```

- *Type:* boolean
- *Default:* false

Generate dashboard charts for Lambda Insights metrics.

To enable Lambda Insights on your Lambda function, see
https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-Getting-Started-clouddevelopmentkit.html

---

##### `rateComputationMethod`<sup>Optional</sup> <a name="rateComputationMethod" id="cdk-monitoring-constructs.LambdaFunctionMetricFactoryProps.property.rateComputationMethod"></a>

```typescript
public readonly rateComputationMethod: RateComputationMethod;
```

- *Type:* <a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a>
- *Default:* average

---

### LambdaFunctionMonitoringOptions <a name="LambdaFunctionMonitoringOptions" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.Initializer"></a>

```typescript
import { LambdaFunctionMonitoringOptions } from 'cdk-monitoring-constructs'

const lambdaFunctionMonitoringOptions: LambdaFunctionMonitoringOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addConcurrentExecutionsCountAlarm">addConcurrentExecutionsCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addEnhancedMonitoringAvgCpuTotalTimeAlarm">addEnhancedMonitoringAvgCpuTotalTimeAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addEnhancedMonitoringAvgMemoryUtilizationAlarm">addEnhancedMonitoringAvgMemoryUtilizationAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addEnhancedMonitoringMaxCpuTotalTimeAlarm">addEnhancedMonitoringMaxCpuTotalTimeAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addEnhancedMonitoringMaxMemoryUtilizationAlarm">addEnhancedMonitoringMaxMemoryUtilizationAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addEnhancedMonitoringP90CpuTotalTimeAlarm">addEnhancedMonitoringP90CpuTotalTimeAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addEnhancedMonitoringP90MemoryUtilizationAlarm">addEnhancedMonitoringP90MemoryUtilizationAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addFaultCountAlarm">addFaultCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addFaultRateAlarm">addFaultRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addHighTpsAlarm">addHighTpsAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HighTpsThreshold">HighTpsThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addLatencyP50Alarm">addLatencyP50Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addLatencyP90Alarm">addLatencyP90Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addLatencyP99Alarm">addLatencyP99Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addLowTpsAlarm">addLowTpsAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LowTpsThreshold">LowTpsThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addMaxIteratorAgeAlarm">addMaxIteratorAgeAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MaxAgeThreshold">MaxAgeThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addMinInvocationsCountAlarm">addMinInvocationsCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MinUsageCountThreshold">MinUsageCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addProvisionedConcurrencySpilloverInvocationsCountAlarm">addProvisionedConcurrencySpilloverInvocationsCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addProvisionedConcurrencySpilloverInvocationsRateAlarm">addProvisionedConcurrencySpilloverInvocationsRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskRateThreshold">RunningTaskRateThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addThrottlesCountAlarm">addThrottlesCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addThrottlesRateAlarm">addThrottlesRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addConcurrentExecutionsCountAlarm`<sup>Optional</sup> <a name="addConcurrentExecutionsCountAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addConcurrentExecutionsCountAlarm"></a>

```typescript
public readonly addConcurrentExecutionsCountAlarm: {[ key: string ]: RunningTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}

---

##### `addEnhancedMonitoringAvgCpuTotalTimeAlarm`<sup>Optional</sup> <a name="addEnhancedMonitoringAvgCpuTotalTimeAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addEnhancedMonitoringAvgCpuTotalTimeAlarm"></a>

```typescript
public readonly addEnhancedMonitoringAvgCpuTotalTimeAlarm: {[ key: string ]: DurationThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}

---

##### `addEnhancedMonitoringAvgMemoryUtilizationAlarm`<sup>Optional</sup> <a name="addEnhancedMonitoringAvgMemoryUtilizationAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addEnhancedMonitoringAvgMemoryUtilizationAlarm"></a>

```typescript
public readonly addEnhancedMonitoringAvgMemoryUtilizationAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addEnhancedMonitoringMaxCpuTotalTimeAlarm`<sup>Optional</sup> <a name="addEnhancedMonitoringMaxCpuTotalTimeAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addEnhancedMonitoringMaxCpuTotalTimeAlarm"></a>

```typescript
public readonly addEnhancedMonitoringMaxCpuTotalTimeAlarm: {[ key: string ]: DurationThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}

---

##### `addEnhancedMonitoringMaxMemoryUtilizationAlarm`<sup>Optional</sup> <a name="addEnhancedMonitoringMaxMemoryUtilizationAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addEnhancedMonitoringMaxMemoryUtilizationAlarm"></a>

```typescript
public readonly addEnhancedMonitoringMaxMemoryUtilizationAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addEnhancedMonitoringP90CpuTotalTimeAlarm`<sup>Optional</sup> <a name="addEnhancedMonitoringP90CpuTotalTimeAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addEnhancedMonitoringP90CpuTotalTimeAlarm"></a>

```typescript
public readonly addEnhancedMonitoringP90CpuTotalTimeAlarm: {[ key: string ]: DurationThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}

---

##### `addEnhancedMonitoringP90MemoryUtilizationAlarm`<sup>Optional</sup> <a name="addEnhancedMonitoringP90MemoryUtilizationAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addEnhancedMonitoringP90MemoryUtilizationAlarm"></a>

```typescript
public readonly addEnhancedMonitoringP90MemoryUtilizationAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addFaultCountAlarm`<sup>Optional</sup> <a name="addFaultCountAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addFaultCountAlarm"></a>

```typescript
public readonly addFaultCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `addFaultRateAlarm`<sup>Optional</sup> <a name="addFaultRateAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addFaultRateAlarm"></a>

```typescript
public readonly addFaultRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

##### `addHighTpsAlarm`<sup>Optional</sup> <a name="addHighTpsAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addHighTpsAlarm"></a>

```typescript
public readonly addHighTpsAlarm: {[ key: string ]: HighTpsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HighTpsThreshold">HighTpsThreshold</a>}

---

##### `addLatencyP50Alarm`<sup>Optional</sup> <a name="addLatencyP50Alarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addLatencyP50Alarm"></a>

```typescript
public readonly addLatencyP50Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP90Alarm`<sup>Optional</sup> <a name="addLatencyP90Alarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addLatencyP90Alarm"></a>

```typescript
public readonly addLatencyP90Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP99Alarm`<sup>Optional</sup> <a name="addLatencyP99Alarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addLatencyP99Alarm"></a>

```typescript
public readonly addLatencyP99Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLowTpsAlarm`<sup>Optional</sup> <a name="addLowTpsAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addLowTpsAlarm"></a>

```typescript
public readonly addLowTpsAlarm: {[ key: string ]: LowTpsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LowTpsThreshold">LowTpsThreshold</a>}

---

##### `addMaxIteratorAgeAlarm`<sup>Optional</sup> <a name="addMaxIteratorAgeAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addMaxIteratorAgeAlarm"></a>

```typescript
public readonly addMaxIteratorAgeAlarm: {[ key: string ]: MaxAgeThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MaxAgeThreshold">MaxAgeThreshold</a>}

---

##### `addMinInvocationsCountAlarm`<sup>Optional</sup> <a name="addMinInvocationsCountAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addMinInvocationsCountAlarm"></a>

```typescript
public readonly addMinInvocationsCountAlarm: {[ key: string ]: MinUsageCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MinUsageCountThreshold">MinUsageCountThreshold</a>}

---

##### `addProvisionedConcurrencySpilloverInvocationsCountAlarm`<sup>Optional</sup> <a name="addProvisionedConcurrencySpilloverInvocationsCountAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addProvisionedConcurrencySpilloverInvocationsCountAlarm"></a>

```typescript
public readonly addProvisionedConcurrencySpilloverInvocationsCountAlarm: {[ key: string ]: RunningTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}

---

##### `addProvisionedConcurrencySpilloverInvocationsRateAlarm`<sup>Optional</sup> <a name="addProvisionedConcurrencySpilloverInvocationsRateAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addProvisionedConcurrencySpilloverInvocationsRateAlarm"></a>

```typescript
public readonly addProvisionedConcurrencySpilloverInvocationsRateAlarm: {[ key: string ]: RunningTaskRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskRateThreshold">RunningTaskRateThreshold</a>}

---

##### `addThrottlesCountAlarm`<sup>Optional</sup> <a name="addThrottlesCountAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addThrottlesCountAlarm"></a>

```typescript
public readonly addThrottlesCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `addThrottlesRateAlarm`<sup>Optional</sup> <a name="addThrottlesRateAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringOptions.property.addThrottlesRateAlarm"></a>

```typescript
public readonly addThrottlesRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

### LambdaFunctionMonitoringProps <a name="LambdaFunctionMonitoringProps" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.Initializer"></a>

```typescript
import { LambdaFunctionMonitoringProps } from 'cdk-monitoring-constructs'

const lambdaFunctionMonitoringProps: LambdaFunctionMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.lambdaFunction">lambdaFunction</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.fillTpsWithZeroes">fillTpsWithZeroes</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.lambdaInsightsEnabled">lambdaInsightsEnabled</a></code> | <code>boolean</code> | Generate dashboard charts for Lambda Insights metrics. |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.rateComputationMethod">rateComputationMethod</a></code> | <code><a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a></code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addConcurrentExecutionsCountAlarm">addConcurrentExecutionsCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addEnhancedMonitoringAvgCpuTotalTimeAlarm">addEnhancedMonitoringAvgCpuTotalTimeAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addEnhancedMonitoringAvgMemoryUtilizationAlarm">addEnhancedMonitoringAvgMemoryUtilizationAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addEnhancedMonitoringMaxCpuTotalTimeAlarm">addEnhancedMonitoringMaxCpuTotalTimeAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addEnhancedMonitoringMaxMemoryUtilizationAlarm">addEnhancedMonitoringMaxMemoryUtilizationAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addEnhancedMonitoringP90CpuTotalTimeAlarm">addEnhancedMonitoringP90CpuTotalTimeAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addEnhancedMonitoringP90MemoryUtilizationAlarm">addEnhancedMonitoringP90MemoryUtilizationAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addFaultCountAlarm">addFaultCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addFaultRateAlarm">addFaultRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addHighTpsAlarm">addHighTpsAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.HighTpsThreshold">HighTpsThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addLatencyP50Alarm">addLatencyP50Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addLatencyP90Alarm">addLatencyP90Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addLatencyP99Alarm">addLatencyP99Alarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addLowTpsAlarm">addLowTpsAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.LowTpsThreshold">LowTpsThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addMaxIteratorAgeAlarm">addMaxIteratorAgeAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MaxAgeThreshold">MaxAgeThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addMinInvocationsCountAlarm">addMinInvocationsCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.MinUsageCountThreshold">MinUsageCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addProvisionedConcurrencySpilloverInvocationsCountAlarm">addProvisionedConcurrencySpilloverInvocationsCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addProvisionedConcurrencySpilloverInvocationsRateAlarm">addProvisionedConcurrencySpilloverInvocationsRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskRateThreshold">RunningTaskRateThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addThrottlesCountAlarm">addThrottlesCountAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}</code> | *No description.* |
| <code><a href="#cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addThrottlesRateAlarm">addThrottlesRateAlarm</a></code> | <code>{[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}</code> | *No description.* |

---

##### `lambdaFunction`<sup>Required</sup> <a name="lambdaFunction" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.lambdaFunction"></a>

```typescript
public readonly lambdaFunction: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

##### `fillTpsWithZeroes`<sup>Optional</sup> <a name="fillTpsWithZeroes" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.fillTpsWithZeroes"></a>

```typescript
public readonly fillTpsWithZeroes: boolean;
```

- *Type:* boolean
- *Default:* true

---

##### `lambdaInsightsEnabled`<sup>Optional</sup> <a name="lambdaInsightsEnabled" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.lambdaInsightsEnabled"></a>

```typescript
public readonly lambdaInsightsEnabled: boolean;
```

- *Type:* boolean
- *Default:* false

Generate dashboard charts for Lambda Insights metrics.

To enable Lambda Insights on your Lambda function, see
https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-Getting-Started-clouddevelopmentkit.html

---

##### `rateComputationMethod`<sup>Optional</sup> <a name="rateComputationMethod" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.rateComputationMethod"></a>

```typescript
public readonly rateComputationMethod: RateComputationMethod;
```

- *Type:* <a href="#cdk-monitoring-constructs.RateComputationMethod">RateComputationMethod</a>
- *Default:* average

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `addConcurrentExecutionsCountAlarm`<sup>Optional</sup> <a name="addConcurrentExecutionsCountAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addConcurrentExecutionsCountAlarm"></a>

```typescript
public readonly addConcurrentExecutionsCountAlarm: {[ key: string ]: RunningTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}

---

##### `addEnhancedMonitoringAvgCpuTotalTimeAlarm`<sup>Optional</sup> <a name="addEnhancedMonitoringAvgCpuTotalTimeAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addEnhancedMonitoringAvgCpuTotalTimeAlarm"></a>

```typescript
public readonly addEnhancedMonitoringAvgCpuTotalTimeAlarm: {[ key: string ]: DurationThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}

---

##### `addEnhancedMonitoringAvgMemoryUtilizationAlarm`<sup>Optional</sup> <a name="addEnhancedMonitoringAvgMemoryUtilizationAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addEnhancedMonitoringAvgMemoryUtilizationAlarm"></a>

```typescript
public readonly addEnhancedMonitoringAvgMemoryUtilizationAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addEnhancedMonitoringMaxCpuTotalTimeAlarm`<sup>Optional</sup> <a name="addEnhancedMonitoringMaxCpuTotalTimeAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addEnhancedMonitoringMaxCpuTotalTimeAlarm"></a>

```typescript
public readonly addEnhancedMonitoringMaxCpuTotalTimeAlarm: {[ key: string ]: DurationThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}

---

##### `addEnhancedMonitoringMaxMemoryUtilizationAlarm`<sup>Optional</sup> <a name="addEnhancedMonitoringMaxMemoryUtilizationAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addEnhancedMonitoringMaxMemoryUtilizationAlarm"></a>

```typescript
public readonly addEnhancedMonitoringMaxMemoryUtilizationAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addEnhancedMonitoringP90CpuTotalTimeAlarm`<sup>Optional</sup> <a name="addEnhancedMonitoringP90CpuTotalTimeAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addEnhancedMonitoringP90CpuTotalTimeAlarm"></a>

```typescript
public readonly addEnhancedMonitoringP90CpuTotalTimeAlarm: {[ key: string ]: DurationThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.DurationThreshold">DurationThreshold</a>}

---

##### `addEnhancedMonitoringP90MemoryUtilizationAlarm`<sup>Optional</sup> <a name="addEnhancedMonitoringP90MemoryUtilizationAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addEnhancedMonitoringP90MemoryUtilizationAlarm"></a>

```typescript
public readonly addEnhancedMonitoringP90MemoryUtilizationAlarm: {[ key: string ]: UsageThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.UsageThreshold">UsageThreshold</a>}

---

##### `addFaultCountAlarm`<sup>Optional</sup> <a name="addFaultCountAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addFaultCountAlarm"></a>

```typescript
public readonly addFaultCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `addFaultRateAlarm`<sup>Optional</sup> <a name="addFaultRateAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addFaultRateAlarm"></a>

```typescript
public readonly addFaultRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

##### `addHighTpsAlarm`<sup>Optional</sup> <a name="addHighTpsAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addHighTpsAlarm"></a>

```typescript
public readonly addHighTpsAlarm: {[ key: string ]: HighTpsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.HighTpsThreshold">HighTpsThreshold</a>}

---

##### `addLatencyP50Alarm`<sup>Optional</sup> <a name="addLatencyP50Alarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addLatencyP50Alarm"></a>

```typescript
public readonly addLatencyP50Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP90Alarm`<sup>Optional</sup> <a name="addLatencyP90Alarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addLatencyP90Alarm"></a>

```typescript
public readonly addLatencyP90Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLatencyP99Alarm`<sup>Optional</sup> <a name="addLatencyP99Alarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addLatencyP99Alarm"></a>

```typescript
public readonly addLatencyP99Alarm: {[ key: string ]: LatencyThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LatencyThreshold">LatencyThreshold</a>}

---

##### `addLowTpsAlarm`<sup>Optional</sup> <a name="addLowTpsAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addLowTpsAlarm"></a>

```typescript
public readonly addLowTpsAlarm: {[ key: string ]: LowTpsThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.LowTpsThreshold">LowTpsThreshold</a>}

---

##### `addMaxIteratorAgeAlarm`<sup>Optional</sup> <a name="addMaxIteratorAgeAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addMaxIteratorAgeAlarm"></a>

```typescript
public readonly addMaxIteratorAgeAlarm: {[ key: string ]: MaxAgeThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MaxAgeThreshold">MaxAgeThreshold</a>}

---

##### `addMinInvocationsCountAlarm`<sup>Optional</sup> <a name="addMinInvocationsCountAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addMinInvocationsCountAlarm"></a>

```typescript
public readonly addMinInvocationsCountAlarm: {[ key: string ]: MinUsageCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.MinUsageCountThreshold">MinUsageCountThreshold</a>}

---

##### `addProvisionedConcurrencySpilloverInvocationsCountAlarm`<sup>Optional</sup> <a name="addProvisionedConcurrencySpilloverInvocationsCountAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addProvisionedConcurrencySpilloverInvocationsCountAlarm"></a>

```typescript
public readonly addProvisionedConcurrencySpilloverInvocationsCountAlarm: {[ key: string ]: RunningTaskCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskCountThreshold">RunningTaskCountThreshold</a>}

---

##### `addProvisionedConcurrencySpilloverInvocationsRateAlarm`<sup>Optional</sup> <a name="addProvisionedConcurrencySpilloverInvocationsRateAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addProvisionedConcurrencySpilloverInvocationsRateAlarm"></a>

```typescript
public readonly addProvisionedConcurrencySpilloverInvocationsRateAlarm: {[ key: string ]: RunningTaskRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.RunningTaskRateThreshold">RunningTaskRateThreshold</a>}

---

##### `addThrottlesCountAlarm`<sup>Optional</sup> <a name="addThrottlesCountAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addThrottlesCountAlarm"></a>

```typescript
public readonly addThrottlesCountAlarm: {[ key: string ]: ErrorCountThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorCountThreshold">ErrorCountThreshold</a>}

---

##### `addThrottlesRateAlarm`<sup>Optional</sup> <a name="addThrottlesRateAlarm" id="cdk-monitoring-constructs.LambdaFunctionMonitoringProps.property.addThrottlesRateAlarm"></a>

```typescript
public readonly addThrottlesRateAlarm: {[ key: string ]: ErrorRateThreshold};
```

- *Type:* {[ key: string ]: <a href="#cdk-monitoring-constructs.ErrorRateThreshold">ErrorRateThreshold</a>}

---

### LatencyThreshold <a name="LatencyThreshold" id="cdk-monitoring-constructs.LatencyThreshold"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.LatencyThreshold.Initializer"></a>

```typescript
import { LatencyThreshold } from 'cdk-monitoring-constructs'

const latencyThreshold: LatencyThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.LatencyThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.LatencyThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.LatencyThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.LatencyThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.LatencyThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.LatencyThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.LatencyThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.LatencyThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.LatencyThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.LatencyThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.LatencyThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.LatencyThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.LatencyThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.LatencyThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.LatencyThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.LatencyThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.LatencyThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.LatencyThreshold.property.maxLatency">maxLatency</a></code> | <code>aws-cdk-lib.Duration</code> | *No description.* |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.LatencyThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.LatencyThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.LatencyThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.LatencyThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.LatencyThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.LatencyThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.LatencyThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.LatencyThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.LatencyThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.LatencyThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.LatencyThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.LatencyThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.LatencyThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.LatencyThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, a composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
This composite alarm will be returned as a result and uses the specified alarm actions.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.LatencyThreshold.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.LatencyThreshold.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `treatMissingDataOverride`<sup>Optional</sup> <a name="treatMissingDataOverride" id="cdk-monitoring-constructs.LatencyThreshold.property.treatMissingDataOverride"></a>

```typescript
public readonly treatMissingDataOverride: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData
- *Default:* alarm-specific default

Behaviour in case the metric data is missing.

---

##### `maxLatency`<sup>Required</sup> <a name="maxLatency" id="cdk-monitoring-constructs.LatencyThreshold.property.maxLatency"></a>

```typescript
public readonly maxLatency: Duration;
```

- *Type:* aws-cdk-lib.Duration

---

### LogLevelCountThreshold <a name="LogLevelCountThreshold" id="cdk-monitoring-constructs.LogLevelCountThreshold"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.LogLevelCountThreshold.Initializer"></a>

```typescript
import { LogLevelCountThreshold } from 'cdk-monitoring-constructs'

const logLevelCountThreshold: LogLevelCountThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.LogLevelCountThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.LogLevelCountThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.LogLevelCountThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.LogLevelCountThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.LogLevelCountThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.LogLevelCountThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.LogLevelCountThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.LogLevelCountThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.LogLevelCountThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.LogLevelCountThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.LogLevelCountThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.LogLevelCountThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.LogLevelCountThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.LogLevelCountThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.LogLevelCountThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.LogLevelCountThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.LogLevelCountThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.LogLevelCountThreshold.property.maxLogCount">maxLogCount</a></code> | <code>number</code> | Threshold for the number of logs to alarm on. |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.LogLevelCountThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.LogLevelCountThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.LogLevelCountThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.LogLevelCountThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.LogLevelCountThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.LogLevelCountThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.LogLevelCountThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.LogLevelCountThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.LogLevelCountThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.LogLevelCountThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.LogLevelCountThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.LogLevelCountThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.LogLevelCountThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.LogLevelCountThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, a composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
This composite alarm will be returned as a result and uses the specified alarm actions.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.LogLevelCountThreshold.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.LogLevelCountThreshold.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `treatMissingDataOverride`<sup>Optional</sup> <a name="treatMissingDataOverride" id="cdk-monitoring-constructs.LogLevelCountThreshold.property.treatMissingDataOverride"></a>

```typescript
public readonly treatMissingDataOverride: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData
- *Default:* alarm-specific default

Behaviour in case the metric data is missing.

---

##### `maxLogCount`<sup>Required</sup> <a name="maxLogCount" id="cdk-monitoring-constructs.LogLevelCountThreshold.property.maxLogCount"></a>

```typescript
public readonly maxLogCount: number;
```

- *Type:* number

Threshold for the number of logs to alarm on.

---

### LogMonitoringProps <a name="LogMonitoringProps" id="cdk-monitoring-constructs.LogMonitoringProps"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.LogMonitoringProps.Initializer"></a>

```typescript
import { LogMonitoringProps } from 'cdk-monitoring-constructs'

const logMonitoringProps: LogMonitoringProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.LogMonitoringProps.property.alarmFriendlyName">alarmFriendlyName</a></code> | <code>string</code> | Plain name, used in naming alarms. |
| <code><a href="#cdk-monitoring-constructs.LogMonitoringProps.property.humanReadableName">humanReadableName</a></code> | <code>string</code> | Human-readable name is a freeform string, used as a caption or description. |
| <code><a href="#cdk-monitoring-constructs.LogMonitoringProps.property.localAlarmNamePrefixOverride">localAlarmNamePrefixOverride</a></code> | <code>string</code> | If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. |
| <code><a href="#cdk-monitoring-constructs.LogMonitoringProps.property.addToAlarmDashboard">addToAlarmDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to alarm dashboard. |
| <code><a href="#cdk-monitoring-constructs.LogMonitoringProps.property.addToDetailDashboard">addToDetailDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to detailed dashboard. |
| <code><a href="#cdk-monitoring-constructs.LogMonitoringProps.property.addToSummaryDashboard">addToSummaryDashboard</a></code> | <code>boolean</code> | Flag indicating if the widgets should be added to summary dashboard. |
| <code><a href="#cdk-monitoring-constructs.LogMonitoringProps.property.useCreatedAlarms">useCreatedAlarms</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a></code> | Calls provided function to process all alarms created. |
| <code><a href="#cdk-monitoring-constructs.LogMonitoringProps.property.logGroupName">logGroupName</a></code> | <code>string</code> | name of the log group to analyze for the given pattern. |
| <code><a href="#cdk-monitoring-constructs.LogMonitoringProps.property.pattern">pattern</a></code> | <code>string</code> | pattern to show, e.g. "ERROR". |
| <code><a href="#cdk-monitoring-constructs.LogMonitoringProps.property.limit">limit</a></code> | <code>number</code> | number of log messages to search for. |
| <code><a href="#cdk-monitoring-constructs.LogMonitoringProps.property.title">title</a></code> | <code>string</code> | widget title. |

---

##### `alarmFriendlyName`<sup>Optional</sup> <a name="alarmFriendlyName" id="cdk-monitoring-constructs.LogMonitoringProps.property.alarmFriendlyName"></a>

```typescript
public readonly alarmFriendlyName: string;
```

- *Type:* string
- *Default:* derives name from the construct itself

Plain name, used in naming alarms.

This unique among other resources, and respect the AWS CDK restriction posed on alarm names.
The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

---

##### `humanReadableName`<sup>Optional</sup> <a name="humanReadableName" id="cdk-monitoring-constructs.LogMonitoringProps.property.humanReadableName"></a>

```typescript
public readonly humanReadableName: string;
```

- *Type:* string
- *Default:* use alarmFriendlyName

Human-readable name is a freeform string, used as a caption or description.

There are no limitations on what it can be.

---

##### `localAlarmNamePrefixOverride`<sup>Optional</sup> <a name="localAlarmNamePrefixOverride" id="cdk-monitoring-constructs.LogMonitoringProps.property.localAlarmNamePrefixOverride"></a>

```typescript
public readonly localAlarmNamePrefixOverride: string;
```

- *Type:* string

If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value.

The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

> [AlarmNamingStrategy for more details on alarm name prefixes](AlarmNamingStrategy for more details on alarm name prefixes)

---

##### `addToAlarmDashboard`<sup>Optional</sup> <a name="addToAlarmDashboard" id="cdk-monitoring-constructs.LogMonitoringProps.property.addToAlarmDashboard"></a>

```typescript
public readonly addToAlarmDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to alarm dashboard.

---

##### `addToDetailDashboard`<sup>Optional</sup> <a name="addToDetailDashboard" id="cdk-monitoring-constructs.LogMonitoringProps.property.addToDetailDashboard"></a>

```typescript
public readonly addToDetailDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to detailed dashboard.

---

##### `addToSummaryDashboard`<sup>Optional</sup> <a name="addToSummaryDashboard" id="cdk-monitoring-constructs.LogMonitoringProps.property.addToSummaryDashboard"></a>

```typescript
public readonly addToSummaryDashboard: boolean;
```

- *Type:* boolean
- *Default:* true

Flag indicating if the widgets should be added to summary dashboard.

---

##### `useCreatedAlarms`<sup>Optional</sup> <a name="useCreatedAlarms" id="cdk-monitoring-constructs.LogMonitoringProps.property.useCreatedAlarms"></a>

```typescript
public readonly useCreatedAlarms: IAlarmConsumer;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmConsumer">IAlarmConsumer</a>

Calls provided function to process all alarms created.

---

##### `logGroupName`<sup>Required</sup> <a name="logGroupName" id="cdk-monitoring-constructs.LogMonitoringProps.property.logGroupName"></a>

```typescript
public readonly logGroupName: string;
```

- *Type:* string

name of the log group to analyze for the given pattern.

---

##### `pattern`<sup>Required</sup> <a name="pattern" id="cdk-monitoring-constructs.LogMonitoringProps.property.pattern"></a>

```typescript
public readonly pattern: string;
```

- *Type:* string

pattern to show, e.g. "ERROR".

---

##### `limit`<sup>Optional</sup> <a name="limit" id="cdk-monitoring-constructs.LogMonitoringProps.property.limit"></a>

```typescript
public readonly limit: number;
```

- *Type:* number
- *Default:* 10

number of log messages to search for.

---

##### `title`<sup>Optional</sup> <a name="title" id="cdk-monitoring-constructs.LogMonitoringProps.property.title"></a>

```typescript
public readonly title: string;
```

- *Type:* string
- *Default:* auto-generated title based on the pattern and limit

widget title.

---

### LowConnectionCountThreshold <a name="LowConnectionCountThreshold" id="cdk-monitoring-constructs.LowConnectionCountThreshold"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.LowConnectionCountThreshold.Initializer"></a>

```typescript
import { LowConnectionCountThreshold } from 'cdk-monitoring-constructs'

const lowConnectionCountThreshold: LowConnectionCountThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.LowConnectionCountThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.LowConnectionCountThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.LowConnectionCountThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.LowConnectionCountThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.LowConnectionCountThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.LowConnectionCountThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.LowConnectionCountThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.LowConnectionCountThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.LowConnectionCountThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.LowConnectionCountThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.LowConnectionCountThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.LowConnectionCountThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.LowConnectionCountThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.LowConnectionCountThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.LowConnectionCountThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.LowConnectionCountThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.LowConnectionCountThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.LowConnectionCountThreshold.property.minConnectionCount">minConnectionCount</a></code> | <code>number</code> | *No description.* |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.LowConnectionCountThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.LowConnectionCountThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.LowConnectionCountThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.LowConnectionCountThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.LowConnectionCountThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.LowConnectionCountThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.LowConnectionCountThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.LowConnectionCountThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.LowConnectionCountThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.LowConnectionCountThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.LowConnectionCountThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.LowConnectionCountThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.LowConnectionCountThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.LowConnectionCountThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, a composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
This composite alarm will be returned as a result and uses the specified alarm actions.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.LowConnectionCountThreshold.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.LowConnectionCountThreshold.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `treatMissingDataOverride`<sup>Optional</sup> <a name="treatMissingDataOverride" id="cdk-monitoring-constructs.LowConnectionCountThreshold.property.treatMissingDataOverride"></a>

```typescript
public readonly treatMissingDataOverride: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData
- *Default:* alarm-specific default

Behaviour in case the metric data is missing.

---

##### `minConnectionCount`<sup>Required</sup> <a name="minConnectionCount" id="cdk-monitoring-constructs.LowConnectionCountThreshold.property.minConnectionCount"></a>

```typescript
public readonly minConnectionCount: number;
```

- *Type:* number

---

### LowMessagesPublishedThreshold <a name="LowMessagesPublishedThreshold" id="cdk-monitoring-constructs.LowMessagesPublishedThreshold"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.LowMessagesPublishedThreshold.Initializer"></a>

```typescript
import { LowMessagesPublishedThreshold } from 'cdk-monitoring-constructs'

const lowMessagesPublishedThreshold: LowMessagesPublishedThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.minMessagesPublishedCount">minMessagesPublishedCount</a></code> | <code>number</code> | *No description.* |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public readonly minMetricSamplesToAlarm: number;
```

- *Type:* number
- *Default:* default behaviour - no condition on sample count will be added to the alarm

Specifies how many samples (N) of the metric is needed to trigger the alarm.

If this property is specified, a composite alarm is created of the following:
<ul>
<li>The original alarm, created without this property being used; this alarm will have no actions set.</li>
<li>A secondary alarm, which will monitor the same metric with the N (SampleCount) statistic, checking the sample count.</li>
</ul>
This composite alarm will be returned as a result and uses the specified alarm actions.

---

##### `period`<sup>Optional</sup> <a name="period" id="cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.period"></a>

```typescript
public readonly period: Duration;
```

- *Type:* aws-cdk-lib.Duration
- *Default:* the default specified in MetricFactory

Period override for the metric to alarm on.

---

##### `runbookLink`<sup>Optional</sup> <a name="runbookLink" id="cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.runbookLink"></a>

```typescript
public readonly runbookLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `treatMissingDataOverride`<sup>Optional</sup> <a name="treatMissingDataOverride" id="cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.treatMissingDataOverride"></a>

```typescript
public readonly treatMissingDataOverride: TreatMissingData;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.TreatMissingData
- *Default:* alarm-specific default

Behaviour in case the metric data is missing.

---

##### `minMessagesPublishedCount`<sup>Required</sup> <a name="minMessagesPublishedCount" id="cdk-monitoring-constructs.LowMessagesPublishedThreshold.property.minMessagesPublishedCount"></a>

```typescript
public readonly minMessagesPublishedCount: number;
```

- *Type:* number

---

### LowTpsThreshold <a name="LowTpsThreshold" id="cdk-monitoring-constructs.LowTpsThreshold"></a>

#### Initializer <a name="Initializer" id="cdk-monitoring-constructs.LowTpsThreshold.Initializer"></a>

```typescript
import { LowTpsThreshold } from 'cdk-monitoring-constructs'

const lowTpsThreshold: LowTpsThreshold = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk-monitoring-constructs.LowTpsThreshold.property.actionOverride">actionOverride</a></code> | <code><a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a></code> | Allows to override the default alarm action. |
| <code><a href="#cdk-monitoring-constructs.LowTpsThreshold.property.actionsEnabled">actionsEnabled</a></code> | <code>boolean</code> | Enables the configured CloudWatch alarm ticketing actions. |
| <code><a href="#cdk-monitoring-constructs.LowTpsThreshold.property.alarmDescriptionOverride">alarmDescriptionOverride</a></code> | <code>string</code> | A text included in the generated ticket description body, which fully replaces the generated text. |
| <code><a href="#cdk-monitoring-constructs.LowTpsThreshold.property.alarmNameOverride">alarmNameOverride</a></code> | <code>string</code> | If this is defined, the alarm name is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.LowTpsThreshold.property.comparisonOperatorOverride">comparisonOperatorOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.ComparisonOperator</code> | Comparison operator used to compare actual value against the threshold. |
| <code><a href="#cdk-monitoring-constructs.LowTpsThreshold.property.customParams">customParams</a></code> | <code>{[ key: string ]: any}</code> | This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.LowTpsThreshold.property.customTags">customTags</a></code> | <code>string[]</code> | This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. |
| <code><a href="#cdk-monitoring-constructs.LowTpsThreshold.property.datapointsToAlarm">datapointsToAlarm</a></code> | <code>number</code> | Number of breaches required to transition into an ALARM state. |
| <code><a href="#cdk-monitoring-constructs.LowTpsThreshold.property.dedupeStringOverride">dedupeStringOverride</a></code> | <code>string</code> | If this is defined, the alarm dedupe string is set to this exact value. |
| <code><a href="#cdk-monitoring-constructs.LowTpsThreshold.property.documentationLink">documentationLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.LowTpsThreshold.property.evaluateLowSampleCountPercentile">evaluateLowSampleCountPercentile</a></code> | <code>boolean</code> | Used only for alarms based on percentiles. |
| <code><a href="#cdk-monitoring-constructs.LowTpsThreshold.property.evaluationPeriods">evaluationPeriods</a></code> | <code>number</code> | Number of periods to consider when checking the number of breaching datapoints. |
| <code><a href="#cdk-monitoring-constructs.LowTpsThreshold.property.fillAlarmRange">fillAlarmRange</a></code> | <code>boolean</code> | Indicates whether the alarming range of values should be highlighted in the widget. |
| <code><a href="#cdk-monitoring-constructs.LowTpsThreshold.property.minMetricSamplesToAlarm">minMetricSamplesToAlarm</a></code> | <code>number</code> | Specifies how many samples (N) of the metric is needed to trigger the alarm. |
| <code><a href="#cdk-monitoring-constructs.LowTpsThreshold.property.period">period</a></code> | <code>aws-cdk-lib.Duration</code> | Period override for the metric to alarm on. |
| <code><a href="#cdk-monitoring-constructs.LowTpsThreshold.property.runbookLink">runbookLink</a></code> | <code>string</code> | An optional link included in the generated ticket description body. |
| <code><a href="#cdk-monitoring-constructs.LowTpsThreshold.property.treatMissingDataOverride">treatMissingDataOverride</a></code> | <code>aws-cdk-lib.aws_cloudwatch.TreatMissingData</code> | Behaviour in case the metric data is missing. |
| <code><a href="#cdk-monitoring-constructs.LowTpsThreshold.property.minTps">minTps</a></code> | <code>number</code> | *No description.* |

---

##### `actionOverride`<sup>Optional</sup> <a name="actionOverride" id="cdk-monitoring-constructs.LowTpsThreshold.property.actionOverride"></a>

```typescript
public readonly actionOverride: IAlarmActionStrategy;
```

- *Type:* <a href="#cdk-monitoring-constructs.IAlarmActionStrategy">IAlarmActionStrategy</a>
- *Default:* undefined (default action will be used, if any)

Allows to override the default alarm action.

---

##### `actionsEnabled`<sup>Optional</sup> <a name="actionsEnabled" id="cdk-monitoring-constructs.LowTpsThreshold.property.actionsEnabled"></a>

```typescript
public readonly actionsEnabled: boolean;
```

- *Type:* boolean
- *Default:* the same as monitoring facade default

Enables the configured CloudWatch alarm ticketing actions.

---

##### `alarmDescriptionOverride`<sup>Optional</sup> <a name="alarmDescriptionOverride" id="cdk-monitoring-constructs.LowTpsThreshold.property.alarmDescriptionOverride"></a>

```typescript
public readonly alarmDescriptionOverride: string;
```

- *Type:* string
- *Default:* default auto-generated content only

A text included in the generated ticket description body, which fully replaces the generated text.

---

##### `alarmNameOverride`<sup>Optional</sup> <a name="alarmNameOverride" id="cdk-monitoring-constructs.LowTpsThreshold.property.alarmNameOverride"></a>

```typescript
public readonly alarmNameOverride: string;
```

- *Type:* string

If this is defined, the alarm name is set to this exact value.

Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

---

##### `comparisonOperatorOverride`<sup>Optional</sup> <a name="comparisonOperatorOverride" id="cdk-monitoring-constructs.LowTpsThreshold.property.comparisonOperatorOverride"></a>

```typescript
public readonly comparisonOperatorOverride: ComparisonOperator;
```

- *Type:* aws-cdk-lib.aws_cloudwatch.ComparisonOperator
- *Default:* alarm-specific default

Comparison operator used to compare actual value against the threshold.

---

##### `customParams`<sup>Optional</sup> <a name="customParams" id="cdk-monitoring-constructs.LowTpsThreshold.property.customParams"></a>

```typescript
public readonly customParams: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}
- *Default:* no parameters

This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `customTags`<sup>Optional</sup> <a name="customTags" id="cdk-monitoring-constructs.LowTpsThreshold.property.customTags"></a>

```typescript
public readonly customTags: string[];
```

- *Type:* string[]
- *Default:* no tags

This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

---

##### `datapointsToAlarm`<sup>Optional</sup> <a name="datapointsToAlarm" id="cdk-monitoring-constructs.LowTpsThreshold.property.datapointsToAlarm"></a>

```typescript
public readonly datapointsToAlarm: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of breaches required to transition into an ALARM state.

---

##### `dedupeStringOverride`<sup>Optional</sup> <a name="dedupeStringOverride" id="cdk-monitoring-constructs.LowTpsThreshold.property.dedupeStringOverride"></a>

```typescript
public readonly dedupeStringOverride: string;
```

- *Type:* string
- *Default:* undefined (no override)

If this is defined, the alarm dedupe string is set to this exact value.

Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
Dedupe strings are global and not unique per CTI.

---

##### `documentationLink`<sup>Optional</sup> <a name="documentationLink" id="cdk-monitoring-constructs.LowTpsThreshold.property.documentationLink"></a>

```typescript
public readonly documentationLink: string;
```

- *Type:* string
- *Default:* no additional link will be added

An optional link included in the generated ticket description body.

---

##### `evaluateLowSampleCountPercentile`<sup>Optional</sup> <a name="evaluateLowSampleCountPercentile" id="cdk-monitoring-constructs.LowTpsThreshold.property.evaluateLowSampleCountPercentile"></a>

```typescript
public readonly evaluateLowSampleCountPercentile: boolean;
```

- *Type:* boolean
- *Default:* true

Used only for alarms based on percentiles.

If you specify <code>false</code>, the alarm state does not change during periods with too few data points to be statistically significant.
If you specify <code>true</code>, the alarm is always evaluated and possibly changes state no matter how many data points are available.

---

##### `evaluationPeriods`<sup>Optional</sup> <a name="evaluationPeriods" id="cdk-monitoring-constructs.LowTpsThreshold.property.evaluationPeriods"></a>

```typescript
public readonly evaluationPeriods: number;
```

- *Type:* number
- *Default:* the same as monitoring facade default

Number of periods to consider when checking the number of breaching datapoints.

---

##### `fillAlarmRange`<sup>Optional</sup> <a name="fillAlarmRange" id="cdk-monitoring-constructs.LowTpsThreshold.property.fillAlarmRange"></a>

```typescript
public readonly fillAlarmRange: boolean;
```

- *Type:* boolean
- *Default:* false

Indicates whether the alarming range of values should be highlighted in the widget.

---

##### `minMetricSamplesToAlarm`<sup>Optional</sup> <a name="minMetricSamplesToAlarm" id="cdk-monitoring-constructs.LowTpsThreshold.property.minMetricSamplesToAlarm"></a>

```typescript
public re