import { IAlarmDedupeStringProcessor } from "./IAlarmDedupeStringProcessor";
export interface AlarmNamingInput {
    readonly alarmNameSuffix: string;
    readonly alarmNameOverride?: string;
    readonly alarmDedupeStringSuffix?: string;
    readonly dedupeStringOverride?: string;
    readonly disambiguator?: string;
}
export declare class AlarmNamingStrategy {
    protected readonly globalPrefix: string;
    protected readonly localPrefix: string;
    protected readonly dedupeStringStrategy: IAlarmDedupeStringProcessor;
    constructor(globalPrefix: string, localPrefix: string, dedupeStringStrategy?: IAlarmDedupeStringProcessor);
    /**
     * Alarm name is resolved like this:
     * - If "alarmNameOverride" is defined for an alarm, it will be used as alarm name.
     * - Otherwise, the alarm name will be generated by joining: global prefix, local prefix, alarm name suffix, disambiguator.
     *
     * @param props properties
     */
    getName(props: AlarmNamingInput): string;
    getWidgetLabel(props: AlarmNamingInput): string;
    /**
     * Dedupe string resolved like this:
     * - If "dedupeStringOverride" is defined for an alarm, it will be used as a dedupe string.
     * - If "alarmDedupeStringSuffix" from the alarm factory is defined, "GlobalPrefix-LocalPrefix-AlarmDedupeStringSuffix" will be used as a dedupe string.
     * - Otherwise, the alarm dedupe string will not be set.
     * If a dedupe string strategy is set, it will be used to process the final string.
     *
     * @param props properties
     */
    getDedupeString(props: AlarmNamingInput): string | undefined;
    protected joinDistinct(parts: string[], separator: string): string;
}
