"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlarmNamingStrategy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const IAlarmDedupeStringProcessor_1 = require("./IAlarmDedupeStringProcessor");
const AlarmNamePartSeparator = "-";
const AlarmLabelPartSeparator = " ";
class AlarmNamingStrategy {
    constructor(globalPrefix, localPrefix, dedupeStringStrategy) {
        this.globalPrefix = globalPrefix;
        this.localPrefix = localPrefix;
        this.dedupeStringStrategy =
            dedupeStringStrategy ?? new IAlarmDedupeStringProcessor_1.DoNotModifyDedupeString();
    }
    /**
     * Alarm name is resolved like this:
     * - If "alarmNameOverride" is defined for an alarm, it will be used as alarm name.
     * - Otherwise, the alarm name will be generated by joining: global prefix, local prefix, alarm name suffix, disambiguator.
     *
     * @param props properties
     */
    getName(props) {
        if (props.alarmNameOverride) {
            return props.alarmNameOverride;
        }
        const parts = [
            this.globalPrefix,
            this.localPrefix,
            props.alarmNameSuffix,
        ];
        if (props.disambiguator) {
            parts.push(props.disambiguator);
        }
        return this.joinDistinct(parts, AlarmNamePartSeparator);
    }
    getWidgetLabel(props) {
        // not using global prefix to make the label shorter
        const parts = [this.localPrefix, props.alarmNameSuffix];
        if (props.disambiguator) {
            parts.push(props.disambiguator);
        }
        return this.joinDistinct(parts, AlarmLabelPartSeparator);
    }
    /**
     * Dedupe string resolved like this:
     * - If "dedupeStringOverride" is defined for an alarm, it will be used as a dedupe string.
     * - If "alarmDedupeStringSuffix" from the alarm factory is defined, "GlobalPrefix-LocalPrefix-AlarmDedupeStringSuffix" will be used as a dedupe string.
     * - Otherwise, the alarm dedupe string will not be set.
     * If a dedupe string strategy is set, it will be used to process the final string.
     *
     * @param props properties
     */
    getDedupeString(props) {
        if (props.dedupeStringOverride) {
            return this.dedupeStringStrategy.processDedupeStringOverride(props.dedupeStringOverride);
        }
        if (props.alarmDedupeStringSuffix) {
            // not using disambiguator here as we are still alarming on the same thing
            const parts = [
                this.globalPrefix,
                this.localPrefix,
                props.alarmDedupeStringSuffix,
            ];
            const dedupeString = this.joinDistinct(parts, AlarmNamePartSeparator);
            return this.dedupeStringStrategy.processDedupeString(dedupeString);
        }
        return undefined;
    }
    joinDistinct(parts, separator) {
        return parts.filter((x, i, a) => a.indexOf(x) == i).join(separator);
    }
}
exports.AlarmNamingStrategy = AlarmNamingStrategy;
_a = JSII_RTTI_SYMBOL_1;
AlarmNamingStrategy[_a] = { fqn: "cdk-monitoring-constructs.AlarmNamingStrategy", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQWxhcm1OYW1pbmdTdHJhdGVneS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIkFsYXJtTmFtaW5nU3RyYXRlZ3kudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSwrRUFHdUM7QUFFdkMsTUFBTSxzQkFBc0IsR0FBRyxHQUFHLENBQUM7QUFDbkMsTUFBTSx1QkFBdUIsR0FBRyxHQUFHLENBQUM7QUFVcEMsTUFBYSxtQkFBbUI7SUFLOUIsWUFDRSxZQUFvQixFQUNwQixXQUFtQixFQUNuQixvQkFBa0Q7UUFFbEQsSUFBSSxDQUFDLFlBQVksR0FBRyxZQUFZLENBQUM7UUFDakMsSUFBSSxDQUFDLFdBQVcsR0FBRyxXQUFXLENBQUM7UUFDL0IsSUFBSSxDQUFDLG9CQUFvQjtZQUN2QixvQkFBb0IsSUFBSSxJQUFJLHFEQUF1QixFQUFFLENBQUM7SUFDMUQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNILE9BQU8sQ0FBQyxLQUF1QjtRQUM3QixJQUFJLEtBQUssQ0FBQyxpQkFBaUIsRUFBRTtZQUMzQixPQUFPLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztTQUNoQztRQUVELE1BQU0sS0FBSyxHQUFhO1lBQ3RCLElBQUksQ0FBQyxZQUFZO1lBQ2pCLElBQUksQ0FBQyxXQUFXO1lBQ2hCLEtBQUssQ0FBQyxlQUFlO1NBQ3RCLENBQUM7UUFFRixJQUFJLEtBQUssQ0FBQyxhQUFhLEVBQUU7WUFDdkIsS0FBSyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDLENBQUM7U0FDakM7UUFFRCxPQUFPLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLHNCQUFzQixDQUFDLENBQUM7SUFDMUQsQ0FBQztJQUVELGNBQWMsQ0FBQyxLQUF1QjtRQUNwQyxvREFBb0Q7UUFDcEQsTUFBTSxLQUFLLEdBQWEsQ0FBQyxJQUFJLENBQUMsV0FBVyxFQUFFLEtBQUssQ0FBQyxlQUFlLENBQUMsQ0FBQztRQUVsRSxJQUFJLEtBQUssQ0FBQyxhQUFhLEVBQUU7WUFDdkIsS0FBSyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDLENBQUM7U0FDakM7UUFFRCxPQUFPLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLHVCQUF1QixDQUFDLENBQUM7SUFDM0QsQ0FBQztJQUVEOzs7Ozs7OztPQVFHO0lBQ0gsZUFBZSxDQUFDLEtBQXVCO1FBQ3JDLElBQUksS0FBSyxDQUFDLG9CQUFvQixFQUFFO1lBQzlCLE9BQU8sSUFBSSxDQUFDLG9CQUFvQixDQUFDLDJCQUEyQixDQUMxRCxLQUFLLENBQUMsb0JBQW9CLENBQzNCLENBQUM7U0FDSDtRQUVELElBQUksS0FBSyxDQUFDLHVCQUF1QixFQUFFO1lBQ2pDLDBFQUEwRTtZQUMxRSxNQUFNLEtBQUssR0FBRztnQkFDWixJQUFJLENBQUMsWUFBWTtnQkFDakIsSUFBSSxDQUFDLFdBQVc7Z0JBQ2hCLEtBQUssQ0FBQyx1QkFBdUI7YUFDOUIsQ0FBQztZQUNGLE1BQU0sWUFBWSxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLHNCQUFzQixDQUFDLENBQUM7WUFDdEUsT0FBTyxJQUFJLENBQUMsb0JBQW9CLENBQUMsbUJBQW1CLENBQUMsWUFBWSxDQUFDLENBQUM7U0FDcEU7UUFFRCxPQUFPLFNBQVMsQ0FBQztJQUNuQixDQUFDO0lBRVMsWUFBWSxDQUFDLEtBQWUsRUFBRSxTQUFpQjtRQUN2RCxPQUFPLEtBQUssQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDdEUsQ0FBQzs7QUFwRkgsa0RBcUZDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtcbiAgRG9Ob3RNb2RpZnlEZWR1cGVTdHJpbmcsXG4gIElBbGFybURlZHVwZVN0cmluZ1Byb2Nlc3Nvcixcbn0gZnJvbSBcIi4vSUFsYXJtRGVkdXBlU3RyaW5nUHJvY2Vzc29yXCI7XG5cbmNvbnN0IEFsYXJtTmFtZVBhcnRTZXBhcmF0b3IgPSBcIi1cIjtcbmNvbnN0IEFsYXJtTGFiZWxQYXJ0U2VwYXJhdG9yID0gXCIgXCI7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQWxhcm1OYW1pbmdJbnB1dCB7XG4gIHJlYWRvbmx5IGFsYXJtTmFtZVN1ZmZpeDogc3RyaW5nO1xuICByZWFkb25seSBhbGFybU5hbWVPdmVycmlkZT86IHN0cmluZztcbiAgcmVhZG9ubHkgYWxhcm1EZWR1cGVTdHJpbmdTdWZmaXg/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGRlZHVwZVN0cmluZ092ZXJyaWRlPzogc3RyaW5nO1xuICByZWFkb25seSBkaXNhbWJpZ3VhdG9yPzogc3RyaW5nO1xufVxuXG5leHBvcnQgY2xhc3MgQWxhcm1OYW1pbmdTdHJhdGVneSB7XG4gIHByb3RlY3RlZCByZWFkb25seSBnbG9iYWxQcmVmaXg6IHN0cmluZztcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IGxvY2FsUHJlZml4OiBzdHJpbmc7XG4gIHByb3RlY3RlZCByZWFkb25seSBkZWR1cGVTdHJpbmdTdHJhdGVneTogSUFsYXJtRGVkdXBlU3RyaW5nUHJvY2Vzc29yO1xuXG4gIGNvbnN0cnVjdG9yKFxuICAgIGdsb2JhbFByZWZpeDogc3RyaW5nLFxuICAgIGxvY2FsUHJlZml4OiBzdHJpbmcsXG4gICAgZGVkdXBlU3RyaW5nU3RyYXRlZ3k/OiBJQWxhcm1EZWR1cGVTdHJpbmdQcm9jZXNzb3JcbiAgKSB7XG4gICAgdGhpcy5nbG9iYWxQcmVmaXggPSBnbG9iYWxQcmVmaXg7XG4gICAgdGhpcy5sb2NhbFByZWZpeCA9IGxvY2FsUHJlZml4O1xuICAgIHRoaXMuZGVkdXBlU3RyaW5nU3RyYXRlZ3kgPVxuICAgICAgZGVkdXBlU3RyaW5nU3RyYXRlZ3kgPz8gbmV3IERvTm90TW9kaWZ5RGVkdXBlU3RyaW5nKCk7XG4gIH1cblxuICAvKipcbiAgICogQWxhcm0gbmFtZSBpcyByZXNvbHZlZCBsaWtlIHRoaXM6XG4gICAqIC0gSWYgXCJhbGFybU5hbWVPdmVycmlkZVwiIGlzIGRlZmluZWQgZm9yIGFuIGFsYXJtLCBpdCB3aWxsIGJlIHVzZWQgYXMgYWxhcm0gbmFtZS5cbiAgICogLSBPdGhlcndpc2UsIHRoZSBhbGFybSBuYW1lIHdpbGwgYmUgZ2VuZXJhdGVkIGJ5IGpvaW5pbmc6IGdsb2JhbCBwcmVmaXgsIGxvY2FsIHByZWZpeCwgYWxhcm0gbmFtZSBzdWZmaXgsIGRpc2FtYmlndWF0b3IuXG4gICAqXG4gICAqIEBwYXJhbSBwcm9wcyBwcm9wZXJ0aWVzXG4gICAqL1xuICBnZXROYW1lKHByb3BzOiBBbGFybU5hbWluZ0lucHV0KSB7XG4gICAgaWYgKHByb3BzLmFsYXJtTmFtZU92ZXJyaWRlKSB7XG4gICAgICByZXR1cm4gcHJvcHMuYWxhcm1OYW1lT3ZlcnJpZGU7XG4gICAgfVxuXG4gICAgY29uc3QgcGFydHM6IHN0cmluZ1tdID0gW1xuICAgICAgdGhpcy5nbG9iYWxQcmVmaXgsXG4gICAgICB0aGlzLmxvY2FsUHJlZml4LFxuICAgICAgcHJvcHMuYWxhcm1OYW1lU3VmZml4LFxuICAgIF07XG5cbiAgICBpZiAocHJvcHMuZGlzYW1iaWd1YXRvcikge1xuICAgICAgcGFydHMucHVzaChwcm9wcy5kaXNhbWJpZ3VhdG9yKTtcbiAgICB9XG5cbiAgICByZXR1cm4gdGhpcy5qb2luRGlzdGluY3QocGFydHMsIEFsYXJtTmFtZVBhcnRTZXBhcmF0b3IpO1xuICB9XG5cbiAgZ2V0V2lkZ2V0TGFiZWwocHJvcHM6IEFsYXJtTmFtaW5nSW5wdXQpIHtcbiAgICAvLyBub3QgdXNpbmcgZ2xvYmFsIHByZWZpeCB0byBtYWtlIHRoZSBsYWJlbCBzaG9ydGVyXG4gICAgY29uc3QgcGFydHM6IHN0cmluZ1tdID0gW3RoaXMubG9jYWxQcmVmaXgsIHByb3BzLmFsYXJtTmFtZVN1ZmZpeF07XG5cbiAgICBpZiAocHJvcHMuZGlzYW1iaWd1YXRvcikge1xuICAgICAgcGFydHMucHVzaChwcm9wcy5kaXNhbWJpZ3VhdG9yKTtcbiAgICB9XG5cbiAgICByZXR1cm4gdGhpcy5qb2luRGlzdGluY3QocGFydHMsIEFsYXJtTGFiZWxQYXJ0U2VwYXJhdG9yKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBEZWR1cGUgc3RyaW5nIHJlc29sdmVkIGxpa2UgdGhpczpcbiAgICogLSBJZiBcImRlZHVwZVN0cmluZ092ZXJyaWRlXCIgaXMgZGVmaW5lZCBmb3IgYW4gYWxhcm0sIGl0IHdpbGwgYmUgdXNlZCBhcyBhIGRlZHVwZSBzdHJpbmcuXG4gICAqIC0gSWYgXCJhbGFybURlZHVwZVN0cmluZ1N1ZmZpeFwiIGZyb20gdGhlIGFsYXJtIGZhY3RvcnkgaXMgZGVmaW5lZCwgXCJHbG9iYWxQcmVmaXgtTG9jYWxQcmVmaXgtQWxhcm1EZWR1cGVTdHJpbmdTdWZmaXhcIiB3aWxsIGJlIHVzZWQgYXMgYSBkZWR1cGUgc3RyaW5nLlxuICAgKiAtIE90aGVyd2lzZSwgdGhlIGFsYXJtIGRlZHVwZSBzdHJpbmcgd2lsbCBub3QgYmUgc2V0LlxuICAgKiBJZiBhIGRlZHVwZSBzdHJpbmcgc3RyYXRlZ3kgaXMgc2V0LCBpdCB3aWxsIGJlIHVzZWQgdG8gcHJvY2VzcyB0aGUgZmluYWwgc3RyaW5nLlxuICAgKlxuICAgKiBAcGFyYW0gcHJvcHMgcHJvcGVydGllc1xuICAgKi9cbiAgZ2V0RGVkdXBlU3RyaW5nKHByb3BzOiBBbGFybU5hbWluZ0lucHV0KSB7XG4gICAgaWYgKHByb3BzLmRlZHVwZVN0cmluZ092ZXJyaWRlKSB7XG4gICAgICByZXR1cm4gdGhpcy5kZWR1cGVTdHJpbmdTdHJhdGVneS5wcm9jZXNzRGVkdXBlU3RyaW5nT3ZlcnJpZGUoXG4gICAgICAgIHByb3BzLmRlZHVwZVN0cmluZ092ZXJyaWRlXG4gICAgICApO1xuICAgIH1cblxuICAgIGlmIChwcm9wcy5hbGFybURlZHVwZVN0cmluZ1N1ZmZpeCkge1xuICAgICAgLy8gbm90IHVzaW5nIGRpc2FtYmlndWF0b3IgaGVyZSBhcyB3ZSBhcmUgc3RpbGwgYWxhcm1pbmcgb24gdGhlIHNhbWUgdGhpbmdcbiAgICAgIGNvbnN0IHBhcnRzID0gW1xuICAgICAgICB0aGlzLmdsb2JhbFByZWZpeCxcbiAgICAgICAgdGhpcy5sb2NhbFByZWZpeCxcbiAgICAgICAgcHJvcHMuYWxhcm1EZWR1cGVTdHJpbmdTdWZmaXgsXG4gICAgICBdO1xuICAgICAgY29uc3QgZGVkdXBlU3RyaW5nID0gdGhpcy5qb2luRGlzdGluY3QocGFydHMsIEFsYXJtTmFtZVBhcnRTZXBhcmF0b3IpO1xuICAgICAgcmV0dXJuIHRoaXMuZGVkdXBlU3RyaW5nU3RyYXRlZ3kucHJvY2Vzc0RlZHVwZVN0cmluZyhkZWR1cGVTdHJpbmcpO1xuICAgIH1cblxuICAgIHJldHVybiB1bmRlZmluZWQ7XG4gIH1cblxuICBwcm90ZWN0ZWQgam9pbkRpc3RpbmN0KHBhcnRzOiBzdHJpbmdbXSwgc2VwYXJhdG9yOiBzdHJpbmcpOiBzdHJpbmcge1xuICAgIHJldHVybiBwYXJ0cy5maWx0ZXIoKHgsIGksIGEpID0+IGEuaW5kZXhPZih4KSA9PSBpKS5qb2luKHNlcGFyYXRvcik7XG4gIH1cbn1cbiJdfQ==