"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultAlarmAnnotationStrategy = exports.FillingAlarmAnnotationStrategy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
/**
 * Annotation strategy that fills the annotation provided, using the input and user requirements.
 */
class FillingAlarmAnnotationStrategy {
    createAnnotation(props) {
        return {
            ...this.createAnnotationToFill(props),
            ...(props.fillAlarmRange && {
                fill: this.getAlarmingRangeShade(props),
            }),
            ...(props.overrideAnnotationColor !== undefined && {
                color: props.overrideAnnotationColor,
            }),
            ...(props.overrideAnnotationLabel !== undefined && {
                label: props.overrideAnnotationLabel,
            }),
            ...(props.overrideAnnotationVisibility !== undefined && {
                visible: props.overrideAnnotationVisibility,
            }),
        };
    }
    getAlarmingRangeShade(props) {
        switch (props.comparisonOperator) {
            case aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD:
            case aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD:
            case aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_UPPER_THRESHOLD:
                // Fill background above the annotation line
                return aws_cloudwatch_1.Shading.ABOVE;
            case aws_cloudwatch_1.ComparisonOperator.LESS_THAN_OR_EQUAL_TO_THRESHOLD:
            case aws_cloudwatch_1.ComparisonOperator.LESS_THAN_THRESHOLD:
            case aws_cloudwatch_1.ComparisonOperator.LESS_THAN_LOWER_THRESHOLD:
                // Fill background below the annotation line
                return aws_cloudwatch_1.Shading.BELOW;
            default:
                return undefined;
        }
    }
}
exports.FillingAlarmAnnotationStrategy = FillingAlarmAnnotationStrategy;
_a = JSII_RTTI_SYMBOL_1;
FillingAlarmAnnotationStrategy[_a] = { fqn: "cdk-monitoring-constructs.FillingAlarmAnnotationStrategy", version: "1.27.0" };
/**
 * Default annotation strategy that returns the built-in alarm annotation.
 */
class DefaultAlarmAnnotationStrategy extends FillingAlarmAnnotationStrategy {
    createAnnotationToFill(props) {
        return props.alarm.toAnnotation();
    }
}
exports.DefaultAlarmAnnotationStrategy = DefaultAlarmAnnotationStrategy;
_b = JSII_RTTI_SYMBOL_1;
DefaultAlarmAnnotationStrategy[_b] = { fqn: "cdk-monitoring-constructs.DefaultAlarmAnnotationStrategy", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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