"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DoNotModifyDedupeString = exports.ExtendDedupeString = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Dedupe string processor that adds prefix and/or suffix to the dedupe string.
 */
class ExtendDedupeString {
    constructor(prefix, suffix) {
        this.prefix = prefix ?? "";
        this.suffix = suffix ?? "";
    }
    processDedupeString(dedupeString) {
        return this.prefix + dedupeString + this.suffix;
    }
    processDedupeStringOverride(dedupeString) {
        return this.prefix + dedupeString + this.suffix;
    }
}
exports.ExtendDedupeString = ExtendDedupeString;
_a = JSII_RTTI_SYMBOL_1;
ExtendDedupeString[_a] = { fqn: "cdk-monitoring-constructs.ExtendDedupeString", version: "1.27.0" };
/**
 * Default dedupe strategy - does not add any prefix nor suffix.
 */
class DoNotModifyDedupeString extends ExtendDedupeString {
}
exports.DoNotModifyDedupeString = DoNotModifyDedupeString;
_b = JSII_RTTI_SYMBOL_1;
DoNotModifyDedupeString[_b] = { fqn: "cdk-monitoring-constructs.DoNotModifyDedupeString", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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