"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultipleAlarmActionStrategy = exports.multipleActions = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
function multipleActions(...actions) {
    return new MultipleAlarmActionStrategy(actions);
}
exports.multipleActions = multipleActions;
/**
 * Alarm action strategy that combines multiple actions in the same order as they were given.
 */
class MultipleAlarmActionStrategy {
    constructor(actions) {
        this.actions = actions;
    }
    addAlarmActions(props) {
        this.actions.forEach((action) => action.addAlarmActions(props));
    }
}
exports.MultipleAlarmActionStrategy = MultipleAlarmActionStrategy;
_a = JSII_RTTI_SYMBOL_1;
MultipleAlarmActionStrategy[_a] = { fqn: "cdk-monitoring-constructs.MultipleAlarmActionStrategy", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTXVsdGlwbGVBbGFybUFjdGlvblN0cmF0ZWd5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiTXVsdGlwbGVBbGFybUFjdGlvblN0cmF0ZWd5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBS0EsU0FBZ0IsZUFBZSxDQUFDLEdBQUcsT0FBK0I7SUFDaEUsT0FBTyxJQUFJLDJCQUEyQixDQUFDLE9BQU8sQ0FBQyxDQUFDO0FBQ2xELENBQUM7QUFGRCwwQ0FFQztBQUVEOztHQUVHO0FBQ0gsTUFBYSwyQkFBMkI7SUFHdEMsWUFBWSxPQUErQjtRQUN6QyxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU8sQ0FBQztJQUN6QixDQUFDO0lBRUQsZUFBZSxDQUFDLEtBQStCO1FBQzdDLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLENBQUMsTUFBTSxFQUFFLEVBQUUsQ0FBQyxNQUFNLENBQUMsZUFBZSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDbEUsQ0FBQzs7QUFUSCxrRUFVQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XG4gIEFsYXJtQWN0aW9uU3RyYXRlZ3lQcm9wcyxcbiAgSUFsYXJtQWN0aW9uU3RyYXRlZ3ksXG59IGZyb20gXCIuL0lBbGFybUFjdGlvblN0cmF0ZWd5XCI7XG5cbmV4cG9ydCBmdW5jdGlvbiBtdWx0aXBsZUFjdGlvbnMoLi4uYWN0aW9uczogSUFsYXJtQWN0aW9uU3RyYXRlZ3lbXSkge1xuICByZXR1cm4gbmV3IE11bHRpcGxlQWxhcm1BY3Rpb25TdHJhdGVneShhY3Rpb25zKTtcbn1cblxuLyoqXG4gKiBBbGFybSBhY3Rpb24gc3RyYXRlZ3kgdGhhdCBjb21iaW5lcyBtdWx0aXBsZSBhY3Rpb25zIGluIHRoZSBzYW1lIG9yZGVyIGFzIHRoZXkgd2VyZSBnaXZlbi5cbiAqL1xuZXhwb3J0IGNsYXNzIE11bHRpcGxlQWxhcm1BY3Rpb25TdHJhdGVneSBpbXBsZW1lbnRzIElBbGFybUFjdGlvblN0cmF0ZWd5IHtcbiAgcmVhZG9ubHkgYWN0aW9uczogSUFsYXJtQWN0aW9uU3RyYXRlZ3lbXTtcblxuICBjb25zdHJ1Y3RvcihhY3Rpb25zOiBJQWxhcm1BY3Rpb25TdHJhdGVneVtdKSB7XG4gICAgdGhpcy5hY3Rpb25zID0gYWN0aW9ucztcbiAgfVxuXG4gIGFkZEFsYXJtQWN0aW9ucyhwcm9wczogQWxhcm1BY3Rpb25TdHJhdGVneVByb3BzKTogdm9pZCB7XG4gICAgdGhpcy5hY3Rpb25zLmZvckVhY2goKGFjdGlvbikgPT4gYWN0aW9uLmFkZEFsYXJtQWN0aW9ucyhwcm9wcykpO1xuICB9XG59XG4iXX0=