"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpsItemAlarmActionStrategy = exports.createOpsItem = exports.createLowSeverityOpsItem = exports.createMediumSeverityOpsItem = exports.createHighSeverityOpsItem = exports.createCriticalSeverityOpsItem = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_actions_1 = require("aws-cdk-lib/aws-cloudwatch-actions");
/**
 * Creates an AWS OpsCenter OpsItem with critical severity.
 *
 * @param category optional category (no category by default)
 */
function createCriticalSeverityOpsItem(category) {
    return createOpsItem(aws_cloudwatch_actions_1.OpsItemSeverity.CRITICAL, category);
}
exports.createCriticalSeverityOpsItem = createCriticalSeverityOpsItem;
/**
 * Creates an AWS OpsCenter OpsItem with high severity.
 *
 * @param category optional category (no category by default)
 */
function createHighSeverityOpsItem(category) {
    return createOpsItem(aws_cloudwatch_actions_1.OpsItemSeverity.HIGH, category);
}
exports.createHighSeverityOpsItem = createHighSeverityOpsItem;
/**
 * Creates an AWS OpsCenter OpsItem with medium severity.
 *
 * @param category optional category (no category by default)
 */
function createMediumSeverityOpsItem(category) {
    return createOpsItem(aws_cloudwatch_actions_1.OpsItemSeverity.MEDIUM, category);
}
exports.createMediumSeverityOpsItem = createMediumSeverityOpsItem;
/**
 * Creates an AWS OpsCenter OpsItem with low severity.
 *
 * @param category optional category (no category by default)
 */
function createLowSeverityOpsItem(category) {
    return createOpsItem(aws_cloudwatch_actions_1.OpsItemSeverity.LOW, category);
}
exports.createLowSeverityOpsItem = createLowSeverityOpsItem;
/**
 * Creates an AWS OpsCenter OpsItem.
 *
 * @param severity desired item severity
 * @param category optional category (no category by default)
 */
function createOpsItem(severity, category) {
    return new OpsItemAlarmActionStrategy(severity, category);
}
exports.createOpsItem = createOpsItem;
/**
 * Alarm action strategy that creates an AWS OpsCenter OpsItem.
 */
class OpsItemAlarmActionStrategy {
    constructor(severity, category) {
        this.severity = severity;
        this.category = category;
    }
    addAlarmActions(props) {
        props.alarm.addAlarmAction(new aws_cloudwatch_actions_1.SsmAction(this.severity, this.category));
    }
}
exports.OpsItemAlarmActionStrategy = OpsItemAlarmActionStrategy;
_a = JSII_RTTI_SYMBOL_1;
OpsItemAlarmActionStrategy[_a] = { fqn: "cdk-monitoring-constructs.OpsItemAlarmActionStrategy", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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