"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnomalyDetectionMathExpression = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
/**
 * Captures specific MathExpression for anomaly detection, for which alarm generation is different.
 * Added to overcome certain CDK limitations at the time of writing.
 * @see https://github.com/aws/aws-cdk/issues/10540
 */
class AnomalyDetectionMathExpression extends aws_cloudwatch_1.MathExpression {
    constructor(props) {
        super(props);
    }
    with(props) {
        return new AnomalyDetectionMathExpression({
            expression: this.expression,
            usingMetrics: this.usingMetrics,
            label: props.label ?? this.label,
            color: props.color ?? this.color,
            period: props.period ?? this.period,
        });
    }
    createAlarm(scope, id, props) {
        const alarm = super.createAlarm(scope, id, props);
        // https://github.com/aws/aws-cdk/issues/10540#issuecomment-725222564
        const cfnAlarm = alarm.node.defaultChild;
        cfnAlarm.addPropertyDeletionOverride("Threshold");
        cfnAlarm.metrics.forEach((metric, index) => {
            if (metric.expression) {
                cfnAlarm.thresholdMetricId = metric.id;
            }
            cfnAlarm.addPropertyOverride(`Metrics.${index}.ReturnData`, true);
        });
        return alarm;
    }
}
exports.AnomalyDetectionMathExpression = AnomalyDetectionMathExpression;
_a = JSII_RTTI_SYMBOL_1;
AnomalyDetectionMathExpression[_a] = { fqn: "cdk-monitoring-constructs.AnomalyDetectionMathExpression", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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