"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Monitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * An independent unit of monitoring. This is the base for all monitoring classes with alarm support.
 */
class Monitoring {
    constructor(scope, props) {
        this.scope = scope;
        this.alarms = [];
        this.localAlarmNamePrefixOverride = props?.localAlarmNamePrefixOverride;
    }
    /**
     * Creates a new widget factory.
     */
    createWidgetFactory() {
        return this.scope.createWidgetFactory();
    }
    /**
     * Creates a new metric factory.
     */
    createMetricFactory() {
        return this.scope.createMetricFactory();
    }
    /**
     * Creates a new alarm factory.
     * Alarms created will be named with the given prefix, unless a local name override is present.
     * @param alarmNamePrefix alarm name prefix
     */
    createAlarmFactory(alarmNamePrefix) {
        return this.scope.createAlarmFactory(this.localAlarmNamePrefixOverride ?? alarmNamePrefix);
    }
    /**
     * Adds an alarm.
     * @param alarm alarm to add
     */
    addAlarm(alarm) {
        this.alarms.push(alarm);
    }
    /**
     * Returns all the alarms created.
     */
    createdAlarms() {
        return this.alarms;
    }
    /**
     * Returns widgets for all alarms. These can go to runbook or to service dashboard.
     */
    alarmWidgets() {
        return this.createdAlarms().map((alarm) => this.createWidgetFactory().createAlarmDetailWidget(alarm));
    }
    /**
     * Returns widgets to be placed on the summary dashboard.
     *
     * @default - no widgets.
     */
    summaryWidgets() {
        return [];
    }
}
exports.Monitoring = Monitoring;
_a = JSII_RTTI_SYMBOL_1;
Monitoring[_a] = { fqn: "cdk-monitoring-constructs.Monitoring", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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