"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisAlarmFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
class KinesisAlarmFactory {
    constructor(alarmFactory) {
        this.alarmFactory = alarmFactory;
    }
    addIteratorMaxAgeAlarm(metric, props, disambiguator) {
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxAgeInMillis,
            alarmNameSuffix: "Iterator-Age-Max",
            alarmDescription: `Iterator Max Age is too high.`,
            // we will dedupe any kind of message count issue to the same ticket
            alarmDedupeStringSuffix: "AnyDataStreamIteratorMaxAge",
        });
    }
    addPutRecordsThrottledAlarm(metric, props, disambiguator) {
        const threshold = props.maxRecordsThrottledThreshold;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: threshold,
            alarmNameSuffix: "PutRecordsThrottled",
            alarmDescription: `Number of throttled PutRecords exceeded threshold of ${threshold}`,
            // we will dedupe any kind of message count issue to the same ticket
            alarmDedupeStringSuffix: "PutRecordsThrottled",
        });
    }
    addPutRecordsFailedAlarm(metric, props, disambiguator) {
        const threshold = props.maxRecordsFailedThreshold;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold,
            alarmNameSuffix: "PutRecordsFailed",
            alarmDescription: `Number of failed PutRecords exceeded threshold of ${threshold}`,
            // we will dedupe any kind of message count issue to the same ticket
            alarmDedupeStringSuffix: "PutRecordsFailed",
        });
    }
    addProvisionedReadThroughputExceededAlarm(metric, props, disambiguator) {
        const threshold = props.maxRecordsThrottledThreshold;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold,
            alarmNameSuffix: "ReadThroughputExceeded",
            alarmDescription: `Number of records resulting in read throughput capacity throttling reached the threshold of ${threshold}.`,
        });
    }
    addProvisionedWriteThroughputExceededAlarm(metric, props, disambiguator) {
        const threshold = props.maxRecordsThrottledThreshold;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold,
            alarmNameSuffix: "WriteThroughputExceeded",
            alarmDescription: `Number of records resulting in write throughput capacity throttling reached the threshold of ${threshold}.`,
        });
    }
}
exports.KinesisAlarmFactory = KinesisAlarmFactory;
_a = JSII_RTTI_SYMBOL_1;
KinesisAlarmFactory[_a] = { fqn: "cdk-monitoring-constructs.KinesisAlarmFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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