"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LatencyAlarmFactory = exports.getLatencyTypeLabel = exports.getLatencyTypeExpressionId = exports.getLatencyTypeStatistic = exports.LatencyType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const metric_1 = require("../../metric");
var LatencyType;
(function (LatencyType) {
    LatencyType["P50"] = "P50";
    LatencyType["P70"] = "P70";
    LatencyType["P90"] = "P90";
    LatencyType["P95"] = "P95";
    LatencyType["P99"] = "P99";
    LatencyType["P999"] = "P999";
    LatencyType["P9999"] = "P9999";
    LatencyType["P100"] = "P100";
    LatencyType["TM50"] = "TM50";
    LatencyType["TM70"] = "TM70";
    LatencyType["TM90"] = "TM90";
    LatencyType["TM95"] = "TM95";
    LatencyType["TM99"] = "TM99";
    LatencyType["TM999"] = "TM999";
    LatencyType["TM9999"] = "TM9999";
    LatencyType["AVERAGE"] = "Average";
})(LatencyType = exports.LatencyType || (exports.LatencyType = {}));
function getLatencyTypeStatistic(latencyType) {
    switch (latencyType) {
        case LatencyType.P50:
            return metric_1.MetricStatistic.P50;
        case LatencyType.P70:
            return metric_1.MetricStatistic.P70;
        case LatencyType.P90:
            return metric_1.MetricStatistic.P90;
        case LatencyType.P95:
            return metric_1.MetricStatistic.P95;
        case LatencyType.P99:
            return metric_1.MetricStatistic.P99;
        case LatencyType.P999:
            return metric_1.MetricStatistic.P999;
        case LatencyType.P9999:
            return metric_1.MetricStatistic.P9999;
        case LatencyType.P100:
            return metric_1.MetricStatistic.P100;
        case LatencyType.TM50:
            return metric_1.MetricStatistic.TM50;
        case LatencyType.TM70:
            return metric_1.MetricStatistic.TM70;
        case LatencyType.TM90:
            return metric_1.MetricStatistic.TM90;
        case LatencyType.TM95:
            return metric_1.MetricStatistic.TM95;
        case LatencyType.TM99:
            return metric_1.MetricStatistic.TM99;
        case LatencyType.TM999:
            return metric_1.MetricStatistic.TM999;
        case LatencyType.TM9999:
            return metric_1.MetricStatistic.TM9999;
        case LatencyType.AVERAGE:
            return metric_1.MetricStatistic.AVERAGE;
        default:
            throw new Error("Unsupported latency type (unknown statistic): " + latencyType);
    }
}
exports.getLatencyTypeStatistic = getLatencyTypeStatistic;
function getLatencyTypeExpressionId(latencyType) {
    switch (latencyType) {
        case LatencyType.P50:
        case LatencyType.P70:
        case LatencyType.P90:
        case LatencyType.P95:
        case LatencyType.P99:
        case LatencyType.P999:
        case LatencyType.P9999:
        case LatencyType.P100:
            // remove the P prefix
            return latencyType.substr(1);
        case LatencyType.AVERAGE:
            // making it shorter for backwards compatibility
            return "Avg";
        default:
            // use as-is
            return latencyType;
    }
}
exports.getLatencyTypeExpressionId = getLatencyTypeExpressionId;
function getLatencyTypeLabel(latencyType) {
    const averageSuffix = " (avg: ${AVG})";
    switch (latencyType) {
        case LatencyType.P999:
        case LatencyType.TM999:
            // we need proper decimal here
            return latencyType.replace("999", "99.9") + averageSuffix;
        case LatencyType.P9999:
        case LatencyType.TM9999:
            // we need proper decimal here
            return latencyType.replace("9999", "99.99") + averageSuffix;
        case LatencyType.AVERAGE:
            // no suffix here, since we already have average
            return "Average";
        default:
            // use as-is
            return latencyType + averageSuffix;
    }
}
exports.getLatencyTypeLabel = getLatencyTypeLabel;
class LatencyAlarmFactory {
    constructor(alarmFactory) {
        this.alarmFactory = alarmFactory;
    }
    addLatencyAlarm(metric, latencyType, props, disambiguator) {
        const alarmNameSuffix = `Latency-${latencyType}`;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxLatency.toMilliseconds(),
            alarmNameSuffix,
            // we will dedupe any kind of latency issue to the same ticket
            alarmDedupeStringSuffix: this.alarmFactory
                .shouldUseDefaultDedupeForLatency
                ? "AnyLatency"
                : alarmNameSuffix,
            alarmDescription: `${latencyType} latency is too high.`,
        });
    }
    addIntegrationLatencyAlarm(metric, latencyType, props, disambiguator) {
        const alarmNameSuffix = `IntegrationLatency-${latencyType}`;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxLatency.toMilliseconds(),
            alarmNameSuffix,
            // we will dedupe any kind of latency issue to the same alarm
            alarmDedupeStringSuffix: this.alarmFactory
                .shouldUseDefaultDedupeForLatency
                ? "AnyLatency"
                : alarmNameSuffix,
            alarmDescription: `${latencyType} integration latency is too high.`,
        });
    }
    addDurationAlarm(metric, latencyType, props, disambiguator) {
        const alarmNameSuffix = `Duration-${latencyType}`;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxDuration.toMilliseconds(),
            alarmNameSuffix,
            // we will dedupe any kind of latency issue to the same ticket
            alarmDedupeStringSuffix: this.alarmFactory
                .shouldUseDefaultDedupeForLatency
                ? "AnyDuration"
                : alarmNameSuffix,
            alarmDescription: `${latencyType} duration is too long.`,
        });
    }
    addJvmGarbageCollectionDurationAlarm(metric, latencyType, props, disambiguator) {
        const alarmNameSuffix = `Garbage-Collection-Time-${latencyType}`;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxDuration.toMilliseconds(),
            alarmNameSuffix,
            // we will dedupe any kind of latency issue to the same ticket
            alarmDedupeStringSuffix: this.alarmFactory
                .shouldUseDefaultDedupeForLatency
                ? "AnyDuration"
                : alarmNameSuffix,
            alarmDescription: `${latencyType} duration is too long.`,
        });
    }
}
exports.LatencyAlarmFactory = LatencyAlarmFactory;
_a = JSII_RTTI_SYMBOL_1;
LatencyAlarmFactory[_a] = { fqn: "cdk-monitoring-constructs.LatencyAlarmFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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