"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueueAlarmFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
class QueueAlarmFactory {
    constructor(alarmFactory) {
        this.alarmFactory = alarmFactory;
    }
    addMinQueueMessageCountAlarm(metric, props, disambiguator) {
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.LESS_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.minMessageCount,
            alarmNameSuffix: "Queue-Message-Count-Min",
            alarmDescription: `Number of messages in the queue is too low.`,
            // we will dedupe any kind of message count issue to the same ticket
            alarmDedupeStringSuffix: "AnyQueueMessageCount",
        });
    }
    addMaxQueueMessageCountAlarm(metric, props, disambiguator) {
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxMessageCount,
            alarmNameSuffix: "Queue-Message-Count-Max",
            alarmDescription: `Number of messages in the queue is too high.`,
            // we will dedupe any kind of message count issue to the same ticket
            alarmDedupeStringSuffix: "AnyQueueMessageCount",
        });
    }
    addMaxQueueMessageAgeAlarm(metric, props, disambiguator) {
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxAgeInSeconds,
            alarmNameSuffix: "Queue-Message-Age-Max",
            alarmDescription: `Age of the oldest message in the queue is too high.`,
        });
    }
    addMaxQueueTimeToDrainMessagesAlarm(metric, props, disambiguator) {
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxTimeToDrain.toSeconds(),
            alarmNameSuffix: "Queue-TimeToDrain-Max",
            alarmDescription: `Time to drain messages in the queue is too high.`,
        });
    }
    addMinQueueIncomingMessagesCountAlarm(metric, props, disambiguator) {
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.LESS_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.minIncomingMessagesCount,
            alarmNameSuffix: "Queue-Incoming-Messages-Count-Min",
            alarmDescription: `Number of incoming messages into the queue is too low.`,
        });
    }
    addMaxQueueIncomingMessagesCountAlarm(metric, props, disambiguator) {
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxIncomingMessagesCount,
            alarmNameSuffix: "Queue-Incoming-Messages-Count-Max",
            alarmDescription: `Number of incoming messages into the queue is too high.`,
        });
    }
}
exports.QueueAlarmFactory = QueueAlarmFactory;
_a = JSII_RTTI_SYMBOL_1;
QueueAlarmFactory[_a] = { fqn: "cdk-monitoring-constructs.QueueAlarmFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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