"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ThroughputAlarmFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
class ThroughputAlarmFactory {
    constructor(alarmFactory) {
        this.alarmFactory = alarmFactory;
    }
    addMinProcessedBytesAlarm(metric, props, disambiguator) {
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.LESS_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.minProcessedBytes,
            alarmNameSuffix: "Processed-Bytes-Min",
            alarmDescription: `Minimum number of processed bytes is too low.`,
        });
    }
}
exports.ThroughputAlarmFactory = ThroughputAlarmFactory;
_a = JSII_RTTI_SYMBOL_1;
ThroughputAlarmFactory[_a] = { fqn: "cdk-monitoring-constructs.ThroughputAlarmFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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