"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsageAlarmFactory = exports.UsageType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
var UsageType;
(function (UsageType) {
    UsageType["P50"] = "P50";
    UsageType["P70"] = "P70";
    UsageType["P90"] = "P90";
    UsageType["P99"] = "P99";
    UsageType["P999"] = "P999";
    UsageType["P9999"] = "P9999";
    UsageType["P100"] = "P100";
    UsageType["AVERAGE"] = "Average";
    UsageType["MAX"] = "Maximum";
})(UsageType = exports.UsageType || (exports.UsageType = {}));
class UsageAlarmFactory {
    constructor(alarmFactory) {
        this.alarmFactory = alarmFactory;
    }
    addMinUsageCountAlarm(percentMetric, props, disambiguator) {
        return this.alarmFactory.addAlarm(percentMetric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.LESS_THAN_LOWER_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.minCount,
            alarmNameSuffix: "Usage-Count",
            alarmDescription: "The count is too low.",
        });
    }
    addMaxCpuUsagePercentAlarm(percentMetric, props, disambiguator) {
        return this.alarmFactory.addAlarm(percentMetric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxUsagePercent,
            alarmNameSuffix: "CPU-Usage",
            alarmDescription: "The CPU usage is too high.",
        });
    }
    addMaxMasterCpuUsagePercentAlarm(percentMetric, props, disambiguator) {
        return this.alarmFactory.addAlarm(percentMetric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxUsagePercent,
            alarmNameSuffix: "Master-CPU-Usage",
            alarmDescription: "The master CPU usage is too high.",
        });
    }
    addMaxMemoryUsagePercentAlarm(percentMetric, props, disambiguator) {
        return this.addMemoryUsagePercentAlarm(percentMetric, props, UsageType.MAX, disambiguator);
    }
    addMemoryUsagePercentAlarm(percentMetric, props, usageType, disambiguator) {
        const alarmNameSuffix = usageType === UsageType.MAX
            ? "Memory-Usage"
            : `${usageType}-Memory-Usage`;
        return this.alarmFactory.addAlarm(percentMetric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxUsagePercent,
            alarmNameSuffix,
            alarmDescription: "The memory usage is too high.",
        });
    }
    addMaxMasterMemoryUsagePercentAlarm(percentMetric, props, disambiguator) {
        return this.alarmFactory.addAlarm(percentMetric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxUsagePercent,
            alarmNameSuffix: "Master-Memory-Usage",
            alarmDescription: "The master memory usage is too high.",
        });
    }
    addMaxDiskUsagePercentAlarm(percentMetric, props, disambiguator) {
        return this.alarmFactory.addAlarm(percentMetric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxUsagePercent,
            alarmNameSuffix: "Disk-Usage",
            alarmDescription: "The disk usage is too high.",
        });
    }
    addMaxHeapMemoryAfterGCUsagePercentAlarm(percentMetric, props, disambiguator) {
        return this.alarmFactory.addAlarm(percentMetric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxUsagePercent,
            alarmNameSuffix: "HeapMemoryAfterGC-Usage",
            alarmDescription: "The heap memory after GC usage is too high.",
        });
    }
    addMaxFileDescriptorPercentAlarm(percentMetric, props, disambiguator) {
        return this.alarmFactory.addAlarm(percentMetric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxUsagePercent,
            alarmNameSuffix: "File-Descriptor-Usage",
            alarmDescription: "The file descriptor usage is too high.",
        });
    }
    addMaxThreadCountUsageAlarm(percentMetric, props, disambiguator) {
        return this.alarmFactory.addAlarm(percentMetric, {
            treatMissingData: props.treatMissingDataOverride ?? aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: props.comparisonOperatorOverride ??
                aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxUsageCount,
            alarmNameSuffix: "Thread-Count",
            alarmDescription: "The thread count is too high.",
        });
    }
}
exports.UsageAlarmFactory = UsageAlarmFactory;
_a = JSII_RTTI_SYMBOL_1;
UsageAlarmFactory[_a] = { fqn: "cdk-monitoring-constructs.UsageAlarmFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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