import { GraphWidgetProps, IWidget } from "aws-cdk-lib/aws-cloudwatch";
export declare enum GraphWidgetType {
    LINE = "Line",
    STACKED_AREA = "StackedArea",
    PIE = "Pie",
    BAR = "Bar",
    SINGLE_VALUE = "SingleValue"
}
/**
 * Creates a graph widget of the desired type.
 *
 * @param type graph type (e.g. Pie or Bar)
 * @param props graph widget properties
 */
export declare function createGraphWidget(type: GraphWidgetType, props: GraphWidgetProps): IWidget;
