"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createGraphWidget = exports.GraphWidgetType = void 0;
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
var GraphWidgetType;
(function (GraphWidgetType) {
    GraphWidgetType["LINE"] = "Line";
    GraphWidgetType["STACKED_AREA"] = "StackedArea";
    GraphWidgetType["PIE"] = "Pie";
    GraphWidgetType["BAR"] = "Bar";
    GraphWidgetType["SINGLE_VALUE"] = "SingleValue";
})(GraphWidgetType = exports.GraphWidgetType || (exports.GraphWidgetType = {}));
/**
 * Creates a graph widget of the desired type.
 *
 * @param type graph type (e.g. Pie or Bar)
 * @param props graph widget properties
 */
function createGraphWidget(type, props) {
    switch (type) {
        case GraphWidgetType.LINE:
            return new aws_cloudwatch_1.GraphWidget(props);
        case GraphWidgetType.BAR:
            return new aws_cloudwatch_1.GraphWidget({
                ...props,
                view: aws_cloudwatch_1.GraphWidgetView.BAR,
            });
        case GraphWidgetType.PIE:
            return new aws_cloudwatch_1.GraphWidget({
                ...props,
                view: aws_cloudwatch_1.GraphWidgetView.PIE,
            });
        case GraphWidgetType.STACKED_AREA:
            return new aws_cloudwatch_1.GraphWidget({
                ...props,
                stacked: true,
            });
        case GraphWidgetType.SINGLE_VALUE:
            return new aws_cloudwatch_1.SingleValueWidget({
                metrics: [...(props.left ?? []), ...(props.right ?? [])],
            });
        default:
            throw new Error(`Unsupported graph type: ${type}`);
    }
}
exports.createGraphWidget = createGraphWidget;
//# sourceMappingURL=data:application/json;base64,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