import { Duration } from "aws-cdk-lib";
import { Dashboard, DashboardProps, PeriodOverride } from "aws-cdk-lib/aws-cloudwatch";
import { Construct } from "constructs";
import { IDashboardFactory, IDashboardFactoryProps } from "./IDashboardFactory";
/**
 * Preferred way of rendering the widgets.
 */
export declare enum DashboardRenderingPreference {
    /**
     * create standard set of dashboards with interactive widgets only
     */
    INTERACTIVE_ONLY = 0,
    /**
     * create standard set of dashboards with bitmap widgets only
     */
    BITMAP_ONLY = 1,
    /**
     * create a two sets of dashboards: standard set (interactive) and a copy (bitmap)
     */
    INTERACTIVE_AND_BITMAP = 2
}
export interface MonitoringDashboardsProps {
    /**
     * Prefix added to each dashboard name.
     * This allows to have all dashboards sorted close to each other and also separate multiple monitoring facades.
     */
    readonly dashboardNamePrefix: string;
    /**
     * Range of the detail dashboard (and other auxiliary dashboards).
     * @default - 8 hours
     * @see DefaultDetailDashboardRange
     */
    readonly detailDashboardRange?: Duration;
    /**
     * Period override for the detail dashboard (and other auxiliary dashboards).
     * @default - respect individual graphs (PeriodOverride.INHERIT)
     */
    readonly detailDashboardPeriodOverride?: PeriodOverride;
    /**
     * Range of the summary dashboard.
     * @default - 14 days
     */
    readonly summaryDashboardRange?: Duration;
    /**
     * Period override for the summary dashboard.
     * @default - respect individual graphs (PeriodOverride.INHERIT)
     */
    readonly summaryDashboardPeriodOverride?: PeriodOverride;
    /**
     * Flag indicating whether the default dashboard should be created.
     * This is independent on other create dashboard flags.
     *
     * @default - true
     */
    readonly createDashboard?: boolean;
    /**
     * Flag indicating whether the summary dashboard should be created.
     * This is independent on other create dashboard flags.
     *
     * @default - false
     */
    readonly createSummaryDashboard?: boolean;
    /**
     * Flag indicating whether the alarm dashboard should be created.
     * This is independent on other create dashboard flags.
     *
     * @default - false
     */
    readonly createAlarmDashboard?: boolean;
    /**
     * Dashboard rendering preference.
     *
     * @default - DashboardRenderingPreference.INTERACTIVE_ONLY
     */
    readonly renderingPreference?: DashboardRenderingPreference;
}
export declare class DefaultDashboardFactory extends Construct implements IDashboardFactory {
    readonly dashboard?: Dashboard;
    readonly summaryDashboard?: Dashboard;
    readonly alarmDashboard?: Dashboard;
    readonly anyDashboardCreated: boolean;
    constructor(scope: Construct, id: string, props: MonitoringDashboardsProps);
    protected createDashboard(renderingPreference: DashboardRenderingPreference, id: string, props: DashboardProps): Dashboard;
    addSegment(props: IDashboardFactoryProps): void;
    createdDashboard(): Dashboard | undefined;
    createdSummaryDashboard(): Dashboard | undefined;
    createdAlarmDashboard(): Dashboard | undefined;
}
