"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultDashboardFactory = exports.DashboardRenderingPreference = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const constructs_1 = require("constructs");
const BitmapDashboard_1 = require("./BitmapDashboard");
const DashboardWithBitmapCopy_1 = require("./DashboardWithBitmapCopy");
/**
 * Preferred way of rendering the widgets.
 */
var DashboardRenderingPreference;
(function (DashboardRenderingPreference) {
    /**
     * create standard set of dashboards with interactive widgets only
     */
    DashboardRenderingPreference[DashboardRenderingPreference["INTERACTIVE_ONLY"] = 0] = "INTERACTIVE_ONLY";
    /**
     * create standard set of dashboards with bitmap widgets only
     */
    DashboardRenderingPreference[DashboardRenderingPreference["BITMAP_ONLY"] = 1] = "BITMAP_ONLY";
    /**
     * create a two sets of dashboards: standard set (interactive) and a copy (bitmap)
     */
    DashboardRenderingPreference[DashboardRenderingPreference["INTERACTIVE_AND_BITMAP"] = 2] = "INTERACTIVE_AND_BITMAP";
})(DashboardRenderingPreference = exports.DashboardRenderingPreference || (exports.DashboardRenderingPreference = {}));
class DefaultDashboardFactory extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const createDashboard = props.createDashboard ?? true;
        const createSummaryDashboard = props.createSummaryDashboard ?? false;
        const createAlarmDashboard = props.createAlarmDashboard ?? false;
        const shouldCreateDashboards = createDashboard || createAlarmDashboard || createSummaryDashboard;
        if (shouldCreateDashboards && !props.dashboardNamePrefix) {
            throw Error("A non-empty dashboardNamePrefix is required if dashboards are being created");
        }
        const renderingPreference = props.renderingPreference ??
            DashboardRenderingPreference.INTERACTIVE_ONLY;
        const detailStart = "-" + (props.detailDashboardRange ?? aws_cdk_lib_1.Duration.hours(8)).toIsoString();
        const summaryStart = "-" + (props.summaryDashboardRange ?? aws_cdk_lib_1.Duration.days(14)).toIsoString();
        let anyDashboardCreated = false;
        if (createDashboard) {
            anyDashboardCreated = true;
            this.dashboard = this.createDashboard(renderingPreference, "Dashboard", {
                dashboardName: props.dashboardNamePrefix,
                start: detailStart,
                periodOverride: props.detailDashboardPeriodOverride ?? aws_cloudwatch_1.PeriodOverride.INHERIT,
            });
        }
        if (createSummaryDashboard) {
            anyDashboardCreated = true;
            this.summaryDashboard = this.createDashboard(renderingPreference, "SummaryDashboard", {
                dashboardName: `${props.dashboardNamePrefix}-Summary`,
                start: summaryStart,
                periodOverride: props.summaryDashboardPeriodOverride ?? aws_cloudwatch_1.PeriodOverride.INHERIT,
            });
        }
        if (createAlarmDashboard) {
            anyDashboardCreated = true;
            this.alarmDashboard = this.createDashboard(renderingPreference, "AlarmDashboard", {
                dashboardName: `${props.dashboardNamePrefix}-Alarms`,
                start: detailStart,
                periodOverride: props.detailDashboardPeriodOverride ?? aws_cloudwatch_1.PeriodOverride.INHERIT,
            });
        }
        this.anyDashboardCreated = anyDashboardCreated;
    }
    createDashboard(renderingPreference, id, props) {
        switch (renderingPreference) {
            case DashboardRenderingPreference.INTERACTIVE_ONLY:
                return new aws_cloudwatch_1.Dashboard(this, id, props);
            case DashboardRenderingPreference.BITMAP_ONLY:
                return new BitmapDashboard_1.BitmapDashboard(this, id, props);
            case DashboardRenderingPreference.INTERACTIVE_AND_BITMAP:
                return new DashboardWithBitmapCopy_1.DashboardWithBitmapCopy(this, id, props);
        }
    }
    addSegment(props) {
        if ((props.overrideProps?.addToDetailDashboard ?? true) && this.dashboard) {
            this.dashboard.addWidgets(...props.segment.widgets());
        }
        if ((props.overrideProps?.addToSummaryDashboard ?? true) &&
            this.summaryDashboard) {
            this.summaryDashboard.addWidgets(...props.segment.summaryWidgets());
        }
        if ((props.overrideProps?.addToAlarmDashboard ?? true) &&
            this.alarmDashboard) {
            this.alarmDashboard.addWidgets(...props.segment.alarmWidgets());
        }
    }
    createdDashboard() {
        return this.dashboard;
    }
    createdSummaryDashboard() {
        return this.summaryDashboard;
    }
    createdAlarmDashboard() {
        return this.alarmDashboard;
    }
}
exports.DefaultDashboardFactory = DefaultDashboardFactory;
_a = JSII_RTTI_SYMBOL_1;
DefaultDashboardFactory[_a] = { fqn: "cdk-monitoring-constructs.DefaultDashboardFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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