"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HeaderWidget = exports.HeaderLevel = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const widget_1 = require("../../common/widget");
var HeaderLevel;
(function (HeaderLevel) {
    HeaderLevel[HeaderLevel["LARGE"] = 0] = "LARGE";
    HeaderLevel[HeaderLevel["MEDIUM"] = 1] = "MEDIUM";
    HeaderLevel[HeaderLevel["SMALL"] = 2] = "SMALL";
})(HeaderLevel = exports.HeaderLevel || (exports.HeaderLevel = {}));
class HeaderWidget extends aws_cloudwatch_1.TextWidget {
    constructor(text, level) {
        super({
            width: widget_1.FullWidth,
            height: 1,
            markdown: HeaderWidget.toMarkdown(text, level ?? HeaderLevel.LARGE),
        });
    }
    static toMarkdown(text, level) {
        return "#".repeat(level + 1) + " " + text;
    }
}
exports.HeaderWidget = HeaderWidget;
_a = JSII_RTTI_SYMBOL_1;
HeaderWidget[_a] = { fqn: "cdk-monitoring-constructs.HeaderWidget", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiSGVhZGVyV2lkZ2V0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiSGVhZGVyV2lkZ2V0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsK0RBQXdEO0FBRXhELGdEQUFnRDtBQUVoRCxJQUFZLFdBSVg7QUFKRCxXQUFZLFdBQVc7SUFDckIsK0NBQUssQ0FBQTtJQUNMLGlEQUFNLENBQUE7SUFDTiwrQ0FBSyxDQUFBO0FBQ1AsQ0FBQyxFQUpXLFdBQVcsR0FBWCxtQkFBVyxLQUFYLG1CQUFXLFFBSXRCO0FBRUQsTUFBYSxZQUFhLFNBQVEsMkJBQVU7SUFDMUMsWUFBWSxJQUFZLEVBQUUsS0FBbUI7UUFDM0MsS0FBSyxDQUFDO1lBQ0osS0FBSyxFQUFFLGtCQUFTO1lBQ2hCLE1BQU0sRUFBRSxDQUFDO1lBQ1QsUUFBUSxFQUFFLFlBQVksQ0FBQyxVQUFVLENBQUMsSUFBSSxFQUFFLEtBQUssSUFBSSxXQUFXLENBQUMsS0FBSyxDQUFDO1NBQ3BFLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFTyxNQUFNLENBQUMsVUFBVSxDQUFDLElBQVksRUFBRSxLQUFrQjtRQUN4RCxPQUFPLEdBQUcsQ0FBQyxNQUFNLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQyxHQUFHLEdBQUcsR0FBRyxJQUFJLENBQUM7SUFDNUMsQ0FBQzs7QUFYSCxvQ0FZQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFRleHRXaWRnZXQgfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWNsb3Vkd2F0Y2hcIjtcblxuaW1wb3J0IHsgRnVsbFdpZHRoIH0gZnJvbSBcIi4uLy4uL2NvbW1vbi93aWRnZXRcIjtcblxuZXhwb3J0IGVudW0gSGVhZGVyTGV2ZWwge1xuICBMQVJHRSxcbiAgTUVESVVNLFxuICBTTUFMTCxcbn1cblxuZXhwb3J0IGNsYXNzIEhlYWRlcldpZGdldCBleHRlbmRzIFRleHRXaWRnZXQge1xuICBjb25zdHJ1Y3Rvcih0ZXh0OiBzdHJpbmcsIGxldmVsPzogSGVhZGVyTGV2ZWwpIHtcbiAgICBzdXBlcih7XG4gICAgICB3aWR0aDogRnVsbFdpZHRoLFxuICAgICAgaGVpZ2h0OiAxLFxuICAgICAgbWFya2Rvd246IEhlYWRlcldpZGdldC50b01hcmtkb3duKHRleHQsIGxldmVsID8/IEhlYWRlckxldmVsLkxBUkdFKSxcbiAgICB9KTtcbiAgfVxuXG4gIHByaXZhdGUgc3RhdGljIHRvTWFya2Rvd24odGV4dDogc3RyaW5nLCBsZXZlbDogSGVhZGVyTGV2ZWwpIHtcbiAgICByZXR1cm4gXCIjXCIucmVwZWF0KGxldmVsICsgMSkgKyBcIiBcIiArIHRleHQ7XG4gIH1cbn1cbiJdfQ==