import { CompositeAlarm, Dashboard, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { Construct } from "constructs";
import { AddCompositeAlarmProps, AlarmFactory, AlarmFactoryDefaults, AlarmWithAnnotation, AwsConsoleUrlFactory, MetricFactory, MetricFactoryDefaults, Monitoring, MonitoringScope } from "../common";
import { IDashboardFactory, IDashboardSegment, IWidgetFactory, MonitoringDashboardsOverrideProps } from "../dashboard";
import { ApiGatewayMonitoringProps, ApiGatewayV2HttpApiMonitoringProps, AppSyncMonitoringProps, AutoScalingGroupMonitoringProps, BillingMonitoringProps, CertificateManagerMonitoringProps, CloudFrontDistributionMonitoringProps, CodeBuildProjectMonitoringProps, CustomMonitoringProps, DocumentDbMonitoringProps, DynamoTableGlobalSecondaryIndexMonitoringProps, DynamoTableMonitoringProps, Ec2ApplicationLoadBalancerMonitoringProps, EC2MonitoringProps, Ec2NetworkLoadBalancerMonitoringProps, Ec2ServiceMonitoringProps, ElastiCacheClusterMonitoringProps, FargateApplicationLoadBalancerMonitoringProps, FargateNetworkLoadBalancerMonitoringProps, FargateServiceMonitoringProps, GlueJobMonitoringProps, KinesisDataAnalyticsMonitoringProps, KinesisDataStreamMonitoringProps, KinesisFirehoseMonitoringProps, LambdaFunctionMonitoringProps, LogMonitoringProps, NetworkLoadBalancerMonitoringProps, OpenSearchClusterMonitoringProps, QueueProcessingEc2ServiceMonitoringProps, QueueProcessingFargateServiceMonitoringProps, RdsClusterMonitoringProps, RedshiftClusterMonitoringProps, S3BucketMonitoringProps, SecretsManagerSecretMonitoringProps, SimpleEc2ServiceMonitoringProps, SimpleFargateServiceMonitoringProps, SnsTopicMonitoringProps, SqsQueueMonitoringProps, SqsQueueMonitoringWithDlqProps, StepFunctionActivityMonitoringProps, StepFunctionLambdaIntegrationMonitoringProps, StepFunctionMonitoringProps, StepFunctionServiceIntegrationMonitoringProps, SyntheticsCanaryMonitoringProps, WafV2MonitoringProps } from "../monitoring";
import { MonitoringAspectProps } from "./MonitoringAspect";
export interface MonitoringFacadeProps {
    /**
     * Defaults for metric factory.
     * @default - empty (no preferences)
     */
    readonly metricFactoryDefaults?: MetricFactoryDefaults;
    /**
     * Defaults for alarm factory.
     * @default - actions enabled, facade logical ID used as default alarm name prefix
     */
    readonly alarmFactoryDefaults?: AlarmFactoryDefaults;
    /**
     * Defaults for dashboard factory.
     * @default - `DefaultDashboardFactory`; facade logical ID used as default name
     */
    readonly dashboardFactory?: IDashboardFactory;
}
/**
 * Main entry point to create your monitoring.
 */
export declare class MonitoringFacade extends MonitoringScope {
    protected readonly metricFactoryDefaults: MetricFactoryDefaults;
    protected readonly alarmFactoryDefaults: AlarmFactoryDefaults;
    protected readonly dashboardFactory?: IDashboardFactory;
    protected readonly createdSegments: IDashboardSegment[];
    constructor(scope: Construct, id: string, props?: MonitoringFacadeProps);
    private static getDefaultMetricFactoryDefaults;
    private static getDefaultAlarmFactoryDefaults;
    private static getDefaultDashboardFactory;
    createAlarmFactory(alarmNamePrefix: string): AlarmFactory;
    createAwsConsoleUrlFactory(): AwsConsoleUrlFactory;
    createMetricFactory(): MetricFactory;
    createWidgetFactory(): IWidgetFactory;
    createdDashboard(): Dashboard | undefined;
    createdSummaryDashboard(): Dashboard | undefined;
    createdAlarmDashboard(): Dashboard | undefined;
    /**
     * Returns the created alarms across all the monitorings added up until now.
     */
    createdAlarms(): AlarmWithAnnotation[];
    /**
     * Returns a subset of created alarms that are marked by a specific custom tag.
     * @param customTag tag to filter alarms by
     */
    createdAlarmsWithTag(customTag: string): AlarmWithAnnotation[];
    /**
     * Returns a subset of created alarms that are marked by a specific disambiguator.
     * @param disambiguator disambiguator to filter alarms by
     */
    createdAlarmsWithDisambiguator(disambiguator: string): AlarmWithAnnotation[];
    /**
     * Finds a subset of created alarms that are marked by a specific custom tag and creates a composite alarm.
     * This composite alarm is created with an 'OR' condition, so it triggers with any child alarm.
     * NOTE: This composite alarm is not added among other alarms, so it is not returned by createdAlarms() calls.
     *
     * @param customTag tag to filter alarms by
     * @param props customization options
     */
    createCompositeAlarmUsingTag(customTag: string, props?: AddCompositeAlarmProps): CompositeAlarm | undefined;
    /**
     * Finds a subset of created alarms that are marked by a specific disambiguator and creates a composite alarm.
     * This composite alarm is created with an 'OR' condition, so it triggers with any child alarm.
     * NOTE: This composite alarm is not added among other alarms, so it is not returned by createdAlarms() calls.
     *
     * @param alarmDisambiguator disambiguator to filter alarms by
     * @param props customization options
     */
    createCompositeAlarmUsingDisambiguator(alarmDisambiguator: string, props?: AddCompositeAlarmProps): CompositeAlarm | undefined;
    /**
     * Returns the created monitorings added up until now.
     */
    createdMonitorings(): Monitoring[];
    addSegment(segment: IDashboardSegment, overrideProps?: MonitoringDashboardsOverrideProps): this;
    addLargeHeader(text: string, addToSummary?: boolean, addToAlarm?: boolean): this;
    addMediumHeader(text: string, addToSummary?: boolean, addToAlarm?: boolean): this;
    addSmallHeader(text: string, addToSummary?: boolean, addToAlarm?: boolean): this;
    addWidget(widget: IWidget, addToSummary?: boolean, addToAlarm?: boolean): this;
    monitorApiGateway(props: ApiGatewayMonitoringProps): this;
    monitorApiGatewayV2HttpApi(props: ApiGatewayV2HttpApiMonitoringProps): this;
    monitorAppSyncApi(props: AppSyncMonitoringProps): this;
    monitorCertificate(props: CertificateManagerMonitoringProps): this;
    monitorCloudFrontDistribution(props: CloudFrontDistributionMonitoringProps): this;
    monitorCodeBuildProject(props: CodeBuildProjectMonitoringProps): this;
    monitorDocumentDbCluster(props: DocumentDbMonitoringProps): this;
    monitorDynamoTable(props: DynamoTableMonitoringProps): this;
    monitorDynamoTableGlobalSecondaryIndex(props: DynamoTableGlobalSecondaryIndexMonitoringProps): this;
    monitorEC2Instances(props: EC2MonitoringProps): this;
    monitorElasticsearchCluster(props: OpenSearchClusterMonitoringProps): this;
    monitorOpenSearchCluster(props: OpenSearchClusterMonitoringProps): this;
    monitorElastiCacheCluster(props: ElastiCacheClusterMonitoringProps): this;
    monitorGlueJob(props: GlueJobMonitoringProps): this;
    monitorFargateService(props: FargateServiceMonitoringProps): this;
    monitorSimpleFargateService(props: SimpleFargateServiceMonitoringProps): this;
    monitorFargateNetworkLoadBalancer(props: FargateNetworkLoadBalancerMonitoringProps): this;
    monitorFargateApplicationLoadBalancer(props: FargateApplicationLoadBalancerMonitoringProps): this;
    monitorEc2Service(props: Ec2ServiceMonitoringProps): this;
    monitorSimpleEc2Service(props: SimpleEc2ServiceMonitoringProps): this;
    monitorEc2NetworkLoadBalancer(props: Ec2NetworkLoadBalancerMonitoringProps): this;
    monitorEc2ApplicationLoadBalancer(props: Ec2ApplicationLoadBalancerMonitoringProps): this;
    monitorQueueProcessingFargateService(props: QueueProcessingFargateServiceMonitoringProps): this;
    monitorQueueProcessingEc2Service(props: QueueProcessingEc2ServiceMonitoringProps): this;
    monitorAutoScalingGroup(props: AutoScalingGroupMonitoringProps): this;
    monitorKinesisFirehose(props: KinesisFirehoseMonitoringProps): this;
    monitorKinesisDataStream(props: KinesisDataStreamMonitoringProps): this;
    monitorKinesisDataAnalytics(props: KinesisDataAnalyticsMonitoringProps): this;
    monitorLambdaFunction(props: LambdaFunctionMonitoringProps): this;
    monitorNetworkLoadBalancer(props: NetworkLoadBalancerMonitoringProps): this;
    monitorRdsCluster(props: RdsClusterMonitoringProps): this;
    monitorRedshiftCluster(props: RedshiftClusterMonitoringProps): this;
    monitorSecretsManagerSecret(props: SecretsManagerSecretMonitoringProps): this;
    monitorSnsTopic(props: SnsTopicMonitoringProps): this;
    monitorSqsQueue(props: SqsQueueMonitoringProps): this;
    monitorSqsQueueWithDlq(props: SqsQueueMonitoringWithDlqProps): this;
    monitorStepFunction(props: StepFunctionMonitoringProps): this;
    monitorStepFunctionActivity(props: StepFunctionActivityMonitoringProps): this;
    monitorStepFunctionLambdaIntegration(props: StepFunctionLambdaIntegrationMonitoringProps): this;
    monitorStepFunctionServiceIntegration(props: StepFunctionServiceIntegrationMonitoringProps): this;
    monitorS3Bucket(props: S3BucketMonitoringProps): this;
    monitorLog(props: LogMonitoringProps): this;
    monitorSyntheticsCanary(props: SyntheticsCanaryMonitoringProps): this;
    monitorWebApplicationFirewallAclV2(props: WafV2MonitoringProps): this;
    monitorBilling(props?: BillingMonitoringProps): this;
    monitorCustom(props: CustomMonitoringProps): this;
    /**
     * Monitor all the resources in the given scope.
     * @param scope
     * @param aspectProps
     * @experimental
     */
    monitorScope(scope: Construct, aspectProps?: MonitoringAspectProps): void;
}
