"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const ApiGatewayNamespace = "AWS/ApiGateway";
class ApiGatewayMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.fillTpsWithZeroes = props.fillTpsWithZeroes ?? true;
        this.rateComputationMethod =
            props.rateComputationMethod ?? common_1.RateComputationMethod.AVERAGE;
        this.dimensionsMap = {
            ApiName: props.api.restApiName,
            Stage: props.apiStage ?? "prod",
            ...(props.apiMethod && { Method: props.apiMethod }),
            ...(props.apiResource && { Resource: props.apiResource }),
        };
    }
    /**
     * @deprecated use metricInvocationRate
     */
    metricTps() {
        return this.metricFactory.toRate(this.metricInvocationCount(), common_1.RateComputationMethod.PER_SECOND, false, "requests", this.fillTpsWithZeroes);
    }
    metricInvocationRate() {
        return this.metricFactory.toRate(this.metricInvocationCount(), this.rateComputationMethod, false, "requests", this.fillTpsWithZeroes);
    }
    metricInvocationCount() {
        return this.metricFactory.createMetric("Count", common_1.MetricStatistic.SUM, "Count", this.dimensionsMap, undefined, ApiGatewayNamespace);
    }
    metric4XXErrorCount() {
        return this.metricFactory.createMetric("4XXError", common_1.MetricStatistic.SUM, "4XX Error", this.dimensionsMap, undefined, ApiGatewayNamespace);
    }
    metric4XXErrorRate() {
        const metric = this.metric4XXErrorCount();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "errors");
    }
    metric5XXFaultCount() {
        return this.metricFactory.createMetric("5XXError", common_1.MetricStatistic.SUM, "5XX Fault", this.dimensionsMap, undefined, ApiGatewayNamespace);
    }
    metric5XXFaultRate() {
        const metric = this.metric5XXFaultCount();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "faults");
    }
    /**
     * @deprecated use metricLatencyInMillis instead
     */
    metricLatencyP99InMillis() {
        return this.metricLatencyInMillis(common_1.LatencyType.P99);
    }
    /**
     * @deprecated use metricLatencyInMillis instead
     */
    metricLatencyP90InMillis() {
        return this.metricLatencyInMillis(common_1.LatencyType.P90);
    }
    /**
     * @deprecated use metricLatencyInMillis instead
     */
    metricLatencyP50InMillis() {
        return this.metricLatencyInMillis(common_1.LatencyType.P50);
    }
    metricLatencyInMillis(latencyType) {
        const label = common_1.getLatencyTypeLabel(latencyType);
        return this.metricFactory.createMetric("Latency", common_1.getLatencyTypeStatistic(latencyType), label, this.dimensionsMap, undefined, ApiGatewayNamespace);
    }
}
exports.ApiGatewayMetricFactory = ApiGatewayMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
ApiGatewayMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.ApiGatewayMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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